const cheerio = require('cheerio');
const axios = require('axios');

async function torrentGalaxy({query, category}) {
    if (category === 'Series') {
        category = 'TV';
    }
    const torrents = [];
    const url = 'https://torrentgalaxy.to/torrents.php?parent_cat=' + category + '&search=' + query + '&sort=seeders&order=desc&page=0';
    let html;
    try{
        html = await axios.get(url);
    }catch{
        return null;
    }
    const $ = cheerio.load(html.data);
    $('div.tgxtablerow.txlight').each((i, element) => {
        const torrent = {
            title: $(element).find(':nth-child(4) div a b').text(),
            url: 'https://torrentgalaxy.to' + $(element).find('a.txlight').attr('href'),
            magnet: $(element).find('.tgxtablecell.collapsehide.rounded.txlight a').next().attr('href'),
            seed: $(element).find(':nth-child(11) > span > font:nth-child(1) > b').text().replace(/\.|,/g, ''),
            leech: $(element).find(':nth-child(11) > span > font:nth-child(2) > b').text().replace(/\.|,/g, ''),
            size: $(element).find(':nth-child(8)').text()
        }
        if (torrent.size) {
            torrents.push(torrent);
        }
    });
    return {domain: url, query: query, torrents};
}

module.exports.search = torrentGalaxy;
