const Rusha = require('rusha')

let worker
let nextTaskId
let cbs

function init () {
  worker = Rusha.createWorker()
  nextTaskId = 1
  cbs = {} // taskId -> cb

  worker.onmessage = function onRushaMessage (e) {
    const taskId = e.data.id
    const cb = cbs[taskId]
    delete cbs[taskId]

    if (e.data.error != null) {
      cb(new Error('Rusha worker error: ' + e.data.error))
    } else {
      cb(null, e.data.hash)
    }
  }
}

function sha1 (buf, cb) {
  if (!worker) init()

  cbs[nextTaskId] = cb
  worker.postMessage({ id: nextTaskId, data: buf })
  nextTaskId += 1
}

module.exports = sha1
