const cheerio = require('cheerio');
const axios = require('axios');

async function nyaaSI({query, category}) {
    const torrents = [];
    const url = 'https://nyaa.si/?f=0&c=0_0&q=' + query + '&s=seeders&o=desc';
    if (category !== 'Anime') {
        return {domain: url, query: query, torrents};
    }
    let html;
    try{
        html = await axios.get(url);
    }catch{
        return null;
    }
    const $ = cheerio.load(html.data);
    $('tbody tr').each((i, element) => {
        const torrent = {
            title: $(element).find('td[colspan="2"] a').text().trim().match(/[a-zA-Z\W].+/g)[0],
            url: ('https://nyaa.si' + $(element).find('td[colspan="2"] a').attr('href')).replace(/.comments/gi, ''),
            magnet: $(element).find('.text-center a').next().attr('href'),
            seed: $(element).children('td').eq(5).text(),
            leech: $(element).children('td').eq(6).text(),
            size: $(element).children('td').eq(3).text().replace('i', '')
        }
        if (torrent.size) {
            torrents.push(torrent);
        }
    });
    return {domain: url, query: query, torrents};
}

module.exports.search = nyaaSI;
