<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# edit-json-file

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Version](https://img.shields.io/npm/v/edit-json-file.svg)](https://www.npmjs.com/package/edit-json-file) [![Downloads](https://img.shields.io/npm/dt/edit-json-file.svg)](https://www.npmjs.com/package/edit-json-file) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> Edit a json file with ease.

















## :cloud: Installation

```sh
# Using npm
npm install --save edit-json-file

# Using yarn
yarn add edit-json-file
```













## :clipboard: Example



```js
const editJsonFile = require("edit-json-file");

// If the file doesn't exist, the content will be an empty object by default.
let file = editJsonFile(`${__dirname}/foo.json`);

// Set a couple of fields
file.set("planet", "Earth");
file.set("city\\.name", "anytown");
file.set("name.first", "Johnny");
file.set("name.last", "B.");
file.set("is_student", false);
//Create or append to an array
file.append("classes", "fysics");
//You can even append objects
file.append("classes", { class: "Computer Science", where: "KULeuven" });


// Output the content
console.log(file.get());
// { planet: 'Earth',
//   city.name: 'anytown',
//   name: { first: 'Johnny', last: 'B.' },
//   is_student: false,
//   classes: [
//     'fysics',
//     {
//       'class': 'Computer Science',
//       'where': 'KULeuven'
//     }
//   ]
// }

//if you want to remove the last element from an array use pop
file.pop("classes")

// Save the data to the disk
file.save();

// Reload it from the disk
file = editJsonFile(`${__dirname}/foo.json`, {
    autosave: true
});

// Get one field
console.log(file.get("name.first"));
// => Johnny

// This will save it to disk
file.set("a.new.field.as.object", {
    hello: "world"
});

// Output the whole thing
console.log(file.toObject());
// { planet: 'Earth',
//   name: { first: 'Johnny', last: 'B.' },
//   is_student: false,
//   a: { new: { field: [Object] } } }
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `JsonEditor(path, options)`

#### Params

- **String** `path`: The path to the JSON file.
- **Object** `options`: An object containing the following fields:
 - `stringify_width` (Number): The JSON stringify indent width (default: `2`).
 - `stringify_fn` (Function): A function used by `JSON.stringify`.
 - `stringify_eol` (Boolean): Wheter to add the new line at the end of the file or not (default: `false`)
 - `ignore_dots` (Boolean): Wheter to use the path including dots or have an object structure (default: `false`)
 - `autosave` (Boolean): Save the file when setting some data in it.

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `set(path, value, options)`
Set a value in a specific path.

#### Params

- **String** `path`: The object path.
- **Anything** `value`: The value.
- **Object** `options`: The options for set-value (applied only when {ignore_dots} file option is false)

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `get(path)`
Get a value in a specific path.

#### Params

- **String** `path`:

#### Return
- **Value** The object path value.

### `unset(path)`
Remove a path from a JSON object.

#### Params

- **String** `path`: The object path.

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `append(path, value)`
Appends a value/object to a specific path.
If the path is empty it wil create a list.

#### Params

- **String** `path`: The object path.
- **Anything** `value`: The value.

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `pop(path)`
Pop an array from a specific path.

#### Params

- **String** `path`: The object path.

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `read(cb)`
Read the JSON file.

#### Params

- **Function** `cb`: An optional callback function which will turn the function into an asynchronous one.

#### Return
- **Object** The object parsed as object or an empty object by default.

### `read(The, cb)`
write
Write the JSON file.

#### Params

- **String** `The`: file content.
- **Function** `cb`: An optional callback function which will turn the function into an asynchronous one.

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `empty(cb)`
Empty the JSON file content.

#### Params

- **Function** `cb`: The callback function.

### `save(cb)`
Save the file back to disk.

#### Params

- **Function** `cb`: An optional callback function which will turn the function into an asynchronous one.

#### Return
- **JsonEditor** The `JsonEditor` instance.

### `toObject()`

#### Return
- **Object** The data object.

### `editJsonFile(path, options)`
Edit a json file.

#### Params

- **String** `path`: The path to the JSON file.
- **Object** `options`: An object containing the following fields:

#### Return
- **JsonEditor** The `JsonEditor` instance.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `@acanto/laravel-scripts`
 - `@dolittle/vanir-features`
 - `@airbnb/nimbus`
 - `@neutralinojs/neu`
 - `json-config-ts`
 - `@dolittle/vanir-cli`
 - `soft-add-dependencies`
 - `@williarts/williarts-commons`
 - `@wonderland/cli-plugin-serverless`
 - `@wonderland/cli-plugin-new`
 - `@formbird/core`
 - `admooh-cli`
 - `deploi`
 - `express-generator-typescript`
 - `live-stream-radio`
 - `sheetbase-cli`
 - `extracct`
 - `semcom`
 - `lyo`
 - `@empirica/meteor-deploy`
 - `noir-wp-cli`
 - `@johnlindquist/next-lesson`
 - `typescript-react-native-starter`
 - `create-itk-app`
 - `jollofjs`
 - `@frdl/legacy-and-deprecations-fallback`
 - `grelease`
 - `@sevta/cli`
 - `baelte-cli`
 - `plop-pack-sanity-starter`
 - `modern-project-generator`
 - `nipinit`
 - `pipe-boy`
 - `monstro`
 - `create-fw`
 - `bo-admin-starter`
 - `minitest-audits`
 - `vcommit-cli`
 - `bhc-cli`
 - `@bronzw/create-discord-js-bot`
 - `simple-rtg`
 - `fluxxo-generator`
 - `robinhood-yolo`
 - `create-next-library`
 - `bo-api-starter`
 - `fixed-minor-patch-package-json`
 - `zoral-generator`
 - `react-native-dom-expo`
 - `blazar-cli`
 - `@postlight/node-typescript-starter-kit`
 - `uiseeds`
 - `webify-generator`
 - `@fanxie/cli`
 - `@malmo/cli`
 - `@xploration-tech/xtouch`
 - `kikd`
 - `@aquestsrl/create-app-cli`
 - `menreiki`
 - `@something.technology/core`
 - `nodman-cli`
 - `create-ts-jest`
 - `@openstfoundation/openst-platform`
 - `bucket-cli`
 - `@dricup/dricup-cli`
 - `gitversion-tool`
 - `@wonderland/new`
 - `intelliter`
 - `typescript-fastify-starter`
 - `express-react-generator-typescript`
 - `@mtmeyer/create-react-figma-plugin`
 - `express-ts-app`
 - `@teamhive/angular-npm-seed`
 - `@imklau/react-app`
 - `bt-translate`
 - `@oriflame/lumos`
 - `guser`
 - `ootb-express-app`
 - `@marvinkome/create-node-app`
 - `dricup-cli`
 - `d-bot-script`
 - `@farazahmad759/dricup-crud-express`
 - `ontrac`
 - `@acanto/october-scripts`
 - `my-chakra-ui`
 - `push-notifier`
 - `cmd-assistant`
 - `mf-webpack-plugin`
 - `env-to-now-json`
 - `@dolittle/vanir-common`
 - `git-normalize`
 - `typescript-express-starter`
 - `menreiki2`
 - `kape`
 - `bloggify-tools`
 - `@perlatsp/devild`
 - `@superjs/require-auto`
 - `typescript-vue-starter`
 - `karmacv-themes`
 - `package-to-local`
 - `@j.u.p.iter/jupiter-scripts`
 - `@panfilo/express-template`
 - `@mianfrigo/express-typescript-generator`
 - `simple-etg`
 - `check-dependency-version-consistency`
 - `@quantform/cli`
 - `malmo`
 - `typescript-nest-starter`
 - `simple-webpack-starter`
 - `iffe-cli`
 - `react-sgh-scaffolding`
 - `easybackup`
 - `@allmywallets/specification`
 - `@sapling/cli`
 - `dricup`
 - `generator-brei-next`
 - `def-struct`
 - `@s-ui/changelog`
 - `@rajzik/lumos`
 - `@dolittle/webpack`
 - `cli-json-edit`
 - `@grogqli/server`
 - `@jianghe/sand-cli`
 - `@elastosfoundation/trinity-cli`
 - `returrn`
 - `gyaon-cli`
 - `@kcom/package-tools`
 - `term-of-the-day`
 - `typescript-koa-starter`
 - `project-initializer`
 - `node-rg`
 - `ss-clean-slate`
 - `gev`
 - `jad-node-ts-kit`
 - `forcemanager-cli`
 - `use-express-template`
 - `modern-node-starter`
 - `@triptyk/nfw-cli`
 - `@chakra-ui/codemod`
 - `@mkvlrn/nodeinit`
 - `crestron-angular-theme`
 - `ecochat-term`
 - `@aburkov/scripts`
 - `plop-pack-gatsby-starter`
 - `@acanto/workflow`
 - `bo-api-starter-ts`
 - `deployqb`
 - `blip-lang`
 - `create-nuxt-typescript-component`
 - `@tinyhttp/cli`
 - `next-nodecms`
 - `jollof-cli`
 - `@anyopsos/cli`
 - `mongoose-auto-api.cli`
 - `new-express-app`
 - `iffe-commit`
 - `striplet`
 - `express-generator-typescript-k8s`
 - `pkgmngrgui`
 - `dex-cli`
 - `typescript-react-starter`
 - `cucu-generator`
 - `generator-brei-app`
 - `react-easy-boilerplate`
 - `create-express-template`
 - `base-express-app-starter`
 - `@hyron/cli`
 - `deyarn`
 - `lazlodb`
 - `sisback`
 - `fix-package-versions`
 - `create-express-typescript-application`
 - `pandocuments`
 - `grafpad`
 - `axereos-hopes`
 - `kanuki-cli`
 - `@deboxsoft/plop-generator`
 - `@imklau/react-boilerplate`
 - `@colorfulcompany/create-cc-jlmf`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
