// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a distribution tenant.
func (c *Client) UpdateDistributionTenant(ctx context.Context, params *UpdateDistributionTenantInput, optFns ...func(*Options)) (*UpdateDistributionTenantOutput, error) {
	if params == nil {
		params = &UpdateDistributionTenantInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDistributionTenant", params, optFns, c.addOperationUpdateDistributionTenantMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDistributionTenantOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDistributionTenantInput struct {

	// The ID of the distribution tenant.
	//
	// This member is required.
	Id *string

	// The value of the ETag header that you received when retrieving the distribution
	// tenant to update. This value is returned in the response of the
	// GetDistributionTenant API operation.
	//
	// This member is required.
	IfMatch *string

	// The ID of the target connection group.
	ConnectionGroupId *string

	// Customizations for the distribution tenant. For each distribution tenant, you
	// can specify the geographic restrictions, and the Amazon Resource Names (ARNs)
	// for the ACM certificate and WAF web ACL. These are specific values that you can
	// override or disable from the multi-tenant distribution that was used to create
	// the distribution tenant.
	Customizations *types.Customizations

	// The ID for the multi-tenant distribution.
	DistributionId *string

	// The domains to update for the distribution tenant. A domain object can contain
	// only a domain property. You must specify at least one domain. Each distribution
	// tenant can have up to 5 domains.
	Domains []types.DomainItem

	// Indicates whether the distribution tenant should be updated to an enabled
	// state. If you update the distribution tenant and it's not enabled, the
	// distribution tenant won't serve traffic.
	Enabled *bool

	// An object that contains the CloudFront managed ACM certificate request.
	ManagedCertificateRequest *types.ManagedCertificateRequest

	// A list of parameter values to add to the resource. A parameter is specified as
	// a key-value pair. A valid parameter value must exist for any parameter that is
	// marked as required in the multi-tenant distribution.
	Parameters []types.Parameter

	noSmithyDocumentSerde
}

type UpdateDistributionTenantOutput struct {

	// The distribution tenant that you're updating.
	DistributionTenant *types.DistributionTenant

	// The current version of the distribution tenant.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDistributionTenantMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpUpdateDistributionTenant{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpUpdateDistributionTenant{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDistributionTenant"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDistributionTenantValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDistributionTenant(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDistributionTenant(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDistributionTenant",
	}
}
