#!/usr/bin/env node

"use strict";
/*
Copyright 2023 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const minimist_1 = __importDefault(require("minimist"));
const lodash_1 = __importDefault(require("lodash"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const common_1 = require("./common");
const I18NDIR = "src/i18n/strings";
const argv = (0, minimist_1.default)(process.argv.slice(2), {
    boolean: ["copy"],
});
const [oldPath, newPath] = argv._.map(common_1.getPath);
const sourceTranslations = (0, common_1.getTranslations)();
const translation = lodash_1.default.get(sourceTranslations, oldPath);
if (!translation) {
    throw new Error(`"${argv._[0]}" key not present in source translations`);
}
if (lodash_1.default.get(sourceTranslations, newPath)) {
    throw new Error(`"${argv._[1]}" key already present in source translations`);
}
function updateTranslations(translations) {
    const value = lodash_1.default.get(translations, oldPath);
    if (!value)
        return;
    lodash_1.default.set(translations, newPath, lodash_1.default.get(translations, oldPath));
    if (!argv.copy) {
        lodash_1.default.unset(translations, oldPath);
    }
}
for (const filename of fs_1.default.readdirSync(I18NDIR)) {
    if (!filename.endsWith(".json"))
        continue;
    const file = path_1.default.join(I18NDIR, filename);
    const translations = (0, common_1.getTranslations)(file);
    updateTranslations(translations);
    (0, common_1.putTranslations)(translations, file);
}
