/**
 * Returns a language string with underscores replaced with
 * hyphens, and lower-cased.
 *
 * @param {string} language The language string to be normalized
 * @returns {string} The normalized language string
 */
export declare function normalizeLanguageKey(language: string): string;
/**
 * Turns a language string, normalises it,
 * (see normalizeLanguageKey) into an array of language strings
 * with fallback to generic languages
 * (e.g. 'pt-BR' => ['pt-br', 'pt'])
 *
 * @param language The input language string
 * @return a list of normalised languages
 */
export declare function getNormalizedLanguageKeys(language: string): string[];
//# sourceMappingURL=utils.d.ts.map