"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MOBX_DEVTOOLS = exports.REDUX_DEVTOOLS = exports.VUEJS_DEVTOOLS_BETA = exports.VUEJS_DEVTOOLS = exports.JQUERY_DEBUGGER = exports.BACKBONE_DEBUGGER = exports.REACT_DEVELOPER_TOOLS = exports.EMBER_INSPECTOR = void 0;
exports.installExtension = installExtension;
const electron_1 = require("electron");
const downloadChromeExtension_1 = require("./downloadChromeExtension");
async function installExtension(extensionReference, options = {}) {
    const { forceDownload, loadExtensionOptions, session: _session } = options;
    const targetSession = _session || electron_1.session.defaultSession;
    if (process.type !== 'browser') {
        return Promise.reject(new Error('electron-devtools-installer can only be used from the main process'));
    }
    if (Array.isArray(extensionReference)) {
        return extensionReference.reduce((accum, extension) => accum.then(async (result) => {
            const inner = await installExtension(extension, options);
            return [...result, inner];
        }), Promise.resolve([]));
    }
    let chromeStoreID;
    if (typeof extensionReference === 'object' && extensionReference.id) {
        chromeStoreID = extensionReference.id;
    }
    else if (typeof extensionReference === 'string') {
        chromeStoreID = extensionReference;
    }
    else {
        throw new Error(`Invalid extensionReference passed in: "${extensionReference}"`);
    }
    const installedExtension = targetSession.getAllExtensions().find((e) => e.id === chromeStoreID);
    if (!forceDownload && installedExtension) {
        return installedExtension;
    }
    const extensionFolder = await (0, downloadChromeExtension_1.downloadChromeExtension)(chromeStoreID, {
        forceDownload: forceDownload || false,
    });
    // Use forceDownload, but already installed
    if (installedExtension === null || installedExtension === void 0 ? void 0 : installedExtension.id) {
        const unloadPromise = new Promise((resolve) => {
            const handler = (_, ext) => {
                if (ext.id === installedExtension.id) {
                    targetSession.removeListener('extension-unloaded', handler);
                    resolve();
                }
            };
            targetSession.on('extension-unloaded', handler);
        });
        targetSession.removeExtension(installedExtension.id);
        await unloadPromise;
    }
    return targetSession.loadExtension(extensionFolder, loadExtensionOptions);
}
exports.default = installExtension;
exports.EMBER_INSPECTOR = {
    id: 'bmdblncegkenkacieihfhpjfppoconhi',
};
exports.REACT_DEVELOPER_TOOLS = {
    id: 'fmkadmapgofadopljbjfkapdkoienihi',
};
exports.BACKBONE_DEBUGGER = {
    id: 'bhljhndlimiafopmmhjlgfpnnchjjbhd',
};
exports.JQUERY_DEBUGGER = {
    id: 'dbhhnnnpaeobfddmlalhnehgclcmjimi',
};
exports.VUEJS_DEVTOOLS = {
    id: 'nhdogjmejiglipccpnnnanhbledajbpd',
};
exports.VUEJS_DEVTOOLS_BETA = {
    id: 'ljjemllljcmogpfapbkkighbhhppjdbg',
};
exports.REDUX_DEVTOOLS = {
    id: 'lmhkpmbekcpmknklioeibfkpmmfibljd',
};
exports.MOBX_DEVTOOLS = {
    id: 'pfgnfdagidkfgccljigdamigbcnndkod',
};
//# sourceMappingURL=index.js.map