import { Extension, LoadExtensionOptions, Session } from 'electron';
export interface ExtensionReference {
    /**
     * Extension ID
     */
    id: string;
}
export interface InstallExtensionOptions {
    /**
     * Ignore whether the extension is already downloaded and redownload every time
     */
    forceDownload?: boolean;
    /**
     * Options passed to session.loadExtension
     */
    loadExtensionOptions?: LoadExtensionOptions;
    /**
     * Optionally specify the session to install devtools into, by default devtools
     * will be installed into the "defaultSession". See the Electron Session docs
     * for more info.
     *
     * https://electronjs.org/docs/api/session
     */
    session?: Session;
}
/**
 * @param extensionReference Extension or extensions to install
 * @param options Installation options
 * @returns A promise resolving with the name or names of the extensions installed
 */
export declare function installExtension(extensionReference: Array<ExtensionReference | string>, options?: InstallExtensionOptions): Promise<Extension[]>;
export declare function installExtension(extensionReference: ExtensionReference | string, options?: InstallExtensionOptions): Promise<Extension>;
export default installExtension;
export declare const EMBER_INSPECTOR: ExtensionReference;
export declare const REACT_DEVELOPER_TOOLS: ExtensionReference;
export declare const BACKBONE_DEBUGGER: ExtensionReference;
export declare const JQUERY_DEBUGGER: ExtensionReference;
export declare const VUEJS_DEVTOOLS: ExtensionReference;
export declare const VUEJS_DEVTOOLS_BETA: ExtensionReference;
export declare const REDUX_DEVTOOLS: ExtensionReference;
export declare const MOBX_DEVTOOLS: ExtensionReference;
