"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.downloadChromeExtension = void 0;
const fs = require("fs");
const path = require("path");
const utils_1 = require("./utils");
const unzip = require('unzip-crx-3');
const downloadChromeExtension = async (chromeStoreID, { forceDownload = false, attempts = 5, } = {}) => {
    const extensionsStore = (0, utils_1.getPath)();
    if (!fs.existsSync(extensionsStore)) {
        await fs.promises.mkdir(extensionsStore, { recursive: true });
    }
    const extensionFolder = path.resolve(`${extensionsStore}/${chromeStoreID}`);
    if (!fs.existsSync(extensionFolder) || forceDownload) {
        if (fs.existsSync(extensionFolder)) {
            await fs.promises.rmdir(extensionFolder, {
                recursive: true,
            });
        }
        const fileURL = `https://clients2.google.com/service/update2/crx?response=redirect&acceptformat=crx2,crx3&x=id%3D${chromeStoreID}%26uc&prodversion=${process.versions.chrome}`; // eslint-disable-line
        const filePath = path.resolve(`${extensionFolder}.crx`);
        try {
            await (0, utils_1.downloadFile)(fileURL, filePath);
            try {
                await unzip(filePath, extensionFolder);
                (0, utils_1.changePermissions)(extensionFolder, 755);
                return extensionFolder;
            }
            catch (err) {
                if (!fs.existsSync(path.resolve(extensionFolder, 'manifest.json'))) {
                    throw err;
                }
            }
        }
        catch (err) {
            console.error(`Failed to fetch extension, trying ${attempts - 1} more times`); // eslint-disable-line
            if (attempts <= 1) {
                throw err;
            }
            await new Promise((resolve) => setTimeout(resolve, 200));
            return await (0, exports.downloadChromeExtension)(chromeStoreID, {
                forceDownload,
                attempts: attempts - 1,
            });
        }
    }
    return extensionFolder;
};
exports.downloadChromeExtension = downloadChromeExtension;
//# sourceMappingURL=downloadChromeExtension.js.map