import { type IHttpOpts, type MatrixHttpApi } from "./http-api/index.ts";
import { type Logger } from "./logger.ts";
export interface ICapability {
    enabled: boolean;
}
export interface IChangePasswordCapability extends ICapability {
}
export interface IThreadsCapability extends ICapability {
}
export interface IGetLoginTokenCapability extends ICapability {
}
export interface ISetDisplayNameCapability extends ICapability {
}
export interface ISetAvatarUrlCapability extends ICapability {
}
export interface IProfileFieldsCapability extends ICapability {
}
export declare enum RoomVersionStability {
    Stable = "stable",
    Unstable = "unstable"
}
export interface IRoomVersionsCapability {
    default: string;
    available: Record<string, RoomVersionStability>;
}
/**
 * A representation of the capabilities advertised by a homeserver as defined by
 * [Capabilities negotiation](https://spec.matrix.org/v1.6/client-server-api/#get_matrixclientv3capabilities).
 */
export interface Capabilities {
    [key: string]: any;
    "m.change_password"?: IChangePasswordCapability;
    "m.room_versions"?: IRoomVersionsCapability;
    "io.element.thread"?: IThreadsCapability;
    "m.get_login_token"?: IGetLoginTokenCapability;
    "org.matrix.msc3882.get_login_token"?: IGetLoginTokenCapability;
    "m.set_displayname"?: ISetDisplayNameCapability;
    "m.set_avatar_url"?: ISetAvatarUrlCapability;
    "uk.tcpip.msc4133.profile_fields"?: IProfileFieldsCapability;
    /**
     * Since Matrix v1.16
     */
    "m.profile_fields"?: IProfileFieldsCapability;
}
/**
 * Manages storing and periodically refreshing the server capabilities.
 */
export declare class ServerCapabilities {
    private readonly logger;
    private readonly http;
    private capabilities?;
    private retryTimeout?;
    private refreshTimeout?;
    constructor(logger: Logger, http: MatrixHttpApi<IHttpOpts & {
        onlyData: true;
    }>);
    /**
     * Starts periodically fetching the server capabilities.
     */
    start(): void;
    /**
     * Stops the service
     */
    stop(): void;
    /**
     * Returns the cached capabilities, or undefined if none are cached.
     * @returns the current capabilities, if any.
     */
    getCachedCapabilities(): Capabilities | undefined;
    /**
     * Fetches the latest server capabilities from the homeserver and returns them, or rejects
     * on failure.
     */
    fetchCapabilities: () => Promise<Capabilities>;
    private poll;
    private clearTimeouts;
}
//# sourceMappingURL=serverCapabilities.d.ts.map