import type { InboundEncryptionSession, ParticipantId } from "./types.ts";
/**
 * Detects when a key for a given index is outdated.
 */
export declare class OutdatedKeyFilter {
    private tsBuffer;
    constructor();
    /**
     * Check if there is a recent key with the same keyId (index) and then use the creationTS to decide what to
     * do with the key. If the key received is older than the one already in the buffer, it is ignored.
     * @param participantId
     * @param item
     */
    isOutdated(participantId: ParticipantId, item: InboundEncryptionSession): boolean;
}
export declare function getParticipantId(userId: string, deviceId: string): ParticipantId;
//# sourceMappingURL=utils.d.ts.map