export declare function timeoutSignal(ms: number): AbortSignal;
export declare function anySignal(signals: AbortSignal[]): {
    signal: AbortSignal;
    cleanup(): void;
};
/**
 * Attempt to turn an HTTP error response into a Javascript Error.
 *
 * If it is a JSON response, we will parse it into a MatrixError. Otherwise
 * we return a generic Error.
 *
 * @param response - response object
 * @param body - raw body of the response
 * @returns
 */
export declare function parseErrorResponse(response: XMLHttpRequest | Response, body?: string): Error;
/**
 * Retries a network operation run in a callback.
 * @param maxAttempts - maximum attempts to try
 * @param callback - callback that returns a promise of the network operation. If rejected with ConnectionError, it will be retried by calling the callback again.
 * @returns the result of the network operation
 * @throws {@link ConnectionError} If after maxAttempts the callback still throws ConnectionError
 */
export declare function retryNetworkOperation<T>(maxAttempts: number, callback: () => Promise<T>): Promise<T>;
/**
 * Calculate the backoff time for a request retry attempt.
 * This produces wait times of 2, 4, 8, and 16 seconds (30s total) after which we give up. If the
 * failure was due to a rate limited request, the time specified in the error is returned.
 *
 * Returns -1 if the error is not retryable, or if we reach the maximum number of attempts.
 *
 * @param err - The error thrown by the http call
 * @param attempts - The number of attempts made so far, including the one that just failed.
 * @param retryConnectionError - Whether to retry on {@link ConnectionError} (CORS, connection is down, etc.)
 */
export declare function calculateRetryBackoff(err: any, attempts: number, retryConnectionError: boolean): number;
//# sourceMappingURL=utils.d.ts.map