import { type ISigned } from "../@types/signed.ts";
import { type AESEncryptedSecretStoragePayload } from "../@types/AESEncryptedSecretStoragePayload.ts";
import { type ImportRoomKeyProgressData } from "./index.ts";
export interface Curve25519AuthData {
    public_key: string;
    private_key_salt?: string;
    private_key_iterations?: number;
    private_key_bits?: number;
}
export interface Aes256AuthData {
    iv: string;
    mac: string;
    private_key_salt?: string;
    private_key_iterations?: number;
}
/**
 * Information about a server-side key backup.
 *
 * Returned by [`GET /_matrix/client/v3/room_keys/version`](https://spec.matrix.org/v1.7/client-server-api/#get_matrixclientv3room_keysversion).
 */
export interface KeyBackupInfo {
    algorithm: string;
    auth_data: ISigned & (Curve25519AuthData | Aes256AuthData);
    count?: number;
    etag?: string;
    version?: string;
}
/**
 * Information on whether a given server-side backup is trusted.
 */
export interface BackupTrustInfo {
    /**
     * Is this backup trusted?
     *
     * True if, and only if, there is a valid signature on the backup from a trusted device.
     */
    readonly trusted: boolean;
    /**
     * True if this backup matches the stored decryption key.
     */
    readonly matchesDecryptionKey: boolean;
}
/**
 * The result of {@link CryptoApi.checkKeyBackupAndEnable}.
 */
export interface KeyBackupCheck {
    backupInfo: KeyBackupInfo;
    trustInfo: BackupTrustInfo;
}
export interface Curve25519SessionData {
    ciphertext: string;
    ephemeral: string;
    mac: string;
}
export interface KeyBackupSession<T = Curve25519SessionData | AESEncryptedSecretStoragePayload> {
    first_message_index: number;
    forwarded_count: number;
    is_verified: boolean;
    session_data: T;
}
export interface KeyBackupRoomSessions {
    [sessionId: string]: KeyBackupSession;
}
/**
 * Extra parameters for {@link CryptoApi.restoreKeyBackup} and {@link CryptoApi.restoreKeyBackupWithPassphrase}.
 */
export interface KeyBackupRestoreOpts {
    /**
     * A callback which, if defined, will be called periodically to report ongoing progress of the backup restore process.
     * @param progress
     */
    progressCallback?: (progress: ImportRoomKeyProgressData) => void;
}
/**
 * The result of {@link CryptoApi.restoreKeyBackup}.
 */
export interface KeyBackupRestoreResult {
    /**
     * The total number of keys that were found in the backup.
     */
    total: number;
    /**
     * The number of keys that were imported.
     */
    imported: number;
}
//# sourceMappingURL=keybackup.d.ts.map