import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["server", "limit", "since"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
Copyright 2015-2023 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * This is an internal module. See {@link MatrixClient} for the public class.
 */

import { SyncApi, SyncState } from "./sync.js";
import { EventStatus, MatrixEvent, MatrixEventEvent } from "./models/event.js";
import { StubStore } from "./store/stub.js";
import { createNewMatrixCall, supportsMatrixCall } from "./webrtc/call.js";
import { Filter } from "./filter.js";
import { CallEventHandler } from "./webrtc/callEventHandler.js";
import { GroupCallEventHandler } from "./webrtc/groupCallEventHandler.js";
import * as utils from "./utils.js";
import { deepCompare, noUnsafeEventProps, replaceParam, safeSet, sleep } from "./utils.js";
import { Direction, EventTimeline } from "./models/event-timeline.js";
import { PushProcessor } from "./pushprocessor.js";
import { AutoDiscovery } from "./autodiscovery.js";
import { encodeUnpaddedBase64Url } from "./base64.js";
import { TypedReEmitter } from "./ReEmitter.js";
import { logger } from "./logger.js";
import { SERVICE_TYPES } from "./service-types.js";
import { ClientPrefix, IdentityPrefix, MatrixError, MatrixHttpApi, MediaPrefix, Method, retryNetworkOperation } from "./http-api/index.js";
import { User, UserEvent } from "./models/user.js";
import { getHttpUriForMxc } from "./content-repo.js";
import { SearchResult } from "./models/search-result.js";
import * as ContentHelpers from "./content-helpers.js";
import { NotificationCountType } from "./models/room.js";
import { RoomMemberEvent } from "./models/room-member.js";
import { isSendDelayedEventRequestOpts } from "./@types/requests.js";
import { EventType, LOCAL_NOTIFICATION_SETTINGS_PREFIX, MSC3912_RELATION_BASED_REDACTIONS_PROP, MsgType, PUSHER_ENABLED, RelationType, RoomCreateTypeField, RoomType, UNSTABLE_MSC3088_ENABLED, UNSTABLE_MSC3088_PURPOSE, UNSTABLE_MSC3089_TREE_SUBTYPE } from "./@types/event.js";
import { GuestAccess, HistoryVisibility, Preset } from "./@types/partials.js";
import { eventMapperFor } from "./event-mapper.js";
import { secureRandomString } from "./randomstring.js";
import { DEFAULT_TREE_POWER_LEVELS_TEMPLATE, MSC3089TreeSpace } from "./models/MSC3089TreeSpace.js";
import { SearchOrderBy } from "./@types/search.js";
import { PushRuleActionName, PushRuleKind } from "./@types/PushRules.js";
import { GroupCall } from "./webrtc/groupCall.js";
import { MediaHandler } from "./webrtc/mediaHandler.js";
import { TypedEventEmitter } from "./models/typed-event-emitter.js";
import { MAIN_ROOM_TIMELINE, ReceiptType } from "./@types/read_receipts.js";
import { SlidingSyncSdk } from "./sliding-sync-sdk.js";
import { determineFeatureSupport, FeatureSupport, Thread, THREAD_RELATION_TYPE, ThreadFilterType, threadFilterTypeToFilter } from "./models/thread.js";
import { M_BEACON_INFO } from "./@types/beacon.js";
import { NamespacedValue, UnstableValue } from "./NamespacedValue.js";
import { ToDeviceMessageQueue } from "./ToDeviceMessageQueue.js";
import { IgnoredInvites } from "./models/invites-ignorer.js";
import { buildFeatureSupportMap, Feature, ServerSupport } from "./feature.js";
import { RUST_SDK_STORE_PREFIX } from "./rust-crypto/constants.js";
import { CryptoEvent } from "./crypto-api/index.js";
import { ServerSideSecretStorageImpl } from "./secret-storage.js";
import { MatrixRTCSessionManager } from "./matrixrtc/MatrixRTCSessionManager.js";
import { getRelationsThreadFilter } from "./thread-utils.js";
import { KnownMembership } from "./@types/membership.js";
import { ServerCapabilities } from "./serverCapabilities.js";
import { sha256 } from "./digest.js";
import { discoverAndValidateOIDCIssuerWellKnown, validateAuthMetadataAndKeys } from "./oidc/index.js";
import { UnsupportedDelayedEventsEndpointError, UnsupportedStickyEventsEndpointError } from "./errors.js";
var SCROLLBACK_DELAY_MS = 3000;
var TURN_CHECK_INTERVAL = 10 * 60 * 1000; // poll for turn credentials every 10 minutes

export var UNSTABLE_MSC3852_LAST_SEEN_UA = new UnstableValue("last_seen_user_agent", "org.matrix.msc3852.last_seen_user_agent");
export var PendingEventOrdering = /*#__PURE__*/function (PendingEventOrdering) {
  PendingEventOrdering["Chronological"] = "chronological";
  PendingEventOrdering["Detached"] = "detached";
  return PendingEventOrdering;
}({});
export var GET_LOGIN_TOKEN_CAPABILITY = new NamespacedValue("m.get_login_token", "org.matrix.msc3882.get_login_token");
export var UNSTABLE_MSC2666_SHARED_ROOMS = "uk.half-shot.msc2666";
export var UNSTABLE_MSC2666_MUTUAL_ROOMS = "uk.half-shot.msc2666.mutual_rooms";
export var UNSTABLE_MSC2666_QUERY_MUTUAL_ROOMS = "uk.half-shot.msc2666.query_mutual_rooms";
export var UNSTABLE_MSC4140_DELAYED_EVENTS = "org.matrix.msc4140";
export var UNSTABLE_MSC4354_STICKY_EVENTS = "org.matrix.msc4354";
export var UNSTABLE_MSC4133_EXTENDED_PROFILES = "uk.tcpip.msc4133";
export var STABLE_MSC4133_EXTENDED_PROFILES = "uk.tcpip.msc4133.stable";
var CrossSigningKeyType = /*#__PURE__*/function (CrossSigningKeyType) {
  CrossSigningKeyType["MasterKey"] = "master_key";
  CrossSigningKeyType["SelfSigningKey"] = "self_signing_key";
  CrossSigningKeyType["UserSigningKey"] = "user_signing_key";
  return CrossSigningKeyType;
}(CrossSigningKeyType || {}); // Re-export for backwards compatibility
/**
 * The summary of a room as defined by an initial version of MSC3266 and implemented in Synapse
 * Proposed at https://github.com/matrix-org/matrix-doc/pull/3266
 */
/* eslint-enable camelcase */

// We're using this constant for methods overloading and inspect whether a variable
// contains an eventId or not. This was required to ensure backwards compatibility
// of methods for threads
// Probably not the most graceful solution but does a good enough job for now
var EVENT_ID_PREFIX = "$";
export var ClientEvent = /*#__PURE__*/function (ClientEvent) {
  /**
   * Fires whenever the SDK's syncing state is updated. The state can be one of:
   * <ul>
   *
   * <li>PREPARED: The client has synced with the server at least once and is
   * ready for methods to be called on it. This will be immediately followed by
   * a state of SYNCING. <i>This is the equivalent of "syncComplete" in the
   * previous API.</i></li>
   *
   * <li>CATCHUP: The client has detected the connection to the server might be
   * available again and will now try to do a sync again. As this sync might take
   * a long time (depending how long ago was last synced, and general server
   * performance) the client is put in this mode so the UI can reflect trying
   * to catch up with the server after losing connection.</li>
   *
   * <li>SYNCING : The client is currently polling for new events from the server.
   * This will be called <i>after</i> processing latest events from a sync.</li>
   *
   * <li>ERROR : The client has had a problem syncing with the server. If this is
   * called <i>before</i> PREPARED then there was a problem performing the initial
   * sync. If this is called <i>after</i> PREPARED then there was a problem polling
   * the server for updates. This may be called multiple times even if the state is
   * already ERROR. <i>This is the equivalent of "syncError" in the previous
   * API.</i></li>
   *
   * <li>RECONNECTING: The sync connection has dropped, but not (yet) in a way that
   * should be considered erroneous.
   * </li>
   *
   * <li>STOPPED: The client has stopped syncing with server due to stopClient
   * being called.
   * </li>
   * </ul>
   * State transition diagram:
   * ```
   *                                          +---->STOPPED
   *                                          |
   *              +----->PREPARED -------> SYNCING <--+
   *              |                        ^  |  ^    |
   *              |      CATCHUP ----------+  |  |    |
   *              |        ^                  V  |    |
   *   null ------+        |  +------- RECONNECTING   |
   *              |        V  V                       |
   *              +------->ERROR ---------------------+
   *
   * NB: 'null' will never be emitted by this event.
   *
   * ```
   * Transitions:
   * <ul>
   *
   * <li>`null -> PREPARED` : Occurs when the initial sync is completed
   * first time. This involves setting up filters and obtaining push rules.
   *
   * <li>`null -> ERROR` : Occurs when the initial sync failed first time.
   *
   * <li>`ERROR -> PREPARED` : Occurs when the initial sync succeeds
   * after previously failing.
   *
   * <li>`PREPARED -> SYNCING` : Occurs immediately after transitioning
   * to PREPARED. Starts listening for live updates rather than catching up.
   *
   * <li>`SYNCING -> RECONNECTING` : Occurs when the live update fails.
   *
   * <li>`RECONNECTING -> RECONNECTING` : Can occur if the update calls
   * continue to fail, but the keepalive calls (to /versions) succeed.
   *
   * <li>`RECONNECTING -> ERROR` : Occurs when the keepalive call also fails
   *
   * <li>`ERROR -> SYNCING` : Occurs when the client has performed a
   * live update after having previously failed.
   *
   * <li>`ERROR -> ERROR` : Occurs when the client has failed to keepalive
   * for a second time or more.</li>
   *
   * <li>`SYNCING -> SYNCING` : Occurs when the client has performed a live
   * update. This is called <i>after</i> processing.</li>
   *
   * <li>`* -> STOPPED` : Occurs once the client has stopped syncing or
   * trying to sync after stopClient has been called.</li>
   * </ul>
   *
   * The payloads consits of the following 3 parameters:
   *
   * - state - An enum representing the syncing state. One of "PREPARED",
   * "SYNCING", "ERROR", "STOPPED".
   *
   * - prevState - An enum representing the previous syncing state.
   * One of "PREPARED", "SYNCING", "ERROR", "STOPPED" <b>or null</b>.
   *
   * - data - Data about this transition.
   *
   * @example
   * ```
   * matrixClient.on("sync", function(state, prevState, data) {
   *   switch (state) {
   *     case "ERROR":
   *       // update UI to say "Connection Lost"
   *       break;
   *     case "SYNCING":
   *       // update UI to remove any "Connection Lost" message
   *       break;
   *     case "PREPARED":
   *       // the client instance is ready to be queried.
   *       var rooms = matrixClient.getRooms();
   *       break;
   *   }
   * });
   * ```
   */
  ClientEvent["Sync"] = "sync";
  /**
   * Fires whenever the SDK receives a new event.
   * <p>
   * This is only fired for live events received via /sync - it is not fired for
   * events received over context, search, or pagination APIs.
   *
   * The payload is the matrix event which caused this event to fire.
   * @example
   * ```
   * matrixClient.on("event", function(event){
   *   var sender = event.getSender();
   * });
   * ```
   */
  ClientEvent["Event"] = "event";
  /** @deprecated Use {@link ReceivedToDeviceMessage}.
   * Fires whenever the SDK receives a new to-device event.
   * The payload is the matrix event ({@link MatrixEvent}) which caused this event to fire.
   * @example
   * ```
   * matrixClient.on("toDeviceEvent", function(event){
   *   var sender = event.getSender();
   * });
   * ```
   */
  ClientEvent["ToDeviceEvent"] = "toDeviceEvent";
  /**
   * Fires whenever the SDK receives a new (potentially decrypted) to-device message.
   * The payload is the to-device message and the encryption info for that message ({@link ReceivedToDeviceMessage}).
   * @example
   * ```
   * matrixClient.on("receivedToDeviceMessage", function(payload){
   *   const { message, encryptionInfo } = payload;
   *   var claimed_sender = encryptionInfo ? encryptionInfo.sender : message.sender;
   *   var isVerified = encryptionInfo ? encryptionInfo.verified : false;
   *   var type = message.type;
   * });
   */
  ClientEvent["ReceivedToDeviceMessage"] = "receivedToDeviceMessage";
  /**
   * Fires whenever new user-scoped account_data is added.
   * The payload is a pair of event ({@link MatrixEvent}) describing the account_data just added, and the previous event, if known:
   *  - event: The event describing the account_data just added
   *  - oldEvent: The previous account data, if known.
   * @example
   * ```
   * matrixClient.on("accountData", function(event, oldEvent){
   *   myAccountData[event.type] = event.content;
   * });
   * ```
   */
  ClientEvent["AccountData"] = "accountData";
  /**
   * Fires whenever a new Room is added. This will fire when you are invited to a
   * room, as well as when you join a room. <strong>This event is experimental and
   * may change.</strong>
   *
   * The payload is the newly created room, fully populated.
   * @example
   * ```
   * matrixClient.on("Room", function(room){
   *   var roomId = room.roomId;
   * });
   * ```
   */
  ClientEvent["Room"] = "Room";
  /**
   * Fires whenever a Room is removed. This will fire when you forget a room.
   * <strong>This event is experimental and may change.</strong>
   * The payload is the roomId of the deleted room.
   * @example
   * ```
   * matrixClient.on("deleteRoom", function(roomId){
   *   // update UI from getRooms()
   * });
   * ```
   */
  ClientEvent["DeleteRoom"] = "deleteRoom";
  ClientEvent["SyncUnexpectedError"] = "sync.unexpectedError";
  /**
   * Fires when the client .well-known info is fetched.
   * The payload is the JSON object (see {@link IClientWellKnown}) returned by the server
   */
  ClientEvent["ClientWellKnown"] = "WellKnown.client";
  ClientEvent["ReceivedVoipEvent"] = "received_voip_event";
  ClientEvent["TurnServers"] = "turnServers";
  ClientEvent["TurnServersError"] = "turnServers.error";
  return ClientEvent;
}({});
var SSO_ACTION_PARAM = new UnstableValue("action", "org.matrix.msc3824.action");

/**
 * Represents a Matrix Client. Only directly construct this if you want to use
 * custom modules. Normally, {@link createClient} should be used
 * as it specifies 'sensible' defaults for these modules.
 */
export class MatrixClient extends TypedEventEmitter {
  constructor(opts) {
    var _opts$logger, _opts$usingExternalCr, _this, _opts$disableVoip, _opts$enableEncrypted, _opts$cryptoCallbacks;
    // If a custom logger is provided, use it. Otherwise, default to the global
    // one in logger.ts.
    super();
    _this = this;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "reEmitter", new TypedReEmitter(this));
    _defineProperty(this, "olmVersion", null);
    // populated after initLegacyCrypto
    _defineProperty(this, "usingExternalCrypto", false);
    _defineProperty(this, "_store", void 0);
    _defineProperty(this, "deviceId", void 0);
    _defineProperty(this, "credentials", void 0);
    /**
     * Encryption key used for encrypting sensitive data (such as e2ee keys) in storage.
     *
     * As supplied in the constructor via {@link IMatrixClientCreateOpts#pickleKey}.
     * Used for migration from the legacy crypto to the rust crypto
     */
    _defineProperty(this, "legacyPickleKey", void 0);
    _defineProperty(this, "scheduler", void 0);
    _defineProperty(this, "clientRunning", false);
    _defineProperty(this, "timelineSupport", false);
    _defineProperty(this, "urlPreviewCache", {});
    _defineProperty(this, "identityServer", void 0);
    _defineProperty(this, "http", void 0);
    // XXX: Intended private, used in code.
    _defineProperty(this, "cryptoBackend", void 0);
    // one of crypto or rustCrypto
    _defineProperty(this, "enableEncryptedStateEvents", void 0);
    _defineProperty(this, "cryptoCallbacks", void 0);
    // XXX: Intended private, used in code.
    _defineProperty(this, "callEventHandler", void 0);
    // XXX: Intended private, used in code.
    _defineProperty(this, "groupCallEventHandler", void 0);
    _defineProperty(this, "supportsCallTransfer", false);
    // XXX: Intended private, used in code.
    _defineProperty(this, "forceTURN", false);
    // XXX: Intended private, used in code.
    _defineProperty(this, "iceCandidatePoolSize", 0);
    // XXX: Intended private, used in code.
    _defineProperty(this, "idBaseUrl", void 0);
    _defineProperty(this, "baseUrl", void 0);
    _defineProperty(this, "isVoipWithNoMediaAllowed", void 0);
    _defineProperty(this, "disableVoip", void 0);
    _defineProperty(this, "useLivekitForGroupCalls", void 0);
    // Note: these are all `protected` to let downstream consumers make mistakes if they want to.
    // We don't technically support this usage, but have reasons to do this.
    _defineProperty(this, "canSupportVoip", false);
    _defineProperty(this, "peekSync", null);
    _defineProperty(this, "isGuestAccount", false);
    _defineProperty(this, "ongoingScrollbacks", {});
    _defineProperty(this, "notifTimelineSet", null);
    /**
     * Legacy crypto store used for migration from the legacy crypto to the rust crypto
     * @private
     */
    _defineProperty(this, "legacyCryptoStore", void 0);
    _defineProperty(this, "verificationMethods", void 0);
    _defineProperty(this, "fallbackICEServerAllowed", false);
    _defineProperty(this, "syncApi", void 0);
    _defineProperty(this, "roomNameGenerator", void 0);
    _defineProperty(this, "pushRules", void 0);
    _defineProperty(this, "syncLeftRoomsPromise", void 0);
    _defineProperty(this, "syncedLeftRooms", false);
    _defineProperty(this, "clientOpts", void 0);
    _defineProperty(this, "clientWellKnownIntervalID", void 0);
    _defineProperty(this, "canResetTimelineCallback", void 0);
    _defineProperty(this, "canSupport", new Map());
    // The pushprocessor caches useful things, so keep one and re-use it
    _defineProperty(this, "pushProcessor", new PushProcessor(this));
    // Promise to a response of the server's /versions response
    // TODO: This should expire: https://github.com/matrix-org/matrix-js-sdk/issues/1020
    _defineProperty(this, "serverVersionsPromise", void 0);
    _defineProperty(this, "clientWellKnown", void 0);
    _defineProperty(this, "clientWellKnownPromise", void 0);
    _defineProperty(this, "turnServers", []);
    _defineProperty(this, "turnServersExpiry", 0);
    _defineProperty(this, "checkTurnServersIntervalID", void 0);
    _defineProperty(this, "txnCtr", 0);
    _defineProperty(this, "mediaHandler", new MediaHandler(this));
    _defineProperty(this, "sessionId", void 0);
    /** IDs of events which are currently being encrypted.
     *
     * This is part of the cancellation mechanism: if the event is no longer listed here when encryption completes,
     * that tells us that it has been cancelled, and we should not send it.
     */
    _defineProperty(this, "eventsBeingEncrypted", new Set());
    _defineProperty(this, "useE2eForGroupCall", true);
    _defineProperty(this, "toDeviceMessageQueue", void 0);
    _defineProperty(this, "livekitServiceURL", void 0);
    _defineProperty(this, "_secretStorage", void 0);
    // A manager for determining which invites should be ignored.
    _defineProperty(this, "ignoredInvites", void 0);
    _defineProperty(this, "matrixRTC", void 0);
    _defineProperty(this, "serverCapabilitiesService", void 0);
    _defineProperty(this, "startCallEventHandler", () => {
      if (this.isInitialSyncComplete()) {
        if (supportsMatrixCall()) {
          this.callEventHandler.start();
          this.groupCallEventHandler.start();
        }
        this.off(ClientEvent.Sync, this.startCallEventHandler);
      }
    });
    _defineProperty(this, "startMatrixRTC", () => {
      if (this.isInitialSyncComplete()) {
        this.matrixRTC.start();
        this.off(ClientEvent.Sync, this.startMatrixRTC);
      }
    });
    /**
     * Once the client has been initialised, we want to clear notifications we
     * know for a fact should be here.
     * This issue should also be addressed on synapse's side and is tracked as part
     * of https://github.com/matrix-org/synapse/issues/14837
     *
     * We consider a room or a thread as fully read if the current user has sent
     * the last event in the live timeline of that context and if the read receipt
     * we have on record matches.
     */
    _defineProperty(this, "fixupRoomNotifications", () => {
      if (this.isInitialSyncComplete()) {
        var _this$getRooms;
        var unreadRooms = ((_this$getRooms = this.getRooms()) !== null && _this$getRooms !== void 0 ? _this$getRooms : []).filter(room => {
          return room.getUnreadNotificationCount(NotificationCountType.Total) > 0;
        });
        for (var _room of unreadRooms) {
          var currentUserId = this.getSafeUserId();
          _room.fixupNotifications(currentUserId);
        }
        this.off(ClientEvent.Sync, this.fixupRoomNotifications);
      }
    });
    this.logger = (_opts$logger = opts.logger) !== null && _opts$logger !== void 0 ? _opts$logger : logger;
    opts.baseUrl = utils.ensureNoTrailingSlash(opts.baseUrl);
    opts.idBaseUrl = utils.ensureNoTrailingSlash(opts.idBaseUrl);
    this.baseUrl = opts.baseUrl;
    this.idBaseUrl = opts.idBaseUrl;
    this.identityServer = opts.identityServer;
    this.usingExternalCrypto = (_opts$usingExternalCr = opts.usingExternalCrypto) !== null && _opts$usingExternalCr !== void 0 ? _opts$usingExternalCr : false;
    this.store = opts.store || new StubStore();
    this.deviceId = opts.deviceId || null;
    this.sessionId = secureRandomString(10);
    var userId = opts.userId || null;
    this.credentials = {
      userId
    };
    this.http = new MatrixHttpApi(this, {
      fetchFn: opts.fetchFn,
      baseUrl: opts.baseUrl,
      idBaseUrl: opts.idBaseUrl,
      accessToken: opts.accessToken,
      refreshToken: opts.refreshToken,
      tokenRefreshFunction: opts.tokenRefreshFunction,
      prefix: ClientPrefix.V3,
      onlyData: true,
      extraParams: opts.queryParams,
      localTimeoutMs: opts.localTimeoutMs,
      useAuthorizationHeader: opts.useAuthorizationHeader,
      logger: this.logger
    });
    if (opts.pickleKey) {
      this.legacyPickleKey = opts.pickleKey;
    }
    this.useLivekitForGroupCalls = Boolean(opts.useLivekitForGroupCalls);
    this.scheduler = opts.scheduler;
    if (this.scheduler) {
      this.scheduler.setProcessFunction(/*#__PURE__*/function () {
        var _ref = _asyncToGenerator(function* (eventToSend) {
          var room = _this.getRoom(eventToSend.getRoomId());
          if (eventToSend.status !== EventStatus.SENDING) {
            _this.updatePendingEventStatus(room, eventToSend, EventStatus.SENDING);
          }
          var res = yield _this.sendEventHttpRequest(eventToSend);
          if (room) {
            // ensure we update pending event before the next scheduler run so that any listeners to event id
            // updates on the synchronous event emitter get a chance to run first.
            room.updatePendingEvent(eventToSend, EventStatus.SENT, res.event_id);
          }
          return res;
        });
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
    }
    this.disableVoip = (_opts$disableVoip = opts.disableVoip) !== null && _opts$disableVoip !== void 0 ? _opts$disableVoip : false;
    if (!this.disableVoip && supportsMatrixCall()) {
      this.callEventHandler = new CallEventHandler(this);
      this.groupCallEventHandler = new GroupCallEventHandler(this);
      this.canSupportVoip = true;
      // Start listening for calls after the initial sync is done
      // We do not need to backfill the call event buffer
      // with encrypted events that might never get decrypted
      this.on(ClientEvent.Sync, this.startCallEventHandler);
    }

    // NB. We initialise MatrixRTC whether we have call support or not: this is just
    // the underlying session management and doesn't use any actual media capabilities
    this.matrixRTC = new MatrixRTCSessionManager(this.logger, this);
    this.serverCapabilitiesService = new ServerCapabilities(this.logger, this.http);
    this.on(ClientEvent.Sync, this.fixupRoomNotifications);
    this.timelineSupport = Boolean(opts.timelineSupport);
    this.legacyCryptoStore = opts.cryptoStore;
    this.verificationMethods = opts.verificationMethods;
    this.cryptoCallbacks = opts.cryptoCallbacks || {};
    this.enableEncryptedStateEvents = (_opts$enableEncrypted = opts.enableEncryptedStateEvents) !== null && _opts$enableEncrypted !== void 0 ? _opts$enableEncrypted : false;
    this.forceTURN = opts.forceTURN || false;
    this.iceCandidatePoolSize = opts.iceCandidatePoolSize === undefined ? 0 : opts.iceCandidatePoolSize;
    this.supportsCallTransfer = opts.supportsCallTransfer || false;
    this.fallbackICEServerAllowed = opts.fallbackICEServerAllowed || false;
    this.isVoipWithNoMediaAllowed = opts.isVoipWithNoMediaAllowed || false;
    if (opts.useE2eForGroupCall !== undefined) this.useE2eForGroupCall = opts.useE2eForGroupCall;
    this.livekitServiceURL = opts.livekitServiceURL;
    this.roomNameGenerator = opts.roomNameGenerator;
    this.toDeviceMessageQueue = new ToDeviceMessageQueue(this, this.logger);

    // The SDK doesn't really provide a clean way for events to recalculate the push
    // actions for themselves, so we have to kinda help them out when they are encrypted.
    // We do this so that push rules are correctly executed on events in their decrypted
    // state, such as highlights when the user's name is mentioned.
    this.on(MatrixEventEvent.Decrypted, event => {
      fixNotificationCountOnDecryption(this, event);
    });
    this.ignoredInvites = new IgnoredInvites(this);
    this._secretStorage = new ServerSideSecretStorageImpl(this, (_opts$cryptoCallbacks = opts.cryptoCallbacks) !== null && _opts$cryptoCallbacks !== void 0 ? _opts$cryptoCallbacks : {});

    // having lots of event listeners is not unusual. 0 means "unlimited".
    this.setMaxListeners(0);
  }
  set store(newStore) {
    this._store = newStore;
    this._store.setUserCreator(userId => User.createUser(userId, this));
  }
  get store() {
    return this._store;
  }

  /**
   * High level helper method to begin syncing and poll for new events. To listen for these
   * events, add a listener for {@link ClientEvent.Event}
   * via {@link MatrixClient#on}. Alternatively, listen for specific
   * state change events.
   * @param opts - Options to apply when syncing.
   */
  startClient(opts) {
    var _this2 = this;
    return _asyncToGenerator(function* () {
      if (_this2.clientRunning) {
        // client is already running.
        return;
      }
      _this2.clientRunning = true;
      _this2.on(ClientEvent.Sync, _this2.startMatrixRTC);

      // Create our own user object artificially (instead of waiting for sync)
      // so it's always available, even if the user is not in any rooms etc.
      var userId = _this2.getUserId();
      if (userId) {
        _this2.store.storeUser(new User(userId));
      }

      // periodically poll for turn servers if we support voip
      if (_this2.supportsVoip()) {
        _this2.checkTurnServersIntervalID = setInterval(() => {
          _this2.checkTurnServers();
        }, TURN_CHECK_INTERVAL);
        // noinspection ES6MissingAwait
        _this2.checkTurnServers();
      }
      if (_this2.syncApi) {
        // This shouldn't happen since we thought the client was not running
        _this2.logger.error("Still have sync object whilst not running: stopping old one");
        _this2.syncApi.stop();
      }
      try {
        yield _this2.getVersions();

        // This should be done with `canSupport`
        // TODO: https://github.com/vector-im/element-web/issues/23643
        var {
          threads,
          list,
          fwdPagination
        } = yield _this2.doesServerSupportThread();
        Thread.setServerSideSupport(threads);
        Thread.setServerSideListSupport(list);
        Thread.setServerSideFwdPaginationSupport(fwdPagination);
      } catch (e) {
        _this2.logger.error("Can't fetch server versions, continuing to initialise sync, this will be retried later", e);
      }
      _this2.clientOpts = opts !== null && opts !== void 0 ? opts : {};
      if (_this2.clientOpts.slidingSync) {
        _this2.syncApi = new SlidingSyncSdk(_this2.clientOpts.slidingSync, _this2, _this2.clientOpts, _this2.buildSyncApiOptions());
      } else {
        _this2.syncApi = new SyncApi(_this2, _this2.clientOpts, _this2.buildSyncApiOptions());
      }
      _this2.syncApi.sync().catch(e => _this2.logger.info("Sync startup aborted with an error:", e));
      if (_this2.clientOpts.clientWellKnownPollPeriod !== undefined) {
        _this2.clientWellKnownIntervalID = setInterval(() => {
          _this2.fetchClientWellKnown();
        }, 1000 * _this2.clientOpts.clientWellKnownPollPeriod);
        _this2.fetchClientWellKnown();
      }
      _this2.toDeviceMessageQueue.start();
      _this2.serverCapabilitiesService.start();
    })();
  }

  /**
   * Construct a SyncApiOptions for this client, suitable for passing into the SyncApi constructor
   */
  buildSyncApiOptions() {
    return {
      cryptoCallbacks: this.cryptoBackend,
      canResetEntireTimeline: roomId => {
        if (!this.canResetTimelineCallback) {
          return false;
        }
        return this.canResetTimelineCallback(roomId);
      },
      logger: this.logger.getChild("sync")
    };
  }

  /**
   * High level helper method to stop the client from polling and allow a
   * clean shutdown.
   */
  stopClient() {
    var _this$cryptoBackend, _this$syncApi, _this$peekSync, _this$callEventHandle, _this$groupCallEventH;
    (_this$cryptoBackend = this.cryptoBackend) === null || _this$cryptoBackend === void 0 || _this$cryptoBackend.stop(); // crypto might have been initialised even if the client wasn't fully started

    this.off(ClientEvent.Sync, this.startMatrixRTC);
    if (!this.clientRunning) return; // already stopped

    this.logger.debug("stopping MatrixClient");
    this.clientRunning = false;
    (_this$syncApi = this.syncApi) === null || _this$syncApi === void 0 || _this$syncApi.stop();
    this.syncApi = undefined;
    (_this$peekSync = this.peekSync) === null || _this$peekSync === void 0 || _this$peekSync.stopPeeking();
    (_this$callEventHandle = this.callEventHandler) === null || _this$callEventHandle === void 0 || _this$callEventHandle.stop();
    (_this$groupCallEventH = this.groupCallEventHandler) === null || _this$groupCallEventH === void 0 || _this$groupCallEventH.stop();
    this.callEventHandler = undefined;
    this.groupCallEventHandler = undefined;
    globalThis.clearInterval(this.checkTurnServersIntervalID);
    this.checkTurnServersIntervalID = undefined;
    if (this.clientWellKnownIntervalID !== undefined) {
      globalThis.clearInterval(this.clientWellKnownIntervalID);
    }
    this.toDeviceMessageQueue.stop();
    this.matrixRTC.stop();
    this.serverCapabilitiesService.stop();
  }

  /**
   * Clear any data out of the persistent stores used by the client.
   *
   * @param args.cryptoDatabasePrefix - The database name to use for indexeddb, defaults to 'matrix-js-sdk'.
   * @returns Promise which resolves when the stores have been cleared.
   */
  clearStores() {
    var _this3 = this;
    var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (this.clientRunning) {
      throw new Error("Cannot clear stores while client is running");
    }
    var promises = [];
    promises.push(this.store.deleteAllData());
    if (this.legacyCryptoStore) {
      promises.push(this.legacyCryptoStore.deleteAllData());
    }

    // delete the stores used by the rust matrix-sdk-crypto, in case they were used
    var deleteRustSdkStore = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(function* () {
        var indexedDB;
        try {
          indexedDB = globalThis.indexedDB;
          if (!indexedDB) return; // No indexedDB support
        } catch (_unused) {
          // No indexedDB support
          return;
        }
        var _loop = function* _loop(dbname) {
          var prom = new Promise((resolve, reject) => {
            _this3.logger.info("Removing IndexedDB instance ".concat(dbname));
            var req = indexedDB.deleteDatabase(dbname);
            req.onsuccess = _ => {
              _this3.logger.info("Removed IndexedDB instance ".concat(dbname));
              resolve(0);
            };
            req.onerror = e => {
              // In private browsing, Firefox has a globalThis.indexedDB, but attempts to delete an indexeddb
              // (even a non-existent one) fail with "DOMException: A mutation operation was attempted on a
              // database that did not allow mutations."
              //
              // it seems like the only thing we can really do is ignore the error.
              _this3.logger.warn("Failed to remove IndexedDB instance ".concat(dbname, ":"), e);
              resolve(0);
            };
            req.onblocked = e => {
              _this3.logger.info("cannot yet remove IndexedDB instance ".concat(dbname));
            };
          });
          yield prom;
        };
        for (var dbname of ["".concat((_args$cryptoDatabaseP = args.cryptoDatabasePrefix) !== null && _args$cryptoDatabaseP !== void 0 ? _args$cryptoDatabaseP : RUST_SDK_STORE_PREFIX, "::matrix-sdk-crypto"), "".concat((_args$cryptoDatabaseP2 = args.cryptoDatabasePrefix) !== null && _args$cryptoDatabaseP2 !== void 0 ? _args$cryptoDatabaseP2 : RUST_SDK_STORE_PREFIX, "::matrix-sdk-crypto-meta")]) {
          var _args$cryptoDatabaseP, _args$cryptoDatabaseP2;
          yield* _loop(dbname);
        }
      });
      return function deleteRustSdkStore() {
        return _ref2.apply(this, arguments);
      };
    }();
    promises.push(deleteRustSdkStore());
    return Promise.all(promises).then(); // .then to fix types
  }

  /**
   * Get the user-id of the logged-in user
   *
   * @returns MXID for the logged-in user, or null if not logged in
   */
  getUserId() {
    var _this$credentials$use, _this$credentials;
    return (_this$credentials$use = (_this$credentials = this.credentials) === null || _this$credentials === void 0 ? void 0 : _this$credentials.userId) !== null && _this$credentials$use !== void 0 ? _this$credentials$use : null;
  }

  /**
   * Get the user-id of the logged-in user
   *
   * @returns MXID for the logged-in user
   * @throws Error if not logged in
   */
  getSafeUserId() {
    var userId = this.getUserId();
    if (!userId) {
      throw new Error("Expected logged in user but found none.");
    }
    return userId;
  }

  /**
   * Get the domain for this client's MXID
   * @returns Domain of this MXID
   */
  getDomain() {
    var _this$credentials2;
    if ((_this$credentials2 = this.credentials) !== null && _this$credentials2 !== void 0 && _this$credentials2.userId) {
      return this.credentials.userId.replace(/^.*?:/, "");
    }
    return null;
  }

  /**
   * Get the local part of the current user ID e.g. "foo" in "\@foo:bar".
   * @returns The user ID localpart or null.
   */
  getUserIdLocalpart() {
    var _this$credentials$use2, _this$credentials3;
    return (_this$credentials$use2 = (_this$credentials3 = this.credentials) === null || _this$credentials3 === void 0 || (_this$credentials3 = _this$credentials3.userId) === null || _this$credentials3 === void 0 ? void 0 : _this$credentials3.split(":")[0].substring(1)) !== null && _this$credentials$use2 !== void 0 ? _this$credentials$use2 : null;
  }

  /**
   * Get the device ID of this client
   * @returns device ID
   */
  getDeviceId() {
    return this.deviceId;
  }

  /**
   * Get the session ID of this client
   * @returns session ID
   */
  getSessionId() {
    return this.sessionId;
  }

  /**
   * Check if the runtime environment supports VoIP calling.
   * @returns True if VoIP is supported.
   */
  supportsVoip() {
    return !this.disableVoip && this.canSupportVoip;
  }

  /**
   * @returns
   */
  getMediaHandler() {
    return this.mediaHandler;
  }

  /**
   * Set whether VoIP calls are forced to use only TURN
   * candidates. This is the same as the forceTURN option
   * when creating the client.
   * @param force - True to force use of TURN servers
   */
  setForceTURN(force) {
    this.forceTURN = force;
  }

  /**
   * Set whether to advertise transfer support to other parties on Matrix calls.
   * @param support - True to advertise the 'm.call.transferee' capability
   */
  setSupportsCallTransfer(support) {
    this.supportsCallTransfer = support;
  }

  /**
   * Returns true if to-device signalling for group calls will be encrypted with Olm.
   * If false, it will be sent unencrypted.
   * @returns boolean Whether group call signalling will be encrypted
   */
  getUseE2eForGroupCall() {
    return this.useE2eForGroupCall;
  }

  /**
   * Creates a new call.
   * The place*Call methods on the returned call can be used to actually place a call
   *
   * @param roomId - The room the call is to be placed in.
   * @returns the call or null if the browser doesn't support calling.
   */
  createCall(roomId) {
    return createNewMatrixCall(this, roomId);
  }

  /**
   * Creates a new group call and sends the associated state event
   * to alert other members that the room now has a group call.
   *
   * @param roomId - The room the call is to be placed in.
   */
  createGroupCall(roomId, type, isPtt, intent, dataChannelsEnabled, dataChannelOptions) {
    var _this4 = this;
    return _asyncToGenerator(function* () {
      if (_this4.getGroupCallForRoom(roomId)) {
        throw new Error("".concat(roomId, " already has an existing group call"));
      }
      var room = _this4.getRoom(roomId);
      if (!room) {
        throw new Error("Cannot find room ".concat(roomId));
      }

      // Because without Media section a WebRTC connection is not possible, so need a RTCDataChannel to set up a
      // no media WebRTC connection anyway.
      return new GroupCall(_this4, room, type, isPtt, intent, undefined, dataChannelsEnabled || _this4.isVoipWithNoMediaAllowed, dataChannelOptions, _this4.isVoipWithNoMediaAllowed, _this4.useLivekitForGroupCalls, _this4.livekitServiceURL).create();
    })();
  }
  getLivekitServiceURL() {
    return this.livekitServiceURL;
  }

  // This shouldn't need to exist, but the widget API has startup ordering problems that
  // mean it doesn't know the livekit URL fast enough: remove this once this is fixed.
  setLivekitServiceURL(newURL) {
    this.livekitServiceURL = newURL;
  }

  /**
   * Wait until an initial state for the given room has been processed by the
   * client and the client is aware of any ongoing group calls. Awaiting on
   * the promise returned by this method before calling getGroupCallForRoom()
   * avoids races where getGroupCallForRoom is called before the state for that
   * room has been processed. It does not, however, fix other races, eg. two
   * clients both creating a group call at the same time.
   * @param roomId - The room ID to wait for
   * @returns A promise that resolves once existing group calls in the room
   *          have been processed.
   */
  waitUntilRoomReadyForGroupCalls(roomId) {
    return this.groupCallEventHandler.waitUntilRoomReadyForGroupCalls(roomId);
  }

  /**
   * Get an existing group call for the provided room.
   * @returns The group call or null if it doesn't already exist.
   */
  getGroupCallForRoom(roomId) {
    return this.groupCallEventHandler.groupCalls.get(roomId) || null;
  }

  /**
   * Get the current sync state.
   * @returns the sync state, which may be null.
   * @see MatrixClient#event:"sync"
   */
  getSyncState() {
    var _this$syncApi$getSync, _this$syncApi2;
    return (_this$syncApi$getSync = (_this$syncApi2 = this.syncApi) === null || _this$syncApi2 === void 0 ? void 0 : _this$syncApi2.getSyncState()) !== null && _this$syncApi$getSync !== void 0 ? _this$syncApi$getSync : null;
  }

  /**
   * Returns the additional data object associated with
   * the current sync state, or null if there is no
   * such data.
   * Sync errors, if available, are put in the 'error' key of
   * this object.
   */
  getSyncStateData() {
    if (!this.syncApi) {
      return null;
    }
    return this.syncApi.getSyncStateData();
  }

  /**
   * Whether the initial sync has completed.
   * @returns True if at least one sync has happened.
   */
  isInitialSyncComplete() {
    var state = this.getSyncState();
    if (!state) {
      return false;
    }
    return state === SyncState.Prepared || state === SyncState.Syncing;
  }

  /**
   * Return whether the client is configured for a guest account.
   * @returns True if this is a guest access_token (or no token is supplied).
   */
  isGuest() {
    return this.isGuestAccount;
  }

  /**
   * Set whether this client is a guest account. <b>This method is experimental
   * and may change without warning.</b>
   * @param guest - True if this is a guest account.
   * @experimental if the token is a macaroon, it should be encoded in it that it is a 'guest'
   * access token, which means that the SDK can determine this entirely without
   * the dev manually flipping this flag.
   */
  setGuest(guest) {
    this.isGuestAccount = guest;
  }

  /**
   * Return the provided scheduler, if any.
   * @returns The scheduler or undefined
   */
  getScheduler() {
    return this.scheduler;
  }

  /**
   * Retry a backed off syncing request immediately. This should only be used when
   * the user <b>explicitly</b> attempts to retry their lost connection.
   * Will also retry any outbound to-device messages currently in the queue to be sent
   * (retries of regular outgoing events are handled separately, per-event).
   * @returns True if this resulted in a request being retried.
   */
  retryImmediately() {
    var _this$syncApi$retryIm, _this$syncApi3;
    // don't await for this promise: we just want to kick it off
    this.toDeviceMessageQueue.sendQueue();
    return (_this$syncApi$retryIm = (_this$syncApi3 = this.syncApi) === null || _this$syncApi3 === void 0 ? void 0 : _this$syncApi3.retryImmediately()) !== null && _this$syncApi$retryIm !== void 0 ? _this$syncApi$retryIm : false;
  }

  /**
   * Return the global notification EventTimelineSet, if any
   *
   * @returns the globl notification EventTimelineSet
   */
  getNotifTimelineSet() {
    return this.notifTimelineSet;
  }

  /**
   * Set the global notification EventTimelineSet
   *
   */
  setNotifTimelineSet(set) {
    this.notifTimelineSet = set;
  }

  /**
   * Gets the cached capabilities of the homeserver, returning cached ones if available.
   * If there are no cached capabilities and none can be fetched, throw an exception.
   *
   * @returns Promise resolving with The capabilities of the homeserver
   */
  getCapabilities() {
    var _this5 = this;
    return _asyncToGenerator(function* () {
      var caps = _this5.serverCapabilitiesService.getCachedCapabilities();
      if (caps) return caps;
      return _this5.serverCapabilitiesService.fetchCapabilities();
    })();
  }

  /**
   * Gets the cached capabilities of the homeserver. If none have been fetched yet,
   * return undefined.
   *
   * @returns The capabilities of the homeserver
   */
  getCachedCapabilities() {
    return this.serverCapabilitiesService.getCachedCapabilities();
  }

  /**
   * Fetches the latest capabilities from the homeserver, ignoring any cached
   * versions. The newly returned version is cached.
   *
   * @returns A promise which resolves to the capabilities of the homeserver
   */
  fetchCapabilities() {
    return this.serverCapabilitiesService.fetchCapabilities();
  }

  /**
   * Initialise support for end-to-end encryption in this client, using the rust matrix-sdk-crypto.
   *
   * **WARNING**: the cryptography stack is not thread-safe. Having multiple `MatrixClient` instances connected to
   * the same Indexed DB will cause data corruption and decryption failures. The application layer is responsible for
   * ensuring that only one `MatrixClient` issue is instantiated at a time.
   *
   * @param args.useIndexedDB - True to use an indexeddb store, false to use an in-memory store. Defaults to 'true'.
   * @param args.cryptoDatabasePrefix - The database name to use for indexeddb, defaults to 'matrix-js-sdk'.
   *    Unused if useIndexedDB is 'false'.
   * @param args.storageKey - A key with which to encrypt the indexeddb store. If provided, it must be exactly
   *    32 bytes of data, and must be the same each time the client is initialised for a given device.
   *    If both this and `storagePassword` are unspecified, the store will be unencrypted.
   * @param args.storagePassword - An alternative to `storageKey`. A password which will be used to derive a key to
   *    encrypt the store with. Deriving a key from a password is (deliberately) a slow operation, so prefer
   *    to pass a `storageKey` directly where possible.
   *
   * @returns a Promise which will resolve when the crypto layer has been
   *    successfully initialised.
   */
  initRustCrypto() {
    var _arguments = arguments,
      _this6 = this;
    return _asyncToGenerator(function* () {
      var _args$cryptoDatabaseP3, _this6$legacyPickleKe;
      var args = _arguments.length > 0 && _arguments[0] !== undefined ? _arguments[0] : {};
      if (_this6.cryptoBackend) {
        _this6.logger.warn("Attempt to re-initialise e2e encryption on MatrixClient");
        return;
      }
      var userId = _this6.getUserId();
      if (userId === null) {
        throw new Error("Cannot enable encryption on MatrixClient with unknown userId: " + "ensure userId is passed in createClient().");
      }
      var deviceId = _this6.getDeviceId();
      if (deviceId === null) {
        throw new Error("Cannot enable encryption on MatrixClient with unknown deviceId: " + "ensure deviceId is passed in createClient().");
      }

      // importing rust-crypto will download the webassembly, so we delay it until we know it will be
      // needed.
      _this6.logger.debug("Downloading Rust crypto library");
      var RustCrypto = yield import("./rust-crypto/index.js");
      var rustCrypto = yield RustCrypto.initRustCrypto({
        logger: _this6.logger,
        http: _this6.http,
        userId: userId,
        deviceId: deviceId,
        secretStorage: _this6.secretStorage,
        cryptoCallbacks: _this6.cryptoCallbacks,
        storePrefix: args.useIndexedDB === false ? null : (_args$cryptoDatabaseP3 = args.cryptoDatabasePrefix) !== null && _args$cryptoDatabaseP3 !== void 0 ? _args$cryptoDatabaseP3 : RUST_SDK_STORE_PREFIX,
        storeKey: args.storageKey,
        storePassphrase: args.storagePassword,
        legacyCryptoStore: _this6.legacyCryptoStore,
        legacyPickleKey: (_this6$legacyPickleKe = _this6.legacyPickleKey) !== null && _this6$legacyPickleKe !== void 0 ? _this6$legacyPickleKe : "DEFAULT_KEY",
        legacyMigrationProgressListener: (progress, total) => {
          _this6.emit(CryptoEvent.LegacyCryptoStoreMigrationProgress, progress, total);
        },
        enableEncryptedStateEvents: _this6.enableEncryptedStateEvents
      });
      rustCrypto.setSupportedVerificationMethods(_this6.verificationMethods);
      _this6.cryptoBackend = rustCrypto;

      // attach the event listeners needed by RustCrypto
      _this6.on(RoomMemberEvent.Membership, rustCrypto.onRoomMembership.bind(rustCrypto));
      _this6.on(ClientEvent.Event, event => {
        rustCrypto.onLiveEventFromSync(event);
      });

      // re-emit the events emitted by the crypto impl
      _this6.reEmitter.reEmit(rustCrypto, [CryptoEvent.VerificationRequestReceived, CryptoEvent.UserTrustStatusChanged, CryptoEvent.KeyBackupStatus, CryptoEvent.KeyBackupSessionsRemaining, CryptoEvent.KeyBackupFailed, CryptoEvent.KeyBackupDecryptionKeyCached, CryptoEvent.KeysChanged, CryptoEvent.DevicesUpdated, CryptoEvent.WillUpdateDevices, CryptoEvent.DehydratedDeviceCreated, CryptoEvent.DehydratedDeviceUploaded, CryptoEvent.RehydrationStarted, CryptoEvent.RehydrationProgress, CryptoEvent.RehydrationCompleted, CryptoEvent.RehydrationError, CryptoEvent.DehydrationKeyCached, CryptoEvent.DehydratedDeviceRotationError]);
    })();
  }

  /**
   * Access the server-side secret storage API for this client.
   */
  get secretStorage() {
    return this._secretStorage;
  }

  /**
   * Access the crypto API for this client.
   *
   * If end-to-end encryption has been enabled for this client (via {@link initRustCrypto}),
   * returns an object giving access to the crypto API. Otherwise, returns `undefined`.
   */
  getCrypto() {
    return this.cryptoBackend;
  }

  /**
   * Whether encryption is enabled for a room.
   * @param roomId - the room id to query.
   * @returns whether encryption is enabled.
   *
   * @deprecated Not correctly supported for Rust Cryptography. Use {@link CryptoApi.isEncryptionEnabledInRoom} and/or
   *    {@link Room.hasEncryptionStateEvent}.
   */
  isRoomEncrypted(roomId) {
    var room = this.getRoom(roomId);
    if (!room) {
      // we don't know about this room, so can't determine if it should be
      // encrypted. Let's assume not.
      return false;
    }

    // if there is an 'm.room.encryption' event in this room, it should be
    // encrypted (independently of whether we actually support encryption)
    return room.hasEncryptionStateEvent();
  }

  /**
   * Check whether the key backup private key is stored in secret storage.
   * @returns map of key name to key info the secret is
   *     encrypted with, or null if it is not present or not encrypted with a
   *     trusted key
   */
  isKeyBackupKeyStored() {
    return Promise.resolve(this.secretStorage.isStored("m.megolm_backup.v1"));
  }
  makeKeyBackupPath(roomId, sessionId, version) {
    var path;
    if (sessionId !== undefined) {
      path = utils.encodeUri("/room_keys/keys/$roomId/$sessionId", {
        $roomId: roomId,
        $sessionId: sessionId
      });
    } else if (roomId !== undefined) {
      path = utils.encodeUri("/room_keys/keys/$roomId", {
        $roomId: roomId
      });
    } else {
      path = "/room_keys/keys";
    }
    var queryData = version === undefined ? undefined : {
      version
    };
    return {
      path,
      queryData
    };
  }
  deleteKeysFromBackup(roomId, sessionId, version) {
    var _this7 = this;
    return _asyncToGenerator(function* () {
      var path = _this7.makeKeyBackupPath(roomId, sessionId, version);
      yield _this7.http.authedRequest(Method.Delete, path.path, path.queryData, undefined, {
        prefix: ClientPrefix.V3
      });
    })();
  }

  /**
   * Get the config for the media repository.
   *
   * @param useAuthenticatedMedia - If true, the caller supports authenticated
   * media and wants an authentication-required URL. Note that server support
   * for authenticated media will *not* be checked - it is the caller's responsibility
   * to do so before calling this function.
   *
   * @returns Promise which resolves with an object containing the config.
   */
  getMediaConfig() {
    var useAuthenticatedMedia = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    var path = useAuthenticatedMedia ? "/media/config" : "/config";
    return this.http.authedRequest(Method.Get, path, undefined, undefined, {
      prefix: useAuthenticatedMedia ? ClientPrefix.V1 : MediaPrefix.V3
    });
  }

  /**
   * Get the room for the given room ID.
   * This function will return a valid room for any room for which a Room event
   * has been emitted. Note in particular that other events, eg. RoomState.members
   * will be emitted for a room before this function will return the given room.
   * @param roomId - The room ID
   * @returns The Room or null if it doesn't exist or there is no data store.
   */
  getRoom(roomId) {
    if (!roomId) {
      return null;
    }
    return this.store.getRoom(roomId);
  }

  /**
   * Retrieve all known rooms.
   * @returns A list of rooms, or an empty list if there is no data store.
   */
  getRooms() {
    return this.store.getRooms();
  }

  /**
   * Retrieve all rooms that should be displayed to the user
   * This is essentially getRooms() with some rooms filtered out, eg. old versions
   * of rooms that have been replaced or (in future) other rooms that have been
   * marked at the protocol level as not to be displayed to the user.
   *
   * @param msc3946ProcessDynamicPredecessor - if true, look for an
   *                                           m.room.predecessor state event and
   *                                           use it if found (MSC3946).
   * @returns A list of rooms, or an empty list if there is no data store.
   */
  getVisibleRooms() {
    var msc3946ProcessDynamicPredecessor = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    var allRooms = this.store.getRooms();
    var visibleRooms = new Set(allRooms);
    for (var _room2 of visibleRooms) {
      var predecessors = this.findPredecessorRooms(_room2, true, msc3946ProcessDynamicPredecessor);
      for (var predecessor of predecessors) {
        visibleRooms.delete(predecessor);
      }
    }
    return Array.from(visibleRooms);
  }

  /**
   * Retrieve a user.
   * @param userId - The user ID to retrieve.
   * @returns A user or null if there is no data store or the user does
   * not exist.
   */
  getUser(userId) {
    return this.store.getUser(userId);
  }

  /**
   * Retrieve all known users.
   * @returns A list of users, or an empty list if there is no data store.
   */
  getUsers() {
    return this.store.getUsers();
  }

  /**
   * Set account data event for the current user, and wait for the result to be echoed over `/sync`.
   *
   * Waiting for the remote echo ensures that a subsequent call to {@link getAccountData} will return the updated
   * value.
   *
   * If called before the client is started with {@link startClient}, logs a warning and falls back to
   * {@link setAccountDataRaw}.
   *
   * Retries the request up to 5 times in the case of an {@link ConnectionError}.
   *
   * @param eventType - The event type
   * @param content - the contents object for the event
   */
  setAccountData(eventType, content) {
    var _this8 = this;
    return _asyncToGenerator(function* () {
      // If the sync loop is not running, fall back to setAccountDataRaw.
      if (!_this8.clientRunning) {
        _this8.logger.warn("Calling `setAccountData` before the client is started: `getAccountData` may return inconsistent results.");
        return yield retryNetworkOperation(5, () => _this8.setAccountDataRaw(eventType, content));
      }

      // If the account data is already correct, then we cannot expect an update over sync, and the operation
      // is, in any case, a no-op.
      //
      // NB that we rely on this operation being synchronous to avoid a race condition: there must be no `await`
      // between here and `this.addListener` below, in case we miss an update.
      var existingData = _this8.store.getAccountData(eventType);
      if (existingData && deepCompare(existingData.event.content, content)) return {};

      // Create a promise which will resolve when the update is received
      var updatedResolvers = Promise.withResolvers();
      function accountDataListener(event) {
        // Note that we cannot safely check that the content matches what we expected, because there is a race:
        //   * We set the new content
        //   * Another client sets alternative content
        //   * Then /sync returns, but only reflects the latest content.
        //
        // Of course there is room for debate over what we should actually do in that case -- a subsequent
        // `getAccountData` isn't going to return the expected value, but whose fault is that? Databases are hard.
        //
        // Anyway, what we *shouldn't* do is get stuck in a loop. I think the best we can do is check that the event
        // type matches.
        if (event.getType() === eventType) updatedResolvers.resolve();
      }
      _this8.addListener(ClientEvent.AccountData, accountDataListener);
      try {
        var result = yield retryNetworkOperation(5, () => _this8.setAccountDataRaw(eventType, content));
        yield updatedResolvers.promise;
        return result;
      } finally {
        _this8.removeListener(ClientEvent.AccountData, accountDataListener);
      }
    })();
  }

  /**
   * Set account data event for the current user, without waiting for the remote echo.
   *
   * @param eventType - The event type
   * @param content - the contents object for the event
   */
  setAccountDataRaw(eventType, content) {
    var path = utils.encodeUri("/user/$userId/account_data/$type", {
      $userId: this.credentials.userId,
      $type: eventType
    });
    return this.http.authedRequest(Method.Put, path, undefined, content);
  }

  /**
   * Get account data event of given type for the current user.
   * @param eventType - The event type
   * @returns The contents of the given account data event
   */
  getAccountData(eventType) {
    return this.store.getAccountData(eventType);
  }

  /**
   * Get account data event of given type for the current user. This variant
   * gets account data directly from the homeserver if the local store is not
   * ready, which can be useful very early in startup before the initial sync.
   * @param eventType - The event type
   * @returns Promise which resolves: The contents of the given account data event.
   * @returns Rejects: with an error response.
   */
  getAccountDataFromServer(eventType) {
    var _this9 = this;
    return _asyncToGenerator(function* () {
      if (_this9.isInitialSyncComplete()) {
        var _event = _this9.store.getAccountData(eventType);
        if (!_event) {
          return null;
        }
        // The network version below returns just the content, so this branch
        // does the same to match.
        return _event.getContent();
      }
      var path = utils.encodeUri("/user/$userId/account_data/$type", {
        $userId: _this9.credentials.userId,
        $type: eventType
      });
      try {
        return yield _this9.http.authedRequest(Method.Get, path);
      } catch (e) {
        var _data;
        if (((_data = e.data) === null || _data === void 0 ? void 0 : _data.errcode) === "M_NOT_FOUND") {
          return null;
        }
        throw e;
      }
    })();
  }
  deleteAccountData(eventType) {
    var _this0 = this;
    return _asyncToGenerator(function* () {
      var msc3391DeleteAccountDataServerSupport = _this0.canSupport.get(Feature.AccountDataDeletion);
      // if deletion is not supported overwrite with empty content
      if (msc3391DeleteAccountDataServerSupport === ServerSupport.Unsupported) {
        yield _this0.setAccountData(eventType, {});
        return;
      }
      var path = utils.encodeUri("/user/$userId/account_data/$type", {
        $userId: _this0.getSafeUserId(),
        $type: eventType
      });
      var options = msc3391DeleteAccountDataServerSupport === ServerSupport.Unstable ? {
        prefix: "/_matrix/client/unstable/org.matrix.msc3391"
      } : undefined;
      return yield _this0.http.authedRequest(Method.Delete, path, undefined, undefined, options);
    })();
  }

  /**
   * Gets the users that are ignored by this client
   * @returns The array of users that are ignored (empty if none)
   */
  getIgnoredUsers() {
    var event = this.getAccountData(EventType.IgnoredUserList);
    if (!(event !== null && event !== void 0 && event.getContent()["ignored_users"])) return [];
    return Object.keys(event.getContent()["ignored_users"]);
  }

  /**
   * Sets the users that the current user should ignore.
   * @param userIds - the user IDs to ignore
   * @returns Promise which resolves: an empty object
   * @returns Rejects: with an error response.
   */
  setIgnoredUsers(userIds) {
    var content = {
      ignored_users: {}
    };
    userIds.forEach(u => {
      content.ignored_users[u] = {};
    });
    return this.setAccountData(EventType.IgnoredUserList, content);
  }

  /**
   * Gets whether or not a specific user is being ignored by this client.
   * @param userId - the user ID to check
   * @returns true if the user is ignored, false otherwise
   */
  isUserIgnored(userId) {
    return this.getIgnoredUsers().includes(userId);
  }

  /**
   * Join a room. If you have already joined the room, this will no-op.
   * @param roomIdOrAlias - The room ID or room alias to join.
   * @param opts - Options when joining the room.
   * @returns Promise which resolves: Room object.
   * @returns Rejects: with an error response.
   */
  joinRoom(roomIdOrAlias) {
    var _arguments2 = arguments,
      _this1 = this;
    return _asyncToGenerator(function* () {
      var _roomMember$events$me, _roomMember$events$me2;
      var opts = _arguments2.length > 1 && _arguments2[1] !== undefined ? _arguments2[1] : {};
      var room = _this1.getRoom(roomIdOrAlias);
      var roomMember = room === null || room === void 0 ? void 0 : room.getMember(_this1.getSafeUserId());
      var preJoinMembership = roomMember === null || roomMember === void 0 ? void 0 : roomMember.membership;

      // If we were invited to the room, the ID of the user that sent the invite. Otherwise, `null`.
      var inviter = preJoinMembership == KnownMembership.Invite ? (_roomMember$events$me = roomMember === null || roomMember === void 0 || (_roomMember$events$me2 = roomMember.events.member) === null || _roomMember$events$me2 === void 0 ? void 0 : _roomMember$events$me2.getSender()) !== null && _roomMember$events$me !== void 0 ? _roomMember$events$me : null : null;
      _this1.logger.debug("joinRoom[".concat(roomIdOrAlias, "]: preJoinMembership=").concat(preJoinMembership, ", inviter=").concat(inviter, ", opts=").concat(JSON.stringify(opts)));
      if (preJoinMembership == KnownMembership.Join) return room;
      var signPromise = Promise.resolve();
      if (opts.inviteSignUrl) {
        var _url = new URL(opts.inviteSignUrl);
        _url.searchParams.set("mxid", _this1.credentials.userId);
        signPromise = _this1.http.requestOtherUrl(Method.Post, _url);
      }
      var queryParams = {};
      if (opts.viaServers) {
        // server_name has been deprecated in favour of via with Matrix >1.11 (MSC4156)
        // We only use the first 3 servers, to avoid URI length issues.
        queryParams.via = queryParams.server_name = opts.viaServers.slice(0, 3);
      }
      var data = {};
      var signedInviteObj = yield signPromise;
      if (signedInviteObj) {
        data.third_party_signed = signedInviteObj;
      }
      var path = utils.encodeUri("/join/$roomid", {
        $roomid: roomIdOrAlias
      });
      var res = yield _this1.http.authedRequest(Method.Post, path, queryParams, data);
      var roomId = res.room_id;
      if (opts.acceptSharedHistory && inviter && _this1.cryptoBackend) {
        yield _this1.cryptoBackend.maybeAcceptKeyBundle(roomId, inviter);
      }

      // In case we were originally given an alias, check the room cache again
      // with the resolved ID - this method is supposed to no-op if we already
      // were in the room, after all.
      var resolvedRoom = _this1.getRoom(roomId);
      if (resolvedRoom !== null && resolvedRoom !== void 0 && resolvedRoom.hasMembershipState(_this1.credentials.userId, KnownMembership.Join)) return resolvedRoom;
      var syncApi = new SyncApi(_this1, _this1.clientOpts, _this1.buildSyncApiOptions());
      return syncApi.createRoom(roomId);
    })();
  }

  /**
   * Knock a room. If you have already knocked the room, this will no-op.
   * @param roomIdOrAlias - The room ID or room alias to knock.
   * @param opts - Options when knocking the room.
   * @returns Promise which resolves: `{room_id: {string}}`
   * @returns Rejects: with an error response.
   */
  knockRoom(roomIdOrAlias) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var room = this.getRoom(roomIdOrAlias);
    if (room !== null && room !== void 0 && room.hasMembershipState(this.credentials.userId, KnownMembership.Knock)) {
      return Promise.resolve({
        room_id: room.roomId
      });
    }
    var path = utils.encodeUri("/knock/$roomIdOrAlias", {
      $roomIdOrAlias: roomIdOrAlias
    });
    var queryParams = {};
    if (opts.viaServers) {
      // We only use the first 3 servers, to avoid URI length issues.
      var viaServers = Array.isArray(opts.viaServers) ? opts.viaServers.slice(0, 3) : [opts.viaServers];
      // server_name has been deprecated in favour of via with Matrix >1.11 (MSC4156)
      queryParams.server_name = viaServers;
      queryParams.via = viaServers;
    }
    var body = {};
    if (opts.reason) {
      body.reason = opts.reason;
    }
    return this.http.authedRequest(Method.Post, path, queryParams, body);
  }

  /**
   * Resend an event. Will also retry any to-device messages waiting to be sent.
   * @param event - The event to resend.
   * @param room - Optional. The room the event is in. Will update the
   * timeline entry if provided.
   * @returns Promise which resolves: to an ISendEventResponse object
   * @returns Rejects: with an error response.
   */
  resendEvent(event, room) {
    // also kick the to-device queue to retry
    this.toDeviceMessageQueue.sendQueue();
    this.updatePendingEventStatus(room, event, EventStatus.SENDING);
    return this.encryptAndSendEvent(room, event);
  }

  /**
   * Cancel a queued or unsent event.
   *
   * @param event -   Event to cancel
   * @throws Error if the event is not in QUEUED, NOT_SENT or ENCRYPTING state
   */
  cancelPendingEvent(event) {
    if (![EventStatus.QUEUED, EventStatus.NOT_SENT, EventStatus.ENCRYPTING].includes(event.status)) {
      throw new Error("cannot cancel an event with status " + event.status);
    }

    // If the event is currently being encrypted then remove it from the pending list, to indicate that it should
    // not be sent.
    if (event.status === EventStatus.ENCRYPTING) {
      this.eventsBeingEncrypted.delete(event.getId());
    } else if (this.scheduler && event.status === EventStatus.QUEUED) {
      // tell the scheduler to forget about it, if it's queued
      this.scheduler.removeEventFromQueue(event);
    }

    // then tell the room about the change of state, which will remove it
    // from the room's list of pending events.
    var room = this.getRoom(event.getRoomId());
    this.updatePendingEventStatus(room, event, EventStatus.CANCELLED);
  }

  /**
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  setRoomName(roomId, name) {
    return this.sendStateEvent(roomId, EventType.RoomName, {
      name: name
    });
  }

  /**
   * @param roomId - The room to update the topic in.
   * @param topic - The plaintext topic. May be empty to remove the topic.
   * @param htmlTopic - Optional.
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  setRoomTopic(roomId, topic, htmlTopic) {
    var content = ContentHelpers.makeTopicContent(topic, htmlTopic);
    return this.sendStateEvent(roomId, EventType.RoomTopic, content);
  }

  /**
   * @returns Promise which resolves: to an object keyed by tagId with objects containing a numeric order field.
   * @returns Rejects: with an error response.
   */
  getRoomTags(roomId) {
    var path = utils.encodeUri("/user/$userId/rooms/$roomId/tags", {
      $userId: this.credentials.userId,
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * @param tagName - name of room tag to be set
   * @param metadata - associated with that tag to be stored
   * @returns Promise which resolves: to an empty object
   * @returns Rejects: with an error response.
   */
  setRoomTag(roomId, tagName) {
    var metadata = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var path = utils.encodeUri("/user/$userId/rooms/$roomId/tags/$tag", {
      $userId: this.credentials.userId,
      $roomId: roomId,
      $tag: tagName
    });
    return this.http.authedRequest(Method.Put, path, undefined, metadata);
  }

  /**
   * @param tagName - name of room tag to be removed
   * @returns Promise which resolves: to an empty object
   * @returns Rejects: with an error response.
   */
  deleteRoomTag(roomId, tagName) {
    var path = utils.encodeUri("/user/$userId/rooms/$roomId/tags/$tag", {
      $userId: this.credentials.userId,
      $roomId: roomId,
      $tag: tagName
    });
    return this.http.authedRequest(Method.Delete, path);
  }

  /**
   * @param eventType - event type to be set
   * @param content - event content
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  setRoomAccountData(roomId, eventType, content) {
    var path = utils.encodeUri("/user/$userId/rooms/$roomId/account_data/$type", {
      $userId: this.credentials.userId,
      $roomId: roomId,
      $type: eventType
    });
    return this.http.authedRequest(Method.Put, path, undefined, content);
  }

  /**
   * Set a power level to one or multiple users.
   * Will apply changes atop of current power level event from local state if running & synced, falling back
   * to fetching latest from the `/state/` API.
   * @param roomId - the room to update power levels in
   * @param userId - the ID of the user or users to update power levels of
   * @param powerLevel - the numeric power level to update given users to
   * @returns Promise which resolves: to an ISendEventResponse object
   * @returns Rejects: with an error response.
   */
  setPowerLevel(roomId, userId, powerLevel) {
    var _this10 = this;
    return _asyncToGenerator(function* () {
      var _content;
      var content;
      if (_this10.clientRunning && _this10.isInitialSyncComplete()) {
        var _this10$getRoom;
        content = (_this10$getRoom = _this10.getRoom(roomId)) === null || _this10$getRoom === void 0 || (_this10$getRoom = _this10$getRoom.currentState) === null || _this10$getRoom === void 0 || (_this10$getRoom = _this10$getRoom.getStateEvents(EventType.RoomPowerLevels, "")) === null || _this10$getRoom === void 0 ? void 0 : _this10$getRoom.getContent();
      }
      if (!content) {
        try {
          content = yield _this10.getStateEvent(roomId, EventType.RoomPowerLevels, "");
        } catch (e) {
          // It is possible for a Matrix room to not have a power levels event
          if (e instanceof MatrixError && e.errcode === "M_NOT_FOUND") {
            content = {};
          } else {
            throw e;
          }
        }
      }

      // take a copy of the content to ensure we don't corrupt
      // existing client state with a failed power level change
      content = utils.deepCopy(content);
      if (!((_content = content) !== null && _content !== void 0 && _content.users)) {
        content.users = {};
      }
      var users = Array.isArray(userId) ? userId : [userId];
      for (var user of users) {
        if (powerLevel == null) {
          delete content.users[user];
        } else {
          content.users[user] = powerLevel;
        }
      }
      return _this10.sendStateEvent(roomId, EventType.RoomPowerLevels, content, "");
    })();
  }

  /**
   * Create an m.beacon_info event
   * @returns
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  unstable_createLiveBeacon(roomId, beaconInfoContent) {
    var _this11 = this;
    return _asyncToGenerator(function* () {
      return _this11.unstable_setLiveBeacon(roomId, beaconInfoContent);
    })();
  }

  /**
   * Upsert a live beacon event
   * using a specific m.beacon_info.* event variable type
   * @param roomId - string
   * @returns
   */
  // eslint-disable-next-line @typescript-eslint/naming-convention
  unstable_setLiveBeacon(roomId, beaconInfoContent) {
    var _this12 = this;
    return _asyncToGenerator(function* () {
      return _this12.sendStateEvent(roomId, M_BEACON_INFO.name, beaconInfoContent, _this12.getUserId());
    })();
  }
  sendEvent(roomId, threadIdOrEventType, eventTypeOrContent, contentOrTxnId, txnIdOrVoid) {
    var threadId;
    var eventType;
    var content;
    var txnId;
    if (!(threadIdOrEventType !== null && threadIdOrEventType !== void 0 && threadIdOrEventType.startsWith(EVENT_ID_PREFIX)) && threadIdOrEventType !== null) {
      txnId = contentOrTxnId;
      content = eventTypeOrContent;
      eventType = threadIdOrEventType;
      threadId = null;
    } else {
      txnId = txnIdOrVoid;
      content = contentOrTxnId;
      eventType = eventTypeOrContent;
      threadId = threadIdOrEventType;
    }
    this.addThreadRelationIfNeeded(content, threadId, roomId);
    return this.sendCompleteEvent({
      roomId,
      threadId,
      eventObject: {
        type: eventType,
        content
      },
      txnId
    });
  }

  /**
   * If we expect that an event is part of a thread but is missing the relation
   * we need to add it manually, as well as the reply fallback
   */
  addThreadRelationIfNeeded(content, threadId, roomId) {
    var _content$mRelates_to;
    if (threadId && !((_content$mRelates_to = content["m.relates_to"]) !== null && _content$mRelates_to !== void 0 && _content$mRelates_to.rel_type)) {
      var _content$mRelates_to2, _this$getRoom;
      var isReply = !!((_content$mRelates_to2 = content["m.relates_to"]) !== null && _content$mRelates_to2 !== void 0 && _content$mRelates_to2["m.in_reply_to"]);
      content["m.relates_to"] = _objectSpread(_objectSpread({}, content["m.relates_to"]), {}, {
        rel_type: THREAD_RELATION_TYPE.name,
        event_id: threadId,
        // Set is_falling_back to true unless this is actually intended to be a reply
        is_falling_back: !isReply
      });
      var thread = (_this$getRoom = this.getRoom(roomId)) === null || _this$getRoom === void 0 ? void 0 : _this$getRoom.getThread(threadId);
      if (thread && !isReply) {
        var _thread$lastReply$get, _thread$lastReply;
        content["m.relates_to"]["m.in_reply_to"] = {
          event_id: (_thread$lastReply$get = (_thread$lastReply = thread.lastReply(ev => {
            return ev.isRelation(THREAD_RELATION_TYPE.name) && !ev.status;
          })) === null || _thread$lastReply === void 0 ? void 0 : _thread$lastReply.getId()) !== null && _thread$lastReply$get !== void 0 ? _thread$lastReply$get : threadId
        };
      }
    }
  }

  /**
   * @param eventObject - An object with the partial structure of an event, to which event_id, user_id, room_id and origin_server_ts will be added.
   * @param txnId - Optional.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */

  /**
   * Sends a delayed event (MSC4140).
   * @param eventObject - An object with the partial structure of an event, to which event_id, user_id, room_id and origin_server_ts will be added.
   * @param delayOpts - Properties of the delay for this event.
   * @param txnId - Optional.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */

  sendCompleteEvent(_ref3) {
    var {
      roomId,
      threadId,
      eventObject,
      delayOpts,
      queryDict,
      txnId
    } = _ref3;
    if (!txnId) {
      txnId = this.makeTxnId();
    }

    // We always construct a MatrixEvent when sending because the store and scheduler use them.
    // We'll extract the params back out if it turns out the client has no scheduler or store.
    var localEvent = new MatrixEvent(Object.assign(eventObject, {
      event_id: "~" + roomId + ":" + txnId,
      user_id: this.credentials.userId,
      sender: this.credentials.userId,
      room_id: roomId,
      origin_server_ts: new Date().getTime()
    }));
    var room = this.getRoom(roomId);
    var thread = threadId ? room === null || room === void 0 ? void 0 : room.getThread(threadId) : undefined;
    if (thread) {
      localEvent.setThread(thread);
    }
    if (!delayOpts) {
      // set up re-emitter for this new event - this is normally the job of EventMapper but we don't use it here
      this.reEmitter.reEmit(localEvent, [MatrixEventEvent.Replaced, MatrixEventEvent.VisibilityChange]);
      room === null || room === void 0 || room.reEmitter.reEmit(localEvent, [MatrixEventEvent.BeforeRedaction]);
    }

    // if this is a relation or redaction of an event
    // that hasn't been sent yet (e.g. with a local id starting with a ~)
    // then listen for the remote echo of that event so that by the time
    // this event does get sent, we have the correct event_id
    var targetId = localEvent.getAssociatedId();
    if (targetId !== null && targetId !== void 0 && targetId.startsWith("~")) {
      var target = room === null || room === void 0 ? void 0 : room.getPendingEvents().find(e => e.getId() === targetId);
      target === null || target === void 0 || target.once(MatrixEventEvent.LocalEventIdReplaced, () => {
        localEvent.updateAssociatedId(target.getId());
      });
    }
    var type = localEvent.getType();
    this.logger.debug("sendEvent of type ".concat(type, " in ").concat(roomId, " with txnId ").concat(txnId).concat(delayOpts ? " (delayed event)" : "").concat(queryDict ? " query params: " + JSON.stringify(queryDict) : ""));
    localEvent.setTxnId(txnId);
    localEvent.setStatus(EventStatus.SENDING);

    // TODO: separate store for delayed events?
    if (!delayOpts) {
      // add this event immediately to the local store as 'sending'.
      room === null || room === void 0 || room.addPendingEvent(localEvent, txnId);

      // addPendingEvent can change the state to NOT_SENT if it believes
      // that there's other events that have failed. We won't bother to
      // try sending the event if the state has changed as such.
      if (localEvent.status === EventStatus.NOT_SENT) {
        return Promise.reject(new Error("Event blocked by other events not yet sent"));
      }
      return this.encryptAndSendEvent(room, localEvent, queryDict);
    } else {
      return this.encryptAndSendEvent(room, localEvent, delayOpts, queryDict);
    }
  }

  /**
   * encrypts the event if necessary; adds the event to the queue, or sends it; marks the event as sent/unsent
   * @returns returns a promise which resolves with the result of the send request
   */

  /**
   * Simply sends a delayed event without encrypting it.
   * TODO: Allow encrypted delayed events, and encrypt them properly
   * @param delayOpts - Properties of the delay for this event.
   * @returns returns a promise which resolves with the result of the delayed send request
   */

  encryptAndSendEvent(room, event, delayOptsOrQuery, queryDict) {
    var _this13 = this;
    return _asyncToGenerator(function* () {
      var queryOpts = queryDict;
      if (delayOptsOrQuery && isSendDelayedEventRequestOpts(delayOptsOrQuery)) {
        return _this13.sendEventHttpRequest(event, delayOptsOrQuery, queryOpts);
      } else if (!queryOpts) {
        queryOpts = delayOptsOrQuery;
      }
      try {
        var cancelled;
        _this13.eventsBeingEncrypted.add(event.getId());
        try {
          yield _this13.encryptEventIfNeeded(event, room !== null && room !== void 0 ? room : undefined);
        } finally {
          cancelled = !_this13.eventsBeingEncrypted.delete(event.getId());
        }
        if (cancelled) {
          // cancelled via MatrixClient::cancelPendingEvent
          return {};
        }

        // encryptEventIfNeeded may have updated the status from SENDING to ENCRYPTING. If so, we need
        // to put it back.
        if (event.status === EventStatus.ENCRYPTING) {
          _this13.updatePendingEventStatus(room, event, EventStatus.SENDING);
        }
        var promise = null;
        if (_this13.scheduler) {
          // if this returns a promise then the scheduler has control now and will
          // resolve/reject when it is done. Internally, the scheduler will invoke
          // processFn which is set to this._sendEventHttpRequest so the same code
          // path is executed regardless.
          promise = _this13.scheduler.queueEvent(event);
          if (promise && _this13.scheduler.getQueueForEvent(event).length > 1) {
            // event is processed FIFO so if the length is 2 or more we know
            // this event is stuck behind an earlier event.
            _this13.updatePendingEventStatus(room, event, EventStatus.QUEUED);
          }
        }
        if (!promise) {
          promise = _this13.sendEventHttpRequest(event, queryOpts);
          if (room) {
            promise = promise.then(res => {
              room.updatePendingEvent(event, EventStatus.SENT, res["event_id"]);
              return res;
            });
          }
        }
        return yield promise;
      } catch (err) {
        _this13.logger.error("Error sending event", err);
        try {
          // set the error on the event before we update the status:
          // updating the status emits the event, so the state should be
          // consistent at that point.
          event.error = err;
          _this13.updatePendingEventStatus(room, event, EventStatus.NOT_SENT);
        } catch (e) {
          _this13.logger.error("Exception in error handler!", e);
        }
        if (err instanceof MatrixError) {
          err.event = event;
        }
        throw err;
      }
    })();
  }
  encryptEventIfNeeded(event, room) {
    var _this14 = this;
    return _asyncToGenerator(function* () {
      // If the room is unknown, we cannot encrypt for it
      if (!room) return;
      if (!(yield _this14.shouldEncryptEventForRoom(event, room))) return;
      if (!_this14.cryptoBackend && _this14.usingExternalCrypto) {
        // The client has opted to allow sending messages to encrypted
        // rooms even if the room is encrypted, and we haven't set up
        // crypto. This is useful for users of matrix-org/pantalaimon
        return;
      }
      if (!_this14.cryptoBackend) {
        throw new Error("This room is configured to use encryption, but your client does not support encryption.");
      }
      _this14.updatePendingEventStatus(room, event, EventStatus.ENCRYPTING);
      yield _this14.cryptoBackend.encryptEvent(event, room);
    })();
  }

  /**
   * Determine whether a given event should be encrypted when we send it to the given room.
   *
   * This takes into account event type and room configuration.
   */
  shouldEncryptEventForRoom(event, room) {
    var _this15 = this;
    return _asyncToGenerator(function* () {
      var _this15$cryptoBackend;
      if (event.isEncrypted()) {
        // this event has already been encrypted; this happens if the
        // encryption step succeeded, but the send step failed on the first
        // attempt.
        return false;
      }
      if (event.getType() === EventType.Reaction) {
        // For reactions, there is a very little gained by encrypting the entire
        // event, as relation data is already kept in the clear. Event
        // encryption for a reaction effectively only obscures the event type,
        // but the purpose is still obvious from the relation data, so nothing
        // is really gained. It also causes quite a few problems, such as:
        //   * triggers notifications via default push rules
        //   * prevents server-side bundling for reactions
        // The reaction key / content / emoji value does warrant encrypting, but
        // this will be handled separately by encrypting just this value.
        // See https://github.com/matrix-org/matrix-doc/pull/1849#pullrequestreview-248763642
        return false;
      }
      if (event.isRedaction()) {
        // Redactions do not support encryption in the spec at this time.
        // Whilst it mostly worked in some clients, it wasn't compliant.
        return false;
      }

      // If the room has an m.room.encryption event, we should encrypt.
      if (room.hasEncryptionStateEvent()) return true;

      // If we have a crypto impl, and *it* thinks we should encrypt, then we should.
      if (yield (_this15$cryptoBackend = _this15.cryptoBackend) === null || _this15$cryptoBackend === void 0 ? void 0 : _this15$cryptoBackend.isEncryptionEnabledInRoom(room.roomId)) return true;

      // Otherwise, no need to encrypt.
      return false;
    })();
  }

  /**
   * Returns the eventType that should be used taking encryption into account
   * for a given eventType.
   * @param roomId - the room for the events `eventType` relates to
   * @param eventType - the event type
   * @returns the event type taking encryption into account
   */
  getEncryptedIfNeededEventType(roomId, eventType) {
    var _this$getRoom2;
    if (eventType === EventType.Reaction) return eventType;
    return (_this$getRoom2 = this.getRoom(roomId)) !== null && _this$getRoom2 !== void 0 && _this$getRoom2.hasEncryptionStateEvent() ? EventType.RoomMessageEncrypted : eventType;
  }
  updatePendingEventStatus(room, event, newStatus) {
    if (room) {
      room.updatePendingEvent(event, newStatus);
    } else {
      event.setStatus(newStatus);
    }
  }
  sendEventHttpRequest(event, queryOrDelayOpts, queryDict) {
    var txnId = event.getTxnId();
    if (!txnId) {
      txnId = this.makeTxnId();
      event.setTxnId(txnId);
    }
    var pathParams = {
      $roomId: event.getRoomId(),
      $eventType: event.getWireType(),
      $stateKey: event.getStateKey(),
      $txnId: txnId
    };
    var path;
    if (event.isState()) {
      var pathTemplate = "/rooms/$roomId/state/$eventType";
      if (event.getStateKey() && event.getStateKey().length > 0) {
        pathTemplate = "/rooms/$roomId/state/$eventType/$stateKey";
      }
      path = utils.encodeUri(pathTemplate, pathParams);
    } else if (event.isRedaction() && event.event.redacts) {
      var _pathTemplate = "/rooms/$roomId/redact/$redactsEventId/$txnId";
      path = utils.encodeUri(_pathTemplate, _objectSpread({
        $redactsEventId: event.event.redacts
      }, pathParams));
    } else {
      path = utils.encodeUri("/rooms/$roomId/send/$eventType/$txnId", pathParams);
    }
    var delayOpts = queryOrDelayOpts && isSendDelayedEventRequestOpts(queryOrDelayOpts) ? queryOrDelayOpts : undefined;
    var queryOpts = !delayOpts ? queryOrDelayOpts : queryDict;
    var content = event.getWireContent();
    if (delayOpts) {
      return this.http.authedRequest(Method.Put, path, _objectSpread(_objectSpread({}, getUnstableDelayQueryOpts(delayOpts)), queryOpts), content);
    } else {
      return this.http.authedRequest(Method.Put, path, queryOpts, content).then(res => {
        this.logger.debug("Event sent to ".concat(event.getRoomId(), " with event id ").concat(res.event_id));
        return res;
      });
    }
  }

  /**
   * @param txnId -  transaction id. One will be made up if not supplied.
   * @param opts - Redact options
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   * @throws Error if called with `with_rel_types` (MSC3912) but the server does not support it.
   *         Callers should check whether the server supports MSC3912 via `MatrixClient.canSupport`.
   */

  redactEvent(roomId, threadId, eventId, txnId, opts) {
    var _eventId, _opts, _opts2;
    if (!((_eventId = eventId) !== null && _eventId !== void 0 && _eventId.startsWith(EVENT_ID_PREFIX))) {
      opts = txnId;
      txnId = eventId;
      eventId = threadId;
      threadId = null;
    }
    var reason = (_opts = opts) === null || _opts === void 0 ? void 0 : _opts.reason;
    var content = {
      reason
    };
    if (((_opts2 = opts) === null || _opts2 === void 0 ? void 0 : _opts2.with_rel_types) !== undefined) {
      if (this.canSupport.get(Feature.RelationBasedRedactions) === ServerSupport.Unsupported) {
        throw new Error("Server does not support relation based redactions " + "roomId ".concat(roomId, " eventId ").concat(eventId, " txnId: ").concat(txnId, " threadId ").concat(threadId));
      }
      var withRelTypesPropName = this.canSupport.get(Feature.RelationBasedRedactions) === ServerSupport.Stable ? MSC3912_RELATION_BASED_REDACTIONS_PROP.stable : MSC3912_RELATION_BASED_REDACTIONS_PROP.unstable;
      content[withRelTypesPropName] = opts.with_rel_types;
    }
    return this.sendCompleteEvent({
      roomId,
      threadId,
      eventObject: {
        type: EventType.RoomRedaction,
        content,
        redacts: eventId
      },
      txnId: txnId
    });
  }

  /**
   * @param txnId - Optional.
   * @returns Promise which resolves: to an ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendMessage(roomId, threadId, content, txnId) {
    if (typeof threadId !== "string" && threadId !== null) {
      txnId = content;
      content = threadId;
      threadId = null;
    }
    var eventType = EventType.RoomMessage;
    var sendContent = content;
    return this.sendEvent(roomId, threadId, eventType, sendContent, txnId);
  }

  /**
   * @param txnId - Optional.
   * @returns
   * @returns Rejects: with an error response.
   */

  sendTextMessage(roomId, threadId, body, txnId) {
    var _threadId;
    if (!((_threadId = threadId) !== null && _threadId !== void 0 && _threadId.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      txnId = body;
      body = threadId;
      threadId = null;
    }
    var content = ContentHelpers.makeTextMessage(body);
    return this.sendMessage(roomId, threadId, content, txnId);
  }

  /**
   * @param txnId - Optional.
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendNotice(roomId, threadId, body, txnId) {
    var _threadId2;
    if (!((_threadId2 = threadId) !== null && _threadId2 !== void 0 && _threadId2.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      txnId = body;
      body = threadId;
      threadId = null;
    }
    var content = ContentHelpers.makeNotice(body);
    return this.sendMessage(roomId, threadId, content, txnId);
  }

  /**
   * @param txnId - Optional.
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendEmoteMessage(roomId, threadId, body, txnId) {
    var _threadId3;
    if (!((_threadId3 = threadId) !== null && _threadId3 !== void 0 && _threadId3.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      txnId = body;
      body = threadId;
      threadId = null;
    }
    var content = ContentHelpers.makeEmoteMessage(body);
    return this.sendMessage(roomId, threadId, content, txnId);
  }

  /**
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendImageMessage(roomId, threadId, url, info) {
    var _threadId4;
    var text = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : "Image";
    if (!((_threadId4 = threadId) !== null && _threadId4 !== void 0 && _threadId4.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      text = info || "Image";
      info = url;
      url = threadId;
      threadId = null;
    }
    var content = {
      msgtype: MsgType.Image,
      url: url,
      info: info,
      body: text
    };
    return this.sendMessage(roomId, threadId, content);
  }

  /**
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendStickerMessage(roomId, threadId, url, info) {
    var _threadId5;
    var text = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : "Sticker";
    if (!((_threadId5 = threadId) !== null && _threadId5 !== void 0 && _threadId5.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      text = info || "Sticker";
      info = url;
      url = threadId;
      threadId = null;
    }
    var content = {
      url: url,
      info: info,
      body: text
    };
    return this.sendEvent(roomId, threadId, EventType.Sticker, content);
  }

  /**
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendHtmlMessage(roomId, threadId, body, htmlBody) {
    var _threadId6;
    if (!((_threadId6 = threadId) !== null && _threadId6 !== void 0 && _threadId6.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      htmlBody = body;
      body = threadId;
      threadId = null;
    }
    var content = ContentHelpers.makeHtmlMessage(body, htmlBody);
    return this.sendMessage(roomId, threadId, content);
  }

  /**
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendHtmlNotice(roomId, threadId, body, htmlBody) {
    var _threadId7;
    if (!((_threadId7 = threadId) !== null && _threadId7 !== void 0 && _threadId7.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      htmlBody = body;
      body = threadId;
      threadId = null;
    }
    var content = ContentHelpers.makeHtmlNotice(body, htmlBody);
    return this.sendMessage(roomId, threadId, content);
  }

  /**
   * @returns Promise which resolves: to a ISendEventResponse object
   * @returns Rejects: with an error response.
   */

  sendHtmlEmote(roomId, threadId, body, htmlBody) {
    var _threadId8;
    if (!((_threadId8 = threadId) !== null && _threadId8 !== void 0 && _threadId8.startsWith(EVENT_ID_PREFIX)) && threadId !== null) {
      htmlBody = body;
      body = threadId;
      threadId = null;
    }
    var content = ContentHelpers.makeHtmlEmote(body, htmlBody);
    return this.sendMessage(roomId, threadId, content);
  }

  /**
   * Send a delayed timeline event.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC4140](https://github.com/matrix-org/matrix-spec-proposals/pull/4140) for more details.
   */
  // eslint-disable-next-line
  _unstable_sendDelayedEvent(roomId, delayOpts, threadId, eventType, content, txnId) {
    var _this16 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this16.doesServerSupportUnstableFeature(UNSTABLE_MSC4140_DELAYED_EVENTS))) {
        throw new UnsupportedDelayedEventsEndpointError("Server does not support the delayed events API", "sendDelayedEvent");
      }
      _this16.addThreadRelationIfNeeded(content, threadId, roomId);
      return _this16.sendCompleteEvent({
        roomId,
        threadId,
        eventObject: {
          type: eventType,
          content
        },
        delayOpts,
        txnId
      });
    })();
  }

  /**
   * Send a delayed sticky timeline event.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC4140](https://github.com/matrix-org/matrix-spec-proposals/pull/4140) and
   *   [MSC4354](https://github.com/matrix-org/matrix-spec-proposals/pull/4354) for more details.
   */
  // eslint-disable-next-line
  _unstable_sendStickyDelayedEvent(roomId, stickDuration, delayOpts, threadId, eventType, content, txnId) {
    var _this17 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this17.doesServerSupportUnstableFeature(UNSTABLE_MSC4140_DELAYED_EVENTS))) {
        throw new UnsupportedDelayedEventsEndpointError("Server does not support the delayed events API", "getDelayedEvents");
      }
      if (!(yield _this17.doesServerSupportUnstableFeature(UNSTABLE_MSC4354_STICKY_EVENTS))) {
        throw new UnsupportedStickyEventsEndpointError("Server does not support the sticky events", "sendStickyEvent");
      }
      _this17.addThreadRelationIfNeeded(content, threadId, roomId);
      return _this17.sendCompleteEvent({
        roomId,
        threadId,
        eventObject: {
          type: eventType,
          content
        },
        queryDict: {
          "org.matrix.msc4354.sticky_duration_ms": stickDuration
        },
        delayOpts,
        txnId
      });
    })();
  }

  /**
   * Send a delayed state event.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC4140](https://github.com/matrix-org/matrix-spec-proposals/pull/4140) for more details.
   */
  // eslint-disable-next-line
  _unstable_sendDelayedStateEvent(roomId, delayOpts, eventType, content) {
    var _arguments3 = arguments,
      _this18 = this;
    return _asyncToGenerator(function* () {
      var stateKey = _arguments3.length > 4 && _arguments3[4] !== undefined ? _arguments3[4] : "";
      var opts = _arguments3.length > 5 && _arguments3[5] !== undefined ? _arguments3[5] : {};
      if (!(yield _this18.doesServerSupportUnstableFeature(UNSTABLE_MSC4140_DELAYED_EVENTS))) {
        throw new UnsupportedDelayedEventsEndpointError("Server does not support the delayed events API", "sendDelayedStateEvent");
      }
      var pathParams = {
        $roomId: roomId,
        $eventType: eventType,
        $stateKey: stateKey
      };
      var path = utils.encodeUri("/rooms/$roomId/state/$eventType", pathParams);
      if (stateKey !== undefined) {
        path = utils.encodeUri(path + "/$stateKey", pathParams);
      }
      return _this18.http.authedRequest(Method.Put, path, getUnstableDelayQueryOpts(delayOpts), content, opts);
    })();
  }

  /**
   * Send a sticky timeline event.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC4354](https://github.com/matrix-org/matrix-spec-proposals/pull/4354) for more details.
   */
  // eslint-disable-next-line
  _unstable_sendStickyEvent(roomId, stickDuration, threadId, eventType, content, txnId) {
    var _this19 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this19.doesServerSupportUnstableFeature(UNSTABLE_MSC4354_STICKY_EVENTS))) {
        throw new UnsupportedStickyEventsEndpointError("Server does not support the sticky events", "sendStickyEvent");
      }
      _this19.addThreadRelationIfNeeded(content, threadId, roomId);
      return _this19.sendCompleteEvent({
        roomId,
        threadId,
        eventObject: {
          type: eventType,
          content
        },
        queryDict: {
          "org.matrix.msc4354.sticky_duration_ms": stickDuration
        },
        txnId
      });
    })();
  }

  /**
   * Get all pending delayed events for the calling user.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC4140](https://github.com/matrix-org/matrix-spec-proposals/pull/4140) for more details.
   */
  // eslint-disable-next-line
  _unstable_getDelayedEvents(fromToken) {
    var _this20 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this20.doesServerSupportUnstableFeature(UNSTABLE_MSC4140_DELAYED_EVENTS))) {
        throw new UnsupportedDelayedEventsEndpointError("Server does not support the delayed events API", "getDelayedEvents");
      }
      var queryDict = fromToken ? {
        from: fromToken
      } : undefined;
      return yield _this20.http.authedRequest(Method.Get, "/delayed_events", queryDict, undefined, {
        prefix: "".concat(ClientPrefix.Unstable, "/").concat(UNSTABLE_MSC4140_DELAYED_EVENTS)
      });
    })();
  }

  /**
   * Manage a delayed event associated with the given delay_id.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC4140](https://github.com/matrix-org/matrix-spec-proposals/pull/4140) for more details.
   */
  // eslint-disable-next-line
  _unstable_updateDelayedEvent(delayId, action) {
    var _arguments4 = arguments,
      _this21 = this;
    return _asyncToGenerator(function* () {
      var requestOptions = _arguments4.length > 2 && _arguments4[2] !== undefined ? _arguments4[2] : {};
      if (!(yield _this21.doesServerSupportUnstableFeature(UNSTABLE_MSC4140_DELAYED_EVENTS))) {
        throw new UnsupportedDelayedEventsEndpointError("Server does not support the delayed events API", "updateDelayedEvent");
      }
      var path = utils.encodeUri("/delayed_events/$delayId", {
        $delayId: delayId
      });
      var data = {
        action
      };
      return yield _this21.http.authedRequest(Method.Post, path, undefined, data, _objectSpread(_objectSpread({}, requestOptions), {}, {
        prefix: "".concat(ClientPrefix.Unstable, "/").concat(UNSTABLE_MSC4140_DELAYED_EVENTS)
      }));
    })();
  }

  /**
   * Send a receipt.
   * @param event - The event being acknowledged
   * @param receiptType - The kind of receipt e.g. "m.read". Other than
   * ReceiptType.Read are experimental!
   * @param body - Additional content to send alongside the receipt.
   * @param unthreaded - An unthreaded receipt will clear room+thread notifications
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  sendReceipt(event, receiptType, body) {
    var _arguments5 = arguments,
      _this22 = this;
    return _asyncToGenerator(function* () {
      var unthreaded = _arguments5.length > 3 && _arguments5[3] !== undefined ? _arguments5[3] : false;
      if (_this22.isGuest()) {
        return Promise.resolve({}); // guests cannot send receipts so don't bother.
      }
      var path = utils.encodeUri("/rooms/$roomId/receipt/$receiptType/$eventId", {
        $roomId: event.getRoomId(),
        $receiptType: receiptType,
        $eventId: event.getId()
      });

      // Unless we're explicitly making an unthreaded receipt or we don't
      // support threads, include the `thread_id` property in the body.
      var shouldAddThreadId = !unthreaded && _this22.supportsThreads();
      var fullBody = shouldAddThreadId ? _objectSpread(_objectSpread({}, body), {}, {
        thread_id: threadIdForReceipt(event)
      }) : body;
      var promise = _this22.http.authedRequest(Method.Post, path, undefined, fullBody || {});
      var room = _this22.getRoom(event.getRoomId());
      if (room && _this22.credentials.userId) {
        room.addLocalEchoReceipt(_this22.credentials.userId, event, receiptType, unthreaded);
      }
      return promise;
    })();
  }

  /**
   * Send a read receipt.
   * @param event - The event that has been read.
   * @param receiptType - other than ReceiptType.Read are experimental! Optional.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  sendReadReceipt(event) {
    var _arguments6 = arguments,
      _this23 = this;
    return _asyncToGenerator(function* () {
      var receiptType = _arguments6.length > 1 && _arguments6[1] !== undefined ? _arguments6[1] : ReceiptType.Read;
      var unthreaded = _arguments6.length > 2 && _arguments6[2] !== undefined ? _arguments6[2] : false;
      if (!event) return;
      var eventId = event.getId();
      var room = _this23.getRoom(event.getRoomId());
      if (room !== null && room !== void 0 && room.hasPendingEvent(eventId)) {
        throw new Error("Cannot set read receipt to a pending event (".concat(eventId, ")"));
      }
      return _this23.sendReceipt(event, receiptType, {}, unthreaded);
    })();
  }

  /**
   * Set a marker to indicate the point in a room before which the user has read every
   * event. This can be retrieved from room account data (the event type is `m.fully_read`)
   * and displayed as a horizontal line in the timeline that is visually distinct to the
   * position of the user's own read receipt.
   * @param roomId - ID of the room that has been read
   * @param rmEventId - ID of the event that has been read
   * @param rrEvent - the event tracked by the read receipt. This is here for
   * convenience because the RR and the RM are commonly updated at the same time as each
   * other. The local echo of this receipt will be done if set. Optional.
   * @param rpEvent - the m.read.private read receipt event for when we don't
   * want other users to see the read receipts. This is experimental. Optional.
   * @returns Promise which resolves: the empty object, `{}`.
   */
  setRoomReadMarkers(roomId, rmEventId, rrEvent, rpEvent) {
    var _this24 = this;
    return _asyncToGenerator(function* () {
      var room = _this24.getRoom(roomId);
      if (room !== null && room !== void 0 && room.hasPendingEvent(rmEventId)) {
        throw new Error("Cannot set read marker to a pending event (".concat(rmEventId, ")"));
      }

      // Add the optional RR update, do local echo like `sendReceipt`
      var rrEventId;
      if (rrEvent) {
        rrEventId = rrEvent.getId();
        if (room !== null && room !== void 0 && room.hasPendingEvent(rrEventId)) {
          throw new Error("Cannot set read receipt to a pending event (".concat(rrEventId, ")"));
        }
        room === null || room === void 0 || room.addLocalEchoReceipt(_this24.credentials.userId, rrEvent, ReceiptType.Read);
      }

      // Add the optional private RR update, do local echo like `sendReceipt`
      var rpEventId;
      if (rpEvent) {
        rpEventId = rpEvent.getId();
        if (room !== null && room !== void 0 && room.hasPendingEvent(rpEventId)) {
          throw new Error("Cannot set read receipt to a pending event (".concat(rpEventId, ")"));
        }
        room === null || room === void 0 || room.addLocalEchoReceipt(_this24.credentials.userId, rpEvent, ReceiptType.ReadPrivate);
      }
      return yield _this24.setRoomReadMarkersHttpRequest(roomId, rmEventId, rrEventId, rpEventId);
    })();
  }
  sendRtcDecline(roomId, notificationEventId) {
    return this.sendEvent(roomId, EventType.RTCDecline, {
      "m.relates_to": {
        event_id: notificationEventId,
        rel_type: RelationType.Reference
      }
    });
  }

  /**
   * Get a preview of the given URL as of (roughly) the given point in time,
   * described as an object with OpenGraph keys and associated values.
   * Attributes may be synthesized where actual OG metadata is lacking.
   * Caches results to prevent hammering the server.
   * @param url - The URL to get preview data for
   * @param ts - The preferred point in time that the preview should
   * describe (ms since epoch).  The preview returned will either be the most
   * recent one preceding this timestamp if available, or failing that the next
   * most recent available preview.
   * @returns Promise which resolves: Object of OG metadata.
   * @returns Rejects: with an error response.
   * May return synthesized attributes if the URL lacked OG meta.
   */
  getUrlPreview(url, ts) {
    // bucket the timestamp to the nearest minute to prevent excessive spam to the server
    // Surely 60-second accuracy is enough for anyone.
    ts = Math.floor(ts / 60000) * 60000;
    var parsed = new URL(url);
    parsed.hash = ""; // strip the hash as it won't affect the preview
    url = parsed.toString();
    var key = ts + "_" + url;

    // If there's already a request in flight (or we've handled it), return that instead.
    if (key in this.urlPreviewCache) {
      return this.urlPreviewCache[key];
    }
    var resp = this.http.authedRequest(Method.Get, "/preview_url", {
      url,
      ts: ts.toString()
    }, undefined, {
      prefix: MediaPrefix.V3,
      priority: "low"
    });
    // TODO: Expire the URL preview cache sometimes
    this.urlPreviewCache[key] = resp;
    return resp;
  }

  /**
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  sendTyping(roomId, isTyping, timeoutMs) {
    if (this.isGuest()) {
      return Promise.resolve({}); // guests cannot send typing notifications so don't bother.
    }
    var path = utils.encodeUri("/rooms/$roomId/typing/$userId", {
      $roomId: roomId,
      $userId: this.getUserId()
    });
    var data = {
      typing: isTyping
    };
    if (isTyping) {
      data.timeout = timeoutMs ? timeoutMs : 20000;
    }
    return this.http.authedRequest(Method.Put, path, undefined, data);
  }

  /**
   * Determines the history of room upgrades for a given room, as far as the
   * client can see. Returns an array of Rooms where the first entry is the
   * oldest and the last entry is the newest (likely current) room. If the
   * provided room is not found, this returns an empty list. This works in
   * both directions, looking for older and newer rooms of the given room.
   * @param roomId - The room ID to search from
   * @param verifyLinks - If true, the function will only return rooms
   * which can be proven to be linked. For example, rooms which have a create
   * event pointing to an old room which the client is not aware of or doesn't
   * have a matching tombstone would not be returned.
   * @param msc3946ProcessDynamicPredecessor - if true, look for
   * m.room.predecessor state events as well as create events, and prefer
   * predecessor events where they exist (MSC3946).
   * @returns An array of rooms representing the upgrade
   * history.
   */
  getRoomUpgradeHistory(roomId) {
    var verifyLinks = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var msc3946ProcessDynamicPredecessor = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var currentRoom = this.getRoom(roomId);
    if (!currentRoom) return [];
    var before = this.findPredecessorRooms(currentRoom, verifyLinks, msc3946ProcessDynamicPredecessor);
    var after = this.findSuccessorRooms(currentRoom, verifyLinks, msc3946ProcessDynamicPredecessor);
    return [...before, currentRoom, ...after];
  }
  findPredecessorRooms(room, verifyLinks, msc3946ProcessDynamicPredecessor) {
    var _room$findPredecessor;
    var ret = [];
    var seenRoomIDs = new Set([room.roomId]);

    // Work backwards from newer to older rooms
    var predecessorRoomId = (_room$findPredecessor = room.findPredecessor(msc3946ProcessDynamicPredecessor)) === null || _room$findPredecessor === void 0 ? void 0 : _room$findPredecessor.roomId;
    while (predecessorRoomId !== null) {
      var _room$findPredecessor2;
      if (predecessorRoomId) {
        if (seenRoomIDs.has(predecessorRoomId)) break;
        seenRoomIDs.add(predecessorRoomId);
      }
      var predecessorRoom = this.getRoom(predecessorRoomId);
      if (predecessorRoom === null) {
        break;
      }
      if (verifyLinks) {
        var tombstone = predecessorRoom.currentState.getStateEvents(EventType.RoomTombstone, "");
        if (!tombstone || tombstone.getContent()["replacement_room"] !== room.roomId) {
          break;
        }
      }

      // Insert at the front because we're working backwards from the currentRoom
      ret.splice(0, 0, predecessorRoom);
      room = predecessorRoom;
      predecessorRoomId = (_room$findPredecessor2 = room.findPredecessor(msc3946ProcessDynamicPredecessor)) === null || _room$findPredecessor2 === void 0 ? void 0 : _room$findPredecessor2.roomId;
    }
    return ret;
  }
  findSuccessorRooms(room, verifyLinks, msc3946ProcessDynamicPredecessor) {
    var ret = [];

    // Work forwards, looking at tombstone events
    var tombstoneEvent = room.currentState.getStateEvents(EventType.RoomTombstone, "");
    while (tombstoneEvent) {
      var successorRoom = this.getRoom(tombstoneEvent.getContent()["replacement_room"]);
      if (!successorRoom) break; // end of the chain
      if (successorRoom.roomId === room.roomId) break; // Tombstone is referencing its own room

      if (verifyLinks) {
        var _successorRoom$findPr;
        var predecessorRoomId = (_successorRoom$findPr = successorRoom.findPredecessor(msc3946ProcessDynamicPredecessor)) === null || _successorRoom$findPr === void 0 ? void 0 : _successorRoom$findPr.roomId;
        if (!predecessorRoomId || predecessorRoomId !== room.roomId) {
          break;
        }
      }

      // Push to the end because we're looking forwards
      ret.push(successorRoom);
      var roomIds = new Set(ret.map(ref => ref.roomId));
      if (roomIds.size < ret.length) {
        // The last room added to the list introduced a previous roomId
        // To avoid recursion, return the last rooms - 1
        return ret.slice(0, ret.length - 1);
      }

      // Set the current room to the reference room so we know where we're at
      room = successorRoom;
      tombstoneEvent = room.currentState.getStateEvents(EventType.RoomTombstone, "");
    }
    return ret;
  }

  /**
   * Send an invite to the given user to join the given room.
   *
   * @param roomId - The ID of the room to which the user should be invited.
   * @param userId - The ID of the user that should be invited.
   * @param opts - Optional reason object. For backwards compatibility, a string is also accepted, and will be interpreted as a reason.
   *
   * @returns An empty object.
   */
  invite(roomId, userId) {
    var _arguments7 = arguments,
      _this25 = this;
    return _asyncToGenerator(function* () {
      var opts = _arguments7.length > 2 && _arguments7[2] !== undefined ? _arguments7[2] : {};
      if (typeof opts != "object") {
        opts = {
          reason: opts
        };
      }
      if (opts.shareEncryptedHistory) {
        var _this25$cryptoBackend;
        yield (_this25$cryptoBackend = _this25.cryptoBackend) === null || _this25$cryptoBackend === void 0 ? void 0 : _this25$cryptoBackend.shareRoomHistoryWithUser(roomId, userId);
      }
      return yield _this25.membershipChange(roomId, userId, KnownMembership.Invite, opts.reason);
    })();
  }

  /**
   * Invite a user to a room based on their email address.
   * @param roomId - The room to invite the user to.
   * @param email - The email address to invite.
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  inviteByEmail(roomId, email) {
    return this.inviteByThreePid(roomId, "email", email);
  }

  /**
   * Invite a user to a room based on a third-party identifier.
   * @param roomId - The room to invite the user to.
   * @param medium - The medium to invite the user e.g. "email".
   * @param address - The address for the specified medium.
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  inviteByThreePid(roomId, medium, address) {
    var _this26 = this;
    return _asyncToGenerator(function* () {
      var _this26$identityServe;
      var path = utils.encodeUri("/rooms/$roomId/invite", {
        $roomId: roomId
      });
      var identityServerUrl = _this26.getIdentityServerUrl(true);
      if (!identityServerUrl) {
        return Promise.reject(new MatrixError({
          error: "No supplied identity server URL",
          errcode: "ORG.MATRIX.JSSDK_MISSING_PARAM"
        }));
      }
      var params = {
        id_server: identityServerUrl,
        medium: medium,
        address: address
      };
      if ((_this26$identityServe = _this26.identityServer) !== null && _this26$identityServe !== void 0 && _this26$identityServe.getAccessToken) {
        var identityAccessToken = yield _this26.identityServer.getAccessToken();
        if (identityAccessToken) {
          params["id_access_token"] = identityAccessToken;
        }
      }
      return _this26.http.authedRequest(Method.Post, path, undefined, params);
    })();
  }

  /**
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  leave(roomId) {
    return this.membershipChange(roomId, undefined, KnownMembership.Leave);
  }

  /**
   * Leaves all rooms in the chain of room upgrades based on the given room. By
   * default, this will leave all the previous and upgraded rooms, including the
   * given room. To only leave the given room and any previous rooms, keeping the
   * upgraded (modern) rooms untouched supply `false` to `includeFuture`.
   * @param roomId - The room ID to start leaving at
   * @param includeFuture - If true, the whole chain (past and future) of
   * upgraded rooms will be left.
   * @returns Promise which resolves when completed with an object keyed
   * by room ID and value of the error encountered when leaving or null.
   */
  leaveRoomChain(roomId) {
    var includeFuture = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var upgradeHistory = this.getRoomUpgradeHistory(roomId, true);
    var eligibleToLeave = upgradeHistory;
    if (!includeFuture) {
      eligibleToLeave = [];
      for (var _room3 of upgradeHistory) {
        eligibleToLeave.push(_room3);
        if (_room3.roomId === roomId) {
          break;
        }
      }
    }
    var populationResults = {};
    var promises = [];
    var doLeave = roomId => {
      return this.leave(roomId).then(() => {
        delete populationResults[roomId];
      }).catch(err => {
        // suppress error
        populationResults[roomId] = err;
      });
    };
    for (var _room4 of eligibleToLeave) {
      promises.push(doLeave(_room4.roomId));
    }
    return Promise.all(promises).then(() => populationResults);
  }

  /**
   * @param reason - Optional.
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  ban(roomId, userId, reason) {
    return this.membershipChange(roomId, userId, KnownMembership.Ban, reason);
  }

  /**
   * @param deleteRoom - True to delete the room from the store on success.
   * Default: true.
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  forget(roomId) {
    var _arguments8 = arguments,
      _this27 = this;
    return _asyncToGenerator(function* () {
      var deleteRoom = _arguments8.length > 1 && _arguments8[1] !== undefined ? _arguments8[1] : true;
      // API returns an empty object
      var path = utils.encodeUri("/rooms/$room_id/forget", {
        $room_id: roomId
      });
      var response = yield _this27.http.authedRequest(Method.Post, path);
      if (deleteRoom) {
        _this27.store.removeRoom(roomId);
        _this27.emit(ClientEvent.DeleteRoom, roomId);
      }
      return response;
    })();
  }

  /**
   * @returns Promise which resolves: Object (currently empty)
   * @returns Rejects: with an error response.
   */
  unban(roomId, userId) {
    // unbanning != set their state to leave: this used to be
    // the case, but was then changed so that leaving was always
    // a revoking of privilege, otherwise two people racing to
    // kick / ban someone could end up banning and then un-banning
    // them.
    var path = utils.encodeUri("/rooms/$roomId/unban", {
      $roomId: roomId
    });
    var data = {
      user_id: userId
    };
    return this.http.authedRequest(Method.Post, path, undefined, data);
  }

  /**
   * @param reason - Optional.
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  kick(roomId, userId, reason) {
    var path = utils.encodeUri("/rooms/$roomId/kick", {
      $roomId: roomId
    });
    var data = {
      user_id: userId,
      reason: reason
    };
    return this.http.authedRequest(Method.Post, path, undefined, data);
  }
  membershipChange(roomId, userId, membership, reason) {
    // API returns an empty object
    var path = utils.encodeUri("/rooms/$room_id/$membership", {
      $room_id: roomId,
      $membership: membership
    });
    return this.http.authedRequest(Method.Post, path, undefined, {
      user_id: userId,
      // may be undefined e.g. on leave
      reason: reason
    });
  }

  /**
   * Obtain a dict of actions which should be performed for this event according
   * to the push rules for this user.  Caches the dict on the event.
   * @param event - The event to get push actions for.
   * @param forceRecalculate - forces to recalculate actions for an event
   * Useful when an event just got decrypted
   * @returns A dict of actions to perform.
   */
  getPushActionsForEvent(event) {
    var forceRecalculate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (!event.getPushActions() || forceRecalculate) {
      var {
        actions,
        rule
      } = this.pushProcessor.actionsAndRuleForEvent(event);
      event.setPushDetails(actions, rule);
    }
    return event.getPushActions();
  }

  /**
   * Obtain a dict of actions which should be performed for this event according
   * to the push rules for this user.  Caches the dict on the event.
   * @param event - The event to get push actions for.
   * @param forceRecalculate - forces to recalculate actions for an event
   * Useful when an event just got decrypted
   * @returns A dict of actions to perform.
   */
  getPushDetailsForEvent(event) {
    var forceRecalculate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (!event.getPushDetails() || forceRecalculate) {
      var {
        actions,
        rule
      } = this.pushProcessor.actionsAndRuleForEvent(event);
      event.setPushDetails(actions, rule);
    }
    return event.getPushDetails();
  }

  /**
   * @param info - The kind of info to set (e.g. 'avatar_url')
   * @param data - The JSON object to set.
   * @returns
   * @returns Rejects: with an error response.
   */
  // eslint-disable-next-line camelcase

  setProfileInfo(info, data) {
    var path = utils.encodeUri("/profile/$userId/$info", {
      $userId: this.credentials.userId,
      $info: info
    });
    return this.http.authedRequest(Method.Put, path, undefined, data);
  }

  /**
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  setDisplayName(name) {
    var _this28 = this;
    return _asyncToGenerator(function* () {
      var prom = yield _this28.setProfileInfo("displayname", {
        displayname: name
      });
      // XXX: synthesise a profile update for ourselves because Synapse is broken and won't
      var user = _this28.getUser(_this28.getUserId());
      if (user) {
        user.displayName = name;
        user.emit(UserEvent.DisplayName, user.events.presence, user);
      }
      return prom;
    })();
  }

  /**
   * @returns Promise which resolves: `{}` an empty object.
   * @returns Rejects: with an error response.
   */
  setAvatarUrl(url) {
    var _this29 = this;
    return _asyncToGenerator(function* () {
      var prom = yield _this29.setProfileInfo("avatar_url", {
        avatar_url: url
      });
      // XXX: synthesise a profile update for ourselves because Synapse is broken and won't
      var user = _this29.getUser(_this29.getUserId());
      if (user) {
        user.avatarUrl = url;
        user.emit(UserEvent.AvatarUrl, user.events.presence, user);
      }
      return prom;
    })();
  }

  /**
   * Turn an MXC URL into an HTTP one. <strong>This method is experimental and
   * may change.</strong>
   * @param mxcUrl - The MXC URL
   * @param width - The desired width of the thumbnail.
   * @param height - The desired height of the thumbnail.
   * @param resizeMethod - The thumbnail resize method to use, either
   * "crop" or "scale".
   * @param allowDirectLinks - If true, return any non-mxc URLs
   * directly. Fetching such URLs will leak information about the user to
   * anyone they share a room with. If false, will return null for such URLs.
   * @param allowRedirects - If true, the caller supports the URL being 307 or
   * 308 redirected to another resource upon request. If false, redirects
   * are not expected. Implied `true` when `useAuthentication` is `true`.
   * @param useAuthentication - If true, the caller supports authenticated
   * media and wants an authentication-required URL. Note that server support
   * for authenticated media will *not* be checked - it is the caller's responsibility
   * to do so before calling this function. Note also that `useAuthentication`
   * implies `allowRedirects`. Defaults to false (unauthenticated endpoints).
   * @returns the avatar URL or null.
   */
  mxcUrlToHttp(mxcUrl, width, height, resizeMethod, allowDirectLinks, allowRedirects, useAuthentication) {
    return getHttpUriForMxc(this.baseUrl, mxcUrl, width, height, resizeMethod, allowDirectLinks, allowRedirects, useAuthentication);
  }

  /**
   * Specify the set_presence value to be used for subsequent calls to the Sync API.
   * This has an advantage over calls to the PUT /presence API in that it
   * doesn't clobber status_msg set by other devices.
   * @param presence - the presence to specify to set_presence of sync calls
   */
  setSyncPresence(presence) {
    var _this30 = this;
    return _asyncToGenerator(function* () {
      var _this30$syncApi;
      (_this30$syncApi = _this30.syncApi) === null || _this30$syncApi === void 0 || _this30$syncApi.setPresence(presence);
    })();
  }

  /**
   * @param opts - Options to apply
   * @returns Promise which resolves
   * @returns Rejects: with an error response.
   * @throws If 'presence' isn't a valid presence enum value.
   */
  setPresence(opts) {
    var _this31 = this;
    return _asyncToGenerator(function* () {
      var path = utils.encodeUri("/presence/$userId/status", {
        $userId: _this31.credentials.userId
      });
      var validStates = ["offline", "online", "unavailable"];
      if (validStates.indexOf(opts.presence) === -1) {
        throw new Error("Bad presence value: " + opts.presence);
      }
      yield _this31.http.authedRequest(Method.Put, path, undefined, opts);
    })();
  }

  /**
   * @param userId - The user to get presence for
   * @returns Promise which resolves: The presence state for this user.
   * @returns Rejects: with an error response.
   */
  getPresence(userId) {
    var path = utils.encodeUri("/presence/$userId/status", {
      $userId: userId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Retrieve older messages from the given room and put them in the timeline.
   *
   * If this is called multiple times whilst a request is ongoing, the <i>same</i>
   * Promise will be returned. If there was a problem requesting scrollback, there
   * will be a small delay before another request can be made (to prevent tight-looping
   * when there is no connection).
   *
   * @param room - The room to get older messages in.
   * @param limit - Optional. The maximum number of previous events to
   * pull in. Default: 30.
   * @returns Promise which resolves: Room. If you are at the beginning
   * of the timeline, `Room.oldState.paginationToken` will be
   * `null`.
   * @returns Rejects: with an error response.
   */
  scrollback(room) {
    var limit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 30;
    var timeToWaitMs = 0;
    var info = this.ongoingScrollbacks[room.roomId] || {};
    if (info.promise) {
      return info.promise;
    } else if (info.errorTs) {
      var timeWaitedMs = Date.now() - info.errorTs;
      timeToWaitMs = Math.max(SCROLLBACK_DELAY_MS - timeWaitedMs, 0);
    }
    if (room.oldState.paginationToken === null) {
      return Promise.resolve(room); // already at the start.
    }
    // attempt to grab more events from the store first
    var numAdded = this.store.scrollback(room, limit).length;
    if (numAdded === limit) {
      // store contained everything we needed.
      return Promise.resolve(room);
    }
    // reduce the required number of events appropriately
    limit = limit - numAdded;
    var promise = new Promise((resolve, reject) => {
      // wait for a time before doing this request
      // (which may be 0 in order not to special case the code paths)
      sleep(timeToWaitMs).then(() => {
        return this.createMessagesRequest(room.roomId, room.oldState.paginationToken, limit, Direction.Backward);
      }).then(res => {
        var _res$end, _res$end2;
        var matrixEvents = res.chunk.map(this.getEventMapper());
        if (res.state) {
          var stateEvents = res.state.map(this.getEventMapper());
          room.currentState.setUnknownStateEvents(stateEvents);
        }
        var [timelineEvents, threadedEvents, unknownRelations] = room.partitionThreadedEvents(matrixEvents);
        this.processAggregatedTimelineEvents(room, timelineEvents);
        room.addEventsToTimeline(timelineEvents, true, true, room.getLiveTimeline());
        this.processThreadEvents(room, threadedEvents, true);
        unknownRelations.forEach(event => room.relations.aggregateChildEvent(event));
        room.oldState.paginationToken = (_res$end = res.end) !== null && _res$end !== void 0 ? _res$end : null;
        if (res.chunk.length === 0) {
          room.oldState.paginationToken = null;
        }
        this.store.storeEvents(room, matrixEvents, (_res$end2 = res.end) !== null && _res$end2 !== void 0 ? _res$end2 : null, true);
        delete this.ongoingScrollbacks[room.roomId];
        resolve(room);
      }).catch(err => {
        this.ongoingScrollbacks[room.roomId] = {
          errorTs: Date.now()
        };
        reject(err);
      });
    });
    info = {
      promise
    };
    this.ongoingScrollbacks[room.roomId] = info;
    return promise;
  }
  getEventMapper(options) {
    return eventMapperFor(this, options || {});
  }

  /**
   * Get an EventTimeline for the given event
   *
   * <p>If the EventTimelineSet object already has the given event in its store, the
   * corresponding timeline will be returned. Otherwise, a /context request is
   * made, and used to construct an EventTimeline.
   * If the event does not belong to this EventTimelineSet then undefined will be returned.
   *
   * @param timelineSet -  The timelineSet to look for the event in, must be bound to a room
   * @param eventId -  The ID of the event to look for
   *
   * @returns Promise which resolves:
   *    {@link EventTimeline} including the given event
   */
  getEventTimeline(timelineSet, eventId) {
    var _this32 = this;
    return _asyncToGenerator(function* () {
      var _this32$clientOpts, _ref4, _timelineSet$getTimel, _timelineSet$room$fin;
      // don't allow any timeline support unless it's been enabled.
      if (!_this32.timelineSupport) {
        throw new Error("timeline support is disabled. Set the 'timelineSupport'" + " parameter to true when creating MatrixClient to enable it.");
      }
      if (!(timelineSet !== null && timelineSet !== void 0 && timelineSet.room)) {
        throw new Error("getEventTimeline only supports room timelines");
      }
      if (timelineSet.getTimelineForEvent(eventId)) {
        return timelineSet.getTimelineForEvent(eventId);
      }
      if (timelineSet.thread && _this32.supportsThreads()) {
        return _this32.getThreadTimeline(timelineSet, eventId);
      }
      var path = utils.encodeUri("/rooms/$roomId/context/$eventId", {
        $roomId: timelineSet.room.roomId,
        $eventId: eventId
      });
      var params = undefined;
      if ((_this32$clientOpts = _this32.clientOpts) !== null && _this32$clientOpts !== void 0 && _this32$clientOpts.lazyLoadMembers) {
        params = {
          filter: JSON.stringify(Filter.LAZY_LOADING_MESSAGES_FILTER)
        };
      }

      // TODO: we should implement a backoff (as per scrollback()) to deal more nicely with HTTP errors.
      var res = yield _this32.http.authedRequest(Method.Get, path, params);
      if (!res.event) {
        throw new Error("'event' not in '/context' result - homeserver too old?");
      }

      // by the time the request completes, the event might have ended up in the timeline.
      if (timelineSet.getTimelineForEvent(eventId)) {
        return timelineSet.getTimelineForEvent(eventId);
      }
      var mapper = _this32.getEventMapper();
      var event = mapper(res.event);
      if (event.isRelation(THREAD_RELATION_TYPE.name)) {
        _this32.logger.warn("Tried loading a regular timeline at the position of a thread event");
        return undefined;
      }
      var events = [
      // Order events from most recent to oldest (reverse-chronological).
      // We start with the last event, since that's the point at which we have known state.
      // events_after is already backwards; events_before is forwards.
      ...res.events_after.reverse().map(mapper), event, ...res.events_before.map(mapper)];

      // Here we handle non-thread timelines only, but still process any thread events to populate thread summaries.
      var timeline = timelineSet.getTimelineForEvent(events[0].getId());
      if (timeline) {
        timeline.getState(EventTimeline.BACKWARDS).setUnknownStateEvents(res.state.map(mapper));
      } else {
        timeline = timelineSet.addTimeline();
        timeline.initialiseState(res.state.map(mapper));
        timeline.getState(EventTimeline.FORWARDS).paginationToken = res.end;
      }
      var [timelineEvents, threadedEvents, unknownRelations] = timelineSet.room.partitionThreadedEvents(events);
      timelineSet.addEventsToTimeline(timelineEvents, true, false, timeline, res.start);
      // The target event is not in a thread but process the contextual events, so we can show any threads around it.
      _this32.processThreadEvents(timelineSet.room, threadedEvents, true);
      _this32.processAggregatedTimelineEvents(timelineSet.room, timelineEvents);
      unknownRelations.forEach(event => timelineSet.relations.aggregateChildEvent(event));

      // There is no guarantee that the event ended up in "timeline" (we might have switched to a neighbouring
      // timeline) - so check the room's index again. On the other hand, there's no guarantee the event ended up
      // anywhere, if it was later redacted, so we just return the timeline we first thought of.
      return (_ref4 = (_timelineSet$getTimel = timelineSet.getTimelineForEvent(eventId)) !== null && _timelineSet$getTimel !== void 0 ? _timelineSet$getTimel : (_timelineSet$room$fin = timelineSet.room.findThreadForEvent(event)) === null || _timelineSet$room$fin === void 0 ? void 0 : _timelineSet$room$fin.liveTimeline) !== null && _ref4 !== void 0 ? _ref4 :
      // for Threads degraded support
      timeline;
    })();
  }
  getThreadTimeline(timelineSet, eventId) {
    var _this33 = this;
    return _asyncToGenerator(function* () {
      var _this33$clientOpts;
      if (!_this33.supportsThreads()) {
        throw new Error("could not get thread timeline: no client support");
      }
      if (!timelineSet.room) {
        throw new Error("could not get thread timeline: not a room timeline");
      }
      if (!timelineSet.thread) {
        throw new Error("could not get thread timeline: not a thread timeline");
      }
      var path = utils.encodeUri("/rooms/$roomId/context/$eventId", {
        $roomId: timelineSet.room.roomId,
        $eventId: eventId
      });
      var params = {
        limit: "0"
      };
      if ((_this33$clientOpts = _this33.clientOpts) !== null && _this33$clientOpts !== void 0 && _this33$clientOpts.lazyLoadMembers) {
        params.filter = JSON.stringify(Filter.LAZY_LOADING_MESSAGES_FILTER);
      }

      // TODO: we should implement a backoff (as per scrollback()) to deal more nicely with HTTP errors.
      var res = yield _this33.http.authedRequest(Method.Get, path, params);
      var mapper = _this33.getEventMapper();
      var event = mapper(res.event);
      if (!timelineSet.canContain(event)) {
        return undefined;
      }
      var recurse = _this33.canSupport.get(Feature.RelationsRecursion) !== ServerSupport.Unsupported;
      if (Thread.hasServerSideSupport) {
        if (Thread.hasServerSideFwdPaginationSupport) {
          var _resOlder$next_batch, _resNewer$next_batch, _timelineSet$getTimel2;
          if (!timelineSet.thread) {
            throw new Error("could not get thread timeline: not a thread timeline");
          }
          var thread = timelineSet.thread;
          var resOlder = yield _this33.fetchRelations(timelineSet.room.roomId, thread.id, null, null, {
            dir: Direction.Backward,
            from: res.start,
            recurse: recurse || undefined
          });
          var resNewer = yield _this33.fetchRelations(timelineSet.room.roomId, thread.id, null, null, {
            dir: Direction.Forward,
            from: res.end,
            recurse: recurse || undefined
          });
          var events = [
          // Order events from most recent to oldest (reverse-chronological).
          // We start with the last event, since that's the point at which we have known state.
          // events_after is already backwards; events_before is forwards.
          ...resNewer.chunk.reverse().filter(getRelationsThreadFilter(thread.id)).map(mapper), event, ...resOlder.chunk.filter(getRelationsThreadFilter(thread.id)).map(mapper)];
          for (var _event2 of events) {
            var _timelineSet$thread;
            yield (_timelineSet$thread = timelineSet.thread) === null || _timelineSet$thread === void 0 ? void 0 : _timelineSet$thread.processEvent(_event2);
          }

          // Here we handle non-thread timelines only, but still process any thread events to populate thread summaries.
          var timeline = timelineSet.getTimelineForEvent(event.getId());
          if (timeline) {
            timeline.getState(EventTimeline.BACKWARDS).setUnknownStateEvents(res.state.map(mapper));
          } else {
            timeline = timelineSet.addTimeline();
            timeline.initialiseState(res.state.map(mapper));
          }
          timelineSet.addEventsToTimeline(events, true, false, timeline, resNewer.next_batch);
          if (!resOlder.next_batch) {
            var originalEvent = yield _this33.fetchRoomEvent(timelineSet.room.roomId, thread.id);
            timelineSet.addEventsToTimeline([mapper(originalEvent)], true, false, timeline, null);
          }
          timeline.setPaginationToken((_resOlder$next_batch = resOlder.next_batch) !== null && _resOlder$next_batch !== void 0 ? _resOlder$next_batch : null, Direction.Backward);
          timeline.setPaginationToken((_resNewer$next_batch = resNewer.next_batch) !== null && _resNewer$next_batch !== void 0 ? _resNewer$next_batch : null, Direction.Forward);
          _this33.processAggregatedTimelineEvents(timelineSet.room, events);

          // There is no guarantee that the event ended up in "timeline" (we might have switched to a neighbouring
          // timeline) - so check the room's index again. On the other hand, there's no guarantee the event ended up
          // anywhere, if it was later redacted, so we just return the timeline we first thought of.
          return (_timelineSet$getTimel2 = timelineSet.getTimelineForEvent(eventId)) !== null && _timelineSet$getTimel2 !== void 0 ? _timelineSet$getTimel2 : timeline;
        } else {
          var _resOlder$next_batch2;
          // Where the event is a thread reply (not a root) and running in MSC-enabled mode the Thread timeline only
          // functions contiguously, so we have to jump through some hoops to get our target event in it.
          // XXX: workaround for https://github.com/vector-im/element-meta/issues/150

          var _thread = timelineSet.thread;
          var _resOlder = yield _this33.fetchRelations(timelineSet.room.roomId, _thread.id, THREAD_RELATION_TYPE.name, null, {
            dir: Direction.Backward,
            from: res.start,
            recurse: recurse || undefined
          });
          var eventsNewer = [];
          var nextBatch = res.end;
          while (nextBatch) {
            var _resNewer$next_batch2;
            var _resNewer = yield _this33.fetchRelations(timelineSet.room.roomId, _thread.id, THREAD_RELATION_TYPE.name, null, {
              dir: Direction.Forward,
              from: nextBatch,
              recurse: recurse || undefined
            });
            nextBatch = (_resNewer$next_batch2 = _resNewer.next_batch) !== null && _resNewer$next_batch2 !== void 0 ? _resNewer$next_batch2 : null;
            eventsNewer.push(..._resNewer.chunk);
          }
          var _events = [
          // Order events from most recent to oldest (reverse-chronological).
          // We start with the last event, since that's the point at which we have known state.
          // events_after is already backwards; events_before is forwards.
          ...eventsNewer.reverse().map(mapper), event, ..._resOlder.chunk.map(mapper)];
          for (var _event3 of _events) {
            var _timelineSet$thread2;
            yield (_timelineSet$thread2 = timelineSet.thread) === null || _timelineSet$thread2 === void 0 ? void 0 : _timelineSet$thread2.processEvent(_event3);
          }

          // Here we handle non-thread timelines only, but still process any thread events to populate thread
          // summaries.
          var _timeline = timelineSet.getLiveTimeline();
          _timeline.getState(EventTimeline.BACKWARDS).setUnknownStateEvents(res.state.map(mapper));
          timelineSet.addEventsToTimeline(_events, true, false, _timeline, null);
          if (!_resOlder.next_batch) {
            var _originalEvent = yield _this33.fetchRoomEvent(timelineSet.room.roomId, _thread.id);
            timelineSet.addEventsToTimeline([mapper(_originalEvent)], true, false, _timeline, null);
          }
          _timeline.setPaginationToken((_resOlder$next_batch2 = _resOlder.next_batch) !== null && _resOlder$next_batch2 !== void 0 ? _resOlder$next_batch2 : null, Direction.Backward);
          _timeline.setPaginationToken(null, Direction.Forward);
          _this33.processAggregatedTimelineEvents(timelineSet.room, _events);
          return _timeline;
        }
      }
    })();
  }

  /**
   * Get an EventTimeline for the latest events in the room. This will just
   * call `/messages` to get the latest message in the room, then use
   * `client.getEventTimeline(...)` to construct a new timeline from it.
   *
   * @param timelineSet -  The timelineSet to find or add the timeline to
   *
   * @returns Promise which resolves:
   *    {@link EventTimeline} timeline with the latest events in the room
   */
  getLatestTimeline(timelineSet) {
    var _this34 = this;
    return _asyncToGenerator(function* () {
      // don't allow any timeline support unless it's been enabled.
      if (!_this34.timelineSupport) {
        throw new Error("timeline support is disabled. Set the 'timelineSupport'" + " parameter to true when creating MatrixClient to enable it.");
      }
      if (!timelineSet.room) {
        throw new Error("getLatestTimeline only supports room timelines");
      }
      var event;
      if (timelineSet.threadListType !== null) {
        var _res$chunk;
        var res = yield _this34.createThreadListMessagesRequest(timelineSet.room.roomId, null, 1, Direction.Backward, timelineSet.threadListType, timelineSet.getFilter());
        event = (_res$chunk = res.chunk) === null || _res$chunk === void 0 ? void 0 : _res$chunk[0];
      } else if (timelineSet.thread && Thread.hasServerSideSupport) {
        var _res$chunk2;
        var recurse = _this34.canSupport.get(Feature.RelationsRecursion) !== ServerSupport.Unsupported;
        var _res = yield _this34.fetchRelations(timelineSet.room.roomId, timelineSet.thread.id, THREAD_RELATION_TYPE.name, null, {
          dir: Direction.Backward,
          limit: 1,
          recurse: recurse || undefined
        });
        event = (_res$chunk2 = _res.chunk) === null || _res$chunk2 === void 0 ? void 0 : _res$chunk2[0];
      } else {
        var _this34$clientOpts, _res2$chunk;
        var messagesPath = utils.encodeUri("/rooms/$roomId/messages", {
          $roomId: timelineSet.room.roomId
        });
        var _params = {
          dir: "b"
        };
        if ((_this34$clientOpts = _this34.clientOpts) !== null && _this34$clientOpts !== void 0 && _this34$clientOpts.lazyLoadMembers) {
          _params.filter = JSON.stringify(Filter.LAZY_LOADING_MESSAGES_FILTER);
        }
        var _res2 = yield _this34.http.authedRequest(Method.Get, messagesPath, _params);
        event = (_res2$chunk = _res2.chunk) === null || _res2$chunk === void 0 ? void 0 : _res2$chunk[0];
      }
      if (!event) {
        throw new Error("No message returned when trying to construct getLatestTimeline");
      }
      return _this34.getEventTimeline(timelineSet, event.event_id);
    })();
  }

  /**
   * Makes a request to /messages with the appropriate lazy loading filter set.
   * XXX: if we do get rid of scrollback (as it's not used at the moment),
   * we could inline this method again in paginateEventTimeline as that would
   * then be the only call-site
   * @param limit - the maximum amount of events the retrieve
   * @param dir - 'f' or 'b'
   * @param timelineFilter - the timeline filter to pass
   */
  // XXX: Intended private, used in code.
  createMessagesRequest(roomId, fromToken) {
    var _this$clientOpts;
    var limit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 30;
    var dir = arguments.length > 3 ? arguments[3] : undefined;
    var timelineFilter = arguments.length > 4 ? arguments[4] : undefined;
    var path = utils.encodeUri("/rooms/$roomId/messages", {
      $roomId: roomId
    });
    var params = {
      limit: limit.toString(),
      dir: dir
    };
    if (fromToken) {
      params.from = fromToken;
    }
    var filter = null;
    if ((_this$clientOpts = this.clientOpts) !== null && _this$clientOpts !== void 0 && _this$clientOpts.lazyLoadMembers) {
      // create a shallow copy of LAZY_LOADING_MESSAGES_FILTER,
      // so the timelineFilter doesn't get written into it below
      filter = Object.assign({}, Filter.LAZY_LOADING_MESSAGES_FILTER);
    }
    if (timelineFilter) {
      var _timelineFilter$getRo;
      // XXX: it's horrific that /messages' filter parameter doesn't match
      // /sync's one - see https://matrix.org/jira/browse/SPEC-451
      filter = filter || {};
      Object.assign(filter, (_timelineFilter$getRo = timelineFilter.getRoomTimelineFilterComponent()) === null || _timelineFilter$getRo === void 0 ? void 0 : _timelineFilter$getRo.toJSON());
    }
    if (filter) {
      params.filter = JSON.stringify(filter);
    }
    return this.http.authedRequest(Method.Get, path, params);
  }

  /**
   * Makes a request to /messages with the appropriate lazy loading filter set.
   * XXX: if we do get rid of scrollback (as it's not used at the moment),
   * we could inline this method again in paginateEventTimeline as that would
   * then be the only call-site
   * @param limit - the maximum amount of events the retrieve
   * @param dir - 'f' or 'b'
   * @param timelineFilter - the timeline filter to pass
   */
  // XXX: Intended private, used by room.fetchRoomThreads
  createThreadListMessagesRequest(roomId, fromToken) {
    var _this$clientOpts2;
    var limit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 30;
    var dir = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Direction.Backward;
    var threadListType = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : ThreadFilterType.All;
    var timelineFilter = arguments.length > 5 ? arguments[5] : undefined;
    var path = utils.encodeUri("/rooms/$roomId/threads", {
      $roomId: roomId
    });
    var params = {
      limit: limit.toString(),
      dir: dir,
      include: threadFilterTypeToFilter(threadListType)
    };
    if (fromToken) {
      params.from = fromToken;
    }
    var filter = {};
    if ((_this$clientOpts2 = this.clientOpts) !== null && _this$clientOpts2 !== void 0 && _this$clientOpts2.lazyLoadMembers) {
      // create a shallow copy of LAZY_LOADING_MESSAGES_FILTER,
      // so the timelineFilter doesn't get written into it below
      filter = _objectSpread({}, Filter.LAZY_LOADING_MESSAGES_FILTER);
    }
    if (timelineFilter) {
      var _timelineFilter$getRo2;
      // XXX: it's horrific that /messages' filter parameter doesn't match
      // /sync's one - see https://matrix.org/jira/browse/SPEC-451
      filter = _objectSpread(_objectSpread({}, filter), (_timelineFilter$getRo2 = timelineFilter.getRoomTimelineFilterComponent()) === null || _timelineFilter$getRo2 === void 0 ? void 0 : _timelineFilter$getRo2.toJSON());
    }
    if (Object.keys(filter).length) {
      params.filter = JSON.stringify(filter);
    }
    var opts = {
      prefix: Thread.hasServerSideListSupport === FeatureSupport.Stable ? ClientPrefix.V1 : "/_matrix/client/unstable/org.matrix.msc3856"
    };
    return this.http.authedRequest(Method.Get, path, params, undefined, opts).then(res => {
      var _res$chunk3;
      return _objectSpread(_objectSpread({}, res), {}, {
        chunk: (_res$chunk3 = res.chunk) === null || _res$chunk3 === void 0 ? void 0 : _res$chunk3.reverse(),
        start: res.prev_batch,
        end: res.next_batch
      });
    });
  }

  /**
   * Take an EventTimeline, and back/forward-fill results.
   *
   * @param eventTimeline - timeline object to be updated
   *
   * @returns Promise which resolves to a boolean: false if there are no
   *    events and we reached either end of the timeline; else true.
   */
  paginateEventTimeline(eventTimeline, opts) {
    var _this35 = this;
    var isNotifTimeline = eventTimeline.getTimelineSet() === this.notifTimelineSet;
    var room = this.getRoom(eventTimeline.getRoomId());
    var threadListType = eventTimeline.getTimelineSet().threadListType;
    var thread = eventTimeline.getTimelineSet().thread;

    // TODO: we should implement a backoff (as per scrollback()) to deal more
    // nicely with HTTP errors.
    opts = opts || {};
    var backwards = opts.backwards || false;
    if (isNotifTimeline) {
      if (!backwards) {
        throw new Error("paginateNotifTimeline can only paginate backwards");
      }
    }
    var dir = backwards ? EventTimeline.BACKWARDS : EventTimeline.FORWARDS;
    var token = eventTimeline.getPaginationToken(dir);
    var pendingRequest = eventTimeline.paginationRequests[dir];
    if (pendingRequest) {
      // already a request in progress - return the existing promise
      return pendingRequest;
    }
    var path;
    var params;
    var promise;
    if (isNotifTimeline) {
      var _opts$limit;
      path = "/notifications";
      params = {
        limit: ((_opts$limit = opts.limit) !== null && _opts$limit !== void 0 ? _opts$limit : 30).toString(),
        only: "highlight"
      };
      if (token && token !== "end") {
        params.from = token;
      }
      promise = this.http.authedRequest(Method.Get, path, params).then(/*#__PURE__*/function () {
        var _ref5 = _asyncToGenerator(function* (res) {
          var token = res.next_token;
          var matrixEvents = [];
          res.notifications = res.notifications.filter(noUnsafeEventProps);
          for (var i = 0; i < res.notifications.length; i++) {
            var notification = res.notifications[i];
            var _event4 = _this35.getEventMapper()(notification.event);

            // @TODO(kerrya) reprocessing every notification is ugly
            // remove if we get server MSC3994 support
            _this35.getPushDetailsForEvent(_event4, true);
            _event4.event.room_id = notification.room_id; // XXX: gutwrenching
            matrixEvents[i] = _event4;
          }

          // No need to partition events for threads here, everything lives
          // in the notification timeline set
          var timelineSet = eventTimeline.getTimelineSet();
          timelineSet.addEventsToTimeline(matrixEvents, backwards, false, eventTimeline, token);
          _this35.processAggregatedTimelineEvents(timelineSet.room, matrixEvents);

          // if we've hit the end of the timeline, we need to stop trying to
          // paginate. We need to keep the 'forwards' token though, to make sure
          // we can recover from gappy syncs.
          if (backwards && !res.next_token) {
            eventTimeline.setPaginationToken(null, dir);
          }
          return Boolean(res.next_token);
        });
        return function (_x2) {
          return _ref5.apply(this, arguments);
        };
      }()).finally(() => {
        eventTimeline.paginationRequests[dir] = null;
      });
      eventTimeline.paginationRequests[dir] = promise;
    } else if (threadListType !== null) {
      if (!room) {
        throw new Error("Unknown room " + eventTimeline.getRoomId());
      }
      if (!Thread.hasServerSideFwdPaginationSupport && dir === Direction.Forward) {
        throw new Error("Cannot paginate threads forwards without server-side support for MSC 3715");
      }
      promise = this.createThreadListMessagesRequest(eventTimeline.getRoomId(), token, opts.limit, dir, threadListType, eventTimeline.getFilter()).then(res => {
        if (res.state) {
          var roomState = eventTimeline.getState(dir);
          var stateEvents = res.state.filter(noUnsafeEventProps).map(this.getEventMapper());
          roomState.setUnknownStateEvents(stateEvents);
        }
        var token = res.end;
        var matrixEvents = res.chunk.filter(noUnsafeEventProps).map(this.getEventMapper());
        var timelineSet = eventTimeline.getTimelineSet();
        timelineSet.addEventsToTimeline(matrixEvents, backwards, false, eventTimeline, token);
        this.processAggregatedTimelineEvents(room, matrixEvents);
        this.processThreadRoots(room, matrixEvents, backwards);

        // if we've hit the end of the timeline, we need to stop trying to
        // paginate. We need to keep the 'forwards' token though, to make sure
        // we can recover from gappy syncs.
        if (backwards && res.end == res.start) {
          eventTimeline.setPaginationToken(null, dir);
        }
        return res.end !== res.start;
      }).finally(() => {
        eventTimeline.paginationRequests[dir] = null;
      });
      eventTimeline.paginationRequests[dir] = promise;
    } else if (thread) {
      var _eventTimeline$getRoo, _eventTimeline$getRoo2;
      var _room5 = this.getRoom((_eventTimeline$getRoo = eventTimeline.getRoomId()) !== null && _eventTimeline$getRoo !== void 0 ? _eventTimeline$getRoo : undefined);
      if (!_room5) {
        throw new Error("Unknown room " + eventTimeline.getRoomId());
      }
      var recurse = this.canSupport.get(Feature.RelationsRecursion) !== ServerSupport.Unsupported;
      promise = this.fetchRelations((_eventTimeline$getRoo2 = eventTimeline.getRoomId()) !== null && _eventTimeline$getRoo2 !== void 0 ? _eventTimeline$getRoo2 : "", thread.id, null, null, {
        dir,
        limit: opts.limit,
        from: token !== null && token !== void 0 ? token : undefined,
        recurse: recurse || undefined
      }).then(/*#__PURE__*/function () {
        var _ref6 = _asyncToGenerator(function* (res) {
          var mapper = _this35.getEventMapper();
          var matrixEvents = res.chunk.filter(noUnsafeEventProps).filter(getRelationsThreadFilter(thread.id)).map(mapper);

          // Process latest events first
          for (var _event5 of matrixEvents.slice().reverse()) {
            yield thread === null || thread === void 0 ? void 0 : thread.processEvent(_event5);
            var sender = _event5.getSender();
            if (!backwards || (thread === null || thread === void 0 ? void 0 : thread.getEventReadUpTo(sender)) === null) {
              _room5.addLocalEchoReceipt(sender, _event5, ReceiptType.Read);
            }
          }
          var newToken = res.next_batch;
          var timelineSet = eventTimeline.getTimelineSet();
          timelineSet.addEventsToTimeline(matrixEvents, backwards, false, eventTimeline, newToken !== null && newToken !== void 0 ? newToken : null);
          if (!newToken && backwards) {
            var _thread$rootEvent, _eventTimeline$getRoo3;
            var originalEvent = (_thread$rootEvent = thread.rootEvent) !== null && _thread$rootEvent !== void 0 ? _thread$rootEvent : mapper(yield _this35.fetchRoomEvent((_eventTimeline$getRoo3 = eventTimeline.getRoomId()) !== null && _eventTimeline$getRoo3 !== void 0 ? _eventTimeline$getRoo3 : "", thread.id));
            timelineSet.addEventsToTimeline([originalEvent], true, false, eventTimeline, null);
          }
          _this35.processAggregatedTimelineEvents(timelineSet.room, matrixEvents);

          // if we've hit the end of the timeline, we need to stop trying to
          // paginate. We need to keep the 'forwards' token though, to make sure
          // we can recover from gappy syncs.
          if (backwards && !newToken) {
            eventTimeline.setPaginationToken(null, dir);
          }
          return Boolean(newToken);
        });
        return function (_x3) {
          return _ref6.apply(this, arguments);
        };
      }()).finally(() => {
        eventTimeline.paginationRequests[dir] = null;
      });
      eventTimeline.paginationRequests[dir] = promise;
    } else {
      if (!room) {
        throw new Error("Unknown room " + eventTimeline.getRoomId());
      }
      promise = this.createMessagesRequest(eventTimeline.getRoomId(), token, opts.limit, dir, eventTimeline.getFilter()).then(res => {
        if (res.state) {
          var roomState = eventTimeline.getState(dir);
          var stateEvents = res.state.filter(noUnsafeEventProps).map(this.getEventMapper());
          roomState.setUnknownStateEvents(stateEvents);
        }
        var token = res.end;
        var matrixEvents = res.chunk.filter(noUnsafeEventProps).map(this.getEventMapper());
        var timelineSet = eventTimeline.getTimelineSet();
        var [timelineEvents,, unknownRelations] = room.partitionThreadedEvents(matrixEvents);
        timelineSet.addEventsToTimeline(timelineEvents, backwards, false, eventTimeline, token);
        this.processAggregatedTimelineEvents(room, timelineEvents);
        this.processThreadRoots(room, timelineEvents.filter(it => it.getServerAggregatedRelation(THREAD_RELATION_TYPE.name)), false);
        unknownRelations.forEach(event => room.relations.aggregateChildEvent(event));
        var atEnd = res.end === undefined || res.end === res.start;

        // if we've hit the end of the timeline, we need to stop trying to
        // paginate. We need to keep the 'forwards' token though, to make sure
        // we can recover from gappy syncs.
        if (backwards && atEnd) {
          eventTimeline.setPaginationToken(null, dir);
        }
        return !atEnd;
      }).finally(() => {
        eventTimeline.paginationRequests[dir] = null;
      });
      eventTimeline.paginationRequests[dir] = promise;
    }
    return promise;
  }

  /**
   * Reset the notifTimelineSet entirely, paginating in some historical notifs as
   * a starting point for subsequent pagination.
   */
  resetNotifTimelineSet() {
    if (!this.notifTimelineSet) {
      return;
    }

    // FIXME: This thing is a total hack, and results in duplicate events being
    // added to the timeline both from /sync and /notifications, and lots of
    // slow and wasteful processing and pagination.  The correct solution is to
    // extend /messages or /search or something to filter on notifications.

    // use the fictitious token 'end'. in practice we would ideally give it
    // the oldest backwards pagination token from /sync, but /sync doesn't
    // know about /notifications, so we have no choice but to start paginating
    // from the current point in time.  This may well overlap with historical
    // notifs which are then inserted into the timeline by /sync responses.
    this.notifTimelineSet.resetLiveTimeline("end");

    // we could try to paginate a single event at this point in order to get
    // a more valid pagination token, but it just ends up with an out of order
    // timeline. given what a mess this is and given we're going to have duplicate
    // events anyway, just leave it with the dummy token for now.
    /*
    this.paginateNotifTimeline(this._notifTimelineSet.getLiveTimeline(), {
        backwards: true,
        limit: 1
    });
    */
  }

  /**
   * Peek into a room and receive updates about the room. This only works if the
   * history visibility for the room is world_readable.
   * @param roomId - The room to attempt to peek into.
   * @param limit - The number of timeline events to initially retrieve.
   * @returns Promise which resolves: Room object
   * @returns Rejects: with an error response.
   */
  peekInRoom(roomId) {
    var _this$peekSync2;
    var limit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 20;
    (_this$peekSync2 = this.peekSync) === null || _this$peekSync2 === void 0 || _this$peekSync2.stopPeeking();
    this.peekSync = new SyncApi(this, this.clientOpts, this.buildSyncApiOptions());
    return this.peekSync.peek(roomId, limit);
  }

  /**
   * Stop any ongoing room peeking.
   */
  stopPeeking() {
    if (this.peekSync) {
      this.peekSync.stopPeeking();
      this.peekSync = null;
    }
  }

  /**
   * Set r/w flags for guest access in a room.
   * @param roomId - The room to configure guest access in.
   * @param opts - Options
   * @returns Promise which resolves
   * @returns Rejects: with an error response.
   */
  setGuestAccess(roomId, opts) {
    var writePromise = this.sendStateEvent(roomId, EventType.RoomGuestAccess, {
      guest_access: opts.allowJoin ? GuestAccess.CanJoin : GuestAccess.Forbidden
    }, "");
    var readPromise = Promise.resolve();
    if (opts.allowRead) {
      readPromise = this.sendStateEvent(roomId, EventType.RoomHistoryVisibility, {
        history_visibility: HistoryVisibility.WorldReadable
      }, "");
    }
    return Promise.all([readPromise, writePromise]).then(); // .then() to hide results for contract
  }

  /**
   * Requests an email verification token for the purposes of registration.
   * This API requests a token from the homeserver.
   * The doesServerRequireIdServerParam() method can be used to determine if
   * the server requires the id_server parameter to be provided.
   *
   * Parameters and return value are as for requestEmailToken
    * @param email - As requestEmailToken
   * @param clientSecret - As requestEmailToken
   * @param sendAttempt - As requestEmailToken
   * @param nextLink - As requestEmailToken
   * @returns Promise which resolves: As requestEmailToken
   */
  requestRegisterEmailToken(email, clientSecret, sendAttempt, nextLink) {
    return this.requestTokenFromEndpoint("/register/email/requestToken", {
      email: email,
      client_secret: clientSecret,
      send_attempt: sendAttempt,
      next_link: nextLink
    });
  }

  /**
   * Requests a text message verification token for the purposes of registration.
   * This API requests a token from the homeserver.
   * The doesServerRequireIdServerParam() method can be used to determine if
   * the server requires the id_server parameter to be provided.
   *
   * @param phoneCountry - The ISO 3166-1 alpha-2 code for the country in which
   *    phoneNumber should be parsed relative to.
   * @param phoneNumber - The phone number, in national or international format
   * @param clientSecret - As requestEmailToken
   * @param sendAttempt - As requestEmailToken
   * @param nextLink - As requestEmailToken
   * @returns Promise which resolves: As requestEmailToken
   */
  requestRegisterMsisdnToken(phoneCountry, phoneNumber, clientSecret, sendAttempt, nextLink) {
    return this.requestTokenFromEndpoint("/register/msisdn/requestToken", {
      country: phoneCountry,
      phone_number: phoneNumber,
      client_secret: clientSecret,
      send_attempt: sendAttempt,
      next_link: nextLink
    });
  }

  /**
   * Requests an email verification token for the purposes of adding a
   * third party identifier to an account.
   * This API requests a token from the homeserver.
   * The doesServerRequireIdServerParam() method can be used to determine if
   * the server requires the id_server parameter to be provided.
   * If an account with the given email address already exists and is
   * associated with an account other than the one the user is authed as,
   * it will either send an email to the address informing them of this
   * or return M_THREEPID_IN_USE (which one is up to the homeserver).
   *
   * @param email - As requestEmailToken
   * @param clientSecret - As requestEmailToken
   * @param sendAttempt - As requestEmailToken
   * @param nextLink - As requestEmailToken
   * @returns Promise which resolves: As requestEmailToken
   */
  requestAdd3pidEmailToken(email, clientSecret, sendAttempt, nextLink) {
    return this.requestTokenFromEndpoint("/account/3pid/email/requestToken", {
      email: email,
      client_secret: clientSecret,
      send_attempt: sendAttempt,
      next_link: nextLink
    });
  }

  /**
   * Requests a text message verification token for the purposes of adding a
   * third party identifier to an account.
   * This API proxies the identity server /validate/email/requestToken API,
   * adding specific behaviour for the addition of phone numbers to an
   * account, as requestAdd3pidEmailToken.
   *
   * @param phoneCountry - As requestRegisterMsisdnToken
   * @param phoneNumber - As requestRegisterMsisdnToken
   * @param clientSecret - As requestEmailToken
   * @param sendAttempt - As requestEmailToken
   * @param nextLink - As requestEmailToken
   * @returns Promise which resolves: As requestEmailToken
   */
  requestAdd3pidMsisdnToken(phoneCountry, phoneNumber, clientSecret, sendAttempt, nextLink) {
    return this.requestTokenFromEndpoint("/account/3pid/msisdn/requestToken", {
      country: phoneCountry,
      phone_number: phoneNumber,
      client_secret: clientSecret,
      send_attempt: sendAttempt,
      next_link: nextLink
    });
  }

  /**
   * Requests an email verification token for the purposes of resetting
   * the password on an account.
   * This API proxies the identity server /validate/email/requestToken API,
   * adding specific behaviour for the password resetting. Specifically,
   * if no account with the given email address exists, it may either
   * return M_THREEPID_NOT_FOUND or send an email
   * to the address informing them of this (which one is up to the homeserver).
   *
   * requestEmailToken calls the equivalent API directly on the identity server,
   * therefore bypassing the password reset specific logic.
   *
   * @param email - As requestEmailToken
   * @param clientSecret - As requestEmailToken
   * @param sendAttempt - As requestEmailToken
   * @param nextLink - As requestEmailToken
   * @returns Promise which resolves: As requestEmailToken
   */
  requestPasswordEmailToken(email, clientSecret, sendAttempt, nextLink) {
    return this.requestTokenFromEndpoint("/account/password/email/requestToken", {
      email: email,
      client_secret: clientSecret,
      send_attempt: sendAttempt,
      next_link: nextLink
    });
  }

  /**
   * Requests a text message verification token for the purposes of resetting
   * the password on an account.
   * This API proxies the identity server /validate/email/requestToken API,
   * adding specific behaviour for the password resetting, as requestPasswordEmailToken.
   *
   * @param phoneCountry - As requestRegisterMsisdnToken
   * @param phoneNumber - As requestRegisterMsisdnToken
   * @param clientSecret - As requestEmailToken
   * @param sendAttempt - As requestEmailToken
   * @param nextLink - As requestEmailToken
   * @returns Promise which resolves: As requestEmailToken
   */
  requestPasswordMsisdnToken(phoneCountry, phoneNumber, clientSecret, sendAttempt, nextLink) {
    return this.requestTokenFromEndpoint("/account/password/msisdn/requestToken", {
      country: phoneCountry,
      phone_number: phoneNumber,
      client_secret: clientSecret,
      send_attempt: sendAttempt,
      next_link: nextLink
    });
  }

  /**
   * Internal utility function for requesting validation tokens from usage-specific
   * requestToken endpoints.
   *
   * @param endpoint - The endpoint to send the request to
   * @param params - Parameters for the POST request
   * @returns Promise which resolves: As requestEmailToken
   */
  requestTokenFromEndpoint(endpoint, params) {
    var _this36 = this;
    return _asyncToGenerator(function* () {
      var postParams = Object.assign({}, params);
      return _this36.http.request(Method.Post, endpoint, undefined, postParams);
    })();
  }

  /**
   * Get the room-kind push rule associated with a room.
   * @param scope - "global" or device-specific.
   * @param roomId - the id of the room.
   * @returns the rule or undefined.
   */
  getRoomPushRule(scope, roomId) {
    // There can be only room-kind push rule per room
    // and its id is the room id.
    if (this.pushRules) {
      var _this$pushRules$scope;
      return (_this$pushRules$scope = this.pushRules[scope]) === null || _this$pushRules$scope === void 0 || (_this$pushRules$scope = _this$pushRules$scope.room) === null || _this$pushRules$scope === void 0 ? void 0 : _this$pushRules$scope.find(rule => rule.rule_id === roomId);
    } else {
      throw new Error("SyncApi.sync() must be done before accessing to push rules.");
    }
  }

  /**
   * Set a room-kind muting push rule in a room.
   * The operation also updates MatrixClient.pushRules at the end.
   * @param scope - "global" or device-specific.
   * @param roomId - the id of the room.
   * @param mute - the mute state.
   * @returns Promise which resolves: result object
   * @returns Rejects: with an error response.
   */
  setRoomMutePushRule(scope, roomId, mute) {
    var promise;
    var hasDontNotifyRule = false;

    // Get the existing room-kind push rule if any
    var roomPushRule = this.getRoomPushRule(scope, roomId);
    if (roomPushRule !== null && roomPushRule !== void 0 && roomPushRule.actions.includes(PushRuleActionName.DontNotify)) {
      hasDontNotifyRule = true;
    }
    if (!mute) {
      // Remove the rule only if it is a muting rule
      if (hasDontNotifyRule) {
        promise = this.deletePushRule(scope, PushRuleKind.RoomSpecific, roomPushRule.rule_id);
      }
    } else {
      if (!roomPushRule) {
        promise = this.addPushRule(scope, PushRuleKind.RoomSpecific, roomId, {
          actions: [PushRuleActionName.DontNotify]
        });
      } else if (!hasDontNotifyRule) {
        // Remove the existing one before setting the mute push rule
        // This is a workaround to SYN-590 (Push rule update fails)
        var doneResolvers = Promise.withResolvers();
        this.deletePushRule(scope, PushRuleKind.RoomSpecific, roomPushRule.rule_id).then(() => {
          this.addPushRule(scope, PushRuleKind.RoomSpecific, roomId, {
            actions: [PushRuleActionName.DontNotify]
          }).then(() => {
            doneResolvers.resolve();
          }).catch(err => {
            doneResolvers.reject(err);
          });
        }).catch(err => {
          doneResolvers.reject(err);
        });
        promise = doneResolvers.promise;
      }
    }
    if (promise) {
      return new Promise((resolve, reject) => {
        // Update this.pushRules when the operation completes
        promise.then(() => {
          this.getPushRules().then(result => {
            this.pushRules = result;
            resolve();
          }).catch(err => {
            reject(err);
          });
        }).catch(err => {
          // Update it even if the previous operation fails. This can help the
          // app to recover when push settings has been modified from another client
          this.getPushRules().then(result => {
            this.pushRules = result;
            reject(err);
          }).catch(err2 => {
            reject(err);
          });
        });
      });
    }
  }
  searchMessageText(opts) {
    var roomEvents = {
      search_term: opts.query
    };
    if ("keys" in opts) {
      roomEvents.keys = opts.keys;
    }
    return this.search({
      body: {
        search_categories: {
          room_events: roomEvents
        }
      }
    });
  }

  /**
   * Perform a server-side search for room events.
   *
   * The returned promise resolves to an object containing the fields:
   *
   *  * count:       estimate of the number of results
   *  * next_batch:  token for back-pagination; if undefined, there are no more results
   *  * highlights:  a list of words to highlight from the stemming algorithm
   *  * results:     a list of results
   *
   * Each entry in the results list is a SearchResult.
   *
   * @returns Promise which resolves: result object
   * @returns Rejects: with an error response.
   */
  searchRoomEvents(opts) {
    // TODO: support search groups

    var body = {
      search_categories: {
        room_events: {
          search_term: opts.term,
          filter: opts.filter,
          order_by: SearchOrderBy.Recent,
          event_context: {
            before_limit: 1,
            after_limit: 1,
            include_profile: true
          }
        }
      }
    };
    var searchResults = {
      _query: body,
      results: [],
      highlights: []
    };
    return this.search({
      body: body
    }).then(res => this.processRoomEventsSearch(searchResults, res));
  }

  /**
   * Take a result from an earlier searchRoomEvents call, and backfill results.
   *
   * @param searchResults -  the results object to be updated
   * @returns Promise which resolves: updated result object
   * @returns Rejects: with an error response.
   */
  backPaginateRoomEventsSearch(searchResults) {
    // TODO: we should implement a backoff (as per scrollback()) to deal more
    // nicely with HTTP errors.

    if (!searchResults.next_batch) {
      return Promise.reject(new Error("Cannot backpaginate event search any further"));
    }
    if (searchResults.pendingRequest) {
      // already a request in progress - return the existing promise
      return searchResults.pendingRequest;
    }
    var searchOpts = {
      body: searchResults._query,
      next_batch: searchResults.next_batch
    };
    var promise = this.search(searchOpts, searchResults.abortSignal).then(res => this.processRoomEventsSearch(searchResults, res)).finally(() => {
      searchResults.pendingRequest = undefined;
    });
    searchResults.pendingRequest = promise;
    return promise;
  }

  /**
   * helper for searchRoomEvents and backPaginateRoomEventsSearch. Processes the
   * response from the API call and updates the searchResults
   *
   * @returns searchResults
   * @internal
   */
  // XXX: Intended private, used in code
  processRoomEventsSearch(searchResults, response) {
    var _roomEvents$results$l, _roomEvents$results;
    var roomEvents = response.search_categories.room_events;
    searchResults.count = roomEvents.count;
    searchResults.next_batch = roomEvents.next_batch;

    // combine the highlight list with our existing list;
    var highlights = new Set(roomEvents.highlights);
    searchResults.highlights.forEach(hl => {
      highlights.add(hl);
    });

    // turn it back into a list.
    searchResults.highlights = Array.from(highlights);
    var mapper = this.getEventMapper();

    // append the new results to our existing results
    var resultsLength = (_roomEvents$results$l = (_roomEvents$results = roomEvents.results) === null || _roomEvents$results === void 0 ? void 0 : _roomEvents$results.length) !== null && _roomEvents$results$l !== void 0 ? _roomEvents$results$l : 0;
    for (var i = 0; i < resultsLength; i++) {
      var sr = SearchResult.fromJson(roomEvents.results[i], mapper);
      var _room6 = this.getRoom(sr.context.getEvent().getRoomId());
      if (_room6) {
        for (var ev of sr.context.getTimeline()) {
          ev.setMetadata(_room6.currentState, false);
        }
      }
      searchResults.results.push(sr);
    }
    return searchResults;
  }

  /**
   * Populate the store with rooms the user has left.
   * @returns Promise which resolves: TODO - Resolved when the rooms have
   * been added to the data store.
   * @returns Rejects: with an error response.
   */
  syncLeftRooms() {
    // Guard against multiple calls whilst ongoing and multiple calls post success
    if (this.syncedLeftRooms) {
      return Promise.resolve([]); // don't call syncRooms again if it succeeded.
    }
    if (this.syncLeftRoomsPromise) {
      return this.syncLeftRoomsPromise; // return the ongoing request
    }
    var syncApi = new SyncApi(this, this.clientOpts, this.buildSyncApiOptions());
    this.syncLeftRoomsPromise = syncApi.syncLeftRooms();

    // cleanup locks
    this.syncLeftRoomsPromise.then(() => {
      this.logger.debug("Marking success of sync left room request");
      this.syncedLeftRooms = true; // flip the bit on success
    }).finally(() => {
      this.syncLeftRoomsPromise = undefined; // cleanup ongoing request state
    });
    return this.syncLeftRoomsPromise;
  }

  /**
   * Create a new filter.
   * @param content - The HTTP body for the request
   * @returns Promise which resolves to a Filter object.
   * @returns Rejects: with an error response.
   */
  createFilter(content) {
    var path = utils.encodeUri("/user/$userId/filter", {
      $userId: this.credentials.userId
    });
    return this.http.authedRequest(Method.Post, path, undefined, content).then(response => {
      // persist the filter
      var filter = Filter.fromJson(this.credentials.userId, response.filter_id, content);
      this.store.storeFilter(filter);
      return filter;
    });
  }

  /**
   * Retrieve a filter.
   * @param userId - The user ID of the filter owner
   * @param filterId - The filter ID to retrieve
   * @param allowCached - True to allow cached filters to be returned.
   * Default: True.
   * @returns Promise which resolves: a Filter object
   * @returns Rejects: with an error response.
   */
  getFilter(userId, filterId, allowCached) {
    if (allowCached) {
      var filter = this.store.getFilter(userId, filterId);
      if (filter) {
        return Promise.resolve(filter);
      }
    }
    var path = utils.encodeUri("/user/$userId/filter/$filterId", {
      $userId: userId,
      $filterId: filterId
    });
    return this.http.authedRequest(Method.Get, path).then(response => {
      // persist the filter
      var filter = Filter.fromJson(userId, filterId, response);
      this.store.storeFilter(filter);
      return filter;
    });
  }

  /**
   * @returns Filter ID
   */
  getOrCreateFilter(filterName, filter) {
    var _this37 = this;
    return _asyncToGenerator(function* () {
      var filterId = _this37.store.getFilterIdByName(filterName);
      var existingId;
      if (filterId) {
        // check that the existing filter matches our expectations
        try {
          var existingFilter = yield _this37.getFilter(_this37.credentials.userId, filterId, true);
          if (existingFilter) {
            var oldDef = existingFilter.getDefinition();
            var newDef = filter.getDefinition();
            if (utils.deepCompare(oldDef, newDef)) {
              // super, just use that.
              // debuglog("Using existing filter ID %s: %s", filterId,
              //          JSON.stringify(oldDef));
              existingId = filterId;
            }
          }
        } catch (error) {
          // Synapse currently returns the following when the filter cannot be found:
          // {
          //     errcode: "M_UNKNOWN",
          //     name: "M_UNKNOWN",
          //     message: "No row found",
          // }
          if (error.errcode !== "M_UNKNOWN" && error.errcode !== "M_NOT_FOUND") {
            throw error;
          }
        }
        // if the filter doesn't exist anymore on the server, remove from store
        if (!existingId) {
          _this37.store.setFilterIdByName(filterName, undefined);
        }
      }
      if (existingId) {
        return existingId;
      }

      // create a new filter
      var createdFilter = yield _this37.createFilter(filter.getDefinition());
      _this37.store.setFilterIdByName(filterName, createdFilter.filterId);
      return createdFilter.filterId;
    })();
  }

  /**
   * Gets a bearer token from the homeserver that the user can
   * present to a third party in order to prove their ownership
   * of the Matrix account they are logged into.
   * @returns Promise which resolves: Token object
   * @returns Rejects: with an error response.
   */
  getOpenIdToken() {
    var path = utils.encodeUri("/user/$userId/openid/request_token", {
      $userId: this.credentials.userId
    });
    return this.http.authedRequest(Method.Post, path, undefined, {});
  }
  /**
   * @returns Promise which resolves: ITurnServerResponse object
   * @returns Rejects: with an error response.
   */
  turnServer() {
    return this.http.authedRequest(Method.Get, "/voip/turnServer");
  }

  /**
   * Get the TURN servers for this homeserver.
   * @returns The servers or an empty list.
   */
  getTurnServers() {
    return this.turnServers || [];
  }

  /**
   * Get the unix timestamp (in milliseconds) at which the current
   * TURN credentials (from getTurnServers) expire
   * @returns The expiry timestamp in milliseconds
   */
  getTurnServersExpiry() {
    return this.turnServersExpiry;
  }
  get pollingTurnServers() {
    return this.checkTurnServersIntervalID !== undefined;
  }

  // XXX: Intended private, used in code.
  checkTurnServers() {
    var _this38 = this;
    return _asyncToGenerator(function* () {
      if (!_this38.supportsVoip()) {
        return;
      }
      var credentialsGood = false;
      var remainingTime = _this38.turnServersExpiry - Date.now();
      if (remainingTime > TURN_CHECK_INTERVAL) {
        _this38.logger.debug("TURN creds are valid for another " + remainingTime + " ms: not fetching new ones.");
        credentialsGood = true;
      } else {
        _this38.logger.debug("Fetching new TURN credentials");
        try {
          var res = yield _this38.turnServer();
          if (res.uris) {
            _this38.logger.debug("Got TURN URIs: " + res.uris + " refresh in " + res.ttl + " secs");
            // map the response to a format that can be fed to RTCPeerConnection
            var servers = {
              urls: res.uris,
              username: res.username,
              credential: res.password
            };
            _this38.turnServers = [servers];
            // The TTL is in seconds but we work in ms
            _this38.turnServersExpiry = Date.now() + res.ttl * 1000;
            credentialsGood = true;
            _this38.emit(ClientEvent.TurnServers, _this38.turnServers);
          }
        } catch (err) {
          _this38.logger.error("Failed to get TURN URIs", err);
          if (err.httpStatus === 403) {
            // We got a 403, so there's no point in looping forever.
            _this38.logger.info("TURN access unavailable for this account: stopping credentials checks");
            if (_this38.checkTurnServersIntervalID !== null) {
              globalThis.clearInterval(_this38.checkTurnServersIntervalID);
            }
            _this38.checkTurnServersIntervalID = undefined;
            _this38.emit(ClientEvent.TurnServersError, err, true); // fatal
          } else {
            // otherwise, if we failed for whatever reason, try again the next time we're called.
            _this38.emit(ClientEvent.TurnServersError, err, false); // non-fatal
          }
        }
      }
      return credentialsGood;
    })();
  }

  /**
   * Set whether to allow a fallback ICE server should be used for negotiating a
   * WebRTC connection if the homeserver doesn't provide any servers. Defaults to
   * false.
   *
   */
  setFallbackICEServerAllowed(allow) {
    this.fallbackICEServerAllowed = allow;
  }

  /**
   * Get whether to allow a fallback ICE server should be used for negotiating a
   * WebRTC connection if the homeserver doesn't provide any servers. Defaults to
   * false.
   *
   * @returns
   */
  isFallbackICEServerAllowed() {
    return this.fallbackICEServerAllowed;
  }

  /**
   * Determines if the current user is an administrator of the Synapse homeserver.
   * Returns false if untrue or the homeserver does not appear to be a Synapse
   * homeserver. <strong>This function is implementation specific and may change
   * as a result.</strong>
   * @returns true if the user appears to be a Synapse administrator.
   */
  isSynapseAdministrator() {
    var path = utils.encodeUri("/_synapse/admin/v1/users/$userId/admin", {
      $userId: this.getUserId()
    });
    return this.http.authedRequest(Method.Get, path, undefined, undefined, {
      prefix: ""
    }).then(r => r.admin); // pull out the specific boolean we want
  }

  /**
   * Performs a whois lookup on a user using Synapse's administrator API.
   * <strong>This function is implementation specific and may change as a
   * result.</strong>
   * @param userId - the User ID to look up.
   * @returns the whois response - see Synapse docs for information.
   */
  whoisSynapseUser(userId) {
    var path = utils.encodeUri("/_synapse/admin/v1/whois/$userId", {
      $userId: userId
    });
    return this.http.authedRequest(Method.Get, path, undefined, undefined, {
      prefix: ""
    });
  }

  /**
   * Deactivates a user using Synapse's administrator API. <strong>This
   * function is implementation specific and may change as a result.</strong>
   * @param userId - the User ID to deactivate.
   * @returns the deactivate response - see Synapse docs for information.
   */
  deactivateSynapseUser(userId) {
    var path = utils.encodeUri("/_synapse/admin/v1/deactivate/$userId", {
      $userId: userId
    });
    return this.http.authedRequest(Method.Post, path, undefined, undefined, {
      prefix: ""
    });
  }
  fetchClientWellKnown() {
    var _this39 = this;
    return _asyncToGenerator(function* () {
      var _this39$getDomain;
      // `getRawClientConfig` does not throw or reject on network errors, instead
      // it absorbs errors and returns `{}`.
      _this39.clientWellKnownPromise = AutoDiscovery.getRawClientConfig((_this39$getDomain = _this39.getDomain()) !== null && _this39$getDomain !== void 0 ? _this39$getDomain : undefined);
      _this39.clientWellKnown = yield _this39.clientWellKnownPromise;
      _this39.emit(ClientEvent.ClientWellKnown, _this39.clientWellKnown);
    })();
  }
  getClientWellKnown() {
    return this.clientWellKnown;
  }
  waitForClientWellKnown() {
    if (!this.clientRunning) {
      throw new Error("Client is not running");
    }
    return this.clientWellKnownPromise;
  }

  /**
   * store client options with boolean/string/numeric values
   * to know in the next session what flags the sync data was
   * created with (e.g. lazy loading)
   * @returns for store operation
   */
  storeClientOptions() {
    // XXX: Intended private, used in code
    var primTypes = ["boolean", "string", "number"];
    var serializableOpts = Object.entries(this.clientOpts).filter(_ref7 => {
      var [key, value] = _ref7;
      return primTypes.includes(typeof value);
    }).reduce((obj, _ref8) => {
      var [key, value] = _ref8;
      obj[key] = value;
      return obj;
    }, {});
    return this.store.storeClientOptions(serializableOpts);
  }

  /**
   * Gets a set of room IDs in common with another user.
   *
   * Note: This endpoint is unstable, and can throw an `Error`.
   *   Check progress on [MSC2666](https://github.com/matrix-org/matrix-spec-proposals/pull/2666) for more details.
   *
   * @param userId - The userId to check.
   * @returns Promise which resolves to an array of rooms
   * @returns Rejects: with an error response.
   */
  // TODO: on spec release, rename this to getMutualRooms
  // eslint-disable-next-line
  _unstable_getSharedRooms(userId) {
    var _this40 = this;
    return _asyncToGenerator(function* () {
      // Initial variant of the MSC
      var sharedRoomsSupport = yield _this40.doesServerSupportUnstableFeature(UNSTABLE_MSC2666_SHARED_ROOMS);

      // Newer variant that renamed shared rooms to mutual rooms
      var mutualRoomsSupport = yield _this40.doesServerSupportUnstableFeature(UNSTABLE_MSC2666_MUTUAL_ROOMS);

      // Latest variant that changed from path elements to query elements
      var queryMutualRoomsSupport = yield _this40.doesServerSupportUnstableFeature(UNSTABLE_MSC2666_QUERY_MUTUAL_ROOMS);
      if (!sharedRoomsSupport && !mutualRoomsSupport && !queryMutualRoomsSupport) {
        throw Error("Server does not support the Mutual Rooms API");
      }
      var path;
      var query;

      // Cascading unstable support switching.
      if (queryMutualRoomsSupport) {
        path = "/uk.half-shot.msc2666/user/mutual_rooms";
        query = {
          user_id: userId
        };
      } else {
        path = utils.encodeUri("/uk.half-shot.msc2666/user/".concat(mutualRoomsSupport ? "mutual_rooms" : "shared_rooms", "/$userId"), {
          $userId: userId
        });
        query = {};
      }

      // Accumulated rooms
      var rooms = [];
      var token = null;
      do {
        var tokenQuery = {};
        if (token != null && queryMutualRoomsSupport) {
          tokenQuery["batch_token"] = token;
        }
        var res = yield _this40.http.authedRequest(Method.Get, path, _objectSpread(_objectSpread({}, query), tokenQuery), undefined, {
          prefix: ClientPrefix.Unstable
        });
        rooms.push(...res.joined);
        if (res.next_batch_token !== undefined) {
          token = res.next_batch_token;
        } else {
          token = null;
        }
      } while (token != null);
      return rooms;
    })();
  }

  /**
   * Get the API versions supported by the server, along with any
   * unstable APIs it supports
   * @returns The server /versions response
   */
  getVersions() {
    var _this41 = this;
    return _asyncToGenerator(function* () {
      if (_this41.serverVersionsPromise) {
        return _this41.serverVersionsPromise;
      }

      // We send an authenticated request as of MSC4026
      _this41.serverVersionsPromise = _this41.http.authedRequest(Method.Get, "/_matrix/client/versions", undefined, undefined, {
        prefix: ""
      }).catch(e => {
        // Need to unset this if it fails, otherwise we'll never retry
        _this41.serverVersionsPromise = undefined;
        // but rethrow the exception to anything that was waiting
        throw e;
      });
      var serverVersions = yield _this41.serverVersionsPromise;
      _this41.canSupport = yield buildFeatureSupportMap(serverVersions);
      return _this41.serverVersionsPromise;
    })();
  }

  /**
   * Check if a particular spec version is supported by the server.
   * @param version - The spec version (such as "r0.5.0") to check for.
   * @returns Whether it is supported
   */
  isVersionSupported(version) {
    var _this42 = this;
    return _asyncToGenerator(function* () {
      var {
        versions
      } = yield _this42.getVersions();
      return versions && versions.includes(version);
    })();
  }

  /**
   * Query the server to see if it lists support for an unstable feature
   * in the /versions response
   * @param feature - the feature name
   * @returns true if the feature is supported
   */
  doesServerSupportUnstableFeature(feature) {
    var _this43 = this;
    return _asyncToGenerator(function* () {
      var response = yield _this43.getVersions();
      if (!response) return false;
      var unstableFeatures = response["unstable_features"];
      return unstableFeatures && !!unstableFeatures[feature];
    })();
  }

  /**
   * Query the server to see if it is forcing encryption to be enabled for
   * a given room preset, based on the /versions response.
   * @param presetName - The name of the preset to check.
   * @returns true if the server is forcing encryption
   * for the preset.
   */
  doesServerForceEncryptionForPreset(presetName) {
    var _this44 = this;
    return _asyncToGenerator(function* () {
      var response = yield _this44.getVersions();
      if (!response) return false;
      var unstableFeatures = response["unstable_features"];

      // The preset name in the versions response will be without the _chat suffix.
      var versionsPresetName = presetName.includes("_chat") ? presetName.substring(0, presetName.indexOf("_chat")) : presetName;
      return unstableFeatures && !!unstableFeatures["io.element.e2ee_forced.".concat(versionsPresetName)];
    })();
  }
  doesServerSupportThread() {
    var _this45 = this;
    return _asyncToGenerator(function* () {
      if (yield _this45.isVersionSupported("v1.4")) {
        return {
          threads: FeatureSupport.Stable,
          list: FeatureSupport.Stable,
          fwdPagination: FeatureSupport.Stable
        };
      }
      try {
        var [threadUnstable, threadStable, listUnstable, listStable, fwdPaginationUnstable, fwdPaginationStable] = yield Promise.all([_this45.doesServerSupportUnstableFeature("org.matrix.msc3440"), _this45.doesServerSupportUnstableFeature("org.matrix.msc3440.stable"), _this45.doesServerSupportUnstableFeature("org.matrix.msc3856"), _this45.doesServerSupportUnstableFeature("org.matrix.msc3856.stable"), _this45.doesServerSupportUnstableFeature("org.matrix.msc3715"), _this45.doesServerSupportUnstableFeature("org.matrix.msc3715.stable")]);
        return {
          threads: determineFeatureSupport(threadStable, threadUnstable),
          list: determineFeatureSupport(listStable, listUnstable),
          fwdPagination: determineFeatureSupport(fwdPaginationStable, fwdPaginationUnstable)
        };
      } catch (_unused2) {
        return {
          threads: FeatureSupport.None,
          list: FeatureSupport.None,
          fwdPagination: FeatureSupport.None
        };
      }
    })();
  }

  /**
   * Get if lazy loading members is being used.
   * @returns Whether or not members are lazy loaded by this client
   */
  hasLazyLoadMembersEnabled() {
    var _this$clientOpts3;
    return !!((_this$clientOpts3 = this.clientOpts) !== null && _this$clientOpts3 !== void 0 && _this$clientOpts3.lazyLoadMembers);
  }

  /**
   * Set a function which is called when /sync returns a 'limited' response.
   * It is called with a room ID and returns a boolean. It should return 'true' if the SDK
   * can SAFELY remove events from this room. It may not be safe to remove events if there
   * are other references to the timelines for this room, e.g because the client is
   * actively viewing events in this room.
   * Default: returns false.
   * @param cb - The callback which will be invoked.
   */
  setCanResetTimelineCallback(cb) {
    this.canResetTimelineCallback = cb;
  }

  /**
   * Get the callback set via `setCanResetTimelineCallback`.
   * @returns The callback or null
   */
  getCanResetTimelineCallback() {
    return this.canResetTimelineCallback;
  }

  /**
   * Returns relations for a given event. Handles encryption transparently,
   * with the caveat that the amount of events returned might be 0, even though you get a nextBatch.
   * When the returned promise resolves, all messages should have finished trying to decrypt.
   * @param roomId - the room of the event
   * @param eventId - the id of the event
   * @param relationType - the rel_type of the relations requested
   * @param eventType - the event type of the relations requested
   * @param opts - options with optional values for the request.
   * @returns an object with `events` as `MatrixEvent[]` and optionally `nextBatch` if more relations are available.
   */
  relations(roomId, eventId, relationType, eventType) {
    var _arguments9 = arguments,
      _this46 = this;
    return _asyncToGenerator(function* () {
      var _result$next_batch, _result$prev_batch;
      var opts = _arguments9.length > 4 && _arguments9[4] !== undefined ? _arguments9[4] : {
        dir: Direction.Backward
      };
      var fetchedEventType = eventType ? _this46.getEncryptedIfNeededEventType(roomId, eventType) : null;
      var [eventResult, result] = yield Promise.all([_this46.fetchRoomEvent(roomId, eventId), _this46.fetchRelations(roomId, eventId, relationType, fetchedEventType, opts)]);
      var mapper = _this46.getEventMapper();
      var originalEvent = eventResult ? mapper(eventResult) : undefined;
      var events = result.chunk.map(mapper);
      if (fetchedEventType === EventType.RoomMessageEncrypted) {
        var allEvents = originalEvent ? events.concat(originalEvent) : events;
        yield Promise.all(allEvents.map(e => _this46.decryptEventIfNeeded(e)));
        if (eventType !== null) {
          events = events.filter(e => e.getType() === eventType);
        }
      }
      if (originalEvent && relationType === RelationType.Replace) {
        events = events.filter(e => e.getSender() === originalEvent.getSender());
      }
      return {
        originalEvent: originalEvent !== null && originalEvent !== void 0 ? originalEvent : null,
        events,
        nextBatch: (_result$next_batch = result.next_batch) !== null && _result$next_batch !== void 0 ? _result$next_batch : null,
        prevBatch: (_result$prev_batch = result.prev_batch) !== null && _result$prev_batch !== void 0 ? _result$prev_batch : null
      };
    })();
  }

  /**
   * Generates a random string suitable for use as a client secret. <strong>This
   * method is experimental and may change.</strong>
   * @returns A new client secret
   */
  generateClientSecret() {
    return secureRandomString(32);
  }

  /**
   * Attempts to decrypt an event
   * @param event - The event to decrypt
   * @returns A decryption promise
   */
  decryptEventIfNeeded(event, options) {
    if (event.isState() && !this.enableEncryptedStateEvents) {
      return Promise.resolve();
    }
    if (event.shouldAttemptDecryption() && this.getCrypto()) {
      event.attemptDecryption(this.cryptoBackend, options);
    }
    if (event.isBeingDecrypted()) {
      return event.getDecryptionPromise();
    } else {
      return Promise.resolve();
    }
  }
  termsUrlForService(serviceType, baseUrl) {
    switch (serviceType) {
      case SERVICE_TYPES.IS:
        return this.http.getUrl("/terms", undefined, IdentityPrefix.V2, baseUrl);
      case SERVICE_TYPES.IM:
        return this.http.getUrl("/terms", undefined, "/_matrix/integrations/v1", baseUrl);
      default:
        throw new Error("Unsupported service type");
    }
  }

  /**
   * Get the Homeserver URL of this client
   * @returns Homeserver URL of this client
   */
  getHomeserverUrl() {
    return this.baseUrl;
  }

  /**
   * Get the identity server URL of this client
   * @param stripProto - whether or not to strip the protocol from the URL
   * @returns Identity server URL of this client
   */
  getIdentityServerUrl() {
    var _this$idBaseUrl, _this$idBaseUrl2;
    var stripProto = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (stripProto && ((_this$idBaseUrl = this.idBaseUrl) !== null && _this$idBaseUrl !== void 0 && _this$idBaseUrl.startsWith("http://") || (_this$idBaseUrl2 = this.idBaseUrl) !== null && _this$idBaseUrl2 !== void 0 && _this$idBaseUrl2.startsWith("https://"))) {
      return this.idBaseUrl.split("://")[1];
    }
    return this.idBaseUrl;
  }

  /**
   * Set the identity server URL of this client
   * @param url - New identity server URL
   */
  setIdentityServerUrl(url) {
    this.idBaseUrl = utils.ensureNoTrailingSlash(url);
    this.http.setIdBaseUrl(this.idBaseUrl);
  }

  /**
   * Get the access token associated with this account.
   * @returns The access_token or null
   */
  getAccessToken() {
    return this.http.opts.accessToken || null;
  }

  /**
   * Get the refresh token associated with this account.
   * @returns The refresh_token or null
   */
  getRefreshToken() {
    var _this$http$opts$refre;
    return (_this$http$opts$refre = this.http.opts.refreshToken) !== null && _this$http$opts$refre !== void 0 ? _this$http$opts$refre : null;
  }

  /**
   * Set the access token associated with this account.
   * @param token - The new access token.
   */
  setAccessToken(token) {
    this.http.opts.accessToken = token;
    // The /versions response can vary for different users so clear the cache
    this.serverVersionsPromise = undefined;
  }

  /**
   * @returns true if there is a valid access_token for this client.
   */
  isLoggedIn() {
    return this.http.opts.accessToken !== undefined;
  }

  /**
   * Make up a new transaction id
   *
   * @returns a new, unique, transaction id
   */
  makeTxnId() {
    return "m" + new Date().getTime() + "." + this.txnCtr++;
  }

  /**
   * Check whether a username is available prior to registration. An error response
   * indicates an invalid/unavailable username.
   * @param username - The username to check the availability of.
   * @returns Promise which resolves: to boolean of whether the username is available.
   */
  isUsernameAvailable(username) {
    return this.http.authedRequest(Method.Get, "/register/available", {
      username
    }).then(response => {
      return response.available;
    }).catch(response => {
      if (response.errcode === "M_USER_IN_USE") {
        return false;
      }
      return Promise.reject(response);
    });
  }

  /**
   * @param bindThreepids - Set key 'email' to true to bind any email
   *     threepid uses during registration in the identity server. Set 'msisdn' to
   *     true to bind msisdn.
   * @returns Promise which resolves to a RegisterResponse object
   * @returns Rejects: with an error response.
   */
  register(username, password, sessionId, auth, bindThreepids, guestAccessToken, inhibitLogin) {
    if (sessionId) {
      auth.session = sessionId;
    }
    var params = {
      auth: auth,
      refresh_token: true // always ask for a refresh token - does nothing if unsupported
    };
    if (username !== undefined && username !== null) {
      params.username = username;
    }
    if (password !== undefined && password !== null) {
      params.password = password;
    }
    if (guestAccessToken !== undefined && guestAccessToken !== null) {
      params.guest_access_token = guestAccessToken;
    }
    if (inhibitLogin !== undefined && inhibitLogin !== null) {
      params.inhibit_login = inhibitLogin;
    }
    return this.registerRequest(params);
  }

  /**
   * Register a guest account.
   * This method returns the auth info needed to create a new authenticated client,
   * Remember to call `setGuest(true)` on the (guest-)authenticated client, e.g:
   * ```javascript
   * const tmpClient = await sdk.createClient(MATRIX_INSTANCE);
   * const { user_id, device_id, access_token } = tmpClient.registerGuest();
   * const client = createClient({
   *   baseUrl: MATRIX_INSTANCE,
   *   accessToken: access_token,
   *   userId: user_id,
   *   deviceId: device_id,
   * })
   * client.setGuest(true);
   * ```
   *
   * @param body - JSON HTTP body to provide.
   * @returns Promise which resolves: JSON object that contains:
   *                   `{ user_id, device_id, access_token, home_server }`
   * @returns Rejects: with an error response.
   */
  registerGuest() {
    var {
      body
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return this.registerRequest(body || {}, "guest");
  }

  /**
   * @param data - parameters for registration request
   * @param kind - type of user to register. may be "guest"
   * @returns Promise which resolves: to the /register response
   * @returns Rejects: with an error response.
   */
  registerRequest(data, kind) {
    var params = {};
    if (kind) {
      params.kind = kind;
    }
    return this.http.request(Method.Post, "/register", params, data);
  }

  /**
   * Refreshes an access token using a provided refresh token. The refresh token
   * must be valid for the current access token known to the client instance.
   *
   * Note that this function will not cause a logout if the token is deemed
   * unknown by the server - the caller is responsible for managing logout
   * actions on error.
   * @param refreshToken - The refresh token.
   * @returns Promise which resolves to the new token.
   * @returns Rejects with an error response.
   */
  refreshToken(refreshToken) {
    var performRefreshRequestWithPrefix = prefix => this.http.authedRequest(Method.Post, "/refresh", undefined, {
      refresh_token: refreshToken
    }, {
      prefix,
      inhibitLogoutEmit: true // we don't want to cause logout loops
    });

    // First try with the (specced) /v3/ prefix.
    // However, before Synapse 1.72.0, Synapse incorrectly required a /v1/ prefix, so we fall
    // back to that if the request fails, for backwards compatibility.
    return performRefreshRequestWithPrefix(ClientPrefix.V3).catch(e => {
      if (e.errcode === "M_UNRECOGNIZED") {
        return performRefreshRequestWithPrefix(ClientPrefix.V1);
      }
      throw e;
    });
  }

  /**
   * @returns Promise which resolves to the available login flows
   * @returns Rejects: with an error response.
   */
  loginFlows() {
    return this.http.request(Method.Get, "/login");
  }

  /**
   * @returns Promise which resolves to a LoginResponse object
   * @returns Rejects: with an error response.
   *
   * @deprecated This method has unintuitive behaviour: it updates the `MatrixClient` instance with *some* of the
   *    returned credentials. Instead, call {@link loginRequest} and create a new `MatrixClient` instance using the
   *    results. See https://github.com/matrix-org/matrix-js-sdk/issues/4502.
   */
  login(loginType, data) {
    return this.loginRequest(_objectSpread(_objectSpread({}, data), {}, {
      type: loginType
    })).then(response => {
      if (response.access_token && response.user_id) {
        this.http.opts.accessToken = response.access_token;
        this.credentials = {
          userId: response.user_id
        };
      }
      return response;
    });
  }

  /**
   * @returns Promise which resolves to a LoginResponse object
   * @returns Rejects: with an error response.
   *
   * @deprecated This method has unintuitive behaviour: it updates the `MatrixClient` instance with *some* of the
   *   returned credentials. Instead, call {@link loginRequest} with `data.type: "m.login.password"`, and create a new
   *   `MatrixClient` instance using the results. See https://github.com/matrix-org/matrix-js-sdk/issues/4502.
   */
  loginWithPassword(user, password) {
    return this.login("m.login.password", {
      user: user,
      password: password
    });
  }

  /**
   * @param redirectUrl - The URL to redirect to after the HS
   * authenticates with CAS.
   * @returns The HS URL to hit to begin the CAS login process.
   */
  getCasLoginUrl(redirectUrl) {
    return this.getSsoLoginUrl(redirectUrl, "cas");
  }

  /**
   * @param redirectUrl - The URL to redirect to after the HS
   *     authenticates with the SSO.
   * @param loginType - The type of SSO login we are doing (sso or cas).
   *     Defaults to 'sso'.
   * @param idpId - The ID of the Identity Provider being targeted, optional.
   * @param action - the SSO flow to indicate to the IdP, optional.
   * @returns The HS URL to hit to begin the SSO login process.
   */
  getSsoLoginUrl(redirectUrl) {
    var loginType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "sso";
    var idpId = arguments.length > 2 ? arguments[2] : undefined;
    var action = arguments.length > 3 ? arguments[3] : undefined;
    var url = "/login/" + loginType + "/redirect";
    if (idpId) {
      url += "/" + idpId;
    }
    var params = {
      redirectUrl,
      [SSO_ACTION_PARAM.unstable]: action
    };
    return this.http.getUrl(url, params).href;
  }

  /**
   * @param token - Login token previously received from homeserver
   * @returns Promise which resolves to a LoginResponse object
   * @returns Rejects: with an error response.
   *
   * @deprecated This method has unintuitive behaviour: it updates the `MatrixClient` instance with *some* of the
   *   returned credentials. Instead, call {@link loginRequest} with `data.type: "m.login.token"`, and create a new
   *   `MatrixClient` instance using the results. See https://github.com/matrix-org/matrix-js-sdk/issues/4502.
   */
  loginWithToken(token) {
    return this.login("m.login.token", {
      token: token
    });
  }

  /**
   * Sends a `POST /login` request to the server.
   *
   * If successful, this will create a new device and access token for the user.
   *
   * @see {@link MatrixClient.loginFlows} which makes a `GET /login` request.
   * @see https://spec.matrix.org/v1.13/client-server-api/#post_matrixclientv3login
   *
   * @param data - Credentials and other details for the login request.
   */
  loginRequest(data) {
    var _this47 = this;
    return _asyncToGenerator(function* () {
      return yield _this47.http.authedRequest(Method.Post, "/login", undefined, data);
    })();
  }

  /**
   * Logs out the current session.
   * Obviously, further calls that require authorisation should fail after this
   * method is called. The state of the MatrixClient object is not affected:
   * it is up to the caller to either reset or destroy the MatrixClient after
   * this method succeeds.
   * @param stopClient - whether to stop the client before calling /logout to prevent invalid token errors.
   * @returns Promise which resolves: On success, the empty object `{}`
   */
  logout() {
    var _arguments0 = arguments,
      _this48 = this;
    return _asyncToGenerator(function* () {
      var stopClient = _arguments0.length > 0 && _arguments0[0] !== undefined ? _arguments0[0] : false;
      if (stopClient) {
        _this48.stopClient();
        _this48.http.abort();
      }
      return _this48.http.authedRequest(Method.Post, "/logout");
    })();
  }

  /**
   * Deactivates the logged-in account.
   * Obviously, further calls that require authorisation should fail after this
   * method is called. The state of the MatrixClient object is not affected:
   * it is up to the caller to either reset or destroy the MatrixClient after
   * this method succeeds.
   * @param auth - Optional. Auth data to supply for User-Interactive auth.
   * @param erase - Optional. If set, send as `erase` attribute in the
   * JSON request body, indicating whether the account should be erased. Defaults
   * to false.
   * @returns Promise which resolves: On success, the empty object
   */
  deactivateAccount(auth, erase) {
    var body = {};
    if (auth) {
      body.auth = auth;
    }
    if (erase !== undefined) {
      body.erase = erase;
    }
    return this.http.authedRequest(Method.Post, "/account/deactivate", undefined, body);
  }

  /**
   * Make a request for an `m.login.token` to be issued as per
   * https://spec.matrix.org/v1.7/client-server-api/#post_matrixclientv1loginget_token
   *
   * The server may require User-Interactive auth.
   *
   * @param auth - Optional. Auth data to supply for User-Interactive auth.
   * @returns Promise which resolves: On success, the token response
   * or UIA auth data.
   */
  requestLoginToken(auth) {
    var _this49 = this;
    return _asyncToGenerator(function* () {
      var body = {
        auth
      };
      return _this49.http.authedRequest(Method.Post, "/login/get_token", undefined,
      // no query params
      body, {
        prefix: ClientPrefix.V1
      });
    })();
  }

  /**
   * Get the fallback URL to use for unknown interactive-auth stages.
   *
   * @param loginType -     the type of stage being attempted
   * @param authSessionId - the auth session ID provided by the homeserver
   *
   * @returns HS URL to hit to for the fallback interface
   */
  getFallbackAuthUrl(loginType, authSessionId) {
    var path = utils.encodeUri("/auth/$loginType/fallback/web", {
      $loginType: loginType
    });
    return this.http.getUrl(path, {
      session: authSessionId
    }).href;
  }

  /**
   * Create a new room.
   * @param options - a list of options to pass to the /createRoom API.
   * @returns Promise which resolves: `{room_id: {string}}`
   * @returns Rejects: with an error response.
   */
  createRoom(options) {
    var _this50 = this;
    return _asyncToGenerator(function* () {
      var _this50$identityServe;
      // eslint-disable-line camelcase
      // some valid options include: room_alias_name, visibility, invite

      // inject the id_access_token if inviting 3rd party addresses
      var invitesNeedingToken = (options.invite_3pid || []).filter(i => !i.id_access_token);
      if (invitesNeedingToken.length > 0 && (_this50$identityServe = _this50.identityServer) !== null && _this50$identityServe !== void 0 && _this50$identityServe.getAccessToken) {
        var identityAccessToken = yield _this50.identityServer.getAccessToken();
        if (identityAccessToken) {
          for (var invite of invitesNeedingToken) {
            invite.id_access_token = identityAccessToken;
          }
        }
      }
      return _this50.http.authedRequest(Method.Post, "/createRoom", undefined, options);
    })();
  }

  /**
   * Fetches relations for a given event
   * @param roomId - the room of the event
   * @param eventId - the id of the event
   * @param relationType - the rel_type of the relations requested
   * @param eventType - the event type of the relations requested
   * @param opts - options with optional values for the request.
   * @returns the response, with chunk, prev_batch and, next_batch.
   */
  fetchRelations(roomId, eventId, relationType, eventType) {
    var opts = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {
      dir: Direction.Backward
    };
    var params = opts;
    if (Thread.hasServerSideFwdPaginationSupport === FeatureSupport.Experimental) {
      params = replaceParam("dir", "org.matrix.msc3715.dir", params);
    }
    if (this.canSupport.get(Feature.RelationsRecursion) === ServerSupport.Unstable) {
      params = replaceParam("recurse", "org.matrix.msc3981.recurse", params);
    }
    var queryString = utils.encodeParams(params);
    var templatedUrl = "/rooms/$roomId/relations/$eventId";
    if (relationType !== null) {
      templatedUrl += "/$relationType";
      if (eventType !== null) {
        templatedUrl += "/$eventType";
      }
    } else if (eventType !== null) {
      this.logger.warn("eventType: ".concat(eventType, " ignored when fetching\n            relations as relationType is null"));
      eventType = null;
    }
    var path = utils.encodeUri(templatedUrl + "?" + queryString, {
      $roomId: roomId,
      $eventId: eventId,
      $relationType: relationType,
      $eventType: eventType
    });
    return this.http.authedRequest(Method.Get, path, undefined, undefined, {
      prefix: ClientPrefix.V1
    });
  }

  /**
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  roomState(roomId) {
    var path = utils.encodeUri("/rooms/$roomId/state", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Get an event in a room by its event id.
   *
   * @returns Promise which resolves to an object containing the event.
   * @returns Rejects: with an error response.
   */
  fetchRoomEvent(roomId, eventId) {
    var path = utils.encodeUri("/rooms/$roomId/event/$eventId", {
      $roomId: roomId,
      $eventId: eventId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * @param includeMembership - the membership type to include in the response
   * @param excludeMembership - the membership type to exclude from the response
   * @param atEventId - the id of the event for which moment in the timeline the members should be returned for
   * @returns Promise which resolves: dictionary of userid to profile information
   * @returns Rejects: with an error response.
   */
  members(roomId, includeMembership, excludeMembership, atEventId) {
    var queryParams = {};
    if (includeMembership) {
      queryParams.membership = includeMembership;
    }
    if (excludeMembership) {
      queryParams.not_membership = excludeMembership;
    }
    if (atEventId) {
      queryParams.at = atEventId;
    }
    var queryString = utils.encodeParams(queryParams);
    var path = utils.encodeUri("/rooms/$roomId/members?" + queryString, {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Upgrades a room to a new protocol version
   * @param newVersion - The target version to upgrade to
   * @returns Promise which resolves: Object with key 'replacement_room'
   * @returns Rejects: with an error response.
   */
  upgradeRoom(roomId, newVersion) {
    // eslint-disable-line camelcase
    var path = utils.encodeUri("/rooms/$roomId/upgrade", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Post, path, undefined, {
      new_version: newVersion
    });
  }

  /**
   * Retrieve a state event.
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  getStateEvent(roomId, eventType, stateKey) {
    var pathParams = {
      $roomId: roomId,
      $eventType: eventType,
      $stateKey: stateKey
    };
    var path = utils.encodeUri("/rooms/$roomId/state/$eventType", pathParams);
    if (stateKey !== undefined) {
      path = utils.encodeUri(path + "/$stateKey", pathParams);
    }
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Send a state event into a room
   * @param roomId - ID of the room to send the event into
   * @param eventType - type of the state event to send
   * @param content - content of the event to send
   * @param stateKey - the stateKey to send into the room
   * @param opts - Options for the request function.
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  sendStateEvent(roomId, eventType, content) {
    var _arguments1 = arguments,
      _this51 = this;
    return _asyncToGenerator(function* () {
      var stateKey = _arguments1.length > 3 && _arguments1[3] !== undefined ? _arguments1[3] : "";
      var opts = _arguments1.length > 4 && _arguments1[4] !== undefined ? _arguments1[4] : {};
      var room = _this51.getRoom(roomId);
      var event = new MatrixEvent({
        room_id: roomId,
        type: eventType,
        state_key: stateKey,
        // Cast safety: StateEvents[K] is a stronger bound than IContent, which has [key: string]: any
        content: content
      });
      yield _this51.encryptStateEventIfNeeded(event, room !== null && room !== void 0 ? room : undefined);
      var pathParams = {
        $roomId: roomId,
        $eventType: event.getWireType(),
        $stateKey: event.getWireStateKey()
      };
      var path = utils.encodeUri("/rooms/$roomId/state/$eventType", pathParams);
      if (stateKey !== undefined) {
        path = utils.encodeUri(path + "/$stateKey", pathParams);
      }
      return _this51.http.authedRequest(Method.Put, path, undefined, event.getWireContent(), opts);
    })();
  }
  encryptStateEventIfNeeded(event, room) {
    var _this52 = this;
    return _asyncToGenerator(function* () {
      if (!_this52.enableEncryptedStateEvents) {
        return;
      }

      // If the room is unknown, we cannot encrypt for it
      if (!room) return;
      if (!_this52.cryptoBackend && _this52.usingExternalCrypto) {
        // The client has opted to allow sending messages to encrypted
        // rooms even if the room is encrypted, and we haven't set up
        // crypto. This is useful for users of matrix-org/pantalaimon
        return;
      }
      if (!_this52.cryptoBackend) {
        throw new Error("This room is configured to use encryption, but your client does not support encryption.");
      }

      // Check regular encryption conditions.
      if (!(yield _this52.shouldEncryptEventForRoom(event, room))) {
        return;
      }

      // If the crypto impl thinks we shouldn't encrypt, then we shouldn't.
      // Safety: we checked the crypto impl exists above.
      if (!(yield _this52.cryptoBackend.isStateEncryptionEnabledInRoom(room.roomId))) {
        return;
      }

      // Check if the event is excluded under MSC3414
      if (["m.room.create", "m.room.member", "m.room.join_rules", "m.room.power_levels", "m.room.third_party_invite", "m.room.history_visibility", "m.room.guest_access", "m.room.encryption"].includes(event.getType())) {
        return;
      }
      yield _this52.cryptoBackend.encryptEvent(event, room);
    })();
  }

  /**
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  roomInitialSync(roomId, limit) {
    var _limit$toString;
    var path = utils.encodeUri("/rooms/$roomId/initialSync", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Get, path, {
      limit: (_limit$toString = limit === null || limit === void 0 ? void 0 : limit.toString()) !== null && _limit$toString !== void 0 ? _limit$toString : "30"
    });
  }

  /**
   * Set a marker to indicate the point in a room before which the user has read every
   * event. This can be retrieved from room account data (the event type is `m.fully_read`)
   * and displayed as a horizontal line in the timeline that is visually distinct to the
   * position of the user's own read receipt.
   * @param roomId - ID of the room that has been read
   * @param rmEventId - ID of the event that has been read
   * @param rrEventId - ID of the event tracked by the read receipt. This is here
   * for convenience because the RR and the RM are commonly updated at the same time as
   * each other. Optional.
   * @param rpEventId - rpEvent the m.read.private read receipt event for when we
   * don't want other users to see the read receipts. This is experimental. Optional.
   * @returns Promise which resolves: the empty object, `{}`.
   */
  setRoomReadMarkersHttpRequest(roomId, rmEventId, rrEventId, rpEventId) {
    var _this53 = this;
    return _asyncToGenerator(function* () {
      var path = utils.encodeUri("/rooms/$roomId/read_markers", {
        $roomId: roomId
      });
      var content = {
        [ReceiptType.FullyRead]: rmEventId,
        [ReceiptType.Read]: rrEventId
      };
      if ((yield _this53.doesServerSupportUnstableFeature("org.matrix.msc2285.stable")) || (yield _this53.isVersionSupported("v1.4"))) {
        content[ReceiptType.ReadPrivate] = rpEventId;
      }
      return _this53.http.authedRequest(Method.Post, path, undefined, content);
    })();
  }

  /**
   * @returns Promise which resolves: A list of the user's current rooms
   * @returns Rejects: with an error response.
   */
  getJoinedRooms() {
    var path = utils.encodeUri("/joined_rooms", {});
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Retrieve membership info. for a room.
   * @param roomId - ID of the room to get membership for
   * @returns Promise which resolves: A list of currently joined users
   *                                 and their profile data.
   * @returns Rejects: with an error response.
   */
  getJoinedRoomMembers(roomId) {
    var path = utils.encodeUri("/rooms/$roomId/joined_members", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * @param params - Options for this request
   * @returns Promise which resolves: IPublicRoomsResponse
   * @returns Rejects: with an error response.
   */
  publicRooms() {
    var _ref9 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var {
        server,
        limit,
        since
      } = _ref9,
      options = _objectWithoutProperties(_ref9, _excluded);
    if (Object.keys(options).length === 0) {
      var queryParams = {
        server,
        limit,
        since
      };
      return this.http.authedRequest(Method.Get, "/publicRooms", queryParams);
    } else {
      var _queryParams = {
        server
      };
      var _body = _objectSpread({
        limit,
        since
      }, options);
      return this.http.authedRequest(Method.Post, "/publicRooms", _queryParams, _body);
    }
  }

  /**
   * Create an alias to room ID mapping.
   * @param alias - The room alias to create.
   * @param roomId - The room ID to link the alias to.
   * @returns Promise which resolves: an empty object `{}`
   * @returns Rejects: with an error response.
   */
  createAlias(alias, roomId) {
    var path = utils.encodeUri("/directory/room/$alias", {
      $alias: alias
    });
    var data = {
      room_id: roomId
    };
    return this.http.authedRequest(Method.Put, path, undefined, data);
  }

  /**
   * Delete an alias to room ID mapping. This alias must be on your local server,
   * and you must have sufficient access to do this operation.
   * @param alias - The room alias to delete.
   * @returns Promise which resolves: an empty object `{}`.
   * @returns Rejects: with an error response.
   */
  deleteAlias(alias) {
    var path = utils.encodeUri("/directory/room/$alias", {
      $alias: alias
    });
    return this.http.authedRequest(Method.Delete, path);
  }

  /**
   * Gets the local aliases for the room. Note: this includes all local aliases, unlike the
   * curated list from the m.room.canonical_alias state event.
   * @param roomId - The room ID to get local aliases for.
   * @returns Promise which resolves: an object with an `aliases` property, containing an array of local aliases
   * @returns Rejects: with an error response.
   */
  getLocalAliases(roomId) {
    var path = utils.encodeUri("/rooms/$roomId/aliases", {
      $roomId: roomId
    });
    var prefix = ClientPrefix.V3;
    return this.http.authedRequest(Method.Get, path, undefined, undefined, {
      prefix
    });
  }

  /**
   * Get room info for the given alias.
   * @param alias - The room alias to resolve.
   * @returns Promise which resolves: Object with room_id and servers.
   * @returns Rejects: with an error response.
   */
  getRoomIdForAlias(alias) {
    // eslint-disable-line camelcase
    var path = utils.encodeUri("/directory/room/$alias", {
      $alias: alias
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Get the visibility of a room in the current HS's room directory
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  getRoomDirectoryVisibility(roomId) {
    var path = utils.encodeUri("/directory/list/room/$roomId", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Set the visibility of a room in the current HS's room directory
   * @param visibility - "public" to make the room visible
   *                 in the public directory, or "private" to make
   *                 it invisible.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  setRoomDirectoryVisibility(roomId, visibility) {
    var path = utils.encodeUri("/directory/list/room/$roomId", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Put, path, undefined, {
      visibility
    });
  }

  /**
   * Query the user directory with a term matching user IDs, display names and domains.
   * @param options
   * @param options.term - the term with which to search.
   * @param options.limit - the maximum number of results to return. The server will apply a limit if unspecified.
   * @returns Promise which resolves: an array of results.
   */
  searchUserDirectory(_ref0) {
    var {
      term,
      limit
    } = _ref0;
    var body = {
      search_term: term
    };
    if (limit !== undefined) {
      body.limit = limit;
    }
    return this.http.authedRequest(Method.Post, "/user_directory/search", undefined, body);
  }

  /**
   * Upload a file to the media repository on the homeserver.
   *
   * @param file - The object to upload. On a browser, something that
   *   can be sent to XMLHttpRequest.send (typically a File).  Under node.js,
   *   a a Buffer, String or ReadStream.
   *
   * @param opts -  options object
   *
   * @returns Promise which resolves to response object, or rejects with an error (usually a MatrixError).
   */
  uploadContent(file, opts) {
    return this.http.uploadContent(file, opts);
  }

  /**
   * Cancel a file upload in progress
   * @param upload - The object returned from uploadContent
   * @returns true if canceled, otherwise false
   */
  cancelUpload(upload) {
    return this.http.cancelUpload(upload);
  }

  /**
   * Get a list of all file uploads in progress
   * @returns Array of objects representing current uploads.
   * Currently in progress is element 0. Keys:
   *  - promise: The promise associated with the upload
   *  - loaded: Number of bytes uploaded
   *  - total: Total number of bytes to upload
   */
  getCurrentUploads() {
    return this.http.getCurrentUploads();
  }

  /**
   * @param info - The kind of info to retrieve (e.g. 'displayname',
   * 'avatar_url').
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   */
  getProfileInfo(userId, info
  // eslint-disable-next-line camelcase
  ) {
    var path = info ? utils.encodeUri("/profile/$userId/$info", {
      $userId: userId,
      $info: info
    }) : utils.encodeUri("/profile/$userId", {
      $userId: userId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Determine if the server supports extended profiles, as described by MSC4133.
   *
   * @returns `true` if supported, otherwise `false`
   */
  doesServerSupportExtendedProfiles() {
    var _this54 = this;
    return _asyncToGenerator(function* () {
      return (yield _this54.isVersionSupported("v1.16")) || (yield _this54.doesServerSupportUnstableFeature(UNSTABLE_MSC4133_EXTENDED_PROFILES)) || (yield _this54.doesServerSupportUnstableFeature(STABLE_MSC4133_EXTENDED_PROFILES));
    })();
  }

  /**
   * Get the prefix used for extended profile requests.
   *
   * @returns The prefix for use with `authedRequest`
   */
  getExtendedProfileRequestPrefix() {
    var _this55 = this;
    return _asyncToGenerator(function* () {
      if ((yield _this55.isVersionSupported("v1.16")) || (yield _this55.doesServerSupportUnstableFeature("uk.tcpip.msc4133.stable"))) {
        return ClientPrefix.V3;
      }
      return "/_matrix/client/unstable/uk.tcpip.msc4133";
    })();
  }

  /**
   * Fetch a user's *extended* profile, which may include additional keys.
   *
   * @see https://github.com/tcpipuk/matrix-spec-proposals/blob/main/proposals/4133-extended-profiles.md
   * @param userId The user ID to fetch the profile of.
   * @returns A set of keys to property values.
   *
   * @throws An error if the server does not support MSC4133.
   * @throws A M_NOT_FOUND error if the profile could not be found.
   */
  getExtendedProfile(userId) {
    var _this56 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this56.doesServerSupportExtendedProfiles())) {
        throw new Error("Server does not support extended profiles");
      }
      return _this56.http.authedRequest(Method.Get, utils.encodeUri("/profile/$userId", {
        $userId: userId
      }), undefined, undefined, {
        prefix: yield _this56.getExtendedProfileRequestPrefix()
      });
    })();
  }

  /**
   * Fetch a specific key from the user's *extended* profile.
   *
   * @see https://github.com/tcpipuk/matrix-spec-proposals/blob/main/proposals/4133-extended-profiles.md
   * @param userId The user ID to fetch the profile of.
   * @param key The key of the property to fetch.
   * @returns The property value.
   *
   * @throws An error if the server does not support MSC4133.
   * @throws A M_NOT_FOUND error if the key was not set OR the profile could not be found.
   */
  getExtendedProfileProperty(userId, key) {
    var _this57 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this57.doesServerSupportExtendedProfiles())) {
        throw new Error("Server does not support extended profiles");
      }
      var profile = yield _this57.http.authedRequest(Method.Get, utils.encodeUri("/profile/$userId/$key", {
        $userId: userId,
        $key: key
      }), undefined, undefined, {
        prefix: yield _this57.getExtendedProfileRequestPrefix()
      });
      return profile[key];
    })();
  }

  /**
   * Set a property on your *extended* profile.
   *
   * @see https://github.com/tcpipuk/matrix-spec-proposals/blob/main/proposals/4133-extended-profiles.md
   * @param key The key of the property to set.
   * @param value The value to set on the property.
   *
   * @throws An error if the server does not support MSC4133 OR the server disallows editing the user profile.
   */
  setExtendedProfileProperty(key, value) {
    var _this58 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this58.doesServerSupportExtendedProfiles())) {
        throw new Error("Server does not support extended profiles");
      }
      var userId = _this58.getUserId();
      yield _this58.http.authedRequest(Method.Put, utils.encodeUri("/profile/$userId/$key", {
        $userId: userId,
        $key: key
      }), undefined, {
        [key]: value
      }, {
        prefix: yield _this58.getExtendedProfileRequestPrefix()
      });
    })();
  }

  /**
   * Delete a property on your *extended* profile.
   *
   * @see https://github.com/tcpipuk/matrix-spec-proposals/blob/main/proposals/4133-extended-profiles.md
   * @param key The key of the property to delete.
   *
   * @throws An error if the server does not support MSC4133 OR the server disallows editing the user profile.
   */
  deleteExtendedProfileProperty(key) {
    var _this59 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this59.doesServerSupportExtendedProfiles())) {
        throw new Error("Server does not support extended profiles");
      }
      var userId = _this59.getUserId();
      yield _this59.http.authedRequest(Method.Delete, utils.encodeUri("/profile/$userId/$key", {
        $userId: userId,
        $key: key
      }), undefined, undefined, {
        prefix: yield _this59.getExtendedProfileRequestPrefix()
      });
    })();
  }

  /**
   * Update multiple properties on your *extended* profile. This will
   * merge with any existing keys.
   *
   * @see https://github.com/tcpipuk/matrix-spec-proposals/blob/main/proposals/4133-extended-profiles.md
   * @param profile The profile object to merge with the existing profile.
   * @returns The newly merged profile.
   *
   * @throws An error if the server does not support MSC4133 OR the server disallows editing the user profile.
   */
  patchExtendedProfile(profile) {
    var _this60 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this60.doesServerSupportExtendedProfiles())) {
        throw new Error("Server does not support extended profiles");
      }
      var userId = _this60.getUserId();
      return _this60.http.authedRequest(Method.Patch, utils.encodeUri("/profile/$userId", {
        $userId: userId
      }), {}, profile, {
        prefix: yield _this60.getExtendedProfileRequestPrefix()
      });
    })();
  }

  /**
   * Set multiple properties on your *extended* profile. This will completely
   * replace the existing profile, removing any unspecified keys.
   *
   * @see https://github.com/tcpipuk/matrix-spec-proposals/blob/main/proposals/4133-extended-profiles.md
   * @param profile The profile object to set.
   *
   * @throws An error if the server does not support MSC4133 OR the server disallows editing the user profile.
   */
  setExtendedProfile(profile) {
    var _this61 = this;
    return _asyncToGenerator(function* () {
      if (!(yield _this61.doesServerSupportExtendedProfiles())) {
        throw new Error("Server does not support extended profiles");
      }
      var userId = _this61.getUserId();
      yield _this61.http.authedRequest(Method.Put, utils.encodeUri("/profile/$userId", {
        $userId: userId
      }), {}, profile, {
        prefix: yield _this61.getExtendedProfileRequestPrefix()
      });
    })();
  }

  /**
   * @returns Promise which resolves to a list of the user's threepids.
   * @returns Rejects: with an error response.
   */
  getThreePids() {
    return this.http.authedRequest(Method.Get, "/account/3pid");
  }

  /**
   * Add a 3PID to your homeserver account. This API does not use an identity
   * server, as the homeserver is expected to handle 3PID ownership validation.
   *
   * @param data - A object with 3PID validation data from having called
   * `account/3pid/<medium>/requestToken` on the homeserver.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  addThreePidOnly(data) {
    var _this62 = this;
    return _asyncToGenerator(function* () {
      var path = "/account/3pid/add";
      return _this62.http.authedRequest(Method.Post, path, undefined, data);
    })();
  }

  /**
   * Bind a 3PID for discovery onto an identity server via the homeserver. The
   * identity server handles 3PID ownership validation and the homeserver records
   * the new binding to track where all 3PIDs for the account are bound.
   *
   * @param data - A object with 3PID validation data from having called
   * `validate/<medium>/requestToken` on the identity server. It should also
   * contain `id_server` and `id_access_token` fields as well.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  bindThreePid(data) {
    var _this63 = this;
    return _asyncToGenerator(function* () {
      var path = "/account/3pid/bind";
      return _this63.http.authedRequest(Method.Post, path, undefined, data);
    })();
  }

  /**
   * Unbind a 3PID for discovery on an identity server via the homeserver. The
   * homeserver removes its record of the binding to keep an updated record of
   * where all 3PIDs for the account are bound.
   *
   * @param medium - The threepid medium (eg. 'email')
   * @param address - The threepid address (eg. 'bob\@example.com')
   *        this must be as returned by getThreePids.
   * @returns Promise which resolves: on success
   * @returns Rejects: with an error response.
   */
  unbindThreePid(medium, address
  // eslint-disable-next-line camelcase
  ) {
    var _this64 = this;
    return _asyncToGenerator(function* () {
      var path = "/account/3pid/unbind";
      var data = {
        medium,
        address,
        id_server: _this64.getIdentityServerUrl(true)
      };
      return _this64.http.authedRequest(Method.Post, path, undefined, data);
    })();
  }

  /**
   * @param medium - The threepid medium (eg. 'email')
   * @param address - The threepid address (eg. 'bob\@example.com')
   *        this must be as returned by getThreePids.
   * @returns Promise which resolves: The server response on success
   *     (generally the empty JSON object)
   * @returns Rejects: with an error response.
   */
  deleteThreePid(medium, address
  // eslint-disable-next-line camelcase
  ) {
    var path = "/account/3pid/delete";
    return this.http.authedRequest(Method.Post, path, undefined, {
      medium,
      address
    });
  }

  /**
   * Make a request to change your password.
   * @param newPassword - The new desired password.
   * @param logoutDevices - Should all sessions be logged out after the password change. Defaults to true.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  setPassword(authDict, newPassword, logoutDevices) {
    var path = "/account/password";
    var data = {
      auth: authDict,
      new_password: newPassword,
      logout_devices: logoutDevices
    };
    return this.http.authedRequest(Method.Post, path, undefined, data);
  }

  /**
   * Gets all devices recorded for the logged-in user
   * @returns Promise which resolves: result object
   * @returns Rejects: with an error response.
   */
  getDevices() {
    return this.http.authedRequest(Method.Get, "/devices");
  }

  /**
   * Gets specific device details for the logged-in user
   * @param deviceId -  device to query
   * @returns Promise which resolves: result object
   * @returns Rejects: with an error response.
   */
  getDevice(deviceId) {
    var path = utils.encodeUri("/devices/$device_id", {
      $device_id: deviceId
    });
    return this.http.authedRequest(Method.Get, path);
  }

  /**
   * Update the given device
   *
   * @param deviceId -  device to update
   * @param body -       body of request
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  // eslint-disable-next-line camelcase
  setDeviceDetails(deviceId, body) {
    var path = utils.encodeUri("/devices/$device_id", {
      $device_id: deviceId
    });
    return this.http.authedRequest(Method.Put, path, undefined, body);
  }

  /**
   * Delete the given device
   *
   * @param deviceId -  device to delete
   * @param auth - Optional. Auth data to supply for User-Interactive auth.
   * @returns Promise which resolves: result object
   * @returns Rejects: with an error response.
   */
  deleteDevice(deviceId, auth) {
    var path = utils.encodeUri("/devices/$device_id", {
      $device_id: deviceId
    });
    var body = {};
    if (auth) {
      body.auth = auth;
    }
    return this.http.authedRequest(Method.Delete, path, undefined, body);
  }

  /**
   * Delete multiple device
   *
   * @param devices - IDs of the devices to delete
   * @param auth - Optional. Auth data to supply for User-Interactive auth.
   * @returns Promise which resolves: result object
   * @returns Rejects: with an error response.
   */
  deleteMultipleDevices(devices, auth) {
    var body = {
      devices
    };
    if (auth) {
      body.auth = auth;
    }
    var path = "/delete_devices";
    return this.http.authedRequest(Method.Post, path, undefined, body);
  }

  /**
   * Gets all pushers registered for the logged-in user
   *
   * @returns Promise which resolves: Array of objects representing pushers
   * @returns Rejects: with an error response.
   */
  getPushers() {
    var _this65 = this;
    return _asyncToGenerator(function* () {
      var response = yield _this65.http.authedRequest(Method.Get, "/pushers");

      // Migration path for clients that connect to a homeserver that does not support
      // MSC3881 yet, see https://github.com/matrix-org/matrix-spec-proposals/blob/kerry/remote-push-toggle/proposals/3881-remote-push-notification-toggling.md#migration
      if (!(yield _this65.doesServerSupportUnstableFeature("org.matrix.msc3881"))) {
        response.pushers = response.pushers.map(pusher => {
          if (!pusher.hasOwnProperty(PUSHER_ENABLED.name)) {
            pusher[PUSHER_ENABLED.name] = true;
          }
          return pusher;
        });
      }
      return response;
    })();
  }

  /**
   * Adds a new pusher or updates an existing pusher
   *
   * @param pusher - Object representing a pusher
   * @returns Promise which resolves: Empty json object on success
   * @returns Rejects: with an error response.
   */
  setPusher(pusher) {
    var path = "/pushers/set";
    return this.http.authedRequest(Method.Post, path, undefined, pusher);
  }

  /**
   * Removes an existing pusher
   * @param pushKey - pushkey of pusher to remove
   * @param appId - app_id of pusher to remove
   * @returns Promise which resolves: Empty json object on success
   * @returns Rejects: with an error response.
   */
  removePusher(pushKey, appId) {
    var path = "/pushers/set";
    var body = {
      pushkey: pushKey,
      app_id: appId,
      kind: null // marks pusher for removal
    };
    return this.http.authedRequest(Method.Post, path, undefined, body);
  }

  /**
   * Persists local notification settings
   * @returns Promise which resolves: an empty object
   * @returns Rejects: with an error response.
   */
  setLocalNotificationSettings(deviceId, notificationSettings) {
    var key = "".concat(LOCAL_NOTIFICATION_SETTINGS_PREFIX.name, ".").concat(deviceId);
    return this.setAccountData(key, notificationSettings);
  }

  /**
   * Get the push rules for the account from the server.
   * @returns Promise which resolves to the push rules.
   * @returns Rejects: with an error response.
   */
  getPushRules() {
    return this.http.authedRequest(Method.Get, "/pushrules/").then(rules => {
      this.setPushRules(rules);
      return this.pushRules;
    });
  }

  /**
   * Update the push rules for the account. This should be called whenever
   * updated push rules are available.
   */
  setPushRules(rules) {
    // Fix-up defaults, if applicable.
    this.pushRules = PushProcessor.rewriteDefaultRules(this.logger, rules, this.getUserId());
    // Pre-calculate any necessary caches.
    this.pushProcessor.updateCachedPushRuleKeys(this.pushRules);
  }

  /**
   * @returns Promise which resolves: an empty object `{}`
   * @returns Rejects: with an error response.
   */
  addPushRule(scope, kind, ruleId, body) {
    // NB. Scope not uri encoded because devices need the '/'
    var path = utils.encodeUri("/pushrules/" + scope + "/$kind/$ruleId", {
      $kind: kind,
      $ruleId: ruleId
    });
    return this.http.authedRequest(Method.Put, path, undefined, body);
  }

  /**
   * @returns Promise which resolves: an empty object `{}`
   * @returns Rejects: with an error response.
   */
  deletePushRule(scope, kind, ruleId) {
    // NB. Scope not uri encoded because devices need the '/'
    var path = utils.encodeUri("/pushrules/" + scope + "/$kind/$ruleId", {
      $kind: kind,
      $ruleId: ruleId
    });
    return this.http.authedRequest(Method.Delete, path);
  }

  /**
   * Enable or disable a push notification rule.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  setPushRuleEnabled(scope, kind, ruleId, enabled) {
    var path = utils.encodeUri("/pushrules/" + scope + "/$kind/$ruleId/enabled", {
      $kind: kind,
      $ruleId: ruleId
    });
    return this.http.authedRequest(Method.Put, path, undefined, {
      enabled: enabled
    });
  }

  /**
   * Set the actions for a push notification rule.
   * @returns Promise which resolves: to an empty object `{}`
   * @returns Rejects: with an error response.
   */
  setPushRuleActions(scope, kind, ruleId, actions) {
    var path = utils.encodeUri("/pushrules/" + scope + "/$kind/$ruleId/actions", {
      $kind: kind,
      $ruleId: ruleId
    });
    return this.http.authedRequest(Method.Put, path, undefined, {
      actions: actions
    });
  }

  /**
   * Perform a server-side search.
   * @param params
   * @param params.next_batch - the batch token to pass in the query string
   * @param params.body - the JSON object to pass to the request body.
   * @param abortSignal - optional signal used to cancel the http request.
   * @returns Promise which resolves to the search response object.
   * @returns Rejects: with an error response.
   */
  search(_ref1, abortSignal) {
    var {
      body,
      next_batch: nextBatch
    } = _ref1;
    var queryParams = {};
    if (nextBatch) {
      queryParams.next_batch = nextBatch;
    }
    return this.http.authedRequest(Method.Post, "/search", queryParams, body, {
      abortSignal
    });
  }

  /**
   * Upload keys
   *
   * @param content -  body of upload request
   *
   * @param opts - this method no longer takes any opts,
   *  used to take opts.device_id but this was not removed from the spec as a redundant parameter
   *
   * @returns Promise which resolves: result object. Rejects: with
   *     an error response ({@link MatrixError}).
   */
  uploadKeysRequest(content, opts) {
    return this.http.authedRequest(Method.Post, "/keys/upload", undefined, content);
  }
  uploadKeySignatures(content) {
    return this.http.authedRequest(Method.Post, "/keys/signatures/upload", undefined, content);
  }

  /**
   * Download device keys
   *
   * @param userIds -  list of users to get keys for
   *
   * @param token - sync token to pass in the query request, to help
   *   the HS give the most recent results
   *
   * @returns Promise which resolves: result object. Rejects: with
   *     an error response ({@link MatrixError}).
   */
  downloadKeysForUsers(userIds) {
    var {
      token
    } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var content = {
      device_keys: {}
    };
    if (token !== undefined) {
      content.token = token;
    }
    userIds.forEach(u => {
      content.device_keys[u] = [];
    });
    return this.http.authedRequest(Method.Post, "/keys/query", undefined, content);
  }

  /**
   * Claim one-time keys
   *
   * @param devices -  a list of [userId, deviceId] pairs
   *
   * @param keyAlgorithm -  desired key type
   *
   * @param timeout - the time (in milliseconds) to wait for keys from remote
   *     servers
   *
   * @returns Promise which resolves: result object. Rejects: with
   *     an error response ({@link MatrixError}).
   */
  claimOneTimeKeys(devices) {
    var keyAlgorithm = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "signed_curve25519";
    var timeout = arguments.length > 2 ? arguments[2] : undefined;
    var queries = {};
    if (keyAlgorithm === undefined) {
      keyAlgorithm = "signed_curve25519";
    }
    for (var [userId, _deviceId] of devices) {
      var query = queries[userId] || {};
      safeSet(queries, userId, query);
      safeSet(query, _deviceId, keyAlgorithm);
    }
    var content = {
      one_time_keys: queries
    };
    if (timeout) {
      content.timeout = timeout;
    }
    var path = "/keys/claim";
    return this.http.authedRequest(Method.Post, path, undefined, content);
  }

  /**
   * Ask the server for a list of users who have changed their device lists
   * between a pair of sync tokens
   *
   *
   * @returns Promise which resolves: result object. Rejects: with
   *     an error response ({@link MatrixError}).
   */
  getKeyChanges(oldToken, newToken) {
    var qps = {
      from: oldToken,
      to: newToken
    };
    return this.http.authedRequest(Method.Get, "/keys/changes", qps);
  }
  uploadDeviceSigningKeys(auth, keys) {
    // API returns empty object
    var data = Object.assign({}, keys);
    if (auth) Object.assign(data, {
      auth
    });
    return this.http.authedRequest(Method.Post, "/keys/device_signing/upload", undefined, data, {
      prefix: ClientPrefix.Unstable
    });
  }

  /**
   * Register with an identity server using the OpenID token from the user's
   * Homeserver, which can be retrieved via
   * {@link MatrixClient#getOpenIdToken}.
   *
   * Note that the `/account/register` endpoint (as well as IS authentication in
   * general) was added as part of the v2 API version.
   *
   * @returns Promise which resolves: with object containing an Identity
   * Server access token.
   * @returns Rejects: with an error response.
   */
  registerWithIdentityServer(hsOpenIdToken) {
    if (!this.idBaseUrl) {
      throw new Error("No identity server base URL set");
    }
    var uri = this.http.getUrl("/account/register", undefined, IdentityPrefix.V2, this.idBaseUrl);
    return this.http.requestOtherUrl(Method.Post, uri, hsOpenIdToken);
  }

  /**
   * Requests an email verification token directly from an identity server.
   *
   * This API is used as part of binding an email for discovery on an identity
   * server. The validation data that results should be passed to the
   * `bindThreePid` method to complete the binding process.
   *
   * @param email - The email address to request a token for
   * @param clientSecret - A secret binary string generated by the client.
   *                 It is recommended this be around 16 ASCII characters.
   * @param sendAttempt - If an identity server sees a duplicate request
   *                 with the same sendAttempt, it will not send another email.
   *                 To request another email to be sent, use a larger value for
   *                 the sendAttempt param as was used in the previous request.
   * @param nextLink - Optional If specified, the client will be redirected
   *                 to this link after validation.
   * @param identityAccessToken - The `access_token` field of the identity
   * server `/account/register` response (see {@link registerWithIdentityServer}).
   *
   * @returns Promise which resolves: TODO
   * @returns Rejects: with an error response.
   * @throws Error if no identity server is set
   */
  requestEmailToken(email, clientSecret, sendAttempt, nextLink, identityAccessToken) {
    var params = {
      client_secret: clientSecret,
      email: email,
      send_attempt: sendAttempt === null || sendAttempt === void 0 ? void 0 : sendAttempt.toString()
    };
    if (nextLink) {
      params.next_link = nextLink;
    }
    return this.http.idServerRequest(Method.Post, "/validate/email/requestToken", params, IdentityPrefix.V2, identityAccessToken);
  }

  /**
   * Requests a MSISDN verification token directly from an identity server.
   *
   * This API is used as part of binding a MSISDN for discovery on an identity
   * server. The validation data that results should be passed to the
   * `bindThreePid` method to complete the binding process.
   *
   * @param phoneCountry - The ISO 3166-1 alpha-2 code for the country in
   *                 which phoneNumber should be parsed relative to.
   * @param phoneNumber - The phone number, in national or international
   *                 format
   * @param clientSecret - A secret binary string generated by the client.
   *                 It is recommended this be around 16 ASCII characters.
   * @param sendAttempt - If an identity server sees a duplicate request
   *                 with the same sendAttempt, it will not send another SMS.
   *                 To request another SMS to be sent, use a larger value for
   *                 the sendAttempt param as was used in the previous request.
   * @param nextLink - Optional If specified, the client will be redirected
   *                 to this link after validation.
   * @param identityAccessToken - The `access_token` field of the Identity
   * Server `/account/register` response (see {@link registerWithIdentityServer}).
   *
   * @returns Promise which resolves to an object with a sid string
   * @returns Rejects: with an error response.
   * @throws Error if no identity server is set
   */
  requestMsisdnToken(phoneCountry, phoneNumber, clientSecret, sendAttempt, nextLink, identityAccessToken) {
    var params = {
      client_secret: clientSecret,
      country: phoneCountry,
      phone_number: phoneNumber,
      send_attempt: sendAttempt === null || sendAttempt === void 0 ? void 0 : sendAttempt.toString()
    };
    if (nextLink) {
      params.next_link = nextLink;
    }
    return this.http.idServerRequest(Method.Post, "/validate/msisdn/requestToken", params, IdentityPrefix.V2, identityAccessToken);
  }

  /**
   * Submits a MSISDN token to the identity server
   *
   * This is used when submitting the code sent by SMS to a phone number.
   * The identity server has an equivalent API for email but the js-sdk does
   * not expose this, since email is normally validated by the user clicking
   * a link rather than entering a code.
   *
   * @param sid - The sid given in the response to requestToken
   * @param clientSecret - A secret binary string generated by the client.
   *                 This must be the same value submitted in the requestToken call.
   * @param msisdnToken - The MSISDN token, as entered by the user.
   * @param identityAccessToken - The `access_token` field of the Identity
   * Server `/account/register` response (see {@link registerWithIdentityServer}).
   * Some legacy identity servers had no authentication here.
   *
   * @returns Promise which resolves: Object, containing success boolean.
   * @returns Rejects: with an error response.
   * @throws Error if No identity server is set
   */
  submitMsisdnToken(sid, clientSecret, msisdnToken, identityAccessToken) {
    var params = {
      sid: sid,
      client_secret: clientSecret,
      token: msisdnToken
    };
    return this.http.idServerRequest(Method.Post, "/validate/msisdn/submitToken", params, IdentityPrefix.V2, identityAccessToken !== null && identityAccessToken !== void 0 ? identityAccessToken : undefined);
  }

  /**
   * Submits a MSISDN token to an arbitrary URL.
   *
   * This is used when submitting the code sent by SMS to a phone number in the
   * newer 3PID flow where the homeserver validates 3PID ownership (as part of
   * `requestAdd3pidMsisdnToken`). The homeserver response may include a
   * `submit_url` to specify where the token should be sent, and this helper can
   * be used to pass the token to this URL.
   *
   * @param url - The URL to submit the token to
   * @param sid - The sid given in the response to requestToken
   * @param clientSecret - A secret binary string generated by the client.
   *                 This must be the same value submitted in the requestToken call.
   * @param msisdnToken - The MSISDN token, as entered by the user.
   *
   * @returns Promise which resolves: Object, containing success boolean.
   * @returns Rejects: with an error response.
   */
  submitMsisdnTokenOtherUrl(url, sid, clientSecret, msisdnToken) {
    var params = {
      sid: sid,
      client_secret: clientSecret,
      token: msisdnToken
    };
    return this.http.requestOtherUrl(Method.Post, url, params);
  }

  /**
   * Gets the V2 hashing information from the identity server. Primarily useful for
   * lookups.
   * @param identityAccessToken - The access token for the identity server.
   * @returns The hashing information for the identity server.
   */
  getIdentityHashDetails(identityAccessToken) {
    return this.http.idServerRequest(Method.Get, "/hash_details", undefined, IdentityPrefix.V2, identityAccessToken);
  }

  /**
   * Performs a hashed lookup of addresses against the identity server. This is
   * only supported on identity servers which have at least the version 2 API.
   * @param addressPairs - An array of 2 element arrays.
   * The first element of each pair is the address, the second is the 3PID medium.
   * Eg: `["email@example.org", "email"]`
   * @param identityAccessToken - The access token for the identity server.
   * @returns A collection of address mappings to
   * found MXIDs. Results where no user could be found will not be listed.
   */
  identityHashedLookup(addressPairs, identityAccessToken) {
    var _this66 = this;
    return _asyncToGenerator(function* () {
      var params = {
        // addresses: ["email@example.org", "10005550000"],
        // algorithm: "sha256",
        // pepper: "abc123"
      };

      // Get hash information first before trying to do a lookup
      var hashes = yield _this66.getIdentityHashDetails(identityAccessToken);
      if (!hashes || !hashes["lookup_pepper"] || !hashes["algorithms"]) {
        throw new Error("Unsupported identity server: bad response");
      }
      params["pepper"] = hashes["lookup_pepper"];
      var localMapping = {
        // hashed identifier => plain text address
        // For use in this function's return format
      };

      // When picking an algorithm, we pick the hashed over no hashes
      if (hashes["algorithms"].includes("sha256")) {
        params["addresses"] = yield Promise.all(addressPairs.map(/*#__PURE__*/function () {
          var _ref10 = _asyncToGenerator(function* (p) {
            var addr = p[0].toLowerCase(); // lowercase to get consistent hashes
            var med = p[1].toLowerCase();
            var hashBuffer = yield sha256("".concat(addr, " ").concat(med, " ").concat(params["pepper"]));
            var hashed = encodeUnpaddedBase64Url(hashBuffer);

            // Map the hash to a known (case-sensitive) address. We use the case
            // sensitive version because the caller might be expecting that.
            localMapping[hashed] = p[0];
            return hashed;
          });
          return function (_x4) {
            return _ref10.apply(this, arguments);
          };
        }()));
        params["algorithm"] = "sha256";
      } else if (hashes["algorithms"].includes("none")) {
        params["addresses"] = addressPairs.map(p => {
          var addr = p[0].toLowerCase(); // lowercase to get consistent hashes
          var med = p[1].toLowerCase();
          var unhashed = "".concat(addr, " ").concat(med);
          // Map the unhashed values to a known (case-sensitive) address. We use
          // the case-sensitive version because the caller might be expecting that.
          localMapping[unhashed] = p[0];
          return unhashed;
        });
        params["algorithm"] = "none";
      } else {
        throw new Error("Unsupported identity server: unknown hash algorithm");
      }
      var response = yield _this66.http.idServerRequest(Method.Post, "/lookup", params, IdentityPrefix.V2, identityAccessToken);
      if (!(response !== null && response !== void 0 && response["mappings"])) return []; // no results

      var foundAddresses = [];
      for (var hashed of Object.keys(response["mappings"])) {
        var mxid = response["mappings"][hashed];
        var plainAddress = localMapping[hashed];
        if (!plainAddress) {
          throw new Error("Identity server returned more results than expected");
        }
        foundAddresses.push({
          address: plainAddress,
          mxid
        });
      }
      return foundAddresses;
    })();
  }

  /**
   * Looks up the public Matrix ID mapping for a given 3rd party
   * identifier from the identity server
   *
   * @param medium - The medium of the threepid, eg. 'email'
   * @param address - The textual address of the threepid
   * @param identityAccessToken - The `access_token` field of the Identity
   * Server `/account/register` response (see {@link registerWithIdentityServer}).
   *
   * @returns Promise which resolves: A threepid mapping
   *                                 object or the empty object if no mapping
   *                                 exists
   * @returns Rejects: with an error response.
   */
  lookupThreePid(medium, address, identityAccessToken) {
    var _this67 = this;
    return _asyncToGenerator(function* () {
      // Note: we're using the V2 API by calling this function, but our
      // function contract requires a V1 response. We therefore have to
      // convert it manually.
      var response = yield _this67.identityHashedLookup([[address, medium]], identityAccessToken);
      var result = response.find(p => p.address === address);
      if (!result) {
        return {};
      }
      var mapping = {
        address,
        medium,
        mxid: result.mxid

        // We can't reasonably fill these parameters:
        // not_before
        // not_after
        // ts
        // signatures
      };
      return mapping;
    })();
  }

  /**
   * Looks up the public Matrix ID mappings for multiple 3PIDs.
   *
   * @param query - Array of arrays containing
   * [medium, address]
   * @param identityAccessToken - The `access_token` field of the Identity
   * Server `/account/register` response (see {@link registerWithIdentityServer}).
   *
   * @returns Promise which resolves: Lookup results from IS.
   * @returns Rejects: with an error response.
   */
  bulkLookupThreePids(query, identityAccessToken) {
    var _this68 = this;
    return _asyncToGenerator(function* () {
      // Note: we're using the V2 API by calling this function, but our
      // function contract requires a V1 response. We therefore have to
      // convert it manually.
      var response = yield _this68.identityHashedLookup(
      // We have to reverse the query order to get [address, medium] pairs
      query.map(p => [p[1], p[0]]), identityAccessToken);
      var v1results = [];
      var _loop2 = function* _loop2(mapping) {
        var originalQuery = query.find(p => p[1] === mapping.address);
        if (!originalQuery) {
          throw new Error("Identity sever returned unexpected results");
        }
        v1results.push([originalQuery[0],
        // medium
        mapping.address, mapping.mxid]);
      };
      for (var mapping of response) {
        yield* _loop2(mapping);
      }
      return {
        threepids: v1results
      };
    })();
  }

  /**
   * Get account info from the identity server. This is useful as a neutral check
   * to verify that other APIs are likely to approve access by testing that the
   * token is valid, terms have been agreed, etc.
   *
   * @param identityAccessToken - The `access_token` field of the Identity
   * Server `/account/register` response (see {@link registerWithIdentityServer}).
   *
   * @returns Promise which resolves: an object with account info.
   * @returns Rejects: with an error response.
   */
  getIdentityAccount(identityAccessToken) {
    return this.http.idServerRequest(Method.Get, "/account", undefined, IdentityPrefix.V2, identityAccessToken);
  }

  /**
   * Send an event to a specific list of devices.
   * This is a low-level API that simply wraps the HTTP API
   * call to send to-device messages. We recommend using
   * queueToDevice() which is a higher level API.
   *
   * @param eventType -  type of event to send
   *    content to send. Map from user_id to device_id to content object.
   * @param txnId -     transaction id. One will be made up if not
   *    supplied.
   * @returns Promise which resolves: to an empty object `{}`
   */
  sendToDevice(eventType, contentMap, txnId) {
    var path = utils.encodeUri("/sendToDevice/$eventType/$txnId", {
      $eventType: eventType,
      $txnId: txnId ? txnId : this.makeTxnId()
    });
    var body = {
      messages: utils.recursiveMapToObject(contentMap)
    };
    var targets = new Map();
    for (var [userId, deviceMessages] of contentMap) {
      targets.set(userId, Array.from(deviceMessages.keys()));
    }
    this.logger.debug("PUT ".concat(path), targets);
    return this.http.authedRequest(Method.Put, path, undefined, body);
  }

  /**
   * This will encrypt the payload for all devices in the list and will queue it.
   * The type of the sent to-device message will be `m.room.encrypted`.
   * @param eventType - The type of event to send
   * @param devices - The list of devices to send the event to.
   * @param payload - The payload to send. This will be encrypted.
   * @returns Promise which resolves once queued there is no error feedback when sending fails.
   */
  encryptAndSendToDevice(eventType, devices, payload) {
    var _this69 = this;
    return _asyncToGenerator(function* () {
      if (!_this69.cryptoBackend) {
        throw new Error("Cannot encrypt to device event, your client does not support encryption.");
      }
      var batch = yield _this69.cryptoBackend.encryptToDeviceMessages(eventType, devices, payload);

      // TODO The batch mechanism removes all possibility to get error feedbacks..
      // We might want instead to do the API call directly and pass the errors back.
      yield _this69.queueToDevice(batch);
    })();
  }

  /**
   * Sends events directly to specific devices using Matrix's to-device
   * messaging system. The batch will be split up into appropriately sized
   * batches for sending and stored in the store so they can be retried
   * later if they fail to send. Retries will happen automatically.
   * @param batch - The to-device messages to send
   */
  queueToDevice(batch) {
    return this.toDeviceMessageQueue.queueBatch(batch);
  }

  /**
   * Get the third party protocols that can be reached using
   * this HS
   * @returns Promise which resolves to the result object
   */
  getThirdpartyProtocols() {
    return this.http.authedRequest(Method.Get, "/thirdparty/protocols").then(response => {
      // sanity check
      if (!response || typeof response !== "object") {
        throw new Error("/thirdparty/protocols did not return an object: ".concat(response));
      }
      return response;
    });
  }

  /**
   * Get information on how a specific place on a third party protocol
   * may be reached.
   * @param protocol - The protocol given in getThirdpartyProtocols()
   * @param params - Protocol-specific parameters, as given in the
   *                        response to getThirdpartyProtocols()
   * @returns Promise which resolves to the result object
   */
  getThirdpartyLocation(protocol, params) {
    var path = utils.encodeUri("/thirdparty/location/$protocol", {
      $protocol: protocol
    });
    return this.http.authedRequest(Method.Get, path, params);
  }

  /**
   * Get information on how a specific user on a third party protocol
   * may be reached.
   * @param protocol - The protocol given in getThirdpartyProtocols()
   * @param params - Protocol-specific parameters, as given in the
   *                        response to getThirdpartyProtocols()
   * @returns Promise which resolves to the result object
   */
  getThirdpartyUser(protocol, params) {
    var path = utils.encodeUri("/thirdparty/user/$protocol", {
      $protocol: protocol
    });
    return this.http.authedRequest(Method.Get, path, params);
  }
  getTerms(serviceType, baseUrl) {
    var url = this.termsUrlForService(serviceType, baseUrl);
    return this.http.requestOtherUrl(Method.Get, url);
  }
  agreeToTerms(serviceType, baseUrl, accessToken, termsUrls) {
    var url = this.termsUrlForService(serviceType, baseUrl);
    var headers = {
      Authorization: "Bearer " + accessToken
    };
    return this.http.requestOtherUrl(Method.Post, url, {
      user_accepts: termsUrls
    }, {
      headers
    });
  }

  /**
   * Reports an event as inappropriate to the server, which may then notify the appropriate people.
   * @param roomId - The room in which the event being reported is located.
   * @param eventId - The event to report.
   * @param score - The score to rate this content as where -100 is most offensive and 0 is inoffensive.
   * @param reason - The reason the content is being reported. May be blank.
   * @returns Promise which resolves to an empty object if successful
   */
  reportEvent(roomId, eventId, score, reason) {
    var path = utils.encodeUri("/rooms/$roomId/report/$eventId", {
      $roomId: roomId,
      $eventId: eventId
    });
    return this.http.authedRequest(Method.Post, path, undefined, {
      score,
      reason
    });
  }

  /**
   * Reports a room as inappropriate to the server, which may then notify the appropriate people.
   *
   * This API was introduced in Matrix v1.13.
   *
   * @param roomId - The room being reported.
   * @param reason - The reason the room is being reported. May be blank.
   * @returns Promise which resolves to an empty object if successful
   */
  reportRoom(roomId, reason) {
    var path = utils.encodeUri("/rooms/$roomId/report", {
      $roomId: roomId
    });
    return this.http.authedRequest(Method.Post, path, undefined, {
      reason
    });
  }

  /**
   * Fetches or paginates a room hierarchy asmatrix-js-sdk/spec/unit/matrix-client.spec.ts defined by MSC2946.
   * Falls back gracefully to sourcing its data from `getSpaceSummary` if this API is not yet supported by the server.
   * @param roomId - The ID of the space-room to use as the root of the summary.
   * @param limit - The maximum number of rooms to return per page.
   * @param maxDepth - The maximum depth in the tree from the root room to return.
   * @param suggestedOnly - Whether to only return rooms with suggested=true.
   * @param fromToken - The opaque token to paginate a previous request.
   * @returns the response, with next_batch & rooms fields.
   */
  getRoomHierarchy(roomId, limit, maxDepth) {
    var suggestedOnly = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    var fromToken = arguments.length > 4 ? arguments[4] : undefined;
    var path = utils.encodeUri("/rooms/$roomId/hierarchy", {
      $roomId: roomId
    });
    var queryParams = {
      suggested_only: String(suggestedOnly),
      max_depth: maxDepth === null || maxDepth === void 0 ? void 0 : maxDepth.toString(),
      from: fromToken,
      limit: limit === null || limit === void 0 ? void 0 : limit.toString()
    };
    return this.http.authedRequest(Method.Get, path, queryParams, undefined, {
      prefix: ClientPrefix.V1
    }).catch(e => {
      if (e.errcode === "M_UNRECOGNIZED") {
        // fall back to the prefixed hierarchy API.
        return this.http.authedRequest(Method.Get, path, queryParams, undefined, {
          prefix: "/_matrix/client/unstable/org.matrix.msc2946"
        });
      }
      throw e;
    });
  }

  /**
   * Creates a new file tree space with the given name. The client will pick
   * defaults for how it expects to be able to support the remaining API offered
   * by the returned class.
   *
   * Note that this is UNSTABLE and may have breaking changes without notice.
   * @param name - The name of the tree space.
   * @returns Promise which resolves to the created space.
   */
  unstableCreateFileTree(name) {
    var _this70 = this;
    return _asyncToGenerator(function* () {
      var {
        room_id: roomId
      } = yield _this70.createRoom({
        name: name,
        preset: Preset.PrivateChat,
        power_level_content_override: _objectSpread(_objectSpread({}, DEFAULT_TREE_POWER_LEVELS_TEMPLATE), {}, {
          users: {
            [_this70.getUserId()]: 100
          }
        }),
        creation_content: {
          [RoomCreateTypeField]: RoomType.Space
        },
        initial_state: [{
          type: UNSTABLE_MSC3088_PURPOSE.name,
          state_key: UNSTABLE_MSC3089_TREE_SUBTYPE.name,
          content: {
            [UNSTABLE_MSC3088_ENABLED.name]: true
          }
        }, {
          type: EventType.RoomEncryption,
          state_key: "",
          content: {
            algorithm: "m.megolm.v1.aes-sha2"
          }
        }]
      });
      return new MSC3089TreeSpace(_this70, roomId);
    })();
  }

  /**
   * Gets a reference to a tree space, if the room ID given is a tree space. If the room
   * does not appear to be a tree space then null is returned.
   *
   * Note that this is UNSTABLE and may have breaking changes without notice.
   * @param roomId - The room ID to get a tree space reference for.
   * @returns The tree space, or null if not a tree space.
   */
  unstableGetFileTreeSpace(roomId) {
    var _purposeEvent$getCont, _createEvent$getConte;
    var room = this.getRoom(roomId);
    if ((room === null || room === void 0 ? void 0 : room.getMyMembership()) !== KnownMembership.Join) return null;
    var createEvent = room.currentState.getStateEvents(EventType.RoomCreate, "");
    var purposeEvent = room.currentState.getStateEvents(UNSTABLE_MSC3088_PURPOSE.name, UNSTABLE_MSC3089_TREE_SUBTYPE.name);
    if (!createEvent) throw new Error("Expected single room create event");
    if (!(purposeEvent !== null && purposeEvent !== void 0 && (_purposeEvent$getCont = purposeEvent.getContent()) !== null && _purposeEvent$getCont !== void 0 && _purposeEvent$getCont[UNSTABLE_MSC3088_ENABLED.name])) return null;
    if (((_createEvent$getConte = createEvent.getContent()) === null || _createEvent$getConte === void 0 ? void 0 : _createEvent$getConte[RoomCreateTypeField]) !== RoomType.Space) return null;
    return new MSC3089TreeSpace(this, roomId);
  }

  /**
   * Perform a single MSC3575 sliding sync request.
   * @param req - The request to make.
   * @param proxyBaseUrl - The base URL for the sliding sync proxy.
   * @param abortSignal - Optional signal to abort request mid-flight.
   * @returns The sliding sync response, or a standard error.
   * @throws on non 2xx status codes with an object with a field "httpStatus":number.
   */
  slidingSync(req, proxyBaseUrl, abortSignal) {
    var qps = {};
    if (req.pos) {
      qps.pos = req.pos;
      delete req.pos;
    }
    if (req.timeout) {
      qps.timeout = req.timeout;
      delete req.timeout;
    }
    var clientTimeout = req.clientTimeout;
    delete req.clientTimeout;
    return this.http.authedRequest(Method.Post, "/sync", qps, req, {
      prefix: "/_matrix/client/unstable/org.matrix.simplified_msc3575",
      baseUrl: proxyBaseUrl,
      localTimeoutMs: clientTimeout,
      abortSignal
    });
  }

  /**
   * A helper to determine thread support
   * @returns a boolean to determine if threads are enabled
   */
  supportsThreads() {
    var _this$clientOpts4;
    return ((_this$clientOpts4 = this.clientOpts) === null || _this$clientOpts4 === void 0 ? void 0 : _this$clientOpts4.threadSupport) || false;
  }

  /**
   * A helper to determine intentional mentions support
   * @returns a boolean to determine if intentional mentions are enabled on the server
   * @experimental
   */
  supportsIntentionalMentions() {
    return this.canSupport.get(Feature.IntentionalMentions) !== ServerSupport.Unsupported;
  }

  /**
   * Fetches the summary of a room as defined by an initial version of MSC3266 and implemented in Synapse
   * Proposed at https://github.com/matrix-org/matrix-doc/pull/3266
   * @param roomIdOrAlias - The ID or alias of the room to get the summary of.
   * @param via - The list of servers which know about the room if only an ID was provided.
   */
  getRoomSummary(roomIdOrAlias, via) {
    var _this71 = this;
    return _asyncToGenerator(function* () {
      var paramOpts = {
        prefix: "/_matrix/client/unstable/im.nheko.summary"
      };
      try {
        var path = utils.encodeUri("/summary/$roomid", {
          $roomid: roomIdOrAlias
        });
        return yield _this71.http.authedRequest(Method.Get, path, {
          via
        }, undefined, paramOpts);
      } catch (e) {
        if (e instanceof MatrixError && e.errcode === "M_UNRECOGNIZED") {
          var _path = utils.encodeUri("/rooms/$roomid/summary", {
            $roomid: roomIdOrAlias
          });
          return yield _this71.http.authedRequest(Method.Get, _path, {
            via
          }, undefined, paramOpts);
        } else {
          throw e;
        }
      }
    })();
  }

  /**
   * Processes a list of threaded events and adds them to their respective timelines
   * @param room - the room the adds the threaded events
   * @param threadedEvents - an array of the threaded events
   * @param toStartOfTimeline - the direction in which we want to add the events
   */
  processThreadEvents(room, threadedEvents, toStartOfTimeline) {
    room.processThreadedEvents(threadedEvents, toStartOfTimeline);
  }

  /**
   * Processes a list of thread roots and creates a thread model
   * @param room - the room to create the threads in
   * @param threadedEvents - an array of thread roots
   * @param toStartOfTimeline - the direction
   */
  processThreadRoots(room, threadedEvents, toStartOfTimeline) {
    if (!this.supportsThreads()) return;
    room.processThreadRoots(threadedEvents, toStartOfTimeline);
  }
  processBeaconEvents(room, events) {
    this.processAggregatedTimelineEvents(room, events);
  }

  /**
   * Calls aggregation functions for event types that are aggregated
   * Polls and location beacons
   * @param room - room the events belong to
   * @param events - timeline events to be processed
   * @returns
   */
  processAggregatedTimelineEvents(room, events) {
    if (!(events !== null && events !== void 0 && events.length)) return;
    if (!room) return;
    room.currentState.processBeaconEvents(events, this);
    room.processPollEvents(events);
  }

  /**
   * Fetches information about the user for the configured access token.
   */
  whoami() {
    var _this72 = this;
    return _asyncToGenerator(function* () {
      return _this72.http.authedRequest(Method.Get, "/account/whoami");
    })();
  }

  /**
   * Find the event_id closest to the given timestamp in the given direction.
   * @returns Resolves: A promise of an object containing the event_id and
   *    origin_server_ts of the closest event to the timestamp in the given direction
   * @returns Rejects: when the request fails (module:http-api.MatrixError)
   */
  timestampToEvent(roomId, timestamp, dir) {
    var _this73 = this;
    return _asyncToGenerator(function* () {
      var path = utils.encodeUri("/rooms/$roomId/timestamp_to_event", {
        $roomId: roomId
      });
      var queryParams = {
        ts: timestamp.toString(),
        dir: dir
      };
      try {
        return yield _this73.http.authedRequest(Method.Get, path, queryParams, undefined, {
          prefix: ClientPrefix.V1
        });
      } catch (err) {
        // Fallback to the prefixed unstable endpoint. Since the stable endpoint is
        // new, we should also try the unstable endpoint before giving up. We can
        // remove this fallback request in a year (remove after 2023-11-28).
        if (err.errcode === "M_UNRECOGNIZED" && (
        // XXX: The 400 status code check should be removed in the future
        // when Synapse is compliant with MSC3743.
        err.httpStatus === 400 ||
        // This the correct standard status code for an unsupported
        // endpoint according to MSC3743. Not Found and Method Not Allowed
        // both indicate that this endpoint+verb combination is
        // not supported.
        err.httpStatus === 404 || err.httpStatus === 405)) {
          return yield _this73.http.authedRequest(Method.Get, path, queryParams, undefined, {
            prefix: "/_matrix/client/unstable/org.matrix.msc3030"
          });
        }
        throw err;
      }
    })();
  }

  /**
   * Discover and validate delegated auth configuration
   * - delegated auth issuer openid-configuration is reachable
   * - delegated auth issuer openid-configuration is configured correctly for us
   * Fetches /auth_metadata falling back to legacy implementation using /auth_issuer followed by
   * https://oidc-issuer.example.com/.well-known/openid-configuration and other files linked therein.
   * When successful, validated metadata is returned
   * @returns validated authentication metadata and optionally signing keys
   * @throws when delegated auth config is invalid or unreachable
   * @experimental - part of MSC2965
   */
  getAuthMetadata() {
    var _this74 = this;
    return _asyncToGenerator(function* () {
      var authMetadata;
      try {
        authMetadata = yield _this74.http.request(Method.Get, "/auth_metadata", undefined, undefined, {
          prefix: ClientPrefix.Unstable + "/org.matrix.msc2965"
        });
      } catch (e) {
        if (e instanceof MatrixError && e.errcode === "M_UNRECOGNIZED") {
          // Fall back to older variant of MSC2965
          var {
            issuer
          } = yield _this74.http.request(Method.Get, "/auth_issuer", undefined, undefined, {
            prefix: ClientPrefix.Unstable + "/org.matrix.msc2965"
          });
          return discoverAndValidateOIDCIssuerWellKnown(issuer);
        }
        throw e;
      }
      return validateAuthMetadataAndKeys(authMetadata);
    })();
  }
}
_defineProperty(MatrixClient, "RESTORE_BACKUP_ERROR_BAD_KEY", "RESTORE_BACKUP_ERROR_BAD_KEY");
function getUnstableDelayQueryOpts(delayOpts) {
  return Object.fromEntries(Object.entries(delayOpts).map(_ref11 => {
    var [k, v] = _ref11;
    return ["".concat(UNSTABLE_MSC4140_DELAYED_EVENTS, ".").concat(k), v];
  }));
}

/**
 * recalculates an accurate notifications count on event decryption.
 * Servers do not have enough knowledge about encrypted events to calculate an
 * accurate notification_count
 */
export function fixNotificationCountOnDecryption(cli, event) {
  var _actions$tweaks;
  var ourUserId = cli.getUserId();
  var eventId = event.getId();
  var room = cli.getRoom(event.getRoomId());
  if (!room || !ourUserId || !eventId) return;

  // Due to threads, we can get relation events (eg. edits & reactions) that never get
  // added to a timeline and so cannot be found in their own room (their edit / reaction
  // still applies to the event it needs to, so it doesn't matter too much). However, if
  // we try to process notification about this event, we'll get very confused because we
  // won't be able to find the event in the room, so will assume it must be unread, even
  // if it's actually read. We therefore skip anything that isn't in the room. This isn't
  // *great*, so if we can fix the homeless events (eg. with MSC4023) then we should probably
  // remove this workaround.
  if (!room.findEventById(eventId)) {
    logger.info("Decrypted event ".concat(event.getId(), " is not in room ").concat(room.roomId, ": ignoring"));
    return;
  }
  var isThreadEvent = !!event.threadRootId && !event.isThreadRoot;
  var hasReadEvent;
  if (isThreadEvent) {
    var thread = room.getThread(event.threadRootId);
    hasReadEvent = thread ? thread.hasUserReadEvent(ourUserId, eventId) :
    // If the thread object does not exist in the room yet, we don't
    // want to calculate notification for this event yet. We have not
    // restored the read receipts yet and can't accurately calculate
    // notifications at this stage.
    //
    // This issue can likely go away when MSC3874 is implemented
    true;
  } else {
    hasReadEvent = room.hasUserReadEvent(ourUserId, eventId);
  }
  if (hasReadEvent) {
    // If the event has been read, ignore it.
    return;
  }
  var actions = cli.getPushActionsForEvent(event, true);

  // Ensure the unread counts are kept up to date if the event is encrypted
  // We also want to make sure that the notification count goes up if we already
  // have encrypted events to avoid other code from resetting 'highlight' to zero.
  var newHighlight = !!(actions !== null && actions !== void 0 && (_actions$tweaks = actions.tweaks) !== null && _actions$tweaks !== void 0 && _actions$tweaks.highlight);
  if (newHighlight) {
    // TODO: Handle mentions received while the client is offline
    // See also https://github.com/vector-im/element-web/issues/9069
    var newCount = room.getUnreadCountForEventContext(NotificationCountType.Highlight, event) + 1;
    if (isThreadEvent) {
      room.setThreadUnreadNotificationCount(event.threadRootId, NotificationCountType.Highlight, newCount);
    } else {
      room.setUnreadNotificationCount(NotificationCountType.Highlight, newCount);
    }
  }

  // `notify` is used in practice for incrementing the total count
  var newNotify = !!(actions !== null && actions !== void 0 && actions.notify);

  // The room total count is NEVER incremented by the server for encrypted rooms. We basically ignore
  // the server here as it's always going to tell us to increment for encrypted events.
  if (newNotify) {
    // Total count is used to typically increment a room notification counter, but not loudly highlight it.
    var _newCount = room.getUnreadCountForEventContext(NotificationCountType.Total, event) + 1;
    if (isThreadEvent) {
      room.setThreadUnreadNotificationCount(event.threadRootId, NotificationCountType.Total, _newCount);
    } else {
      room.setUnreadNotificationCount(NotificationCountType.Total, _newCount);
    }
  }
}

/**
 * Given an event, figure out the thread ID we should use for it in a receipt.
 *
 * This will either be "main", or event.threadRootId. For the thread root, or
 * e.g. reactions to the thread root, this will be main. For events inside the
 * thread, or e.g. reactions to them, this will be event.threadRootId.
 *
 * (Exported for test.)
 */
export function threadIdForReceipt(event) {
  return inMainTimelineForReceipt(event) ? MAIN_ROOM_TIMELINE : event.threadRootId;
}

/**
 * a) True for non-threaded messages, thread roots and non-thread relations to thread roots.
 * b) False for messages with thread relations to the thread root.
 * c) False for messages with any kind of relation to a message from case b.
 *
 * Note: true for redactions of messages that are in threads. Redacted messages
 * are not really in threads (because their relations are gone), so if they look
 * like they are in threads, that is a sign of a bug elsewhere. (At time of
 * writing, this bug definitely exists - messages are not moved to another
 * thread when they are redacted.)
 *
 * @returns true if this event is considered to be in the main timeline as far
 *               as receipts are concerned.
 */
export function inMainTimelineForReceipt(event) {
  if (!event.threadRootId) {
    // Not in a thread: then it is in the main timeline
    return true;
  }
  if (event.isThreadRoot) {
    // Thread roots are in the main timeline. Note: the spec is ambiguous (or
    // wrong) on this - see
    // https://github.com/matrix-org/matrix-spec-proposals/pull/4037
    return true;
  }
  if (!event.isRelation()) {
    // If it's not related to anything, it can't be related via a chain of
    // relations to a thread root.
    //
    // Note: this is a bug, because how does it have a threadRootId if it is
    // neither a thread root, nor related to one?
    logger.warn("Event is not a relation or a thread root, but still has a threadRootId! id=".concat(event.getId()));
    return true;
  }
  if (event.isRelation(THREAD_RELATION_TYPE.name)) {
    // It's a message in a thread - definitely not in the main timeline.
    return false;
  }
  var isRelatedToRoot = event.relationEventId === event.threadRootId;

  // If it's related to the thread root (and we already know it's not a thread
  // relation) then it's in the main timeline. If it's related to something
  // else, then it's in the thread (because it has a thread ID).
  return isRelatedToRoot;
}
//# sourceMappingURL=client.js.map