/*
Copyright 2019 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import * as matrixcs from "./matrix.js";
if (globalThis.__js_sdk_entrypoint) {
  throw new Error("Multiple matrix-js-sdk entrypoints detected!");
}
globalThis.__js_sdk_entrypoint = true;

// just *accessing* indexedDB throws an exception in firefox with indexeddb disabled.
var indexedDB;
try {
  indexedDB = globalThis.indexedDB;
} catch (_unused) {}

// if our browser (appears to) support indexeddb, use an indexeddb crypto store.
if (indexedDB) {
  matrixcs.setCryptoStoreFactory(() => new matrixcs.IndexedDBCryptoStore(indexedDB, "matrix-js-sdk:crypto"));
}
export * from "./matrix.js";
globalThis.matrixcs = matrixcs;
//# sourceMappingURL=browser-index.js.map