/*
Copyright 2021 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

export var Visibility = /*#__PURE__*/function (Visibility) {
  Visibility["Public"] = "public";
  Visibility["Private"] = "private";
  return Visibility;
}({});
export var Preset = /*#__PURE__*/function (Preset) {
  Preset["PrivateChat"] = "private_chat";
  Preset["TrustedPrivateChat"] = "trusted_private_chat";
  Preset["PublicChat"] = "public_chat";
  return Preset;
}({});
// Knock and private are reserved keywords which are not yet implemented.
export var JoinRule = /*#__PURE__*/function (JoinRule) {
  JoinRule["Public"] = "public";
  JoinRule["Invite"] = "invite";
  /**
   * @deprecated Reserved keyword. Should not be used. Not yet implemented.
   */
  JoinRule["Private"] = "private";
  JoinRule["Knock"] = "knock";
  JoinRule["Restricted"] = "restricted";
  return JoinRule;
}({});
export var RestrictedAllowType = /*#__PURE__*/function (RestrictedAllowType) {
  RestrictedAllowType["RoomMembership"] = "m.room_membership";
  return RestrictedAllowType;
}({});
export var GuestAccess = /*#__PURE__*/function (GuestAccess) {
  GuestAccess["CanJoin"] = "can_join";
  GuestAccess["Forbidden"] = "forbidden";
  return GuestAccess;
}({});
export var HistoryVisibility = /*#__PURE__*/function (HistoryVisibility) {
  HistoryVisibility["Invited"] = "invited";
  HistoryVisibility["Joined"] = "joined";
  HistoryVisibility["Shared"] = "shared";
  HistoryVisibility["WorldReadable"] = "world_readable";
  return HistoryVisibility;
}({});

/**
 * A policy name & url in a specific internationalisation
 * @see https://spec.matrix.org/v1.13/identity-service-api/#get_matrixidentityv2terms_response-200_internationalised-policy
 */

/**
 * A versioned policy with internationalised variants
 * @see https://spec.matrix.org/v1.13/identity-service-api/#get_matrixidentityv2terms_response-200_policy-object
 */

/**
 * Response from the Terms API for Identity servers
 * @see https://spec.matrix.org/v1.13/identity-service-api/#get_matrixidentityv2terms
 */
//# sourceMappingURL=partials.js.map