/*
Copyright 2020 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import { NamespacedValue, UnstableValue } from "../NamespacedValue.js";
export var EventType = /*#__PURE__*/function (EventType) {
  // Room state events
  EventType["RoomCanonicalAlias"] = "m.room.canonical_alias";
  EventType["RoomCreate"] = "m.room.create";
  EventType["RoomJoinRules"] = "m.room.join_rules";
  EventType["RoomMember"] = "m.room.member";
  EventType["RoomThirdPartyInvite"] = "m.room.third_party_invite";
  EventType["RoomPowerLevels"] = "m.room.power_levels";
  EventType["RoomName"] = "m.room.name";
  EventType["RoomTopic"] = "m.room.topic";
  EventType["RoomAvatar"] = "m.room.avatar";
  EventType["RoomPinnedEvents"] = "m.room.pinned_events";
  EventType["RoomEncryption"] = "m.room.encryption";
  EventType["RoomHistoryVisibility"] = "m.room.history_visibility";
  EventType["RoomGuestAccess"] = "m.room.guest_access";
  EventType["RoomServerAcl"] = "m.room.server_acl";
  EventType["RoomTombstone"] = "m.room.tombstone";
  EventType["RoomPredecessor"] = "org.matrix.msc3946.room_predecessor";
  // Moderation policy lists
  EventType["PolicyRuleUser"] = "m.policy.rule.user";
  EventType["PolicyRuleRoom"] = "m.policy.rule.room";
  EventType["PolicyRuleServer"] = "m.policy.rule.server";
  EventType["SpaceChild"] = "m.space.child";
  EventType["SpaceParent"] = "m.space.parent";
  // Room timeline events
  EventType["RoomRedaction"] = "m.room.redaction";
  EventType["RoomMessage"] = "m.room.message";
  EventType["RoomMessageEncrypted"] = "m.room.encrypted";
  EventType["Sticker"] = "m.sticker";
  EventType["CallInvite"] = "m.call.invite";
  EventType["CallCandidates"] = "m.call.candidates";
  EventType["CallAnswer"] = "m.call.answer";
  EventType["CallHangup"] = "m.call.hangup";
  EventType["CallReject"] = "m.call.reject";
  EventType["CallSelectAnswer"] = "m.call.select_answer";
  EventType["CallNegotiate"] = "m.call.negotiate";
  EventType["CallSDPStreamMetadataChanged"] = "m.call.sdp_stream_metadata_changed";
  EventType["CallSDPStreamMetadataChangedPrefix"] = "org.matrix.call.sdp_stream_metadata_changed";
  EventType["CallReplaces"] = "m.call.replaces";
  EventType["CallAssertedIdentity"] = "m.call.asserted_identity";
  EventType["CallAssertedIdentityPrefix"] = "org.matrix.call.asserted_identity";
  EventType["CallEncryptionKeysPrefix"] = "io.element.call.encryption_keys";
  EventType["KeyVerificationRequest"] = "m.key.verification.request";
  EventType["KeyVerificationStart"] = "m.key.verification.start";
  EventType["KeyVerificationCancel"] = "m.key.verification.cancel";
  EventType["KeyVerificationMac"] = "m.key.verification.mac";
  EventType["KeyVerificationDone"] = "m.key.verification.done";
  EventType["KeyVerificationKey"] = "m.key.verification.key";
  EventType["KeyVerificationAccept"] = "m.key.verification.accept";
  // Not used directly - see READY_TYPE in VerificationRequest.
  EventType["KeyVerificationReady"] = "m.key.verification.ready";
  // use of this is discouraged https://matrix.org/docs/spec/client_server/r0.6.1#m-room-message-feedback
  EventType["RoomMessageFeedback"] = "m.room.message.feedback";
  EventType["Reaction"] = "m.reaction";
  EventType["PollStart"] = "org.matrix.msc3381.poll.start";
  // Room ephemeral events
  EventType["Typing"] = "m.typing";
  EventType["Receipt"] = "m.receipt";
  EventType["Presence"] = "m.presence";
  // Room account_data events
  EventType["FullyRead"] = "m.fully_read";
  EventType["Tag"] = "m.tag";
  EventType["SpaceOrder"] = "org.matrix.msc3230.space_order";
  // MSC3230
  // User account_data events
  EventType["PushRules"] = "m.push_rules";
  EventType["Direct"] = "m.direct";
  EventType["IgnoredUserList"] = "m.ignored_user_list";
  // to_device events
  EventType["RoomKey"] = "m.room_key";
  EventType["RoomKeyRequest"] = "m.room_key_request";
  EventType["ForwardedRoomKey"] = "m.forwarded_room_key";
  EventType["Dummy"] = "m.dummy";
  EventType["SecretRequest"] = "m.secret.request";
  EventType["SecretSend"] = "m.secret.send";
  // Group call events
  EventType["GroupCallPrefix"] = "org.matrix.msc3401.call";
  EventType["GroupCallMemberPrefix"] = "org.matrix.msc3401.call.member";
  // MatrixRTC events
  EventType["RTCMembership"] = "org.matrix.msc4143.rtc.member";
  EventType["CallNotify"] = "org.matrix.msc4075.call.notify";
  EventType["RTCNotification"] = "org.matrix.msc4075.rtc.notification";
  EventType["RTCDecline"] = "org.matrix.msc4310.rtc.decline";
  return EventType;
}({});
export var RelationType = /*#__PURE__*/function (RelationType) {
  RelationType["Annotation"] = "m.annotation";
  RelationType["Replace"] = "m.replace";
  RelationType["Reference"] = "m.reference";
  // Don't use this yet: it's only the stable version. The code still assumes we support the unstable prefix and,
  // moreover, our tests currently use the unstable prefix. Use THREAD_RELATION_TYPE.name.
  // Once we support *only* the stable prefix, THREAD_RELATION_TYPE can die and we can switch to this.
  RelationType["Thread"] = "m.thread";
  return RelationType;
}({});
export var MsgType = /*#__PURE__*/function (MsgType) {
  MsgType["Text"] = "m.text";
  MsgType["Emote"] = "m.emote";
  MsgType["Notice"] = "m.notice";
  MsgType["Image"] = "m.image";
  MsgType["File"] = "m.file";
  MsgType["Audio"] = "m.audio";
  MsgType["Location"] = "m.location";
  MsgType["Video"] = "m.video";
  MsgType["KeyVerificationRequest"] = "m.key.verification.request";
  return MsgType;
}({});
export var RoomCreateTypeField = "type";
export var RoomType = /*#__PURE__*/function (RoomType) {
  RoomType["Space"] = "m.space";
  RoomType["UnstableCall"] = "org.matrix.msc3417.call";
  RoomType["ElementVideo"] = "io.element.video";
  return RoomType;
}({});
export var ToDeviceMessageId = "org.matrix.msgid";

/**
 * Identifier for an [MSC3088](https://github.com/matrix-org/matrix-doc/pull/3088)
 * room purpose. Note that this reference is UNSTABLE and subject to breaking changes,
 * including its eventual removal.
 */
export var UNSTABLE_MSC3088_PURPOSE = new UnstableValue("m.room.purpose", "org.matrix.msc3088.purpose");

/**
 * Enabled flag for an [MSC3088](https://github.com/matrix-org/matrix-doc/pull/3088)
 * room purpose. Note that this reference is UNSTABLE and subject to breaking changes,
 * including its eventual removal.
 */
export var UNSTABLE_MSC3088_ENABLED = new UnstableValue("m.enabled", "org.matrix.msc3088.enabled");

/**
 * Subtype for an [MSC3089](https://github.com/matrix-org/matrix-doc/pull/3089) space-room.
 * Note that this reference is UNSTABLE and subject to breaking changes, including its
 * eventual removal.
 */
export var UNSTABLE_MSC3089_TREE_SUBTYPE = new UnstableValue("m.data_tree", "org.matrix.msc3089.data_tree");

/**
 * Leaf type for an event in a [MSC3089](https://github.com/matrix-org/matrix-doc/pull/3089) space-room.
 * Note that this reference is UNSTABLE and subject to breaking changes, including its
 * eventual removal.
 */
export var UNSTABLE_MSC3089_LEAF = new UnstableValue("m.leaf", "org.matrix.msc3089.leaf");

/**
 * Branch (Leaf Reference) type for the index approach in a
 * [MSC3089](https://github.com/matrix-org/matrix-doc/pull/3089) space-room. Note that this reference is
 * UNSTABLE and subject to breaking changes, including its eventual removal.
 */
export var UNSTABLE_MSC3089_BRANCH = new UnstableValue("m.branch", "org.matrix.msc3089.branch");

/**
 * Marker event type to point back at imported historical content in a room. See
 * [MSC2716](https://github.com/matrix-org/matrix-spec-proposals/pull/2716).
 * Note that this reference is UNSTABLE and subject to breaking changes,
 * including its eventual removal.
 */
export var UNSTABLE_MSC2716_MARKER = new UnstableValue("m.room.marker", "org.matrix.msc2716.marker");

/**
 * Name of the request property for relation based redactions.
 * {@link https://github.com/matrix-org/matrix-spec-proposals/pull/3912}
 */
export var MSC3912_RELATION_BASED_REDACTIONS_PROP = new UnstableValue("with_rel_types", "org.matrix.msc3912.with_relations");

/**
 * Functional members type for declaring a purpose of room members (e.g. helpful bots).
 * Note that this reference is UNSTABLE and subject to breaking changes, including its
 * eventual removal.
 *
 * Schema (TypeScript):
 * ```
 * {
 *   service_members?: string[]
 * }
 * ```
 *
 * @example
 * ```
 * {
 *   "service_members": [
 *     "@helperbot:localhost",
 *     "@reminderbot:alice.tdl"
 *   ]
 * }
 * ```
 */
export var UNSTABLE_ELEMENT_FUNCTIONAL_USERS = new UnstableValue("io.element.functional_members", "io.element.functional_members");

/**
 * A type of message that affects visibility of a message,
 * as per https://github.com/matrix-org/matrix-doc/pull/3531
 *
 * @experimental
 */
export var EVENT_VISIBILITY_CHANGE_TYPE = new UnstableValue("m.visibility", "org.matrix.msc3531.visibility");

/**
 * https://github.com/matrix-org/matrix-doc/pull/3881
 *
 * @experimental
 */
export var PUSHER_ENABLED = new UnstableValue("enabled", "org.matrix.msc3881.enabled");

/**
 * https://github.com/matrix-org/matrix-doc/pull/3881
 *
 * @experimental
 */
export var PUSHER_DEVICE_ID = new UnstableValue("device_id", "org.matrix.msc3881.device_id");

/**
 * https://github.com/matrix-org/matrix-doc/pull/3890
 *
 * @experimental
 */
export var LOCAL_NOTIFICATION_SETTINGS_PREFIX = new UnstableValue("m.local_notification_settings", "org.matrix.msc3890.local_notification_settings");

/**
 * https://github.com/matrix-org/matrix-doc/pull/4023
 *
 * @experimental
 */
export var UNSIGNED_THREAD_ID_FIELD = new UnstableValue("thread_id", "org.matrix.msc4023.thread_id");

/**
 * https://github.com/matrix-org/matrix-spec-proposals/pull/4115
 *
 * @experimental
 */
export var UNSIGNED_MEMBERSHIP_FIELD = new NamespacedValue("membership", "io.element.msc4115.membership");

/**
 * Mapped type from event type to content type for all specified non-state room events.
 */

/**
 * Mapped type from event type to content type for all specified room state events.
 */

/**
 * Mapped type from event type to content type for all specified global account_data events.
 */

/**
 * Mapped type from event type to content type for all specified global events encrypted by secret storage.
 *
 * See https://spec.matrix.org/v1.13/client-server-api/#msecret_storagev1aes-hmac-sha2-1
 */
//# sourceMappingURL=event.js.map