const ruleComposer = require("eslint-rule-composer");
const eslint = require("eslint");
const eslintVersion = eslint.ESLint.version;
const rule = (parseInt(eslintVersion, 10) >= 9 ? require("eslint/use-at-your-own-risk").builtinRules : new eslint.Linter().getRules()).get("no-undef");
function isAccessorFieldName(node) {
  const parent = node.parent;
  return (parent.type === "AccessorProperty" || parent.type === "ClassAccessorProperty") && parent.key === node && !parent.computed;
}
module.exports = ruleComposer.filterReports(rule, problem => !isAccessorFieldName(problem.node));

//# sourceMappingURL=no-undef.cjs.map
