(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global = global || self, global.fetchMock = factory());
}(this, (function () { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function commonjsRequire () {
		throw new Error('Dynamic requires are not currently supported by rollup-plugin-commonjs');
	}

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	function getCjsExportFromNamespace (n) {
		return n && n['default'] || n;
	}

	var global$1 = (typeof global !== "undefined" ? global :
	            typeof self !== "undefined" ? self :
	            typeof window !== "undefined" ? window : {});

	// shim for using process in browser
	// based off https://github.com/defunctzombie/node-process/blob/master/browser.js

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	var cachedSetTimeout = defaultSetTimout;
	var cachedClearTimeout = defaultClearTimeout;
	if (typeof global$1.setTimeout === 'function') {
	    cachedSetTimeout = setTimeout;
	}
	if (typeof global$1.clearTimeout === 'function') {
	    cachedClearTimeout = clearTimeout;
	}

	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	function nextTick(fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	}
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	var title = 'browser';
	var platform = 'browser';
	var browser = true;
	var env = {};
	var argv = [];
	var version = ''; // empty string to avoid regexp issues
	var versions = {};
	var release = {};
	var config = {};

	function noop() {}

	var on = noop;
	var addListener = noop;
	var once = noop;
	var off = noop;
	var removeListener = noop;
	var removeAllListeners = noop;
	var emit = noop;

	function binding(name) {
	    throw new Error('process.binding is not supported');
	}

	function cwd () { return '/' }
	function chdir (dir) {
	    throw new Error('process.chdir is not supported');
	}function umask() { return 0; }

	// from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
	var performance = global$1.performance || {};
	var performanceNow =
	  performance.now        ||
	  performance.mozNow     ||
	  performance.msNow      ||
	  performance.oNow       ||
	  performance.webkitNow  ||
	  function(){ return (new Date()).getTime() };

	// generate timestamp or delta
	// see http://nodejs.org/api/process.html#process_process_hrtime
	function hrtime(previousTimestamp){
	  var clocktime = performanceNow.call(performance)*1e-3;
	  var seconds = Math.floor(clocktime);
	  var nanoseconds = Math.floor((clocktime%1)*1e9);
	  if (previousTimestamp) {
	    seconds = seconds - previousTimestamp[0];
	    nanoseconds = nanoseconds - previousTimestamp[1];
	    if (nanoseconds<0) {
	      seconds--;
	      nanoseconds += 1e9;
	    }
	  }
	  return [seconds,nanoseconds]
	}

	var startTime = new Date();
	function uptime() {
	  var currentTime = new Date();
	  var dif = currentTime - startTime;
	  return dif / 1000;
	}

	var process = {
	  nextTick: nextTick,
	  title: title,
	  browser: browser,
	  env: env,
	  argv: argv,
	  version: version,
	  versions: versions,
	  on: on,
	  addListener: addListener,
	  once: once,
	  off: off,
	  removeListener: removeListener,
	  removeAllListeners: removeAllListeners,
	  emit: emit,
	  binding: binding,
	  cwd: cwd,
	  chdir: chdir,
	  umask: umask,
	  hrtime: hrtime,
	  platform: platform,
	  release: release,
	  config: config,
	  uptime: uptime
	};

	var shallowEqual_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = shallowEqual;

	function shallowEqual(actual, expected) {
	  const keys = Object.keys(expected);

	  for (const key of keys) {
	    if (actual[key] !== expected[key]) {
	      return false;
	    }
	  }

	  return true;
	}
	});

	unwrapExports(shallowEqual_1);

	var generated = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.isArrayExpression = isArrayExpression;
	exports.isAssignmentExpression = isAssignmentExpression;
	exports.isBinaryExpression = isBinaryExpression;
	exports.isInterpreterDirective = isInterpreterDirective;
	exports.isDirective = isDirective;
	exports.isDirectiveLiteral = isDirectiveLiteral;
	exports.isBlockStatement = isBlockStatement;
	exports.isBreakStatement = isBreakStatement;
	exports.isCallExpression = isCallExpression;
	exports.isCatchClause = isCatchClause;
	exports.isConditionalExpression = isConditionalExpression;
	exports.isContinueStatement = isContinueStatement;
	exports.isDebuggerStatement = isDebuggerStatement;
	exports.isDoWhileStatement = isDoWhileStatement;
	exports.isEmptyStatement = isEmptyStatement;
	exports.isExpressionStatement = isExpressionStatement;
	exports.isFile = isFile;
	exports.isForInStatement = isForInStatement;
	exports.isForStatement = isForStatement;
	exports.isFunctionDeclaration = isFunctionDeclaration;
	exports.isFunctionExpression = isFunctionExpression;
	exports.isIdentifier = isIdentifier;
	exports.isIfStatement = isIfStatement;
	exports.isLabeledStatement = isLabeledStatement;
	exports.isStringLiteral = isStringLiteral;
	exports.isNumericLiteral = isNumericLiteral;
	exports.isNullLiteral = isNullLiteral;
	exports.isBooleanLiteral = isBooleanLiteral;
	exports.isRegExpLiteral = isRegExpLiteral;
	exports.isLogicalExpression = isLogicalExpression;
	exports.isMemberExpression = isMemberExpression;
	exports.isNewExpression = isNewExpression;
	exports.isProgram = isProgram;
	exports.isObjectExpression = isObjectExpression;
	exports.isObjectMethod = isObjectMethod;
	exports.isObjectProperty = isObjectProperty;
	exports.isRestElement = isRestElement;
	exports.isReturnStatement = isReturnStatement;
	exports.isSequenceExpression = isSequenceExpression;
	exports.isParenthesizedExpression = isParenthesizedExpression;
	exports.isSwitchCase = isSwitchCase;
	exports.isSwitchStatement = isSwitchStatement;
	exports.isThisExpression = isThisExpression;
	exports.isThrowStatement = isThrowStatement;
	exports.isTryStatement = isTryStatement;
	exports.isUnaryExpression = isUnaryExpression;
	exports.isUpdateExpression = isUpdateExpression;
	exports.isVariableDeclaration = isVariableDeclaration;
	exports.isVariableDeclarator = isVariableDeclarator;
	exports.isWhileStatement = isWhileStatement;
	exports.isWithStatement = isWithStatement;
	exports.isAssignmentPattern = isAssignmentPattern;
	exports.isArrayPattern = isArrayPattern;
	exports.isArrowFunctionExpression = isArrowFunctionExpression;
	exports.isClassBody = isClassBody;
	exports.isClassExpression = isClassExpression;
	exports.isClassDeclaration = isClassDeclaration;
	exports.isExportAllDeclaration = isExportAllDeclaration;
	exports.isExportDefaultDeclaration = isExportDefaultDeclaration;
	exports.isExportNamedDeclaration = isExportNamedDeclaration;
	exports.isExportSpecifier = isExportSpecifier;
	exports.isForOfStatement = isForOfStatement;
	exports.isImportDeclaration = isImportDeclaration;
	exports.isImportDefaultSpecifier = isImportDefaultSpecifier;
	exports.isImportNamespaceSpecifier = isImportNamespaceSpecifier;
	exports.isImportSpecifier = isImportSpecifier;
	exports.isMetaProperty = isMetaProperty;
	exports.isClassMethod = isClassMethod;
	exports.isObjectPattern = isObjectPattern;
	exports.isSpreadElement = isSpreadElement;
	exports.isSuper = isSuper;
	exports.isTaggedTemplateExpression = isTaggedTemplateExpression;
	exports.isTemplateElement = isTemplateElement;
	exports.isTemplateLiteral = isTemplateLiteral;
	exports.isYieldExpression = isYieldExpression;
	exports.isAwaitExpression = isAwaitExpression;
	exports.isImport = isImport;
	exports.isBigIntLiteral = isBigIntLiteral;
	exports.isExportNamespaceSpecifier = isExportNamespaceSpecifier;
	exports.isOptionalMemberExpression = isOptionalMemberExpression;
	exports.isOptionalCallExpression = isOptionalCallExpression;
	exports.isAnyTypeAnnotation = isAnyTypeAnnotation;
	exports.isArrayTypeAnnotation = isArrayTypeAnnotation;
	exports.isBooleanTypeAnnotation = isBooleanTypeAnnotation;
	exports.isBooleanLiteralTypeAnnotation = isBooleanLiteralTypeAnnotation;
	exports.isNullLiteralTypeAnnotation = isNullLiteralTypeAnnotation;
	exports.isClassImplements = isClassImplements;
	exports.isDeclareClass = isDeclareClass;
	exports.isDeclareFunction = isDeclareFunction;
	exports.isDeclareInterface = isDeclareInterface;
	exports.isDeclareModule = isDeclareModule;
	exports.isDeclareModuleExports = isDeclareModuleExports;
	exports.isDeclareTypeAlias = isDeclareTypeAlias;
	exports.isDeclareOpaqueType = isDeclareOpaqueType;
	exports.isDeclareVariable = isDeclareVariable;
	exports.isDeclareExportDeclaration = isDeclareExportDeclaration;
	exports.isDeclareExportAllDeclaration = isDeclareExportAllDeclaration;
	exports.isDeclaredPredicate = isDeclaredPredicate;
	exports.isExistsTypeAnnotation = isExistsTypeAnnotation;
	exports.isFunctionTypeAnnotation = isFunctionTypeAnnotation;
	exports.isFunctionTypeParam = isFunctionTypeParam;
	exports.isGenericTypeAnnotation = isGenericTypeAnnotation;
	exports.isInferredPredicate = isInferredPredicate;
	exports.isInterfaceExtends = isInterfaceExtends;
	exports.isInterfaceDeclaration = isInterfaceDeclaration;
	exports.isInterfaceTypeAnnotation = isInterfaceTypeAnnotation;
	exports.isIntersectionTypeAnnotation = isIntersectionTypeAnnotation;
	exports.isMixedTypeAnnotation = isMixedTypeAnnotation;
	exports.isEmptyTypeAnnotation = isEmptyTypeAnnotation;
	exports.isNullableTypeAnnotation = isNullableTypeAnnotation;
	exports.isNumberLiteralTypeAnnotation = isNumberLiteralTypeAnnotation;
	exports.isNumberTypeAnnotation = isNumberTypeAnnotation;
	exports.isObjectTypeAnnotation = isObjectTypeAnnotation;
	exports.isObjectTypeInternalSlot = isObjectTypeInternalSlot;
	exports.isObjectTypeCallProperty = isObjectTypeCallProperty;
	exports.isObjectTypeIndexer = isObjectTypeIndexer;
	exports.isObjectTypeProperty = isObjectTypeProperty;
	exports.isObjectTypeSpreadProperty = isObjectTypeSpreadProperty;
	exports.isOpaqueType = isOpaqueType;
	exports.isQualifiedTypeIdentifier = isQualifiedTypeIdentifier;
	exports.isStringLiteralTypeAnnotation = isStringLiteralTypeAnnotation;
	exports.isStringTypeAnnotation = isStringTypeAnnotation;
	exports.isSymbolTypeAnnotation = isSymbolTypeAnnotation;
	exports.isThisTypeAnnotation = isThisTypeAnnotation;
	exports.isTupleTypeAnnotation = isTupleTypeAnnotation;
	exports.isTypeofTypeAnnotation = isTypeofTypeAnnotation;
	exports.isTypeAlias = isTypeAlias;
	exports.isTypeAnnotation = isTypeAnnotation;
	exports.isTypeCastExpression = isTypeCastExpression;
	exports.isTypeParameter = isTypeParameter;
	exports.isTypeParameterDeclaration = isTypeParameterDeclaration;
	exports.isTypeParameterInstantiation = isTypeParameterInstantiation;
	exports.isUnionTypeAnnotation = isUnionTypeAnnotation;
	exports.isVariance = isVariance;
	exports.isVoidTypeAnnotation = isVoidTypeAnnotation;
	exports.isEnumDeclaration = isEnumDeclaration;
	exports.isEnumBooleanBody = isEnumBooleanBody;
	exports.isEnumNumberBody = isEnumNumberBody;
	exports.isEnumStringBody = isEnumStringBody;
	exports.isEnumSymbolBody = isEnumSymbolBody;
	exports.isEnumBooleanMember = isEnumBooleanMember;
	exports.isEnumNumberMember = isEnumNumberMember;
	exports.isEnumStringMember = isEnumStringMember;
	exports.isEnumDefaultedMember = isEnumDefaultedMember;
	exports.isJSXAttribute = isJSXAttribute;
	exports.isJSXClosingElement = isJSXClosingElement;
	exports.isJSXElement = isJSXElement;
	exports.isJSXEmptyExpression = isJSXEmptyExpression;
	exports.isJSXExpressionContainer = isJSXExpressionContainer;
	exports.isJSXSpreadChild = isJSXSpreadChild;
	exports.isJSXIdentifier = isJSXIdentifier;
	exports.isJSXMemberExpression = isJSXMemberExpression;
	exports.isJSXNamespacedName = isJSXNamespacedName;
	exports.isJSXOpeningElement = isJSXOpeningElement;
	exports.isJSXSpreadAttribute = isJSXSpreadAttribute;
	exports.isJSXText = isJSXText;
	exports.isJSXFragment = isJSXFragment;
	exports.isJSXOpeningFragment = isJSXOpeningFragment;
	exports.isJSXClosingFragment = isJSXClosingFragment;
	exports.isNoop = isNoop;
	exports.isPlaceholder = isPlaceholder;
	exports.isV8IntrinsicIdentifier = isV8IntrinsicIdentifier;
	exports.isArgumentPlaceholder = isArgumentPlaceholder;
	exports.isBindExpression = isBindExpression;
	exports.isClassProperty = isClassProperty;
	exports.isPipelineTopicExpression = isPipelineTopicExpression;
	exports.isPipelineBareFunction = isPipelineBareFunction;
	exports.isPipelinePrimaryTopicReference = isPipelinePrimaryTopicReference;
	exports.isClassPrivateProperty = isClassPrivateProperty;
	exports.isClassPrivateMethod = isClassPrivateMethod;
	exports.isImportAttribute = isImportAttribute;
	exports.isDecorator = isDecorator;
	exports.isDoExpression = isDoExpression;
	exports.isExportDefaultSpecifier = isExportDefaultSpecifier;
	exports.isPrivateName = isPrivateName;
	exports.isRecordExpression = isRecordExpression;
	exports.isTupleExpression = isTupleExpression;
	exports.isDecimalLiteral = isDecimalLiteral;
	exports.isStaticBlock = isStaticBlock;
	exports.isTSParameterProperty = isTSParameterProperty;
	exports.isTSDeclareFunction = isTSDeclareFunction;
	exports.isTSDeclareMethod = isTSDeclareMethod;
	exports.isTSQualifiedName = isTSQualifiedName;
	exports.isTSCallSignatureDeclaration = isTSCallSignatureDeclaration;
	exports.isTSConstructSignatureDeclaration = isTSConstructSignatureDeclaration;
	exports.isTSPropertySignature = isTSPropertySignature;
	exports.isTSMethodSignature = isTSMethodSignature;
	exports.isTSIndexSignature = isTSIndexSignature;
	exports.isTSAnyKeyword = isTSAnyKeyword;
	exports.isTSBooleanKeyword = isTSBooleanKeyword;
	exports.isTSBigIntKeyword = isTSBigIntKeyword;
	exports.isTSIntrinsicKeyword = isTSIntrinsicKeyword;
	exports.isTSNeverKeyword = isTSNeverKeyword;
	exports.isTSNullKeyword = isTSNullKeyword;
	exports.isTSNumberKeyword = isTSNumberKeyword;
	exports.isTSObjectKeyword = isTSObjectKeyword;
	exports.isTSStringKeyword = isTSStringKeyword;
	exports.isTSSymbolKeyword = isTSSymbolKeyword;
	exports.isTSUndefinedKeyword = isTSUndefinedKeyword;
	exports.isTSUnknownKeyword = isTSUnknownKeyword;
	exports.isTSVoidKeyword = isTSVoidKeyword;
	exports.isTSThisType = isTSThisType;
	exports.isTSFunctionType = isTSFunctionType;
	exports.isTSConstructorType = isTSConstructorType;
	exports.isTSTypeReference = isTSTypeReference;
	exports.isTSTypePredicate = isTSTypePredicate;
	exports.isTSTypeQuery = isTSTypeQuery;
	exports.isTSTypeLiteral = isTSTypeLiteral;
	exports.isTSArrayType = isTSArrayType;
	exports.isTSTupleType = isTSTupleType;
	exports.isTSOptionalType = isTSOptionalType;
	exports.isTSRestType = isTSRestType;
	exports.isTSNamedTupleMember = isTSNamedTupleMember;
	exports.isTSUnionType = isTSUnionType;
	exports.isTSIntersectionType = isTSIntersectionType;
	exports.isTSConditionalType = isTSConditionalType;
	exports.isTSInferType = isTSInferType;
	exports.isTSParenthesizedType = isTSParenthesizedType;
	exports.isTSTypeOperator = isTSTypeOperator;
	exports.isTSIndexedAccessType = isTSIndexedAccessType;
	exports.isTSMappedType = isTSMappedType;
	exports.isTSLiteralType = isTSLiteralType;
	exports.isTSExpressionWithTypeArguments = isTSExpressionWithTypeArguments;
	exports.isTSInterfaceDeclaration = isTSInterfaceDeclaration;
	exports.isTSInterfaceBody = isTSInterfaceBody;
	exports.isTSTypeAliasDeclaration = isTSTypeAliasDeclaration;
	exports.isTSAsExpression = isTSAsExpression;
	exports.isTSTypeAssertion = isTSTypeAssertion;
	exports.isTSEnumDeclaration = isTSEnumDeclaration;
	exports.isTSEnumMember = isTSEnumMember;
	exports.isTSModuleDeclaration = isTSModuleDeclaration;
	exports.isTSModuleBlock = isTSModuleBlock;
	exports.isTSImportType = isTSImportType;
	exports.isTSImportEqualsDeclaration = isTSImportEqualsDeclaration;
	exports.isTSExternalModuleReference = isTSExternalModuleReference;
	exports.isTSNonNullExpression = isTSNonNullExpression;
	exports.isTSExportAssignment = isTSExportAssignment;
	exports.isTSNamespaceExportDeclaration = isTSNamespaceExportDeclaration;
	exports.isTSTypeAnnotation = isTSTypeAnnotation;
	exports.isTSTypeParameterInstantiation = isTSTypeParameterInstantiation;
	exports.isTSTypeParameterDeclaration = isTSTypeParameterDeclaration;
	exports.isTSTypeParameter = isTSTypeParameter;
	exports.isExpression = isExpression;
	exports.isBinary = isBinary;
	exports.isScopable = isScopable;
	exports.isBlockParent = isBlockParent;
	exports.isBlock = isBlock;
	exports.isStatement = isStatement;
	exports.isTerminatorless = isTerminatorless;
	exports.isCompletionStatement = isCompletionStatement;
	exports.isConditional = isConditional;
	exports.isLoop = isLoop;
	exports.isWhile = isWhile;
	exports.isExpressionWrapper = isExpressionWrapper;
	exports.isFor = isFor;
	exports.isForXStatement = isForXStatement;
	exports.isFunction = isFunction;
	exports.isFunctionParent = isFunctionParent;
	exports.isPureish = isPureish;
	exports.isDeclaration = isDeclaration;
	exports.isPatternLike = isPatternLike;
	exports.isLVal = isLVal;
	exports.isTSEntityName = isTSEntityName;
	exports.isLiteral = isLiteral;
	exports.isImmutable = isImmutable;
	exports.isUserWhitespacable = isUserWhitespacable;
	exports.isMethod = isMethod;
	exports.isObjectMember = isObjectMember;
	exports.isProperty = isProperty;
	exports.isUnaryLike = isUnaryLike;
	exports.isPattern = isPattern;
	exports.isClass = isClass;
	exports.isModuleDeclaration = isModuleDeclaration;
	exports.isExportDeclaration = isExportDeclaration;
	exports.isModuleSpecifier = isModuleSpecifier;
	exports.isFlow = isFlow;
	exports.isFlowType = isFlowType;
	exports.isFlowBaseAnnotation = isFlowBaseAnnotation;
	exports.isFlowDeclaration = isFlowDeclaration;
	exports.isFlowPredicate = isFlowPredicate;
	exports.isEnumBody = isEnumBody;
	exports.isEnumMember = isEnumMember;
	exports.isJSX = isJSX;
	exports.isPrivate = isPrivate;
	exports.isTSTypeElement = isTSTypeElement;
	exports.isTSType = isTSType;
	exports.isTSBaseType = isTSBaseType;
	exports.isNumberLiteral = isNumberLiteral;
	exports.isRegexLiteral = isRegexLiteral;
	exports.isRestProperty = isRestProperty;
	exports.isSpreadProperty = isSpreadProperty;

	var _shallowEqual = _interopRequireDefault(shallowEqual_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function isArrayExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ArrayExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isAssignmentExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "AssignmentExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBinaryExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BinaryExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isInterpreterDirective(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "InterpreterDirective") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDirective(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Directive") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDirectiveLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DirectiveLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBlockStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BlockStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBreakStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BreakStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isCallExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "CallExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isCatchClause(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "CatchClause") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isConditionalExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ConditionalExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isContinueStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ContinueStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDebuggerStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DebuggerStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDoWhileStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DoWhileStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEmptyStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EmptyStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExpressionStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExpressionStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFile(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "File") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isForInStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ForInStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isForStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ForStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFunctionDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FunctionDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFunctionExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FunctionExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isIdentifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Identifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isIfStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "IfStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isLabeledStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "LabeledStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isStringLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "StringLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNumericLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NumericLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNullLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NullLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBooleanLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BooleanLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isRegExpLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "RegExpLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isLogicalExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "LogicalExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isMemberExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "MemberExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNewExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NewExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isProgram(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Program") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectMethod(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectMethod") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isRestElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "RestElement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isReturnStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ReturnStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSequenceExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "SequenceExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isParenthesizedExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ParenthesizedExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSwitchCase(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "SwitchCase") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSwitchStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "SwitchStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isThisExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ThisExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isThrowStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ThrowStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTryStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TryStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isUnaryExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "UnaryExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isUpdateExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "UpdateExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isVariableDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "VariableDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isVariableDeclarator(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "VariableDeclarator") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isWhileStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "WhileStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isWithStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "WithStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isAssignmentPattern(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "AssignmentPattern") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isArrayPattern(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ArrayPattern") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isArrowFunctionExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ArrowFunctionExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassBody") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportAllDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportAllDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportDefaultDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportDefaultDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportNamedDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportNamedDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportSpecifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isForOfStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ForOfStatement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImportDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ImportDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImportDefaultSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ImportDefaultSpecifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImportNamespaceSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ImportNamespaceSpecifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImportSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ImportSpecifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isMetaProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "MetaProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassMethod(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassMethod") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectPattern(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectPattern") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSpreadElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "SpreadElement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSuper(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Super") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTaggedTemplateExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TaggedTemplateExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTemplateElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TemplateElement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTemplateLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TemplateLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isYieldExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "YieldExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isAwaitExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "AwaitExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImport(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Import") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBigIntLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BigIntLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportNamespaceSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportNamespaceSpecifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isOptionalMemberExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "OptionalMemberExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isOptionalCallExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "OptionalCallExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isAnyTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "AnyTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isArrayTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ArrayTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBooleanTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BooleanTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBooleanLiteralTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BooleanLiteralTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNullLiteralTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NullLiteralTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassImplements(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassImplements") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareClass(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareClass") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareFunction(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareFunction") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareInterface(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareInterface") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareModule(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareModule") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareModuleExports(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareModuleExports") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareTypeAlias(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareTypeAlias") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareOpaqueType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareOpaqueType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareVariable(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareVariable") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareExportDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareExportDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclareExportAllDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclareExportAllDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclaredPredicate(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DeclaredPredicate") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExistsTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExistsTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFunctionTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FunctionTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFunctionTypeParam(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FunctionTypeParam") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isGenericTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "GenericTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isInferredPredicate(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "InferredPredicate") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isInterfaceExtends(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "InterfaceExtends") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isInterfaceDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "InterfaceDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isInterfaceTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "InterfaceTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isIntersectionTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "IntersectionTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isMixedTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "MixedTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEmptyTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EmptyTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNullableTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NullableTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNumberLiteralTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NumberLiteralTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNumberTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NumberTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectTypeInternalSlot(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectTypeInternalSlot") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectTypeCallProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectTypeCallProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectTypeIndexer(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectTypeIndexer") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectTypeProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectTypeProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectTypeSpreadProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectTypeSpreadProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isOpaqueType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "OpaqueType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isQualifiedTypeIdentifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "QualifiedTypeIdentifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isStringLiteralTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "StringLiteralTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isStringTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "StringTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSymbolTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "SymbolTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isThisTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ThisTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTupleTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TupleTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeofTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeofTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeAlias(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeAlias") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeCastExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeCastExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeParameter(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeParameter") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeParameterDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeParameterDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTypeParameterInstantiation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TypeParameterInstantiation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isUnionTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "UnionTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isVariance(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Variance") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isVoidTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "VoidTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumBooleanBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumBooleanBody") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumNumberBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumNumberBody") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumStringBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumStringBody") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumSymbolBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumSymbolBody") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumBooleanMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumBooleanMember") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumNumberMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumNumberMember") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumStringMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumStringMember") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumDefaultedMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumDefaultedMember") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXAttribute(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXAttribute") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXClosingElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXClosingElement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXElement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXEmptyExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXEmptyExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXExpressionContainer(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXExpressionContainer") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXSpreadChild(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXSpreadChild") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXIdentifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXIdentifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXMemberExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXMemberExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXNamespacedName(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXNamespacedName") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXOpeningElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXOpeningElement") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXSpreadAttribute(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXSpreadAttribute") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXText(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXText") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXFragment(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXFragment") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXOpeningFragment(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXOpeningFragment") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSXClosingFragment(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSXClosingFragment") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNoop(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Noop") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPlaceholder(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Placeholder") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isV8IntrinsicIdentifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "V8IntrinsicIdentifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isArgumentPlaceholder(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ArgumentPlaceholder") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBindExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BindExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPipelineTopicExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "PipelineTopicExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPipelineBareFunction(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "PipelineBareFunction") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPipelinePrimaryTopicReference(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "PipelinePrimaryTopicReference") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassPrivateProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassPrivateProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClassPrivateMethod(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ClassPrivateMethod") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImportAttribute(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ImportAttribute") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDecorator(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Decorator") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDoExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DoExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportDefaultSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportDefaultSpecifier") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPrivateName(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "PrivateName") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isRecordExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "RecordExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTupleExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TupleExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDecimalLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "DecimalLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isStaticBlock(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "StaticBlock") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSParameterProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSParameterProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSDeclareFunction(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSDeclareFunction") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSDeclareMethod(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSDeclareMethod") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSQualifiedName(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSQualifiedName") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSCallSignatureDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSCallSignatureDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSConstructSignatureDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSConstructSignatureDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSPropertySignature(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSPropertySignature") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSMethodSignature(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSMethodSignature") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSIndexSignature(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSIndexSignature") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSAnyKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSAnyKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSBooleanKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSBooleanKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSBigIntKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSBigIntKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSIntrinsicKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSIntrinsicKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSNeverKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSNeverKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSNullKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSNullKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSNumberKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSNumberKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSObjectKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSObjectKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSStringKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSStringKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSSymbolKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSSymbolKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSUndefinedKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSUndefinedKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSUnknownKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSUnknownKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSVoidKeyword(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSVoidKeyword") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSThisType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSThisType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSFunctionType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSFunctionType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSConstructorType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSConstructorType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeReference(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeReference") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypePredicate(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypePredicate") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeQuery(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeQuery") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSArrayType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSArrayType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTupleType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTupleType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSOptionalType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSOptionalType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSRestType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSRestType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSNamedTupleMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSNamedTupleMember") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSUnionType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSUnionType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSIntersectionType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSIntersectionType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSConditionalType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSConditionalType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSInferType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSInferType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSParenthesizedType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSParenthesizedType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeOperator(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeOperator") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSIndexedAccessType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSIndexedAccessType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSMappedType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSMappedType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSLiteralType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSLiteralType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSExpressionWithTypeArguments(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSExpressionWithTypeArguments") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSInterfaceDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSInterfaceDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSInterfaceBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSInterfaceBody") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeAliasDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeAliasDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSAsExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSAsExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeAssertion(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeAssertion") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSEnumDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSEnumDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSEnumMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSEnumMember") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSModuleDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSModuleDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSModuleBlock(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSModuleBlock") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSImportType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSImportType") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSImportEqualsDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSImportEqualsDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSExternalModuleReference(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSExternalModuleReference") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSNonNullExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSNonNullExpression") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSExportAssignment(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSExportAssignment") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSNamespaceExportDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSNamespaceExportDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeAnnotation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeParameterInstantiation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeParameterInstantiation") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeParameterDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeParameterDeclaration") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeParameter(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeParameter") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExpression(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Expression" || "ArrayExpression" === nodeType || "AssignmentExpression" === nodeType || "BinaryExpression" === nodeType || "CallExpression" === nodeType || "ConditionalExpression" === nodeType || "FunctionExpression" === nodeType || "Identifier" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "LogicalExpression" === nodeType || "MemberExpression" === nodeType || "NewExpression" === nodeType || "ObjectExpression" === nodeType || "SequenceExpression" === nodeType || "ParenthesizedExpression" === nodeType || "ThisExpression" === nodeType || "UnaryExpression" === nodeType || "UpdateExpression" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "MetaProperty" === nodeType || "Super" === nodeType || "TaggedTemplateExpression" === nodeType || "TemplateLiteral" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType || "Import" === nodeType || "BigIntLiteral" === nodeType || "OptionalMemberExpression" === nodeType || "OptionalCallExpression" === nodeType || "TypeCastExpression" === nodeType || "JSXElement" === nodeType || "JSXFragment" === nodeType || "BindExpression" === nodeType || "PipelinePrimaryTopicReference" === nodeType || "DoExpression" === nodeType || "RecordExpression" === nodeType || "TupleExpression" === nodeType || "DecimalLiteral" === nodeType || "TSAsExpression" === nodeType || "TSTypeAssertion" === nodeType || "TSNonNullExpression" === nodeType || nodeType === "Placeholder" && ("Expression" === node.expectedNode || "Identifier" === node.expectedNode || "StringLiteral" === node.expectedNode)) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBinary(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Binary" || "BinaryExpression" === nodeType || "LogicalExpression" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isScopable(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Scopable" || "BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "ClassDeclaration" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "StaticBlock" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBlockParent(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "BlockParent" || "BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "StaticBlock" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isBlock(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Block" || "BlockStatement" === nodeType || "Program" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Statement" || "BlockStatement" === nodeType || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "DebuggerStatement" === nodeType || "DoWhileStatement" === nodeType || "EmptyStatement" === nodeType || "ExpressionStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "IfStatement" === nodeType || "LabeledStatement" === nodeType || "ReturnStatement" === nodeType || "SwitchStatement" === nodeType || "ThrowStatement" === nodeType || "TryStatement" === nodeType || "VariableDeclaration" === nodeType || "WhileStatement" === nodeType || "WithStatement" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ForOfStatement" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || "TSImportEqualsDeclaration" === nodeType || "TSExportAssignment" === nodeType || "TSNamespaceExportDeclaration" === nodeType || nodeType === "Placeholder" && ("Statement" === node.expectedNode || "Declaration" === node.expectedNode || "BlockStatement" === node.expectedNode)) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTerminatorless(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Terminatorless" || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isCompletionStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "CompletionStatement" || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isConditional(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Conditional" || "ConditionalExpression" === nodeType || "IfStatement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isLoop(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Loop" || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "WhileStatement" === nodeType || "ForOfStatement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isWhile(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "While" || "DoWhileStatement" === nodeType || "WhileStatement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExpressionWrapper(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExpressionWrapper" || "ExpressionStatement" === nodeType || "ParenthesizedExpression" === nodeType || "TypeCastExpression" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFor(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "For" || "ForInStatement" === nodeType || "ForStatement" === nodeType || "ForOfStatement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isForXStatement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ForXStatement" || "ForInStatement" === nodeType || "ForOfStatement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFunction(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Function" || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFunctionParent(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FunctionParent" || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPureish(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Pureish" || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "ArrowFunctionExpression" === nodeType || "BigIntLiteral" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Declaration" || "FunctionDeclaration" === nodeType || "VariableDeclaration" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || nodeType === "Placeholder" && "Declaration" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPatternLike(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "PatternLike" || "Identifier" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isLVal(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "LVal" || "Identifier" === nodeType || "MemberExpression" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || "TSParameterProperty" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSEntityName(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSEntityName" || "Identifier" === nodeType || "TSQualifiedName" === nodeType || nodeType === "Placeholder" && "Identifier" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isLiteral(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Literal" || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "TemplateLiteral" === nodeType || "BigIntLiteral" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isImmutable(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Immutable" || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "BigIntLiteral" === nodeType || "JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXOpeningElement" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isUserWhitespacable(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "UserWhitespacable" || "ObjectMethod" === nodeType || "ObjectProperty" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isMethod(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Method" || "ObjectMethod" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isObjectMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ObjectMember" || "ObjectMethod" === nodeType || "ObjectProperty" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isProperty(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Property" || "ObjectProperty" === nodeType || "ClassProperty" === nodeType || "ClassPrivateProperty" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isUnaryLike(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "UnaryLike" || "UnaryExpression" === nodeType || "SpreadElement" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPattern(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Pattern" || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && "Pattern" === node.expectedNode) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isClass(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Class" || "ClassExpression" === nodeType || "ClassDeclaration" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isModuleDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ModuleDeclaration" || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isExportDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ExportDeclaration" || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isModuleSpecifier(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "ModuleSpecifier" || "ExportSpecifier" === nodeType || "ImportDefaultSpecifier" === nodeType || "ImportNamespaceSpecifier" === nodeType || "ImportSpecifier" === nodeType || "ExportNamespaceSpecifier" === nodeType || "ExportDefaultSpecifier" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFlow(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Flow" || "AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ClassImplements" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "DeclaredPredicate" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "FunctionTypeParam" === nodeType || "GenericTypeAnnotation" === nodeType || "InferredPredicate" === nodeType || "InterfaceExtends" === nodeType || "InterfaceDeclaration" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType || "OpaqueType" === nodeType || "QualifiedTypeIdentifier" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "TypeAlias" === nodeType || "TypeAnnotation" === nodeType || "TypeCastExpression" === nodeType || "TypeParameter" === nodeType || "TypeParameterDeclaration" === nodeType || "TypeParameterInstantiation" === nodeType || "UnionTypeAnnotation" === nodeType || "Variance" === nodeType || "VoidTypeAnnotation" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFlowType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FlowType" || "AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "GenericTypeAnnotation" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "UnionTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFlowBaseAnnotation(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FlowBaseAnnotation" || "AnyTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFlowDeclaration(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FlowDeclaration" || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isFlowPredicate(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "FlowPredicate" || "DeclaredPredicate" === nodeType || "InferredPredicate" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumBody(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumBody" || "EnumBooleanBody" === nodeType || "EnumNumberBody" === nodeType || "EnumStringBody" === nodeType || "EnumSymbolBody" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isEnumMember(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "EnumMember" || "EnumBooleanMember" === nodeType || "EnumNumberMember" === nodeType || "EnumStringMember" === nodeType || "EnumDefaultedMember" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isJSX(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "JSX" || "JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXEmptyExpression" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXIdentifier" === nodeType || "JSXMemberExpression" === nodeType || "JSXNamespacedName" === nodeType || "JSXOpeningElement" === nodeType || "JSXSpreadAttribute" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isPrivate(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "Private" || "ClassPrivateProperty" === nodeType || "ClassPrivateMethod" === nodeType || "PrivateName" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSTypeElement(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSTypeElement" || "TSCallSignatureDeclaration" === nodeType || "TSConstructSignatureDeclaration" === nodeType || "TSPropertySignature" === nodeType || "TSMethodSignature" === nodeType || "TSIndexSignature" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSType" || "TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSIntrinsicKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSFunctionType" === nodeType || "TSConstructorType" === nodeType || "TSTypeReference" === nodeType || "TSTypePredicate" === nodeType || "TSTypeQuery" === nodeType || "TSTypeLiteral" === nodeType || "TSArrayType" === nodeType || "TSTupleType" === nodeType || "TSOptionalType" === nodeType || "TSRestType" === nodeType || "TSUnionType" === nodeType || "TSIntersectionType" === nodeType || "TSConditionalType" === nodeType || "TSInferType" === nodeType || "TSParenthesizedType" === nodeType || "TSTypeOperator" === nodeType || "TSIndexedAccessType" === nodeType || "TSMappedType" === nodeType || "TSLiteralType" === nodeType || "TSExpressionWithTypeArguments" === nodeType || "TSImportType" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isTSBaseType(node, opts) {
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "TSBaseType" || "TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSIntrinsicKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSLiteralType" === nodeType) {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isNumberLiteral(node, opts) {
	  console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "NumberLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isRegexLiteral(node, opts) {
	  console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "RegexLiteral") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isRestProperty(node, opts) {
	  console.trace("The node type RestProperty has been renamed to RestElement");
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "RestProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}

	function isSpreadProperty(node, opts) {
	  console.trace("The node type SpreadProperty has been renamed to SpreadElement");
	  if (!node) return false;
	  const nodeType = node.type;

	  if (nodeType === "SpreadProperty") {
	    if (typeof opts === "undefined") {
	      return true;
	    } else {
	      return (0, _shallowEqual.default)(node, opts);
	    }
	  }

	  return false;
	}
	});

	unwrapExports(generated);
	var generated_1 = generated.isArrayExpression;
	var generated_2 = generated.isAssignmentExpression;
	var generated_3 = generated.isBinaryExpression;
	var generated_4 = generated.isInterpreterDirective;
	var generated_5 = generated.isDirective;
	var generated_6 = generated.isDirectiveLiteral;
	var generated_7 = generated.isBlockStatement;
	var generated_8 = generated.isBreakStatement;
	var generated_9 = generated.isCallExpression;
	var generated_10 = generated.isCatchClause;
	var generated_11 = generated.isConditionalExpression;
	var generated_12 = generated.isContinueStatement;
	var generated_13 = generated.isDebuggerStatement;
	var generated_14 = generated.isDoWhileStatement;
	var generated_15 = generated.isEmptyStatement;
	var generated_16 = generated.isExpressionStatement;
	var generated_17 = generated.isFile;
	var generated_18 = generated.isForInStatement;
	var generated_19 = generated.isForStatement;
	var generated_20 = generated.isFunctionDeclaration;
	var generated_21 = generated.isFunctionExpression;
	var generated_22 = generated.isIdentifier;
	var generated_23 = generated.isIfStatement;
	var generated_24 = generated.isLabeledStatement;
	var generated_25 = generated.isStringLiteral;
	var generated_26 = generated.isNumericLiteral;
	var generated_27 = generated.isNullLiteral;
	var generated_28 = generated.isBooleanLiteral;
	var generated_29 = generated.isRegExpLiteral;
	var generated_30 = generated.isLogicalExpression;
	var generated_31 = generated.isMemberExpression;
	var generated_32 = generated.isNewExpression;
	var generated_33 = generated.isProgram;
	var generated_34 = generated.isObjectExpression;
	var generated_35 = generated.isObjectMethod;
	var generated_36 = generated.isObjectProperty;
	var generated_37 = generated.isRestElement;
	var generated_38 = generated.isReturnStatement;
	var generated_39 = generated.isSequenceExpression;
	var generated_40 = generated.isParenthesizedExpression;
	var generated_41 = generated.isSwitchCase;
	var generated_42 = generated.isSwitchStatement;
	var generated_43 = generated.isThisExpression;
	var generated_44 = generated.isThrowStatement;
	var generated_45 = generated.isTryStatement;
	var generated_46 = generated.isUnaryExpression;
	var generated_47 = generated.isUpdateExpression;
	var generated_48 = generated.isVariableDeclaration;
	var generated_49 = generated.isVariableDeclarator;
	var generated_50 = generated.isWhileStatement;
	var generated_51 = generated.isWithStatement;
	var generated_52 = generated.isAssignmentPattern;
	var generated_53 = generated.isArrayPattern;
	var generated_54 = generated.isArrowFunctionExpression;
	var generated_55 = generated.isClassBody;
	var generated_56 = generated.isClassExpression;
	var generated_57 = generated.isClassDeclaration;
	var generated_58 = generated.isExportAllDeclaration;
	var generated_59 = generated.isExportDefaultDeclaration;
	var generated_60 = generated.isExportNamedDeclaration;
	var generated_61 = generated.isExportSpecifier;
	var generated_62 = generated.isForOfStatement;
	var generated_63 = generated.isImportDeclaration;
	var generated_64 = generated.isImportDefaultSpecifier;
	var generated_65 = generated.isImportNamespaceSpecifier;
	var generated_66 = generated.isImportSpecifier;
	var generated_67 = generated.isMetaProperty;
	var generated_68 = generated.isClassMethod;
	var generated_69 = generated.isObjectPattern;
	var generated_70 = generated.isSpreadElement;
	var generated_71 = generated.isSuper;
	var generated_72 = generated.isTaggedTemplateExpression;
	var generated_73 = generated.isTemplateElement;
	var generated_74 = generated.isTemplateLiteral;
	var generated_75 = generated.isYieldExpression;
	var generated_76 = generated.isAwaitExpression;
	var generated_77 = generated.isImport;
	var generated_78 = generated.isBigIntLiteral;
	var generated_79 = generated.isExportNamespaceSpecifier;
	var generated_80 = generated.isOptionalMemberExpression;
	var generated_81 = generated.isOptionalCallExpression;
	var generated_82 = generated.isAnyTypeAnnotation;
	var generated_83 = generated.isArrayTypeAnnotation;
	var generated_84 = generated.isBooleanTypeAnnotation;
	var generated_85 = generated.isBooleanLiteralTypeAnnotation;
	var generated_86 = generated.isNullLiteralTypeAnnotation;
	var generated_87 = generated.isClassImplements;
	var generated_88 = generated.isDeclareClass;
	var generated_89 = generated.isDeclareFunction;
	var generated_90 = generated.isDeclareInterface;
	var generated_91 = generated.isDeclareModule;
	var generated_92 = generated.isDeclareModuleExports;
	var generated_93 = generated.isDeclareTypeAlias;
	var generated_94 = generated.isDeclareOpaqueType;
	var generated_95 = generated.isDeclareVariable;
	var generated_96 = generated.isDeclareExportDeclaration;
	var generated_97 = generated.isDeclareExportAllDeclaration;
	var generated_98 = generated.isDeclaredPredicate;
	var generated_99 = generated.isExistsTypeAnnotation;
	var generated_100 = generated.isFunctionTypeAnnotation;
	var generated_101 = generated.isFunctionTypeParam;
	var generated_102 = generated.isGenericTypeAnnotation;
	var generated_103 = generated.isInferredPredicate;
	var generated_104 = generated.isInterfaceExtends;
	var generated_105 = generated.isInterfaceDeclaration;
	var generated_106 = generated.isInterfaceTypeAnnotation;
	var generated_107 = generated.isIntersectionTypeAnnotation;
	var generated_108 = generated.isMixedTypeAnnotation;
	var generated_109 = generated.isEmptyTypeAnnotation;
	var generated_110 = generated.isNullableTypeAnnotation;
	var generated_111 = generated.isNumberLiteralTypeAnnotation;
	var generated_112 = generated.isNumberTypeAnnotation;
	var generated_113 = generated.isObjectTypeAnnotation;
	var generated_114 = generated.isObjectTypeInternalSlot;
	var generated_115 = generated.isObjectTypeCallProperty;
	var generated_116 = generated.isObjectTypeIndexer;
	var generated_117 = generated.isObjectTypeProperty;
	var generated_118 = generated.isObjectTypeSpreadProperty;
	var generated_119 = generated.isOpaqueType;
	var generated_120 = generated.isQualifiedTypeIdentifier;
	var generated_121 = generated.isStringLiteralTypeAnnotation;
	var generated_122 = generated.isStringTypeAnnotation;
	var generated_123 = generated.isSymbolTypeAnnotation;
	var generated_124 = generated.isThisTypeAnnotation;
	var generated_125 = generated.isTupleTypeAnnotation;
	var generated_126 = generated.isTypeofTypeAnnotation;
	var generated_127 = generated.isTypeAlias;
	var generated_128 = generated.isTypeAnnotation;
	var generated_129 = generated.isTypeCastExpression;
	var generated_130 = generated.isTypeParameter;
	var generated_131 = generated.isTypeParameterDeclaration;
	var generated_132 = generated.isTypeParameterInstantiation;
	var generated_133 = generated.isUnionTypeAnnotation;
	var generated_134 = generated.isVariance;
	var generated_135 = generated.isVoidTypeAnnotation;
	var generated_136 = generated.isEnumDeclaration;
	var generated_137 = generated.isEnumBooleanBody;
	var generated_138 = generated.isEnumNumberBody;
	var generated_139 = generated.isEnumStringBody;
	var generated_140 = generated.isEnumSymbolBody;
	var generated_141 = generated.isEnumBooleanMember;
	var generated_142 = generated.isEnumNumberMember;
	var generated_143 = generated.isEnumStringMember;
	var generated_144 = generated.isEnumDefaultedMember;
	var generated_145 = generated.isJSXAttribute;
	var generated_146 = generated.isJSXClosingElement;
	var generated_147 = generated.isJSXElement;
	var generated_148 = generated.isJSXEmptyExpression;
	var generated_149 = generated.isJSXExpressionContainer;
	var generated_150 = generated.isJSXSpreadChild;
	var generated_151 = generated.isJSXIdentifier;
	var generated_152 = generated.isJSXMemberExpression;
	var generated_153 = generated.isJSXNamespacedName;
	var generated_154 = generated.isJSXOpeningElement;
	var generated_155 = generated.isJSXSpreadAttribute;
	var generated_156 = generated.isJSXText;
	var generated_157 = generated.isJSXFragment;
	var generated_158 = generated.isJSXOpeningFragment;
	var generated_159 = generated.isJSXClosingFragment;
	var generated_160 = generated.isNoop;
	var generated_161 = generated.isPlaceholder;
	var generated_162 = generated.isV8IntrinsicIdentifier;
	var generated_163 = generated.isArgumentPlaceholder;
	var generated_164 = generated.isBindExpression;
	var generated_165 = generated.isClassProperty;
	var generated_166 = generated.isPipelineTopicExpression;
	var generated_167 = generated.isPipelineBareFunction;
	var generated_168 = generated.isPipelinePrimaryTopicReference;
	var generated_169 = generated.isClassPrivateProperty;
	var generated_170 = generated.isClassPrivateMethod;
	var generated_171 = generated.isImportAttribute;
	var generated_172 = generated.isDecorator;
	var generated_173 = generated.isDoExpression;
	var generated_174 = generated.isExportDefaultSpecifier;
	var generated_175 = generated.isPrivateName;
	var generated_176 = generated.isRecordExpression;
	var generated_177 = generated.isTupleExpression;
	var generated_178 = generated.isDecimalLiteral;
	var generated_179 = generated.isStaticBlock;
	var generated_180 = generated.isTSParameterProperty;
	var generated_181 = generated.isTSDeclareFunction;
	var generated_182 = generated.isTSDeclareMethod;
	var generated_183 = generated.isTSQualifiedName;
	var generated_184 = generated.isTSCallSignatureDeclaration;
	var generated_185 = generated.isTSConstructSignatureDeclaration;
	var generated_186 = generated.isTSPropertySignature;
	var generated_187 = generated.isTSMethodSignature;
	var generated_188 = generated.isTSIndexSignature;
	var generated_189 = generated.isTSAnyKeyword;
	var generated_190 = generated.isTSBooleanKeyword;
	var generated_191 = generated.isTSBigIntKeyword;
	var generated_192 = generated.isTSIntrinsicKeyword;
	var generated_193 = generated.isTSNeverKeyword;
	var generated_194 = generated.isTSNullKeyword;
	var generated_195 = generated.isTSNumberKeyword;
	var generated_196 = generated.isTSObjectKeyword;
	var generated_197 = generated.isTSStringKeyword;
	var generated_198 = generated.isTSSymbolKeyword;
	var generated_199 = generated.isTSUndefinedKeyword;
	var generated_200 = generated.isTSUnknownKeyword;
	var generated_201 = generated.isTSVoidKeyword;
	var generated_202 = generated.isTSThisType;
	var generated_203 = generated.isTSFunctionType;
	var generated_204 = generated.isTSConstructorType;
	var generated_205 = generated.isTSTypeReference;
	var generated_206 = generated.isTSTypePredicate;
	var generated_207 = generated.isTSTypeQuery;
	var generated_208 = generated.isTSTypeLiteral;
	var generated_209 = generated.isTSArrayType;
	var generated_210 = generated.isTSTupleType;
	var generated_211 = generated.isTSOptionalType;
	var generated_212 = generated.isTSRestType;
	var generated_213 = generated.isTSNamedTupleMember;
	var generated_214 = generated.isTSUnionType;
	var generated_215 = generated.isTSIntersectionType;
	var generated_216 = generated.isTSConditionalType;
	var generated_217 = generated.isTSInferType;
	var generated_218 = generated.isTSParenthesizedType;
	var generated_219 = generated.isTSTypeOperator;
	var generated_220 = generated.isTSIndexedAccessType;
	var generated_221 = generated.isTSMappedType;
	var generated_222 = generated.isTSLiteralType;
	var generated_223 = generated.isTSExpressionWithTypeArguments;
	var generated_224 = generated.isTSInterfaceDeclaration;
	var generated_225 = generated.isTSInterfaceBody;
	var generated_226 = generated.isTSTypeAliasDeclaration;
	var generated_227 = generated.isTSAsExpression;
	var generated_228 = generated.isTSTypeAssertion;
	var generated_229 = generated.isTSEnumDeclaration;
	var generated_230 = generated.isTSEnumMember;
	var generated_231 = generated.isTSModuleDeclaration;
	var generated_232 = generated.isTSModuleBlock;
	var generated_233 = generated.isTSImportType;
	var generated_234 = generated.isTSImportEqualsDeclaration;
	var generated_235 = generated.isTSExternalModuleReference;
	var generated_236 = generated.isTSNonNullExpression;
	var generated_237 = generated.isTSExportAssignment;
	var generated_238 = generated.isTSNamespaceExportDeclaration;
	var generated_239 = generated.isTSTypeAnnotation;
	var generated_240 = generated.isTSTypeParameterInstantiation;
	var generated_241 = generated.isTSTypeParameterDeclaration;
	var generated_242 = generated.isTSTypeParameter;
	var generated_243 = generated.isExpression;
	var generated_244 = generated.isBinary;
	var generated_245 = generated.isScopable;
	var generated_246 = generated.isBlockParent;
	var generated_247 = generated.isBlock;
	var generated_248 = generated.isStatement;
	var generated_249 = generated.isTerminatorless;
	var generated_250 = generated.isCompletionStatement;
	var generated_251 = generated.isConditional;
	var generated_252 = generated.isLoop;
	var generated_253 = generated.isWhile;
	var generated_254 = generated.isExpressionWrapper;
	var generated_255 = generated.isFor;
	var generated_256 = generated.isForXStatement;
	var generated_257 = generated.isFunction;
	var generated_258 = generated.isFunctionParent;
	var generated_259 = generated.isPureish;
	var generated_260 = generated.isDeclaration;
	var generated_261 = generated.isPatternLike;
	var generated_262 = generated.isLVal;
	var generated_263 = generated.isTSEntityName;
	var generated_264 = generated.isLiteral;
	var generated_265 = generated.isImmutable;
	var generated_266 = generated.isUserWhitespacable;
	var generated_267 = generated.isMethod;
	var generated_268 = generated.isObjectMember;
	var generated_269 = generated.isProperty;
	var generated_270 = generated.isUnaryLike;
	var generated_271 = generated.isPattern;
	var generated_272 = generated.isClass;
	var generated_273 = generated.isModuleDeclaration;
	var generated_274 = generated.isExportDeclaration;
	var generated_275 = generated.isModuleSpecifier;
	var generated_276 = generated.isFlow;
	var generated_277 = generated.isFlowType;
	var generated_278 = generated.isFlowBaseAnnotation;
	var generated_279 = generated.isFlowDeclaration;
	var generated_280 = generated.isFlowPredicate;
	var generated_281 = generated.isEnumBody;
	var generated_282 = generated.isEnumMember;
	var generated_283 = generated.isJSX;
	var generated_284 = generated.isPrivate;
	var generated_285 = generated.isTSTypeElement;
	var generated_286 = generated.isTSType;
	var generated_287 = generated.isTSBaseType;
	var generated_288 = generated.isNumberLiteral;
	var generated_289 = generated.isRegexLiteral;
	var generated_290 = generated.isRestProperty;
	var generated_291 = generated.isSpreadProperty;

	var matchesPattern_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = matchesPattern;



	function matchesPattern(member, match, allowPartial) {
	  if (!(0, generated.isMemberExpression)(member)) return false;
	  const parts = Array.isArray(match) ? match : match.split(".");
	  const nodes = [];
	  let node;

	  for (node = member; (0, generated.isMemberExpression)(node); node = node.object) {
	    nodes.push(node.property);
	  }

	  nodes.push(node);
	  if (nodes.length < parts.length) return false;
	  if (!allowPartial && nodes.length > parts.length) return false;

	  for (let i = 0, j = nodes.length - 1; i < parts.length; i++, j--) {
	    const node = nodes[j];
	    let value;

	    if ((0, generated.isIdentifier)(node)) {
	      value = node.name;
	    } else if ((0, generated.isStringLiteral)(node)) {
	      value = node.value;
	    } else {
	      return false;
	    }

	    if (parts[i] !== value) return false;
	  }

	  return true;
	}
	});

	unwrapExports(matchesPattern_1);

	var buildMatchMemberExpression_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = buildMatchMemberExpression;

	var _matchesPattern = _interopRequireDefault(matchesPattern_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function buildMatchMemberExpression(match, allowPartial) {
	  const parts = match.split(".");
	  return member => (0, _matchesPattern.default)(member, parts, allowPartial);
	}
	});

	unwrapExports(buildMatchMemberExpression_1);

	var isReactComponent_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;

	var _buildMatchMemberExpression = _interopRequireDefault(buildMatchMemberExpression_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	const isReactComponent = (0, _buildMatchMemberExpression.default)("React.Component");
	var _default = isReactComponent;
	exports.default = _default;
	});

	unwrapExports(isReactComponent_1);

	var isCompatTag_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isCompatTag;

	function isCompatTag(tagName) {
	  return !!tagName && /^[a-z]/.test(tagName);
	}
	});

	unwrapExports(isCompatTag_1);

	/**
	 * Removes all key-value entries from the list cache.
	 *
	 * @private
	 * @name clear
	 * @memberOf ListCache
	 */
	function listCacheClear() {
	  this.__data__ = [];
	  this.size = 0;
	}

	var _listCacheClear = listCacheClear;

	/**
	 * Performs a
	 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'a': 1 };
	 * var other = { 'a': 1 };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}

	var eq_1 = eq;

	/**
	 * Gets the index at which the `key` is found in `array` of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to inspect.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq_1(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}

	var _assocIndexOf = assocIndexOf;

	/** Used for built-in method references. */
	var arrayProto = Array.prototype;

	/** Built-in value references. */
	var splice = arrayProto.splice;

	/**
	 * Removes `key` and its value from the list cache.
	 *
	 * @private
	 * @name delete
	 * @memberOf ListCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function listCacheDelete(key) {
	  var data = this.__data__,
	      index = _assocIndexOf(data, key);

	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  --this.size;
	  return true;
	}

	var _listCacheDelete = listCacheDelete;

	/**
	 * Gets the list cache value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf ListCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function listCacheGet(key) {
	  var data = this.__data__,
	      index = _assocIndexOf(data, key);

	  return index < 0 ? undefined : data[index][1];
	}

	var _listCacheGet = listCacheGet;

	/**
	 * Checks if a list cache value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf ListCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function listCacheHas(key) {
	  return _assocIndexOf(this.__data__, key) > -1;
	}

	var _listCacheHas = listCacheHas;

	/**
	 * Sets the list cache `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf ListCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the list cache instance.
	 */
	function listCacheSet(key, value) {
	  var data = this.__data__,
	      index = _assocIndexOf(data, key);

	  if (index < 0) {
	    ++this.size;
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}

	var _listCacheSet = listCacheSet;

	/**
	 * Creates an list cache object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function ListCache(entries) {
	  var index = -1,
	      length = entries == null ? 0 : entries.length;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	// Add methods to `ListCache`.
	ListCache.prototype.clear = _listCacheClear;
	ListCache.prototype['delete'] = _listCacheDelete;
	ListCache.prototype.get = _listCacheGet;
	ListCache.prototype.has = _listCacheHas;
	ListCache.prototype.set = _listCacheSet;

	var _ListCache = ListCache;

	/**
	 * Removes all key-value entries from the stack.
	 *
	 * @private
	 * @name clear
	 * @memberOf Stack
	 */
	function stackClear() {
	  this.__data__ = new _ListCache;
	  this.size = 0;
	}

	var _stackClear = stackClear;

	/**
	 * Removes `key` and its value from the stack.
	 *
	 * @private
	 * @name delete
	 * @memberOf Stack
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function stackDelete(key) {
	  var data = this.__data__,
	      result = data['delete'](key);

	  this.size = data.size;
	  return result;
	}

	var _stackDelete = stackDelete;

	/**
	 * Gets the stack value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Stack
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function stackGet(key) {
	  return this.__data__.get(key);
	}

	var _stackGet = stackGet;

	/**
	 * Checks if a stack value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Stack
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function stackHas(key) {
	  return this.__data__.has(key);
	}

	var _stackHas = stackHas;

	/** Detect free variable `global` from Node.js. */
	var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

	var _freeGlobal = freeGlobal;

	/** Detect free variable `self`. */
	var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

	/** Used as a reference to the global object. */
	var root = _freeGlobal || freeSelf || Function('return this')();

	var _root = root;

	/** Built-in value references. */
	var Symbol$1 = _root.Symbol;

	var _Symbol = Symbol$1;

	/** Used for built-in method references. */
	var objectProto = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var nativeObjectToString = objectProto.toString;

	/** Built-in value references. */
	var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

	/**
	 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the raw `toStringTag`.
	 */
	function getRawTag(value) {
	  var isOwn = hasOwnProperty.call(value, symToStringTag),
	      tag = value[symToStringTag];

	  try {
	    value[symToStringTag] = undefined;
	    var unmasked = true;
	  } catch (e) {}

	  var result = nativeObjectToString.call(value);
	  if (unmasked) {
	    if (isOwn) {
	      value[symToStringTag] = tag;
	    } else {
	      delete value[symToStringTag];
	    }
	  }
	  return result;
	}

	var _getRawTag = getRawTag;

	/** Used for built-in method references. */
	var objectProto$1 = Object.prototype;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var nativeObjectToString$1 = objectProto$1.toString;

	/**
	 * Converts `value` to a string using `Object.prototype.toString`.
	 *
	 * @private
	 * @param {*} value The value to convert.
	 * @returns {string} Returns the converted string.
	 */
	function objectToString(value) {
	  return nativeObjectToString$1.call(value);
	}

	var _objectToString = objectToString;

	/** `Object#toString` result references. */
	var nullTag = '[object Null]',
	    undefinedTag = '[object Undefined]';

	/** Built-in value references. */
	var symToStringTag$1 = _Symbol ? _Symbol.toStringTag : undefined;

	/**
	 * The base implementation of `getTag` without fallbacks for buggy environments.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	function baseGetTag(value) {
	  if (value == null) {
	    return value === undefined ? undefinedTag : nullTag;
	  }
	  return (symToStringTag$1 && symToStringTag$1 in Object(value))
	    ? _getRawTag(value)
	    : _objectToString(value);
	}

	var _baseGetTag = baseGetTag;

	/**
	 * Checks if `value` is the
	 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
	 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return value != null && (type == 'object' || type == 'function');
	}

	var isObject_1 = isObject;

	/** `Object#toString` result references. */
	var asyncTag = '[object AsyncFunction]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    proxyTag = '[object Proxy]';

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  if (!isObject_1(value)) {
	    return false;
	  }
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 9 which returns 'object' for typed arrays and other constructors.
	  var tag = _baseGetTag(value);
	  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
	}

	var isFunction_1 = isFunction;

	/** Used to detect overreaching core-js shims. */
	var coreJsData = _root['__core-js_shared__'];

	var _coreJsData = coreJsData;

	/** Used to detect methods masquerading as native. */
	var maskSrcKey = (function() {
	  var uid = /[^.]+$/.exec(_coreJsData && _coreJsData.keys && _coreJsData.keys.IE_PROTO || '');
	  return uid ? ('Symbol(src)_1.' + uid) : '';
	}());

	/**
	 * Checks if `func` has its source masked.
	 *
	 * @private
	 * @param {Function} func The function to check.
	 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
	 */
	function isMasked(func) {
	  return !!maskSrcKey && (maskSrcKey in func);
	}

	var _isMasked = isMasked;

	/** Used for built-in method references. */
	var funcProto = Function.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString = funcProto.toString;

	/**
	 * Converts `func` to its source code.
	 *
	 * @private
	 * @param {Function} func The function to convert.
	 * @returns {string} Returns the source code.
	 */
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e) {}
	    try {
	      return (func + '');
	    } catch (e) {}
	  }
	  return '';
	}

	var _toSource = toSource;

	/**
	 * Used to match `RegExp`
	 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
	 */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

	/** Used to detect host constructors (Safari). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/** Used for built-in method references. */
	var funcProto$1 = Function.prototype,
	    objectProto$2 = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString$1 = funcProto$1.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty$1 = objectProto$2.hasOwnProperty;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString$1.call(hasOwnProperty$1).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/**
	 * The base implementation of `_.isNative` without bad shim checks.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function,
	 *  else `false`.
	 */
	function baseIsNative(value) {
	  if (!isObject_1(value) || _isMasked(value)) {
	    return false;
	  }
	  var pattern = isFunction_1(value) ? reIsNative : reIsHostCtor;
	  return pattern.test(_toSource(value));
	}

	var _baseIsNative = baseIsNative;

	/**
	 * Gets the value at `key` of `object`.
	 *
	 * @private
	 * @param {Object} [object] The object to query.
	 * @param {string} key The key of the property to get.
	 * @returns {*} Returns the property value.
	 */
	function getValue(object, key) {
	  return object == null ? undefined : object[key];
	}

	var _getValue = getValue;

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = _getValue(object, key);
	  return _baseIsNative(value) ? value : undefined;
	}

	var _getNative = getNative;

	/* Built-in method references that are verified to be native. */
	var Map$1 = _getNative(_root, 'Map');

	var _Map = Map$1;

	/* Built-in method references that are verified to be native. */
	var nativeCreate = _getNative(Object, 'create');

	var _nativeCreate = nativeCreate;

	/**
	 * Removes all key-value entries from the hash.
	 *
	 * @private
	 * @name clear
	 * @memberOf Hash
	 */
	function hashClear() {
	  this.__data__ = _nativeCreate ? _nativeCreate(null) : {};
	  this.size = 0;
	}

	var _hashClear = hashClear;

	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @name delete
	 * @memberOf Hash
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(key) {
	  var result = this.has(key) && delete this.__data__[key];
	  this.size -= result ? 1 : 0;
	  return result;
	}

	var _hashDelete = hashDelete;

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';

	/** Used for built-in method references. */
	var objectProto$3 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$2 = objectProto$3.hasOwnProperty;

	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Hash
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(key) {
	  var data = this.__data__;
	  if (_nativeCreate) {
	    var result = data[key];
	    return result === HASH_UNDEFINED ? undefined : result;
	  }
	  return hasOwnProperty$2.call(data, key) ? data[key] : undefined;
	}

	var _hashGet = hashGet;

	/** Used for built-in method references. */
	var objectProto$4 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$3 = objectProto$4.hasOwnProperty;

	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Hash
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(key) {
	  var data = this.__data__;
	  return _nativeCreate ? (data[key] !== undefined) : hasOwnProperty$3.call(data, key);
	}

	var _hashHas = hashHas;

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Hash
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the hash instance.
	 */
	function hashSet(key, value) {
	  var data = this.__data__;
	  this.size += this.has(key) ? 0 : 1;
	  data[key] = (_nativeCreate && value === undefined) ? HASH_UNDEFINED$1 : value;
	  return this;
	}

	var _hashSet = hashSet;

	/**
	 * Creates a hash object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Hash(entries) {
	  var index = -1,
	      length = entries == null ? 0 : entries.length;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	// Add methods to `Hash`.
	Hash.prototype.clear = _hashClear;
	Hash.prototype['delete'] = _hashDelete;
	Hash.prototype.get = _hashGet;
	Hash.prototype.has = _hashHas;
	Hash.prototype.set = _hashSet;

	var _Hash = Hash;

	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapCacheClear() {
	  this.size = 0;
	  this.__data__ = {
	    'hash': new _Hash,
	    'map': new (_Map || _ListCache),
	    'string': new _Hash
	  };
	}

	var _mapCacheClear = mapCacheClear;

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	    ? (value !== '__proto__')
	    : (value === null);
	}

	var _isKeyable = isKeyable;

	/**
	 * Gets the data for `map`.
	 *
	 * @private
	 * @param {Object} map The map to query.
	 * @param {string} key The reference key.
	 * @returns {*} Returns the map data.
	 */
	function getMapData(map, key) {
	  var data = map.__data__;
	  return _isKeyable(key)
	    ? data[typeof key == 'string' ? 'string' : 'hash']
	    : data.map;
	}

	var _getMapData = getMapData;

	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapCacheDelete(key) {
	  var result = _getMapData(this, key)['delete'](key);
	  this.size -= result ? 1 : 0;
	  return result;
	}

	var _mapCacheDelete = mapCacheDelete;

	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapCacheGet(key) {
	  return _getMapData(this, key).get(key);
	}

	var _mapCacheGet = mapCacheGet;

	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapCacheHas(key) {
	  return _getMapData(this, key).has(key);
	}

	var _mapCacheHas = mapCacheHas;

	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache instance.
	 */
	function mapCacheSet(key, value) {
	  var data = _getMapData(this, key),
	      size = data.size;

	  data.set(key, value);
	  this.size += data.size == size ? 0 : 1;
	  return this;
	}

	var _mapCacheSet = mapCacheSet;

	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function MapCache(entries) {
	  var index = -1,
	      length = entries == null ? 0 : entries.length;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	// Add methods to `MapCache`.
	MapCache.prototype.clear = _mapCacheClear;
	MapCache.prototype['delete'] = _mapCacheDelete;
	MapCache.prototype.get = _mapCacheGet;
	MapCache.prototype.has = _mapCacheHas;
	MapCache.prototype.set = _mapCacheSet;

	var _MapCache = MapCache;

	/** Used as the size to enable large array optimizations. */
	var LARGE_ARRAY_SIZE = 200;

	/**
	 * Sets the stack `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Stack
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the stack cache instance.
	 */
	function stackSet(key, value) {
	  var data = this.__data__;
	  if (data instanceof _ListCache) {
	    var pairs = data.__data__;
	    if (!_Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
	      pairs.push([key, value]);
	      this.size = ++data.size;
	      return this;
	    }
	    data = this.__data__ = new _MapCache(pairs);
	  }
	  data.set(key, value);
	  this.size = data.size;
	  return this;
	}

	var _stackSet = stackSet;

	/**
	 * Creates a stack cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Stack(entries) {
	  var data = this.__data__ = new _ListCache(entries);
	  this.size = data.size;
	}

	// Add methods to `Stack`.
	Stack.prototype.clear = _stackClear;
	Stack.prototype['delete'] = _stackDelete;
	Stack.prototype.get = _stackGet;
	Stack.prototype.has = _stackHas;
	Stack.prototype.set = _stackSet;

	var _Stack = Stack;

	/**
	 * A specialized version of `_.forEach` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} [array] The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns `array`.
	 */
	function arrayEach(array, iteratee) {
	  var index = -1,
	      length = array == null ? 0 : array.length;

	  while (++index < length) {
	    if (iteratee(array[index], index, array) === false) {
	      break;
	    }
	  }
	  return array;
	}

	var _arrayEach = arrayEach;

	var defineProperty = (function() {
	  try {
	    var func = _getNative(Object, 'defineProperty');
	    func({}, '', {});
	    return func;
	  } catch (e) {}
	}());

	var _defineProperty = defineProperty;

	/**
	 * The base implementation of `assignValue` and `assignMergeValue` without
	 * value checks.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function baseAssignValue(object, key, value) {
	  if (key == '__proto__' && _defineProperty) {
	    _defineProperty(object, key, {
	      'configurable': true,
	      'enumerable': true,
	      'value': value,
	      'writable': true
	    });
	  } else {
	    object[key] = value;
	  }
	}

	var _baseAssignValue = baseAssignValue;

	/** Used for built-in method references. */
	var objectProto$5 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$4 = objectProto$5.hasOwnProperty;

	/**
	 * Assigns `value` to `key` of `object` if the existing value is not equivalent
	 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	 * for equality comparisons.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty$4.call(object, key) && eq_1(objValue, value)) ||
	      (value === undefined && !(key in object))) {
	    _baseAssignValue(object, key, value);
	  }
	}

	var _assignValue = assignValue;

	/**
	 * Copies properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property identifiers to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @param {Function} [customizer] The function to customize copied values.
	 * @returns {Object} Returns `object`.
	 */
	function copyObject(source, props, object, customizer) {
	  var isNew = !object;
	  object || (object = {});

	  var index = -1,
	      length = props.length;

	  while (++index < length) {
	    var key = props[index];

	    var newValue = customizer
	      ? customizer(object[key], source[key], key, object, source)
	      : undefined;

	    if (newValue === undefined) {
	      newValue = source[key];
	    }
	    if (isNew) {
	      _baseAssignValue(object, key, newValue);
	    } else {
	      _assignValue(object, key, newValue);
	    }
	  }
	  return object;
	}

	var _copyObject = copyObject;

	/**
	 * The base implementation of `_.times` without support for iteratee shorthands
	 * or max array length checks.
	 *
	 * @private
	 * @param {number} n The number of times to invoke `iteratee`.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns the array of results.
	 */
	function baseTimes(n, iteratee) {
	  var index = -1,
	      result = Array(n);

	  while (++index < n) {
	    result[index] = iteratee(index);
	  }
	  return result;
	}

	var _baseTimes = baseTimes;

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return value != null && typeof value == 'object';
	}

	var isObjectLike_1 = isObjectLike;

	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]';

	/**
	 * The base implementation of `_.isArguments`.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
	 */
	function baseIsArguments(value) {
	  return isObjectLike_1(value) && _baseGetTag(value) == argsTag;
	}

	var _baseIsArguments = baseIsArguments;

	/** Used for built-in method references. */
	var objectProto$6 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$5 = objectProto$6.hasOwnProperty;

	/** Built-in value references. */
	var propertyIsEnumerable = objectProto$6.propertyIsEnumerable;

	/**
	 * Checks if `value` is likely an `arguments` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
	 *  else `false`.
	 * @example
	 *
	 * _.isArguments(function() { return arguments; }());
	 * // => true
	 *
	 * _.isArguments([1, 2, 3]);
	 * // => false
	 */
	var isArguments = _baseIsArguments(function() { return arguments; }()) ? _baseIsArguments : function(value) {
	  return isObjectLike_1(value) && hasOwnProperty$5.call(value, 'callee') &&
	    !propertyIsEnumerable.call(value, 'callee');
	};

	var isArguments_1 = isArguments;

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;

	var isArray_1 = isArray;

	/**
	 * This method returns `false`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.13.0
	 * @category Util
	 * @returns {boolean} Returns `false`.
	 * @example
	 *
	 * _.times(2, _.stubFalse);
	 * // => [false, false]
	 */
	function stubFalse() {
	  return false;
	}

	var stubFalse_1 = stubFalse;

	var isBuffer_1 = createCommonjsModule(function (module, exports) {
	/** Detect free variable `exports`. */
	var freeExports =  exports && !exports.nodeType && exports;

	/** Detect free variable `module`. */
	var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = freeModule && freeModule.exports === freeExports;

	/** Built-in value references. */
	var Buffer = moduleExports ? _root.Buffer : undefined;

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

	/**
	 * Checks if `value` is a buffer.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.3.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
	 * @example
	 *
	 * _.isBuffer(new Buffer(2));
	 * // => true
	 *
	 * _.isBuffer(new Uint8Array(2));
	 * // => false
	 */
	var isBuffer = nativeIsBuffer || stubFalse_1;

	module.exports = isBuffer;
	});

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;

	/** Used to detect unsigned integer values. */
	var reIsUint = /^(?:0|[1-9]\d*)$/;

	/**
	 * Checks if `value` is a valid array-like index.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
	 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
	 */
	function isIndex(value, length) {
	  var type = typeof value;
	  length = length == null ? MAX_SAFE_INTEGER : length;

	  return !!length &&
	    (type == 'number' ||
	      (type != 'symbol' && reIsUint.test(value))) &&
	        (value > -1 && value % 1 == 0 && value < length);
	}

	var _isIndex = isIndex;

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER$1 = 9007199254740991;

	/**
	 * Checks if `value` is a valid array-like length.
	 *
	 * **Note:** This method is loosely based on
	 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
	 * @example
	 *
	 * _.isLength(3);
	 * // => true
	 *
	 * _.isLength(Number.MIN_VALUE);
	 * // => false
	 *
	 * _.isLength(Infinity);
	 * // => false
	 *
	 * _.isLength('3');
	 * // => false
	 */
	function isLength(value) {
	  return typeof value == 'number' &&
	    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER$1;
	}

	var isLength_1 = isLength;

	/** `Object#toString` result references. */
	var argsTag$1 = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag$1 = '[object Function]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    weakMapTag = '[object WeakMap]';

	var arrayBufferTag = '[object ArrayBuffer]',
	    dataViewTag = '[object DataView]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';

	/** Used to identify `toStringTag` values of typed arrays. */
	var typedArrayTags = {};
	typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
	typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
	typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
	typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
	typedArrayTags[uint32Tag] = true;
	typedArrayTags[argsTag$1] = typedArrayTags[arrayTag] =
	typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
	typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
	typedArrayTags[errorTag] = typedArrayTags[funcTag$1] =
	typedArrayTags[mapTag] = typedArrayTags[numberTag] =
	typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
	typedArrayTags[setTag] = typedArrayTags[stringTag] =
	typedArrayTags[weakMapTag] = false;

	/**
	 * The base implementation of `_.isTypedArray` without Node.js optimizations.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
	 */
	function baseIsTypedArray(value) {
	  return isObjectLike_1(value) &&
	    isLength_1(value.length) && !!typedArrayTags[_baseGetTag(value)];
	}

	var _baseIsTypedArray = baseIsTypedArray;

	/**
	 * The base implementation of `_.unary` without support for storing metadata.
	 *
	 * @private
	 * @param {Function} func The function to cap arguments for.
	 * @returns {Function} Returns the new capped function.
	 */
	function baseUnary(func) {
	  return function(value) {
	    return func(value);
	  };
	}

	var _baseUnary = baseUnary;

	var _nodeUtil = createCommonjsModule(function (module, exports) {
	/** Detect free variable `exports`. */
	var freeExports =  exports && !exports.nodeType && exports;

	/** Detect free variable `module`. */
	var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = freeModule && freeModule.exports === freeExports;

	/** Detect free variable `process` from Node.js. */
	var freeProcess = moduleExports && _freeGlobal.process;

	/** Used to access faster Node.js helpers. */
	var nodeUtil = (function() {
	  try {
	    // Use `util.types` for Node.js 10+.
	    var types = freeModule && freeModule.require && freeModule.require('util').types;

	    if (types) {
	      return types;
	    }

	    // Legacy `process.binding('util')` for Node.js < 10.
	    return freeProcess && freeProcess.binding && freeProcess.binding('util');
	  } catch (e) {}
	}());

	module.exports = nodeUtil;
	});

	/* Node.js helper references. */
	var nodeIsTypedArray = _nodeUtil && _nodeUtil.isTypedArray;

	/**
	 * Checks if `value` is classified as a typed array.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
	 * @example
	 *
	 * _.isTypedArray(new Uint8Array);
	 * // => true
	 *
	 * _.isTypedArray([]);
	 * // => false
	 */
	var isTypedArray = nodeIsTypedArray ? _baseUnary(nodeIsTypedArray) : _baseIsTypedArray;

	var isTypedArray_1 = isTypedArray;

	/** Used for built-in method references. */
	var objectProto$7 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$6 = objectProto$7.hasOwnProperty;

	/**
	 * Creates an array of the enumerable property names of the array-like `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @param {boolean} inherited Specify returning inherited property names.
	 * @returns {Array} Returns the array of property names.
	 */
	function arrayLikeKeys(value, inherited) {
	  var isArr = isArray_1(value),
	      isArg = !isArr && isArguments_1(value),
	      isBuff = !isArr && !isArg && isBuffer_1(value),
	      isType = !isArr && !isArg && !isBuff && isTypedArray_1(value),
	      skipIndexes = isArr || isArg || isBuff || isType,
	      result = skipIndexes ? _baseTimes(value.length, String) : [],
	      length = result.length;

	  for (var key in value) {
	    if ((inherited || hasOwnProperty$6.call(value, key)) &&
	        !(skipIndexes && (
	           // Safari 9 has enumerable `arguments.length` in strict mode.
	           key == 'length' ||
	           // Node.js 0.10 has enumerable non-index properties on buffers.
	           (isBuff && (key == 'offset' || key == 'parent')) ||
	           // PhantomJS 2 has enumerable non-index properties on typed arrays.
	           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
	           // Skip index properties.
	           _isIndex(key, length)
	        ))) {
	      result.push(key);
	    }
	  }
	  return result;
	}

	var _arrayLikeKeys = arrayLikeKeys;

	/** Used for built-in method references. */
	var objectProto$8 = Object.prototype;

	/**
	 * Checks if `value` is likely a prototype object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
	 */
	function isPrototype(value) {
	  var Ctor = value && value.constructor,
	      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto$8;

	  return value === proto;
	}

	var _isPrototype = isPrototype;

	/**
	 * Creates a unary function that invokes `func` with its argument transformed.
	 *
	 * @private
	 * @param {Function} func The function to wrap.
	 * @param {Function} transform The argument transform.
	 * @returns {Function} Returns the new function.
	 */
	function overArg(func, transform) {
	  return function(arg) {
	    return func(transform(arg));
	  };
	}

	var _overArg = overArg;

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeKeys = _overArg(Object.keys, Object);

	var _nativeKeys = nativeKeys;

	/** Used for built-in method references. */
	var objectProto$9 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$7 = objectProto$9.hasOwnProperty;

	/**
	 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeys(object) {
	  if (!_isPrototype(object)) {
	    return _nativeKeys(object);
	  }
	  var result = [];
	  for (var key in Object(object)) {
	    if (hasOwnProperty$7.call(object, key) && key != 'constructor') {
	      result.push(key);
	    }
	  }
	  return result;
	}

	var _baseKeys = baseKeys;

	/**
	 * Checks if `value` is array-like. A value is considered array-like if it's
	 * not a function and has a `value.length` that's an integer greater than or
	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	 * @example
	 *
	 * _.isArrayLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLike(document.body.children);
	 * // => true
	 *
	 * _.isArrayLike('abc');
	 * // => true
	 *
	 * _.isArrayLike(_.noop);
	 * // => false
	 */
	function isArrayLike(value) {
	  return value != null && isLength_1(value.length) && !isFunction_1(value);
	}

	var isArrayLike_1 = isArrayLike;

	/**
	 * Creates an array of the own enumerable property names of `object`.
	 *
	 * **Note:** Non-object values are coerced to objects. See the
	 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
	 * for more details.
	 *
	 * @static
	 * @since 0.1.0
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.keys(new Foo);
	 * // => ['a', 'b'] (iteration order is not guaranteed)
	 *
	 * _.keys('hi');
	 * // => ['0', '1']
	 */
	function keys(object) {
	  return isArrayLike_1(object) ? _arrayLikeKeys(object) : _baseKeys(object);
	}

	var keys_1 = keys;

	/**
	 * The base implementation of `_.assign` without support for multiple sources
	 * or `customizer` functions.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @returns {Object} Returns `object`.
	 */
	function baseAssign(object, source) {
	  return object && _copyObject(source, keys_1(source), object);
	}

	var _baseAssign = baseAssign;

	/**
	 * This function is like
	 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
	 * except that it includes inherited enumerable properties.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function nativeKeysIn(object) {
	  var result = [];
	  if (object != null) {
	    for (var key in Object(object)) {
	      result.push(key);
	    }
	  }
	  return result;
	}

	var _nativeKeysIn = nativeKeysIn;

	/** Used for built-in method references. */
	var objectProto$a = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$8 = objectProto$a.hasOwnProperty;

	/**
	 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeysIn(object) {
	  if (!isObject_1(object)) {
	    return _nativeKeysIn(object);
	  }
	  var isProto = _isPrototype(object),
	      result = [];

	  for (var key in object) {
	    if (!(key == 'constructor' && (isProto || !hasOwnProperty$8.call(object, key)))) {
	      result.push(key);
	    }
	  }
	  return result;
	}

	var _baseKeysIn = baseKeysIn;

	/**
	 * Creates an array of the own and inherited enumerable property names of `object`.
	 *
	 * **Note:** Non-object values are coerced to objects.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.0.0
	 * @category Object
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.keysIn(new Foo);
	 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
	 */
	function keysIn(object) {
	  return isArrayLike_1(object) ? _arrayLikeKeys(object, true) : _baseKeysIn(object);
	}

	var keysIn_1 = keysIn;

	/**
	 * The base implementation of `_.assignIn` without support for multiple sources
	 * or `customizer` functions.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @returns {Object} Returns `object`.
	 */
	function baseAssignIn(object, source) {
	  return object && _copyObject(source, keysIn_1(source), object);
	}

	var _baseAssignIn = baseAssignIn;

	var _cloneBuffer = createCommonjsModule(function (module, exports) {
	/** Detect free variable `exports`. */
	var freeExports =  exports && !exports.nodeType && exports;

	/** Detect free variable `module`. */
	var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = freeModule && freeModule.exports === freeExports;

	/** Built-in value references. */
	var Buffer = moduleExports ? _root.Buffer : undefined,
	    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

	/**
	 * Creates a clone of  `buffer`.
	 *
	 * @private
	 * @param {Buffer} buffer The buffer to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Buffer} Returns the cloned buffer.
	 */
	function cloneBuffer(buffer, isDeep) {
	  if (isDeep) {
	    return buffer.slice();
	  }
	  var length = buffer.length,
	      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

	  buffer.copy(result);
	  return result;
	}

	module.exports = cloneBuffer;
	});

	/**
	 * Copies the values of `source` to `array`.
	 *
	 * @private
	 * @param {Array} source The array to copy values from.
	 * @param {Array} [array=[]] The array to copy values to.
	 * @returns {Array} Returns `array`.
	 */
	function copyArray(source, array) {
	  var index = -1,
	      length = source.length;

	  array || (array = Array(length));
	  while (++index < length) {
	    array[index] = source[index];
	  }
	  return array;
	}

	var _copyArray = copyArray;

	/**
	 * A specialized version of `_.filter` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} [array] The array to iterate over.
	 * @param {Function} predicate The function invoked per iteration.
	 * @returns {Array} Returns the new filtered array.
	 */
	function arrayFilter(array, predicate) {
	  var index = -1,
	      length = array == null ? 0 : array.length,
	      resIndex = 0,
	      result = [];

	  while (++index < length) {
	    var value = array[index];
	    if (predicate(value, index, array)) {
	      result[resIndex++] = value;
	    }
	  }
	  return result;
	}

	var _arrayFilter = arrayFilter;

	/**
	 * This method returns a new empty array.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.13.0
	 * @category Util
	 * @returns {Array} Returns the new empty array.
	 * @example
	 *
	 * var arrays = _.times(2, _.stubArray);
	 *
	 * console.log(arrays);
	 * // => [[], []]
	 *
	 * console.log(arrays[0] === arrays[1]);
	 * // => false
	 */
	function stubArray() {
	  return [];
	}

	var stubArray_1 = stubArray;

	/** Used for built-in method references. */
	var objectProto$b = Object.prototype;

	/** Built-in value references. */
	var propertyIsEnumerable$1 = objectProto$b.propertyIsEnumerable;

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeGetSymbols = Object.getOwnPropertySymbols;

	/**
	 * Creates an array of the own enumerable symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of symbols.
	 */
	var getSymbols = !nativeGetSymbols ? stubArray_1 : function(object) {
	  if (object == null) {
	    return [];
	  }
	  object = Object(object);
	  return _arrayFilter(nativeGetSymbols(object), function(symbol) {
	    return propertyIsEnumerable$1.call(object, symbol);
	  });
	};

	var _getSymbols = getSymbols;

	/**
	 * Copies own symbols of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy symbols from.
	 * @param {Object} [object={}] The object to copy symbols to.
	 * @returns {Object} Returns `object`.
	 */
	function copySymbols(source, object) {
	  return _copyObject(source, _getSymbols(source), object);
	}

	var _copySymbols = copySymbols;

	/**
	 * Appends the elements of `values` to `array`.
	 *
	 * @private
	 * @param {Array} array The array to modify.
	 * @param {Array} values The values to append.
	 * @returns {Array} Returns `array`.
	 */
	function arrayPush(array, values) {
	  var index = -1,
	      length = values.length,
	      offset = array.length;

	  while (++index < length) {
	    array[offset + index] = values[index];
	  }
	  return array;
	}

	var _arrayPush = arrayPush;

	/** Built-in value references. */
	var getPrototype = _overArg(Object.getPrototypeOf, Object);

	var _getPrototype = getPrototype;

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeGetSymbols$1 = Object.getOwnPropertySymbols;

	/**
	 * Creates an array of the own and inherited enumerable symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of symbols.
	 */
	var getSymbolsIn = !nativeGetSymbols$1 ? stubArray_1 : function(object) {
	  var result = [];
	  while (object) {
	    _arrayPush(result, _getSymbols(object));
	    object = _getPrototype(object);
	  }
	  return result;
	};

	var _getSymbolsIn = getSymbolsIn;

	/**
	 * Copies own and inherited symbols of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy symbols from.
	 * @param {Object} [object={}] The object to copy symbols to.
	 * @returns {Object} Returns `object`.
	 */
	function copySymbolsIn(source, object) {
	  return _copyObject(source, _getSymbolsIn(source), object);
	}

	var _copySymbolsIn = copySymbolsIn;

	/**
	 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
	 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
	 * symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Function} keysFunc The function to get the keys of `object`.
	 * @param {Function} symbolsFunc The function to get the symbols of `object`.
	 * @returns {Array} Returns the array of property names and symbols.
	 */
	function baseGetAllKeys(object, keysFunc, symbolsFunc) {
	  var result = keysFunc(object);
	  return isArray_1(object) ? result : _arrayPush(result, symbolsFunc(object));
	}

	var _baseGetAllKeys = baseGetAllKeys;

	/**
	 * Creates an array of own enumerable property names and symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names and symbols.
	 */
	function getAllKeys(object) {
	  return _baseGetAllKeys(object, keys_1, _getSymbols);
	}

	var _getAllKeys = getAllKeys;

	/**
	 * Creates an array of own and inherited enumerable property names and
	 * symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names and symbols.
	 */
	function getAllKeysIn(object) {
	  return _baseGetAllKeys(object, keysIn_1, _getSymbolsIn);
	}

	var _getAllKeysIn = getAllKeysIn;

	/* Built-in method references that are verified to be native. */
	var DataView$1 = _getNative(_root, 'DataView');

	var _DataView = DataView$1;

	/* Built-in method references that are verified to be native. */
	var Promise$1 = _getNative(_root, 'Promise');

	var _Promise = Promise$1;

	/* Built-in method references that are verified to be native. */
	var Set$1 = _getNative(_root, 'Set');

	var _Set = Set$1;

	/* Built-in method references that are verified to be native. */
	var WeakMap$1 = _getNative(_root, 'WeakMap');

	var _WeakMap = WeakMap$1;

	/** `Object#toString` result references. */
	var mapTag$1 = '[object Map]',
	    objectTag$1 = '[object Object]',
	    promiseTag = '[object Promise]',
	    setTag$1 = '[object Set]',
	    weakMapTag$1 = '[object WeakMap]';

	var dataViewTag$1 = '[object DataView]';

	/** Used to detect maps, sets, and weakmaps. */
	var dataViewCtorString = _toSource(_DataView),
	    mapCtorString = _toSource(_Map),
	    promiseCtorString = _toSource(_Promise),
	    setCtorString = _toSource(_Set),
	    weakMapCtorString = _toSource(_WeakMap);

	/**
	 * Gets the `toStringTag` of `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	var getTag = _baseGetTag;

	// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
	if ((_DataView && getTag(new _DataView(new ArrayBuffer(1))) != dataViewTag$1) ||
	    (_Map && getTag(new _Map) != mapTag$1) ||
	    (_Promise && getTag(_Promise.resolve()) != promiseTag) ||
	    (_Set && getTag(new _Set) != setTag$1) ||
	    (_WeakMap && getTag(new _WeakMap) != weakMapTag$1)) {
	  getTag = function(value) {
	    var result = _baseGetTag(value),
	        Ctor = result == objectTag$1 ? value.constructor : undefined,
	        ctorString = Ctor ? _toSource(Ctor) : '';

	    if (ctorString) {
	      switch (ctorString) {
	        case dataViewCtorString: return dataViewTag$1;
	        case mapCtorString: return mapTag$1;
	        case promiseCtorString: return promiseTag;
	        case setCtorString: return setTag$1;
	        case weakMapCtorString: return weakMapTag$1;
	      }
	    }
	    return result;
	  };
	}

	var _getTag = getTag;

	/** Used for built-in method references. */
	var objectProto$c = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$9 = objectProto$c.hasOwnProperty;

	/**
	 * Initializes an array clone.
	 *
	 * @private
	 * @param {Array} array The array to clone.
	 * @returns {Array} Returns the initialized clone.
	 */
	function initCloneArray(array) {
	  var length = array.length,
	      result = new array.constructor(length);

	  // Add properties assigned by `RegExp#exec`.
	  if (length && typeof array[0] == 'string' && hasOwnProperty$9.call(array, 'index')) {
	    result.index = array.index;
	    result.input = array.input;
	  }
	  return result;
	}

	var _initCloneArray = initCloneArray;

	/** Built-in value references. */
	var Uint8Array$1 = _root.Uint8Array;

	var _Uint8Array = Uint8Array$1;

	/**
	 * Creates a clone of `arrayBuffer`.
	 *
	 * @private
	 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
	 * @returns {ArrayBuffer} Returns the cloned array buffer.
	 */
	function cloneArrayBuffer(arrayBuffer) {
	  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
	  new _Uint8Array(result).set(new _Uint8Array(arrayBuffer));
	  return result;
	}

	var _cloneArrayBuffer = cloneArrayBuffer;

	/**
	 * Creates a clone of `dataView`.
	 *
	 * @private
	 * @param {Object} dataView The data view to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned data view.
	 */
	function cloneDataView(dataView, isDeep) {
	  var buffer = isDeep ? _cloneArrayBuffer(dataView.buffer) : dataView.buffer;
	  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
	}

	var _cloneDataView = cloneDataView;

	/** Used to match `RegExp` flags from their coerced string values. */
	var reFlags = /\w*$/;

	/**
	 * Creates a clone of `regexp`.
	 *
	 * @private
	 * @param {Object} regexp The regexp to clone.
	 * @returns {Object} Returns the cloned regexp.
	 */
	function cloneRegExp(regexp) {
	  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	  result.lastIndex = regexp.lastIndex;
	  return result;
	}

	var _cloneRegExp = cloneRegExp;

	/** Used to convert symbols to primitives and strings. */
	var symbolProto = _Symbol ? _Symbol.prototype : undefined,
	    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

	/**
	 * Creates a clone of the `symbol` object.
	 *
	 * @private
	 * @param {Object} symbol The symbol object to clone.
	 * @returns {Object} Returns the cloned symbol object.
	 */
	function cloneSymbol(symbol) {
	  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
	}

	var _cloneSymbol = cloneSymbol;

	/**
	 * Creates a clone of `typedArray`.
	 *
	 * @private
	 * @param {Object} typedArray The typed array to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned typed array.
	 */
	function cloneTypedArray(typedArray, isDeep) {
	  var buffer = isDeep ? _cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
	}

	var _cloneTypedArray = cloneTypedArray;

	/** `Object#toString` result references. */
	var boolTag$1 = '[object Boolean]',
	    dateTag$1 = '[object Date]',
	    mapTag$2 = '[object Map]',
	    numberTag$1 = '[object Number]',
	    regexpTag$1 = '[object RegExp]',
	    setTag$2 = '[object Set]',
	    stringTag$1 = '[object String]',
	    symbolTag = '[object Symbol]';

	var arrayBufferTag$1 = '[object ArrayBuffer]',
	    dataViewTag$2 = '[object DataView]',
	    float32Tag$1 = '[object Float32Array]',
	    float64Tag$1 = '[object Float64Array]',
	    int8Tag$1 = '[object Int8Array]',
	    int16Tag$1 = '[object Int16Array]',
	    int32Tag$1 = '[object Int32Array]',
	    uint8Tag$1 = '[object Uint8Array]',
	    uint8ClampedTag$1 = '[object Uint8ClampedArray]',
	    uint16Tag$1 = '[object Uint16Array]',
	    uint32Tag$1 = '[object Uint32Array]';

	/**
	 * Initializes an object clone based on its `toStringTag`.
	 *
	 * **Note:** This function only supports cloning values with tags of
	 * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @param {string} tag The `toStringTag` of the object to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneByTag(object, tag, isDeep) {
	  var Ctor = object.constructor;
	  switch (tag) {
	    case arrayBufferTag$1:
	      return _cloneArrayBuffer(object);

	    case boolTag$1:
	    case dateTag$1:
	      return new Ctor(+object);

	    case dataViewTag$2:
	      return _cloneDataView(object, isDeep);

	    case float32Tag$1: case float64Tag$1:
	    case int8Tag$1: case int16Tag$1: case int32Tag$1:
	    case uint8Tag$1: case uint8ClampedTag$1: case uint16Tag$1: case uint32Tag$1:
	      return _cloneTypedArray(object, isDeep);

	    case mapTag$2:
	      return new Ctor;

	    case numberTag$1:
	    case stringTag$1:
	      return new Ctor(object);

	    case regexpTag$1:
	      return _cloneRegExp(object);

	    case setTag$2:
	      return new Ctor;

	    case symbolTag:
	      return _cloneSymbol(object);
	  }
	}

	var _initCloneByTag = initCloneByTag;

	/** Built-in value references. */
	var objectCreate = Object.create;

	/**
	 * The base implementation of `_.create` without support for assigning
	 * properties to the created object.
	 *
	 * @private
	 * @param {Object} proto The object to inherit from.
	 * @returns {Object} Returns the new object.
	 */
	var baseCreate = (function() {
	  function object() {}
	  return function(proto) {
	    if (!isObject_1(proto)) {
	      return {};
	    }
	    if (objectCreate) {
	      return objectCreate(proto);
	    }
	    object.prototype = proto;
	    var result = new object;
	    object.prototype = undefined;
	    return result;
	  };
	}());

	var _baseCreate = baseCreate;

	/**
	 * Initializes an object clone.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneObject(object) {
	  return (typeof object.constructor == 'function' && !_isPrototype(object))
	    ? _baseCreate(_getPrototype(object))
	    : {};
	}

	var _initCloneObject = initCloneObject;

	/** `Object#toString` result references. */
	var mapTag$3 = '[object Map]';

	/**
	 * The base implementation of `_.isMap` without Node.js optimizations.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
	 */
	function baseIsMap(value) {
	  return isObjectLike_1(value) && _getTag(value) == mapTag$3;
	}

	var _baseIsMap = baseIsMap;

	/* Node.js helper references. */
	var nodeIsMap = _nodeUtil && _nodeUtil.isMap;

	/**
	 * Checks if `value` is classified as a `Map` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.3.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
	 * @example
	 *
	 * _.isMap(new Map);
	 * // => true
	 *
	 * _.isMap(new WeakMap);
	 * // => false
	 */
	var isMap = nodeIsMap ? _baseUnary(nodeIsMap) : _baseIsMap;

	var isMap_1 = isMap;

	/** `Object#toString` result references. */
	var setTag$3 = '[object Set]';

	/**
	 * The base implementation of `_.isSet` without Node.js optimizations.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a set, else `false`.
	 */
	function baseIsSet(value) {
	  return isObjectLike_1(value) && _getTag(value) == setTag$3;
	}

	var _baseIsSet = baseIsSet;

	/* Node.js helper references. */
	var nodeIsSet = _nodeUtil && _nodeUtil.isSet;

	/**
	 * Checks if `value` is classified as a `Set` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.3.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a set, else `false`.
	 * @example
	 *
	 * _.isSet(new Set);
	 * // => true
	 *
	 * _.isSet(new WeakSet);
	 * // => false
	 */
	var isSet = nodeIsSet ? _baseUnary(nodeIsSet) : _baseIsSet;

	var isSet_1 = isSet;

	/** Used to compose bitmasks for cloning. */
	var CLONE_DEEP_FLAG = 1,
	    CLONE_FLAT_FLAG = 2,
	    CLONE_SYMBOLS_FLAG = 4;

	/** `Object#toString` result references. */
	var argsTag$2 = '[object Arguments]',
	    arrayTag$1 = '[object Array]',
	    boolTag$2 = '[object Boolean]',
	    dateTag$2 = '[object Date]',
	    errorTag$1 = '[object Error]',
	    funcTag$2 = '[object Function]',
	    genTag$1 = '[object GeneratorFunction]',
	    mapTag$4 = '[object Map]',
	    numberTag$2 = '[object Number]',
	    objectTag$2 = '[object Object]',
	    regexpTag$2 = '[object RegExp]',
	    setTag$4 = '[object Set]',
	    stringTag$2 = '[object String]',
	    symbolTag$1 = '[object Symbol]',
	    weakMapTag$2 = '[object WeakMap]';

	var arrayBufferTag$2 = '[object ArrayBuffer]',
	    dataViewTag$3 = '[object DataView]',
	    float32Tag$2 = '[object Float32Array]',
	    float64Tag$2 = '[object Float64Array]',
	    int8Tag$2 = '[object Int8Array]',
	    int16Tag$2 = '[object Int16Array]',
	    int32Tag$2 = '[object Int32Array]',
	    uint8Tag$2 = '[object Uint8Array]',
	    uint8ClampedTag$2 = '[object Uint8ClampedArray]',
	    uint16Tag$2 = '[object Uint16Array]',
	    uint32Tag$2 = '[object Uint32Array]';

	/** Used to identify `toStringTag` values supported by `_.clone`. */
	var cloneableTags = {};
	cloneableTags[argsTag$2] = cloneableTags[arrayTag$1] =
	cloneableTags[arrayBufferTag$2] = cloneableTags[dataViewTag$3] =
	cloneableTags[boolTag$2] = cloneableTags[dateTag$2] =
	cloneableTags[float32Tag$2] = cloneableTags[float64Tag$2] =
	cloneableTags[int8Tag$2] = cloneableTags[int16Tag$2] =
	cloneableTags[int32Tag$2] = cloneableTags[mapTag$4] =
	cloneableTags[numberTag$2] = cloneableTags[objectTag$2] =
	cloneableTags[regexpTag$2] = cloneableTags[setTag$4] =
	cloneableTags[stringTag$2] = cloneableTags[symbolTag$1] =
	cloneableTags[uint8Tag$2] = cloneableTags[uint8ClampedTag$2] =
	cloneableTags[uint16Tag$2] = cloneableTags[uint32Tag$2] = true;
	cloneableTags[errorTag$1] = cloneableTags[funcTag$2] =
	cloneableTags[weakMapTag$2] = false;

	/**
	 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
	 * traversed objects.
	 *
	 * @private
	 * @param {*} value The value to clone.
	 * @param {boolean} bitmask The bitmask flags.
	 *  1 - Deep clone
	 *  2 - Flatten inherited properties
	 *  4 - Clone symbols
	 * @param {Function} [customizer] The function to customize cloning.
	 * @param {string} [key] The key of `value`.
	 * @param {Object} [object] The parent object of `value`.
	 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
	 * @returns {*} Returns the cloned value.
	 */
	function baseClone(value, bitmask, customizer, key, object, stack) {
	  var result,
	      isDeep = bitmask & CLONE_DEEP_FLAG,
	      isFlat = bitmask & CLONE_FLAT_FLAG,
	      isFull = bitmask & CLONE_SYMBOLS_FLAG;

	  if (customizer) {
	    result = object ? customizer(value, key, object, stack) : customizer(value);
	  }
	  if (result !== undefined) {
	    return result;
	  }
	  if (!isObject_1(value)) {
	    return value;
	  }
	  var isArr = isArray_1(value);
	  if (isArr) {
	    result = _initCloneArray(value);
	    if (!isDeep) {
	      return _copyArray(value, result);
	    }
	  } else {
	    var tag = _getTag(value),
	        isFunc = tag == funcTag$2 || tag == genTag$1;

	    if (isBuffer_1(value)) {
	      return _cloneBuffer(value, isDeep);
	    }
	    if (tag == objectTag$2 || tag == argsTag$2 || (isFunc && !object)) {
	      result = (isFlat || isFunc) ? {} : _initCloneObject(value);
	      if (!isDeep) {
	        return isFlat
	          ? _copySymbolsIn(value, _baseAssignIn(result, value))
	          : _copySymbols(value, _baseAssign(result, value));
	      }
	    } else {
	      if (!cloneableTags[tag]) {
	        return object ? value : {};
	      }
	      result = _initCloneByTag(value, tag, isDeep);
	    }
	  }
	  // Check for circular references and return its corresponding clone.
	  stack || (stack = new _Stack);
	  var stacked = stack.get(value);
	  if (stacked) {
	    return stacked;
	  }
	  stack.set(value, result);

	  if (isSet_1(value)) {
	    value.forEach(function(subValue) {
	      result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
	    });
	  } else if (isMap_1(value)) {
	    value.forEach(function(subValue, key) {
	      result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
	    });
	  }

	  var keysFunc = isFull
	    ? (isFlat ? _getAllKeysIn : _getAllKeys)
	    : (isFlat ? keysIn_1 : keys_1);

	  var props = isArr ? undefined : keysFunc(value);
	  _arrayEach(props || value, function(subValue, key) {
	    if (props) {
	      key = subValue;
	      subValue = value[key];
	    }
	    // Recursively populate clone (susceptible to call stack limits).
	    _assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
	  });
	  return result;
	}

	var _baseClone = baseClone;

	/** Used to compose bitmasks for cloning. */
	var CLONE_SYMBOLS_FLAG$1 = 4;

	/**
	 * Creates a shallow clone of `value`.
	 *
	 * **Note:** This method is loosely based on the
	 * [structured clone algorithm](https://mdn.io/Structured_clone_algorithm)
	 * and supports cloning arrays, array buffers, booleans, date objects, maps,
	 * numbers, `Object` objects, regexes, sets, strings, symbols, and typed
	 * arrays. The own enumerable properties of `arguments` objects are cloned
	 * as plain objects. An empty object is returned for uncloneable values such
	 * as error objects, functions, DOM nodes, and WeakMaps.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to clone.
	 * @returns {*} Returns the cloned value.
	 * @see _.cloneDeep
	 * @example
	 *
	 * var objects = [{ 'a': 1 }, { 'b': 2 }];
	 *
	 * var shallow = _.clone(objects);
	 * console.log(shallow[0] === objects[0]);
	 * // => true
	 */
	function clone(value) {
	  return _baseClone(value, CLONE_SYMBOLS_FLAG$1);
	}

	var clone_1 = clone;

	let fastProto = null;

	// Creates an object with permanently fast properties in V8. See Toon Verwaest's
	// post https://medium.com/@tverwaes/setting-up-prototypes-in-v8-ec9c9491dfe2#5f62
	// for more details. Use %HasFastProperties(object) and the Node.js flag
	// --allow-natives-syntax to check whether an object has fast properties.
	function FastObject(o) {
		// A prototype object will have "fast properties" enabled once it is checked
		// against the inline property cache of a function, e.g. fastProto.property:
		// https://github.com/v8/v8/blob/6.0.122/test/mjsunit/fast-prototype.js#L48-L63
		if (fastProto !== null && typeof fastProto.property) {
			const result = fastProto;
			fastProto = FastObject.prototype = null;
			return result;
		}
		fastProto = FastObject.prototype = o == null ? Object.create(null) : o;
		return new FastObject;
	}

	// Initialize the inline property cache of FastObject
	FastObject();

	var toFastProperties = function toFastproperties(o) {
		return FastObject(o);
	};

	var isType_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isType;



	function isType(nodeType, targetType) {
	  if (nodeType === targetType) return true;
	  if (definitions.ALIAS_KEYS[targetType]) return false;
	  const aliases = definitions.FLIPPED_ALIAS_KEYS[targetType];

	  if (aliases) {
	    if (aliases[0] === nodeType) return true;

	    for (const alias of aliases) {
	      if (nodeType === alias) return true;
	    }
	  }

	  return false;
	}
	});

	unwrapExports(isType_1);

	var isPlaceholderType_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isPlaceholderType;



	function isPlaceholderType(placeholderType, targetType) {
	  if (placeholderType === targetType) return true;
	  const aliases = definitions.PLACEHOLDERS_ALIAS[placeholderType];

	  if (aliases) {
	    for (const alias of aliases) {
	      if (targetType === alias) return true;
	    }
	  }

	  return false;
	}
	});

	unwrapExports(isPlaceholderType_1);

	var is_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = is;

	var _shallowEqual = _interopRequireDefault(shallowEqual_1);

	var _isType = _interopRequireDefault(isType_1);

	var _isPlaceholderType = _interopRequireDefault(isPlaceholderType_1);



	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function is(type, node, opts) {
	  if (!node) return false;
	  const matches = (0, _isType.default)(node.type, type);

	  if (!matches) {
	    if (!opts && node.type === "Placeholder" && type in definitions.FLIPPED_ALIAS_KEYS) {
	      return (0, _isPlaceholderType.default)(node.expectedNode, type);
	    }

	    return false;
	  }

	  if (typeof opts === "undefined") {
	    return true;
	  } else {
	    return (0, _shallowEqual.default)(node, opts);
	  }
	}
	});

	unwrapExports(is_1);

	var identifier = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.isIdentifierStart = isIdentifierStart;
	exports.isIdentifierChar = isIdentifierChar;
	exports.isIdentifierName = isIdentifierName;
	let nonASCIIidentifierStartChars = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u08a0-\u08b4\u08b6-\u08c7\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c88\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\u9ffc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7bf\ua7c2-\ua7ca\ua7f5-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";
	let nonASCIIidentifierChars = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf\u1ac0\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f";
	const nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
	const nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
	nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
	const astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 157, 310, 10, 21, 11, 7, 153, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 107, 20, 28, 22, 13, 52, 76, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 230, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 35, 56, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2749, 1070, 4050, 582, 8634, 568, 8, 30, 114, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8952, 286, 50, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 2357, 44, 11, 6, 17, 0, 370, 43, 1301, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42717, 35, 4148, 12, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
	const astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 176, 2, 54, 14, 32, 9, 16, 3, 46, 10, 54, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 135, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 5319, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 419, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

	function isInAstralSet(code, set) {
	  let pos = 0x10000;

	  for (let i = 0, length = set.length; i < length; i += 2) {
	    pos += set[i];
	    if (pos > code) return false;
	    pos += set[i + 1];
	    if (pos >= code) return true;
	  }

	  return false;
	}

	function isIdentifierStart(code) {
	  if (code < 65) return code === 36;
	  if (code <= 90) return true;
	  if (code < 97) return code === 95;
	  if (code <= 122) return true;

	  if (code <= 0xffff) {
	    return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code));
	  }

	  return isInAstralSet(code, astralIdentifierStartCodes);
	}

	function isIdentifierChar(code) {
	  if (code < 48) return code === 36;
	  if (code < 58) return true;
	  if (code < 65) return false;
	  if (code <= 90) return true;
	  if (code < 97) return code === 95;
	  if (code <= 122) return true;

	  if (code <= 0xffff) {
	    return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code));
	  }

	  return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
	}

	function isIdentifierName(name) {
	  let isFirst = true;

	  for (let _i = 0, _Array$from = Array.from(name); _i < _Array$from.length; _i++) {
	    const char = _Array$from[_i];
	    const cp = char.codePointAt(0);

	    if (isFirst) {
	      if (!isIdentifierStart(cp)) {
	        return false;
	      }

	      isFirst = false;
	    } else if (!isIdentifierChar(cp)) {
	      return false;
	    }
	  }

	  return !isFirst;
	}
	});

	unwrapExports(identifier);
	var identifier_1 = identifier.isIdentifierStart;
	var identifier_2 = identifier.isIdentifierChar;
	var identifier_3 = identifier.isIdentifierName;

	var keyword = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.isReservedWord = isReservedWord;
	exports.isStrictReservedWord = isStrictReservedWord;
	exports.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
	exports.isStrictBindReservedWord = isStrictBindReservedWord;
	exports.isKeyword = isKeyword;
	const reservedWords = {
	  keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
	  strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
	  strictBind: ["eval", "arguments"]
	};
	const keywords = new Set(reservedWords.keyword);
	const reservedWordsStrictSet = new Set(reservedWords.strict);
	const reservedWordsStrictBindSet = new Set(reservedWords.strictBind);

	function isReservedWord(word, inModule) {
	  return inModule && word === "await" || word === "enum";
	}

	function isStrictReservedWord(word, inModule) {
	  return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
	}

	function isStrictBindOnlyReservedWord(word) {
	  return reservedWordsStrictBindSet.has(word);
	}

	function isStrictBindReservedWord(word, inModule) {
	  return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
	}

	function isKeyword(word) {
	  return keywords.has(word);
	}
	});

	unwrapExports(keyword);
	var keyword_1 = keyword.isReservedWord;
	var keyword_2 = keyword.isStrictReservedWord;
	var keyword_3 = keyword.isStrictBindOnlyReservedWord;
	var keyword_4 = keyword.isStrictBindReservedWord;
	var keyword_5 = keyword.isKeyword;

	var lib = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	Object.defineProperty(exports, "isIdentifierName", {
	  enumerable: true,
	  get: function () {
	    return identifier.isIdentifierName;
	  }
	});
	Object.defineProperty(exports, "isIdentifierChar", {
	  enumerable: true,
	  get: function () {
	    return identifier.isIdentifierChar;
	  }
	});
	Object.defineProperty(exports, "isIdentifierStart", {
	  enumerable: true,
	  get: function () {
	    return identifier.isIdentifierStart;
	  }
	});
	Object.defineProperty(exports, "isReservedWord", {
	  enumerable: true,
	  get: function () {
	    return keyword.isReservedWord;
	  }
	});
	Object.defineProperty(exports, "isStrictBindOnlyReservedWord", {
	  enumerable: true,
	  get: function () {
	    return keyword.isStrictBindOnlyReservedWord;
	  }
	});
	Object.defineProperty(exports, "isStrictBindReservedWord", {
	  enumerable: true,
	  get: function () {
	    return keyword.isStrictBindReservedWord;
	  }
	});
	Object.defineProperty(exports, "isStrictReservedWord", {
	  enumerable: true,
	  get: function () {
	    return keyword.isStrictReservedWord;
	  }
	});
	Object.defineProperty(exports, "isKeyword", {
	  enumerable: true,
	  get: function () {
	    return keyword.isKeyword;
	  }
	});
	});

	unwrapExports(lib);

	var isValidIdentifier_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isValidIdentifier;



	function isValidIdentifier(name, reserved = true) {
	  if (typeof name !== "string") return false;

	  if (reserved) {
	    if ((0, lib.isKeyword)(name) || (0, lib.isStrictReservedWord)(name)) {
	      return false;
	    } else if (name === "await") {
	      return false;
	    }
	  }

	  return (0, lib.isIdentifierName)(name);
	}
	});

	unwrapExports(isValidIdentifier_1);

	var constants = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.NOT_LOCAL_BINDING = exports.BLOCK_SCOPED_SYMBOL = exports.INHERIT_KEYS = exports.UNARY_OPERATORS = exports.STRING_UNARY_OPERATORS = exports.NUMBER_UNARY_OPERATORS = exports.BOOLEAN_UNARY_OPERATORS = exports.ASSIGNMENT_OPERATORS = exports.BINARY_OPERATORS = exports.NUMBER_BINARY_OPERATORS = exports.BOOLEAN_BINARY_OPERATORS = exports.COMPARISON_BINARY_OPERATORS = exports.EQUALITY_BINARY_OPERATORS = exports.BOOLEAN_NUMBER_BINARY_OPERATORS = exports.UPDATE_OPERATORS = exports.LOGICAL_OPERATORS = exports.COMMENT_KEYS = exports.FOR_INIT_KEYS = exports.FLATTENABLE_KEYS = exports.STATEMENT_OR_BLOCK_KEYS = void 0;
	const STATEMENT_OR_BLOCK_KEYS = ["consequent", "body", "alternate"];
	exports.STATEMENT_OR_BLOCK_KEYS = STATEMENT_OR_BLOCK_KEYS;
	const FLATTENABLE_KEYS = ["body", "expressions"];
	exports.FLATTENABLE_KEYS = FLATTENABLE_KEYS;
	const FOR_INIT_KEYS = ["left", "init"];
	exports.FOR_INIT_KEYS = FOR_INIT_KEYS;
	const COMMENT_KEYS = ["leadingComments", "trailingComments", "innerComments"];
	exports.COMMENT_KEYS = COMMENT_KEYS;
	const LOGICAL_OPERATORS = ["||", "&&", "??"];
	exports.LOGICAL_OPERATORS = LOGICAL_OPERATORS;
	const UPDATE_OPERATORS = ["++", "--"];
	exports.UPDATE_OPERATORS = UPDATE_OPERATORS;
	const BOOLEAN_NUMBER_BINARY_OPERATORS = [">", "<", ">=", "<="];
	exports.BOOLEAN_NUMBER_BINARY_OPERATORS = BOOLEAN_NUMBER_BINARY_OPERATORS;
	const EQUALITY_BINARY_OPERATORS = ["==", "===", "!=", "!=="];
	exports.EQUALITY_BINARY_OPERATORS = EQUALITY_BINARY_OPERATORS;
	const COMPARISON_BINARY_OPERATORS = [...EQUALITY_BINARY_OPERATORS, "in", "instanceof"];
	exports.COMPARISON_BINARY_OPERATORS = COMPARISON_BINARY_OPERATORS;
	const BOOLEAN_BINARY_OPERATORS = [...COMPARISON_BINARY_OPERATORS, ...BOOLEAN_NUMBER_BINARY_OPERATORS];
	exports.BOOLEAN_BINARY_OPERATORS = BOOLEAN_BINARY_OPERATORS;
	const NUMBER_BINARY_OPERATORS = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
	exports.NUMBER_BINARY_OPERATORS = NUMBER_BINARY_OPERATORS;
	const BINARY_OPERATORS = ["+", ...NUMBER_BINARY_OPERATORS, ...BOOLEAN_BINARY_OPERATORS];
	exports.BINARY_OPERATORS = BINARY_OPERATORS;
	const ASSIGNMENT_OPERATORS = ["=", "+=", ...NUMBER_BINARY_OPERATORS.map(op => op + "="), ...LOGICAL_OPERATORS.map(op => op + "=")];
	exports.ASSIGNMENT_OPERATORS = ASSIGNMENT_OPERATORS;
	const BOOLEAN_UNARY_OPERATORS = ["delete", "!"];
	exports.BOOLEAN_UNARY_OPERATORS = BOOLEAN_UNARY_OPERATORS;
	const NUMBER_UNARY_OPERATORS = ["+", "-", "~"];
	exports.NUMBER_UNARY_OPERATORS = NUMBER_UNARY_OPERATORS;
	const STRING_UNARY_OPERATORS = ["typeof"];
	exports.STRING_UNARY_OPERATORS = STRING_UNARY_OPERATORS;
	const UNARY_OPERATORS = ["void", "throw", ...BOOLEAN_UNARY_OPERATORS, ...NUMBER_UNARY_OPERATORS, ...STRING_UNARY_OPERATORS];
	exports.UNARY_OPERATORS = UNARY_OPERATORS;
	const INHERIT_KEYS = {
	  optional: ["typeAnnotation", "typeParameters", "returnType"],
	  force: ["start", "loc", "end"]
	};
	exports.INHERIT_KEYS = INHERIT_KEYS;
	const BLOCK_SCOPED_SYMBOL = Symbol.for("var used to be block scoped");
	exports.BLOCK_SCOPED_SYMBOL = BLOCK_SCOPED_SYMBOL;
	const NOT_LOCAL_BINDING = Symbol.for("should not be considered a local binding");
	exports.NOT_LOCAL_BINDING = NOT_LOCAL_BINDING;
	});

	unwrapExports(constants);
	var constants_1 = constants.NOT_LOCAL_BINDING;
	var constants_2 = constants.BLOCK_SCOPED_SYMBOL;
	var constants_3 = constants.INHERIT_KEYS;
	var constants_4 = constants.UNARY_OPERATORS;
	var constants_5 = constants.STRING_UNARY_OPERATORS;
	var constants_6 = constants.NUMBER_UNARY_OPERATORS;
	var constants_7 = constants.BOOLEAN_UNARY_OPERATORS;
	var constants_8 = constants.ASSIGNMENT_OPERATORS;
	var constants_9 = constants.BINARY_OPERATORS;
	var constants_10 = constants.NUMBER_BINARY_OPERATORS;
	var constants_11 = constants.BOOLEAN_BINARY_OPERATORS;
	var constants_12 = constants.COMPARISON_BINARY_OPERATORS;
	var constants_13 = constants.EQUALITY_BINARY_OPERATORS;
	var constants_14 = constants.BOOLEAN_NUMBER_BINARY_OPERATORS;
	var constants_15 = constants.UPDATE_OPERATORS;
	var constants_16 = constants.LOGICAL_OPERATORS;
	var constants_17 = constants.COMMENT_KEYS;
	var constants_18 = constants.FOR_INIT_KEYS;
	var constants_19 = constants.FLATTENABLE_KEYS;
	var constants_20 = constants.STATEMENT_OR_BLOCK_KEYS;

	var validate_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = validate;
	exports.validateField = validateField;
	exports.validateChild = validateChild;



	function validate(node, key, val) {
	  if (!node) return;
	  const fields = definitions.NODE_FIELDS[node.type];
	  if (!fields) return;
	  const field = fields[key];
	  validateField(node, key, val, field);
	  validateChild(node, key, val);
	}

	function validateField(node, key, val, field) {
	  if (!(field == null ? void 0 : field.validate)) return;
	  if (field.optional && val == null) return;
	  field.validate(node, key, val);
	}

	function validateChild(node, key, val) {
	  if (val == null) return;
	  const validate = definitions.NODE_PARENT_VALIDATIONS[val.type];
	  if (!validate) return;
	  validate(node, key, val);
	}
	});

	unwrapExports(validate_1);
	var validate_2 = validate_1.validateField;
	var validate_3 = validate_1.validateChild;

	var utils = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.validate = validate;
	exports.typeIs = typeIs;
	exports.validateType = validateType;
	exports.validateOptional = validateOptional;
	exports.validateOptionalType = validateOptionalType;
	exports.arrayOf = arrayOf;
	exports.arrayOfType = arrayOfType;
	exports.validateArrayOfType = validateArrayOfType;
	exports.assertEach = assertEach;
	exports.assertOneOf = assertOneOf;
	exports.assertNodeType = assertNodeType;
	exports.assertNodeOrValueType = assertNodeOrValueType;
	exports.assertValueType = assertValueType;
	exports.assertShape = assertShape;
	exports.assertOptionalChainStart = assertOptionalChainStart;
	exports.chain = chain;
	exports.default = defineType;
	exports.NODE_PARENT_VALIDATIONS = exports.DEPRECATED_KEYS = exports.BUILDER_KEYS = exports.NODE_FIELDS = exports.FLIPPED_ALIAS_KEYS = exports.ALIAS_KEYS = exports.VISITOR_KEYS = void 0;

	var _is = _interopRequireDefault(is_1);



	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	const VISITOR_KEYS = {};
	exports.VISITOR_KEYS = VISITOR_KEYS;
	const ALIAS_KEYS = {};
	exports.ALIAS_KEYS = ALIAS_KEYS;
	const FLIPPED_ALIAS_KEYS = {};
	exports.FLIPPED_ALIAS_KEYS = FLIPPED_ALIAS_KEYS;
	const NODE_FIELDS = {};
	exports.NODE_FIELDS = NODE_FIELDS;
	const BUILDER_KEYS = {};
	exports.BUILDER_KEYS = BUILDER_KEYS;
	const DEPRECATED_KEYS = {};
	exports.DEPRECATED_KEYS = DEPRECATED_KEYS;
	const NODE_PARENT_VALIDATIONS = {};
	exports.NODE_PARENT_VALIDATIONS = NODE_PARENT_VALIDATIONS;

	function getType(val) {
	  if (Array.isArray(val)) {
	    return "array";
	  } else if (val === null) {
	    return "null";
	  } else {
	    return typeof val;
	  }
	}

	function validate(validate) {
	  return {
	    validate
	  };
	}

	function typeIs(typeName) {
	  return typeof typeName === "string" ? assertNodeType(typeName) : assertNodeType(...typeName);
	}

	function validateType(typeName) {
	  return validate(typeIs(typeName));
	}

	function validateOptional(validate) {
	  return {
	    validate,
	    optional: true
	  };
	}

	function validateOptionalType(typeName) {
	  return {
	    validate: typeIs(typeName),
	    optional: true
	  };
	}

	function arrayOf(elementType) {
	  return chain(assertValueType("array"), assertEach(elementType));
	}

	function arrayOfType(typeName) {
	  return arrayOf(typeIs(typeName));
	}

	function validateArrayOfType(typeName) {
	  return validate(arrayOfType(typeName));
	}

	function assertEach(callback) {
	  function validator(node, key, val) {
	    if (!Array.isArray(val)) return;

	    for (let i = 0; i < val.length; i++) {
	      const subkey = `${key}[${i}]`;
	      const v = val[i];
	      callback(node, subkey, v);
	      if (process.env.BABEL_TYPES_8_BREAKING) (0, validate_1.validateChild)(node, subkey, v);
	    }
	  }

	  validator.each = callback;
	  return validator;
	}

	function assertOneOf(...values) {
	  function validate(node, key, val) {
	    if (values.indexOf(val) < 0) {
	      throw new TypeError(`Property ${key} expected value to be one of ${JSON.stringify(values)} but got ${JSON.stringify(val)}`);
	    }
	  }

	  validate.oneOf = values;
	  return validate;
	}

	function assertNodeType(...types) {
	  function validate(node, key, val) {
	    for (const type of types) {
	      if ((0, _is.default)(type, val)) {
	        (0, validate_1.validateChild)(node, key, val);
	        return;
	      }
	    }

	    throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
	  }

	  validate.oneOfNodeTypes = types;
	  return validate;
	}

	function assertNodeOrValueType(...types) {
	  function validate(node, key, val) {
	    for (const type of types) {
	      if (getType(val) === type || (0, _is.default)(type, val)) {
	        (0, validate_1.validateChild)(node, key, val);
	        return;
	      }
	    }

	    throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
	  }

	  validate.oneOfNodeOrValueTypes = types;
	  return validate;
	}

	function assertValueType(type) {
	  function validate(node, key, val) {
	    const valid = getType(val) === type;

	    if (!valid) {
	      throw new TypeError(`Property ${key} expected type of ${type} but got ${getType(val)}`);
	    }
	  }

	  validate.type = type;
	  return validate;
	}

	function assertShape(shape) {
	  function validate(node, key, val) {
	    const errors = [];

	    for (const property of Object.keys(shape)) {
	      try {
	        (0, validate_1.validateField)(node, property, val[property], shape[property]);
	      } catch (error) {
	        if (error instanceof TypeError) {
	          errors.push(error.message);
	          continue;
	        }

	        throw error;
	      }
	    }

	    if (errors.length) {
	      throw new TypeError(`Property ${key} of ${node.type} expected to have the following:\n${errors.join("\n")}`);
	    }
	  }

	  validate.shapeOf = shape;
	  return validate;
	}

	function assertOptionalChainStart() {
	  function validate(node) {
	    var _current;

	    let current = node;

	    while (node) {
	      const {
	        type
	      } = current;

	      if (type === "OptionalCallExpression") {
	        if (current.optional) return;
	        current = current.callee;
	        continue;
	      }

	      if (type === "OptionalMemberExpression") {
	        if (current.optional) return;
	        current = current.object;
	        continue;
	      }

	      break;
	    }

	    throw new TypeError(`Non-optional ${node.type} must chain from an optional OptionalMemberExpression or OptionalCallExpression. Found chain from ${(_current = current) == null ? void 0 : _current.type}`);
	  }

	  return validate;
	}

	function chain(...fns) {
	  function validate(...args) {
	    for (const fn of fns) {
	      fn(...args);
	    }
	  }

	  validate.chainOf = fns;
	  return validate;
	}

	const validTypeOpts = ["aliases", "builder", "deprecatedAlias", "fields", "inherits", "visitor", "validate"];
	const validFieldKeys = ["default", "optional", "validate"];

	function defineType(type, opts = {}) {
	  const inherits = opts.inherits && store[opts.inherits] || {};
	  let fields = opts.fields;

	  if (!fields) {
	    fields = {};

	    if (inherits.fields) {
	      const keys = Object.getOwnPropertyNames(inherits.fields);

	      for (const key of keys) {
	        const field = inherits.fields[key];
	        fields[key] = {
	          default: field.default,
	          optional: field.optional,
	          validate: field.validate
	        };
	      }
	    }
	  }

	  const visitor = opts.visitor || inherits.visitor || [];
	  const aliases = opts.aliases || inherits.aliases || [];
	  const builder = opts.builder || inherits.builder || opts.visitor || [];

	  for (const k of Object.keys(opts)) {
	    if (validTypeOpts.indexOf(k) === -1) {
	      throw new Error(`Unknown type option "${k}" on ${type}`);
	    }
	  }

	  if (opts.deprecatedAlias) {
	    DEPRECATED_KEYS[opts.deprecatedAlias] = type;
	  }

	  for (const key of visitor.concat(builder)) {
	    fields[key] = fields[key] || {};
	  }

	  for (const key of Object.keys(fields)) {
	    const field = fields[key];

	    if (field.default !== undefined && builder.indexOf(key) === -1) {
	      field.optional = true;
	    }

	    if (field.default === undefined) {
	      field.default = null;
	    } else if (!field.validate && field.default != null) {
	      field.validate = assertValueType(getType(field.default));
	    }

	    for (const k of Object.keys(field)) {
	      if (validFieldKeys.indexOf(k) === -1) {
	        throw new Error(`Unknown field key "${k}" on ${type}.${key}`);
	      }
	    }
	  }

	  VISITOR_KEYS[type] = opts.visitor = visitor;
	  BUILDER_KEYS[type] = opts.builder = builder;
	  NODE_FIELDS[type] = opts.fields = fields;
	  ALIAS_KEYS[type] = opts.aliases = aliases;
	  aliases.forEach(alias => {
	    FLIPPED_ALIAS_KEYS[alias] = FLIPPED_ALIAS_KEYS[alias] || [];
	    FLIPPED_ALIAS_KEYS[alias].push(type);
	  });

	  if (opts.validate) {
	    NODE_PARENT_VALIDATIONS[type] = opts.validate;
	  }

	  store[type] = opts;
	}

	const store = {};
	});

	unwrapExports(utils);
	var utils_1 = utils.validate;
	var utils_2 = utils.typeIs;
	var utils_3 = utils.validateType;
	var utils_4 = utils.validateOptional;
	var utils_5 = utils.validateOptionalType;
	var utils_6 = utils.arrayOf;
	var utils_7 = utils.arrayOfType;
	var utils_8 = utils.validateArrayOfType;
	var utils_9 = utils.assertEach;
	var utils_10 = utils.assertOneOf;
	var utils_11 = utils.assertNodeType;
	var utils_12 = utils.assertNodeOrValueType;
	var utils_13 = utils.assertValueType;
	var utils_14 = utils.assertShape;
	var utils_15 = utils.assertOptionalChainStart;
	var utils_16 = utils.chain;
	var utils_17 = utils.NODE_PARENT_VALIDATIONS;
	var utils_18 = utils.DEPRECATED_KEYS;
	var utils_19 = utils.BUILDER_KEYS;
	var utils_20 = utils.NODE_FIELDS;
	var utils_21 = utils.FLIPPED_ALIAS_KEYS;
	var utils_22 = utils.ALIAS_KEYS;
	var utils_23 = utils.VISITOR_KEYS;

	var core = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.classMethodOrDeclareMethodCommon = exports.classMethodOrPropertyCommon = exports.patternLikeCommon = exports.functionDeclarationCommon = exports.functionTypeAnnotationCommon = exports.functionCommon = void 0;

	var _is = _interopRequireDefault(is_1);

	var _isValidIdentifier = _interopRequireDefault(isValidIdentifier_1);





	var _utils = _interopRequireWildcard(utils);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	(0, _utils.default)("ArrayExpression", {
	  fields: {
	    elements: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "Expression", "SpreadElement"))),
	      default: !process.env.BABEL_TYPES_8_BREAKING ? [] : undefined
	    }
	  },
	  visitor: ["elements"],
	  aliases: ["Expression"]
	});
	(0, _utils.default)("AssignmentExpression", {
	  fields: {
	    operator: {
	      validate: function () {
	        if (!process.env.BABEL_TYPES_8_BREAKING) {
	          return (0, _utils.assertValueType)("string");
	        }

	        const identifier = (0, _utils.assertOneOf)(...constants.ASSIGNMENT_OPERATORS);
	        const pattern = (0, _utils.assertOneOf)("=");
	        return function (node, key, val) {
	          const validator = (0, _is.default)("Pattern", node.left) ? pattern : identifier;
	          validator(node, key, val);
	        };
	      }()
	    },
	    left: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
	    },
	    right: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  },
	  builder: ["operator", "left", "right"],
	  visitor: ["left", "right"],
	  aliases: ["Expression"]
	});
	(0, _utils.default)("BinaryExpression", {
	  builder: ["operator", "left", "right"],
	  fields: {
	    operator: {
	      validate: (0, _utils.assertOneOf)(...constants.BINARY_OPERATORS)
	    },
	    left: {
	      validate: function () {
	        const expression = (0, _utils.assertNodeType)("Expression");
	        const inOp = (0, _utils.assertNodeType)("Expression", "PrivateName");

	        const validator = function (node, key, val) {
	          const validator = node.operator === "in" ? inOp : expression;
	          validator(node, key, val);
	        };

	        validator.oneOfNodeTypes = ["Expression", "PrivateName"];
	        return validator;
	      }()
	    },
	    right: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  },
	  visitor: ["left", "right"],
	  aliases: ["Binary", "Expression"]
	});
	(0, _utils.default)("InterpreterDirective", {
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  }
	});
	(0, _utils.default)("Directive", {
	  visitor: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertNodeType)("DirectiveLiteral")
	    }
	  }
	});
	(0, _utils.default)("DirectiveLiteral", {
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  }
	});
	(0, _utils.default)("BlockStatement", {
	  builder: ["body", "directives"],
	  visitor: ["directives", "body"],
	  fields: {
	    directives: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Directive"))),
	      default: []
	    },
	    body: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
	    }
	  },
	  aliases: ["Scopable", "BlockParent", "Block", "Statement"]
	});
	(0, _utils.default)("BreakStatement", {
	  visitor: ["label"],
	  fields: {
	    label: {
	      validate: (0, _utils.assertNodeType)("Identifier"),
	      optional: true
	    }
	  },
	  aliases: ["Statement", "Terminatorless", "CompletionStatement"]
	});
	(0, _utils.default)("CallExpression", {
	  visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
	  builder: ["callee", "arguments"],
	  aliases: ["Expression"],
	  fields: Object.assign({
	    callee: {
	      validate: (0, _utils.assertNodeType)("Expression", "V8IntrinsicIdentifier")
	    },
	    arguments: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement", "JSXNamespacedName", "ArgumentPlaceholder")))
	    }
	  }, !process.env.BABEL_TYPES_8_BREAKING ? {
	    optional: {
	      validate: (0, _utils.assertOneOf)(true, false),
	      optional: true
	    }
	  } : {}, {
	    typeArguments: {
	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
	      optional: true
	    },
	    typeParameters: {
	      validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
	      optional: true
	    }
	  })
	});
	(0, _utils.default)("CatchClause", {
	  visitor: ["param", "body"],
	  fields: {
	    param: {
	      validate: (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern"),
	      optional: true
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  },
	  aliases: ["Scopable", "BlockParent"]
	});
	(0, _utils.default)("ConditionalExpression", {
	  visitor: ["test", "consequent", "alternate"],
	  fields: {
	    test: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    consequent: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    alternate: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  },
	  aliases: ["Expression", "Conditional"]
	});
	(0, _utils.default)("ContinueStatement", {
	  visitor: ["label"],
	  fields: {
	    label: {
	      validate: (0, _utils.assertNodeType)("Identifier"),
	      optional: true
	    }
	  },
	  aliases: ["Statement", "Terminatorless", "CompletionStatement"]
	});
	(0, _utils.default)("DebuggerStatement", {
	  aliases: ["Statement"]
	});
	(0, _utils.default)("DoWhileStatement", {
	  visitor: ["test", "body"],
	  fields: {
	    test: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  },
	  aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"]
	});
	(0, _utils.default)("EmptyStatement", {
	  aliases: ["Statement"]
	});
	(0, _utils.default)("ExpressionStatement", {
	  visitor: ["expression"],
	  fields: {
	    expression: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  },
	  aliases: ["Statement", "ExpressionWrapper"]
	});
	(0, _utils.default)("File", {
	  builder: ["program", "comments", "tokens"],
	  visitor: ["program"],
	  fields: {
	    program: {
	      validate: (0, _utils.assertNodeType)("Program")
	    },
	    comments: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? Object.assign(() => {}, {
	        each: {
	          oneOfNodeTypes: ["CommentBlock", "CommentLine"]
	        }
	      }) : (0, _utils.assertEach)((0, _utils.assertNodeType)("CommentBlock", "CommentLine")),
	      optional: true
	    },
	    tokens: {
	      validate: (0, _utils.assertEach)(Object.assign(() => {}, {
	        type: "any"
	      })),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("ForInStatement", {
	  visitor: ["left", "right", "body"],
	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
	  fields: {
	    left: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("VariableDeclaration", "LVal") : (0, _utils.assertNodeType)("VariableDeclaration", "Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
	    },
	    right: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  }
	});
	(0, _utils.default)("ForStatement", {
	  visitor: ["init", "test", "update", "body"],
	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop"],
	  fields: {
	    init: {
	      validate: (0, _utils.assertNodeType)("VariableDeclaration", "Expression"),
	      optional: true
	    },
	    test: {
	      validate: (0, _utils.assertNodeType)("Expression"),
	      optional: true
	    },
	    update: {
	      validate: (0, _utils.assertNodeType)("Expression"),
	      optional: true
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  }
	});
	const functionCommon = {
	  params: {
	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Identifier", "Pattern", "RestElement", "TSParameterProperty")))
	  },
	  generator: {
	    default: false
	  },
	  async: {
	    default: false
	  }
	};
	exports.functionCommon = functionCommon;
	const functionTypeAnnotationCommon = {
	  returnType: {
	    validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
	    optional: true
	  },
	  typeParameters: {
	    validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
	    optional: true
	  }
	};
	exports.functionTypeAnnotationCommon = functionTypeAnnotationCommon;
	const functionDeclarationCommon = Object.assign({}, functionCommon, {
	  declare: {
	    validate: (0, _utils.assertValueType)("boolean"),
	    optional: true
	  },
	  id: {
	    validate: (0, _utils.assertNodeType)("Identifier"),
	    optional: true
	  }
	});
	exports.functionDeclarationCommon = functionDeclarationCommon;
	(0, _utils.default)("FunctionDeclaration", {
	  builder: ["id", "params", "body", "generator", "async"],
	  visitor: ["id", "params", "body", "returnType", "typeParameters"],
	  fields: Object.assign({}, functionDeclarationCommon, functionTypeAnnotationCommon, {
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  }),
	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Statement", "Pureish", "Declaration"],
	  validate: function () {
	    if (!process.env.BABEL_TYPES_8_BREAKING) return () => {};
	    const identifier = (0, _utils.assertNodeType)("Identifier");
	    return function (parent, key, node) {
	      if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
	        identifier(node, "id", node.id);
	      }
	    };
	  }()
	});
	(0, _utils.default)("FunctionExpression", {
	  inherits: "FunctionDeclaration",
	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
	    id: {
	      validate: (0, _utils.assertNodeType)("Identifier"),
	      optional: true
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  })
	});
	const patternLikeCommon = {
	  typeAnnotation: {
	    validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
	    optional: true
	  },
	  decorators: {
	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator")))
	  }
	};
	exports.patternLikeCommon = patternLikeCommon;
	(0, _utils.default)("Identifier", {
	  builder: ["name"],
	  visitor: ["typeAnnotation", "decorators"],
	  aliases: ["Expression", "PatternLike", "LVal", "TSEntityName"],
	  fields: Object.assign({}, patternLikeCommon, {
	    name: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (!(0, _isValidIdentifier.default)(val, false)) {
	          throw new TypeError(`"${val}" is not a valid identifier name`);
	        }
	      }, {
	        type: "string"
	      }))
	    },
	    optional: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    }
	  }),

	  validate(parent, key, node) {
	    if (!process.env.BABEL_TYPES_8_BREAKING) return;
	    const match = /\.(\w+)$/.exec(key);
	    if (!match) return;
	    const [, parentKey] = match;
	    const nonComp = {
	      computed: false
	    };

	    if (parentKey === "property") {
	      if ((0, _is.default)("MemberExpression", parent, nonComp)) return;
	      if ((0, _is.default)("OptionalMemberExpression", parent, nonComp)) return;
	    } else if (parentKey === "key") {
	      if ((0, _is.default)("Property", parent, nonComp)) return;
	      if ((0, _is.default)("Method", parent, nonComp)) return;
	    } else if (parentKey === "exported") {
	      if ((0, _is.default)("ExportSpecifier", parent)) return;
	    } else if (parentKey === "imported") {
	      if ((0, _is.default)("ImportSpecifier", parent, {
	        imported: node
	      })) return;
	    } else if (parentKey === "meta") {
	      if ((0, _is.default)("MetaProperty", parent, {
	        meta: node
	      })) return;
	    }

	    if (((0, lib.isKeyword)(node.name) || (0, lib.isReservedWord)(node.name)) && node.name !== "this") {
	      throw new TypeError(`"${node.name}" is not a valid identifier`);
	    }
	  }

	});
	(0, _utils.default)("IfStatement", {
	  visitor: ["test", "consequent", "alternate"],
	  aliases: ["Statement", "Conditional"],
	  fields: {
	    test: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    consequent: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    },
	    alternate: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  }
	});
	(0, _utils.default)("LabeledStatement", {
	  visitor: ["label", "body"],
	  aliases: ["Statement"],
	  fields: {
	    label: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  }
	});
	(0, _utils.default)("StringLiteral", {
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  },
	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
	});
	(0, _utils.default)("NumericLiteral", {
	  builder: ["value"],
	  deprecatedAlias: "NumberLiteral",
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("number")
	    }
	  },
	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
	});
	(0, _utils.default)("NullLiteral", {
	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
	});
	(0, _utils.default)("BooleanLiteral", {
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("boolean")
	    }
	  },
	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
	});
	(0, _utils.default)("RegExpLiteral", {
	  builder: ["pattern", "flags"],
	  deprecatedAlias: "RegexLiteral",
	  aliases: ["Expression", "Pureish", "Literal"],
	  fields: {
	    pattern: {
	      validate: (0, _utils.assertValueType)("string")
	    },
	    flags: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;
	        const invalid = /[^gimsuy]/.exec(val);

	        if (invalid) {
	          throw new TypeError(`"${invalid[0]}" is not a valid RegExp flag`);
	        }
	      }, {
	        type: "string"
	      })),
	      default: ""
	    }
	  }
	});
	(0, _utils.default)("LogicalExpression", {
	  builder: ["operator", "left", "right"],
	  visitor: ["left", "right"],
	  aliases: ["Binary", "Expression"],
	  fields: {
	    operator: {
	      validate: (0, _utils.assertOneOf)(...constants.LOGICAL_OPERATORS)
	    },
	    left: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    right: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("MemberExpression", {
	  builder: ["object", "property", "computed", "optional"],
	  visitor: ["object", "property"],
	  aliases: ["Expression", "LVal"],
	  fields: Object.assign({
	    object: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    property: {
	      validate: function () {
	        const normal = (0, _utils.assertNodeType)("Identifier", "PrivateName");
	        const computed = (0, _utils.assertNodeType)("Expression");

	        const validator = function (node, key, val) {
	          const validator = node.computed ? computed : normal;
	          validator(node, key, val);
	        };

	        validator.oneOfNodeTypes = ["Expression", "Identifier", "PrivateName"];
	        return validator;
	      }()
	    },
	    computed: {
	      default: false
	    }
	  }, !process.env.BABEL_TYPES_8_BREAKING ? {
	    optional: {
	      validate: (0, _utils.assertOneOf)(true, false),
	      optional: true
	    }
	  } : {})
	});
	(0, _utils.default)("NewExpression", {
	  inherits: "CallExpression"
	});
	(0, _utils.default)("Program", {
	  visitor: ["directives", "body"],
	  builder: ["body", "directives", "sourceType", "interpreter"],
	  fields: {
	    sourceFile: {
	      validate: (0, _utils.assertValueType)("string")
	    },
	    sourceType: {
	      validate: (0, _utils.assertOneOf)("script", "module"),
	      default: "script"
	    },
	    interpreter: {
	      validate: (0, _utils.assertNodeType)("InterpreterDirective"),
	      default: null,
	      optional: true
	    },
	    directives: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Directive"))),
	      default: []
	    },
	    body: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
	    }
	  },
	  aliases: ["Scopable", "BlockParent", "Block"]
	});
	(0, _utils.default)("ObjectExpression", {
	  visitor: ["properties"],
	  aliases: ["Expression"],
	  fields: {
	    properties: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ObjectMethod", "ObjectProperty", "SpreadElement")))
	    }
	  }
	});
	(0, _utils.default)("ObjectMethod", {
	  builder: ["kind", "key", "params", "body", "computed", "generator", "async"],
	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
	    kind: Object.assign({
	      validate: (0, _utils.assertOneOf)("method", "get", "set")
	    }, !process.env.BABEL_TYPES_8_BREAKING ? {
	      default: "method"
	    } : {}),
	    computed: {
	      default: false
	    },
	    key: {
	      validate: function () {
	        const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
	        const computed = (0, _utils.assertNodeType)("Expression");

	        const validator = function (node, key, val) {
	          const validator = node.computed ? computed : normal;
	          validator(node, key, val);
	        };

	        validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
	        return validator;
	      }()
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  }),
	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
	  aliases: ["UserWhitespacable", "Function", "Scopable", "BlockParent", "FunctionParent", "Method", "ObjectMember"]
	});
	(0, _utils.default)("ObjectProperty", {
	  builder: ["key", "value", "computed", "shorthand", ...(!process.env.BABEL_TYPES_8_BREAKING ? ["decorators"] : [])],
	  fields: {
	    computed: {
	      default: false
	    },
	    key: {
	      validate: function () {
	        const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
	        const computed = (0, _utils.assertNodeType)("Expression");

	        const validator = function (node, key, val) {
	          const validator = node.computed ? computed : normal;
	          validator(node, key, val);
	        };

	        validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
	        return validator;
	      }()
	    },
	    value: {
	      validate: (0, _utils.assertNodeType)("Expression", "PatternLike")
	    },
	    shorthand: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (val && node.computed) {
	          throw new TypeError("Property shorthand of ObjectProperty cannot be true if computed is true");
	        }
	      }, {
	        type: "boolean"
	      }), function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (val && !(0, _is.default)("Identifier", node.key)) {
	          throw new TypeError("Property shorthand of ObjectProperty cannot be true if key is not an Identifier");
	        }
	      }),
	      default: false
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    }
	  },
	  visitor: ["key", "value", "decorators"],
	  aliases: ["UserWhitespacable", "Property", "ObjectMember"],
	  validate: function () {
	    const pattern = (0, _utils.assertNodeType)("Identifier", "Pattern");
	    const expression = (0, _utils.assertNodeType)("Expression");
	    return function (parent, key, node) {
	      if (!process.env.BABEL_TYPES_8_BREAKING) return;
	      const validator = (0, _is.default)("ObjectPattern", parent) ? pattern : expression;
	      validator(node, "value", node.value);
	    };
	  }()
	});
	(0, _utils.default)("RestElement", {
	  visitor: ["argument", "typeAnnotation"],
	  builder: ["argument"],
	  aliases: ["LVal", "PatternLike"],
	  deprecatedAlias: "RestProperty",
	  fields: Object.assign({}, patternLikeCommon, {
	    argument: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "Pattern", "MemberExpression")
	    }
	  }),

	  validate(parent, key) {
	    if (!process.env.BABEL_TYPES_8_BREAKING) return;
	    const match = /(\w+)\[(\d+)\]/.exec(key);
	    if (!match) throw new Error("Internal Babel error: malformed key.");
	    const [, listKey, index] = match;

	    if (parent[listKey].length > index + 1) {
	      throw new TypeError(`RestElement must be last element of ${listKey}`);
	    }
	  }

	});
	(0, _utils.default)("ReturnStatement", {
	  visitor: ["argument"],
	  aliases: ["Statement", "Terminatorless", "CompletionStatement"],
	  fields: {
	    argument: {
	      validate: (0, _utils.assertNodeType)("Expression"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("SequenceExpression", {
	  visitor: ["expressions"],
	  fields: {
	    expressions: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression")))
	    }
	  },
	  aliases: ["Expression"]
	});
	(0, _utils.default)("ParenthesizedExpression", {
	  visitor: ["expression"],
	  aliases: ["Expression", "ExpressionWrapper"],
	  fields: {
	    expression: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("SwitchCase", {
	  visitor: ["test", "consequent"],
	  fields: {
	    test: {
	      validate: (0, _utils.assertNodeType)("Expression"),
	      optional: true
	    },
	    consequent: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
	    }
	  }
	});
	(0, _utils.default)("SwitchStatement", {
	  visitor: ["discriminant", "cases"],
	  aliases: ["Statement", "BlockParent", "Scopable"],
	  fields: {
	    discriminant: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    cases: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("SwitchCase")))
	    }
	  }
	});
	(0, _utils.default)("ThisExpression", {
	  aliases: ["Expression"]
	});
	(0, _utils.default)("ThrowStatement", {
	  visitor: ["argument"],
	  aliases: ["Statement", "Terminatorless", "CompletionStatement"],
	  fields: {
	    argument: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("TryStatement", {
	  visitor: ["block", "handler", "finalizer"],
	  aliases: ["Statement"],
	  fields: {
	    block: {
	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("BlockStatement"), Object.assign(function (node) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (!node.handler && !node.finalizer) {
	          throw new TypeError("TryStatement expects either a handler or finalizer, or both");
	        }
	      }, {
	        oneOfNodeTypes: ["BlockStatement"]
	      }))
	    },
	    handler: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("CatchClause")
	    },
	    finalizer: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  }
	});
	(0, _utils.default)("UnaryExpression", {
	  builder: ["operator", "argument", "prefix"],
	  fields: {
	    prefix: {
	      default: true
	    },
	    argument: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    operator: {
	      validate: (0, _utils.assertOneOf)(...constants.UNARY_OPERATORS)
	    }
	  },
	  visitor: ["argument"],
	  aliases: ["UnaryLike", "Expression"]
	});
	(0, _utils.default)("UpdateExpression", {
	  builder: ["operator", "argument", "prefix"],
	  fields: {
	    prefix: {
	      default: false
	    },
	    argument: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("Expression") : (0, _utils.assertNodeType)("Identifier", "MemberExpression")
	    },
	    operator: {
	      validate: (0, _utils.assertOneOf)(...constants.UPDATE_OPERATORS)
	    }
	  },
	  visitor: ["argument"],
	  aliases: ["Expression"]
	});
	(0, _utils.default)("VariableDeclaration", {
	  builder: ["kind", "declarations"],
	  visitor: ["declarations"],
	  aliases: ["Statement", "Declaration"],
	  fields: {
	    declare: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    },
	    kind: {
	      validate: (0, _utils.assertOneOf)("var", "let", "const")
	    },
	    declarations: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("VariableDeclarator")))
	    }
	  },

	  validate(parent, key, node) {
	    if (!process.env.BABEL_TYPES_8_BREAKING) return;
	    if (!(0, _is.default)("ForXStatement", parent, {
	      left: node
	    })) return;

	    if (node.declarations.length !== 1) {
	      throw new TypeError(`Exactly one VariableDeclarator is required in the VariableDeclaration of a ${parent.type}`);
	    }
	  }

	});
	(0, _utils.default)("VariableDeclarator", {
	  visitor: ["id", "init"],
	  fields: {
	    id: {
	      validate: function () {
	        if (!process.env.BABEL_TYPES_8_BREAKING) {
	          return (0, _utils.assertNodeType)("LVal");
	        }

	        const normal = (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern");
	        const without = (0, _utils.assertNodeType)("Identifier");
	        return function (node, key, val) {
	          const validator = node.init ? normal : without;
	          validator(node, key, val);
	        };
	      }()
	    },
	    definite: {
	      optional: true,
	      validate: (0, _utils.assertValueType)("boolean")
	    },
	    init: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("WhileStatement", {
	  visitor: ["test", "body"],
	  aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"],
	  fields: {
	    test: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  }
	});
	(0, _utils.default)("WithStatement", {
	  visitor: ["object", "body"],
	  aliases: ["Statement"],
	  fields: {
	    object: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    }
	  }
	});
	(0, _utils.default)("AssignmentPattern", {
	  visitor: ["left", "right", "decorators"],
	  builder: ["left", "right"],
	  aliases: ["Pattern", "PatternLike", "LVal"],
	  fields: Object.assign({}, patternLikeCommon, {
	    left: {
	      validate: (0, _utils.assertNodeType)("Identifier", "ObjectPattern", "ArrayPattern", "MemberExpression")
	    },
	    right: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    }
	  })
	});
	(0, _utils.default)("ArrayPattern", {
	  visitor: ["elements", "typeAnnotation"],
	  builder: ["elements"],
	  aliases: ["Pattern", "PatternLike", "LVal"],
	  fields: Object.assign({}, patternLikeCommon, {
	    elements: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "PatternLike")))
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    }
	  })
	});
	(0, _utils.default)("ArrowFunctionExpression", {
	  builder: ["params", "body", "async"],
	  visitor: ["params", "body", "returnType", "typeParameters"],
	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
	    expression: {
	      validate: (0, _utils.assertValueType)("boolean")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement", "Expression")
	    }
	  })
	});
	(0, _utils.default)("ClassBody", {
	  visitor: ["body"],
	  fields: {
	    body: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ClassMethod", "ClassPrivateMethod", "ClassProperty", "ClassPrivateProperty", "TSDeclareMethod", "TSIndexSignature")))
	    }
	  }
	});
	(0, _utils.default)("ClassExpression", {
	  builder: ["id", "superClass", "body", "decorators"],
	  visitor: ["id", "body", "superClass", "mixins", "typeParameters", "superTypeParameters", "implements", "decorators"],
	  aliases: ["Scopable", "Class", "Expression"],
	  fields: {
	    id: {
	      validate: (0, _utils.assertNodeType)("Identifier"),
	      optional: true
	    },
	    typeParameters: {
	      validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
	      optional: true
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("ClassBody")
	    },
	    superClass: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    superTypeParameters: {
	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
	      optional: true
	    },
	    implements: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
	      optional: true
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    },
	    mixins: {
	      validate: (0, _utils.assertNodeType)("InterfaceExtends"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("ClassDeclaration", {
	  inherits: "ClassExpression",
	  aliases: ["Scopable", "Class", "Statement", "Declaration"],
	  fields: {
	    id: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    },
	    typeParameters: {
	      validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
	      optional: true
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("ClassBody")
	    },
	    superClass: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    superTypeParameters: {
	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
	      optional: true
	    },
	    implements: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
	      optional: true
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    },
	    mixins: {
	      validate: (0, _utils.assertNodeType)("InterfaceExtends"),
	      optional: true
	    },
	    declare: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    },
	    abstract: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    }
	  },
	  validate: function () {
	    const identifier = (0, _utils.assertNodeType)("Identifier");
	    return function (parent, key, node) {
	      if (!process.env.BABEL_TYPES_8_BREAKING) return;

	      if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
	        identifier(node, "id", node.id);
	      }
	    };
	  }()
	});
	(0, _utils.default)("ExportAllDeclaration", {
	  visitor: ["source"],
	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
	  fields: {
	    source: {
	      validate: (0, _utils.assertNodeType)("StringLiteral")
	    },
	    assertions: {
	      optional: true,
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertNodeType)("ImportAttribute"))
	    }
	  }
	});
	(0, _utils.default)("ExportDefaultDeclaration", {
	  visitor: ["declaration"],
	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
	  fields: {
	    declaration: {
	      validate: (0, _utils.assertNodeType)("FunctionDeclaration", "TSDeclareFunction", "ClassDeclaration", "Expression")
	    }
	  }
	});
	(0, _utils.default)("ExportNamedDeclaration", {
	  visitor: ["declaration", "specifiers", "source"],
	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
	  fields: {
	    declaration: {
	      optional: true,
	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("Declaration"), Object.assign(function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (val && node.specifiers.length) {
	          throw new TypeError("Only declaration or specifiers is allowed on ExportNamedDeclaration");
	        }
	      }, {
	        oneOfNodeTypes: ["Declaration"]
	      }), function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (val && node.source) {
	          throw new TypeError("Cannot export a declaration from a source");
	        }
	      })
	    },
	    assertions: {
	      optional: true,
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertNodeType)("ImportAttribute"))
	    },
	    specifiers: {
	      default: [],
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)(function () {
	        const sourced = (0, _utils.assertNodeType)("ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier");
	        const sourceless = (0, _utils.assertNodeType)("ExportSpecifier");
	        if (!process.env.BABEL_TYPES_8_BREAKING) return sourced;
	        return function (node, key, val) {
	          const validator = node.source ? sourced : sourceless;
	          validator(node, key, val);
	        };
	      }()))
	    },
	    source: {
	      validate: (0, _utils.assertNodeType)("StringLiteral"),
	      optional: true
	    },
	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
	  }
	});
	(0, _utils.default)("ExportSpecifier", {
	  visitor: ["local", "exported"],
	  aliases: ["ModuleSpecifier"],
	  fields: {
	    local: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    },
	    exported: {
	      validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
	    }
	  }
	});
	(0, _utils.default)("ForOfStatement", {
	  visitor: ["left", "right", "body"],
	  builder: ["left", "right", "body", "await"],
	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
	  fields: {
	    left: {
	      validate: function () {
	        if (!process.env.BABEL_TYPES_8_BREAKING) {
	          return (0, _utils.assertNodeType)("VariableDeclaration", "LVal");
	        }

	        const declaration = (0, _utils.assertNodeType)("VariableDeclaration");
	        const lval = (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern");
	        return function (node, key, val) {
	          if ((0, _is.default)("VariableDeclaration", val)) {
	            declaration(node, key, val);
	          } else {
	            lval(node, key, val);
	          }
	        };
	      }()
	    },
	    right: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("Statement")
	    },
	    await: {
	      default: false
	    }
	  }
	});
	(0, _utils.default)("ImportDeclaration", {
	  visitor: ["specifiers", "source"],
	  aliases: ["Statement", "Declaration", "ModuleDeclaration"],
	  fields: {
	    assertions: {
	      optional: true,
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertNodeType)("ImportAttribute"))
	    },
	    specifiers: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier")))
	    },
	    source: {
	      validate: (0, _utils.assertNodeType)("StringLiteral")
	    },
	    importKind: {
	      validate: (0, _utils.assertOneOf)("type", "typeof", "value"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("ImportDefaultSpecifier", {
	  visitor: ["local"],
	  aliases: ["ModuleSpecifier"],
	  fields: {
	    local: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    }
	  }
	});
	(0, _utils.default)("ImportNamespaceSpecifier", {
	  visitor: ["local"],
	  aliases: ["ModuleSpecifier"],
	  fields: {
	    local: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    }
	  }
	});
	(0, _utils.default)("ImportSpecifier", {
	  visitor: ["local", "imported"],
	  aliases: ["ModuleSpecifier"],
	  fields: {
	    local: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    },
	    imported: {
	      validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
	    },
	    importKind: {
	      validate: (0, _utils.assertOneOf)("type", "typeof"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("MetaProperty", {
	  visitor: ["meta", "property"],
	  aliases: ["Expression"],
	  fields: {
	    meta: {
	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("Identifier"), Object.assign(function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;
	        let property;

	        switch (val.name) {
	          case "function":
	            property = "sent";
	            break;

	          case "new":
	            property = "target";
	            break;

	          case "import":
	            property = "meta";
	            break;
	        }

	        if (!(0, _is.default)("Identifier", node.property, {
	          name: property
	        })) {
	          throw new TypeError("Unrecognised MetaProperty");
	        }
	      }, {
	        oneOfNodeTypes: ["Identifier"]
	      }))
	    },
	    property: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    }
	  }
	});
	const classMethodOrPropertyCommon = {
	  abstract: {
	    validate: (0, _utils.assertValueType)("boolean"),
	    optional: true
	  },
	  accessibility: {
	    validate: (0, _utils.assertOneOf)("public", "private", "protected"),
	    optional: true
	  },
	  static: {
	    default: false
	  },
	  computed: {
	    default: false
	  },
	  optional: {
	    validate: (0, _utils.assertValueType)("boolean"),
	    optional: true
	  },
	  key: {
	    validate: (0, _utils.chain)(function () {
	      const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
	      const computed = (0, _utils.assertNodeType)("Expression");
	      return function (node, key, val) {
	        const validator = node.computed ? computed : normal;
	        validator(node, key, val);
	      };
	    }(), (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "Expression"))
	  }
	};
	exports.classMethodOrPropertyCommon = classMethodOrPropertyCommon;
	const classMethodOrDeclareMethodCommon = Object.assign({}, functionCommon, classMethodOrPropertyCommon, {
	  kind: {
	    validate: (0, _utils.assertOneOf)("get", "set", "method", "constructor"),
	    default: "method"
	  },
	  access: {
	    validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("public", "private", "protected")),
	    optional: true
	  },
	  decorators: {
	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	    optional: true
	  }
	});
	exports.classMethodOrDeclareMethodCommon = classMethodOrDeclareMethodCommon;
	(0, _utils.default)("ClassMethod", {
	  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
	  builder: ["kind", "key", "params", "body", "computed", "static", "generator", "async"],
	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
	  fields: Object.assign({}, classMethodOrDeclareMethodCommon, functionTypeAnnotationCommon, {
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  })
	});
	(0, _utils.default)("ObjectPattern", {
	  visitor: ["properties", "typeAnnotation", "decorators"],
	  builder: ["properties"],
	  aliases: ["Pattern", "PatternLike", "LVal"],
	  fields: Object.assign({}, patternLikeCommon, {
	    properties: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("RestElement", "ObjectProperty")))
	    }
	  })
	});
	(0, _utils.default)("SpreadElement", {
	  visitor: ["argument"],
	  aliases: ["UnaryLike"],
	  deprecatedAlias: "SpreadProperty",
	  fields: {
	    argument: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("Super", {
	  aliases: ["Expression"]
	});
	(0, _utils.default)("TaggedTemplateExpression", {
	  visitor: ["tag", "quasi"],
	  aliases: ["Expression"],
	  fields: {
	    tag: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    quasi: {
	      validate: (0, _utils.assertNodeType)("TemplateLiteral")
	    },
	    typeParameters: {
	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("TemplateElement", {
	  builder: ["value", "tail"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertShape)({
	        raw: {
	          validate: (0, _utils.assertValueType)("string")
	        },
	        cooked: {
	          validate: (0, _utils.assertValueType)("string"),
	          optional: true
	        }
	      })
	    },
	    tail: {
	      default: false
	    }
	  }
	});
	(0, _utils.default)("TemplateLiteral", {
	  visitor: ["quasis", "expressions"],
	  aliases: ["Expression", "Literal"],
	  fields: {
	    quasis: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TemplateElement")))
	    },
	    expressions: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "TSType")), function (node, key, val) {
	        if (node.quasis.length !== val.length + 1) {
	          throw new TypeError(`Number of ${node.type} quasis should be exactly one more than the number of expressions.\nExpected ${val.length + 1} quasis but got ${node.quasis.length}`);
	        }
	      })
	    }
	  }
	});
	(0, _utils.default)("YieldExpression", {
	  builder: ["argument", "delegate"],
	  visitor: ["argument"],
	  aliases: ["Expression", "Terminatorless"],
	  fields: {
	    delegate: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function (node, key, val) {
	        if (!process.env.BABEL_TYPES_8_BREAKING) return;

	        if (val && !node.argument) {
	          throw new TypeError("Property delegate of YieldExpression cannot be true if there is no argument");
	        }
	      }, {
	        type: "boolean"
	      })),
	      default: false
	    },
	    argument: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("AwaitExpression", {
	  builder: ["argument"],
	  visitor: ["argument"],
	  aliases: ["Expression", "Terminatorless"],
	  fields: {
	    argument: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("Import", {
	  aliases: ["Expression"]
	});
	(0, _utils.default)("BigIntLiteral", {
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  },
	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
	});
	(0, _utils.default)("ExportNamespaceSpecifier", {
	  visitor: ["exported"],
	  aliases: ["ModuleSpecifier"],
	  fields: {
	    exported: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    }
	  }
	});
	(0, _utils.default)("OptionalMemberExpression", {
	  builder: ["object", "property", "computed", "optional"],
	  visitor: ["object", "property"],
	  aliases: ["Expression"],
	  fields: {
	    object: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    property: {
	      validate: function () {
	        const normal = (0, _utils.assertNodeType)("Identifier");
	        const computed = (0, _utils.assertNodeType)("Expression");

	        const validator = function (node, key, val) {
	          const validator = node.computed ? computed : normal;
	          validator(node, key, val);
	        };

	        validator.oneOfNodeTypes = ["Expression", "Identifier"];
	        return validator;
	      }()
	    },
	    computed: {
	      default: false
	    },
	    optional: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
	    }
	  }
	});
	(0, _utils.default)("OptionalCallExpression", {
	  visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
	  builder: ["callee", "arguments", "optional"],
	  aliases: ["Expression"],
	  fields: {
	    callee: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    arguments: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement", "JSXNamespacedName")))
	    },
	    optional: {
	      validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
	    },
	    typeArguments: {
	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
	      optional: true
	    },
	    typeParameters: {
	      validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
	      optional: true
	    }
	  }
	});
	});

	unwrapExports(core);
	var core_1 = core.classMethodOrDeclareMethodCommon;
	var core_2 = core.classMethodOrPropertyCommon;
	var core_3 = core.patternLikeCommon;
	var core_4 = core.functionDeclarationCommon;
	var core_5 = core.functionTypeAnnotationCommon;
	var core_6 = core.functionCommon;

	var flow = createCommonjsModule(function (module) {

	var _utils = _interopRequireWildcard(utils);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	const defineInterfaceishType = (name, typeParameterType = "TypeParameterDeclaration") => {
	  (0, _utils.default)(name, {
	    builder: ["id", "typeParameters", "extends", "body"],
	    visitor: ["id", "typeParameters", "extends", "mixins", "implements", "body"],
	    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	    fields: {
	      id: (0, _utils.validateType)("Identifier"),
	      typeParameters: (0, _utils.validateOptionalType)(typeParameterType),
	      extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
	      mixins: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
	      implements: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ClassImplements")),
	      body: (0, _utils.validateType)("ObjectTypeAnnotation")
	    }
	  });
	};

	(0, _utils.default)("AnyTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("ArrayTypeAnnotation", {
	  visitor: ["elementType"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    elementType: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("BooleanTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("BooleanLiteralTypeAnnotation", {
	  builder: ["value"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    value: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
	  }
	});
	(0, _utils.default)("NullLiteralTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("ClassImplements", {
	  visitor: ["id", "typeParameters"],
	  aliases: ["Flow"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
	  }
	});
	defineInterfaceishType("DeclareClass");
	(0, _utils.default)("DeclareFunction", {
	  visitor: ["id"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    predicate: (0, _utils.validateOptionalType)("DeclaredPredicate")
	  }
	});
	defineInterfaceishType("DeclareInterface");
	(0, _utils.default)("DeclareModule", {
	  builder: ["id", "body", "kind"],
	  visitor: ["id", "body"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
	    body: (0, _utils.validateType)("BlockStatement"),
	    kind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("CommonJS", "ES"))
	  }
	});
	(0, _utils.default)("DeclareModuleExports", {
	  visitor: ["typeAnnotation"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
	  }
	});
	(0, _utils.default)("DeclareTypeAlias", {
	  visitor: ["id", "typeParameters", "right"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
	    right: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("DeclareOpaqueType", {
	  visitor: ["id", "typeParameters", "supertype"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
	    supertype: (0, _utils.validateOptionalType)("FlowType")
	  }
	});
	(0, _utils.default)("DeclareVariable", {
	  visitor: ["id"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier")
	  }
	});
	(0, _utils.default)("DeclareExportDeclaration", {
	  visitor: ["declaration", "specifiers", "source"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    declaration: (0, _utils.validateOptionalType)("Flow"),
	    specifiers: (0, _utils.validateOptional)((0, _utils.arrayOfType)(["ExportSpecifier", "ExportNamespaceSpecifier"])),
	    source: (0, _utils.validateOptionalType)("StringLiteral"),
	    default: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
	  }
	});
	(0, _utils.default)("DeclareExportAllDeclaration", {
	  visitor: ["source"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    source: (0, _utils.validateType)("StringLiteral"),
	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
	  }
	});
	(0, _utils.default)("DeclaredPredicate", {
	  visitor: ["value"],
	  aliases: ["Flow", "FlowPredicate"],
	  fields: {
	    value: (0, _utils.validateType)("Flow")
	  }
	});
	(0, _utils.default)("ExistsTypeAnnotation", {
	  aliases: ["Flow", "FlowType"]
	});
	(0, _utils.default)("FunctionTypeAnnotation", {
	  visitor: ["typeParameters", "params", "rest", "returnType"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
	    params: (0, _utils.validate)((0, _utils.arrayOfType)("FunctionTypeParam")),
	    rest: (0, _utils.validateOptionalType)("FunctionTypeParam"),
	    returnType: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("FunctionTypeParam", {
	  visitor: ["name", "typeAnnotation"],
	  aliases: ["Flow"],
	  fields: {
	    name: (0, _utils.validateOptionalType)("Identifier"),
	    typeAnnotation: (0, _utils.validateType)("FlowType"),
	    optional: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
	  }
	});
	(0, _utils.default)("GenericTypeAnnotation", {
	  visitor: ["id", "typeParameters"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    id: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"]),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
	  }
	});
	(0, _utils.default)("InferredPredicate", {
	  aliases: ["Flow", "FlowPredicate"]
	});
	(0, _utils.default)("InterfaceExtends", {
	  visitor: ["id", "typeParameters"],
	  aliases: ["Flow"],
	  fields: {
	    id: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"]),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
	  }
	});
	defineInterfaceishType("InterfaceDeclaration");
	(0, _utils.default)("InterfaceTypeAnnotation", {
	  visitor: ["extends", "body"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
	    body: (0, _utils.validateType)("ObjectTypeAnnotation")
	  }
	});
	(0, _utils.default)("IntersectionTypeAnnotation", {
	  visitor: ["types"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
	  }
	});
	(0, _utils.default)("MixedTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("EmptyTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("NullableTypeAnnotation", {
	  visitor: ["typeAnnotation"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("NumberLiteralTypeAnnotation", {
	  builder: ["value"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    value: (0, _utils.validate)((0, _utils.assertValueType)("number"))
	  }
	});
	(0, _utils.default)("NumberTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("ObjectTypeAnnotation", {
	  visitor: ["properties", "indexers", "callProperties", "internalSlots"],
	  aliases: ["Flow", "FlowType"],
	  builder: ["properties", "indexers", "callProperties", "internalSlots", "exact"],
	  fields: {
	    properties: (0, _utils.validate)((0, _utils.arrayOfType)(["ObjectTypeProperty", "ObjectTypeSpreadProperty"])),
	    indexers: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeIndexer")),
	    callProperties: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeCallProperty")),
	    internalSlots: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeInternalSlot")),
	    exact: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      default: false
	    },
	    inexact: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
	  }
	});
	(0, _utils.default)("ObjectTypeInternalSlot", {
	  visitor: ["id", "value", "optional", "static", "method"],
	  aliases: ["Flow", "UserWhitespacable"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    value: (0, _utils.validateType)("FlowType"),
	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    method: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
	  }
	});
	(0, _utils.default)("ObjectTypeCallProperty", {
	  visitor: ["value"],
	  aliases: ["Flow", "UserWhitespacable"],
	  fields: {
	    value: (0, _utils.validateType)("FlowType"),
	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
	  }
	});
	(0, _utils.default)("ObjectTypeIndexer", {
	  visitor: ["id", "key", "value", "variance"],
	  aliases: ["Flow", "UserWhitespacable"],
	  fields: {
	    id: (0, _utils.validateOptionalType)("Identifier"),
	    key: (0, _utils.validateType)("FlowType"),
	    value: (0, _utils.validateType)("FlowType"),
	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    variance: (0, _utils.validateOptionalType)("Variance")
	  }
	});
	(0, _utils.default)("ObjectTypeProperty", {
	  visitor: ["key", "value", "variance"],
	  aliases: ["Flow", "UserWhitespacable"],
	  fields: {
	    key: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
	    value: (0, _utils.validateType)("FlowType"),
	    kind: (0, _utils.validate)((0, _utils.assertOneOf)("init", "get", "set")),
	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    proto: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    variance: (0, _utils.validateOptionalType)("Variance")
	  }
	});
	(0, _utils.default)("ObjectTypeSpreadProperty", {
	  visitor: ["argument"],
	  aliases: ["Flow", "UserWhitespacable"],
	  fields: {
	    argument: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("OpaqueType", {
	  visitor: ["id", "typeParameters", "supertype", "impltype"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
	    supertype: (0, _utils.validateOptionalType)("FlowType"),
	    impltype: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("QualifiedTypeIdentifier", {
	  visitor: ["id", "qualification"],
	  aliases: ["Flow"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    qualification: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"])
	  }
	});
	(0, _utils.default)("StringLiteralTypeAnnotation", {
	  builder: ["value"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    value: (0, _utils.validate)((0, _utils.assertValueType)("string"))
	  }
	});
	(0, _utils.default)("StringTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("SymbolTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("ThisTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("TupleTypeAnnotation", {
	  visitor: ["types"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
	  }
	});
	(0, _utils.default)("TypeofTypeAnnotation", {
	  visitor: ["argument"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    argument: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("TypeAlias", {
	  visitor: ["id", "typeParameters", "right"],
	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
	    right: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("TypeAnnotation", {
	  aliases: ["Flow"],
	  visitor: ["typeAnnotation"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("FlowType")
	  }
	});
	(0, _utils.default)("TypeCastExpression", {
	  visitor: ["expression", "typeAnnotation"],
	  aliases: ["Flow", "ExpressionWrapper", "Expression"],
	  fields: {
	    expression: (0, _utils.validateType)("Expression"),
	    typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
	  }
	});
	(0, _utils.default)("TypeParameter", {
	  aliases: ["Flow"],
	  visitor: ["bound", "default", "variance"],
	  fields: {
	    name: (0, _utils.validate)((0, _utils.assertValueType)("string")),
	    bound: (0, _utils.validateOptionalType)("TypeAnnotation"),
	    default: (0, _utils.validateOptionalType)("FlowType"),
	    variance: (0, _utils.validateOptionalType)("Variance")
	  }
	});
	(0, _utils.default)("TypeParameterDeclaration", {
	  aliases: ["Flow"],
	  visitor: ["params"],
	  fields: {
	    params: (0, _utils.validate)((0, _utils.arrayOfType)("TypeParameter"))
	  }
	});
	(0, _utils.default)("TypeParameterInstantiation", {
	  aliases: ["Flow"],
	  visitor: ["params"],
	  fields: {
	    params: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
	  }
	});
	(0, _utils.default)("UnionTypeAnnotation", {
	  visitor: ["types"],
	  aliases: ["Flow", "FlowType"],
	  fields: {
	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
	  }
	});
	(0, _utils.default)("Variance", {
	  aliases: ["Flow"],
	  builder: ["kind"],
	  fields: {
	    kind: (0, _utils.validate)((0, _utils.assertOneOf)("minus", "plus"))
	  }
	});
	(0, _utils.default)("VoidTypeAnnotation", {
	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
	});
	(0, _utils.default)("EnumDeclaration", {
	  aliases: ["Statement", "Declaration"],
	  visitor: ["id", "body"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    body: (0, _utils.validateType)(["EnumBooleanBody", "EnumNumberBody", "EnumStringBody", "EnumSymbolBody"])
	  }
	});
	(0, _utils.default)("EnumBooleanBody", {
	  aliases: ["EnumBody"],
	  visitor: ["members"],
	  fields: {
	    explicit: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    members: (0, _utils.validateArrayOfType)("EnumBooleanMember")
	  }
	});
	(0, _utils.default)("EnumNumberBody", {
	  aliases: ["EnumBody"],
	  visitor: ["members"],
	  fields: {
	    explicit: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    members: (0, _utils.validateArrayOfType)("EnumNumberMember")
	  }
	});
	(0, _utils.default)("EnumStringBody", {
	  aliases: ["EnumBody"],
	  visitor: ["members"],
	  fields: {
	    explicit: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
	    members: (0, _utils.validateArrayOfType)(["EnumStringMember", "EnumDefaultedMember"])
	  }
	});
	(0, _utils.default)("EnumSymbolBody", {
	  aliases: ["EnumBody"],
	  visitor: ["members"],
	  fields: {
	    members: (0, _utils.validateArrayOfType)("EnumDefaultedMember")
	  }
	});
	(0, _utils.default)("EnumBooleanMember", {
	  aliases: ["EnumMember"],
	  visitor: ["id"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    init: (0, _utils.validateType)("BooleanLiteral")
	  }
	});
	(0, _utils.default)("EnumNumberMember", {
	  aliases: ["EnumMember"],
	  visitor: ["id", "init"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    init: (0, _utils.validateType)("NumericLiteral")
	  }
	});
	(0, _utils.default)("EnumStringMember", {
	  aliases: ["EnumMember"],
	  visitor: ["id", "init"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier"),
	    init: (0, _utils.validateType)("StringLiteral")
	  }
	});
	(0, _utils.default)("EnumDefaultedMember", {
	  aliases: ["EnumMember"],
	  visitor: ["id"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier")
	  }
	});
	});

	unwrapExports(flow);

	var jsx = createCommonjsModule(function (module) {

	var _utils = _interopRequireWildcard(utils);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	(0, _utils.default)("JSXAttribute", {
	  visitor: ["name", "value"],
	  aliases: ["JSX", "Immutable"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXNamespacedName")
	    },
	    value: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("JSXElement", "JSXFragment", "StringLiteral", "JSXExpressionContainer")
	    }
	  }
	});
	(0, _utils.default)("JSXClosingElement", {
	  visitor: ["name"],
	  aliases: ["JSX", "Immutable"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
	    }
	  }
	});
	(0, _utils.default)("JSXElement", {
	  builder: ["openingElement", "closingElement", "children", "selfClosing"],
	  visitor: ["openingElement", "children", "closingElement"],
	  aliases: ["JSX", "Immutable", "Expression"],
	  fields: {
	    openingElement: {
	      validate: (0, _utils.assertNodeType)("JSXOpeningElement")
	    },
	    closingElement: {
	      optional: true,
	      validate: (0, _utils.assertNodeType)("JSXClosingElement")
	    },
	    children: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
	    },
	    selfClosing: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("JSXEmptyExpression", {
	  aliases: ["JSX"]
	});
	(0, _utils.default)("JSXExpressionContainer", {
	  visitor: ["expression"],
	  aliases: ["JSX", "Immutable"],
	  fields: {
	    expression: {
	      validate: (0, _utils.assertNodeType)("Expression", "JSXEmptyExpression")
	    }
	  }
	});
	(0, _utils.default)("JSXSpreadChild", {
	  visitor: ["expression"],
	  aliases: ["JSX", "Immutable"],
	  fields: {
	    expression: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("JSXIdentifier", {
	  builder: ["name"],
	  aliases: ["JSX"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  }
	});
	(0, _utils.default)("JSXMemberExpression", {
	  visitor: ["object", "property"],
	  aliases: ["JSX"],
	  fields: {
	    object: {
	      validate: (0, _utils.assertNodeType)("JSXMemberExpression", "JSXIdentifier")
	    },
	    property: {
	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
	    }
	  }
	});
	(0, _utils.default)("JSXNamespacedName", {
	  visitor: ["namespace", "name"],
	  aliases: ["JSX"],
	  fields: {
	    namespace: {
	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
	    },
	    name: {
	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
	    }
	  }
	});
	(0, _utils.default)("JSXOpeningElement", {
	  builder: ["name", "attributes", "selfClosing"],
	  visitor: ["name", "attributes"],
	  aliases: ["JSX", "Immutable"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
	    },
	    selfClosing: {
	      default: false
	    },
	    attributes: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXAttribute", "JSXSpreadAttribute")))
	    },
	    typeParameters: {
	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("JSXSpreadAttribute", {
	  visitor: ["argument"],
	  aliases: ["JSX"],
	  fields: {
	    argument: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("JSXText", {
	  aliases: ["JSX", "Immutable"],
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  }
	});
	(0, _utils.default)("JSXFragment", {
	  builder: ["openingFragment", "closingFragment", "children"],
	  visitor: ["openingFragment", "children", "closingFragment"],
	  aliases: ["JSX", "Immutable", "Expression"],
	  fields: {
	    openingFragment: {
	      validate: (0, _utils.assertNodeType)("JSXOpeningFragment")
	    },
	    closingFragment: {
	      validate: (0, _utils.assertNodeType)("JSXClosingFragment")
	    },
	    children: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
	    }
	  }
	});
	(0, _utils.default)("JSXOpeningFragment", {
	  aliases: ["JSX", "Immutable"]
	});
	(0, _utils.default)("JSXClosingFragment", {
	  aliases: ["JSX", "Immutable"]
	});
	});

	unwrapExports(jsx);

	var placeholders = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.PLACEHOLDERS_FLIPPED_ALIAS = exports.PLACEHOLDERS_ALIAS = exports.PLACEHOLDERS = void 0;



	const PLACEHOLDERS = ["Identifier", "StringLiteral", "Expression", "Statement", "Declaration", "BlockStatement", "ClassBody", "Pattern"];
	exports.PLACEHOLDERS = PLACEHOLDERS;
	const PLACEHOLDERS_ALIAS = {
	  Declaration: ["Statement"],
	  Pattern: ["PatternLike", "LVal"]
	};
	exports.PLACEHOLDERS_ALIAS = PLACEHOLDERS_ALIAS;

	for (const type of PLACEHOLDERS) {
	  const alias = utils.ALIAS_KEYS[type];
	  if (alias == null ? void 0 : alias.length) PLACEHOLDERS_ALIAS[type] = alias;
	}

	const PLACEHOLDERS_FLIPPED_ALIAS = {};
	exports.PLACEHOLDERS_FLIPPED_ALIAS = PLACEHOLDERS_FLIPPED_ALIAS;
	Object.keys(PLACEHOLDERS_ALIAS).forEach(type => {
	  PLACEHOLDERS_ALIAS[type].forEach(alias => {
	    if (!Object.hasOwnProperty.call(PLACEHOLDERS_FLIPPED_ALIAS, alias)) {
	      PLACEHOLDERS_FLIPPED_ALIAS[alias] = [];
	    }

	    PLACEHOLDERS_FLIPPED_ALIAS[alias].push(type);
	  });
	});
	});

	unwrapExports(placeholders);
	var placeholders_1 = placeholders.PLACEHOLDERS_FLIPPED_ALIAS;
	var placeholders_2 = placeholders.PLACEHOLDERS_ALIAS;
	var placeholders_3 = placeholders.PLACEHOLDERS;

	var misc = createCommonjsModule(function (module) {

	var _utils = _interopRequireWildcard(utils);



	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	(0, _utils.default)("Noop", {
	  visitor: []
	});
	(0, _utils.default)("Placeholder", {
	  visitor: [],
	  builder: ["expectedNode", "name"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    },
	    expectedNode: {
	      validate: (0, _utils.assertOneOf)(...placeholders.PLACEHOLDERS)
	    }
	  }
	});
	(0, _utils.default)("V8IntrinsicIdentifier", {
	  builder: ["name"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  }
	});
	});

	unwrapExports(misc);

	var experimental = createCommonjsModule(function (module) {

	var _utils = _interopRequireWildcard(utils);



	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	(0, _utils.default)("ArgumentPlaceholder", {});
	(0, _utils.default)("BindExpression", {
	  visitor: ["object", "callee"],
	  aliases: ["Expression"],
	  fields: !process.env.BABEL_TYPES_8_BREAKING ? {
	    object: {
	      validate: Object.assign(() => {}, {
	        oneOfNodeTypes: ["Expression"]
	      })
	    },
	    callee: {
	      validate: Object.assign(() => {}, {
	        oneOfNodeTypes: ["Expression"]
	      })
	    }
	  } : {
	    object: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    },
	    callee: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("ClassProperty", {
	  visitor: ["key", "value", "typeAnnotation", "decorators"],
	  builder: ["key", "value", "typeAnnotation", "decorators", "computed", "static"],
	  aliases: ["Property"],
	  fields: Object.assign({}, core.classMethodOrPropertyCommon, {
	    value: {
	      validate: (0, _utils.assertNodeType)("Expression"),
	      optional: true
	    },
	    definite: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    },
	    typeAnnotation: {
	      validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
	      optional: true
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    },
	    readonly: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    },
	    declare: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    }
	  })
	});
	(0, _utils.default)("PipelineTopicExpression", {
	  builder: ["expression"],
	  visitor: ["expression"],
	  fields: {
	    expression: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("PipelineBareFunction", {
	  builder: ["callee"],
	  visitor: ["callee"],
	  fields: {
	    callee: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("PipelinePrimaryTopicReference", {
	  aliases: ["Expression"]
	});
	(0, _utils.default)("ClassPrivateProperty", {
	  visitor: ["key", "value", "decorators"],
	  builder: ["key", "value", "decorators", "static"],
	  aliases: ["Property", "Private"],
	  fields: {
	    key: {
	      validate: (0, _utils.assertNodeType)("PrivateName")
	    },
	    value: {
	      validate: (0, _utils.assertNodeType)("Expression"),
	      optional: true
	    },
	    decorators: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
	      optional: true
	    }
	  }
	});
	(0, _utils.default)("ClassPrivateMethod", {
	  builder: ["kind", "key", "params", "body", "static"],
	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
	  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method", "Private"],
	  fields: Object.assign({}, core.classMethodOrDeclareMethodCommon, core.functionTypeAnnotationCommon, {
	    key: {
	      validate: (0, _utils.assertNodeType)("PrivateName")
	    },
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  })
	});
	(0, _utils.default)("ImportAttribute", {
	  visitor: ["key", "value"],
	  fields: {
	    key: {
	      validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
	    },
	    value: {
	      validate: (0, _utils.assertNodeType)("StringLiteral")
	    }
	  }
	});
	(0, _utils.default)("Decorator", {
	  visitor: ["expression"],
	  fields: {
	    expression: {
	      validate: (0, _utils.assertNodeType)("Expression")
	    }
	  }
	});
	(0, _utils.default)("DoExpression", {
	  visitor: ["body"],
	  aliases: ["Expression"],
	  fields: {
	    body: {
	      validate: (0, _utils.assertNodeType)("BlockStatement")
	    }
	  }
	});
	(0, _utils.default)("ExportDefaultSpecifier", {
	  visitor: ["exported"],
	  aliases: ["ModuleSpecifier"],
	  fields: {
	    exported: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    }
	  }
	});
	(0, _utils.default)("PrivateName", {
	  visitor: ["id"],
	  aliases: ["Private"],
	  fields: {
	    id: {
	      validate: (0, _utils.assertNodeType)("Identifier")
	    }
	  }
	});
	(0, _utils.default)("RecordExpression", {
	  visitor: ["properties"],
	  aliases: ["Expression"],
	  fields: {
	    properties: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ObjectProperty", "SpreadElement")))
	    }
	  }
	});
	(0, _utils.default)("TupleExpression", {
	  fields: {
	    elements: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement"))),
	      default: []
	    }
	  },
	  visitor: ["elements"],
	  aliases: ["Expression"]
	});
	(0, _utils.default)("DecimalLiteral", {
	  builder: ["value"],
	  fields: {
	    value: {
	      validate: (0, _utils.assertValueType)("string")
	    }
	  },
	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
	});
	(0, _utils.default)("StaticBlock", {
	  visitor: ["body"],
	  fields: {
	    body: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
	    }
	  },
	  aliases: ["Scopable", "BlockParent"]
	});
	});

	unwrapExports(experimental);

	var typescript = createCommonjsModule(function (module) {

	var _utils = _interopRequireWildcard(utils);



	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	const bool = (0, _utils.assertValueType)("boolean");
	const tSFunctionTypeAnnotationCommon = {
	  returnType: {
	    validate: (0, _utils.assertNodeType)("TSTypeAnnotation", "Noop"),
	    optional: true
	  },
	  typeParameters: {
	    validate: (0, _utils.assertNodeType)("TSTypeParameterDeclaration", "Noop"),
	    optional: true
	  }
	};
	(0, _utils.default)("TSParameterProperty", {
	  aliases: ["LVal"],
	  visitor: ["parameter"],
	  fields: {
	    accessibility: {
	      validate: (0, _utils.assertOneOf)("public", "private", "protected"),
	      optional: true
	    },
	    readonly: {
	      validate: (0, _utils.assertValueType)("boolean"),
	      optional: true
	    },
	    parameter: {
	      validate: (0, _utils.assertNodeType)("Identifier", "AssignmentPattern")
	    }
	  }
	});
	(0, _utils.default)("TSDeclareFunction", {
	  aliases: ["Statement", "Declaration"],
	  visitor: ["id", "typeParameters", "params", "returnType"],
	  fields: Object.assign({}, core.functionDeclarationCommon, tSFunctionTypeAnnotationCommon)
	});
	(0, _utils.default)("TSDeclareMethod", {
	  visitor: ["decorators", "key", "typeParameters", "params", "returnType"],
	  fields: Object.assign({}, core.classMethodOrDeclareMethodCommon, tSFunctionTypeAnnotationCommon)
	});
	(0, _utils.default)("TSQualifiedName", {
	  aliases: ["TSEntityName"],
	  visitor: ["left", "right"],
	  fields: {
	    left: (0, _utils.validateType)("TSEntityName"),
	    right: (0, _utils.validateType)("Identifier")
	  }
	});
	const signatureDeclarationCommon = {
	  typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
	  parameters: (0, _utils.validateArrayOfType)(["Identifier", "RestElement"]),
	  typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
	};
	const callConstructSignatureDeclaration = {
	  aliases: ["TSTypeElement"],
	  visitor: ["typeParameters", "parameters", "typeAnnotation"],
	  fields: signatureDeclarationCommon
	};
	(0, _utils.default)("TSCallSignatureDeclaration", callConstructSignatureDeclaration);
	(0, _utils.default)("TSConstructSignatureDeclaration", callConstructSignatureDeclaration);
	const namedTypeElementCommon = {
	  key: (0, _utils.validateType)("Expression"),
	  computed: (0, _utils.validate)(bool),
	  optional: (0, _utils.validateOptional)(bool)
	};
	(0, _utils.default)("TSPropertySignature", {
	  aliases: ["TSTypeElement"],
	  visitor: ["key", "typeAnnotation", "initializer"],
	  fields: Object.assign({}, namedTypeElementCommon, {
	    readonly: (0, _utils.validateOptional)(bool),
	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
	    initializer: (0, _utils.validateOptionalType)("Expression")
	  })
	});
	(0, _utils.default)("TSMethodSignature", {
	  aliases: ["TSTypeElement"],
	  visitor: ["key", "typeParameters", "parameters", "typeAnnotation"],
	  fields: Object.assign({}, signatureDeclarationCommon, namedTypeElementCommon)
	});
	(0, _utils.default)("TSIndexSignature", {
	  aliases: ["TSTypeElement"],
	  visitor: ["parameters", "typeAnnotation"],
	  fields: {
	    readonly: (0, _utils.validateOptional)(bool),
	    parameters: (0, _utils.validateArrayOfType)("Identifier"),
	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
	  }
	});
	const tsKeywordTypes = ["TSAnyKeyword", "TSBooleanKeyword", "TSBigIntKeyword", "TSIntrinsicKeyword", "TSNeverKeyword", "TSNullKeyword", "TSNumberKeyword", "TSObjectKeyword", "TSStringKeyword", "TSSymbolKeyword", "TSUndefinedKeyword", "TSUnknownKeyword", "TSVoidKeyword"];

	for (const type of tsKeywordTypes) {
	  (0, _utils.default)(type, {
	    aliases: ["TSType", "TSBaseType"],
	    visitor: [],
	    fields: {}
	  });
	}

	(0, _utils.default)("TSThisType", {
	  aliases: ["TSType", "TSBaseType"],
	  visitor: [],
	  fields: {}
	});
	const fnOrCtr = {
	  aliases: ["TSType"],
	  visitor: ["typeParameters", "parameters", "typeAnnotation"],
	  fields: signatureDeclarationCommon
	};
	(0, _utils.default)("TSFunctionType", fnOrCtr);
	(0, _utils.default)("TSConstructorType", fnOrCtr);
	(0, _utils.default)("TSTypeReference", {
	  aliases: ["TSType"],
	  visitor: ["typeName", "typeParameters"],
	  fields: {
	    typeName: (0, _utils.validateType)("TSEntityName"),
	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
	  }
	});
	(0, _utils.default)("TSTypePredicate", {
	  aliases: ["TSType"],
	  visitor: ["parameterName", "typeAnnotation"],
	  builder: ["parameterName", "typeAnnotation", "asserts"],
	  fields: {
	    parameterName: (0, _utils.validateType)(["Identifier", "TSThisType"]),
	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
	    asserts: (0, _utils.validateOptional)(bool)
	  }
	});
	(0, _utils.default)("TSTypeQuery", {
	  aliases: ["TSType"],
	  visitor: ["exprName"],
	  fields: {
	    exprName: (0, _utils.validateType)(["TSEntityName", "TSImportType"])
	  }
	});
	(0, _utils.default)("TSTypeLiteral", {
	  aliases: ["TSType"],
	  visitor: ["members"],
	  fields: {
	    members: (0, _utils.validateArrayOfType)("TSTypeElement")
	  }
	});
	(0, _utils.default)("TSArrayType", {
	  aliases: ["TSType"],
	  visitor: ["elementType"],
	  fields: {
	    elementType: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSTupleType", {
	  aliases: ["TSType"],
	  visitor: ["elementTypes"],
	  fields: {
	    elementTypes: (0, _utils.validateArrayOfType)(["TSType", "TSNamedTupleMember"])
	  }
	});
	(0, _utils.default)("TSOptionalType", {
	  aliases: ["TSType"],
	  visitor: ["typeAnnotation"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSRestType", {
	  aliases: ["TSType"],
	  visitor: ["typeAnnotation"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSNamedTupleMember", {
	  visitor: ["label", "elementType"],
	  builder: ["label", "elementType", "optional"],
	  fields: {
	    label: (0, _utils.validateType)("Identifier"),
	    optional: {
	      validate: bool,
	      default: false
	    },
	    elementType: (0, _utils.validateType)("TSType")
	  }
	});
	const unionOrIntersection = {
	  aliases: ["TSType"],
	  visitor: ["types"],
	  fields: {
	    types: (0, _utils.validateArrayOfType)("TSType")
	  }
	};
	(0, _utils.default)("TSUnionType", unionOrIntersection);
	(0, _utils.default)("TSIntersectionType", unionOrIntersection);
	(0, _utils.default)("TSConditionalType", {
	  aliases: ["TSType"],
	  visitor: ["checkType", "extendsType", "trueType", "falseType"],
	  fields: {
	    checkType: (0, _utils.validateType)("TSType"),
	    extendsType: (0, _utils.validateType)("TSType"),
	    trueType: (0, _utils.validateType)("TSType"),
	    falseType: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSInferType", {
	  aliases: ["TSType"],
	  visitor: ["typeParameter"],
	  fields: {
	    typeParameter: (0, _utils.validateType)("TSTypeParameter")
	  }
	});
	(0, _utils.default)("TSParenthesizedType", {
	  aliases: ["TSType"],
	  visitor: ["typeAnnotation"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSTypeOperator", {
	  aliases: ["TSType"],
	  visitor: ["typeAnnotation"],
	  fields: {
	    operator: (0, _utils.validate)((0, _utils.assertValueType)("string")),
	    typeAnnotation: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSIndexedAccessType", {
	  aliases: ["TSType"],
	  visitor: ["objectType", "indexType"],
	  fields: {
	    objectType: (0, _utils.validateType)("TSType"),
	    indexType: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSMappedType", {
	  aliases: ["TSType"],
	  visitor: ["typeParameter", "typeAnnotation", "nameType"],
	  fields: {
	    readonly: (0, _utils.validateOptional)(bool),
	    typeParameter: (0, _utils.validateType)("TSTypeParameter"),
	    optional: (0, _utils.validateOptional)(bool),
	    typeAnnotation: (0, _utils.validateOptionalType)("TSType"),
	    nameType: (0, _utils.validateOptionalType)("TSType")
	  }
	});
	(0, _utils.default)("TSLiteralType", {
	  aliases: ["TSType", "TSBaseType"],
	  visitor: ["literal"],
	  fields: {
	    literal: (0, _utils.validateType)(["NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral"])
	  }
	});
	(0, _utils.default)("TSExpressionWithTypeArguments", {
	  aliases: ["TSType"],
	  visitor: ["expression", "typeParameters"],
	  fields: {
	    expression: (0, _utils.validateType)("TSEntityName"),
	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
	  }
	});
	(0, _utils.default)("TSInterfaceDeclaration", {
	  aliases: ["Statement", "Declaration"],
	  visitor: ["id", "typeParameters", "extends", "body"],
	  fields: {
	    declare: (0, _utils.validateOptional)(bool),
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
	    extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("TSExpressionWithTypeArguments")),
	    body: (0, _utils.validateType)("TSInterfaceBody")
	  }
	});
	(0, _utils.default)("TSInterfaceBody", {
	  visitor: ["body"],
	  fields: {
	    body: (0, _utils.validateArrayOfType)("TSTypeElement")
	  }
	});
	(0, _utils.default)("TSTypeAliasDeclaration", {
	  aliases: ["Statement", "Declaration"],
	  visitor: ["id", "typeParameters", "typeAnnotation"],
	  fields: {
	    declare: (0, _utils.validateOptional)(bool),
	    id: (0, _utils.validateType)("Identifier"),
	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
	    typeAnnotation: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSAsExpression", {
	  aliases: ["Expression"],
	  visitor: ["expression", "typeAnnotation"],
	  fields: {
	    expression: (0, _utils.validateType)("Expression"),
	    typeAnnotation: (0, _utils.validateType)("TSType")
	  }
	});
	(0, _utils.default)("TSTypeAssertion", {
	  aliases: ["Expression"],
	  visitor: ["typeAnnotation", "expression"],
	  fields: {
	    typeAnnotation: (0, _utils.validateType)("TSType"),
	    expression: (0, _utils.validateType)("Expression")
	  }
	});
	(0, _utils.default)("TSEnumDeclaration", {
	  aliases: ["Statement", "Declaration"],
	  visitor: ["id", "members"],
	  fields: {
	    declare: (0, _utils.validateOptional)(bool),
	    const: (0, _utils.validateOptional)(bool),
	    id: (0, _utils.validateType)("Identifier"),
	    members: (0, _utils.validateArrayOfType)("TSEnumMember"),
	    initializer: (0, _utils.validateOptionalType)("Expression")
	  }
	});
	(0, _utils.default)("TSEnumMember", {
	  visitor: ["id", "initializer"],
	  fields: {
	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
	    initializer: (0, _utils.validateOptionalType)("Expression")
	  }
	});
	(0, _utils.default)("TSModuleDeclaration", {
	  aliases: ["Statement", "Declaration"],
	  visitor: ["id", "body"],
	  fields: {
	    declare: (0, _utils.validateOptional)(bool),
	    global: (0, _utils.validateOptional)(bool),
	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
	    body: (0, _utils.validateType)(["TSModuleBlock", "TSModuleDeclaration"])
	  }
	});
	(0, _utils.default)("TSModuleBlock", {
	  aliases: ["Scopable", "Block", "BlockParent"],
	  visitor: ["body"],
	  fields: {
	    body: (0, _utils.validateArrayOfType)("Statement")
	  }
	});
	(0, _utils.default)("TSImportType", {
	  aliases: ["TSType"],
	  visitor: ["argument", "qualifier", "typeParameters"],
	  fields: {
	    argument: (0, _utils.validateType)("StringLiteral"),
	    qualifier: (0, _utils.validateOptionalType)("TSEntityName"),
	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
	  }
	});
	(0, _utils.default)("TSImportEqualsDeclaration", {
	  aliases: ["Statement"],
	  visitor: ["id", "moduleReference"],
	  fields: {
	    isExport: (0, _utils.validate)(bool),
	    id: (0, _utils.validateType)("Identifier"),
	    moduleReference: (0, _utils.validateType)(["TSEntityName", "TSExternalModuleReference"])
	  }
	});
	(0, _utils.default)("TSExternalModuleReference", {
	  visitor: ["expression"],
	  fields: {
	    expression: (0, _utils.validateType)("StringLiteral")
	  }
	});
	(0, _utils.default)("TSNonNullExpression", {
	  aliases: ["Expression"],
	  visitor: ["expression"],
	  fields: {
	    expression: (0, _utils.validateType)("Expression")
	  }
	});
	(0, _utils.default)("TSExportAssignment", {
	  aliases: ["Statement"],
	  visitor: ["expression"],
	  fields: {
	    expression: (0, _utils.validateType)("Expression")
	  }
	});
	(0, _utils.default)("TSNamespaceExportDeclaration", {
	  aliases: ["Statement"],
	  visitor: ["id"],
	  fields: {
	    id: (0, _utils.validateType)("Identifier")
	  }
	});
	(0, _utils.default)("TSTypeAnnotation", {
	  visitor: ["typeAnnotation"],
	  fields: {
	    typeAnnotation: {
	      validate: (0, _utils.assertNodeType)("TSType")
	    }
	  }
	});
	(0, _utils.default)("TSTypeParameterInstantiation", {
	  visitor: ["params"],
	  fields: {
	    params: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSType")))
	    }
	  }
	});
	(0, _utils.default)("TSTypeParameterDeclaration", {
	  visitor: ["params"],
	  fields: {
	    params: {
	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSTypeParameter")))
	    }
	  }
	});
	(0, _utils.default)("TSTypeParameter", {
	  builder: ["constraint", "default", "name"],
	  visitor: ["constraint", "default"],
	  fields: {
	    name: {
	      validate: (0, _utils.assertValueType)("string")
	    },
	    constraint: {
	      validate: (0, _utils.assertNodeType)("TSType"),
	      optional: true
	    },
	    default: {
	      validate: (0, _utils.assertNodeType)("TSType"),
	      optional: true
	    }
	  }
	});
	});

	unwrapExports(typescript);

	var definitions = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	Object.defineProperty(exports, "VISITOR_KEYS", {
	  enumerable: true,
	  get: function () {
	    return utils.VISITOR_KEYS;
	  }
	});
	Object.defineProperty(exports, "ALIAS_KEYS", {
	  enumerable: true,
	  get: function () {
	    return utils.ALIAS_KEYS;
	  }
	});
	Object.defineProperty(exports, "FLIPPED_ALIAS_KEYS", {
	  enumerable: true,
	  get: function () {
	    return utils.FLIPPED_ALIAS_KEYS;
	  }
	});
	Object.defineProperty(exports, "NODE_FIELDS", {
	  enumerable: true,
	  get: function () {
	    return utils.NODE_FIELDS;
	  }
	});
	Object.defineProperty(exports, "BUILDER_KEYS", {
	  enumerable: true,
	  get: function () {
	    return utils.BUILDER_KEYS;
	  }
	});
	Object.defineProperty(exports, "DEPRECATED_KEYS", {
	  enumerable: true,
	  get: function () {
	    return utils.DEPRECATED_KEYS;
	  }
	});
	Object.defineProperty(exports, "NODE_PARENT_VALIDATIONS", {
	  enumerable: true,
	  get: function () {
	    return utils.NODE_PARENT_VALIDATIONS;
	  }
	});
	Object.defineProperty(exports, "PLACEHOLDERS", {
	  enumerable: true,
	  get: function () {
	    return placeholders.PLACEHOLDERS;
	  }
	});
	Object.defineProperty(exports, "PLACEHOLDERS_ALIAS", {
	  enumerable: true,
	  get: function () {
	    return placeholders.PLACEHOLDERS_ALIAS;
	  }
	});
	Object.defineProperty(exports, "PLACEHOLDERS_FLIPPED_ALIAS", {
	  enumerable: true,
	  get: function () {
	    return placeholders.PLACEHOLDERS_FLIPPED_ALIAS;
	  }
	});
	exports.TYPES = void 0;

	var _toFastProperties = _interopRequireDefault(toFastProperties);

















	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	(0, _toFastProperties.default)(utils.VISITOR_KEYS);
	(0, _toFastProperties.default)(utils.ALIAS_KEYS);
	(0, _toFastProperties.default)(utils.FLIPPED_ALIAS_KEYS);
	(0, _toFastProperties.default)(utils.NODE_FIELDS);
	(0, _toFastProperties.default)(utils.BUILDER_KEYS);
	(0, _toFastProperties.default)(utils.DEPRECATED_KEYS);
	(0, _toFastProperties.default)(placeholders.PLACEHOLDERS_ALIAS);
	(0, _toFastProperties.default)(placeholders.PLACEHOLDERS_FLIPPED_ALIAS);
	const TYPES = Object.keys(utils.VISITOR_KEYS).concat(Object.keys(utils.FLIPPED_ALIAS_KEYS)).concat(Object.keys(utils.DEPRECATED_KEYS));
	exports.TYPES = TYPES;
	});

	unwrapExports(definitions);
	var definitions_1 = definitions.TYPES;

	var builder_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = builder;

	var _clone = _interopRequireDefault(clone_1);



	var _validate = _interopRequireDefault(validate_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function builder(type, ...args) {
	  const keys = definitions.BUILDER_KEYS[type];
	  const countArgs = args.length;

	  if (countArgs > keys.length) {
	    throw new Error(`${type}: Too many arguments passed. Received ${countArgs} but can receive no more than ${keys.length}`);
	  }

	  const node = {
	    type
	  };
	  let i = 0;
	  keys.forEach(key => {
	    const field = definitions.NODE_FIELDS[type][key];
	    let arg;
	    if (i < countArgs) arg = args[i];
	    if (arg === undefined) arg = (0, _clone.default)(field.default);
	    node[key] = arg;
	    i++;
	  });

	  for (const key of Object.keys(node)) {
	    (0, _validate.default)(node, key, node[key]);
	  }

	  return node;
	}
	});

	unwrapExports(builder_1);

	var generated$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.ArrayExpression = exports.arrayExpression = arrayExpression;
	exports.AssignmentExpression = exports.assignmentExpression = assignmentExpression;
	exports.BinaryExpression = exports.binaryExpression = binaryExpression;
	exports.InterpreterDirective = exports.interpreterDirective = interpreterDirective;
	exports.Directive = exports.directive = directive;
	exports.DirectiveLiteral = exports.directiveLiteral = directiveLiteral;
	exports.BlockStatement = exports.blockStatement = blockStatement;
	exports.BreakStatement = exports.breakStatement = breakStatement;
	exports.CallExpression = exports.callExpression = callExpression;
	exports.CatchClause = exports.catchClause = catchClause;
	exports.ConditionalExpression = exports.conditionalExpression = conditionalExpression;
	exports.ContinueStatement = exports.continueStatement = continueStatement;
	exports.DebuggerStatement = exports.debuggerStatement = debuggerStatement;
	exports.DoWhileStatement = exports.doWhileStatement = doWhileStatement;
	exports.EmptyStatement = exports.emptyStatement = emptyStatement;
	exports.ExpressionStatement = exports.expressionStatement = expressionStatement;
	exports.File = exports.file = file;
	exports.ForInStatement = exports.forInStatement = forInStatement;
	exports.ForStatement = exports.forStatement = forStatement;
	exports.FunctionDeclaration = exports.functionDeclaration = functionDeclaration;
	exports.FunctionExpression = exports.functionExpression = functionExpression;
	exports.Identifier = exports.identifier = identifier;
	exports.IfStatement = exports.ifStatement = ifStatement;
	exports.LabeledStatement = exports.labeledStatement = labeledStatement;
	exports.StringLiteral = exports.stringLiteral = stringLiteral;
	exports.NumericLiteral = exports.numericLiteral = numericLiteral;
	exports.NullLiteral = exports.nullLiteral = nullLiteral;
	exports.BooleanLiteral = exports.booleanLiteral = booleanLiteral;
	exports.RegExpLiteral = exports.regExpLiteral = regExpLiteral;
	exports.LogicalExpression = exports.logicalExpression = logicalExpression;
	exports.MemberExpression = exports.memberExpression = memberExpression;
	exports.NewExpression = exports.newExpression = newExpression;
	exports.Program = exports.program = program;
	exports.ObjectExpression = exports.objectExpression = objectExpression;
	exports.ObjectMethod = exports.objectMethod = objectMethod;
	exports.ObjectProperty = exports.objectProperty = objectProperty;
	exports.RestElement = exports.restElement = restElement;
	exports.ReturnStatement = exports.returnStatement = returnStatement;
	exports.SequenceExpression = exports.sequenceExpression = sequenceExpression;
	exports.ParenthesizedExpression = exports.parenthesizedExpression = parenthesizedExpression;
	exports.SwitchCase = exports.switchCase = switchCase;
	exports.SwitchStatement = exports.switchStatement = switchStatement;
	exports.ThisExpression = exports.thisExpression = thisExpression;
	exports.ThrowStatement = exports.throwStatement = throwStatement;
	exports.TryStatement = exports.tryStatement = tryStatement;
	exports.UnaryExpression = exports.unaryExpression = unaryExpression;
	exports.UpdateExpression = exports.updateExpression = updateExpression;
	exports.VariableDeclaration = exports.variableDeclaration = variableDeclaration;
	exports.VariableDeclarator = exports.variableDeclarator = variableDeclarator;
	exports.WhileStatement = exports.whileStatement = whileStatement;
	exports.WithStatement = exports.withStatement = withStatement;
	exports.AssignmentPattern = exports.assignmentPattern = assignmentPattern;
	exports.ArrayPattern = exports.arrayPattern = arrayPattern;
	exports.ArrowFunctionExpression = exports.arrowFunctionExpression = arrowFunctionExpression;
	exports.ClassBody = exports.classBody = classBody;
	exports.ClassExpression = exports.classExpression = classExpression;
	exports.ClassDeclaration = exports.classDeclaration = classDeclaration;
	exports.ExportAllDeclaration = exports.exportAllDeclaration = exportAllDeclaration;
	exports.ExportDefaultDeclaration = exports.exportDefaultDeclaration = exportDefaultDeclaration;
	exports.ExportNamedDeclaration = exports.exportNamedDeclaration = exportNamedDeclaration;
	exports.ExportSpecifier = exports.exportSpecifier = exportSpecifier;
	exports.ForOfStatement = exports.forOfStatement = forOfStatement;
	exports.ImportDeclaration = exports.importDeclaration = importDeclaration;
	exports.ImportDefaultSpecifier = exports.importDefaultSpecifier = importDefaultSpecifier;
	exports.ImportNamespaceSpecifier = exports.importNamespaceSpecifier = importNamespaceSpecifier;
	exports.ImportSpecifier = exports.importSpecifier = importSpecifier;
	exports.MetaProperty = exports.metaProperty = metaProperty;
	exports.ClassMethod = exports.classMethod = classMethod;
	exports.ObjectPattern = exports.objectPattern = objectPattern;
	exports.SpreadElement = exports.spreadElement = spreadElement;
	exports.super = exports.Super = _super;
	exports.TaggedTemplateExpression = exports.taggedTemplateExpression = taggedTemplateExpression;
	exports.TemplateElement = exports.templateElement = templateElement;
	exports.TemplateLiteral = exports.templateLiteral = templateLiteral;
	exports.YieldExpression = exports.yieldExpression = yieldExpression;
	exports.AwaitExpression = exports.awaitExpression = awaitExpression;
	exports.import = exports.Import = _import;
	exports.BigIntLiteral = exports.bigIntLiteral = bigIntLiteral;
	exports.ExportNamespaceSpecifier = exports.exportNamespaceSpecifier = exportNamespaceSpecifier;
	exports.OptionalMemberExpression = exports.optionalMemberExpression = optionalMemberExpression;
	exports.OptionalCallExpression = exports.optionalCallExpression = optionalCallExpression;
	exports.AnyTypeAnnotation = exports.anyTypeAnnotation = anyTypeAnnotation;
	exports.ArrayTypeAnnotation = exports.arrayTypeAnnotation = arrayTypeAnnotation;
	exports.BooleanTypeAnnotation = exports.booleanTypeAnnotation = booleanTypeAnnotation;
	exports.BooleanLiteralTypeAnnotation = exports.booleanLiteralTypeAnnotation = booleanLiteralTypeAnnotation;
	exports.NullLiteralTypeAnnotation = exports.nullLiteralTypeAnnotation = nullLiteralTypeAnnotation;
	exports.ClassImplements = exports.classImplements = classImplements;
	exports.DeclareClass = exports.declareClass = declareClass;
	exports.DeclareFunction = exports.declareFunction = declareFunction;
	exports.DeclareInterface = exports.declareInterface = declareInterface;
	exports.DeclareModule = exports.declareModule = declareModule;
	exports.DeclareModuleExports = exports.declareModuleExports = declareModuleExports;
	exports.DeclareTypeAlias = exports.declareTypeAlias = declareTypeAlias;
	exports.DeclareOpaqueType = exports.declareOpaqueType = declareOpaqueType;
	exports.DeclareVariable = exports.declareVariable = declareVariable;
	exports.DeclareExportDeclaration = exports.declareExportDeclaration = declareExportDeclaration;
	exports.DeclareExportAllDeclaration = exports.declareExportAllDeclaration = declareExportAllDeclaration;
	exports.DeclaredPredicate = exports.declaredPredicate = declaredPredicate;
	exports.ExistsTypeAnnotation = exports.existsTypeAnnotation = existsTypeAnnotation;
	exports.FunctionTypeAnnotation = exports.functionTypeAnnotation = functionTypeAnnotation;
	exports.FunctionTypeParam = exports.functionTypeParam = functionTypeParam;
	exports.GenericTypeAnnotation = exports.genericTypeAnnotation = genericTypeAnnotation;
	exports.InferredPredicate = exports.inferredPredicate = inferredPredicate;
	exports.InterfaceExtends = exports.interfaceExtends = interfaceExtends;
	exports.InterfaceDeclaration = exports.interfaceDeclaration = interfaceDeclaration;
	exports.InterfaceTypeAnnotation = exports.interfaceTypeAnnotation = interfaceTypeAnnotation;
	exports.IntersectionTypeAnnotation = exports.intersectionTypeAnnotation = intersectionTypeAnnotation;
	exports.MixedTypeAnnotation = exports.mixedTypeAnnotation = mixedTypeAnnotation;
	exports.EmptyTypeAnnotation = exports.emptyTypeAnnotation = emptyTypeAnnotation;
	exports.NullableTypeAnnotation = exports.nullableTypeAnnotation = nullableTypeAnnotation;
	exports.NumberLiteralTypeAnnotation = exports.numberLiteralTypeAnnotation = numberLiteralTypeAnnotation;
	exports.NumberTypeAnnotation = exports.numberTypeAnnotation = numberTypeAnnotation;
	exports.ObjectTypeAnnotation = exports.objectTypeAnnotation = objectTypeAnnotation;
	exports.ObjectTypeInternalSlot = exports.objectTypeInternalSlot = objectTypeInternalSlot;
	exports.ObjectTypeCallProperty = exports.objectTypeCallProperty = objectTypeCallProperty;
	exports.ObjectTypeIndexer = exports.objectTypeIndexer = objectTypeIndexer;
	exports.ObjectTypeProperty = exports.objectTypeProperty = objectTypeProperty;
	exports.ObjectTypeSpreadProperty = exports.objectTypeSpreadProperty = objectTypeSpreadProperty;
	exports.OpaqueType = exports.opaqueType = opaqueType;
	exports.QualifiedTypeIdentifier = exports.qualifiedTypeIdentifier = qualifiedTypeIdentifier;
	exports.StringLiteralTypeAnnotation = exports.stringLiteralTypeAnnotation = stringLiteralTypeAnnotation;
	exports.StringTypeAnnotation = exports.stringTypeAnnotation = stringTypeAnnotation;
	exports.SymbolTypeAnnotation = exports.symbolTypeAnnotation = symbolTypeAnnotation;
	exports.ThisTypeAnnotation = exports.thisTypeAnnotation = thisTypeAnnotation;
	exports.TupleTypeAnnotation = exports.tupleTypeAnnotation = tupleTypeAnnotation;
	exports.TypeofTypeAnnotation = exports.typeofTypeAnnotation = typeofTypeAnnotation;
	exports.TypeAlias = exports.typeAlias = typeAlias;
	exports.TypeAnnotation = exports.typeAnnotation = typeAnnotation;
	exports.TypeCastExpression = exports.typeCastExpression = typeCastExpression;
	exports.TypeParameter = exports.typeParameter = typeParameter;
	exports.TypeParameterDeclaration = exports.typeParameterDeclaration = typeParameterDeclaration;
	exports.TypeParameterInstantiation = exports.typeParameterInstantiation = typeParameterInstantiation;
	exports.UnionTypeAnnotation = exports.unionTypeAnnotation = unionTypeAnnotation;
	exports.Variance = exports.variance = variance;
	exports.VoidTypeAnnotation = exports.voidTypeAnnotation = voidTypeAnnotation;
	exports.EnumDeclaration = exports.enumDeclaration = enumDeclaration;
	exports.EnumBooleanBody = exports.enumBooleanBody = enumBooleanBody;
	exports.EnumNumberBody = exports.enumNumberBody = enumNumberBody;
	exports.EnumStringBody = exports.enumStringBody = enumStringBody;
	exports.EnumSymbolBody = exports.enumSymbolBody = enumSymbolBody;
	exports.EnumBooleanMember = exports.enumBooleanMember = enumBooleanMember;
	exports.EnumNumberMember = exports.enumNumberMember = enumNumberMember;
	exports.EnumStringMember = exports.enumStringMember = enumStringMember;
	exports.EnumDefaultedMember = exports.enumDefaultedMember = enumDefaultedMember;
	exports.jSXAttribute = exports.JSXAttribute = exports.jsxAttribute = jsxAttribute;
	exports.jSXClosingElement = exports.JSXClosingElement = exports.jsxClosingElement = jsxClosingElement;
	exports.jSXElement = exports.JSXElement = exports.jsxElement = jsxElement;
	exports.jSXEmptyExpression = exports.JSXEmptyExpression = exports.jsxEmptyExpression = jsxEmptyExpression;
	exports.jSXExpressionContainer = exports.JSXExpressionContainer = exports.jsxExpressionContainer = jsxExpressionContainer;
	exports.jSXSpreadChild = exports.JSXSpreadChild = exports.jsxSpreadChild = jsxSpreadChild;
	exports.jSXIdentifier = exports.JSXIdentifier = exports.jsxIdentifier = jsxIdentifier;
	exports.jSXMemberExpression = exports.JSXMemberExpression = exports.jsxMemberExpression = jsxMemberExpression;
	exports.jSXNamespacedName = exports.JSXNamespacedName = exports.jsxNamespacedName = jsxNamespacedName;
	exports.jSXOpeningElement = exports.JSXOpeningElement = exports.jsxOpeningElement = jsxOpeningElement;
	exports.jSXSpreadAttribute = exports.JSXSpreadAttribute = exports.jsxSpreadAttribute = jsxSpreadAttribute;
	exports.jSXText = exports.JSXText = exports.jsxText = jsxText;
	exports.jSXFragment = exports.JSXFragment = exports.jsxFragment = jsxFragment;
	exports.jSXOpeningFragment = exports.JSXOpeningFragment = exports.jsxOpeningFragment = jsxOpeningFragment;
	exports.jSXClosingFragment = exports.JSXClosingFragment = exports.jsxClosingFragment = jsxClosingFragment;
	exports.Noop = exports.noop = noop;
	exports.Placeholder = exports.placeholder = placeholder;
	exports.V8IntrinsicIdentifier = exports.v8IntrinsicIdentifier = v8IntrinsicIdentifier;
	exports.ArgumentPlaceholder = exports.argumentPlaceholder = argumentPlaceholder;
	exports.BindExpression = exports.bindExpression = bindExpression;
	exports.ClassProperty = exports.classProperty = classProperty;
	exports.PipelineTopicExpression = exports.pipelineTopicExpression = pipelineTopicExpression;
	exports.PipelineBareFunction = exports.pipelineBareFunction = pipelineBareFunction;
	exports.PipelinePrimaryTopicReference = exports.pipelinePrimaryTopicReference = pipelinePrimaryTopicReference;
	exports.ClassPrivateProperty = exports.classPrivateProperty = classPrivateProperty;
	exports.ClassPrivateMethod = exports.classPrivateMethod = classPrivateMethod;
	exports.ImportAttribute = exports.importAttribute = importAttribute;
	exports.Decorator = exports.decorator = decorator;
	exports.DoExpression = exports.doExpression = doExpression;
	exports.ExportDefaultSpecifier = exports.exportDefaultSpecifier = exportDefaultSpecifier;
	exports.PrivateName = exports.privateName = privateName;
	exports.RecordExpression = exports.recordExpression = recordExpression;
	exports.TupleExpression = exports.tupleExpression = tupleExpression;
	exports.DecimalLiteral = exports.decimalLiteral = decimalLiteral;
	exports.StaticBlock = exports.staticBlock = staticBlock;
	exports.tSParameterProperty = exports.TSParameterProperty = exports.tsParameterProperty = tsParameterProperty;
	exports.tSDeclareFunction = exports.TSDeclareFunction = exports.tsDeclareFunction = tsDeclareFunction;
	exports.tSDeclareMethod = exports.TSDeclareMethod = exports.tsDeclareMethod = tsDeclareMethod;
	exports.tSQualifiedName = exports.TSQualifiedName = exports.tsQualifiedName = tsQualifiedName;
	exports.tSCallSignatureDeclaration = exports.TSCallSignatureDeclaration = exports.tsCallSignatureDeclaration = tsCallSignatureDeclaration;
	exports.tSConstructSignatureDeclaration = exports.TSConstructSignatureDeclaration = exports.tsConstructSignatureDeclaration = tsConstructSignatureDeclaration;
	exports.tSPropertySignature = exports.TSPropertySignature = exports.tsPropertySignature = tsPropertySignature;
	exports.tSMethodSignature = exports.TSMethodSignature = exports.tsMethodSignature = tsMethodSignature;
	exports.tSIndexSignature = exports.TSIndexSignature = exports.tsIndexSignature = tsIndexSignature;
	exports.tSAnyKeyword = exports.TSAnyKeyword = exports.tsAnyKeyword = tsAnyKeyword;
	exports.tSBooleanKeyword = exports.TSBooleanKeyword = exports.tsBooleanKeyword = tsBooleanKeyword;
	exports.tSBigIntKeyword = exports.TSBigIntKeyword = exports.tsBigIntKeyword = tsBigIntKeyword;
	exports.tSIntrinsicKeyword = exports.TSIntrinsicKeyword = exports.tsIntrinsicKeyword = tsIntrinsicKeyword;
	exports.tSNeverKeyword = exports.TSNeverKeyword = exports.tsNeverKeyword = tsNeverKeyword;
	exports.tSNullKeyword = exports.TSNullKeyword = exports.tsNullKeyword = tsNullKeyword;
	exports.tSNumberKeyword = exports.TSNumberKeyword = exports.tsNumberKeyword = tsNumberKeyword;
	exports.tSObjectKeyword = exports.TSObjectKeyword = exports.tsObjectKeyword = tsObjectKeyword;
	exports.tSStringKeyword = exports.TSStringKeyword = exports.tsStringKeyword = tsStringKeyword;
	exports.tSSymbolKeyword = exports.TSSymbolKeyword = exports.tsSymbolKeyword = tsSymbolKeyword;
	exports.tSUndefinedKeyword = exports.TSUndefinedKeyword = exports.tsUndefinedKeyword = tsUndefinedKeyword;
	exports.tSUnknownKeyword = exports.TSUnknownKeyword = exports.tsUnknownKeyword = tsUnknownKeyword;
	exports.tSVoidKeyword = exports.TSVoidKeyword = exports.tsVoidKeyword = tsVoidKeyword;
	exports.tSThisType = exports.TSThisType = exports.tsThisType = tsThisType;
	exports.tSFunctionType = exports.TSFunctionType = exports.tsFunctionType = tsFunctionType;
	exports.tSConstructorType = exports.TSConstructorType = exports.tsConstructorType = tsConstructorType;
	exports.tSTypeReference = exports.TSTypeReference = exports.tsTypeReference = tsTypeReference;
	exports.tSTypePredicate = exports.TSTypePredicate = exports.tsTypePredicate = tsTypePredicate;
	exports.tSTypeQuery = exports.TSTypeQuery = exports.tsTypeQuery = tsTypeQuery;
	exports.tSTypeLiteral = exports.TSTypeLiteral = exports.tsTypeLiteral = tsTypeLiteral;
	exports.tSArrayType = exports.TSArrayType = exports.tsArrayType = tsArrayType;
	exports.tSTupleType = exports.TSTupleType = exports.tsTupleType = tsTupleType;
	exports.tSOptionalType = exports.TSOptionalType = exports.tsOptionalType = tsOptionalType;
	exports.tSRestType = exports.TSRestType = exports.tsRestType = tsRestType;
	exports.tSNamedTupleMember = exports.TSNamedTupleMember = exports.tsNamedTupleMember = tsNamedTupleMember;
	exports.tSUnionType = exports.TSUnionType = exports.tsUnionType = tsUnionType;
	exports.tSIntersectionType = exports.TSIntersectionType = exports.tsIntersectionType = tsIntersectionType;
	exports.tSConditionalType = exports.TSConditionalType = exports.tsConditionalType = tsConditionalType;
	exports.tSInferType = exports.TSInferType = exports.tsInferType = tsInferType;
	exports.tSParenthesizedType = exports.TSParenthesizedType = exports.tsParenthesizedType = tsParenthesizedType;
	exports.tSTypeOperator = exports.TSTypeOperator = exports.tsTypeOperator = tsTypeOperator;
	exports.tSIndexedAccessType = exports.TSIndexedAccessType = exports.tsIndexedAccessType = tsIndexedAccessType;
	exports.tSMappedType = exports.TSMappedType = exports.tsMappedType = tsMappedType;
	exports.tSLiteralType = exports.TSLiteralType = exports.tsLiteralType = tsLiteralType;
	exports.tSExpressionWithTypeArguments = exports.TSExpressionWithTypeArguments = exports.tsExpressionWithTypeArguments = tsExpressionWithTypeArguments;
	exports.tSInterfaceDeclaration = exports.TSInterfaceDeclaration = exports.tsInterfaceDeclaration = tsInterfaceDeclaration;
	exports.tSInterfaceBody = exports.TSInterfaceBody = exports.tsInterfaceBody = tsInterfaceBody;
	exports.tSTypeAliasDeclaration = exports.TSTypeAliasDeclaration = exports.tsTypeAliasDeclaration = tsTypeAliasDeclaration;
	exports.tSAsExpression = exports.TSAsExpression = exports.tsAsExpression = tsAsExpression;
	exports.tSTypeAssertion = exports.TSTypeAssertion = exports.tsTypeAssertion = tsTypeAssertion;
	exports.tSEnumDeclaration = exports.TSEnumDeclaration = exports.tsEnumDeclaration = tsEnumDeclaration;
	exports.tSEnumMember = exports.TSEnumMember = exports.tsEnumMember = tsEnumMember;
	exports.tSModuleDeclaration = exports.TSModuleDeclaration = exports.tsModuleDeclaration = tsModuleDeclaration;
	exports.tSModuleBlock = exports.TSModuleBlock = exports.tsModuleBlock = tsModuleBlock;
	exports.tSImportType = exports.TSImportType = exports.tsImportType = tsImportType;
	exports.tSImportEqualsDeclaration = exports.TSImportEqualsDeclaration = exports.tsImportEqualsDeclaration = tsImportEqualsDeclaration;
	exports.tSExternalModuleReference = exports.TSExternalModuleReference = exports.tsExternalModuleReference = tsExternalModuleReference;
	exports.tSNonNullExpression = exports.TSNonNullExpression = exports.tsNonNullExpression = tsNonNullExpression;
	exports.tSExportAssignment = exports.TSExportAssignment = exports.tsExportAssignment = tsExportAssignment;
	exports.tSNamespaceExportDeclaration = exports.TSNamespaceExportDeclaration = exports.tsNamespaceExportDeclaration = tsNamespaceExportDeclaration;
	exports.tSTypeAnnotation = exports.TSTypeAnnotation = exports.tsTypeAnnotation = tsTypeAnnotation;
	exports.tSTypeParameterInstantiation = exports.TSTypeParameterInstantiation = exports.tsTypeParameterInstantiation = tsTypeParameterInstantiation;
	exports.tSTypeParameterDeclaration = exports.TSTypeParameterDeclaration = exports.tsTypeParameterDeclaration = tsTypeParameterDeclaration;
	exports.tSTypeParameter = exports.TSTypeParameter = exports.tsTypeParameter = tsTypeParameter;
	exports.numberLiteral = exports.NumberLiteral = NumberLiteral;
	exports.regexLiteral = exports.RegexLiteral = RegexLiteral;
	exports.restProperty = exports.RestProperty = RestProperty;
	exports.spreadProperty = exports.SpreadProperty = SpreadProperty;

	var _builder = _interopRequireDefault(builder_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function arrayExpression(...args) {
	  return (0, _builder.default)("ArrayExpression", ...args);
	}

	function assignmentExpression(...args) {
	  return (0, _builder.default)("AssignmentExpression", ...args);
	}

	function binaryExpression(...args) {
	  return (0, _builder.default)("BinaryExpression", ...args);
	}

	function interpreterDirective(...args) {
	  return (0, _builder.default)("InterpreterDirective", ...args);
	}

	function directive(...args) {
	  return (0, _builder.default)("Directive", ...args);
	}

	function directiveLiteral(...args) {
	  return (0, _builder.default)("DirectiveLiteral", ...args);
	}

	function blockStatement(...args) {
	  return (0, _builder.default)("BlockStatement", ...args);
	}

	function breakStatement(...args) {
	  return (0, _builder.default)("BreakStatement", ...args);
	}

	function callExpression(...args) {
	  return (0, _builder.default)("CallExpression", ...args);
	}

	function catchClause(...args) {
	  return (0, _builder.default)("CatchClause", ...args);
	}

	function conditionalExpression(...args) {
	  return (0, _builder.default)("ConditionalExpression", ...args);
	}

	function continueStatement(...args) {
	  return (0, _builder.default)("ContinueStatement", ...args);
	}

	function debuggerStatement(...args) {
	  return (0, _builder.default)("DebuggerStatement", ...args);
	}

	function doWhileStatement(...args) {
	  return (0, _builder.default)("DoWhileStatement", ...args);
	}

	function emptyStatement(...args) {
	  return (0, _builder.default)("EmptyStatement", ...args);
	}

	function expressionStatement(...args) {
	  return (0, _builder.default)("ExpressionStatement", ...args);
	}

	function file(...args) {
	  return (0, _builder.default)("File", ...args);
	}

	function forInStatement(...args) {
	  return (0, _builder.default)("ForInStatement", ...args);
	}

	function forStatement(...args) {
	  return (0, _builder.default)("ForStatement", ...args);
	}

	function functionDeclaration(...args) {
	  return (0, _builder.default)("FunctionDeclaration", ...args);
	}

	function functionExpression(...args) {
	  return (0, _builder.default)("FunctionExpression", ...args);
	}

	function identifier(...args) {
	  return (0, _builder.default)("Identifier", ...args);
	}

	function ifStatement(...args) {
	  return (0, _builder.default)("IfStatement", ...args);
	}

	function labeledStatement(...args) {
	  return (0, _builder.default)("LabeledStatement", ...args);
	}

	function stringLiteral(...args) {
	  return (0, _builder.default)("StringLiteral", ...args);
	}

	function numericLiteral(...args) {
	  return (0, _builder.default)("NumericLiteral", ...args);
	}

	function nullLiteral(...args) {
	  return (0, _builder.default)("NullLiteral", ...args);
	}

	function booleanLiteral(...args) {
	  return (0, _builder.default)("BooleanLiteral", ...args);
	}

	function regExpLiteral(...args) {
	  return (0, _builder.default)("RegExpLiteral", ...args);
	}

	function logicalExpression(...args) {
	  return (0, _builder.default)("LogicalExpression", ...args);
	}

	function memberExpression(...args) {
	  return (0, _builder.default)("MemberExpression", ...args);
	}

	function newExpression(...args) {
	  return (0, _builder.default)("NewExpression", ...args);
	}

	function program(...args) {
	  return (0, _builder.default)("Program", ...args);
	}

	function objectExpression(...args) {
	  return (0, _builder.default)("ObjectExpression", ...args);
	}

	function objectMethod(...args) {
	  return (0, _builder.default)("ObjectMethod", ...args);
	}

	function objectProperty(...args) {
	  return (0, _builder.default)("ObjectProperty", ...args);
	}

	function restElement(...args) {
	  return (0, _builder.default)("RestElement", ...args);
	}

	function returnStatement(...args) {
	  return (0, _builder.default)("ReturnStatement", ...args);
	}

	function sequenceExpression(...args) {
	  return (0, _builder.default)("SequenceExpression", ...args);
	}

	function parenthesizedExpression(...args) {
	  return (0, _builder.default)("ParenthesizedExpression", ...args);
	}

	function switchCase(...args) {
	  return (0, _builder.default)("SwitchCase", ...args);
	}

	function switchStatement(...args) {
	  return (0, _builder.default)("SwitchStatement", ...args);
	}

	function thisExpression(...args) {
	  return (0, _builder.default)("ThisExpression", ...args);
	}

	function throwStatement(...args) {
	  return (0, _builder.default)("ThrowStatement", ...args);
	}

	function tryStatement(...args) {
	  return (0, _builder.default)("TryStatement", ...args);
	}

	function unaryExpression(...args) {
	  return (0, _builder.default)("UnaryExpression", ...args);
	}

	function updateExpression(...args) {
	  return (0, _builder.default)("UpdateExpression", ...args);
	}

	function variableDeclaration(...args) {
	  return (0, _builder.default)("VariableDeclaration", ...args);
	}

	function variableDeclarator(...args) {
	  return (0, _builder.default)("VariableDeclarator", ...args);
	}

	function whileStatement(...args) {
	  return (0, _builder.default)("WhileStatement", ...args);
	}

	function withStatement(...args) {
	  return (0, _builder.default)("WithStatement", ...args);
	}

	function assignmentPattern(...args) {
	  return (0, _builder.default)("AssignmentPattern", ...args);
	}

	function arrayPattern(...args) {
	  return (0, _builder.default)("ArrayPattern", ...args);
	}

	function arrowFunctionExpression(...args) {
	  return (0, _builder.default)("ArrowFunctionExpression", ...args);
	}

	function classBody(...args) {
	  return (0, _builder.default)("ClassBody", ...args);
	}

	function classExpression(...args) {
	  return (0, _builder.default)("ClassExpression", ...args);
	}

	function classDeclaration(...args) {
	  return (0, _builder.default)("ClassDeclaration", ...args);
	}

	function exportAllDeclaration(...args) {
	  return (0, _builder.default)("ExportAllDeclaration", ...args);
	}

	function exportDefaultDeclaration(...args) {
	  return (0, _builder.default)("ExportDefaultDeclaration", ...args);
	}

	function exportNamedDeclaration(...args) {
	  return (0, _builder.default)("ExportNamedDeclaration", ...args);
	}

	function exportSpecifier(...args) {
	  return (0, _builder.default)("ExportSpecifier", ...args);
	}

	function forOfStatement(...args) {
	  return (0, _builder.default)("ForOfStatement", ...args);
	}

	function importDeclaration(...args) {
	  return (0, _builder.default)("ImportDeclaration", ...args);
	}

	function importDefaultSpecifier(...args) {
	  return (0, _builder.default)("ImportDefaultSpecifier", ...args);
	}

	function importNamespaceSpecifier(...args) {
	  return (0, _builder.default)("ImportNamespaceSpecifier", ...args);
	}

	function importSpecifier(...args) {
	  return (0, _builder.default)("ImportSpecifier", ...args);
	}

	function metaProperty(...args) {
	  return (0, _builder.default)("MetaProperty", ...args);
	}

	function classMethod(...args) {
	  return (0, _builder.default)("ClassMethod", ...args);
	}

	function objectPattern(...args) {
	  return (0, _builder.default)("ObjectPattern", ...args);
	}

	function spreadElement(...args) {
	  return (0, _builder.default)("SpreadElement", ...args);
	}

	function _super(...args) {
	  return (0, _builder.default)("Super", ...args);
	}

	function taggedTemplateExpression(...args) {
	  return (0, _builder.default)("TaggedTemplateExpression", ...args);
	}

	function templateElement(...args) {
	  return (0, _builder.default)("TemplateElement", ...args);
	}

	function templateLiteral(...args) {
	  return (0, _builder.default)("TemplateLiteral", ...args);
	}

	function yieldExpression(...args) {
	  return (0, _builder.default)("YieldExpression", ...args);
	}

	function awaitExpression(...args) {
	  return (0, _builder.default)("AwaitExpression", ...args);
	}

	function _import(...args) {
	  return (0, _builder.default)("Import", ...args);
	}

	function bigIntLiteral(...args) {
	  return (0, _builder.default)("BigIntLiteral", ...args);
	}

	function exportNamespaceSpecifier(...args) {
	  return (0, _builder.default)("ExportNamespaceSpecifier", ...args);
	}

	function optionalMemberExpression(...args) {
	  return (0, _builder.default)("OptionalMemberExpression", ...args);
	}

	function optionalCallExpression(...args) {
	  return (0, _builder.default)("OptionalCallExpression", ...args);
	}

	function anyTypeAnnotation(...args) {
	  return (0, _builder.default)("AnyTypeAnnotation", ...args);
	}

	function arrayTypeAnnotation(...args) {
	  return (0, _builder.default)("ArrayTypeAnnotation", ...args);
	}

	function booleanTypeAnnotation(...args) {
	  return (0, _builder.default)("BooleanTypeAnnotation", ...args);
	}

	function booleanLiteralTypeAnnotation(...args) {
	  return (0, _builder.default)("BooleanLiteralTypeAnnotation", ...args);
	}

	function nullLiteralTypeAnnotation(...args) {
	  return (0, _builder.default)("NullLiteralTypeAnnotation", ...args);
	}

	function classImplements(...args) {
	  return (0, _builder.default)("ClassImplements", ...args);
	}

	function declareClass(...args) {
	  return (0, _builder.default)("DeclareClass", ...args);
	}

	function declareFunction(...args) {
	  return (0, _builder.default)("DeclareFunction", ...args);
	}

	function declareInterface(...args) {
	  return (0, _builder.default)("DeclareInterface", ...args);
	}

	function declareModule(...args) {
	  return (0, _builder.default)("DeclareModule", ...args);
	}

	function declareModuleExports(...args) {
	  return (0, _builder.default)("DeclareModuleExports", ...args);
	}

	function declareTypeAlias(...args) {
	  return (0, _builder.default)("DeclareTypeAlias", ...args);
	}

	function declareOpaqueType(...args) {
	  return (0, _builder.default)("DeclareOpaqueType", ...args);
	}

	function declareVariable(...args) {
	  return (0, _builder.default)("DeclareVariable", ...args);
	}

	function declareExportDeclaration(...args) {
	  return (0, _builder.default)("DeclareExportDeclaration", ...args);
	}

	function declareExportAllDeclaration(...args) {
	  return (0, _builder.default)("DeclareExportAllDeclaration", ...args);
	}

	function declaredPredicate(...args) {
	  return (0, _builder.default)("DeclaredPredicate", ...args);
	}

	function existsTypeAnnotation(...args) {
	  return (0, _builder.default)("ExistsTypeAnnotation", ...args);
	}

	function functionTypeAnnotation(...args) {
	  return (0, _builder.default)("FunctionTypeAnnotation", ...args);
	}

	function functionTypeParam(...args) {
	  return (0, _builder.default)("FunctionTypeParam", ...args);
	}

	function genericTypeAnnotation(...args) {
	  return (0, _builder.default)("GenericTypeAnnotation", ...args);
	}

	function inferredPredicate(...args) {
	  return (0, _builder.default)("InferredPredicate", ...args);
	}

	function interfaceExtends(...args) {
	  return (0, _builder.default)("InterfaceExtends", ...args);
	}

	function interfaceDeclaration(...args) {
	  return (0, _builder.default)("InterfaceDeclaration", ...args);
	}

	function interfaceTypeAnnotation(...args) {
	  return (0, _builder.default)("InterfaceTypeAnnotation", ...args);
	}

	function intersectionTypeAnnotation(...args) {
	  return (0, _builder.default)("IntersectionTypeAnnotation", ...args);
	}

	function mixedTypeAnnotation(...args) {
	  return (0, _builder.default)("MixedTypeAnnotation", ...args);
	}

	function emptyTypeAnnotation(...args) {
	  return (0, _builder.default)("EmptyTypeAnnotation", ...args);
	}

	function nullableTypeAnnotation(...args) {
	  return (0, _builder.default)("NullableTypeAnnotation", ...args);
	}

	function numberLiteralTypeAnnotation(...args) {
	  return (0, _builder.default)("NumberLiteralTypeAnnotation", ...args);
	}

	function numberTypeAnnotation(...args) {
	  return (0, _builder.default)("NumberTypeAnnotation", ...args);
	}

	function objectTypeAnnotation(...args) {
	  return (0, _builder.default)("ObjectTypeAnnotation", ...args);
	}

	function objectTypeInternalSlot(...args) {
	  return (0, _builder.default)("ObjectTypeInternalSlot", ...args);
	}

	function objectTypeCallProperty(...args) {
	  return (0, _builder.default)("ObjectTypeCallProperty", ...args);
	}

	function objectTypeIndexer(...args) {
	  return (0, _builder.default)("ObjectTypeIndexer", ...args);
	}

	function objectTypeProperty(...args) {
	  return (0, _builder.default)("ObjectTypeProperty", ...args);
	}

	function objectTypeSpreadProperty(...args) {
	  return (0, _builder.default)("ObjectTypeSpreadProperty", ...args);
	}

	function opaqueType(...args) {
	  return (0, _builder.default)("OpaqueType", ...args);
	}

	function qualifiedTypeIdentifier(...args) {
	  return (0, _builder.default)("QualifiedTypeIdentifier", ...args);
	}

	function stringLiteralTypeAnnotation(...args) {
	  return (0, _builder.default)("StringLiteralTypeAnnotation", ...args);
	}

	function stringTypeAnnotation(...args) {
	  return (0, _builder.default)("StringTypeAnnotation", ...args);
	}

	function symbolTypeAnnotation(...args) {
	  return (0, _builder.default)("SymbolTypeAnnotation", ...args);
	}

	function thisTypeAnnotation(...args) {
	  return (0, _builder.default)("ThisTypeAnnotation", ...args);
	}

	function tupleTypeAnnotation(...args) {
	  return (0, _builder.default)("TupleTypeAnnotation", ...args);
	}

	function typeofTypeAnnotation(...args) {
	  return (0, _builder.default)("TypeofTypeAnnotation", ...args);
	}

	function typeAlias(...args) {
	  return (0, _builder.default)("TypeAlias", ...args);
	}

	function typeAnnotation(...args) {
	  return (0, _builder.default)("TypeAnnotation", ...args);
	}

	function typeCastExpression(...args) {
	  return (0, _builder.default)("TypeCastExpression", ...args);
	}

	function typeParameter(...args) {
	  return (0, _builder.default)("TypeParameter", ...args);
	}

	function typeParameterDeclaration(...args) {
	  return (0, _builder.default)("TypeParameterDeclaration", ...args);
	}

	function typeParameterInstantiation(...args) {
	  return (0, _builder.default)("TypeParameterInstantiation", ...args);
	}

	function unionTypeAnnotation(...args) {
	  return (0, _builder.default)("UnionTypeAnnotation", ...args);
	}

	function variance(...args) {
	  return (0, _builder.default)("Variance", ...args);
	}

	function voidTypeAnnotation(...args) {
	  return (0, _builder.default)("VoidTypeAnnotation", ...args);
	}

	function enumDeclaration(...args) {
	  return (0, _builder.default)("EnumDeclaration", ...args);
	}

	function enumBooleanBody(...args) {
	  return (0, _builder.default)("EnumBooleanBody", ...args);
	}

	function enumNumberBody(...args) {
	  return (0, _builder.default)("EnumNumberBody", ...args);
	}

	function enumStringBody(...args) {
	  return (0, _builder.default)("EnumStringBody", ...args);
	}

	function enumSymbolBody(...args) {
	  return (0, _builder.default)("EnumSymbolBody", ...args);
	}

	function enumBooleanMember(...args) {
	  return (0, _builder.default)("EnumBooleanMember", ...args);
	}

	function enumNumberMember(...args) {
	  return (0, _builder.default)("EnumNumberMember", ...args);
	}

	function enumStringMember(...args) {
	  return (0, _builder.default)("EnumStringMember", ...args);
	}

	function enumDefaultedMember(...args) {
	  return (0, _builder.default)("EnumDefaultedMember", ...args);
	}

	function jsxAttribute(...args) {
	  return (0, _builder.default)("JSXAttribute", ...args);
	}

	function jsxClosingElement(...args) {
	  return (0, _builder.default)("JSXClosingElement", ...args);
	}

	function jsxElement(...args) {
	  return (0, _builder.default)("JSXElement", ...args);
	}

	function jsxEmptyExpression(...args) {
	  return (0, _builder.default)("JSXEmptyExpression", ...args);
	}

	function jsxExpressionContainer(...args) {
	  return (0, _builder.default)("JSXExpressionContainer", ...args);
	}

	function jsxSpreadChild(...args) {
	  return (0, _builder.default)("JSXSpreadChild", ...args);
	}

	function jsxIdentifier(...args) {
	  return (0, _builder.default)("JSXIdentifier", ...args);
	}

	function jsxMemberExpression(...args) {
	  return (0, _builder.default)("JSXMemberExpression", ...args);
	}

	function jsxNamespacedName(...args) {
	  return (0, _builder.default)("JSXNamespacedName", ...args);
	}

	function jsxOpeningElement(...args) {
	  return (0, _builder.default)("JSXOpeningElement", ...args);
	}

	function jsxSpreadAttribute(...args) {
	  return (0, _builder.default)("JSXSpreadAttribute", ...args);
	}

	function jsxText(...args) {
	  return (0, _builder.default)("JSXText", ...args);
	}

	function jsxFragment(...args) {
	  return (0, _builder.default)("JSXFragment", ...args);
	}

	function jsxOpeningFragment(...args) {
	  return (0, _builder.default)("JSXOpeningFragment", ...args);
	}

	function jsxClosingFragment(...args) {
	  return (0, _builder.default)("JSXClosingFragment", ...args);
	}

	function noop(...args) {
	  return (0, _builder.default)("Noop", ...args);
	}

	function placeholder(...args) {
	  return (0, _builder.default)("Placeholder", ...args);
	}

	function v8IntrinsicIdentifier(...args) {
	  return (0, _builder.default)("V8IntrinsicIdentifier", ...args);
	}

	function argumentPlaceholder(...args) {
	  return (0, _builder.default)("ArgumentPlaceholder", ...args);
	}

	function bindExpression(...args) {
	  return (0, _builder.default)("BindExpression", ...args);
	}

	function classProperty(...args) {
	  return (0, _builder.default)("ClassProperty", ...args);
	}

	function pipelineTopicExpression(...args) {
	  return (0, _builder.default)("PipelineTopicExpression", ...args);
	}

	function pipelineBareFunction(...args) {
	  return (0, _builder.default)("PipelineBareFunction", ...args);
	}

	function pipelinePrimaryTopicReference(...args) {
	  return (0, _builder.default)("PipelinePrimaryTopicReference", ...args);
	}

	function classPrivateProperty(...args) {
	  return (0, _builder.default)("ClassPrivateProperty", ...args);
	}

	function classPrivateMethod(...args) {
	  return (0, _builder.default)("ClassPrivateMethod", ...args);
	}

	function importAttribute(...args) {
	  return (0, _builder.default)("ImportAttribute", ...args);
	}

	function decorator(...args) {
	  return (0, _builder.default)("Decorator", ...args);
	}

	function doExpression(...args) {
	  return (0, _builder.default)("DoExpression", ...args);
	}

	function exportDefaultSpecifier(...args) {
	  return (0, _builder.default)("ExportDefaultSpecifier", ...args);
	}

	function privateName(...args) {
	  return (0, _builder.default)("PrivateName", ...args);
	}

	function recordExpression(...args) {
	  return (0, _builder.default)("RecordExpression", ...args);
	}

	function tupleExpression(...args) {
	  return (0, _builder.default)("TupleExpression", ...args);
	}

	function decimalLiteral(...args) {
	  return (0, _builder.default)("DecimalLiteral", ...args);
	}

	function staticBlock(...args) {
	  return (0, _builder.default)("StaticBlock", ...args);
	}

	function tsParameterProperty(...args) {
	  return (0, _builder.default)("TSParameterProperty", ...args);
	}

	function tsDeclareFunction(...args) {
	  return (0, _builder.default)("TSDeclareFunction", ...args);
	}

	function tsDeclareMethod(...args) {
	  return (0, _builder.default)("TSDeclareMethod", ...args);
	}

	function tsQualifiedName(...args) {
	  return (0, _builder.default)("TSQualifiedName", ...args);
	}

	function tsCallSignatureDeclaration(...args) {
	  return (0, _builder.default)("TSCallSignatureDeclaration", ...args);
	}

	function tsConstructSignatureDeclaration(...args) {
	  return (0, _builder.default)("TSConstructSignatureDeclaration", ...args);
	}

	function tsPropertySignature(...args) {
	  return (0, _builder.default)("TSPropertySignature", ...args);
	}

	function tsMethodSignature(...args) {
	  return (0, _builder.default)("TSMethodSignature", ...args);
	}

	function tsIndexSignature(...args) {
	  return (0, _builder.default)("TSIndexSignature", ...args);
	}

	function tsAnyKeyword(...args) {
	  return (0, _builder.default)("TSAnyKeyword", ...args);
	}

	function tsBooleanKeyword(...args) {
	  return (0, _builder.default)("TSBooleanKeyword", ...args);
	}

	function tsBigIntKeyword(...args) {
	  return (0, _builder.default)("TSBigIntKeyword", ...args);
	}

	function tsIntrinsicKeyword(...args) {
	  return (0, _builder.default)("TSIntrinsicKeyword", ...args);
	}

	function tsNeverKeyword(...args) {
	  return (0, _builder.default)("TSNeverKeyword", ...args);
	}

	function tsNullKeyword(...args) {
	  return (0, _builder.default)("TSNullKeyword", ...args);
	}

	function tsNumberKeyword(...args) {
	  return (0, _builder.default)("TSNumberKeyword", ...args);
	}

	function tsObjectKeyword(...args) {
	  return (0, _builder.default)("TSObjectKeyword", ...args);
	}

	function tsStringKeyword(...args) {
	  return (0, _builder.default)("TSStringKeyword", ...args);
	}

	function tsSymbolKeyword(...args) {
	  return (0, _builder.default)("TSSymbolKeyword", ...args);
	}

	function tsUndefinedKeyword(...args) {
	  return (0, _builder.default)("TSUndefinedKeyword", ...args);
	}

	function tsUnknownKeyword(...args) {
	  return (0, _builder.default)("TSUnknownKeyword", ...args);
	}

	function tsVoidKeyword(...args) {
	  return (0, _builder.default)("TSVoidKeyword", ...args);
	}

	function tsThisType(...args) {
	  return (0, _builder.default)("TSThisType", ...args);
	}

	function tsFunctionType(...args) {
	  return (0, _builder.default)("TSFunctionType", ...args);
	}

	function tsConstructorType(...args) {
	  return (0, _builder.default)("TSConstructorType", ...args);
	}

	function tsTypeReference(...args) {
	  return (0, _builder.default)("TSTypeReference", ...args);
	}

	function tsTypePredicate(...args) {
	  return (0, _builder.default)("TSTypePredicate", ...args);
	}

	function tsTypeQuery(...args) {
	  return (0, _builder.default)("TSTypeQuery", ...args);
	}

	function tsTypeLiteral(...args) {
	  return (0, _builder.default)("TSTypeLiteral", ...args);
	}

	function tsArrayType(...args) {
	  return (0, _builder.default)("TSArrayType", ...args);
	}

	function tsTupleType(...args) {
	  return (0, _builder.default)("TSTupleType", ...args);
	}

	function tsOptionalType(...args) {
	  return (0, _builder.default)("TSOptionalType", ...args);
	}

	function tsRestType(...args) {
	  return (0, _builder.default)("TSRestType", ...args);
	}

	function tsNamedTupleMember(...args) {
	  return (0, _builder.default)("TSNamedTupleMember", ...args);
	}

	function tsUnionType(...args) {
	  return (0, _builder.default)("TSUnionType", ...args);
	}

	function tsIntersectionType(...args) {
	  return (0, _builder.default)("TSIntersectionType", ...args);
	}

	function tsConditionalType(...args) {
	  return (0, _builder.default)("TSConditionalType", ...args);
	}

	function tsInferType(...args) {
	  return (0, _builder.default)("TSInferType", ...args);
	}

	function tsParenthesizedType(...args) {
	  return (0, _builder.default)("TSParenthesizedType", ...args);
	}

	function tsTypeOperator(...args) {
	  return (0, _builder.default)("TSTypeOperator", ...args);
	}

	function tsIndexedAccessType(...args) {
	  return (0, _builder.default)("TSIndexedAccessType", ...args);
	}

	function tsMappedType(...args) {
	  return (0, _builder.default)("TSMappedType", ...args);
	}

	function tsLiteralType(...args) {
	  return (0, _builder.default)("TSLiteralType", ...args);
	}

	function tsExpressionWithTypeArguments(...args) {
	  return (0, _builder.default)("TSExpressionWithTypeArguments", ...args);
	}

	function tsInterfaceDeclaration(...args) {
	  return (0, _builder.default)("TSInterfaceDeclaration", ...args);
	}

	function tsInterfaceBody(...args) {
	  return (0, _builder.default)("TSInterfaceBody", ...args);
	}

	function tsTypeAliasDeclaration(...args) {
	  return (0, _builder.default)("TSTypeAliasDeclaration", ...args);
	}

	function tsAsExpression(...args) {
	  return (0, _builder.default)("TSAsExpression", ...args);
	}

	function tsTypeAssertion(...args) {
	  return (0, _builder.default)("TSTypeAssertion", ...args);
	}

	function tsEnumDeclaration(...args) {
	  return (0, _builder.default)("TSEnumDeclaration", ...args);
	}

	function tsEnumMember(...args) {
	  return (0, _builder.default)("TSEnumMember", ...args);
	}

	function tsModuleDeclaration(...args) {
	  return (0, _builder.default)("TSModuleDeclaration", ...args);
	}

	function tsModuleBlock(...args) {
	  return (0, _builder.default)("TSModuleBlock", ...args);
	}

	function tsImportType(...args) {
	  return (0, _builder.default)("TSImportType", ...args);
	}

	function tsImportEqualsDeclaration(...args) {
	  return (0, _builder.default)("TSImportEqualsDeclaration", ...args);
	}

	function tsExternalModuleReference(...args) {
	  return (0, _builder.default)("TSExternalModuleReference", ...args);
	}

	function tsNonNullExpression(...args) {
	  return (0, _builder.default)("TSNonNullExpression", ...args);
	}

	function tsExportAssignment(...args) {
	  return (0, _builder.default)("TSExportAssignment", ...args);
	}

	function tsNamespaceExportDeclaration(...args) {
	  return (0, _builder.default)("TSNamespaceExportDeclaration", ...args);
	}

	function tsTypeAnnotation(...args) {
	  return (0, _builder.default)("TSTypeAnnotation", ...args);
	}

	function tsTypeParameterInstantiation(...args) {
	  return (0, _builder.default)("TSTypeParameterInstantiation", ...args);
	}

	function tsTypeParameterDeclaration(...args) {
	  return (0, _builder.default)("TSTypeParameterDeclaration", ...args);
	}

	function tsTypeParameter(...args) {
	  return (0, _builder.default)("TSTypeParameter", ...args);
	}

	function NumberLiteral(...args) {
	  console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
	  return (0, _builder.default)("NumberLiteral", ...args);
	}

	function RegexLiteral(...args) {
	  console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
	  return (0, _builder.default)("RegexLiteral", ...args);
	}

	function RestProperty(...args) {
	  console.trace("The node type RestProperty has been renamed to RestElement");
	  return (0, _builder.default)("RestProperty", ...args);
	}

	function SpreadProperty(...args) {
	  console.trace("The node type SpreadProperty has been renamed to SpreadElement");
	  return (0, _builder.default)("SpreadProperty", ...args);
	}
	});

	unwrapExports(generated$1);
	var generated_1$1 = generated$1.ArrayExpression;
	var generated_2$1 = generated$1.arrayExpression;
	var generated_3$1 = generated$1.AssignmentExpression;
	var generated_4$1 = generated$1.assignmentExpression;
	var generated_5$1 = generated$1.BinaryExpression;
	var generated_6$1 = generated$1.binaryExpression;
	var generated_7$1 = generated$1.InterpreterDirective;
	var generated_8$1 = generated$1.interpreterDirective;
	var generated_9$1 = generated$1.Directive;
	var generated_10$1 = generated$1.directive;
	var generated_11$1 = generated$1.DirectiveLiteral;
	var generated_12$1 = generated$1.directiveLiteral;
	var generated_13$1 = generated$1.BlockStatement;
	var generated_14$1 = generated$1.blockStatement;
	var generated_15$1 = generated$1.BreakStatement;
	var generated_16$1 = generated$1.breakStatement;
	var generated_17$1 = generated$1.CallExpression;
	var generated_18$1 = generated$1.callExpression;
	var generated_19$1 = generated$1.CatchClause;
	var generated_20$1 = generated$1.catchClause;
	var generated_21$1 = generated$1.ConditionalExpression;
	var generated_22$1 = generated$1.conditionalExpression;
	var generated_23$1 = generated$1.ContinueStatement;
	var generated_24$1 = generated$1.continueStatement;
	var generated_25$1 = generated$1.DebuggerStatement;
	var generated_26$1 = generated$1.debuggerStatement;
	var generated_27$1 = generated$1.DoWhileStatement;
	var generated_28$1 = generated$1.doWhileStatement;
	var generated_29$1 = generated$1.EmptyStatement;
	var generated_30$1 = generated$1.emptyStatement;
	var generated_31$1 = generated$1.ExpressionStatement;
	var generated_32$1 = generated$1.expressionStatement;
	var generated_33$1 = generated$1.File;
	var generated_34$1 = generated$1.file;
	var generated_35$1 = generated$1.ForInStatement;
	var generated_36$1 = generated$1.forInStatement;
	var generated_37$1 = generated$1.ForStatement;
	var generated_38$1 = generated$1.forStatement;
	var generated_39$1 = generated$1.FunctionDeclaration;
	var generated_40$1 = generated$1.functionDeclaration;
	var generated_41$1 = generated$1.FunctionExpression;
	var generated_42$1 = generated$1.functionExpression;
	var generated_43$1 = generated$1.Identifier;
	var generated_44$1 = generated$1.identifier;
	var generated_45$1 = generated$1.IfStatement;
	var generated_46$1 = generated$1.ifStatement;
	var generated_47$1 = generated$1.LabeledStatement;
	var generated_48$1 = generated$1.labeledStatement;
	var generated_49$1 = generated$1.StringLiteral;
	var generated_50$1 = generated$1.stringLiteral;
	var generated_51$1 = generated$1.NumericLiteral;
	var generated_52$1 = generated$1.numericLiteral;
	var generated_53$1 = generated$1.NullLiteral;
	var generated_54$1 = generated$1.nullLiteral;
	var generated_55$1 = generated$1.BooleanLiteral;
	var generated_56$1 = generated$1.booleanLiteral;
	var generated_57$1 = generated$1.RegExpLiteral;
	var generated_58$1 = generated$1.regExpLiteral;
	var generated_59$1 = generated$1.LogicalExpression;
	var generated_60$1 = generated$1.logicalExpression;
	var generated_61$1 = generated$1.MemberExpression;
	var generated_62$1 = generated$1.memberExpression;
	var generated_63$1 = generated$1.NewExpression;
	var generated_64$1 = generated$1.newExpression;
	var generated_65$1 = generated$1.Program;
	var generated_66$1 = generated$1.program;
	var generated_67$1 = generated$1.ObjectExpression;
	var generated_68$1 = generated$1.objectExpression;
	var generated_69$1 = generated$1.ObjectMethod;
	var generated_70$1 = generated$1.objectMethod;
	var generated_71$1 = generated$1.ObjectProperty;
	var generated_72$1 = generated$1.objectProperty;
	var generated_73$1 = generated$1.RestElement;
	var generated_74$1 = generated$1.restElement;
	var generated_75$1 = generated$1.ReturnStatement;
	var generated_76$1 = generated$1.returnStatement;
	var generated_77$1 = generated$1.SequenceExpression;
	var generated_78$1 = generated$1.sequenceExpression;
	var generated_79$1 = generated$1.ParenthesizedExpression;
	var generated_80$1 = generated$1.parenthesizedExpression;
	var generated_81$1 = generated$1.SwitchCase;
	var generated_82$1 = generated$1.switchCase;
	var generated_83$1 = generated$1.SwitchStatement;
	var generated_84$1 = generated$1.switchStatement;
	var generated_85$1 = generated$1.ThisExpression;
	var generated_86$1 = generated$1.thisExpression;
	var generated_87$1 = generated$1.ThrowStatement;
	var generated_88$1 = generated$1.throwStatement;
	var generated_89$1 = generated$1.TryStatement;
	var generated_90$1 = generated$1.tryStatement;
	var generated_91$1 = generated$1.UnaryExpression;
	var generated_92$1 = generated$1.unaryExpression;
	var generated_93$1 = generated$1.UpdateExpression;
	var generated_94$1 = generated$1.updateExpression;
	var generated_95$1 = generated$1.VariableDeclaration;
	var generated_96$1 = generated$1.variableDeclaration;
	var generated_97$1 = generated$1.VariableDeclarator;
	var generated_98$1 = generated$1.variableDeclarator;
	var generated_99$1 = generated$1.WhileStatement;
	var generated_100$1 = generated$1.whileStatement;
	var generated_101$1 = generated$1.WithStatement;
	var generated_102$1 = generated$1.withStatement;
	var generated_103$1 = generated$1.AssignmentPattern;
	var generated_104$1 = generated$1.assignmentPattern;
	var generated_105$1 = generated$1.ArrayPattern;
	var generated_106$1 = generated$1.arrayPattern;
	var generated_107$1 = generated$1.ArrowFunctionExpression;
	var generated_108$1 = generated$1.arrowFunctionExpression;
	var generated_109$1 = generated$1.ClassBody;
	var generated_110$1 = generated$1.classBody;
	var generated_111$1 = generated$1.ClassExpression;
	var generated_112$1 = generated$1.classExpression;
	var generated_113$1 = generated$1.ClassDeclaration;
	var generated_114$1 = generated$1.classDeclaration;
	var generated_115$1 = generated$1.ExportAllDeclaration;
	var generated_116$1 = generated$1.exportAllDeclaration;
	var generated_117$1 = generated$1.ExportDefaultDeclaration;
	var generated_118$1 = generated$1.exportDefaultDeclaration;
	var generated_119$1 = generated$1.ExportNamedDeclaration;
	var generated_120$1 = generated$1.exportNamedDeclaration;
	var generated_121$1 = generated$1.ExportSpecifier;
	var generated_122$1 = generated$1.exportSpecifier;
	var generated_123$1 = generated$1.ForOfStatement;
	var generated_124$1 = generated$1.forOfStatement;
	var generated_125$1 = generated$1.ImportDeclaration;
	var generated_126$1 = generated$1.importDeclaration;
	var generated_127$1 = generated$1.ImportDefaultSpecifier;
	var generated_128$1 = generated$1.importDefaultSpecifier;
	var generated_129$1 = generated$1.ImportNamespaceSpecifier;
	var generated_130$1 = generated$1.importNamespaceSpecifier;
	var generated_131$1 = generated$1.ImportSpecifier;
	var generated_132$1 = generated$1.importSpecifier;
	var generated_133$1 = generated$1.MetaProperty;
	var generated_134$1 = generated$1.metaProperty;
	var generated_135$1 = generated$1.ClassMethod;
	var generated_136$1 = generated$1.classMethod;
	var generated_137$1 = generated$1.ObjectPattern;
	var generated_138$1 = generated$1.objectPattern;
	var generated_139$1 = generated$1.SpreadElement;
	var generated_140$1 = generated$1.spreadElement;
	var generated_141$1 = generated$1.Super;
	var generated_142$1 = generated$1.TaggedTemplateExpression;
	var generated_143$1 = generated$1.taggedTemplateExpression;
	var generated_144$1 = generated$1.TemplateElement;
	var generated_145$1 = generated$1.templateElement;
	var generated_146$1 = generated$1.TemplateLiteral;
	var generated_147$1 = generated$1.templateLiteral;
	var generated_148$1 = generated$1.YieldExpression;
	var generated_149$1 = generated$1.yieldExpression;
	var generated_150$1 = generated$1.AwaitExpression;
	var generated_151$1 = generated$1.awaitExpression;
	var generated_152$1 = generated$1.Import;
	var generated_153$1 = generated$1.BigIntLiteral;
	var generated_154$1 = generated$1.bigIntLiteral;
	var generated_155$1 = generated$1.ExportNamespaceSpecifier;
	var generated_156$1 = generated$1.exportNamespaceSpecifier;
	var generated_157$1 = generated$1.OptionalMemberExpression;
	var generated_158$1 = generated$1.optionalMemberExpression;
	var generated_159$1 = generated$1.OptionalCallExpression;
	var generated_160$1 = generated$1.optionalCallExpression;
	var generated_161$1 = generated$1.AnyTypeAnnotation;
	var generated_162$1 = generated$1.anyTypeAnnotation;
	var generated_163$1 = generated$1.ArrayTypeAnnotation;
	var generated_164$1 = generated$1.arrayTypeAnnotation;
	var generated_165$1 = generated$1.BooleanTypeAnnotation;
	var generated_166$1 = generated$1.booleanTypeAnnotation;
	var generated_167$1 = generated$1.BooleanLiteralTypeAnnotation;
	var generated_168$1 = generated$1.booleanLiteralTypeAnnotation;
	var generated_169$1 = generated$1.NullLiteralTypeAnnotation;
	var generated_170$1 = generated$1.nullLiteralTypeAnnotation;
	var generated_171$1 = generated$1.ClassImplements;
	var generated_172$1 = generated$1.classImplements;
	var generated_173$1 = generated$1.DeclareClass;
	var generated_174$1 = generated$1.declareClass;
	var generated_175$1 = generated$1.DeclareFunction;
	var generated_176$1 = generated$1.declareFunction;
	var generated_177$1 = generated$1.DeclareInterface;
	var generated_178$1 = generated$1.declareInterface;
	var generated_179$1 = generated$1.DeclareModule;
	var generated_180$1 = generated$1.declareModule;
	var generated_181$1 = generated$1.DeclareModuleExports;
	var generated_182$1 = generated$1.declareModuleExports;
	var generated_183$1 = generated$1.DeclareTypeAlias;
	var generated_184$1 = generated$1.declareTypeAlias;
	var generated_185$1 = generated$1.DeclareOpaqueType;
	var generated_186$1 = generated$1.declareOpaqueType;
	var generated_187$1 = generated$1.DeclareVariable;
	var generated_188$1 = generated$1.declareVariable;
	var generated_189$1 = generated$1.DeclareExportDeclaration;
	var generated_190$1 = generated$1.declareExportDeclaration;
	var generated_191$1 = generated$1.DeclareExportAllDeclaration;
	var generated_192$1 = generated$1.declareExportAllDeclaration;
	var generated_193$1 = generated$1.DeclaredPredicate;
	var generated_194$1 = generated$1.declaredPredicate;
	var generated_195$1 = generated$1.ExistsTypeAnnotation;
	var generated_196$1 = generated$1.existsTypeAnnotation;
	var generated_197$1 = generated$1.FunctionTypeAnnotation;
	var generated_198$1 = generated$1.functionTypeAnnotation;
	var generated_199$1 = generated$1.FunctionTypeParam;
	var generated_200$1 = generated$1.functionTypeParam;
	var generated_201$1 = generated$1.GenericTypeAnnotation;
	var generated_202$1 = generated$1.genericTypeAnnotation;
	var generated_203$1 = generated$1.InferredPredicate;
	var generated_204$1 = generated$1.inferredPredicate;
	var generated_205$1 = generated$1.InterfaceExtends;
	var generated_206$1 = generated$1.interfaceExtends;
	var generated_207$1 = generated$1.InterfaceDeclaration;
	var generated_208$1 = generated$1.interfaceDeclaration;
	var generated_209$1 = generated$1.InterfaceTypeAnnotation;
	var generated_210$1 = generated$1.interfaceTypeAnnotation;
	var generated_211$1 = generated$1.IntersectionTypeAnnotation;
	var generated_212$1 = generated$1.intersectionTypeAnnotation;
	var generated_213$1 = generated$1.MixedTypeAnnotation;
	var generated_214$1 = generated$1.mixedTypeAnnotation;
	var generated_215$1 = generated$1.EmptyTypeAnnotation;
	var generated_216$1 = generated$1.emptyTypeAnnotation;
	var generated_217$1 = generated$1.NullableTypeAnnotation;
	var generated_218$1 = generated$1.nullableTypeAnnotation;
	var generated_219$1 = generated$1.NumberLiteralTypeAnnotation;
	var generated_220$1 = generated$1.numberLiteralTypeAnnotation;
	var generated_221$1 = generated$1.NumberTypeAnnotation;
	var generated_222$1 = generated$1.numberTypeAnnotation;
	var generated_223$1 = generated$1.ObjectTypeAnnotation;
	var generated_224$1 = generated$1.objectTypeAnnotation;
	var generated_225$1 = generated$1.ObjectTypeInternalSlot;
	var generated_226$1 = generated$1.objectTypeInternalSlot;
	var generated_227$1 = generated$1.ObjectTypeCallProperty;
	var generated_228$1 = generated$1.objectTypeCallProperty;
	var generated_229$1 = generated$1.ObjectTypeIndexer;
	var generated_230$1 = generated$1.objectTypeIndexer;
	var generated_231$1 = generated$1.ObjectTypeProperty;
	var generated_232$1 = generated$1.objectTypeProperty;
	var generated_233$1 = generated$1.ObjectTypeSpreadProperty;
	var generated_234$1 = generated$1.objectTypeSpreadProperty;
	var generated_235$1 = generated$1.OpaqueType;
	var generated_236$1 = generated$1.opaqueType;
	var generated_237$1 = generated$1.QualifiedTypeIdentifier;
	var generated_238$1 = generated$1.qualifiedTypeIdentifier;
	var generated_239$1 = generated$1.StringLiteralTypeAnnotation;
	var generated_240$1 = generated$1.stringLiteralTypeAnnotation;
	var generated_241$1 = generated$1.StringTypeAnnotation;
	var generated_242$1 = generated$1.stringTypeAnnotation;
	var generated_243$1 = generated$1.SymbolTypeAnnotation;
	var generated_244$1 = generated$1.symbolTypeAnnotation;
	var generated_245$1 = generated$1.ThisTypeAnnotation;
	var generated_246$1 = generated$1.thisTypeAnnotation;
	var generated_247$1 = generated$1.TupleTypeAnnotation;
	var generated_248$1 = generated$1.tupleTypeAnnotation;
	var generated_249$1 = generated$1.TypeofTypeAnnotation;
	var generated_250$1 = generated$1.typeofTypeAnnotation;
	var generated_251$1 = generated$1.TypeAlias;
	var generated_252$1 = generated$1.typeAlias;
	var generated_253$1 = generated$1.TypeAnnotation;
	var generated_254$1 = generated$1.typeAnnotation;
	var generated_255$1 = generated$1.TypeCastExpression;
	var generated_256$1 = generated$1.typeCastExpression;
	var generated_257$1 = generated$1.TypeParameter;
	var generated_258$1 = generated$1.typeParameter;
	var generated_259$1 = generated$1.TypeParameterDeclaration;
	var generated_260$1 = generated$1.typeParameterDeclaration;
	var generated_261$1 = generated$1.TypeParameterInstantiation;
	var generated_262$1 = generated$1.typeParameterInstantiation;
	var generated_263$1 = generated$1.UnionTypeAnnotation;
	var generated_264$1 = generated$1.unionTypeAnnotation;
	var generated_265$1 = generated$1.Variance;
	var generated_266$1 = generated$1.variance;
	var generated_267$1 = generated$1.VoidTypeAnnotation;
	var generated_268$1 = generated$1.voidTypeAnnotation;
	var generated_269$1 = generated$1.EnumDeclaration;
	var generated_270$1 = generated$1.enumDeclaration;
	var generated_271$1 = generated$1.EnumBooleanBody;
	var generated_272$1 = generated$1.enumBooleanBody;
	var generated_273$1 = generated$1.EnumNumberBody;
	var generated_274$1 = generated$1.enumNumberBody;
	var generated_275$1 = generated$1.EnumStringBody;
	var generated_276$1 = generated$1.enumStringBody;
	var generated_277$1 = generated$1.EnumSymbolBody;
	var generated_278$1 = generated$1.enumSymbolBody;
	var generated_279$1 = generated$1.EnumBooleanMember;
	var generated_280$1 = generated$1.enumBooleanMember;
	var generated_281$1 = generated$1.EnumNumberMember;
	var generated_282$1 = generated$1.enumNumberMember;
	var generated_283$1 = generated$1.EnumStringMember;
	var generated_284$1 = generated$1.enumStringMember;
	var generated_285$1 = generated$1.EnumDefaultedMember;
	var generated_286$1 = generated$1.enumDefaultedMember;
	var generated_287$1 = generated$1.jSXAttribute;
	var generated_288$1 = generated$1.JSXAttribute;
	var generated_289$1 = generated$1.jsxAttribute;
	var generated_290$1 = generated$1.jSXClosingElement;
	var generated_291$1 = generated$1.JSXClosingElement;
	var generated_292 = generated$1.jsxClosingElement;
	var generated_293 = generated$1.jSXElement;
	var generated_294 = generated$1.JSXElement;
	var generated_295 = generated$1.jsxElement;
	var generated_296 = generated$1.jSXEmptyExpression;
	var generated_297 = generated$1.JSXEmptyExpression;
	var generated_298 = generated$1.jsxEmptyExpression;
	var generated_299 = generated$1.jSXExpressionContainer;
	var generated_300 = generated$1.JSXExpressionContainer;
	var generated_301 = generated$1.jsxExpressionContainer;
	var generated_302 = generated$1.jSXSpreadChild;
	var generated_303 = generated$1.JSXSpreadChild;
	var generated_304 = generated$1.jsxSpreadChild;
	var generated_305 = generated$1.jSXIdentifier;
	var generated_306 = generated$1.JSXIdentifier;
	var generated_307 = generated$1.jsxIdentifier;
	var generated_308 = generated$1.jSXMemberExpression;
	var generated_309 = generated$1.JSXMemberExpression;
	var generated_310 = generated$1.jsxMemberExpression;
	var generated_311 = generated$1.jSXNamespacedName;
	var generated_312 = generated$1.JSXNamespacedName;
	var generated_313 = generated$1.jsxNamespacedName;
	var generated_314 = generated$1.jSXOpeningElement;
	var generated_315 = generated$1.JSXOpeningElement;
	var generated_316 = generated$1.jsxOpeningElement;
	var generated_317 = generated$1.jSXSpreadAttribute;
	var generated_318 = generated$1.JSXSpreadAttribute;
	var generated_319 = generated$1.jsxSpreadAttribute;
	var generated_320 = generated$1.jSXText;
	var generated_321 = generated$1.JSXText;
	var generated_322 = generated$1.jsxText;
	var generated_323 = generated$1.jSXFragment;
	var generated_324 = generated$1.JSXFragment;
	var generated_325 = generated$1.jsxFragment;
	var generated_326 = generated$1.jSXOpeningFragment;
	var generated_327 = generated$1.JSXOpeningFragment;
	var generated_328 = generated$1.jsxOpeningFragment;
	var generated_329 = generated$1.jSXClosingFragment;
	var generated_330 = generated$1.JSXClosingFragment;
	var generated_331 = generated$1.jsxClosingFragment;
	var generated_332 = generated$1.Noop;
	var generated_333 = generated$1.noop;
	var generated_334 = generated$1.Placeholder;
	var generated_335 = generated$1.placeholder;
	var generated_336 = generated$1.V8IntrinsicIdentifier;
	var generated_337 = generated$1.v8IntrinsicIdentifier;
	var generated_338 = generated$1.ArgumentPlaceholder;
	var generated_339 = generated$1.argumentPlaceholder;
	var generated_340 = generated$1.BindExpression;
	var generated_341 = generated$1.bindExpression;
	var generated_342 = generated$1.ClassProperty;
	var generated_343 = generated$1.classProperty;
	var generated_344 = generated$1.PipelineTopicExpression;
	var generated_345 = generated$1.pipelineTopicExpression;
	var generated_346 = generated$1.PipelineBareFunction;
	var generated_347 = generated$1.pipelineBareFunction;
	var generated_348 = generated$1.PipelinePrimaryTopicReference;
	var generated_349 = generated$1.pipelinePrimaryTopicReference;
	var generated_350 = generated$1.ClassPrivateProperty;
	var generated_351 = generated$1.classPrivateProperty;
	var generated_352 = generated$1.ClassPrivateMethod;
	var generated_353 = generated$1.classPrivateMethod;
	var generated_354 = generated$1.ImportAttribute;
	var generated_355 = generated$1.importAttribute;
	var generated_356 = generated$1.Decorator;
	var generated_357 = generated$1.decorator;
	var generated_358 = generated$1.DoExpression;
	var generated_359 = generated$1.doExpression;
	var generated_360 = generated$1.ExportDefaultSpecifier;
	var generated_361 = generated$1.exportDefaultSpecifier;
	var generated_362 = generated$1.PrivateName;
	var generated_363 = generated$1.privateName;
	var generated_364 = generated$1.RecordExpression;
	var generated_365 = generated$1.recordExpression;
	var generated_366 = generated$1.TupleExpression;
	var generated_367 = generated$1.tupleExpression;
	var generated_368 = generated$1.DecimalLiteral;
	var generated_369 = generated$1.decimalLiteral;
	var generated_370 = generated$1.StaticBlock;
	var generated_371 = generated$1.staticBlock;
	var generated_372 = generated$1.tSParameterProperty;
	var generated_373 = generated$1.TSParameterProperty;
	var generated_374 = generated$1.tsParameterProperty;
	var generated_375 = generated$1.tSDeclareFunction;
	var generated_376 = generated$1.TSDeclareFunction;
	var generated_377 = generated$1.tsDeclareFunction;
	var generated_378 = generated$1.tSDeclareMethod;
	var generated_379 = generated$1.TSDeclareMethod;
	var generated_380 = generated$1.tsDeclareMethod;
	var generated_381 = generated$1.tSQualifiedName;
	var generated_382 = generated$1.TSQualifiedName;
	var generated_383 = generated$1.tsQualifiedName;
	var generated_384 = generated$1.tSCallSignatureDeclaration;
	var generated_385 = generated$1.TSCallSignatureDeclaration;
	var generated_386 = generated$1.tsCallSignatureDeclaration;
	var generated_387 = generated$1.tSConstructSignatureDeclaration;
	var generated_388 = generated$1.TSConstructSignatureDeclaration;
	var generated_389 = generated$1.tsConstructSignatureDeclaration;
	var generated_390 = generated$1.tSPropertySignature;
	var generated_391 = generated$1.TSPropertySignature;
	var generated_392 = generated$1.tsPropertySignature;
	var generated_393 = generated$1.tSMethodSignature;
	var generated_394 = generated$1.TSMethodSignature;
	var generated_395 = generated$1.tsMethodSignature;
	var generated_396 = generated$1.tSIndexSignature;
	var generated_397 = generated$1.TSIndexSignature;
	var generated_398 = generated$1.tsIndexSignature;
	var generated_399 = generated$1.tSAnyKeyword;
	var generated_400 = generated$1.TSAnyKeyword;
	var generated_401 = generated$1.tsAnyKeyword;
	var generated_402 = generated$1.tSBooleanKeyword;
	var generated_403 = generated$1.TSBooleanKeyword;
	var generated_404 = generated$1.tsBooleanKeyword;
	var generated_405 = generated$1.tSBigIntKeyword;
	var generated_406 = generated$1.TSBigIntKeyword;
	var generated_407 = generated$1.tsBigIntKeyword;
	var generated_408 = generated$1.tSIntrinsicKeyword;
	var generated_409 = generated$1.TSIntrinsicKeyword;
	var generated_410 = generated$1.tsIntrinsicKeyword;
	var generated_411 = generated$1.tSNeverKeyword;
	var generated_412 = generated$1.TSNeverKeyword;
	var generated_413 = generated$1.tsNeverKeyword;
	var generated_414 = generated$1.tSNullKeyword;
	var generated_415 = generated$1.TSNullKeyword;
	var generated_416 = generated$1.tsNullKeyword;
	var generated_417 = generated$1.tSNumberKeyword;
	var generated_418 = generated$1.TSNumberKeyword;
	var generated_419 = generated$1.tsNumberKeyword;
	var generated_420 = generated$1.tSObjectKeyword;
	var generated_421 = generated$1.TSObjectKeyword;
	var generated_422 = generated$1.tsObjectKeyword;
	var generated_423 = generated$1.tSStringKeyword;
	var generated_424 = generated$1.TSStringKeyword;
	var generated_425 = generated$1.tsStringKeyword;
	var generated_426 = generated$1.tSSymbolKeyword;
	var generated_427 = generated$1.TSSymbolKeyword;
	var generated_428 = generated$1.tsSymbolKeyword;
	var generated_429 = generated$1.tSUndefinedKeyword;
	var generated_430 = generated$1.TSUndefinedKeyword;
	var generated_431 = generated$1.tsUndefinedKeyword;
	var generated_432 = generated$1.tSUnknownKeyword;
	var generated_433 = generated$1.TSUnknownKeyword;
	var generated_434 = generated$1.tsUnknownKeyword;
	var generated_435 = generated$1.tSVoidKeyword;
	var generated_436 = generated$1.TSVoidKeyword;
	var generated_437 = generated$1.tsVoidKeyword;
	var generated_438 = generated$1.tSThisType;
	var generated_439 = generated$1.TSThisType;
	var generated_440 = generated$1.tsThisType;
	var generated_441 = generated$1.tSFunctionType;
	var generated_442 = generated$1.TSFunctionType;
	var generated_443 = generated$1.tsFunctionType;
	var generated_444 = generated$1.tSConstructorType;
	var generated_445 = generated$1.TSConstructorType;
	var generated_446 = generated$1.tsConstructorType;
	var generated_447 = generated$1.tSTypeReference;
	var generated_448 = generated$1.TSTypeReference;
	var generated_449 = generated$1.tsTypeReference;
	var generated_450 = generated$1.tSTypePredicate;
	var generated_451 = generated$1.TSTypePredicate;
	var generated_452 = generated$1.tsTypePredicate;
	var generated_453 = generated$1.tSTypeQuery;
	var generated_454 = generated$1.TSTypeQuery;
	var generated_455 = generated$1.tsTypeQuery;
	var generated_456 = generated$1.tSTypeLiteral;
	var generated_457 = generated$1.TSTypeLiteral;
	var generated_458 = generated$1.tsTypeLiteral;
	var generated_459 = generated$1.tSArrayType;
	var generated_460 = generated$1.TSArrayType;
	var generated_461 = generated$1.tsArrayType;
	var generated_462 = generated$1.tSTupleType;
	var generated_463 = generated$1.TSTupleType;
	var generated_464 = generated$1.tsTupleType;
	var generated_465 = generated$1.tSOptionalType;
	var generated_466 = generated$1.TSOptionalType;
	var generated_467 = generated$1.tsOptionalType;
	var generated_468 = generated$1.tSRestType;
	var generated_469 = generated$1.TSRestType;
	var generated_470 = generated$1.tsRestType;
	var generated_471 = generated$1.tSNamedTupleMember;
	var generated_472 = generated$1.TSNamedTupleMember;
	var generated_473 = generated$1.tsNamedTupleMember;
	var generated_474 = generated$1.tSUnionType;
	var generated_475 = generated$1.TSUnionType;
	var generated_476 = generated$1.tsUnionType;
	var generated_477 = generated$1.tSIntersectionType;
	var generated_478 = generated$1.TSIntersectionType;
	var generated_479 = generated$1.tsIntersectionType;
	var generated_480 = generated$1.tSConditionalType;
	var generated_481 = generated$1.TSConditionalType;
	var generated_482 = generated$1.tsConditionalType;
	var generated_483 = generated$1.tSInferType;
	var generated_484 = generated$1.TSInferType;
	var generated_485 = generated$1.tsInferType;
	var generated_486 = generated$1.tSParenthesizedType;
	var generated_487 = generated$1.TSParenthesizedType;
	var generated_488 = generated$1.tsParenthesizedType;
	var generated_489 = generated$1.tSTypeOperator;
	var generated_490 = generated$1.TSTypeOperator;
	var generated_491 = generated$1.tsTypeOperator;
	var generated_492 = generated$1.tSIndexedAccessType;
	var generated_493 = generated$1.TSIndexedAccessType;
	var generated_494 = generated$1.tsIndexedAccessType;
	var generated_495 = generated$1.tSMappedType;
	var generated_496 = generated$1.TSMappedType;
	var generated_497 = generated$1.tsMappedType;
	var generated_498 = generated$1.tSLiteralType;
	var generated_499 = generated$1.TSLiteralType;
	var generated_500 = generated$1.tsLiteralType;
	var generated_501 = generated$1.tSExpressionWithTypeArguments;
	var generated_502 = generated$1.TSExpressionWithTypeArguments;
	var generated_503 = generated$1.tsExpressionWithTypeArguments;
	var generated_504 = generated$1.tSInterfaceDeclaration;
	var generated_505 = generated$1.TSInterfaceDeclaration;
	var generated_506 = generated$1.tsInterfaceDeclaration;
	var generated_507 = generated$1.tSInterfaceBody;
	var generated_508 = generated$1.TSInterfaceBody;
	var generated_509 = generated$1.tsInterfaceBody;
	var generated_510 = generated$1.tSTypeAliasDeclaration;
	var generated_511 = generated$1.TSTypeAliasDeclaration;
	var generated_512 = generated$1.tsTypeAliasDeclaration;
	var generated_513 = generated$1.tSAsExpression;
	var generated_514 = generated$1.TSAsExpression;
	var generated_515 = generated$1.tsAsExpression;
	var generated_516 = generated$1.tSTypeAssertion;
	var generated_517 = generated$1.TSTypeAssertion;
	var generated_518 = generated$1.tsTypeAssertion;
	var generated_519 = generated$1.tSEnumDeclaration;
	var generated_520 = generated$1.TSEnumDeclaration;
	var generated_521 = generated$1.tsEnumDeclaration;
	var generated_522 = generated$1.tSEnumMember;
	var generated_523 = generated$1.TSEnumMember;
	var generated_524 = generated$1.tsEnumMember;
	var generated_525 = generated$1.tSModuleDeclaration;
	var generated_526 = generated$1.TSModuleDeclaration;
	var generated_527 = generated$1.tsModuleDeclaration;
	var generated_528 = generated$1.tSModuleBlock;
	var generated_529 = generated$1.TSModuleBlock;
	var generated_530 = generated$1.tsModuleBlock;
	var generated_531 = generated$1.tSImportType;
	var generated_532 = generated$1.TSImportType;
	var generated_533 = generated$1.tsImportType;
	var generated_534 = generated$1.tSImportEqualsDeclaration;
	var generated_535 = generated$1.TSImportEqualsDeclaration;
	var generated_536 = generated$1.tsImportEqualsDeclaration;
	var generated_537 = generated$1.tSExternalModuleReference;
	var generated_538 = generated$1.TSExternalModuleReference;
	var generated_539 = generated$1.tsExternalModuleReference;
	var generated_540 = generated$1.tSNonNullExpression;
	var generated_541 = generated$1.TSNonNullExpression;
	var generated_542 = generated$1.tsNonNullExpression;
	var generated_543 = generated$1.tSExportAssignment;
	var generated_544 = generated$1.TSExportAssignment;
	var generated_545 = generated$1.tsExportAssignment;
	var generated_546 = generated$1.tSNamespaceExportDeclaration;
	var generated_547 = generated$1.TSNamespaceExportDeclaration;
	var generated_548 = generated$1.tsNamespaceExportDeclaration;
	var generated_549 = generated$1.tSTypeAnnotation;
	var generated_550 = generated$1.TSTypeAnnotation;
	var generated_551 = generated$1.tsTypeAnnotation;
	var generated_552 = generated$1.tSTypeParameterInstantiation;
	var generated_553 = generated$1.TSTypeParameterInstantiation;
	var generated_554 = generated$1.tsTypeParameterInstantiation;
	var generated_555 = generated$1.tSTypeParameterDeclaration;
	var generated_556 = generated$1.TSTypeParameterDeclaration;
	var generated_557 = generated$1.tsTypeParameterDeclaration;
	var generated_558 = generated$1.tSTypeParameter;
	var generated_559 = generated$1.TSTypeParameter;
	var generated_560 = generated$1.tsTypeParameter;
	var generated_561 = generated$1.numberLiteral;
	var generated_562 = generated$1.NumberLiteral;
	var generated_563 = generated$1.regexLiteral;
	var generated_564 = generated$1.RegexLiteral;
	var generated_565 = generated$1.restProperty;
	var generated_566 = generated$1.RestProperty;
	var generated_567 = generated$1.spreadProperty;
	var generated_568 = generated$1.SpreadProperty;

	var cleanJSXElementLiteralChild_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = cleanJSXElementLiteralChild;



	function cleanJSXElementLiteralChild(child, args) {
	  const lines = child.value.split(/\r\n|\n|\r/);
	  let lastNonEmptyLine = 0;

	  for (let i = 0; i < lines.length; i++) {
	    if (lines[i].match(/[^ \t]/)) {
	      lastNonEmptyLine = i;
	    }
	  }

	  let str = "";

	  for (let i = 0; i < lines.length; i++) {
	    const line = lines[i];
	    const isFirstLine = i === 0;
	    const isLastLine = i === lines.length - 1;
	    const isLastNonEmptyLine = i === lastNonEmptyLine;
	    let trimmedLine = line.replace(/\t/g, " ");

	    if (!isFirstLine) {
	      trimmedLine = trimmedLine.replace(/^[ ]+/, "");
	    }

	    if (!isLastLine) {
	      trimmedLine = trimmedLine.replace(/[ ]+$/, "");
	    }

	    if (trimmedLine) {
	      if (!isLastNonEmptyLine) {
	        trimmedLine += " ";
	      }

	      str += trimmedLine;
	    }
	  }

	  if (str) args.push((0, generated$1.stringLiteral)(str));
	}
	});

	unwrapExports(cleanJSXElementLiteralChild_1);

	var buildChildren_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = buildChildren;



	var _cleanJSXElementLiteralChild = _interopRequireDefault(cleanJSXElementLiteralChild_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function buildChildren(node) {
	  const elements = [];

	  for (let i = 0; i < node.children.length; i++) {
	    let child = node.children[i];

	    if ((0, generated.isJSXText)(child)) {
	      (0, _cleanJSXElementLiteralChild.default)(child, elements);
	      continue;
	    }

	    if ((0, generated.isJSXExpressionContainer)(child)) child = child.expression;
	    if ((0, generated.isJSXEmptyExpression)(child)) continue;
	    elements.push(child);
	  }

	  return elements;
	}
	});

	unwrapExports(buildChildren_1);

	var isNode_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isNode;



	function isNode(node) {
	  return !!(node && definitions.VISITOR_KEYS[node.type]);
	}
	});

	unwrapExports(isNode_1);

	var assertNode_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = assertNode;

	var _isNode = _interopRequireDefault(isNode_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function assertNode(node) {
	  if (!(0, _isNode.default)(node)) {
	    var _node$type;

	    const type = (_node$type = node == null ? void 0 : node.type) != null ? _node$type : JSON.stringify(node);
	    throw new TypeError(`Not a valid node of type "${type}"`);
	  }
	}
	});

	unwrapExports(assertNode_1);

	var generated$2 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.assertArrayExpression = assertArrayExpression;
	exports.assertAssignmentExpression = assertAssignmentExpression;
	exports.assertBinaryExpression = assertBinaryExpression;
	exports.assertInterpreterDirective = assertInterpreterDirective;
	exports.assertDirective = assertDirective;
	exports.assertDirectiveLiteral = assertDirectiveLiteral;
	exports.assertBlockStatement = assertBlockStatement;
	exports.assertBreakStatement = assertBreakStatement;
	exports.assertCallExpression = assertCallExpression;
	exports.assertCatchClause = assertCatchClause;
	exports.assertConditionalExpression = assertConditionalExpression;
	exports.assertContinueStatement = assertContinueStatement;
	exports.assertDebuggerStatement = assertDebuggerStatement;
	exports.assertDoWhileStatement = assertDoWhileStatement;
	exports.assertEmptyStatement = assertEmptyStatement;
	exports.assertExpressionStatement = assertExpressionStatement;
	exports.assertFile = assertFile;
	exports.assertForInStatement = assertForInStatement;
	exports.assertForStatement = assertForStatement;
	exports.assertFunctionDeclaration = assertFunctionDeclaration;
	exports.assertFunctionExpression = assertFunctionExpression;
	exports.assertIdentifier = assertIdentifier;
	exports.assertIfStatement = assertIfStatement;
	exports.assertLabeledStatement = assertLabeledStatement;
	exports.assertStringLiteral = assertStringLiteral;
	exports.assertNumericLiteral = assertNumericLiteral;
	exports.assertNullLiteral = assertNullLiteral;
	exports.assertBooleanLiteral = assertBooleanLiteral;
	exports.assertRegExpLiteral = assertRegExpLiteral;
	exports.assertLogicalExpression = assertLogicalExpression;
	exports.assertMemberExpression = assertMemberExpression;
	exports.assertNewExpression = assertNewExpression;
	exports.assertProgram = assertProgram;
	exports.assertObjectExpression = assertObjectExpression;
	exports.assertObjectMethod = assertObjectMethod;
	exports.assertObjectProperty = assertObjectProperty;
	exports.assertRestElement = assertRestElement;
	exports.assertReturnStatement = assertReturnStatement;
	exports.assertSequenceExpression = assertSequenceExpression;
	exports.assertParenthesizedExpression = assertParenthesizedExpression;
	exports.assertSwitchCase = assertSwitchCase;
	exports.assertSwitchStatement = assertSwitchStatement;
	exports.assertThisExpression = assertThisExpression;
	exports.assertThrowStatement = assertThrowStatement;
	exports.assertTryStatement = assertTryStatement;
	exports.assertUnaryExpression = assertUnaryExpression;
	exports.assertUpdateExpression = assertUpdateExpression;
	exports.assertVariableDeclaration = assertVariableDeclaration;
	exports.assertVariableDeclarator = assertVariableDeclarator;
	exports.assertWhileStatement = assertWhileStatement;
	exports.assertWithStatement = assertWithStatement;
	exports.assertAssignmentPattern = assertAssignmentPattern;
	exports.assertArrayPattern = assertArrayPattern;
	exports.assertArrowFunctionExpression = assertArrowFunctionExpression;
	exports.assertClassBody = assertClassBody;
	exports.assertClassExpression = assertClassExpression;
	exports.assertClassDeclaration = assertClassDeclaration;
	exports.assertExportAllDeclaration = assertExportAllDeclaration;
	exports.assertExportDefaultDeclaration = assertExportDefaultDeclaration;
	exports.assertExportNamedDeclaration = assertExportNamedDeclaration;
	exports.assertExportSpecifier = assertExportSpecifier;
	exports.assertForOfStatement = assertForOfStatement;
	exports.assertImportDeclaration = assertImportDeclaration;
	exports.assertImportDefaultSpecifier = assertImportDefaultSpecifier;
	exports.assertImportNamespaceSpecifier = assertImportNamespaceSpecifier;
	exports.assertImportSpecifier = assertImportSpecifier;
	exports.assertMetaProperty = assertMetaProperty;
	exports.assertClassMethod = assertClassMethod;
	exports.assertObjectPattern = assertObjectPattern;
	exports.assertSpreadElement = assertSpreadElement;
	exports.assertSuper = assertSuper;
	exports.assertTaggedTemplateExpression = assertTaggedTemplateExpression;
	exports.assertTemplateElement = assertTemplateElement;
	exports.assertTemplateLiteral = assertTemplateLiteral;
	exports.assertYieldExpression = assertYieldExpression;
	exports.assertAwaitExpression = assertAwaitExpression;
	exports.assertImport = assertImport;
	exports.assertBigIntLiteral = assertBigIntLiteral;
	exports.assertExportNamespaceSpecifier = assertExportNamespaceSpecifier;
	exports.assertOptionalMemberExpression = assertOptionalMemberExpression;
	exports.assertOptionalCallExpression = assertOptionalCallExpression;
	exports.assertAnyTypeAnnotation = assertAnyTypeAnnotation;
	exports.assertArrayTypeAnnotation = assertArrayTypeAnnotation;
	exports.assertBooleanTypeAnnotation = assertBooleanTypeAnnotation;
	exports.assertBooleanLiteralTypeAnnotation = assertBooleanLiteralTypeAnnotation;
	exports.assertNullLiteralTypeAnnotation = assertNullLiteralTypeAnnotation;
	exports.assertClassImplements = assertClassImplements;
	exports.assertDeclareClass = assertDeclareClass;
	exports.assertDeclareFunction = assertDeclareFunction;
	exports.assertDeclareInterface = assertDeclareInterface;
	exports.assertDeclareModule = assertDeclareModule;
	exports.assertDeclareModuleExports = assertDeclareModuleExports;
	exports.assertDeclareTypeAlias = assertDeclareTypeAlias;
	exports.assertDeclareOpaqueType = assertDeclareOpaqueType;
	exports.assertDeclareVariable = assertDeclareVariable;
	exports.assertDeclareExportDeclaration = assertDeclareExportDeclaration;
	exports.assertDeclareExportAllDeclaration = assertDeclareExportAllDeclaration;
	exports.assertDeclaredPredicate = assertDeclaredPredicate;
	exports.assertExistsTypeAnnotation = assertExistsTypeAnnotation;
	exports.assertFunctionTypeAnnotation = assertFunctionTypeAnnotation;
	exports.assertFunctionTypeParam = assertFunctionTypeParam;
	exports.assertGenericTypeAnnotation = assertGenericTypeAnnotation;
	exports.assertInferredPredicate = assertInferredPredicate;
	exports.assertInterfaceExtends = assertInterfaceExtends;
	exports.assertInterfaceDeclaration = assertInterfaceDeclaration;
	exports.assertInterfaceTypeAnnotation = assertInterfaceTypeAnnotation;
	exports.assertIntersectionTypeAnnotation = assertIntersectionTypeAnnotation;
	exports.assertMixedTypeAnnotation = assertMixedTypeAnnotation;
	exports.assertEmptyTypeAnnotation = assertEmptyTypeAnnotation;
	exports.assertNullableTypeAnnotation = assertNullableTypeAnnotation;
	exports.assertNumberLiteralTypeAnnotation = assertNumberLiteralTypeAnnotation;
	exports.assertNumberTypeAnnotation = assertNumberTypeAnnotation;
	exports.assertObjectTypeAnnotation = assertObjectTypeAnnotation;
	exports.assertObjectTypeInternalSlot = assertObjectTypeInternalSlot;
	exports.assertObjectTypeCallProperty = assertObjectTypeCallProperty;
	exports.assertObjectTypeIndexer = assertObjectTypeIndexer;
	exports.assertObjectTypeProperty = assertObjectTypeProperty;
	exports.assertObjectTypeSpreadProperty = assertObjectTypeSpreadProperty;
	exports.assertOpaqueType = assertOpaqueType;
	exports.assertQualifiedTypeIdentifier = assertQualifiedTypeIdentifier;
	exports.assertStringLiteralTypeAnnotation = assertStringLiteralTypeAnnotation;
	exports.assertStringTypeAnnotation = assertStringTypeAnnotation;
	exports.assertSymbolTypeAnnotation = assertSymbolTypeAnnotation;
	exports.assertThisTypeAnnotation = assertThisTypeAnnotation;
	exports.assertTupleTypeAnnotation = assertTupleTypeAnnotation;
	exports.assertTypeofTypeAnnotation = assertTypeofTypeAnnotation;
	exports.assertTypeAlias = assertTypeAlias;
	exports.assertTypeAnnotation = assertTypeAnnotation;
	exports.assertTypeCastExpression = assertTypeCastExpression;
	exports.assertTypeParameter = assertTypeParameter;
	exports.assertTypeParameterDeclaration = assertTypeParameterDeclaration;
	exports.assertTypeParameterInstantiation = assertTypeParameterInstantiation;
	exports.assertUnionTypeAnnotation = assertUnionTypeAnnotation;
	exports.assertVariance = assertVariance;
	exports.assertVoidTypeAnnotation = assertVoidTypeAnnotation;
	exports.assertEnumDeclaration = assertEnumDeclaration;
	exports.assertEnumBooleanBody = assertEnumBooleanBody;
	exports.assertEnumNumberBody = assertEnumNumberBody;
	exports.assertEnumStringBody = assertEnumStringBody;
	exports.assertEnumSymbolBody = assertEnumSymbolBody;
	exports.assertEnumBooleanMember = assertEnumBooleanMember;
	exports.assertEnumNumberMember = assertEnumNumberMember;
	exports.assertEnumStringMember = assertEnumStringMember;
	exports.assertEnumDefaultedMember = assertEnumDefaultedMember;
	exports.assertJSXAttribute = assertJSXAttribute;
	exports.assertJSXClosingElement = assertJSXClosingElement;
	exports.assertJSXElement = assertJSXElement;
	exports.assertJSXEmptyExpression = assertJSXEmptyExpression;
	exports.assertJSXExpressionContainer = assertJSXExpressionContainer;
	exports.assertJSXSpreadChild = assertJSXSpreadChild;
	exports.assertJSXIdentifier = assertJSXIdentifier;
	exports.assertJSXMemberExpression = assertJSXMemberExpression;
	exports.assertJSXNamespacedName = assertJSXNamespacedName;
	exports.assertJSXOpeningElement = assertJSXOpeningElement;
	exports.assertJSXSpreadAttribute = assertJSXSpreadAttribute;
	exports.assertJSXText = assertJSXText;
	exports.assertJSXFragment = assertJSXFragment;
	exports.assertJSXOpeningFragment = assertJSXOpeningFragment;
	exports.assertJSXClosingFragment = assertJSXClosingFragment;
	exports.assertNoop = assertNoop;
	exports.assertPlaceholder = assertPlaceholder;
	exports.assertV8IntrinsicIdentifier = assertV8IntrinsicIdentifier;
	exports.assertArgumentPlaceholder = assertArgumentPlaceholder;
	exports.assertBindExpression = assertBindExpression;
	exports.assertClassProperty = assertClassProperty;
	exports.assertPipelineTopicExpression = assertPipelineTopicExpression;
	exports.assertPipelineBareFunction = assertPipelineBareFunction;
	exports.assertPipelinePrimaryTopicReference = assertPipelinePrimaryTopicReference;
	exports.assertClassPrivateProperty = assertClassPrivateProperty;
	exports.assertClassPrivateMethod = assertClassPrivateMethod;
	exports.assertImportAttribute = assertImportAttribute;
	exports.assertDecorator = assertDecorator;
	exports.assertDoExpression = assertDoExpression;
	exports.assertExportDefaultSpecifier = assertExportDefaultSpecifier;
	exports.assertPrivateName = assertPrivateName;
	exports.assertRecordExpression = assertRecordExpression;
	exports.assertTupleExpression = assertTupleExpression;
	exports.assertDecimalLiteral = assertDecimalLiteral;
	exports.assertStaticBlock = assertStaticBlock;
	exports.assertTSParameterProperty = assertTSParameterProperty;
	exports.assertTSDeclareFunction = assertTSDeclareFunction;
	exports.assertTSDeclareMethod = assertTSDeclareMethod;
	exports.assertTSQualifiedName = assertTSQualifiedName;
	exports.assertTSCallSignatureDeclaration = assertTSCallSignatureDeclaration;
	exports.assertTSConstructSignatureDeclaration = assertTSConstructSignatureDeclaration;
	exports.assertTSPropertySignature = assertTSPropertySignature;
	exports.assertTSMethodSignature = assertTSMethodSignature;
	exports.assertTSIndexSignature = assertTSIndexSignature;
	exports.assertTSAnyKeyword = assertTSAnyKeyword;
	exports.assertTSBooleanKeyword = assertTSBooleanKeyword;
	exports.assertTSBigIntKeyword = assertTSBigIntKeyword;
	exports.assertTSIntrinsicKeyword = assertTSIntrinsicKeyword;
	exports.assertTSNeverKeyword = assertTSNeverKeyword;
	exports.assertTSNullKeyword = assertTSNullKeyword;
	exports.assertTSNumberKeyword = assertTSNumberKeyword;
	exports.assertTSObjectKeyword = assertTSObjectKeyword;
	exports.assertTSStringKeyword = assertTSStringKeyword;
	exports.assertTSSymbolKeyword = assertTSSymbolKeyword;
	exports.assertTSUndefinedKeyword = assertTSUndefinedKeyword;
	exports.assertTSUnknownKeyword = assertTSUnknownKeyword;
	exports.assertTSVoidKeyword = assertTSVoidKeyword;
	exports.assertTSThisType = assertTSThisType;
	exports.assertTSFunctionType = assertTSFunctionType;
	exports.assertTSConstructorType = assertTSConstructorType;
	exports.assertTSTypeReference = assertTSTypeReference;
	exports.assertTSTypePredicate = assertTSTypePredicate;
	exports.assertTSTypeQuery = assertTSTypeQuery;
	exports.assertTSTypeLiteral = assertTSTypeLiteral;
	exports.assertTSArrayType = assertTSArrayType;
	exports.assertTSTupleType = assertTSTupleType;
	exports.assertTSOptionalType = assertTSOptionalType;
	exports.assertTSRestType = assertTSRestType;
	exports.assertTSNamedTupleMember = assertTSNamedTupleMember;
	exports.assertTSUnionType = assertTSUnionType;
	exports.assertTSIntersectionType = assertTSIntersectionType;
	exports.assertTSConditionalType = assertTSConditionalType;
	exports.assertTSInferType = assertTSInferType;
	exports.assertTSParenthesizedType = assertTSParenthesizedType;
	exports.assertTSTypeOperator = assertTSTypeOperator;
	exports.assertTSIndexedAccessType = assertTSIndexedAccessType;
	exports.assertTSMappedType = assertTSMappedType;
	exports.assertTSLiteralType = assertTSLiteralType;
	exports.assertTSExpressionWithTypeArguments = assertTSExpressionWithTypeArguments;
	exports.assertTSInterfaceDeclaration = assertTSInterfaceDeclaration;
	exports.assertTSInterfaceBody = assertTSInterfaceBody;
	exports.assertTSTypeAliasDeclaration = assertTSTypeAliasDeclaration;
	exports.assertTSAsExpression = assertTSAsExpression;
	exports.assertTSTypeAssertion = assertTSTypeAssertion;
	exports.assertTSEnumDeclaration = assertTSEnumDeclaration;
	exports.assertTSEnumMember = assertTSEnumMember;
	exports.assertTSModuleDeclaration = assertTSModuleDeclaration;
	exports.assertTSModuleBlock = assertTSModuleBlock;
	exports.assertTSImportType = assertTSImportType;
	exports.assertTSImportEqualsDeclaration = assertTSImportEqualsDeclaration;
	exports.assertTSExternalModuleReference = assertTSExternalModuleReference;
	exports.assertTSNonNullExpression = assertTSNonNullExpression;
	exports.assertTSExportAssignment = assertTSExportAssignment;
	exports.assertTSNamespaceExportDeclaration = assertTSNamespaceExportDeclaration;
	exports.assertTSTypeAnnotation = assertTSTypeAnnotation;
	exports.assertTSTypeParameterInstantiation = assertTSTypeParameterInstantiation;
	exports.assertTSTypeParameterDeclaration = assertTSTypeParameterDeclaration;
	exports.assertTSTypeParameter = assertTSTypeParameter;
	exports.assertExpression = assertExpression;
	exports.assertBinary = assertBinary;
	exports.assertScopable = assertScopable;
	exports.assertBlockParent = assertBlockParent;
	exports.assertBlock = assertBlock;
	exports.assertStatement = assertStatement;
	exports.assertTerminatorless = assertTerminatorless;
	exports.assertCompletionStatement = assertCompletionStatement;
	exports.assertConditional = assertConditional;
	exports.assertLoop = assertLoop;
	exports.assertWhile = assertWhile;
	exports.assertExpressionWrapper = assertExpressionWrapper;
	exports.assertFor = assertFor;
	exports.assertForXStatement = assertForXStatement;
	exports.assertFunction = assertFunction;
	exports.assertFunctionParent = assertFunctionParent;
	exports.assertPureish = assertPureish;
	exports.assertDeclaration = assertDeclaration;
	exports.assertPatternLike = assertPatternLike;
	exports.assertLVal = assertLVal;
	exports.assertTSEntityName = assertTSEntityName;
	exports.assertLiteral = assertLiteral;
	exports.assertImmutable = assertImmutable;
	exports.assertUserWhitespacable = assertUserWhitespacable;
	exports.assertMethod = assertMethod;
	exports.assertObjectMember = assertObjectMember;
	exports.assertProperty = assertProperty;
	exports.assertUnaryLike = assertUnaryLike;
	exports.assertPattern = assertPattern;
	exports.assertClass = assertClass;
	exports.assertModuleDeclaration = assertModuleDeclaration;
	exports.assertExportDeclaration = assertExportDeclaration;
	exports.assertModuleSpecifier = assertModuleSpecifier;
	exports.assertFlow = assertFlow;
	exports.assertFlowType = assertFlowType;
	exports.assertFlowBaseAnnotation = assertFlowBaseAnnotation;
	exports.assertFlowDeclaration = assertFlowDeclaration;
	exports.assertFlowPredicate = assertFlowPredicate;
	exports.assertEnumBody = assertEnumBody;
	exports.assertEnumMember = assertEnumMember;
	exports.assertJSX = assertJSX;
	exports.assertPrivate = assertPrivate;
	exports.assertTSTypeElement = assertTSTypeElement;
	exports.assertTSType = assertTSType;
	exports.assertTSBaseType = assertTSBaseType;
	exports.assertNumberLiteral = assertNumberLiteral;
	exports.assertRegexLiteral = assertRegexLiteral;
	exports.assertRestProperty = assertRestProperty;
	exports.assertSpreadProperty = assertSpreadProperty;

	var _is = _interopRequireDefault(is_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function assert(type, node, opts) {
	  if (!(0, _is.default)(type, node, opts)) {
	    throw new Error(`Expected type "${type}" with option ${JSON.stringify(opts)}, ` + `but instead got "${node.type}".`);
	  }
	}

	function assertArrayExpression(node, opts = {}) {
	  assert("ArrayExpression", node, opts);
	}

	function assertAssignmentExpression(node, opts = {}) {
	  assert("AssignmentExpression", node, opts);
	}

	function assertBinaryExpression(node, opts = {}) {
	  assert("BinaryExpression", node, opts);
	}

	function assertInterpreterDirective(node, opts = {}) {
	  assert("InterpreterDirective", node, opts);
	}

	function assertDirective(node, opts = {}) {
	  assert("Directive", node, opts);
	}

	function assertDirectiveLiteral(node, opts = {}) {
	  assert("DirectiveLiteral", node, opts);
	}

	function assertBlockStatement(node, opts = {}) {
	  assert("BlockStatement", node, opts);
	}

	function assertBreakStatement(node, opts = {}) {
	  assert("BreakStatement", node, opts);
	}

	function assertCallExpression(node, opts = {}) {
	  assert("CallExpression", node, opts);
	}

	function assertCatchClause(node, opts = {}) {
	  assert("CatchClause", node, opts);
	}

	function assertConditionalExpression(node, opts = {}) {
	  assert("ConditionalExpression", node, opts);
	}

	function assertContinueStatement(node, opts = {}) {
	  assert("ContinueStatement", node, opts);
	}

	function assertDebuggerStatement(node, opts = {}) {
	  assert("DebuggerStatement", node, opts);
	}

	function assertDoWhileStatement(node, opts = {}) {
	  assert("DoWhileStatement", node, opts);
	}

	function assertEmptyStatement(node, opts = {}) {
	  assert("EmptyStatement", node, opts);
	}

	function assertExpressionStatement(node, opts = {}) {
	  assert("ExpressionStatement", node, opts);
	}

	function assertFile(node, opts = {}) {
	  assert("File", node, opts);
	}

	function assertForInStatement(node, opts = {}) {
	  assert("ForInStatement", node, opts);
	}

	function assertForStatement(node, opts = {}) {
	  assert("ForStatement", node, opts);
	}

	function assertFunctionDeclaration(node, opts = {}) {
	  assert("FunctionDeclaration", node, opts);
	}

	function assertFunctionExpression(node, opts = {}) {
	  assert("FunctionExpression", node, opts);
	}

	function assertIdentifier(node, opts = {}) {
	  assert("Identifier", node, opts);
	}

	function assertIfStatement(node, opts = {}) {
	  assert("IfStatement", node, opts);
	}

	function assertLabeledStatement(node, opts = {}) {
	  assert("LabeledStatement", node, opts);
	}

	function assertStringLiteral(node, opts = {}) {
	  assert("StringLiteral", node, opts);
	}

	function assertNumericLiteral(node, opts = {}) {
	  assert("NumericLiteral", node, opts);
	}

	function assertNullLiteral(node, opts = {}) {
	  assert("NullLiteral", node, opts);
	}

	function assertBooleanLiteral(node, opts = {}) {
	  assert("BooleanLiteral", node, opts);
	}

	function assertRegExpLiteral(node, opts = {}) {
	  assert("RegExpLiteral", node, opts);
	}

	function assertLogicalExpression(node, opts = {}) {
	  assert("LogicalExpression", node, opts);
	}

	function assertMemberExpression(node, opts = {}) {
	  assert("MemberExpression", node, opts);
	}

	function assertNewExpression(node, opts = {}) {
	  assert("NewExpression", node, opts);
	}

	function assertProgram(node, opts = {}) {
	  assert("Program", node, opts);
	}

	function assertObjectExpression(node, opts = {}) {
	  assert("ObjectExpression", node, opts);
	}

	function assertObjectMethod(node, opts = {}) {
	  assert("ObjectMethod", node, opts);
	}

	function assertObjectProperty(node, opts = {}) {
	  assert("ObjectProperty", node, opts);
	}

	function assertRestElement(node, opts = {}) {
	  assert("RestElement", node, opts);
	}

	function assertReturnStatement(node, opts = {}) {
	  assert("ReturnStatement", node, opts);
	}

	function assertSequenceExpression(node, opts = {}) {
	  assert("SequenceExpression", node, opts);
	}

	function assertParenthesizedExpression(node, opts = {}) {
	  assert("ParenthesizedExpression", node, opts);
	}

	function assertSwitchCase(node, opts = {}) {
	  assert("SwitchCase", node, opts);
	}

	function assertSwitchStatement(node, opts = {}) {
	  assert("SwitchStatement", node, opts);
	}

	function assertThisExpression(node, opts = {}) {
	  assert("ThisExpression", node, opts);
	}

	function assertThrowStatement(node, opts = {}) {
	  assert("ThrowStatement", node, opts);
	}

	function assertTryStatement(node, opts = {}) {
	  assert("TryStatement", node, opts);
	}

	function assertUnaryExpression(node, opts = {}) {
	  assert("UnaryExpression", node, opts);
	}

	function assertUpdateExpression(node, opts = {}) {
	  assert("UpdateExpression", node, opts);
	}

	function assertVariableDeclaration(node, opts = {}) {
	  assert("VariableDeclaration", node, opts);
	}

	function assertVariableDeclarator(node, opts = {}) {
	  assert("VariableDeclarator", node, opts);
	}

	function assertWhileStatement(node, opts = {}) {
	  assert("WhileStatement", node, opts);
	}

	function assertWithStatement(node, opts = {}) {
	  assert("WithStatement", node, opts);
	}

	function assertAssignmentPattern(node, opts = {}) {
	  assert("AssignmentPattern", node, opts);
	}

	function assertArrayPattern(node, opts = {}) {
	  assert("ArrayPattern", node, opts);
	}

	function assertArrowFunctionExpression(node, opts = {}) {
	  assert("ArrowFunctionExpression", node, opts);
	}

	function assertClassBody(node, opts = {}) {
	  assert("ClassBody", node, opts);
	}

	function assertClassExpression(node, opts = {}) {
	  assert("ClassExpression", node, opts);
	}

	function assertClassDeclaration(node, opts = {}) {
	  assert("ClassDeclaration", node, opts);
	}

	function assertExportAllDeclaration(node, opts = {}) {
	  assert("ExportAllDeclaration", node, opts);
	}

	function assertExportDefaultDeclaration(node, opts = {}) {
	  assert("ExportDefaultDeclaration", node, opts);
	}

	function assertExportNamedDeclaration(node, opts = {}) {
	  assert("ExportNamedDeclaration", node, opts);
	}

	function assertExportSpecifier(node, opts = {}) {
	  assert("ExportSpecifier", node, opts);
	}

	function assertForOfStatement(node, opts = {}) {
	  assert("ForOfStatement", node, opts);
	}

	function assertImportDeclaration(node, opts = {}) {
	  assert("ImportDeclaration", node, opts);
	}

	function assertImportDefaultSpecifier(node, opts = {}) {
	  assert("ImportDefaultSpecifier", node, opts);
	}

	function assertImportNamespaceSpecifier(node, opts = {}) {
	  assert("ImportNamespaceSpecifier", node, opts);
	}

	function assertImportSpecifier(node, opts = {}) {
	  assert("ImportSpecifier", node, opts);
	}

	function assertMetaProperty(node, opts = {}) {
	  assert("MetaProperty", node, opts);
	}

	function assertClassMethod(node, opts = {}) {
	  assert("ClassMethod", node, opts);
	}

	function assertObjectPattern(node, opts = {}) {
	  assert("ObjectPattern", node, opts);
	}

	function assertSpreadElement(node, opts = {}) {
	  assert("SpreadElement", node, opts);
	}

	function assertSuper(node, opts = {}) {
	  assert("Super", node, opts);
	}

	function assertTaggedTemplateExpression(node, opts = {}) {
	  assert("TaggedTemplateExpression", node, opts);
	}

	function assertTemplateElement(node, opts = {}) {
	  assert("TemplateElement", node, opts);
	}

	function assertTemplateLiteral(node, opts = {}) {
	  assert("TemplateLiteral", node, opts);
	}

	function assertYieldExpression(node, opts = {}) {
	  assert("YieldExpression", node, opts);
	}

	function assertAwaitExpression(node, opts = {}) {
	  assert("AwaitExpression", node, opts);
	}

	function assertImport(node, opts = {}) {
	  assert("Import", node, opts);
	}

	function assertBigIntLiteral(node, opts = {}) {
	  assert("BigIntLiteral", node, opts);
	}

	function assertExportNamespaceSpecifier(node, opts = {}) {
	  assert("ExportNamespaceSpecifier", node, opts);
	}

	function assertOptionalMemberExpression(node, opts = {}) {
	  assert("OptionalMemberExpression", node, opts);
	}

	function assertOptionalCallExpression(node, opts = {}) {
	  assert("OptionalCallExpression", node, opts);
	}

	function assertAnyTypeAnnotation(node, opts = {}) {
	  assert("AnyTypeAnnotation", node, opts);
	}

	function assertArrayTypeAnnotation(node, opts = {}) {
	  assert("ArrayTypeAnnotation", node, opts);
	}

	function assertBooleanTypeAnnotation(node, opts = {}) {
	  assert("BooleanTypeAnnotation", node, opts);
	}

	function assertBooleanLiteralTypeAnnotation(node, opts = {}) {
	  assert("BooleanLiteralTypeAnnotation", node, opts);
	}

	function assertNullLiteralTypeAnnotation(node, opts = {}) {
	  assert("NullLiteralTypeAnnotation", node, opts);
	}

	function assertClassImplements(node, opts = {}) {
	  assert("ClassImplements", node, opts);
	}

	function assertDeclareClass(node, opts = {}) {
	  assert("DeclareClass", node, opts);
	}

	function assertDeclareFunction(node, opts = {}) {
	  assert("DeclareFunction", node, opts);
	}

	function assertDeclareInterface(node, opts = {}) {
	  assert("DeclareInterface", node, opts);
	}

	function assertDeclareModule(node, opts = {}) {
	  assert("DeclareModule", node, opts);
	}

	function assertDeclareModuleExports(node, opts = {}) {
	  assert("DeclareModuleExports", node, opts);
	}

	function assertDeclareTypeAlias(node, opts = {}) {
	  assert("DeclareTypeAlias", node, opts);
	}

	function assertDeclareOpaqueType(node, opts = {}) {
	  assert("DeclareOpaqueType", node, opts);
	}

	function assertDeclareVariable(node, opts = {}) {
	  assert("DeclareVariable", node, opts);
	}

	function assertDeclareExportDeclaration(node, opts = {}) {
	  assert("DeclareExportDeclaration", node, opts);
	}

	function assertDeclareExportAllDeclaration(node, opts = {}) {
	  assert("DeclareExportAllDeclaration", node, opts);
	}

	function assertDeclaredPredicate(node, opts = {}) {
	  assert("DeclaredPredicate", node, opts);
	}

	function assertExistsTypeAnnotation(node, opts = {}) {
	  assert("ExistsTypeAnnotation", node, opts);
	}

	function assertFunctionTypeAnnotation(node, opts = {}) {
	  assert("FunctionTypeAnnotation", node, opts);
	}

	function assertFunctionTypeParam(node, opts = {}) {
	  assert("FunctionTypeParam", node, opts);
	}

	function assertGenericTypeAnnotation(node, opts = {}) {
	  assert("GenericTypeAnnotation", node, opts);
	}

	function assertInferredPredicate(node, opts = {}) {
	  assert("InferredPredicate", node, opts);
	}

	function assertInterfaceExtends(node, opts = {}) {
	  assert("InterfaceExtends", node, opts);
	}

	function assertInterfaceDeclaration(node, opts = {}) {
	  assert("InterfaceDeclaration", node, opts);
	}

	function assertInterfaceTypeAnnotation(node, opts = {}) {
	  assert("InterfaceTypeAnnotation", node, opts);
	}

	function assertIntersectionTypeAnnotation(node, opts = {}) {
	  assert("IntersectionTypeAnnotation", node, opts);
	}

	function assertMixedTypeAnnotation(node, opts = {}) {
	  assert("MixedTypeAnnotation", node, opts);
	}

	function assertEmptyTypeAnnotation(node, opts = {}) {
	  assert("EmptyTypeAnnotation", node, opts);
	}

	function assertNullableTypeAnnotation(node, opts = {}) {
	  assert("NullableTypeAnnotation", node, opts);
	}

	function assertNumberLiteralTypeAnnotation(node, opts = {}) {
	  assert("NumberLiteralTypeAnnotation", node, opts);
	}

	function assertNumberTypeAnnotation(node, opts = {}) {
	  assert("NumberTypeAnnotation", node, opts);
	}

	function assertObjectTypeAnnotation(node, opts = {}) {
	  assert("ObjectTypeAnnotation", node, opts);
	}

	function assertObjectTypeInternalSlot(node, opts = {}) {
	  assert("ObjectTypeInternalSlot", node, opts);
	}

	function assertObjectTypeCallProperty(node, opts = {}) {
	  assert("ObjectTypeCallProperty", node, opts);
	}

	function assertObjectTypeIndexer(node, opts = {}) {
	  assert("ObjectTypeIndexer", node, opts);
	}

	function assertObjectTypeProperty(node, opts = {}) {
	  assert("ObjectTypeProperty", node, opts);
	}

	function assertObjectTypeSpreadProperty(node, opts = {}) {
	  assert("ObjectTypeSpreadProperty", node, opts);
	}

	function assertOpaqueType(node, opts = {}) {
	  assert("OpaqueType", node, opts);
	}

	function assertQualifiedTypeIdentifier(node, opts = {}) {
	  assert("QualifiedTypeIdentifier", node, opts);
	}

	function assertStringLiteralTypeAnnotation(node, opts = {}) {
	  assert("StringLiteralTypeAnnotation", node, opts);
	}

	function assertStringTypeAnnotation(node, opts = {}) {
	  assert("StringTypeAnnotation", node, opts);
	}

	function assertSymbolTypeAnnotation(node, opts = {}) {
	  assert("SymbolTypeAnnotation", node, opts);
	}

	function assertThisTypeAnnotation(node, opts = {}) {
	  assert("ThisTypeAnnotation", node, opts);
	}

	function assertTupleTypeAnnotation(node, opts = {}) {
	  assert("TupleTypeAnnotation", node, opts);
	}

	function assertTypeofTypeAnnotation(node, opts = {}) {
	  assert("TypeofTypeAnnotation", node, opts);
	}

	function assertTypeAlias(node, opts = {}) {
	  assert("TypeAlias", node, opts);
	}

	function assertTypeAnnotation(node, opts = {}) {
	  assert("TypeAnnotation", node, opts);
	}

	function assertTypeCastExpression(node, opts = {}) {
	  assert("TypeCastExpression", node, opts);
	}

	function assertTypeParameter(node, opts = {}) {
	  assert("TypeParameter", node, opts);
	}

	function assertTypeParameterDeclaration(node, opts = {}) {
	  assert("TypeParameterDeclaration", node, opts);
	}

	function assertTypeParameterInstantiation(node, opts = {}) {
	  assert("TypeParameterInstantiation", node, opts);
	}

	function assertUnionTypeAnnotation(node, opts = {}) {
	  assert("UnionTypeAnnotation", node, opts);
	}

	function assertVariance(node, opts = {}) {
	  assert("Variance", node, opts);
	}

	function assertVoidTypeAnnotation(node, opts = {}) {
	  assert("VoidTypeAnnotation", node, opts);
	}

	function assertEnumDeclaration(node, opts = {}) {
	  assert("EnumDeclaration", node, opts);
	}

	function assertEnumBooleanBody(node, opts = {}) {
	  assert("EnumBooleanBody", node, opts);
	}

	function assertEnumNumberBody(node, opts = {}) {
	  assert("EnumNumberBody", node, opts);
	}

	function assertEnumStringBody(node, opts = {}) {
	  assert("EnumStringBody", node, opts);
	}

	function assertEnumSymbolBody(node, opts = {}) {
	  assert("EnumSymbolBody", node, opts);
	}

	function assertEnumBooleanMember(node, opts = {}) {
	  assert("EnumBooleanMember", node, opts);
	}

	function assertEnumNumberMember(node, opts = {}) {
	  assert("EnumNumberMember", node, opts);
	}

	function assertEnumStringMember(node, opts = {}) {
	  assert("EnumStringMember", node, opts);
	}

	function assertEnumDefaultedMember(node, opts = {}) {
	  assert("EnumDefaultedMember", node, opts);
	}

	function assertJSXAttribute(node, opts = {}) {
	  assert("JSXAttribute", node, opts);
	}

	function assertJSXClosingElement(node, opts = {}) {
	  assert("JSXClosingElement", node, opts);
	}

	function assertJSXElement(node, opts = {}) {
	  assert("JSXElement", node, opts);
	}

	function assertJSXEmptyExpression(node, opts = {}) {
	  assert("JSXEmptyExpression", node, opts);
	}

	function assertJSXExpressionContainer(node, opts = {}) {
	  assert("JSXExpressionContainer", node, opts);
	}

	function assertJSXSpreadChild(node, opts = {}) {
	  assert("JSXSpreadChild", node, opts);
	}

	function assertJSXIdentifier(node, opts = {}) {
	  assert("JSXIdentifier", node, opts);
	}

	function assertJSXMemberExpression(node, opts = {}) {
	  assert("JSXMemberExpression", node, opts);
	}

	function assertJSXNamespacedName(node, opts = {}) {
	  assert("JSXNamespacedName", node, opts);
	}

	function assertJSXOpeningElement(node, opts = {}) {
	  assert("JSXOpeningElement", node, opts);
	}

	function assertJSXSpreadAttribute(node, opts = {}) {
	  assert("JSXSpreadAttribute", node, opts);
	}

	function assertJSXText(node, opts = {}) {
	  assert("JSXText", node, opts);
	}

	function assertJSXFragment(node, opts = {}) {
	  assert("JSXFragment", node, opts);
	}

	function assertJSXOpeningFragment(node, opts = {}) {
	  assert("JSXOpeningFragment", node, opts);
	}

	function assertJSXClosingFragment(node, opts = {}) {
	  assert("JSXClosingFragment", node, opts);
	}

	function assertNoop(node, opts = {}) {
	  assert("Noop", node, opts);
	}

	function assertPlaceholder(node, opts = {}) {
	  assert("Placeholder", node, opts);
	}

	function assertV8IntrinsicIdentifier(node, opts = {}) {
	  assert("V8IntrinsicIdentifier", node, opts);
	}

	function assertArgumentPlaceholder(node, opts = {}) {
	  assert("ArgumentPlaceholder", node, opts);
	}

	function assertBindExpression(node, opts = {}) {
	  assert("BindExpression", node, opts);
	}

	function assertClassProperty(node, opts = {}) {
	  assert("ClassProperty", node, opts);
	}

	function assertPipelineTopicExpression(node, opts = {}) {
	  assert("PipelineTopicExpression", node, opts);
	}

	function assertPipelineBareFunction(node, opts = {}) {
	  assert("PipelineBareFunction", node, opts);
	}

	function assertPipelinePrimaryTopicReference(node, opts = {}) {
	  assert("PipelinePrimaryTopicReference", node, opts);
	}

	function assertClassPrivateProperty(node, opts = {}) {
	  assert("ClassPrivateProperty", node, opts);
	}

	function assertClassPrivateMethod(node, opts = {}) {
	  assert("ClassPrivateMethod", node, opts);
	}

	function assertImportAttribute(node, opts = {}) {
	  assert("ImportAttribute", node, opts);
	}

	function assertDecorator(node, opts = {}) {
	  assert("Decorator", node, opts);
	}

	function assertDoExpression(node, opts = {}) {
	  assert("DoExpression", node, opts);
	}

	function assertExportDefaultSpecifier(node, opts = {}) {
	  assert("ExportDefaultSpecifier", node, opts);
	}

	function assertPrivateName(node, opts = {}) {
	  assert("PrivateName", node, opts);
	}

	function assertRecordExpression(node, opts = {}) {
	  assert("RecordExpression", node, opts);
	}

	function assertTupleExpression(node, opts = {}) {
	  assert("TupleExpression", node, opts);
	}

	function assertDecimalLiteral(node, opts = {}) {
	  assert("DecimalLiteral", node, opts);
	}

	function assertStaticBlock(node, opts = {}) {
	  assert("StaticBlock", node, opts);
	}

	function assertTSParameterProperty(node, opts = {}) {
	  assert("TSParameterProperty", node, opts);
	}

	function assertTSDeclareFunction(node, opts = {}) {
	  assert("TSDeclareFunction", node, opts);
	}

	function assertTSDeclareMethod(node, opts = {}) {
	  assert("TSDeclareMethod", node, opts);
	}

	function assertTSQualifiedName(node, opts = {}) {
	  assert("TSQualifiedName", node, opts);
	}

	function assertTSCallSignatureDeclaration(node, opts = {}) {
	  assert("TSCallSignatureDeclaration", node, opts);
	}

	function assertTSConstructSignatureDeclaration(node, opts = {}) {
	  assert("TSConstructSignatureDeclaration", node, opts);
	}

	function assertTSPropertySignature(node, opts = {}) {
	  assert("TSPropertySignature", node, opts);
	}

	function assertTSMethodSignature(node, opts = {}) {
	  assert("TSMethodSignature", node, opts);
	}

	function assertTSIndexSignature(node, opts = {}) {
	  assert("TSIndexSignature", node, opts);
	}

	function assertTSAnyKeyword(node, opts = {}) {
	  assert("TSAnyKeyword", node, opts);
	}

	function assertTSBooleanKeyword(node, opts = {}) {
	  assert("TSBooleanKeyword", node, opts);
	}

	function assertTSBigIntKeyword(node, opts = {}) {
	  assert("TSBigIntKeyword", node, opts);
	}

	function assertTSIntrinsicKeyword(node, opts = {}) {
	  assert("TSIntrinsicKeyword", node, opts);
	}

	function assertTSNeverKeyword(node, opts = {}) {
	  assert("TSNeverKeyword", node, opts);
	}

	function assertTSNullKeyword(node, opts = {}) {
	  assert("TSNullKeyword", node, opts);
	}

	function assertTSNumberKeyword(node, opts = {}) {
	  assert("TSNumberKeyword", node, opts);
	}

	function assertTSObjectKeyword(node, opts = {}) {
	  assert("TSObjectKeyword", node, opts);
	}

	function assertTSStringKeyword(node, opts = {}) {
	  assert("TSStringKeyword", node, opts);
	}

	function assertTSSymbolKeyword(node, opts = {}) {
	  assert("TSSymbolKeyword", node, opts);
	}

	function assertTSUndefinedKeyword(node, opts = {}) {
	  assert("TSUndefinedKeyword", node, opts);
	}

	function assertTSUnknownKeyword(node, opts = {}) {
	  assert("TSUnknownKeyword", node, opts);
	}

	function assertTSVoidKeyword(node, opts = {}) {
	  assert("TSVoidKeyword", node, opts);
	}

	function assertTSThisType(node, opts = {}) {
	  assert("TSThisType", node, opts);
	}

	function assertTSFunctionType(node, opts = {}) {
	  assert("TSFunctionType", node, opts);
	}

	function assertTSConstructorType(node, opts = {}) {
	  assert("TSConstructorType", node, opts);
	}

	function assertTSTypeReference(node, opts = {}) {
	  assert("TSTypeReference", node, opts);
	}

	function assertTSTypePredicate(node, opts = {}) {
	  assert("TSTypePredicate", node, opts);
	}

	function assertTSTypeQuery(node, opts = {}) {
	  assert("TSTypeQuery", node, opts);
	}

	function assertTSTypeLiteral(node, opts = {}) {
	  assert("TSTypeLiteral", node, opts);
	}

	function assertTSArrayType(node, opts = {}) {
	  assert("TSArrayType", node, opts);
	}

	function assertTSTupleType(node, opts = {}) {
	  assert("TSTupleType", node, opts);
	}

	function assertTSOptionalType(node, opts = {}) {
	  assert("TSOptionalType", node, opts);
	}

	function assertTSRestType(node, opts = {}) {
	  assert("TSRestType", node, opts);
	}

	function assertTSNamedTupleMember(node, opts = {}) {
	  assert("TSNamedTupleMember", node, opts);
	}

	function assertTSUnionType(node, opts = {}) {
	  assert("TSUnionType", node, opts);
	}

	function assertTSIntersectionType(node, opts = {}) {
	  assert("TSIntersectionType", node, opts);
	}

	function assertTSConditionalType(node, opts = {}) {
	  assert("TSConditionalType", node, opts);
	}

	function assertTSInferType(node, opts = {}) {
	  assert("TSInferType", node, opts);
	}

	function assertTSParenthesizedType(node, opts = {}) {
	  assert("TSParenthesizedType", node, opts);
	}

	function assertTSTypeOperator(node, opts = {}) {
	  assert("TSTypeOperator", node, opts);
	}

	function assertTSIndexedAccessType(node, opts = {}) {
	  assert("TSIndexedAccessType", node, opts);
	}

	function assertTSMappedType(node, opts = {}) {
	  assert("TSMappedType", node, opts);
	}

	function assertTSLiteralType(node, opts = {}) {
	  assert("TSLiteralType", node, opts);
	}

	function assertTSExpressionWithTypeArguments(node, opts = {}) {
	  assert("TSExpressionWithTypeArguments", node, opts);
	}

	function assertTSInterfaceDeclaration(node, opts = {}) {
	  assert("TSInterfaceDeclaration", node, opts);
	}

	function assertTSInterfaceBody(node, opts = {}) {
	  assert("TSInterfaceBody", node, opts);
	}

	function assertTSTypeAliasDeclaration(node, opts = {}) {
	  assert("TSTypeAliasDeclaration", node, opts);
	}

	function assertTSAsExpression(node, opts = {}) {
	  assert("TSAsExpression", node, opts);
	}

	function assertTSTypeAssertion(node, opts = {}) {
	  assert("TSTypeAssertion", node, opts);
	}

	function assertTSEnumDeclaration(node, opts = {}) {
	  assert("TSEnumDeclaration", node, opts);
	}

	function assertTSEnumMember(node, opts = {}) {
	  assert("TSEnumMember", node, opts);
	}

	function assertTSModuleDeclaration(node, opts = {}) {
	  assert("TSModuleDeclaration", node, opts);
	}

	function assertTSModuleBlock(node, opts = {}) {
	  assert("TSModuleBlock", node, opts);
	}

	function assertTSImportType(node, opts = {}) {
	  assert("TSImportType", node, opts);
	}

	function assertTSImportEqualsDeclaration(node, opts = {}) {
	  assert("TSImportEqualsDeclaration", node, opts);
	}

	function assertTSExternalModuleReference(node, opts = {}) {
	  assert("TSExternalModuleReference", node, opts);
	}

	function assertTSNonNullExpression(node, opts = {}) {
	  assert("TSNonNullExpression", node, opts);
	}

	function assertTSExportAssignment(node, opts = {}) {
	  assert("TSExportAssignment", node, opts);
	}

	function assertTSNamespaceExportDeclaration(node, opts = {}) {
	  assert("TSNamespaceExportDeclaration", node, opts);
	}

	function assertTSTypeAnnotation(node, opts = {}) {
	  assert("TSTypeAnnotation", node, opts);
	}

	function assertTSTypeParameterInstantiation(node, opts = {}) {
	  assert("TSTypeParameterInstantiation", node, opts);
	}

	function assertTSTypeParameterDeclaration(node, opts = {}) {
	  assert("TSTypeParameterDeclaration", node, opts);
	}

	function assertTSTypeParameter(node, opts = {}) {
	  assert("TSTypeParameter", node, opts);
	}

	function assertExpression(node, opts = {}) {
	  assert("Expression", node, opts);
	}

	function assertBinary(node, opts = {}) {
	  assert("Binary", node, opts);
	}

	function assertScopable(node, opts = {}) {
	  assert("Scopable", node, opts);
	}

	function assertBlockParent(node, opts = {}) {
	  assert("BlockParent", node, opts);
	}

	function assertBlock(node, opts = {}) {
	  assert("Block", node, opts);
	}

	function assertStatement(node, opts = {}) {
	  assert("Statement", node, opts);
	}

	function assertTerminatorless(node, opts = {}) {
	  assert("Terminatorless", node, opts);
	}

	function assertCompletionStatement(node, opts = {}) {
	  assert("CompletionStatement", node, opts);
	}

	function assertConditional(node, opts = {}) {
	  assert("Conditional", node, opts);
	}

	function assertLoop(node, opts = {}) {
	  assert("Loop", node, opts);
	}

	function assertWhile(node, opts = {}) {
	  assert("While", node, opts);
	}

	function assertExpressionWrapper(node, opts = {}) {
	  assert("ExpressionWrapper", node, opts);
	}

	function assertFor(node, opts = {}) {
	  assert("For", node, opts);
	}

	function assertForXStatement(node, opts = {}) {
	  assert("ForXStatement", node, opts);
	}

	function assertFunction(node, opts = {}) {
	  assert("Function", node, opts);
	}

	function assertFunctionParent(node, opts = {}) {
	  assert("FunctionParent", node, opts);
	}

	function assertPureish(node, opts = {}) {
	  assert("Pureish", node, opts);
	}

	function assertDeclaration(node, opts = {}) {
	  assert("Declaration", node, opts);
	}

	function assertPatternLike(node, opts = {}) {
	  assert("PatternLike", node, opts);
	}

	function assertLVal(node, opts = {}) {
	  assert("LVal", node, opts);
	}

	function assertTSEntityName(node, opts = {}) {
	  assert("TSEntityName", node, opts);
	}

	function assertLiteral(node, opts = {}) {
	  assert("Literal", node, opts);
	}

	function assertImmutable(node, opts = {}) {
	  assert("Immutable", node, opts);
	}

	function assertUserWhitespacable(node, opts = {}) {
	  assert("UserWhitespacable", node, opts);
	}

	function assertMethod(node, opts = {}) {
	  assert("Method", node, opts);
	}

	function assertObjectMember(node, opts = {}) {
	  assert("ObjectMember", node, opts);
	}

	function assertProperty(node, opts = {}) {
	  assert("Property", node, opts);
	}

	function assertUnaryLike(node, opts = {}) {
	  assert("UnaryLike", node, opts);
	}

	function assertPattern(node, opts = {}) {
	  assert("Pattern", node, opts);
	}

	function assertClass(node, opts = {}) {
	  assert("Class", node, opts);
	}

	function assertModuleDeclaration(node, opts = {}) {
	  assert("ModuleDeclaration", node, opts);
	}

	function assertExportDeclaration(node, opts = {}) {
	  assert("ExportDeclaration", node, opts);
	}

	function assertModuleSpecifier(node, opts = {}) {
	  assert("ModuleSpecifier", node, opts);
	}

	function assertFlow(node, opts = {}) {
	  assert("Flow", node, opts);
	}

	function assertFlowType(node, opts = {}) {
	  assert("FlowType", node, opts);
	}

	function assertFlowBaseAnnotation(node, opts = {}) {
	  assert("FlowBaseAnnotation", node, opts);
	}

	function assertFlowDeclaration(node, opts = {}) {
	  assert("FlowDeclaration", node, opts);
	}

	function assertFlowPredicate(node, opts = {}) {
	  assert("FlowPredicate", node, opts);
	}

	function assertEnumBody(node, opts = {}) {
	  assert("EnumBody", node, opts);
	}

	function assertEnumMember(node, opts = {}) {
	  assert("EnumMember", node, opts);
	}

	function assertJSX(node, opts = {}) {
	  assert("JSX", node, opts);
	}

	function assertPrivate(node, opts = {}) {
	  assert("Private", node, opts);
	}

	function assertTSTypeElement(node, opts = {}) {
	  assert("TSTypeElement", node, opts);
	}

	function assertTSType(node, opts = {}) {
	  assert("TSType", node, opts);
	}

	function assertTSBaseType(node, opts = {}) {
	  assert("TSBaseType", node, opts);
	}

	function assertNumberLiteral(node, opts) {
	  console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
	  assert("NumberLiteral", node, opts);
	}

	function assertRegexLiteral(node, opts) {
	  console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
	  assert("RegexLiteral", node, opts);
	}

	function assertRestProperty(node, opts) {
	  console.trace("The node type RestProperty has been renamed to RestElement");
	  assert("RestProperty", node, opts);
	}

	function assertSpreadProperty(node, opts) {
	  console.trace("The node type SpreadProperty has been renamed to SpreadElement");
	  assert("SpreadProperty", node, opts);
	}
	});

	unwrapExports(generated$2);
	var generated_1$2 = generated$2.assertArrayExpression;
	var generated_2$2 = generated$2.assertAssignmentExpression;
	var generated_3$2 = generated$2.assertBinaryExpression;
	var generated_4$2 = generated$2.assertInterpreterDirective;
	var generated_5$2 = generated$2.assertDirective;
	var generated_6$2 = generated$2.assertDirectiveLiteral;
	var generated_7$2 = generated$2.assertBlockStatement;
	var generated_8$2 = generated$2.assertBreakStatement;
	var generated_9$2 = generated$2.assertCallExpression;
	var generated_10$2 = generated$2.assertCatchClause;
	var generated_11$2 = generated$2.assertConditionalExpression;
	var generated_12$2 = generated$2.assertContinueStatement;
	var generated_13$2 = generated$2.assertDebuggerStatement;
	var generated_14$2 = generated$2.assertDoWhileStatement;
	var generated_15$2 = generated$2.assertEmptyStatement;
	var generated_16$2 = generated$2.assertExpressionStatement;
	var generated_17$2 = generated$2.assertFile;
	var generated_18$2 = generated$2.assertForInStatement;
	var generated_19$2 = generated$2.assertForStatement;
	var generated_20$2 = generated$2.assertFunctionDeclaration;
	var generated_21$2 = generated$2.assertFunctionExpression;
	var generated_22$2 = generated$2.assertIdentifier;
	var generated_23$2 = generated$2.assertIfStatement;
	var generated_24$2 = generated$2.assertLabeledStatement;
	var generated_25$2 = generated$2.assertStringLiteral;
	var generated_26$2 = generated$2.assertNumericLiteral;
	var generated_27$2 = generated$2.assertNullLiteral;
	var generated_28$2 = generated$2.assertBooleanLiteral;
	var generated_29$2 = generated$2.assertRegExpLiteral;
	var generated_30$2 = generated$2.assertLogicalExpression;
	var generated_31$2 = generated$2.assertMemberExpression;
	var generated_32$2 = generated$2.assertNewExpression;
	var generated_33$2 = generated$2.assertProgram;
	var generated_34$2 = generated$2.assertObjectExpression;
	var generated_35$2 = generated$2.assertObjectMethod;
	var generated_36$2 = generated$2.assertObjectProperty;
	var generated_37$2 = generated$2.assertRestElement;
	var generated_38$2 = generated$2.assertReturnStatement;
	var generated_39$2 = generated$2.assertSequenceExpression;
	var generated_40$2 = generated$2.assertParenthesizedExpression;
	var generated_41$2 = generated$2.assertSwitchCase;
	var generated_42$2 = generated$2.assertSwitchStatement;
	var generated_43$2 = generated$2.assertThisExpression;
	var generated_44$2 = generated$2.assertThrowStatement;
	var generated_45$2 = generated$2.assertTryStatement;
	var generated_46$2 = generated$2.assertUnaryExpression;
	var generated_47$2 = generated$2.assertUpdateExpression;
	var generated_48$2 = generated$2.assertVariableDeclaration;
	var generated_49$2 = generated$2.assertVariableDeclarator;
	var generated_50$2 = generated$2.assertWhileStatement;
	var generated_51$2 = generated$2.assertWithStatement;
	var generated_52$2 = generated$2.assertAssignmentPattern;
	var generated_53$2 = generated$2.assertArrayPattern;
	var generated_54$2 = generated$2.assertArrowFunctionExpression;
	var generated_55$2 = generated$2.assertClassBody;
	var generated_56$2 = generated$2.assertClassExpression;
	var generated_57$2 = generated$2.assertClassDeclaration;
	var generated_58$2 = generated$2.assertExportAllDeclaration;
	var generated_59$2 = generated$2.assertExportDefaultDeclaration;
	var generated_60$2 = generated$2.assertExportNamedDeclaration;
	var generated_61$2 = generated$2.assertExportSpecifier;
	var generated_62$2 = generated$2.assertForOfStatement;
	var generated_63$2 = generated$2.assertImportDeclaration;
	var generated_64$2 = generated$2.assertImportDefaultSpecifier;
	var generated_65$2 = generated$2.assertImportNamespaceSpecifier;
	var generated_66$2 = generated$2.assertImportSpecifier;
	var generated_67$2 = generated$2.assertMetaProperty;
	var generated_68$2 = generated$2.assertClassMethod;
	var generated_69$2 = generated$2.assertObjectPattern;
	var generated_70$2 = generated$2.assertSpreadElement;
	var generated_71$2 = generated$2.assertSuper;
	var generated_72$2 = generated$2.assertTaggedTemplateExpression;
	var generated_73$2 = generated$2.assertTemplateElement;
	var generated_74$2 = generated$2.assertTemplateLiteral;
	var generated_75$2 = generated$2.assertYieldExpression;
	var generated_76$2 = generated$2.assertAwaitExpression;
	var generated_77$2 = generated$2.assertImport;
	var generated_78$2 = generated$2.assertBigIntLiteral;
	var generated_79$2 = generated$2.assertExportNamespaceSpecifier;
	var generated_80$2 = generated$2.assertOptionalMemberExpression;
	var generated_81$2 = generated$2.assertOptionalCallExpression;
	var generated_82$2 = generated$2.assertAnyTypeAnnotation;
	var generated_83$2 = generated$2.assertArrayTypeAnnotation;
	var generated_84$2 = generated$2.assertBooleanTypeAnnotation;
	var generated_85$2 = generated$2.assertBooleanLiteralTypeAnnotation;
	var generated_86$2 = generated$2.assertNullLiteralTypeAnnotation;
	var generated_87$2 = generated$2.assertClassImplements;
	var generated_88$2 = generated$2.assertDeclareClass;
	var generated_89$2 = generated$2.assertDeclareFunction;
	var generated_90$2 = generated$2.assertDeclareInterface;
	var generated_91$2 = generated$2.assertDeclareModule;
	var generated_92$2 = generated$2.assertDeclareModuleExports;
	var generated_93$2 = generated$2.assertDeclareTypeAlias;
	var generated_94$2 = generated$2.assertDeclareOpaqueType;
	var generated_95$2 = generated$2.assertDeclareVariable;
	var generated_96$2 = generated$2.assertDeclareExportDeclaration;
	var generated_97$2 = generated$2.assertDeclareExportAllDeclaration;
	var generated_98$2 = generated$2.assertDeclaredPredicate;
	var generated_99$2 = generated$2.assertExistsTypeAnnotation;
	var generated_100$2 = generated$2.assertFunctionTypeAnnotation;
	var generated_101$2 = generated$2.assertFunctionTypeParam;
	var generated_102$2 = generated$2.assertGenericTypeAnnotation;
	var generated_103$2 = generated$2.assertInferredPredicate;
	var generated_104$2 = generated$2.assertInterfaceExtends;
	var generated_105$2 = generated$2.assertInterfaceDeclaration;
	var generated_106$2 = generated$2.assertInterfaceTypeAnnotation;
	var generated_107$2 = generated$2.assertIntersectionTypeAnnotation;
	var generated_108$2 = generated$2.assertMixedTypeAnnotation;
	var generated_109$2 = generated$2.assertEmptyTypeAnnotation;
	var generated_110$2 = generated$2.assertNullableTypeAnnotation;
	var generated_111$2 = generated$2.assertNumberLiteralTypeAnnotation;
	var generated_112$2 = generated$2.assertNumberTypeAnnotation;
	var generated_113$2 = generated$2.assertObjectTypeAnnotation;
	var generated_114$2 = generated$2.assertObjectTypeInternalSlot;
	var generated_115$2 = generated$2.assertObjectTypeCallProperty;
	var generated_116$2 = generated$2.assertObjectTypeIndexer;
	var generated_117$2 = generated$2.assertObjectTypeProperty;
	var generated_118$2 = generated$2.assertObjectTypeSpreadProperty;
	var generated_119$2 = generated$2.assertOpaqueType;
	var generated_120$2 = generated$2.assertQualifiedTypeIdentifier;
	var generated_121$2 = generated$2.assertStringLiteralTypeAnnotation;
	var generated_122$2 = generated$2.assertStringTypeAnnotation;
	var generated_123$2 = generated$2.assertSymbolTypeAnnotation;
	var generated_124$2 = generated$2.assertThisTypeAnnotation;
	var generated_125$2 = generated$2.assertTupleTypeAnnotation;
	var generated_126$2 = generated$2.assertTypeofTypeAnnotation;
	var generated_127$2 = generated$2.assertTypeAlias;
	var generated_128$2 = generated$2.assertTypeAnnotation;
	var generated_129$2 = generated$2.assertTypeCastExpression;
	var generated_130$2 = generated$2.assertTypeParameter;
	var generated_131$2 = generated$2.assertTypeParameterDeclaration;
	var generated_132$2 = generated$2.assertTypeParameterInstantiation;
	var generated_133$2 = generated$2.assertUnionTypeAnnotation;
	var generated_134$2 = generated$2.assertVariance;
	var generated_135$2 = generated$2.assertVoidTypeAnnotation;
	var generated_136$2 = generated$2.assertEnumDeclaration;
	var generated_137$2 = generated$2.assertEnumBooleanBody;
	var generated_138$2 = generated$2.assertEnumNumberBody;
	var generated_139$2 = generated$2.assertEnumStringBody;
	var generated_140$2 = generated$2.assertEnumSymbolBody;
	var generated_141$2 = generated$2.assertEnumBooleanMember;
	var generated_142$2 = generated$2.assertEnumNumberMember;
	var generated_143$2 = generated$2.assertEnumStringMember;
	var generated_144$2 = generated$2.assertEnumDefaultedMember;
	var generated_145$2 = generated$2.assertJSXAttribute;
	var generated_146$2 = generated$2.assertJSXClosingElement;
	var generated_147$2 = generated$2.assertJSXElement;
	var generated_148$2 = generated$2.assertJSXEmptyExpression;
	var generated_149$2 = generated$2.assertJSXExpressionContainer;
	var generated_150$2 = generated$2.assertJSXSpreadChild;
	var generated_151$2 = generated$2.assertJSXIdentifier;
	var generated_152$2 = generated$2.assertJSXMemberExpression;
	var generated_153$2 = generated$2.assertJSXNamespacedName;
	var generated_154$2 = generated$2.assertJSXOpeningElement;
	var generated_155$2 = generated$2.assertJSXSpreadAttribute;
	var generated_156$2 = generated$2.assertJSXText;
	var generated_157$2 = generated$2.assertJSXFragment;
	var generated_158$2 = generated$2.assertJSXOpeningFragment;
	var generated_159$2 = generated$2.assertJSXClosingFragment;
	var generated_160$2 = generated$2.assertNoop;
	var generated_161$2 = generated$2.assertPlaceholder;
	var generated_162$2 = generated$2.assertV8IntrinsicIdentifier;
	var generated_163$2 = generated$2.assertArgumentPlaceholder;
	var generated_164$2 = generated$2.assertBindExpression;
	var generated_165$2 = generated$2.assertClassProperty;
	var generated_166$2 = generated$2.assertPipelineTopicExpression;
	var generated_167$2 = generated$2.assertPipelineBareFunction;
	var generated_168$2 = generated$2.assertPipelinePrimaryTopicReference;
	var generated_169$2 = generated$2.assertClassPrivateProperty;
	var generated_170$2 = generated$2.assertClassPrivateMethod;
	var generated_171$2 = generated$2.assertImportAttribute;
	var generated_172$2 = generated$2.assertDecorator;
	var generated_173$2 = generated$2.assertDoExpression;
	var generated_174$2 = generated$2.assertExportDefaultSpecifier;
	var generated_175$2 = generated$2.assertPrivateName;
	var generated_176$2 = generated$2.assertRecordExpression;
	var generated_177$2 = generated$2.assertTupleExpression;
	var generated_178$2 = generated$2.assertDecimalLiteral;
	var generated_179$2 = generated$2.assertStaticBlock;
	var generated_180$2 = generated$2.assertTSParameterProperty;
	var generated_181$2 = generated$2.assertTSDeclareFunction;
	var generated_182$2 = generated$2.assertTSDeclareMethod;
	var generated_183$2 = generated$2.assertTSQualifiedName;
	var generated_184$2 = generated$2.assertTSCallSignatureDeclaration;
	var generated_185$2 = generated$2.assertTSConstructSignatureDeclaration;
	var generated_186$2 = generated$2.assertTSPropertySignature;
	var generated_187$2 = generated$2.assertTSMethodSignature;
	var generated_188$2 = generated$2.assertTSIndexSignature;
	var generated_189$2 = generated$2.assertTSAnyKeyword;
	var generated_190$2 = generated$2.assertTSBooleanKeyword;
	var generated_191$2 = generated$2.assertTSBigIntKeyword;
	var generated_192$2 = generated$2.assertTSIntrinsicKeyword;
	var generated_193$2 = generated$2.assertTSNeverKeyword;
	var generated_194$2 = generated$2.assertTSNullKeyword;
	var generated_195$2 = generated$2.assertTSNumberKeyword;
	var generated_196$2 = generated$2.assertTSObjectKeyword;
	var generated_197$2 = generated$2.assertTSStringKeyword;
	var generated_198$2 = generated$2.assertTSSymbolKeyword;
	var generated_199$2 = generated$2.assertTSUndefinedKeyword;
	var generated_200$2 = generated$2.assertTSUnknownKeyword;
	var generated_201$2 = generated$2.assertTSVoidKeyword;
	var generated_202$2 = generated$2.assertTSThisType;
	var generated_203$2 = generated$2.assertTSFunctionType;
	var generated_204$2 = generated$2.assertTSConstructorType;
	var generated_205$2 = generated$2.assertTSTypeReference;
	var generated_206$2 = generated$2.assertTSTypePredicate;
	var generated_207$2 = generated$2.assertTSTypeQuery;
	var generated_208$2 = generated$2.assertTSTypeLiteral;
	var generated_209$2 = generated$2.assertTSArrayType;
	var generated_210$2 = generated$2.assertTSTupleType;
	var generated_211$2 = generated$2.assertTSOptionalType;
	var generated_212$2 = generated$2.assertTSRestType;
	var generated_213$2 = generated$2.assertTSNamedTupleMember;
	var generated_214$2 = generated$2.assertTSUnionType;
	var generated_215$2 = generated$2.assertTSIntersectionType;
	var generated_216$2 = generated$2.assertTSConditionalType;
	var generated_217$2 = generated$2.assertTSInferType;
	var generated_218$2 = generated$2.assertTSParenthesizedType;
	var generated_219$2 = generated$2.assertTSTypeOperator;
	var generated_220$2 = generated$2.assertTSIndexedAccessType;
	var generated_221$2 = generated$2.assertTSMappedType;
	var generated_222$2 = generated$2.assertTSLiteralType;
	var generated_223$2 = generated$2.assertTSExpressionWithTypeArguments;
	var generated_224$2 = generated$2.assertTSInterfaceDeclaration;
	var generated_225$2 = generated$2.assertTSInterfaceBody;
	var generated_226$2 = generated$2.assertTSTypeAliasDeclaration;
	var generated_227$2 = generated$2.assertTSAsExpression;
	var generated_228$2 = generated$2.assertTSTypeAssertion;
	var generated_229$2 = generated$2.assertTSEnumDeclaration;
	var generated_230$2 = generated$2.assertTSEnumMember;
	var generated_231$2 = generated$2.assertTSModuleDeclaration;
	var generated_232$2 = generated$2.assertTSModuleBlock;
	var generated_233$2 = generated$2.assertTSImportType;
	var generated_234$2 = generated$2.assertTSImportEqualsDeclaration;
	var generated_235$2 = generated$2.assertTSExternalModuleReference;
	var generated_236$2 = generated$2.assertTSNonNullExpression;
	var generated_237$2 = generated$2.assertTSExportAssignment;
	var generated_238$2 = generated$2.assertTSNamespaceExportDeclaration;
	var generated_239$2 = generated$2.assertTSTypeAnnotation;
	var generated_240$2 = generated$2.assertTSTypeParameterInstantiation;
	var generated_241$2 = generated$2.assertTSTypeParameterDeclaration;
	var generated_242$2 = generated$2.assertTSTypeParameter;
	var generated_243$2 = generated$2.assertExpression;
	var generated_244$2 = generated$2.assertBinary;
	var generated_245$2 = generated$2.assertScopable;
	var generated_246$2 = generated$2.assertBlockParent;
	var generated_247$2 = generated$2.assertBlock;
	var generated_248$2 = generated$2.assertStatement;
	var generated_249$2 = generated$2.assertTerminatorless;
	var generated_250$2 = generated$2.assertCompletionStatement;
	var generated_251$2 = generated$2.assertConditional;
	var generated_252$2 = generated$2.assertLoop;
	var generated_253$2 = generated$2.assertWhile;
	var generated_254$2 = generated$2.assertExpressionWrapper;
	var generated_255$2 = generated$2.assertFor;
	var generated_256$2 = generated$2.assertForXStatement;
	var generated_257$2 = generated$2.assertFunction;
	var generated_258$2 = generated$2.assertFunctionParent;
	var generated_259$2 = generated$2.assertPureish;
	var generated_260$2 = generated$2.assertDeclaration;
	var generated_261$2 = generated$2.assertPatternLike;
	var generated_262$2 = generated$2.assertLVal;
	var generated_263$2 = generated$2.assertTSEntityName;
	var generated_264$2 = generated$2.assertLiteral;
	var generated_265$2 = generated$2.assertImmutable;
	var generated_266$2 = generated$2.assertUserWhitespacable;
	var generated_267$2 = generated$2.assertMethod;
	var generated_268$2 = generated$2.assertObjectMember;
	var generated_269$2 = generated$2.assertProperty;
	var generated_270$2 = generated$2.assertUnaryLike;
	var generated_271$2 = generated$2.assertPattern;
	var generated_272$2 = generated$2.assertClass;
	var generated_273$2 = generated$2.assertModuleDeclaration;
	var generated_274$2 = generated$2.assertExportDeclaration;
	var generated_275$2 = generated$2.assertModuleSpecifier;
	var generated_276$2 = generated$2.assertFlow;
	var generated_277$2 = generated$2.assertFlowType;
	var generated_278$2 = generated$2.assertFlowBaseAnnotation;
	var generated_279$2 = generated$2.assertFlowDeclaration;
	var generated_280$2 = generated$2.assertFlowPredicate;
	var generated_281$2 = generated$2.assertEnumBody;
	var generated_282$2 = generated$2.assertEnumMember;
	var generated_283$2 = generated$2.assertJSX;
	var generated_284$2 = generated$2.assertPrivate;
	var generated_285$2 = generated$2.assertTSTypeElement;
	var generated_286$2 = generated$2.assertTSType;
	var generated_287$2 = generated$2.assertTSBaseType;
	var generated_288$2 = generated$2.assertNumberLiteral;
	var generated_289$2 = generated$2.assertRegexLiteral;
	var generated_290$2 = generated$2.assertRestProperty;
	var generated_291$2 = generated$2.assertSpreadProperty;

	var createTypeAnnotationBasedOnTypeof_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = createTypeAnnotationBasedOnTypeof;



	function createTypeAnnotationBasedOnTypeof(type) {
	  if (type === "string") {
	    return (0, generated$1.stringTypeAnnotation)();
	  } else if (type === "number") {
	    return (0, generated$1.numberTypeAnnotation)();
	  } else if (type === "undefined") {
	    return (0, generated$1.voidTypeAnnotation)();
	  } else if (type === "boolean") {
	    return (0, generated$1.booleanTypeAnnotation)();
	  } else if (type === "function") {
	    return (0, generated$1.genericTypeAnnotation)((0, generated$1.identifier)("Function"));
	  } else if (type === "object") {
	    return (0, generated$1.genericTypeAnnotation)((0, generated$1.identifier)("Object"));
	  } else if (type === "symbol") {
	    return (0, generated$1.genericTypeAnnotation)((0, generated$1.identifier)("Symbol"));
	  } else {
	    throw new Error("Invalid typeof value");
	  }
	}
	});

	unwrapExports(createTypeAnnotationBasedOnTypeof_1);

	var removeTypeDuplicates_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = removeTypeDuplicates;



	function removeTypeDuplicates(nodes) {
	  const generics = {};
	  const bases = {};
	  const typeGroups = [];
	  const types = [];

	  for (let i = 0; i < nodes.length; i++) {
	    const node = nodes[i];
	    if (!node) continue;

	    if (types.indexOf(node) >= 0) {
	      continue;
	    }

	    if ((0, generated.isAnyTypeAnnotation)(node)) {
	      return [node];
	    }

	    if ((0, generated.isFlowBaseAnnotation)(node)) {
	      bases[node.type] = node;
	      continue;
	    }

	    if ((0, generated.isUnionTypeAnnotation)(node)) {
	      if (typeGroups.indexOf(node.types) < 0) {
	        nodes = nodes.concat(node.types);
	        typeGroups.push(node.types);
	      }

	      continue;
	    }

	    if ((0, generated.isGenericTypeAnnotation)(node)) {
	      const name = node.id.name;

	      if (generics[name]) {
	        let existing = generics[name];

	        if (existing.typeParameters) {
	          if (node.typeParameters) {
	            existing.typeParameters.params = removeTypeDuplicates(existing.typeParameters.params.concat(node.typeParameters.params));
	          }
	        } else {
	          existing = node.typeParameters;
	        }
	      } else {
	        generics[name] = node;
	      }

	      continue;
	    }

	    types.push(node);
	  }

	  for (const type of Object.keys(bases)) {
	    types.push(bases[type]);
	  }

	  for (const name of Object.keys(generics)) {
	    types.push(generics[name]);
	  }

	  return types;
	}
	});

	unwrapExports(removeTypeDuplicates_1);

	var createFlowUnionType_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = createFlowUnionType;



	var _removeTypeDuplicates = _interopRequireDefault(removeTypeDuplicates_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function createFlowUnionType(types) {
	  const flattened = (0, _removeTypeDuplicates.default)(types);

	  if (flattened.length === 1) {
	    return flattened[0];
	  } else {
	    return (0, generated$1.unionTypeAnnotation)(flattened);
	  }
	}
	});

	unwrapExports(createFlowUnionType_1);

	var removeTypeDuplicates_1$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = removeTypeDuplicates;



	function removeTypeDuplicates(nodes) {
	  const generics = {};
	  const bases = {};
	  const typeGroups = [];
	  const types = [];

	  for (let i = 0; i < nodes.length; i++) {
	    const node = nodes[i];
	    if (!node) continue;

	    if (types.indexOf(node) >= 0) {
	      continue;
	    }

	    if ((0, generated.isTSAnyKeyword)(node.type)) {
	      return [node];
	    }

	    if ((0, generated.isTSBaseType)(node)) {
	      bases[node.type] = node;
	      continue;
	    }

	    if ((0, generated.isTSUnionType)(node)) {
	      if (typeGroups.indexOf(node.types) < 0) {
	        nodes = nodes.concat(node.types);
	        typeGroups.push(node.types);
	      }

	      continue;
	    }

	    types.push(node);
	  }

	  for (const type of Object.keys(bases)) {
	    types.push(bases[type]);
	  }

	  for (const name of Object.keys(generics)) {
	    types.push(generics[name]);
	  }

	  return types;
	}
	});

	unwrapExports(removeTypeDuplicates_1$1);

	var createTSUnionType_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = createTSUnionType;



	var _removeTypeDuplicates = _interopRequireDefault(removeTypeDuplicates_1$1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function createTSUnionType(typeAnnotations) {
	  const types = typeAnnotations.map(type => type.typeAnnotations);
	  const flattened = (0, _removeTypeDuplicates.default)(types);

	  if (flattened.length === 1) {
	    return flattened[0];
	  } else {
	    return (0, generated$1.tsUnionType)(flattened);
	  }
	}
	});

	unwrapExports(createTSUnionType_1);

	var cloneNode_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = cloneNode;



	const has = Function.call.bind(Object.prototype.hasOwnProperty);

	function cloneIfNode(obj, deep, withoutLoc) {
	  if (obj && typeof obj.type === "string") {
	    return cloneNode(obj, deep, withoutLoc);
	  }

	  return obj;
	}

	function cloneIfNodeOrArray(obj, deep, withoutLoc) {
	  if (Array.isArray(obj)) {
	    return obj.map(node => cloneIfNode(node, deep, withoutLoc));
	  }

	  return cloneIfNode(obj, deep, withoutLoc);
	}

	function cloneNode(node, deep = true, withoutLoc = false) {
	  if (!node) return node;
	  const {
	    type
	  } = node;
	  const newNode = {
	    type
	  };

	  if (type === "Identifier") {
	    newNode.name = node.name;

	    if (has(node, "optional") && typeof node.optional === "boolean") {
	      newNode.optional = node.optional;
	    }

	    if (has(node, "typeAnnotation")) {
	      newNode.typeAnnotation = deep ? cloneIfNodeOrArray(node.typeAnnotation, true, withoutLoc) : node.typeAnnotation;
	    }
	  } else if (!has(definitions.NODE_FIELDS, type)) {
	    throw new Error(`Unknown node type: "${type}"`);
	  } else {
	    for (const field of Object.keys(definitions.NODE_FIELDS[type])) {
	      if (has(node, field)) {
	        if (deep) {
	          newNode[field] = type === "File" && field === "comments" ? maybeCloneComments(node.comments, deep, withoutLoc) : cloneIfNodeOrArray(node[field], true, withoutLoc);
	        } else {
	          newNode[field] = node[field];
	        }
	      }
	    }
	  }

	  if (has(node, "loc")) {
	    if (withoutLoc) {
	      newNode.loc = null;
	    } else {
	      newNode.loc = node.loc;
	    }
	  }

	  if (has(node, "leadingComments")) {
	    newNode.leadingComments = maybeCloneComments(node.leadingComments, deep, withoutLoc);
	  }

	  if (has(node, "innerComments")) {
	    newNode.innerComments = maybeCloneComments(node.innerComments, deep, withoutLoc);
	  }

	  if (has(node, "trailingComments")) {
	    newNode.trailingComments = maybeCloneComments(node.trailingComments, deep, withoutLoc);
	  }

	  if (has(node, "extra")) {
	    newNode.extra = Object.assign({}, node.extra);
	  }

	  return newNode;
	}

	function cloneCommentsWithoutLoc(comments) {
	  return comments.map(({
	    type,
	    value
	  }) => ({
	    type,
	    value,
	    loc: null
	  }));
	}

	function maybeCloneComments(comments, deep, withoutLoc) {
	  return deep && withoutLoc ? cloneCommentsWithoutLoc(comments) : comments;
	}
	});

	unwrapExports(cloneNode_1);

	var clone_1$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = clone;

	var _cloneNode = _interopRequireDefault(cloneNode_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function clone(node) {
	  return (0, _cloneNode.default)(node, false);
	}
	});

	unwrapExports(clone_1$1);

	var cloneDeep_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = cloneDeep;

	var _cloneNode = _interopRequireDefault(cloneNode_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function cloneDeep(node) {
	  return (0, _cloneNode.default)(node);
	}
	});

	unwrapExports(cloneDeep_1);

	var cloneDeepWithoutLoc_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = cloneDeepWithoutLoc;

	var _cloneNode = _interopRequireDefault(cloneNode_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function cloneDeepWithoutLoc(node) {
	  return (0, _cloneNode.default)(node, true, true);
	}
	});

	unwrapExports(cloneDeepWithoutLoc_1);

	var cloneWithoutLoc_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = cloneWithoutLoc;

	var _cloneNode = _interopRequireDefault(cloneNode_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function cloneWithoutLoc(node) {
	  return (0, _cloneNode.default)(node, false, true);
	}
	});

	unwrapExports(cloneWithoutLoc_1);

	var addComments_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = addComments;

	function addComments(node, type, comments) {
	  if (!comments || !node) return node;
	  const key = `${type}Comments`;

	  if (node[key]) {
	    if (type === "leading") {
	      node[key] = comments.concat(node[key]);
	    } else {
	      node[key] = node[key].concat(comments);
	    }
	  } else {
	    node[key] = comments;
	  }

	  return node;
	}
	});

	unwrapExports(addComments_1);

	var addComment_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = addComment;

	var _addComments = _interopRequireDefault(addComments_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function addComment(node, type, content, line) {
	  return (0, _addComments.default)(node, type, [{
	    type: line ? "CommentLine" : "CommentBlock",
	    value: content
	  }]);
	}
	});

	unwrapExports(addComment_1);

	var inherit_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = inherit;

	function inherit(key, child, parent) {
	  if (child && parent) {
	    child[key] = Array.from(new Set([].concat(child[key], parent[key]).filter(Boolean)));
	  }
	}
	});

	unwrapExports(inherit_1);

	var inheritInnerComments_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = inheritInnerComments;

	var _inherit = _interopRequireDefault(inherit_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function inheritInnerComments(child, parent) {
	  (0, _inherit.default)("innerComments", child, parent);
	}
	});

	unwrapExports(inheritInnerComments_1);

	var inheritLeadingComments_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = inheritLeadingComments;

	var _inherit = _interopRequireDefault(inherit_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function inheritLeadingComments(child, parent) {
	  (0, _inherit.default)("leadingComments", child, parent);
	}
	});

	unwrapExports(inheritLeadingComments_1);

	var inheritTrailingComments_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = inheritTrailingComments;

	var _inherit = _interopRequireDefault(inherit_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function inheritTrailingComments(child, parent) {
	  (0, _inherit.default)("trailingComments", child, parent);
	}
	});

	unwrapExports(inheritTrailingComments_1);

	var inheritsComments_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = inheritsComments;

	var _inheritTrailingComments = _interopRequireDefault(inheritTrailingComments_1);

	var _inheritLeadingComments = _interopRequireDefault(inheritLeadingComments_1);

	var _inheritInnerComments = _interopRequireDefault(inheritInnerComments_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function inheritsComments(child, parent) {
	  (0, _inheritTrailingComments.default)(child, parent);
	  (0, _inheritLeadingComments.default)(child, parent);
	  (0, _inheritInnerComments.default)(child, parent);
	  return child;
	}
	});

	unwrapExports(inheritsComments_1);

	var removeComments_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = removeComments;



	function removeComments(node) {
	  constants.COMMENT_KEYS.forEach(key => {
	    node[key] = null;
	  });

	  return node;
	}
	});

	unwrapExports(removeComments_1);

	var generated$3 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.TSBASETYPE_TYPES = exports.TSTYPE_TYPES = exports.TSTYPEELEMENT_TYPES = exports.PRIVATE_TYPES = exports.JSX_TYPES = exports.ENUMMEMBER_TYPES = exports.ENUMBODY_TYPES = exports.FLOWPREDICATE_TYPES = exports.FLOWDECLARATION_TYPES = exports.FLOWBASEANNOTATION_TYPES = exports.FLOWTYPE_TYPES = exports.FLOW_TYPES = exports.MODULESPECIFIER_TYPES = exports.EXPORTDECLARATION_TYPES = exports.MODULEDECLARATION_TYPES = exports.CLASS_TYPES = exports.PATTERN_TYPES = exports.UNARYLIKE_TYPES = exports.PROPERTY_TYPES = exports.OBJECTMEMBER_TYPES = exports.METHOD_TYPES = exports.USERWHITESPACABLE_TYPES = exports.IMMUTABLE_TYPES = exports.LITERAL_TYPES = exports.TSENTITYNAME_TYPES = exports.LVAL_TYPES = exports.PATTERNLIKE_TYPES = exports.DECLARATION_TYPES = exports.PUREISH_TYPES = exports.FUNCTIONPARENT_TYPES = exports.FUNCTION_TYPES = exports.FORXSTATEMENT_TYPES = exports.FOR_TYPES = exports.EXPRESSIONWRAPPER_TYPES = exports.WHILE_TYPES = exports.LOOP_TYPES = exports.CONDITIONAL_TYPES = exports.COMPLETIONSTATEMENT_TYPES = exports.TERMINATORLESS_TYPES = exports.STATEMENT_TYPES = exports.BLOCK_TYPES = exports.BLOCKPARENT_TYPES = exports.SCOPABLE_TYPES = exports.BINARY_TYPES = exports.EXPRESSION_TYPES = void 0;



	const EXPRESSION_TYPES = definitions.FLIPPED_ALIAS_KEYS["Expression"];
	exports.EXPRESSION_TYPES = EXPRESSION_TYPES;
	const BINARY_TYPES = definitions.FLIPPED_ALIAS_KEYS["Binary"];
	exports.BINARY_TYPES = BINARY_TYPES;
	const SCOPABLE_TYPES = definitions.FLIPPED_ALIAS_KEYS["Scopable"];
	exports.SCOPABLE_TYPES = SCOPABLE_TYPES;
	const BLOCKPARENT_TYPES = definitions.FLIPPED_ALIAS_KEYS["BlockParent"];
	exports.BLOCKPARENT_TYPES = BLOCKPARENT_TYPES;
	const BLOCK_TYPES = definitions.FLIPPED_ALIAS_KEYS["Block"];
	exports.BLOCK_TYPES = BLOCK_TYPES;
	const STATEMENT_TYPES = definitions.FLIPPED_ALIAS_KEYS["Statement"];
	exports.STATEMENT_TYPES = STATEMENT_TYPES;
	const TERMINATORLESS_TYPES = definitions.FLIPPED_ALIAS_KEYS["Terminatorless"];
	exports.TERMINATORLESS_TYPES = TERMINATORLESS_TYPES;
	const COMPLETIONSTATEMENT_TYPES = definitions.FLIPPED_ALIAS_KEYS["CompletionStatement"];
	exports.COMPLETIONSTATEMENT_TYPES = COMPLETIONSTATEMENT_TYPES;
	const CONDITIONAL_TYPES = definitions.FLIPPED_ALIAS_KEYS["Conditional"];
	exports.CONDITIONAL_TYPES = CONDITIONAL_TYPES;
	const LOOP_TYPES = definitions.FLIPPED_ALIAS_KEYS["Loop"];
	exports.LOOP_TYPES = LOOP_TYPES;
	const WHILE_TYPES = definitions.FLIPPED_ALIAS_KEYS["While"];
	exports.WHILE_TYPES = WHILE_TYPES;
	const EXPRESSIONWRAPPER_TYPES = definitions.FLIPPED_ALIAS_KEYS["ExpressionWrapper"];
	exports.EXPRESSIONWRAPPER_TYPES = EXPRESSIONWRAPPER_TYPES;
	const FOR_TYPES = definitions.FLIPPED_ALIAS_KEYS["For"];
	exports.FOR_TYPES = FOR_TYPES;
	const FORXSTATEMENT_TYPES = definitions.FLIPPED_ALIAS_KEYS["ForXStatement"];
	exports.FORXSTATEMENT_TYPES = FORXSTATEMENT_TYPES;
	const FUNCTION_TYPES = definitions.FLIPPED_ALIAS_KEYS["Function"];
	exports.FUNCTION_TYPES = FUNCTION_TYPES;
	const FUNCTIONPARENT_TYPES = definitions.FLIPPED_ALIAS_KEYS["FunctionParent"];
	exports.FUNCTIONPARENT_TYPES = FUNCTIONPARENT_TYPES;
	const PUREISH_TYPES = definitions.FLIPPED_ALIAS_KEYS["Pureish"];
	exports.PUREISH_TYPES = PUREISH_TYPES;
	const DECLARATION_TYPES = definitions.FLIPPED_ALIAS_KEYS["Declaration"];
	exports.DECLARATION_TYPES = DECLARATION_TYPES;
	const PATTERNLIKE_TYPES = definitions.FLIPPED_ALIAS_KEYS["PatternLike"];
	exports.PATTERNLIKE_TYPES = PATTERNLIKE_TYPES;
	const LVAL_TYPES = definitions.FLIPPED_ALIAS_KEYS["LVal"];
	exports.LVAL_TYPES = LVAL_TYPES;
	const TSENTITYNAME_TYPES = definitions.FLIPPED_ALIAS_KEYS["TSEntityName"];
	exports.TSENTITYNAME_TYPES = TSENTITYNAME_TYPES;
	const LITERAL_TYPES = definitions.FLIPPED_ALIAS_KEYS["Literal"];
	exports.LITERAL_TYPES = LITERAL_TYPES;
	const IMMUTABLE_TYPES = definitions.FLIPPED_ALIAS_KEYS["Immutable"];
	exports.IMMUTABLE_TYPES = IMMUTABLE_TYPES;
	const USERWHITESPACABLE_TYPES = definitions.FLIPPED_ALIAS_KEYS["UserWhitespacable"];
	exports.USERWHITESPACABLE_TYPES = USERWHITESPACABLE_TYPES;
	const METHOD_TYPES = definitions.FLIPPED_ALIAS_KEYS["Method"];
	exports.METHOD_TYPES = METHOD_TYPES;
	const OBJECTMEMBER_TYPES = definitions.FLIPPED_ALIAS_KEYS["ObjectMember"];
	exports.OBJECTMEMBER_TYPES = OBJECTMEMBER_TYPES;
	const PROPERTY_TYPES = definitions.FLIPPED_ALIAS_KEYS["Property"];
	exports.PROPERTY_TYPES = PROPERTY_TYPES;
	const UNARYLIKE_TYPES = definitions.FLIPPED_ALIAS_KEYS["UnaryLike"];
	exports.UNARYLIKE_TYPES = UNARYLIKE_TYPES;
	const PATTERN_TYPES = definitions.FLIPPED_ALIAS_KEYS["Pattern"];
	exports.PATTERN_TYPES = PATTERN_TYPES;
	const CLASS_TYPES = definitions.FLIPPED_ALIAS_KEYS["Class"];
	exports.CLASS_TYPES = CLASS_TYPES;
	const MODULEDECLARATION_TYPES = definitions.FLIPPED_ALIAS_KEYS["ModuleDeclaration"];
	exports.MODULEDECLARATION_TYPES = MODULEDECLARATION_TYPES;
	const EXPORTDECLARATION_TYPES = definitions.FLIPPED_ALIAS_KEYS["ExportDeclaration"];
	exports.EXPORTDECLARATION_TYPES = EXPORTDECLARATION_TYPES;
	const MODULESPECIFIER_TYPES = definitions.FLIPPED_ALIAS_KEYS["ModuleSpecifier"];
	exports.MODULESPECIFIER_TYPES = MODULESPECIFIER_TYPES;
	const FLOW_TYPES = definitions.FLIPPED_ALIAS_KEYS["Flow"];
	exports.FLOW_TYPES = FLOW_TYPES;
	const FLOWTYPE_TYPES = definitions.FLIPPED_ALIAS_KEYS["FlowType"];
	exports.FLOWTYPE_TYPES = FLOWTYPE_TYPES;
	const FLOWBASEANNOTATION_TYPES = definitions.FLIPPED_ALIAS_KEYS["FlowBaseAnnotation"];
	exports.FLOWBASEANNOTATION_TYPES = FLOWBASEANNOTATION_TYPES;
	const FLOWDECLARATION_TYPES = definitions.FLIPPED_ALIAS_KEYS["FlowDeclaration"];
	exports.FLOWDECLARATION_TYPES = FLOWDECLARATION_TYPES;
	const FLOWPREDICATE_TYPES = definitions.FLIPPED_ALIAS_KEYS["FlowPredicate"];
	exports.FLOWPREDICATE_TYPES = FLOWPREDICATE_TYPES;
	const ENUMBODY_TYPES = definitions.FLIPPED_ALIAS_KEYS["EnumBody"];
	exports.ENUMBODY_TYPES = ENUMBODY_TYPES;
	const ENUMMEMBER_TYPES = definitions.FLIPPED_ALIAS_KEYS["EnumMember"];
	exports.ENUMMEMBER_TYPES = ENUMMEMBER_TYPES;
	const JSX_TYPES = definitions.FLIPPED_ALIAS_KEYS["JSX"];
	exports.JSX_TYPES = JSX_TYPES;
	const PRIVATE_TYPES = definitions.FLIPPED_ALIAS_KEYS["Private"];
	exports.PRIVATE_TYPES = PRIVATE_TYPES;
	const TSTYPEELEMENT_TYPES = definitions.FLIPPED_ALIAS_KEYS["TSTypeElement"];
	exports.TSTYPEELEMENT_TYPES = TSTYPEELEMENT_TYPES;
	const TSTYPE_TYPES = definitions.FLIPPED_ALIAS_KEYS["TSType"];
	exports.TSTYPE_TYPES = TSTYPE_TYPES;
	const TSBASETYPE_TYPES = definitions.FLIPPED_ALIAS_KEYS["TSBaseType"];
	exports.TSBASETYPE_TYPES = TSBASETYPE_TYPES;
	});

	unwrapExports(generated$3);
	var generated_1$3 = generated$3.TSBASETYPE_TYPES;
	var generated_2$3 = generated$3.TSTYPE_TYPES;
	var generated_3$3 = generated$3.TSTYPEELEMENT_TYPES;
	var generated_4$3 = generated$3.PRIVATE_TYPES;
	var generated_5$3 = generated$3.JSX_TYPES;
	var generated_6$3 = generated$3.ENUMMEMBER_TYPES;
	var generated_7$3 = generated$3.ENUMBODY_TYPES;
	var generated_8$3 = generated$3.FLOWPREDICATE_TYPES;
	var generated_9$3 = generated$3.FLOWDECLARATION_TYPES;
	var generated_10$3 = generated$3.FLOWBASEANNOTATION_TYPES;
	var generated_11$3 = generated$3.FLOWTYPE_TYPES;
	var generated_12$3 = generated$3.FLOW_TYPES;
	var generated_13$3 = generated$3.MODULESPECIFIER_TYPES;
	var generated_14$3 = generated$3.EXPORTDECLARATION_TYPES;
	var generated_15$3 = generated$3.MODULEDECLARATION_TYPES;
	var generated_16$3 = generated$3.CLASS_TYPES;
	var generated_17$3 = generated$3.PATTERN_TYPES;
	var generated_18$3 = generated$3.UNARYLIKE_TYPES;
	var generated_19$3 = generated$3.PROPERTY_TYPES;
	var generated_20$3 = generated$3.OBJECTMEMBER_TYPES;
	var generated_21$3 = generated$3.METHOD_TYPES;
	var generated_22$3 = generated$3.USERWHITESPACABLE_TYPES;
	var generated_23$3 = generated$3.IMMUTABLE_TYPES;
	var generated_24$3 = generated$3.LITERAL_TYPES;
	var generated_25$3 = generated$3.TSENTITYNAME_TYPES;
	var generated_26$3 = generated$3.LVAL_TYPES;
	var generated_27$3 = generated$3.PATTERNLIKE_TYPES;
	var generated_28$3 = generated$3.DECLARATION_TYPES;
	var generated_29$3 = generated$3.PUREISH_TYPES;
	var generated_30$3 = generated$3.FUNCTIONPARENT_TYPES;
	var generated_31$3 = generated$3.FUNCTION_TYPES;
	var generated_32$3 = generated$3.FORXSTATEMENT_TYPES;
	var generated_33$3 = generated$3.FOR_TYPES;
	var generated_34$3 = generated$3.EXPRESSIONWRAPPER_TYPES;
	var generated_35$3 = generated$3.WHILE_TYPES;
	var generated_36$3 = generated$3.LOOP_TYPES;
	var generated_37$3 = generated$3.CONDITIONAL_TYPES;
	var generated_38$3 = generated$3.COMPLETIONSTATEMENT_TYPES;
	var generated_39$3 = generated$3.TERMINATORLESS_TYPES;
	var generated_40$3 = generated$3.STATEMENT_TYPES;
	var generated_41$3 = generated$3.BLOCK_TYPES;
	var generated_42$3 = generated$3.BLOCKPARENT_TYPES;
	var generated_43$3 = generated$3.SCOPABLE_TYPES;
	var generated_44$3 = generated$3.BINARY_TYPES;
	var generated_45$3 = generated$3.EXPRESSION_TYPES;

	var toBlock_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toBlock;





	function toBlock(node, parent) {
	  if ((0, generated.isBlockStatement)(node)) {
	    return node;
	  }

	  let blockNodes = [];

	  if ((0, generated.isEmptyStatement)(node)) {
	    blockNodes = [];
	  } else {
	    if (!(0, generated.isStatement)(node)) {
	      if ((0, generated.isFunction)(parent)) {
	        node = (0, generated$1.returnStatement)(node);
	      } else {
	        node = (0, generated$1.expressionStatement)(node);
	      }
	    }

	    blockNodes = [node];
	  }

	  return (0, generated$1.blockStatement)(blockNodes);
	}
	});

	unwrapExports(toBlock_1);

	var ensureBlock_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = ensureBlock;

	var _toBlock = _interopRequireDefault(toBlock_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function ensureBlock(node, key = "body") {
	  return node[key] = (0, _toBlock.default)(node[key], node);
	}
	});

	unwrapExports(ensureBlock_1);

	var toIdentifier_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toIdentifier;

	var _isValidIdentifier = _interopRequireDefault(isValidIdentifier_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function toIdentifier(name) {
	  name = name + "";
	  name = name.replace(/[^a-zA-Z0-9$_]/g, "-");
	  name = name.replace(/^[-0-9]+/, "");
	  name = name.replace(/[-\s]+(.)?/g, function (match, c) {
	    return c ? c.toUpperCase() : "";
	  });

	  if (!(0, _isValidIdentifier.default)(name)) {
	    name = `_${name}`;
	  }

	  return name || "_";
	}
	});

	unwrapExports(toIdentifier_1);

	var toBindingIdentifierName_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toBindingIdentifierName;

	var _toIdentifier = _interopRequireDefault(toIdentifier_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function toBindingIdentifierName(name) {
	  name = (0, _toIdentifier.default)(name);
	  if (name === "eval" || name === "arguments") name = "_" + name;
	  return name;
	}
	});

	unwrapExports(toBindingIdentifierName_1);

	var toComputedKey_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toComputedKey;





	function toComputedKey(node, key = node.key || node.property) {
	  if (!node.computed && (0, generated.isIdentifier)(key)) key = (0, generated$1.stringLiteral)(key.name);
	  return key;
	}
	});

	unwrapExports(toComputedKey_1);

	var toExpression_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toExpression;



	function toExpression(node) {
	  if ((0, generated.isExpressionStatement)(node)) {
	    node = node.expression;
	  }

	  if ((0, generated.isExpression)(node)) {
	    return node;
	  }

	  if ((0, generated.isClass)(node)) {
	    node.type = "ClassExpression";
	  } else if ((0, generated.isFunction)(node)) {
	    node.type = "FunctionExpression";
	  }

	  if (!(0, generated.isExpression)(node)) {
	    throw new Error(`cannot turn ${node.type} to an expression`);
	  }

	  return node;
	}
	});

	unwrapExports(toExpression_1);

	var traverseFast_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = traverseFast;



	function traverseFast(node, enter, opts) {
	  if (!node) return;
	  const keys = definitions.VISITOR_KEYS[node.type];
	  if (!keys) return;
	  opts = opts || {};
	  enter(node, opts);

	  for (const key of keys) {
	    const subNode = node[key];

	    if (Array.isArray(subNode)) {
	      for (const node of subNode) {
	        traverseFast(node, enter, opts);
	      }
	    } else {
	      traverseFast(subNode, enter, opts);
	    }
	  }
	}
	});

	unwrapExports(traverseFast_1);

	var removeProperties_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = removeProperties;



	const CLEAR_KEYS = ["tokens", "start", "end", "loc", "raw", "rawValue"];

	const CLEAR_KEYS_PLUS_COMMENTS = constants.COMMENT_KEYS.concat(["comments"]).concat(CLEAR_KEYS);

	function removeProperties(node, opts = {}) {
	  const map = opts.preserveComments ? CLEAR_KEYS : CLEAR_KEYS_PLUS_COMMENTS;

	  for (const key of map) {
	    if (node[key] != null) node[key] = undefined;
	  }

	  for (const key of Object.keys(node)) {
	    if (key[0] === "_" && node[key] != null) node[key] = undefined;
	  }

	  const symbols = Object.getOwnPropertySymbols(node);

	  for (const sym of symbols) {
	    node[sym] = null;
	  }
	}
	});

	unwrapExports(removeProperties_1);

	var removePropertiesDeep_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = removePropertiesDeep;

	var _traverseFast = _interopRequireDefault(traverseFast_1);

	var _removeProperties = _interopRequireDefault(removeProperties_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function removePropertiesDeep(tree, opts) {
	  (0, _traverseFast.default)(tree, _removeProperties.default, opts);
	  return tree;
	}
	});

	unwrapExports(removePropertiesDeep_1);

	var toKeyAlias_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toKeyAlias;



	var _cloneNode = _interopRequireDefault(cloneNode_1);

	var _removePropertiesDeep = _interopRequireDefault(removePropertiesDeep_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function toKeyAlias(node, key = node.key) {
	  let alias;

	  if (node.kind === "method") {
	    return toKeyAlias.increment() + "";
	  } else if ((0, generated.isIdentifier)(key)) {
	    alias = key.name;
	  } else if ((0, generated.isStringLiteral)(key)) {
	    alias = JSON.stringify(key.value);
	  } else {
	    alias = JSON.stringify((0, _removePropertiesDeep.default)((0, _cloneNode.default)(key)));
	  }

	  if (node.computed) {
	    alias = `[${alias}]`;
	  }

	  if (node.static) {
	    alias = `static:${alias}`;
	  }

	  return alias;
	}

	toKeyAlias.uid = 0;

	toKeyAlias.increment = function () {
	  if (toKeyAlias.uid >= Number.MAX_SAFE_INTEGER) {
	    return toKeyAlias.uid = 0;
	  } else {
	    return toKeyAlias.uid++;
	  }
	};
	});

	unwrapExports(toKeyAlias_1);

	var getBindingIdentifiers_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = getBindingIdentifiers;



	function getBindingIdentifiers(node, duplicates, outerOnly) {
	  let search = [].concat(node);
	  const ids = Object.create(null);

	  while (search.length) {
	    const id = search.shift();
	    if (!id) continue;
	    const keys = getBindingIdentifiers.keys[id.type];

	    if ((0, generated.isIdentifier)(id)) {
	      if (duplicates) {
	        const _ids = ids[id.name] = ids[id.name] || [];

	        _ids.push(id);
	      } else {
	        ids[id.name] = id;
	      }

	      continue;
	    }

	    if ((0, generated.isExportDeclaration)(id)) {
	      if ((0, generated.isDeclaration)(id.declaration)) {
	        search.push(id.declaration);
	      }

	      continue;
	    }

	    if (outerOnly) {
	      if ((0, generated.isFunctionDeclaration)(id)) {
	        search.push(id.id);
	        continue;
	      }

	      if ((0, generated.isFunctionExpression)(id)) {
	        continue;
	      }
	    }

	    if (keys) {
	      for (let i = 0; i < keys.length; i++) {
	        const key = keys[i];

	        if (id[key]) {
	          search = search.concat(id[key]);
	        }
	      }
	    }
	  }

	  return ids;
	}

	getBindingIdentifiers.keys = {
	  DeclareClass: ["id"],
	  DeclareFunction: ["id"],
	  DeclareModule: ["id"],
	  DeclareVariable: ["id"],
	  DeclareInterface: ["id"],
	  DeclareTypeAlias: ["id"],
	  DeclareOpaqueType: ["id"],
	  InterfaceDeclaration: ["id"],
	  TypeAlias: ["id"],
	  OpaqueType: ["id"],
	  CatchClause: ["param"],
	  LabeledStatement: ["label"],
	  UnaryExpression: ["argument"],
	  AssignmentExpression: ["left"],
	  ImportSpecifier: ["local"],
	  ImportNamespaceSpecifier: ["local"],
	  ImportDefaultSpecifier: ["local"],
	  ImportDeclaration: ["specifiers"],
	  ExportSpecifier: ["exported"],
	  ExportNamespaceSpecifier: ["exported"],
	  ExportDefaultSpecifier: ["exported"],
	  FunctionDeclaration: ["id", "params"],
	  FunctionExpression: ["id", "params"],
	  ArrowFunctionExpression: ["params"],
	  ObjectMethod: ["params"],
	  ClassMethod: ["params"],
	  ForInStatement: ["left"],
	  ForOfStatement: ["left"],
	  ClassDeclaration: ["id"],
	  ClassExpression: ["id"],
	  RestElement: ["argument"],
	  UpdateExpression: ["argument"],
	  ObjectProperty: ["value"],
	  AssignmentPattern: ["left"],
	  ArrayPattern: ["elements"],
	  ObjectPattern: ["properties"],
	  VariableDeclaration: ["declarations"],
	  VariableDeclarator: ["id"]
	};
	});

	unwrapExports(getBindingIdentifiers_1);

	var gatherSequenceExpressions_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = gatherSequenceExpressions;

	var _getBindingIdentifiers = _interopRequireDefault(getBindingIdentifiers_1);





	var _cloneNode = _interopRequireDefault(cloneNode_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function gatherSequenceExpressions(nodes, scope, declars) {
	  const exprs = [];
	  let ensureLastUndefined = true;

	  for (const node of nodes) {
	    if (!(0, generated.isEmptyStatement)(node)) {
	      ensureLastUndefined = false;
	    }

	    if ((0, generated.isExpression)(node)) {
	      exprs.push(node);
	    } else if ((0, generated.isExpressionStatement)(node)) {
	      exprs.push(node.expression);
	    } else if ((0, generated.isVariableDeclaration)(node)) {
	      if (node.kind !== "var") return;

	      for (const declar of node.declarations) {
	        const bindings = (0, _getBindingIdentifiers.default)(declar);

	        for (const key of Object.keys(bindings)) {
	          declars.push({
	            kind: node.kind,
	            id: (0, _cloneNode.default)(bindings[key])
	          });
	        }

	        if (declar.init) {
	          exprs.push((0, generated$1.assignmentExpression)("=", declar.id, declar.init));
	        }
	      }

	      ensureLastUndefined = true;
	    } else if ((0, generated.isIfStatement)(node)) {
	      const consequent = node.consequent ? gatherSequenceExpressions([node.consequent], scope, declars) : scope.buildUndefinedNode();
	      const alternate = node.alternate ? gatherSequenceExpressions([node.alternate], scope, declars) : scope.buildUndefinedNode();
	      if (!consequent || !alternate) return;
	      exprs.push((0, generated$1.conditionalExpression)(node.test, consequent, alternate));
	    } else if ((0, generated.isBlockStatement)(node)) {
	      const body = gatherSequenceExpressions(node.body, scope, declars);
	      if (!body) return;
	      exprs.push(body);
	    } else if ((0, generated.isEmptyStatement)(node)) {
	      if (nodes.indexOf(node) === 0) {
	        ensureLastUndefined = true;
	      }
	    } else {
	      return;
	    }
	  }

	  if (ensureLastUndefined) {
	    exprs.push(scope.buildUndefinedNode());
	  }

	  if (exprs.length === 1) {
	    return exprs[0];
	  } else {
	    return (0, generated$1.sequenceExpression)(exprs);
	  }
	}
	});

	unwrapExports(gatherSequenceExpressions_1);

	var toSequenceExpression_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toSequenceExpression;

	var _gatherSequenceExpressions = _interopRequireDefault(gatherSequenceExpressions_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function toSequenceExpression(nodes, scope) {
	  if (!(nodes == null ? void 0 : nodes.length)) return;
	  const declars = [];
	  const result = (0, _gatherSequenceExpressions.default)(nodes, scope, declars);
	  if (!result) return;

	  for (const declar of declars) {
	    scope.push(declar);
	  }

	  return result;
	}
	});

	unwrapExports(toSequenceExpression_1);

	var toStatement_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = toStatement;





	function toStatement(node, ignore) {
	  if ((0, generated.isStatement)(node)) {
	    return node;
	  }

	  let mustHaveId = false;
	  let newType;

	  if ((0, generated.isClass)(node)) {
	    mustHaveId = true;
	    newType = "ClassDeclaration";
	  } else if ((0, generated.isFunction)(node)) {
	    mustHaveId = true;
	    newType = "FunctionDeclaration";
	  } else if ((0, generated.isAssignmentExpression)(node)) {
	    return (0, generated$1.expressionStatement)(node);
	  }

	  if (mustHaveId && !node.id) {
	    newType = false;
	  }

	  if (!newType) {
	    if (ignore) {
	      return false;
	    } else {
	      throw new Error(`cannot turn ${node.type} to a statement`);
	    }
	  }

	  node.type = newType;
	  return node;
	}
	});

	unwrapExports(toStatement_1);

	/** `Object#toString` result references. */
	var objectTag$3 = '[object Object]';

	/** Used for built-in method references. */
	var funcProto$2 = Function.prototype,
	    objectProto$d = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString$2 = funcProto$2.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty$a = objectProto$d.hasOwnProperty;

	/** Used to infer the `Object` constructor. */
	var objectCtorString = funcToString$2.call(Object);

	/**
	 * Checks if `value` is a plain object, that is, an object created by the
	 * `Object` constructor or one with a `[[Prototype]]` of `null`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.8.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 * }
	 *
	 * _.isPlainObject(new Foo);
	 * // => false
	 *
	 * _.isPlainObject([1, 2, 3]);
	 * // => false
	 *
	 * _.isPlainObject({ 'x': 0, 'y': 0 });
	 * // => true
	 *
	 * _.isPlainObject(Object.create(null));
	 * // => true
	 */
	function isPlainObject(value) {
	  if (!isObjectLike_1(value) || _baseGetTag(value) != objectTag$3) {
	    return false;
	  }
	  var proto = _getPrototype(value);
	  if (proto === null) {
	    return true;
	  }
	  var Ctor = hasOwnProperty$a.call(proto, 'constructor') && proto.constructor;
	  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
	    funcToString$2.call(Ctor) == objectCtorString;
	}

	var isPlainObject_1 = isPlainObject;

	/** `Object#toString` result references. */
	var regexpTag$3 = '[object RegExp]';

	/**
	 * The base implementation of `_.isRegExp` without Node.js optimizations.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
	 */
	function baseIsRegExp(value) {
	  return isObjectLike_1(value) && _baseGetTag(value) == regexpTag$3;
	}

	var _baseIsRegExp = baseIsRegExp;

	/* Node.js helper references. */
	var nodeIsRegExp = _nodeUtil && _nodeUtil.isRegExp;

	/**
	 * Checks if `value` is classified as a `RegExp` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
	 * @example
	 *
	 * _.isRegExp(/abc/);
	 * // => true
	 *
	 * _.isRegExp('/abc/');
	 * // => false
	 */
	var isRegExp = nodeIsRegExp ? _baseUnary(nodeIsRegExp) : _baseIsRegExp;

	var isRegExp_1 = isRegExp;

	var valueToNode_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = valueToNode;

	var _isPlainObject = _interopRequireDefault(isPlainObject_1);

	var _isRegExp = _interopRequireDefault(isRegExp_1);

	var _isValidIdentifier = _interopRequireDefault(isValidIdentifier_1);



	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function valueToNode(value) {
	  if (value === undefined) {
	    return (0, generated$1.identifier)("undefined");
	  }

	  if (value === true || value === false) {
	    return (0, generated$1.booleanLiteral)(value);
	  }

	  if (value === null) {
	    return (0, generated$1.nullLiteral)();
	  }

	  if (typeof value === "string") {
	    return (0, generated$1.stringLiteral)(value);
	  }

	  if (typeof value === "number") {
	    let result;

	    if (Number.isFinite(value)) {
	      result = (0, generated$1.numericLiteral)(Math.abs(value));
	    } else {
	      let numerator;

	      if (Number.isNaN(value)) {
	        numerator = (0, generated$1.numericLiteral)(0);
	      } else {
	        numerator = (0, generated$1.numericLiteral)(1);
	      }

	      result = (0, generated$1.binaryExpression)("/", numerator, (0, generated$1.numericLiteral)(0));
	    }

	    if (value < 0 || Object.is(value, -0)) {
	      result = (0, generated$1.unaryExpression)("-", result);
	    }

	    return result;
	  }

	  if ((0, _isRegExp.default)(value)) {
	    const pattern = value.source;
	    const flags = value.toString().match(/\/([a-z]+|)$/)[1];
	    return (0, generated$1.regExpLiteral)(pattern, flags);
	  }

	  if (Array.isArray(value)) {
	    return (0, generated$1.arrayExpression)(value.map(valueToNode));
	  }

	  if ((0, _isPlainObject.default)(value)) {
	    const props = [];

	    for (const key of Object.keys(value)) {
	      let nodeKey;

	      if ((0, _isValidIdentifier.default)(key)) {
	        nodeKey = (0, generated$1.identifier)(key);
	      } else {
	        nodeKey = (0, generated$1.stringLiteral)(key);
	      }

	      props.push((0, generated$1.objectProperty)(nodeKey, valueToNode(value[key])));
	    }

	    return (0, generated$1.objectExpression)(props);
	  }

	  throw new Error("don't know how to turn this value into a node");
	}
	});

	unwrapExports(valueToNode_1);

	var appendToMemberExpression_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = appendToMemberExpression;



	function appendToMemberExpression(member, append, computed = false) {
	  member.object = (0, generated$1.memberExpression)(member.object, member.property, member.computed);
	  member.property = append;
	  member.computed = !!computed;
	  return member;
	}
	});

	unwrapExports(appendToMemberExpression_1);

	var inherits_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = inherits;



	var _inheritsComments = _interopRequireDefault(inheritsComments_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function inherits(child, parent) {
	  if (!child || !parent) return child;

	  for (const key of constants.INHERIT_KEYS.optional) {
	    if (child[key] == null) {
	      child[key] = parent[key];
	    }
	  }

	  for (const key of Object.keys(parent)) {
	    if (key[0] === "_" && key !== "__clone") child[key] = parent[key];
	  }

	  for (const key of constants.INHERIT_KEYS.force) {
	    child[key] = parent[key];
	  }

	  (0, _inheritsComments.default)(child, parent);
	  return child;
	}
	});

	unwrapExports(inherits_1);

	var prependToMemberExpression_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = prependToMemberExpression;



	function prependToMemberExpression(member, prepend) {
	  member.object = (0, generated$1.memberExpression)(prepend, member.object);
	  return member;
	}
	});

	unwrapExports(prependToMemberExpression_1);

	var getOuterBindingIdentifiers_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = getOuterBindingIdentifiers;

	var _getBindingIdentifiers = _interopRequireDefault(getBindingIdentifiers_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function getOuterBindingIdentifiers(node, duplicates) {
	  return (0, _getBindingIdentifiers.default)(node, duplicates, true);
	}
	});

	unwrapExports(getOuterBindingIdentifiers_1);

	var traverse_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = traverse;



	function traverse(node, handlers, state) {
	  if (typeof handlers === "function") {
	    handlers = {
	      enter: handlers
	    };
	  }

	  const {
	    enter,
	    exit
	  } = handlers;
	  traverseSimpleImpl(node, enter, exit, state, []);
	}

	function traverseSimpleImpl(node, enter, exit, state, ancestors) {
	  const keys = definitions.VISITOR_KEYS[node.type];
	  if (!keys) return;
	  if (enter) enter(node, ancestors, state);

	  for (const key of keys) {
	    const subNode = node[key];

	    if (Array.isArray(subNode)) {
	      for (let i = 0; i < subNode.length; i++) {
	        const child = subNode[i];
	        if (!child) continue;
	        ancestors.push({
	          node,
	          key,
	          index: i
	        });
	        traverseSimpleImpl(child, enter, exit, state, ancestors);
	        ancestors.pop();
	      }
	    } else if (subNode) {
	      ancestors.push({
	        node,
	        key
	      });
	      traverseSimpleImpl(subNode, enter, exit, state, ancestors);
	      ancestors.pop();
	    }
	  }

	  if (exit) exit(node, ancestors, state);
	}
	});

	unwrapExports(traverse_1);

	var isBinding_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isBinding;

	var _getBindingIdentifiers = _interopRequireDefault(getBindingIdentifiers_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function isBinding(node, parent, grandparent) {
	  if (grandparent && node.type === "Identifier" && parent.type === "ObjectProperty" && grandparent.type === "ObjectExpression") {
	    return false;
	  }

	  const keys = _getBindingIdentifiers.default.keys[parent.type];

	  if (keys) {
	    for (let i = 0; i < keys.length; i++) {
	      const key = keys[i];
	      const val = parent[key];

	      if (Array.isArray(val)) {
	        if (val.indexOf(node) >= 0) return true;
	      } else {
	        if (val === node) return true;
	      }
	    }
	  }

	  return false;
	}
	});

	unwrapExports(isBinding_1);

	var isLet_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isLet;





	function isLet(node) {
	  return (0, generated.isVariableDeclaration)(node) && (node.kind !== "var" || node[constants.BLOCK_SCOPED_SYMBOL]);
	}
	});

	unwrapExports(isLet_1);

	var isBlockScoped_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isBlockScoped;



	var _isLet = _interopRequireDefault(isLet_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function isBlockScoped(node) {
	  return (0, generated.isFunctionDeclaration)(node) || (0, generated.isClassDeclaration)(node) || (0, _isLet.default)(node);
	}
	});

	unwrapExports(isBlockScoped_1);

	var isImmutable_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isImmutable;

	var _isType = _interopRequireDefault(isType_1);



	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function isImmutable(node) {
	  if ((0, _isType.default)(node.type, "Immutable")) return true;

	  if ((0, generated.isIdentifier)(node)) {
	    if (node.name === "undefined") {
	      return true;
	    } else {
	      return false;
	    }
	  }

	  return false;
	}
	});

	unwrapExports(isImmutable_1);

	var isNodesEquivalent_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isNodesEquivalent;



	function isNodesEquivalent(a, b) {
	  if (typeof a !== "object" || typeof b !== "object" || a == null || b == null) {
	    return a === b;
	  }

	  if (a.type !== b.type) {
	    return false;
	  }

	  const fields = Object.keys(definitions.NODE_FIELDS[a.type] || a.type);
	  const visitorKeys = definitions.VISITOR_KEYS[a.type];

	  for (const field of fields) {
	    if (typeof a[field] !== typeof b[field]) {
	      return false;
	    }

	    if (a[field] == null && b[field] == null) {
	      continue;
	    } else if (a[field] == null || b[field] == null) {
	      return false;
	    }

	    if (Array.isArray(a[field])) {
	      if (!Array.isArray(b[field])) {
	        return false;
	      }

	      if (a[field].length !== b[field].length) {
	        return false;
	      }

	      for (let i = 0; i < a[field].length; i++) {
	        if (!isNodesEquivalent(a[field][i], b[field][i])) {
	          return false;
	        }
	      }

	      continue;
	    }

	    if (typeof a[field] === "object" && !(visitorKeys == null ? void 0 : visitorKeys.includes(field))) {
	      for (const key of Object.keys(a[field])) {
	        if (a[field][key] !== b[field][key]) {
	          return false;
	        }
	      }

	      continue;
	    }

	    if (!isNodesEquivalent(a[field], b[field])) {
	      return false;
	    }
	  }

	  return true;
	}
	});

	unwrapExports(isNodesEquivalent_1);

	var isReferenced_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isReferenced;

	function isReferenced(node, parent, grandparent) {
	  switch (parent.type) {
	    case "MemberExpression":
	    case "JSXMemberExpression":
	    case "OptionalMemberExpression":
	      if (parent.property === node) {
	        return !!parent.computed;
	      }

	      return parent.object === node;

	    case "VariableDeclarator":
	      return parent.init === node;

	    case "ArrowFunctionExpression":
	      return parent.body === node;

	    case "ExportSpecifier":
	      if (parent.source) {
	        return false;
	      }

	      return parent.local === node;

	    case "PrivateName":
	      return false;

	    case "ClassMethod":
	    case "ClassPrivateMethod":
	    case "ObjectMethod":
	      if (parent.params.includes(node)) {
	        return false;
	      }

	    case "ObjectProperty":
	    case "ClassProperty":
	    case "ClassPrivateProperty":
	      if (parent.key === node) {
	        return !!parent.computed;
	      }

	      if (parent.value === node) {
	        return !grandparent || grandparent.type !== "ObjectPattern";
	      }

	      return true;

	    case "ClassDeclaration":
	    case "ClassExpression":
	      return parent.superClass === node;

	    case "AssignmentExpression":
	      return parent.right === node;

	    case "AssignmentPattern":
	      return parent.right === node;

	    case "LabeledStatement":
	      return false;

	    case "CatchClause":
	      return false;

	    case "RestElement":
	      return false;

	    case "BreakStatement":
	    case "ContinueStatement":
	      return false;

	    case "FunctionDeclaration":
	    case "FunctionExpression":
	      return false;

	    case "ExportNamespaceSpecifier":
	    case "ExportDefaultSpecifier":
	      return false;

	    case "ImportDefaultSpecifier":
	    case "ImportNamespaceSpecifier":
	    case "ImportSpecifier":
	      return false;

	    case "JSXAttribute":
	      return false;

	    case "ObjectPattern":
	    case "ArrayPattern":
	      return false;

	    case "MetaProperty":
	      return false;

	    case "ObjectTypeProperty":
	      return parent.key !== node;

	    case "TSEnumMember":
	      return parent.id !== node;

	    case "TSPropertySignature":
	      if (parent.key === node) {
	        return !!parent.computed;
	      }

	      return true;
	  }

	  return true;
	}
	});

	unwrapExports(isReferenced_1);

	var isScope_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isScope;



	function isScope(node, parent) {
	  if ((0, generated.isBlockStatement)(node) && ((0, generated.isFunction)(parent) || (0, generated.isCatchClause)(parent))) {
	    return false;
	  }

	  if ((0, generated.isPattern)(node) && ((0, generated.isFunction)(parent) || (0, generated.isCatchClause)(parent))) {
	    return true;
	  }

	  return (0, generated.isScopable)(node);
	}
	});

	unwrapExports(isScope_1);

	var isSpecifierDefault_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isSpecifierDefault;



	function isSpecifierDefault(specifier) {
	  return (0, generated.isImportDefaultSpecifier)(specifier) || (0, generated.isIdentifier)(specifier.imported || specifier.exported, {
	    name: "default"
	  });
	}
	});

	unwrapExports(isSpecifierDefault_1);

	var isValidES3Identifier_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isValidES3Identifier;

	var _isValidIdentifier = _interopRequireDefault(isValidIdentifier_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	const RESERVED_WORDS_ES3_ONLY = new Set(["abstract", "boolean", "byte", "char", "double", "enum", "final", "float", "goto", "implements", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "volatile"]);

	function isValidES3Identifier(name) {
	  return (0, _isValidIdentifier.default)(name) && !RESERVED_WORDS_ES3_ONLY.has(name);
	}
	});

	unwrapExports(isValidES3Identifier_1);

	var isVar_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = isVar;





	function isVar(node) {
	  return (0, generated.isVariableDeclaration)(node, {
	    kind: "var"
	  }) && !node[constants.BLOCK_SCOPED_SYMBOL];
	}
	});

	unwrapExports(isVar_1);

	var lib$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	var _exportNames = {
	  react: true,
	  assertNode: true,
	  createTypeAnnotationBasedOnTypeof: true,
	  createUnionTypeAnnotation: true,
	  createFlowUnionType: true,
	  createTSUnionType: true,
	  cloneNode: true,
	  clone: true,
	  cloneDeep: true,
	  cloneDeepWithoutLoc: true,
	  cloneWithoutLoc: true,
	  addComment: true,
	  addComments: true,
	  inheritInnerComments: true,
	  inheritLeadingComments: true,
	  inheritsComments: true,
	  inheritTrailingComments: true,
	  removeComments: true,
	  ensureBlock: true,
	  toBindingIdentifierName: true,
	  toBlock: true,
	  toComputedKey: true,
	  toExpression: true,
	  toIdentifier: true,
	  toKeyAlias: true,
	  toSequenceExpression: true,
	  toStatement: true,
	  valueToNode: true,
	  appendToMemberExpression: true,
	  inherits: true,
	  prependToMemberExpression: true,
	  removeProperties: true,
	  removePropertiesDeep: true,
	  removeTypeDuplicates: true,
	  getBindingIdentifiers: true,
	  getOuterBindingIdentifiers: true,
	  traverse: true,
	  traverseFast: true,
	  shallowEqual: true,
	  is: true,
	  isBinding: true,
	  isBlockScoped: true,
	  isImmutable: true,
	  isLet: true,
	  isNode: true,
	  isNodesEquivalent: true,
	  isPlaceholderType: true,
	  isReferenced: true,
	  isScope: true,
	  isSpecifierDefault: true,
	  isType: true,
	  isValidES3Identifier: true,
	  isValidIdentifier: true,
	  isVar: true,
	  matchesPattern: true,
	  validate: true,
	  buildMatchMemberExpression: true
	};
	Object.defineProperty(exports, "assertNode", {
	  enumerable: true,
	  get: function () {
	    return _assertNode.default;
	  }
	});
	Object.defineProperty(exports, "createTypeAnnotationBasedOnTypeof", {
	  enumerable: true,
	  get: function () {
	    return _createTypeAnnotationBasedOnTypeof.default;
	  }
	});
	Object.defineProperty(exports, "createUnionTypeAnnotation", {
	  enumerable: true,
	  get: function () {
	    return _createFlowUnionType.default;
	  }
	});
	Object.defineProperty(exports, "createFlowUnionType", {
	  enumerable: true,
	  get: function () {
	    return _createFlowUnionType.default;
	  }
	});
	Object.defineProperty(exports, "createTSUnionType", {
	  enumerable: true,
	  get: function () {
	    return _createTSUnionType.default;
	  }
	});
	Object.defineProperty(exports, "cloneNode", {
	  enumerable: true,
	  get: function () {
	    return _cloneNode.default;
	  }
	});
	Object.defineProperty(exports, "clone", {
	  enumerable: true,
	  get: function () {
	    return _clone.default;
	  }
	});
	Object.defineProperty(exports, "cloneDeep", {
	  enumerable: true,
	  get: function () {
	    return _cloneDeep.default;
	  }
	});
	Object.defineProperty(exports, "cloneDeepWithoutLoc", {
	  enumerable: true,
	  get: function () {
	    return _cloneDeepWithoutLoc.default;
	  }
	});
	Object.defineProperty(exports, "cloneWithoutLoc", {
	  enumerable: true,
	  get: function () {
	    return _cloneWithoutLoc.default;
	  }
	});
	Object.defineProperty(exports, "addComment", {
	  enumerable: true,
	  get: function () {
	    return _addComment.default;
	  }
	});
	Object.defineProperty(exports, "addComments", {
	  enumerable: true,
	  get: function () {
	    return _addComments.default;
	  }
	});
	Object.defineProperty(exports, "inheritInnerComments", {
	  enumerable: true,
	  get: function () {
	    return _inheritInnerComments.default;
	  }
	});
	Object.defineProperty(exports, "inheritLeadingComments", {
	  enumerable: true,
	  get: function () {
	    return _inheritLeadingComments.default;
	  }
	});
	Object.defineProperty(exports, "inheritsComments", {
	  enumerable: true,
	  get: function () {
	    return _inheritsComments.default;
	  }
	});
	Object.defineProperty(exports, "inheritTrailingComments", {
	  enumerable: true,
	  get: function () {
	    return _inheritTrailingComments.default;
	  }
	});
	Object.defineProperty(exports, "removeComments", {
	  enumerable: true,
	  get: function () {
	    return _removeComments.default;
	  }
	});
	Object.defineProperty(exports, "ensureBlock", {
	  enumerable: true,
	  get: function () {
	    return _ensureBlock.default;
	  }
	});
	Object.defineProperty(exports, "toBindingIdentifierName", {
	  enumerable: true,
	  get: function () {
	    return _toBindingIdentifierName.default;
	  }
	});
	Object.defineProperty(exports, "toBlock", {
	  enumerable: true,
	  get: function () {
	    return _toBlock.default;
	  }
	});
	Object.defineProperty(exports, "toComputedKey", {
	  enumerable: true,
	  get: function () {
	    return _toComputedKey.default;
	  }
	});
	Object.defineProperty(exports, "toExpression", {
	  enumerable: true,
	  get: function () {
	    return _toExpression.default;
	  }
	});
	Object.defineProperty(exports, "toIdentifier", {
	  enumerable: true,
	  get: function () {
	    return _toIdentifier.default;
	  }
	});
	Object.defineProperty(exports, "toKeyAlias", {
	  enumerable: true,
	  get: function () {
	    return _toKeyAlias.default;
	  }
	});
	Object.defineProperty(exports, "toSequenceExpression", {
	  enumerable: true,
	  get: function () {
	    return _toSequenceExpression.default;
	  }
	});
	Object.defineProperty(exports, "toStatement", {
	  enumerable: true,
	  get: function () {
	    return _toStatement.default;
	  }
	});
	Object.defineProperty(exports, "valueToNode", {
	  enumerable: true,
	  get: function () {
	    return _valueToNode.default;
	  }
	});
	Object.defineProperty(exports, "appendToMemberExpression", {
	  enumerable: true,
	  get: function () {
	    return _appendToMemberExpression.default;
	  }
	});
	Object.defineProperty(exports, "inherits", {
	  enumerable: true,
	  get: function () {
	    return _inherits.default;
	  }
	});
	Object.defineProperty(exports, "prependToMemberExpression", {
	  enumerable: true,
	  get: function () {
	    return _prependToMemberExpression.default;
	  }
	});
	Object.defineProperty(exports, "removeProperties", {
	  enumerable: true,
	  get: function () {
	    return _removeProperties.default;
	  }
	});
	Object.defineProperty(exports, "removePropertiesDeep", {
	  enumerable: true,
	  get: function () {
	    return _removePropertiesDeep.default;
	  }
	});
	Object.defineProperty(exports, "removeTypeDuplicates", {
	  enumerable: true,
	  get: function () {
	    return _removeTypeDuplicates.default;
	  }
	});
	Object.defineProperty(exports, "getBindingIdentifiers", {
	  enumerable: true,
	  get: function () {
	    return _getBindingIdentifiers.default;
	  }
	});
	Object.defineProperty(exports, "getOuterBindingIdentifiers", {
	  enumerable: true,
	  get: function () {
	    return _getOuterBindingIdentifiers.default;
	  }
	});
	Object.defineProperty(exports, "traverse", {
	  enumerable: true,
	  get: function () {
	    return _traverse.default;
	  }
	});
	Object.defineProperty(exports, "traverseFast", {
	  enumerable: true,
	  get: function () {
	    return _traverseFast.default;
	  }
	});
	Object.defineProperty(exports, "shallowEqual", {
	  enumerable: true,
	  get: function () {
	    return _shallowEqual.default;
	  }
	});
	Object.defineProperty(exports, "is", {
	  enumerable: true,
	  get: function () {
	    return _is.default;
	  }
	});
	Object.defineProperty(exports, "isBinding", {
	  enumerable: true,
	  get: function () {
	    return _isBinding.default;
	  }
	});
	Object.defineProperty(exports, "isBlockScoped", {
	  enumerable: true,
	  get: function () {
	    return _isBlockScoped.default;
	  }
	});
	Object.defineProperty(exports, "isImmutable", {
	  enumerable: true,
	  get: function () {
	    return _isImmutable.default;
	  }
	});
	Object.defineProperty(exports, "isLet", {
	  enumerable: true,
	  get: function () {
	    return _isLet.default;
	  }
	});
	Object.defineProperty(exports, "isNode", {
	  enumerable: true,
	  get: function () {
	    return _isNode.default;
	  }
	});
	Object.defineProperty(exports, "isNodesEquivalent", {
	  enumerable: true,
	  get: function () {
	    return _isNodesEquivalent.default;
	  }
	});
	Object.defineProperty(exports, "isPlaceholderType", {
	  enumerable: true,
	  get: function () {
	    return _isPlaceholderType.default;
	  }
	});
	Object.defineProperty(exports, "isReferenced", {
	  enumerable: true,
	  get: function () {
	    return _isReferenced.default;
	  }
	});
	Object.defineProperty(exports, "isScope", {
	  enumerable: true,
	  get: function () {
	    return _isScope.default;
	  }
	});
	Object.defineProperty(exports, "isSpecifierDefault", {
	  enumerable: true,
	  get: function () {
	    return _isSpecifierDefault.default;
	  }
	});
	Object.defineProperty(exports, "isType", {
	  enumerable: true,
	  get: function () {
	    return _isType.default;
	  }
	});
	Object.defineProperty(exports, "isValidES3Identifier", {
	  enumerable: true,
	  get: function () {
	    return _isValidES3Identifier.default;
	  }
	});
	Object.defineProperty(exports, "isValidIdentifier", {
	  enumerable: true,
	  get: function () {
	    return _isValidIdentifier.default;
	  }
	});
	Object.defineProperty(exports, "isVar", {
	  enumerable: true,
	  get: function () {
	    return _isVar.default;
	  }
	});
	Object.defineProperty(exports, "matchesPattern", {
	  enumerable: true,
	  get: function () {
	    return _matchesPattern.default;
	  }
	});
	Object.defineProperty(exports, "validate", {
	  enumerable: true,
	  get: function () {
	    return _validate.default;
	  }
	});
	Object.defineProperty(exports, "buildMatchMemberExpression", {
	  enumerable: true,
	  get: function () {
	    return _buildMatchMemberExpression.default;
	  }
	});
	exports.react = void 0;

	var _isReactComponent = _interopRequireDefault(isReactComponent_1);

	var _isCompatTag = _interopRequireDefault(isCompatTag_1);

	var _buildChildren = _interopRequireDefault(buildChildren_1);

	var _assertNode = _interopRequireDefault(assertNode_1);



	Object.keys(generated$2).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
	  if (key in exports && exports[key] === generated$2[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return generated$2[key];
	    }
	  });
	});

	var _createTypeAnnotationBasedOnTypeof = _interopRequireDefault(createTypeAnnotationBasedOnTypeof_1);

	var _createFlowUnionType = _interopRequireDefault(createFlowUnionType_1);

	var _createTSUnionType = _interopRequireDefault(createTSUnionType_1);



	Object.keys(generated$1).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
	  if (key in exports && exports[key] === generated$1[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return generated$1[key];
	    }
	  });
	});

	var _cloneNode = _interopRequireDefault(cloneNode_1);

	var _clone = _interopRequireDefault(clone_1$1);

	var _cloneDeep = _interopRequireDefault(cloneDeep_1);

	var _cloneDeepWithoutLoc = _interopRequireDefault(cloneDeepWithoutLoc_1);

	var _cloneWithoutLoc = _interopRequireDefault(cloneWithoutLoc_1);

	var _addComment = _interopRequireDefault(addComment_1);

	var _addComments = _interopRequireDefault(addComments_1);

	var _inheritInnerComments = _interopRequireDefault(inheritInnerComments_1);

	var _inheritLeadingComments = _interopRequireDefault(inheritLeadingComments_1);

	var _inheritsComments = _interopRequireDefault(inheritsComments_1);

	var _inheritTrailingComments = _interopRequireDefault(inheritTrailingComments_1);

	var _removeComments = _interopRequireDefault(removeComments_1);



	Object.keys(generated$3).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
	  if (key in exports && exports[key] === generated$3[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return generated$3[key];
	    }
	  });
	});



	Object.keys(constants).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
	  if (key in exports && exports[key] === constants[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return constants[key];
	    }
	  });
	});

	var _ensureBlock = _interopRequireDefault(ensureBlock_1);

	var _toBindingIdentifierName = _interopRequireDefault(toBindingIdentifierName_1);

	var _toBlock = _interopRequireDefault(toBlock_1);

	var _toComputedKey = _interopRequireDefault(toComputedKey_1);

	var _toExpression = _interopRequireDefault(toExpression_1);

	var _toIdentifier = _interopRequireDefault(toIdentifier_1);

	var _toKeyAlias = _interopRequireDefault(toKeyAlias_1);

	var _toSequenceExpression = _interopRequireDefault(toSequenceExpression_1);

	var _toStatement = _interopRequireDefault(toStatement_1);

	var _valueToNode = _interopRequireDefault(valueToNode_1);



	Object.keys(definitions).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
	  if (key in exports && exports[key] === definitions[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return definitions[key];
	    }
	  });
	});

	var _appendToMemberExpression = _interopRequireDefault(appendToMemberExpression_1);

	var _inherits = _interopRequireDefault(inherits_1);

	var _prependToMemberExpression = _interopRequireDefault(prependToMemberExpression_1);

	var _removeProperties = _interopRequireDefault(removeProperties_1);

	var _removePropertiesDeep = _interopRequireDefault(removePropertiesDeep_1);

	var _removeTypeDuplicates = _interopRequireDefault(removeTypeDuplicates_1);

	var _getBindingIdentifiers = _interopRequireDefault(getBindingIdentifiers_1);

	var _getOuterBindingIdentifiers = _interopRequireDefault(getOuterBindingIdentifiers_1);

	var _traverse = _interopRequireDefault(traverse_1);

	var _traverseFast = _interopRequireDefault(traverseFast_1);

	var _shallowEqual = _interopRequireDefault(shallowEqual_1);

	var _is = _interopRequireDefault(is_1);

	var _isBinding = _interopRequireDefault(isBinding_1);

	var _isBlockScoped = _interopRequireDefault(isBlockScoped_1);

	var _isImmutable = _interopRequireDefault(isImmutable_1);

	var _isLet = _interopRequireDefault(isLet_1);

	var _isNode = _interopRequireDefault(isNode_1);

	var _isNodesEquivalent = _interopRequireDefault(isNodesEquivalent_1);

	var _isPlaceholderType = _interopRequireDefault(isPlaceholderType_1);

	var _isReferenced = _interopRequireDefault(isReferenced_1);

	var _isScope = _interopRequireDefault(isScope_1);

	var _isSpecifierDefault = _interopRequireDefault(isSpecifierDefault_1);

	var _isType = _interopRequireDefault(isType_1);

	var _isValidES3Identifier = _interopRequireDefault(isValidES3Identifier_1);

	var _isValidIdentifier = _interopRequireDefault(isValidIdentifier_1);

	var _isVar = _interopRequireDefault(isVar_1);

	var _matchesPattern = _interopRequireDefault(matchesPattern_1);

	var _validate = _interopRequireDefault(validate_1);

	var _buildMatchMemberExpression = _interopRequireDefault(buildMatchMemberExpression_1);



	Object.keys(generated).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
	  if (key in exports && exports[key] === generated[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return generated[key];
	    }
	  });
	});

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	const react = {
	  isReactComponent: _isReactComponent.default,
	  isCompatTag: _isCompatTag.default,
	  buildChildren: _buildChildren.default
	};
	exports.react = react;
	});

	unwrapExports(lib$1);
	var lib_1 = lib$1.react;

	var virtualTypes = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.ForAwaitStatement = exports.NumericLiteralTypeAnnotation = exports.ExistentialTypeParam = exports.SpreadProperty = exports.RestProperty = exports.Flow = exports.Pure = exports.Generated = exports.User = exports.Var = exports.BlockScoped = exports.Referenced = exports.Scope = exports.Expression = exports.Statement = exports.BindingIdentifier = exports.ReferencedMemberExpression = exports.ReferencedIdentifier = void 0;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	const ReferencedIdentifier = {
	  types: ["Identifier", "JSXIdentifier"],

	  checkPath(path, opts) {
	    const {
	      node,
	      parent
	    } = path;

	    if (!t.isIdentifier(node, opts) && !t.isJSXMemberExpression(parent, opts)) {
	      if (t.isJSXIdentifier(node, opts)) {
	        if (t.react.isCompatTag(node.name)) return false;
	      } else {
	        return false;
	      }
	    }

	    return t.isReferenced(node, parent, path.parentPath.parent);
	  }

	};
	exports.ReferencedIdentifier = ReferencedIdentifier;
	const ReferencedMemberExpression = {
	  types: ["MemberExpression"],

	  checkPath({
	    node,
	    parent
	  }) {
	    return t.isMemberExpression(node) && t.isReferenced(node, parent);
	  }

	};
	exports.ReferencedMemberExpression = ReferencedMemberExpression;
	const BindingIdentifier = {
	  types: ["Identifier"],

	  checkPath(path) {
	    const {
	      node,
	      parent
	    } = path;
	    const grandparent = path.parentPath.parent;
	    return t.isIdentifier(node) && t.isBinding(node, parent, grandparent);
	  }

	};
	exports.BindingIdentifier = BindingIdentifier;
	const Statement = {
	  types: ["Statement"],

	  checkPath({
	    node,
	    parent
	  }) {
	    if (t.isStatement(node)) {
	      if (t.isVariableDeclaration(node)) {
	        if (t.isForXStatement(parent, {
	          left: node
	        })) return false;
	        if (t.isForStatement(parent, {
	          init: node
	        })) return false;
	      }

	      return true;
	    } else {
	      return false;
	    }
	  }

	};
	exports.Statement = Statement;
	const Expression = {
	  types: ["Expression"],

	  checkPath(path) {
	    if (path.isIdentifier()) {
	      return path.isReferencedIdentifier();
	    } else {
	      return t.isExpression(path.node);
	    }
	  }

	};
	exports.Expression = Expression;
	const Scope = {
	  types: ["Scopable", "Pattern"],

	  checkPath(path) {
	    return t.isScope(path.node, path.parent);
	  }

	};
	exports.Scope = Scope;
	const Referenced = {
	  checkPath(path) {
	    return t.isReferenced(path.node, path.parent);
	  }

	};
	exports.Referenced = Referenced;
	const BlockScoped = {
	  checkPath(path) {
	    return t.isBlockScoped(path.node);
	  }

	};
	exports.BlockScoped = BlockScoped;
	const Var = {
	  types: ["VariableDeclaration"],

	  checkPath(path) {
	    return t.isVar(path.node);
	  }

	};
	exports.Var = Var;
	const User = {
	  checkPath(path) {
	    return path.node && !!path.node.loc;
	  }

	};
	exports.User = User;
	const Generated = {
	  checkPath(path) {
	    return !path.isUser();
	  }

	};
	exports.Generated = Generated;
	const Pure = {
	  checkPath(path, opts) {
	    return path.scope.isPure(path.node, opts);
	  }

	};
	exports.Pure = Pure;
	const Flow = {
	  types: ["Flow", "ImportDeclaration", "ExportDeclaration", "ImportSpecifier"],

	  checkPath({
	    node
	  }) {
	    if (t.isFlow(node)) {
	      return true;
	    } else if (t.isImportDeclaration(node)) {
	      return node.importKind === "type" || node.importKind === "typeof";
	    } else if (t.isExportDeclaration(node)) {
	      return node.exportKind === "type";
	    } else if (t.isImportSpecifier(node)) {
	      return node.importKind === "type" || node.importKind === "typeof";
	    } else {
	      return false;
	    }
	  }

	};
	exports.Flow = Flow;
	const RestProperty = {
	  types: ["RestElement"],

	  checkPath(path) {
	    return path.parentPath && path.parentPath.isObjectPattern();
	  }

	};
	exports.RestProperty = RestProperty;
	const SpreadProperty = {
	  types: ["RestElement"],

	  checkPath(path) {
	    return path.parentPath && path.parentPath.isObjectExpression();
	  }

	};
	exports.SpreadProperty = SpreadProperty;
	const ExistentialTypeParam = {
	  types: ["ExistsTypeAnnotation"]
	};
	exports.ExistentialTypeParam = ExistentialTypeParam;
	const NumericLiteralTypeAnnotation = {
	  types: ["NumberLiteralTypeAnnotation"]
	};
	exports.NumericLiteralTypeAnnotation = NumericLiteralTypeAnnotation;
	const ForAwaitStatement = {
	  types: ["ForOfStatement"],

	  checkPath({
	    node
	  }) {
	    return node.await === true;
	  }

	};
	exports.ForAwaitStatement = ForAwaitStatement;
	});

	unwrapExports(virtualTypes);
	var virtualTypes_1 = virtualTypes.ForAwaitStatement;
	var virtualTypes_2 = virtualTypes.NumericLiteralTypeAnnotation;
	var virtualTypes_3 = virtualTypes.ExistentialTypeParam;
	var virtualTypes_4 = virtualTypes.SpreadProperty;
	var virtualTypes_5 = virtualTypes.RestProperty;
	var virtualTypes_6 = virtualTypes.Flow;
	var virtualTypes_7 = virtualTypes.Pure;
	var virtualTypes_8 = virtualTypes.Generated;
	var virtualTypes_9 = virtualTypes.User;
	var virtualTypes_10 = virtualTypes.Var;
	var virtualTypes_11 = virtualTypes.BlockScoped;
	var virtualTypes_12 = virtualTypes.Referenced;
	var virtualTypes_13 = virtualTypes.Scope;
	var virtualTypes_14 = virtualTypes.Expression;
	var virtualTypes_15 = virtualTypes.Statement;
	var virtualTypes_16 = virtualTypes.BindingIdentifier;
	var virtualTypes_17 = virtualTypes.ReferencedMemberExpression;
	var virtualTypes_18 = virtualTypes.ReferencedIdentifier;

	var browser$1 = true;

	/**
	 * Helpers.
	 */

	var s = 1000;
	var m = s * 60;
	var h = m * 60;
	var d = h * 24;
	var w = d * 7;
	var y = d * 365.25;

	/**
	 * Parse or format the given `val`.
	 *
	 * Options:
	 *
	 *  - `long` verbose formatting [false]
	 *
	 * @param {String|Number} val
	 * @param {Object} [options]
	 * @throws {Error} throw an error if val is not a non-empty string or a number
	 * @return {String|Number}
	 * @api public
	 */

	var ms = function(val, options) {
	  options = options || {};
	  var type = typeof val;
	  if (type === 'string' && val.length > 0) {
	    return parse(val);
	  } else if (type === 'number' && isFinite(val)) {
	    return options.long ? fmtLong(val) : fmtShort(val);
	  }
	  throw new Error(
	    'val is not a non-empty string or a valid number. val=' +
	      JSON.stringify(val)
	  );
	};

	/**
	 * Parse the given `str` and return milliseconds.
	 *
	 * @param {String} str
	 * @return {Number}
	 * @api private
	 */

	function parse(str) {
	  str = String(str);
	  if (str.length > 100) {
	    return;
	  }
	  var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
	    str
	  );
	  if (!match) {
	    return;
	  }
	  var n = parseFloat(match[1]);
	  var type = (match[2] || 'ms').toLowerCase();
	  switch (type) {
	    case 'years':
	    case 'year':
	    case 'yrs':
	    case 'yr':
	    case 'y':
	      return n * y;
	    case 'weeks':
	    case 'week':
	    case 'w':
	      return n * w;
	    case 'days':
	    case 'day':
	    case 'd':
	      return n * d;
	    case 'hours':
	    case 'hour':
	    case 'hrs':
	    case 'hr':
	    case 'h':
	      return n * h;
	    case 'minutes':
	    case 'minute':
	    case 'mins':
	    case 'min':
	    case 'm':
	      return n * m;
	    case 'seconds':
	    case 'second':
	    case 'secs':
	    case 'sec':
	    case 's':
	      return n * s;
	    case 'milliseconds':
	    case 'millisecond':
	    case 'msecs':
	    case 'msec':
	    case 'ms':
	      return n;
	    default:
	      return undefined;
	  }
	}

	/**
	 * Short format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtShort(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return Math.round(ms / d) + 'd';
	  }
	  if (msAbs >= h) {
	    return Math.round(ms / h) + 'h';
	  }
	  if (msAbs >= m) {
	    return Math.round(ms / m) + 'm';
	  }
	  if (msAbs >= s) {
	    return Math.round(ms / s) + 's';
	  }
	  return ms + 'ms';
	}

	/**
	 * Long format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtLong(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return plural(ms, msAbs, d, 'day');
	  }
	  if (msAbs >= h) {
	    return plural(ms, msAbs, h, 'hour');
	  }
	  if (msAbs >= m) {
	    return plural(ms, msAbs, m, 'minute');
	  }
	  if (msAbs >= s) {
	    return plural(ms, msAbs, s, 'second');
	  }
	  return ms + ' ms';
	}

	/**
	 * Pluralization helper.
	 */

	function plural(ms, msAbs, n, name) {
	  var isPlural = msAbs >= n * 1.5;
	  return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
	}

	/**
	 * This is the common logic for both the Node.js and web browser
	 * implementations of `debug()`.
	 */

	function setup(env) {
		createDebug.debug = createDebug;
		createDebug.default = createDebug;
		createDebug.coerce = coerce;
		createDebug.disable = disable;
		createDebug.enable = enable;
		createDebug.enabled = enabled;
		createDebug.humanize = ms;
		createDebug.destroy = destroy;

		Object.keys(env).forEach(key => {
			createDebug[key] = env[key];
		});

		/**
		* The currently active debug mode names, and names to skip.
		*/

		createDebug.names = [];
		createDebug.skips = [];

		/**
		* Map of special "%n" handling functions, for the debug "format" argument.
		*
		* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
		*/
		createDebug.formatters = {};

		/**
		* Selects a color for a debug namespace
		* @param {String} namespace The namespace string for the for the debug instance to be colored
		* @return {Number|String} An ANSI color code for the given namespace
		* @api private
		*/
		function selectColor(namespace) {
			let hash = 0;

			for (let i = 0; i < namespace.length; i++) {
				hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
				hash |= 0; // Convert to 32bit integer
			}

			return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
		}
		createDebug.selectColor = selectColor;

		/**
		* Create a debugger with the given `namespace`.
		*
		* @param {String} namespace
		* @return {Function}
		* @api public
		*/
		function createDebug(namespace) {
			let prevTime;
			let enableOverride = null;

			function debug(...args) {
				// Disabled?
				if (!debug.enabled) {
					return;
				}

				const self = debug;

				// Set `diff` timestamp
				const curr = Number(new Date());
				const ms = curr - (prevTime || curr);
				self.diff = ms;
				self.prev = prevTime;
				self.curr = curr;
				prevTime = curr;

				args[0] = createDebug.coerce(args[0]);

				if (typeof args[0] !== 'string') {
					// Anything else let's inspect with %O
					args.unshift('%O');
				}

				// Apply any `formatters` transformations
				let index = 0;
				args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
					// If we encounter an escaped % then don't increase the array index
					if (match === '%%') {
						return '%';
					}
					index++;
					const formatter = createDebug.formatters[format];
					if (typeof formatter === 'function') {
						const val = args[index];
						match = formatter.call(self, val);

						// Now we need to remove `args[index]` since it's inlined in the `format`
						args.splice(index, 1);
						index--;
					}
					return match;
				});

				// Apply env-specific formatting (colors, etc.)
				createDebug.formatArgs.call(self, args);

				const logFn = self.log || createDebug.log;
				logFn.apply(self, args);
			}

			debug.namespace = namespace;
			debug.useColors = createDebug.useColors();
			debug.color = createDebug.selectColor(namespace);
			debug.extend = extend;
			debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

			Object.defineProperty(debug, 'enabled', {
				enumerable: true,
				configurable: false,
				get: () => enableOverride === null ? createDebug.enabled(namespace) : enableOverride,
				set: v => {
					enableOverride = v;
				}
			});

			// Env-specific initialization logic for debug instances
			if (typeof createDebug.init === 'function') {
				createDebug.init(debug);
			}

			return debug;
		}

		function extend(namespace, delimiter) {
			const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
			newDebug.log = this.log;
			return newDebug;
		}

		/**
		* Enables a debug mode by namespaces. This can include modes
		* separated by a colon and wildcards.
		*
		* @param {String} namespaces
		* @api public
		*/
		function enable(namespaces) {
			createDebug.save(namespaces);

			createDebug.names = [];
			createDebug.skips = [];

			let i;
			const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
			const len = split.length;

			for (i = 0; i < len; i++) {
				if (!split[i]) {
					// ignore empty strings
					continue;
				}

				namespaces = split[i].replace(/\*/g, '.*?');

				if (namespaces[0] === '-') {
					createDebug.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
				} else {
					createDebug.names.push(new RegExp('^' + namespaces + '$'));
				}
			}
		}

		/**
		* Disable debug output.
		*
		* @return {String} namespaces
		* @api public
		*/
		function disable() {
			const namespaces = [
				...createDebug.names.map(toNamespace),
				...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
			].join(',');
			createDebug.enable('');
			return namespaces;
		}

		/**
		* Returns true if the given mode name is enabled, false otherwise.
		*
		* @param {String} name
		* @return {Boolean}
		* @api public
		*/
		function enabled(name) {
			if (name[name.length - 1] === '*') {
				return true;
			}

			let i;
			let len;

			for (i = 0, len = createDebug.skips.length; i < len; i++) {
				if (createDebug.skips[i].test(name)) {
					return false;
				}
			}

			for (i = 0, len = createDebug.names.length; i < len; i++) {
				if (createDebug.names[i].test(name)) {
					return true;
				}
			}

			return false;
		}

		/**
		* Convert regexp to namespace
		*
		* @param {RegExp} regxep
		* @return {String} namespace
		* @api private
		*/
		function toNamespace(regexp) {
			return regexp.toString()
				.substring(2, regexp.toString().length - 2)
				.replace(/\.\*\?$/, '*');
		}

		/**
		* Coerce `val`.
		*
		* @param {Mixed} val
		* @return {Mixed}
		* @api private
		*/
		function coerce(val) {
			if (val instanceof Error) {
				return val.stack || val.message;
			}
			return val;
		}

		/**
		* XXX DO NOT USE. This is a temporary stub function.
		* XXX It WILL be removed in the next major release.
		*/
		function destroy() {
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}

		createDebug.enable(createDebug.load());

		return createDebug;
	}

	var common = setup;

	var browser$2 = createCommonjsModule(function (module, exports) {
	/* eslint-env browser */

	/**
	 * This is the web browser implementation of `debug()`.
	 */

	exports.formatArgs = formatArgs;
	exports.save = save;
	exports.load = load;
	exports.useColors = useColors;
	exports.storage = localstorage();
	exports.destroy = (() => {
		let warned = false;

		return () => {
			if (!warned) {
				warned = true;
				console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
			}
		};
	})();

	/**
	 * Colors.
	 */

	exports.colors = [
		'#0000CC',
		'#0000FF',
		'#0033CC',
		'#0033FF',
		'#0066CC',
		'#0066FF',
		'#0099CC',
		'#0099FF',
		'#00CC00',
		'#00CC33',
		'#00CC66',
		'#00CC99',
		'#00CCCC',
		'#00CCFF',
		'#3300CC',
		'#3300FF',
		'#3333CC',
		'#3333FF',
		'#3366CC',
		'#3366FF',
		'#3399CC',
		'#3399FF',
		'#33CC00',
		'#33CC33',
		'#33CC66',
		'#33CC99',
		'#33CCCC',
		'#33CCFF',
		'#6600CC',
		'#6600FF',
		'#6633CC',
		'#6633FF',
		'#66CC00',
		'#66CC33',
		'#9900CC',
		'#9900FF',
		'#9933CC',
		'#9933FF',
		'#99CC00',
		'#99CC33',
		'#CC0000',
		'#CC0033',
		'#CC0066',
		'#CC0099',
		'#CC00CC',
		'#CC00FF',
		'#CC3300',
		'#CC3333',
		'#CC3366',
		'#CC3399',
		'#CC33CC',
		'#CC33FF',
		'#CC6600',
		'#CC6633',
		'#CC9900',
		'#CC9933',
		'#CCCC00',
		'#CCCC33',
		'#FF0000',
		'#FF0033',
		'#FF0066',
		'#FF0099',
		'#FF00CC',
		'#FF00FF',
		'#FF3300',
		'#FF3333',
		'#FF3366',
		'#FF3399',
		'#FF33CC',
		'#FF33FF',
		'#FF6600',
		'#FF6633',
		'#FF9900',
		'#FF9933',
		'#FFCC00',
		'#FFCC33'
	];

	/**
	 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
	 * and the Firebug extension (any Firefox version) are known
	 * to support "%c" CSS customizations.
	 *
	 * TODO: add a `localStorage` variable to explicitly enable/disable colors
	 */

	// eslint-disable-next-line complexity
	function useColors() {
		// NB: In an Electron preload script, document will be defined but not fully
		// initialized. Since we know we're in Chrome, we'll just detect this case
		// explicitly
		if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
			return true;
		}

		// Internet Explorer and Edge do not support colors.
		if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
			return false;
		}

		// Is webkit? http://stackoverflow.com/a/16459606/376773
		// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
		return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
			// Is firebug? http://stackoverflow.com/a/398120/376773
			(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
			// Is firefox >= v31?
			// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
			(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
			// Double check webkit in userAgent just in case we are in a worker
			(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
	}

	/**
	 * Colorize log arguments if enabled.
	 *
	 * @api public
	 */

	function formatArgs(args) {
		args[0] = (this.useColors ? '%c' : '') +
			this.namespace +
			(this.useColors ? ' %c' : ' ') +
			args[0] +
			(this.useColors ? '%c ' : ' ') +
			'+' + module.exports.humanize(this.diff);

		if (!this.useColors) {
			return;
		}

		const c = 'color: ' + this.color;
		args.splice(1, 0, c, 'color: inherit');

		// The final "%c" is somewhat tricky, because there could be other
		// arguments passed either before or after the %c, so we need to
		// figure out the correct index to insert the CSS into
		let index = 0;
		let lastC = 0;
		args[0].replace(/%[a-zA-Z%]/g, match => {
			if (match === '%%') {
				return;
			}
			index++;
			if (match === '%c') {
				// We only are interested in the *last* %c
				// (the user may have provided their own)
				lastC = index;
			}
		});

		args.splice(lastC, 0, c);
	}

	/**
	 * Invokes `console.debug()` when available.
	 * No-op when `console.debug` is not a "function".
	 * If `console.debug` is not available, falls back
	 * to `console.log`.
	 *
	 * @api public
	 */
	exports.log = console.debug || console.log || (() => {});

	/**
	 * Save `namespaces`.
	 *
	 * @param {String} namespaces
	 * @api private
	 */
	function save(namespaces) {
		try {
			if (namespaces) {
				exports.storage.setItem('debug', namespaces);
			} else {
				exports.storage.removeItem('debug');
			}
		} catch (error) {
			// Swallow
			// XXX (@Qix-) should we be logging these?
		}
	}

	/**
	 * Load `namespaces`.
	 *
	 * @return {String} returns the previously persisted debug modes
	 * @api private
	 */
	function load() {
		let r;
		try {
			r = exports.storage.getItem('debug');
		} catch (error) {
			// Swallow
			// XXX (@Qix-) should we be logging these?
		}

		// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
		if (!r && typeof process !== 'undefined' && 'env' in process) {
			r = process.env.DEBUG;
		}

		return r;
	}

	/**
	 * Localstorage attempts to return the localstorage.
	 *
	 * This is necessary because safari throws
	 * when a user disables cookies/localstorage
	 * and you attempt to access it.
	 *
	 * @return {LocalStorage}
	 * @api private
	 */

	function localstorage() {
		try {
			// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
			// The Browser also has localStorage in the global context.
			return localStorage;
		} catch (error) {
			// Swallow
			// XXX (@Qix-) should we be logging these?
		}
	}

	module.exports = common(exports);

	const {formatters} = module.exports;

	/**
	 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
	 */

	formatters.j = function (v) {
		try {
			return JSON.stringify(v);
		} catch (error) {
			return '[UnexpectedJSONParseError]: ' + error.message;
		}
	};
	});
	var browser_1 = browser$2.formatArgs;
	var browser_2 = browser$2.save;
	var browser_3 = browser$2.load;
	var browser_4 = browser$2.useColors;
	var browser_5 = browser$2.storage;
	var browser_6 = browser$2.destroy;
	var browser_7 = browser$2.colors;
	var browser_8 = browser$2.log;

	// MIT lisence
	// from https://github.com/substack/tty-browserify/blob/1ba769a6429d242f36226538835b4034bf6b7886/index.js

	function isatty() {
	  return false;
	}

	function ReadStream() {
	  throw new Error('tty.ReadStream is not implemented');
	}

	function WriteStream() {
	  throw new Error('tty.ReadStream is not implemented');
	}

	var tty = {
	  isatty: isatty,
	  ReadStream: ReadStream,
	  WriteStream: WriteStream
	};

	var tty$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		isatty: isatty,
		ReadStream: ReadStream,
		WriteStream: WriteStream,
		'default': tty
	});

	var lookup = [];
	var revLookup = [];
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
	var inited = false;
	function init () {
	  inited = true;
	  var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
	  for (var i = 0, len = code.length; i < len; ++i) {
	    lookup[i] = code[i];
	    revLookup[code.charCodeAt(i)] = i;
	  }

	  revLookup['-'.charCodeAt(0)] = 62;
	  revLookup['_'.charCodeAt(0)] = 63;
	}

	function toByteArray (b64) {
	  if (!inited) {
	    init();
	  }
	  var i, j, l, tmp, placeHolders, arr;
	  var len = b64.length;

	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }

	  // the number of equal signs (place holders)
	  // if there are two placeholders, than the two characters before it
	  // represent one byte
	  // if there is only one, then the three characters before it represent 2 bytes
	  // this is just a cheap hack to not do indexOf twice
	  placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

	  // base64 is 4/3 + up to two characters of the original data
	  arr = new Arr(len * 3 / 4 - placeHolders);

	  // if there are placeholders, only get up to the last complete 4 chars
	  l = placeHolders > 0 ? len - 4 : len;

	  var L = 0;

	  for (i = 0, j = 0; i < l; i += 4, j += 3) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
	    arr[L++] = (tmp >> 16) & 0xFF;
	    arr[L++] = (tmp >> 8) & 0xFF;
	    arr[L++] = tmp & 0xFF;
	  }

	  if (placeHolders === 2) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
	    arr[L++] = tmp & 0xFF;
	  } else if (placeHolders === 1) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
	    arr[L++] = (tmp >> 8) & 0xFF;
	    arr[L++] = tmp & 0xFF;
	  }

	  return arr
	}

	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
	}

	function encodeChunk (uint8, start, end) {
	  var tmp;
	  var output = [];
	  for (var i = start; i < end; i += 3) {
	    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
	    output.push(tripletToBase64(tmp));
	  }
	  return output.join('')
	}

	function fromByteArray (uint8) {
	  if (!inited) {
	    init();
	  }
	  var tmp;
	  var len = uint8.length;
	  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
	  var output = '';
	  var parts = [];
	  var maxChunkLength = 16383; // must be multiple of 3

	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
	  }

	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1];
	    output += lookup[tmp >> 2];
	    output += lookup[(tmp << 4) & 0x3F];
	    output += '==';
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
	    output += lookup[tmp >> 10];
	    output += lookup[(tmp >> 4) & 0x3F];
	    output += lookup[(tmp << 2) & 0x3F];
	    output += '=';
	  }

	  parts.push(output);

	  return parts.join('')
	}

	function read (buffer, offset, isLE, mLen, nBytes) {
	  var e, m;
	  var eLen = nBytes * 8 - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = -7;
	  var i = isLE ? (nBytes - 1) : 0;
	  var d = isLE ? -1 : 1;
	  var s = buffer[offset + i];

	  i += d;

	  e = s & ((1 << (-nBits)) - 1);
	  s >>= (-nBits);
	  nBits += eLen;
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1);
	  e >>= (-nBits);
	  nBits += mLen;
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen);
	    e = e - eBias;
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}

	function write (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c;
	  var eLen = nBytes * 8 - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
	  var i = isLE ? 0 : (nBytes - 1);
	  var d = isLE ? 1 : -1;
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

	  value = Math.abs(value);

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0;
	    e = eMax;
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2);
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * Math.pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }

	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
	      e = 0;
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128;
	}

	var toString = {}.toString;

	var isArray$1 = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};

	var INSPECT_MAX_BYTES = 50;

	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.

	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined
	  ? global$1.TYPED_ARRAY_SUPPORT
	  : true;

	/*
	 * Export kMaxLength after typed array support is determined.
	 */
	var _kMaxLength = kMaxLength();

	function kMaxLength () {
	  return Buffer.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}

	function createBuffer (that, length) {
	  if (kMaxLength() < length) {
	    throw new RangeError('Invalid typed array length')
	  }
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = new Uint8Array(length);
	    that.__proto__ = Buffer.prototype;
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    if (that === null) {
	      that = new Buffer(length);
	    }
	    that.length = length;
	  }

	  return that
	}

	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */

	function Buffer (arg, encodingOrOffset, length) {
	  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
	    return new Buffer(arg, encodingOrOffset, length)
	  }

	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new Error(
	        'If encoding is specified then the first argument must be a string'
	      )
	    }
	    return allocUnsafe(this, arg)
	  }
	  return from(this, arg, encodingOrOffset, length)
	}

	Buffer.poolSize = 8192; // not used by this implementation

	// TODO: Legacy, not needed anymore. Remove in next major version.
	Buffer._augment = function (arr) {
	  arr.__proto__ = Buffer.prototype;
	  return arr
	};

	function from (that, value, encodingOrOffset, length) {
	  if (typeof value === 'number') {
	    throw new TypeError('"value" argument must not be a number')
	  }

	  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
	    return fromArrayBuffer(that, value, encodingOrOffset, length)
	  }

	  if (typeof value === 'string') {
	    return fromString(that, value, encodingOrOffset)
	  }

	  return fromObject(that, value)
	}

	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer.from = function (value, encodingOrOffset, length) {
	  return from(null, value, encodingOrOffset, length)
	};

	if (Buffer.TYPED_ARRAY_SUPPORT) {
	  Buffer.prototype.__proto__ = Uint8Array.prototype;
	  Buffer.__proto__ = Uint8Array;
	}

	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  } else if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }
	}

	function alloc (that, size, fill, encoding) {
	  assertSize(size);
	  if (size <= 0) {
	    return createBuffer(that, size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(that, size).fill(fill, encoding)
	      : createBuffer(that, size).fill(fill)
	  }
	  return createBuffer(that, size)
	}

	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer.alloc = function (size, fill, encoding) {
	  return alloc(null, size, fill, encoding)
	};

	function allocUnsafe (that, size) {
	  assertSize(size);
	  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < size; ++i) {
	      that[i] = 0;
	    }
	  }
	  return that
	}

	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer.allocUnsafe = function (size) {
	  return allocUnsafe(null, size)
	};
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer.allocUnsafeSlow = function (size) {
	  return allocUnsafe(null, size)
	};

	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8';
	  }

	  if (!Buffer.isEncoding(encoding)) {
	    throw new TypeError('"encoding" must be a valid string encoding')
	  }

	  var length = byteLength(string, encoding) | 0;
	  that = createBuffer(that, length);

	  var actual = that.write(string, encoding);

	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    that = that.slice(0, actual);
	  }

	  return that
	}

	function fromArrayLike (that, array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0;
	  that = createBuffer(that, length);
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255;
	  }
	  return that
	}

	function fromArrayBuffer (that, array, byteOffset, length) {
	  array.byteLength; // this throws if `array` is not a valid ArrayBuffer

	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('\'offset\' is out of bounds')
	  }

	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('\'length\' is out of bounds')
	  }

	  if (byteOffset === undefined && length === undefined) {
	    array = new Uint8Array(array);
	  } else if (length === undefined) {
	    array = new Uint8Array(array, byteOffset);
	  } else {
	    array = new Uint8Array(array, byteOffset, length);
	  }

	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = array;
	    that.__proto__ = Buffer.prototype;
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromArrayLike(that, array);
	  }
	  return that
	}

	function fromObject (that, obj) {
	  if (internalIsBuffer(obj)) {
	    var len = checked(obj.length) | 0;
	    that = createBuffer(that, len);

	    if (that.length === 0) {
	      return that
	    }

	    obj.copy(that, 0, 0, len);
	    return that
	  }

	  if (obj) {
	    if ((typeof ArrayBuffer !== 'undefined' &&
	        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
	      if (typeof obj.length !== 'number' || isnan(obj.length)) {
	        return createBuffer(that, 0)
	      }
	      return fromArrayLike(that, obj)
	    }

	    if (obj.type === 'Buffer' && isArray$1(obj.data)) {
	      return fromArrayLike(that, obj.data)
	    }
	  }

	  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
	}

	function checked (length) {
	  // Note: cannot use `length < kMaxLength()` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}

	function SlowBuffer (length) {
	  if (+length != length) { // eslint-disable-line eqeqeq
	    length = 0;
	  }
	  return Buffer.alloc(+length)
	}
	Buffer.isBuffer = isBuffer;
	function internalIsBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}

	Buffer.compare = function compare (a, b) {
	  if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }

	  if (a === b) return 0

	  var x = a.length;
	  var y = b.length;

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i];
	      y = b[i];
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	};

	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	};

	Buffer.concat = function concat (list, length) {
	  if (!isArray$1(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }

	  if (list.length === 0) {
	    return Buffer.alloc(0)
	  }

	  var i;
	  if (length === undefined) {
	    length = 0;
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length;
	    }
	  }

	  var buffer = Buffer.allocUnsafe(length);
	  var pos = 0;
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i];
	    if (!internalIsBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos);
	    pos += buf.length;
	  }
	  return buffer
	};

	function byteLength (string, encoding) {
	  if (internalIsBuffer(string)) {
	    return string.length
	  }
	  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
	      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    string = '' + string;
	  }

	  var len = string.length;
	  if (len === 0) return 0

	  // Use a for loop to avoid recursion
	  var loweredCase = false;
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	      case undefined:
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase();
	        loweredCase = true;
	    }
	  }
	}
	Buffer.byteLength = byteLength;

	function slowToString (encoding, start, end) {
	  var loweredCase = false;

	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.

	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0;
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }

	  if (end === undefined || end > this.length) {
	    end = this.length;
	  }

	  if (end <= 0) {
	    return ''
	  }

	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0;
	  start >>>= 0;

	  if (end <= start) {
	    return ''
	  }

	  if (!encoding) encoding = 'utf8';

	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)

	      case 'ascii':
	        return asciiSlice(this, start, end)

	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)

	      case 'base64':
	        return base64Slice(this, start, end)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase();
	        loweredCase = true;
	    }
	  }
	}

	// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
	// Buffer instances.
	Buffer.prototype._isBuffer = true;

	function swap (b, n, m) {
	  var i = b[n];
	  b[n] = b[m];
	  b[m] = i;
	}

	Buffer.prototype.swap16 = function swap16 () {
	  var len = this.length;
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1);
	  }
	  return this
	};

	Buffer.prototype.swap32 = function swap32 () {
	  var len = this.length;
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3);
	    swap(this, i + 1, i + 2);
	  }
	  return this
	};

	Buffer.prototype.swap64 = function swap64 () {
	  var len = this.length;
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7);
	    swap(this, i + 1, i + 6);
	    swap(this, i + 2, i + 5);
	    swap(this, i + 3, i + 4);
	  }
	  return this
	};

	Buffer.prototype.toString = function toString () {
	  var length = this.length | 0;
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	};

	Buffer.prototype.equals = function equals (b) {
	  if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	};

	Buffer.prototype.inspect = function inspect () {
	  var str = '';
	  var max = INSPECT_MAX_BYTES;
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
	    if (this.length > max) str += ' ... ';
	  }
	  return '<Buffer ' + str + '>'
	};

	Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (!internalIsBuffer(target)) {
	    throw new TypeError('Argument must be a Buffer')
	  }

	  if (start === undefined) {
	    start = 0;
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0;
	  }
	  if (thisStart === undefined) {
	    thisStart = 0;
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length;
	  }

	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }

	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }

	  start >>>= 0;
	  end >>>= 0;
	  thisStart >>>= 0;
	  thisEnd >>>= 0;

	  if (this === target) return 0

	  var x = thisEnd - thisStart;
	  var y = end - start;
	  var len = Math.min(x, y);

	  var thisCopy = this.slice(thisStart, thisEnd);
	  var targetCopy = target.slice(start, end);

	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i];
	      y = targetCopy[i];
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	};

	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1

	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset;
	    byteOffset = 0;
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff;
	  } else if (byteOffset < -0x80000000) {
	    byteOffset = -0x80000000;
	  }
	  byteOffset = +byteOffset;  // Coerce to Number.
	  if (isNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1);
	  }

	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1;
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0;
	    else return -1
	  }

	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer.from(val, encoding);
	  }

	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (internalIsBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF; // Search for a byte value [0-255]
	    if (Buffer.TYPED_ARRAY_SUPPORT &&
	        typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }

	  throw new TypeError('val must be string, number or Buffer')
	}

	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1;
	  var arrLength = arr.length;
	  var valLength = val.length;

	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase();
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2;
	      arrLength /= 2;
	      valLength /= 2;
	      byteOffset /= 2;
	    }
	  }

	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }

	  var i;
	  if (dir) {
	    var foundIndex = -1;
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i;
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex;
	        foundIndex = -1;
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true;
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false;
	          break
	        }
	      }
	      if (found) return i
	    }
	  }

	  return -1
	}

	Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	};

	Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	};

	Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	};

	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0;
	  var remaining = buf.length - offset;
	  if (!length) {
	    length = remaining;
	  } else {
	    length = Number(length);
	    if (length > remaining) {
	      length = remaining;
	    }
	  }

	  // must be an even number of digits
	  var strLen = string.length;
	  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

	  if (length > strLen / 2) {
	    length = strLen / 2;
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16);
	    if (isNaN(parsed)) return i
	    buf[offset + i] = parsed;
	  }
	  return i
	}

	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}

	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}

	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}

	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}

	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}

	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8';
	    length = this.length;
	    offset = 0;
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset;
	    length = this.length;
	    offset = 0;
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0;
	    if (isFinite(length)) {
	      length = length | 0;
	      if (encoding === undefined) encoding = 'utf8';
	    } else {
	      encoding = length;
	      length = undefined;
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }

	  var remaining = this.length - offset;
	  if (length === undefined || length > remaining) length = remaining;

	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }

	  if (!encoding) encoding = 'utf8';

	  var loweredCase = false;
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)

	      case 'ascii':
	        return asciiWrite(this, string, offset, length)

	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)

	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase();
	        loweredCase = true;
	    }
	  }
	};

	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	};

	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return fromByteArray(buf)
	  } else {
	    return fromByteArray(buf.slice(start, end))
	  }
	}

	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end);
	  var res = [];

	  var i = start;
	  while (i < end) {
	    var firstByte = buf[i];
	    var codePoint = null;
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1;

	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint;

	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte;
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1];
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint;
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1];
	          thirdByte = buf[i + 2];
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint;
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1];
	          thirdByte = buf[i + 2];
	          fourthByte = buf[i + 3];
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint;
	            }
	          }
	      }
	    }

	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD;
	      bytesPerSequence = 1;
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000;
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
	      codePoint = 0xDC00 | codePoint & 0x3FF;
	    }

	    res.push(codePoint);
	    i += bytesPerSequence;
	  }

	  return decodeCodePointsArray(res)
	}

	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000;

	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length;
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }

	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = '';
	  var i = 0;
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    );
	  }
	  return res
	}

	function asciiSlice (buf, start, end) {
	  var ret = '';
	  end = Math.min(buf.length, end);

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F);
	  }
	  return ret
	}

	function latin1Slice (buf, start, end) {
	  var ret = '';
	  end = Math.min(buf.length, end);

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i]);
	  }
	  return ret
	}

	function hexSlice (buf, start, end) {
	  var len = buf.length;

	  if (!start || start < 0) start = 0;
	  if (!end || end < 0 || end > len) end = len;

	  var out = '';
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i]);
	  }
	  return out
	}

	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end);
	  var res = '';
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
	  }
	  return res
	}

	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length;
	  start = ~~start;
	  end = end === undefined ? len : ~~end;

	  if (start < 0) {
	    start += len;
	    if (start < 0) start = 0;
	  } else if (start > len) {
	    start = len;
	  }

	  if (end < 0) {
	    end += len;
	    if (end < 0) end = 0;
	  } else if (end > len) {
	    end = len;
	  }

	  if (end < start) end = start;

	  var newBuf;
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    newBuf = this.subarray(start, end);
	    newBuf.__proto__ = Buffer.prototype;
	  } else {
	    var sliceLen = end - start;
	    newBuf = new Buffer(sliceLen, undefined);
	    for (var i = 0; i < sliceLen; ++i) {
	      newBuf[i] = this[i + start];
	    }
	  }

	  return newBuf
	};

	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}

	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var val = this[offset];
	  var mul = 1;
	  var i = 0;
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul;
	  }

	  return val
	};

	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length);
	  }

	  var val = this[offset + --byteLength];
	  var mul = 1;
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul;
	  }

	  return val
	};

	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length);
	  return this[offset]
	};

	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  return this[offset] | (this[offset + 1] << 8)
	};

	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  return (this[offset] << 8) | this[offset + 1]
	};

	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	};

	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	};

	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var val = this[offset];
	  var mul = 1;
	  var i = 0;
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul;
	  }
	  mul *= 0x80;

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

	  return val
	};

	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var i = byteLength;
	  var mul = 1;
	  var val = this[offset + --i];
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul;
	  }
	  mul *= 0x80;

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

	  return val
	};

	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length);
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	};

	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  var val = this[offset] | (this[offset + 1] << 8);
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	};

	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  var val = this[offset + 1] | (this[offset] << 8);
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	};

	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	};

	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	};

	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);
	  return read(this, offset, true, 23, 4)
	};

	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);
	  return read(this, offset, false, 23, 4)
	};

	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length);
	  return read(this, offset, true, 52, 8)
	};

	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length);
	  return read(this, offset, false, 52, 8)
	};

	function checkInt (buf, value, offset, ext, max, min) {
	  if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}

	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
	    checkInt(this, value, offset, byteLength, maxBytes, 0);
	  }

	  var mul = 1;
	  var i = 0;
	  this[offset] = value & 0xFF;
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
	    checkInt(this, value, offset, byteLength, maxBytes, 0);
	  }

	  var i = byteLength - 1;
	  var mul = 1;
	  this[offset + i] = value & 0xFF;
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
	  this[offset] = (value & 0xff);
	  return offset + 1
	};

	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1;
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8;
	  }
	}

	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff);
	    this[offset + 1] = (value >>> 8);
	  } else {
	    objectWriteUInt16(this, value, offset, true);
	  }
	  return offset + 2
	};

	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8);
	    this[offset + 1] = (value & 0xff);
	  } else {
	    objectWriteUInt16(this, value, offset, false);
	  }
	  return offset + 2
	};

	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1;
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
	  }
	}

	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24);
	    this[offset + 2] = (value >>> 16);
	    this[offset + 1] = (value >>> 8);
	    this[offset] = (value & 0xff);
	  } else {
	    objectWriteUInt32(this, value, offset, true);
	  }
	  return offset + 4
	};

	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24);
	    this[offset + 1] = (value >>> 16);
	    this[offset + 2] = (value >>> 8);
	    this[offset + 3] = (value & 0xff);
	  } else {
	    objectWriteUInt32(this, value, offset, false);
	  }
	  return offset + 4
	};

	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1);

	    checkInt(this, value, offset, byteLength, limit - 1, -limit);
	  }

	  var i = 0;
	  var mul = 1;
	  var sub = 0;
	  this[offset] = value & 0xFF;
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1;
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1);

	    checkInt(this, value, offset, byteLength, limit - 1, -limit);
	  }

	  var i = byteLength - 1;
	  var mul = 1;
	  var sub = 0;
	  this[offset + i] = value & 0xFF;
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1;
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
	  if (value < 0) value = 0xff + value + 1;
	  this[offset] = (value & 0xff);
	  return offset + 1
	};

	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff);
	    this[offset + 1] = (value >>> 8);
	  } else {
	    objectWriteUInt16(this, value, offset, true);
	  }
	  return offset + 2
	};

	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8);
	    this[offset + 1] = (value & 0xff);
	  } else {
	    objectWriteUInt16(this, value, offset, false);
	  }
	  return offset + 2
	};

	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff);
	    this[offset + 1] = (value >>> 8);
	    this[offset + 2] = (value >>> 16);
	    this[offset + 3] = (value >>> 24);
	  } else {
	    objectWriteUInt32(this, value, offset, true);
	  }
	  return offset + 4
	};

	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
	  if (value < 0) value = 0xffffffff + value + 1;
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24);
	    this[offset + 1] = (value >>> 16);
	    this[offset + 2] = (value >>> 8);
	    this[offset + 3] = (value & 0xff);
	  } else {
	    objectWriteUInt32(this, value, offset, false);
	  }
	  return offset + 4
	};

	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}

	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4);
	  }
	  write(buf, value, offset, littleEndian, 23, 4);
	  return offset + 4
	}

	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	};

	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	};

	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8);
	  }
	  write(buf, value, offset, littleEndian, 52, 8);
	  return offset + 8
	}

	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	};

	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	};

	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0;
	  if (!end && end !== 0) end = this.length;
	  if (targetStart >= target.length) targetStart = target.length;
	  if (!targetStart) targetStart = 0;
	  if (end > 0 && end < start) end = start;

	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0

	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')

	  // Are we oob?
	  if (end > this.length) end = this.length;
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start;
	  }

	  var len = end - start;
	  var i;

	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start];
	    }
	  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; ++i) {
	      target[i + targetStart] = this[i + start];
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, start + len),
	      targetStart
	    );
	  }

	  return len
	};

	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start;
	      start = 0;
	      end = this.length;
	    } else if (typeof end === 'string') {
	      encoding = end;
	      end = this.length;
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0);
	      if (code < 256) {
	        val = code;
	      }
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255;
	  }

	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }

	  if (end <= start) {
	    return this
	  }

	  start = start >>> 0;
	  end = end === undefined ? this.length : end >>> 0;

	  if (!val) val = 0;

	  var i;
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val;
	    }
	  } else {
	    var bytes = internalIsBuffer(val)
	      ? val
	      : utf8ToBytes(new Buffer(val, encoding).toString());
	    var len = bytes.length;
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len];
	    }
	  }

	  return this
	};

	// HELPER FUNCTIONS
	// ================

	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '');
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '=';
	  }
	  return str
	}

	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}

	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}

	function utf8ToBytes (string, units) {
	  units = units || Infinity;
	  var codePoint;
	  var length = string.length;
	  var leadSurrogate = null;
	  var bytes = [];

	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i);

	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	          continue
	        }

	        // valid lead
	        leadSurrogate = codePoint;

	        continue
	      }

	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	        leadSurrogate = codePoint;
	        continue
	      }

	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	    }

	    leadSurrogate = null;

	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint);
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      );
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      );
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      );
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }

	  return bytes
	}

	function asciiToBytes (str) {
	  var byteArray = [];
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF);
	  }
	  return byteArray
	}

	function utf16leToBytes (str, units) {
	  var c, hi, lo;
	  var byteArray = [];
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break

	    c = str.charCodeAt(i);
	    hi = c >> 8;
	    lo = c % 256;
	    byteArray.push(lo);
	    byteArray.push(hi);
	  }

	  return byteArray
	}


	function base64ToBytes (str) {
	  return toByteArray(base64clean(str))
	}

	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i];
	  }
	  return i
	}

	function isnan (val) {
	  return val !== val // eslint-disable-line no-self-compare
	}


	// the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
	// The _isBuffer check is for Safari 5-7 support, because it's missing
	// Object.prototype.constructor. Remove this eventually
	function isBuffer(obj) {
	  return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
	}

	function isFastBuffer (obj) {
	  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
	}

	// For Node v0.10 support. Remove this eventually.
	function isSlowBuffer (obj) {
	  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
	}

	var bufferEs6 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		INSPECT_MAX_BYTES: INSPECT_MAX_BYTES,
		kMaxLength: _kMaxLength,
		Buffer: Buffer,
		SlowBuffer: SlowBuffer,
		isBuffer: isBuffer
	});

	var inherits;
	if (typeof Object.create === 'function'){
	  inherits = function inherits(ctor, superCtor) {
	    // implementation from standard node.js 'util' module
	    ctor.super_ = superCtor;
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  inherits = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor;
	    var TempCtor = function () {};
	    TempCtor.prototype = superCtor.prototype;
	    ctor.prototype = new TempCtor();
	    ctor.prototype.constructor = ctor;
	  };
	}
	var inherits$1 = inherits;

	var formatRegExp = /%[sdj%]/g;
	function format(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }

	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject$1(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	}

	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	function deprecate(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global$1.process)) {
	    return function() {
	      return deprecate(fn, msg).apply(this, arguments);
	    };
	  }

	  if (process.noDeprecation === true) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	}

	var debugs = {};
	var debugEnviron;
	function debuglog(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = 0;
	      debugs[set] = function() {
	        var msg = format.apply(null, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	}

	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    _extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}

	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};

	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};


	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];

	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}


	function stylizeNoColor(str, styleType) {
	  return str;
	}


	function arrayToHash(array) {
	  var hash = {};

	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });

	  return hash;
	}


	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction$1(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }

	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }

	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);

	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }

	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }

	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction$1(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp$1(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }

	  var base = '', array = false, braces = ['{', '}'];

	  // Make Array say that they are Array
	  if (isArray$2(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }

	  // Make functions say that they are functions
	  if (isFunction$1(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }

	  // Make RegExps say that they are RegExps
	  if (isRegExp$1(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }

	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }

	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }

	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }

	  if (recurseTimes < 0) {
	    if (isRegExp$1(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }

	  ctx.seen.push(value);

	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }

	  ctx.seen.pop();

	  return reduceToSingleString(output, base, braces);
	}


	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}


	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}


	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty$b(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}


	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty$b(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }

	  return name + ': ' + str;
	}


	function reduceToSingleString(output, base, braces) {
	  var length = output.reduce(function(prev, cur) {
	    if (cur.indexOf('\n') >= 0) ;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);

	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }

	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}


	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray$2(ar) {
	  return Array.isArray(ar);
	}

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}

	function isNull(arg) {
	  return arg === null;
	}

	function isNullOrUndefined(arg) {
	  return arg == null;
	}

	function isNumber(arg) {
	  return typeof arg === 'number';
	}

	function isString(arg) {
	  return typeof arg === 'string';
	}

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}

	function isRegExp$1(re) {
	  return isObject$1(re) && objectToString$1(re) === '[object RegExp]';
	}

	function isObject$1(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isDate(d) {
	  return isObject$1(d) && objectToString$1(d) === '[object Date]';
	}

	function isError(e) {
	  return isObject$1(e) &&
	      (objectToString$1(e) === '[object Error]' || e instanceof Error);
	}

	function isFunction$1(arg) {
	  return typeof arg === 'function';
	}

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}

	function isBuffer$1(maybeBuf) {
	  return isBuffer(maybeBuf);
	}

	function objectToString$1(o) {
	  return Object.prototype.toString.call(o);
	}


	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}


	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];

	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}


	// log is just a thin wrapper to console.log that prepends a timestamp
	function log() {
	  console.log('%s - %s', timestamp(), format.apply(null, arguments));
	}

	function _extend(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject$1(add)) return origin;

	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	}
	function hasOwnProperty$b(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	var util = {
	  inherits: inherits$1,
	  _extend: _extend,
	  log: log,
	  isBuffer: isBuffer$1,
	  isPrimitive: isPrimitive,
	  isFunction: isFunction$1,
	  isError: isError,
	  isDate: isDate,
	  isObject: isObject$1,
	  isRegExp: isRegExp$1,
	  isUndefined: isUndefined,
	  isSymbol: isSymbol,
	  isString: isString,
	  isNumber: isNumber,
	  isNullOrUndefined: isNullOrUndefined,
	  isNull: isNull,
	  isBoolean: isBoolean,
	  isArray: isArray$2,
	  inspect: inspect,
	  deprecate: deprecate,
	  format: format,
	  debuglog: debuglog
	};

	var util$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		format: format,
		deprecate: deprecate,
		debuglog: debuglog,
		inspect: inspect,
		isArray: isArray$2,
		isBoolean: isBoolean,
		isNull: isNull,
		isNullOrUndefined: isNullOrUndefined,
		isNumber: isNumber,
		isString: isString,
		isSymbol: isSymbol,
		isUndefined: isUndefined,
		isRegExp: isRegExp$1,
		isObject: isObject$1,
		isDate: isDate,
		isError: isError,
		isFunction: isFunction$1,
		isPrimitive: isPrimitive,
		isBuffer: isBuffer$1,
		log: log,
		inherits: inherits$1,
		_extend: _extend,
		'default': util
	});

	/*
	The MIT License (MIT)

	Copyright (c) 2016 CoderPuppy

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.

	*/
	var _endianness;
	function endianness() {
	  if (typeof _endianness === 'undefined') {
	    var a = new ArrayBuffer(2);
	    var b = new Uint8Array(a);
	    var c = new Uint16Array(a);
	    b[0] = 1;
	    b[1] = 2;
	    if (c[0] === 258) {
	      _endianness = 'BE';
	    } else if (c[0] === 513){
	      _endianness = 'LE';
	    } else {
	      throw new Error('unable to figure out endianess');
	    }
	  }
	  return _endianness;
	}

	function hostname() {
	  if (typeof global$1.location !== 'undefined') {
	    return global$1.location.hostname
	  } else return '';
	}

	function loadavg() {
	  return [];
	}

	function uptime$1() {
	  return 0;
	}

	function freemem() {
	  return Number.MAX_VALUE;
	}

	function totalmem() {
	  return Number.MAX_VALUE;
	}

	function cpus() {
	  return [];
	}

	function type() {
	  return 'Browser';
	}

	function release$1 () {
	  if (typeof global$1.navigator !== 'undefined') {
	    return global$1.navigator.appVersion;
	  }
	  return '';
	}

	function networkInterfaces(){}
	function getNetworkInterfaces(){}

	function arch() {
	  return 'javascript';
	}

	function platform$1() {
	  return 'browser';
	}

	function tmpDir() {
	  return '/tmp';
	}
	var tmpdir = tmpDir;

	var EOL = '\n';
	var os = {
	  EOL: EOL,
	  tmpdir: tmpdir,
	  tmpDir: tmpDir,
	  networkInterfaces:networkInterfaces,
	  getNetworkInterfaces: getNetworkInterfaces,
	  release: release$1,
	  type: type,
	  cpus: cpus,
	  totalmem: totalmem,
	  freemem: freemem,
	  uptime: uptime$1,
	  loadavg: loadavg,
	  hostname: hostname,
	  endianness: endianness,
	};

	var os$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		endianness: endianness,
		hostname: hostname,
		loadavg: loadavg,
		uptime: uptime$1,
		freemem: freemem,
		totalmem: totalmem,
		cpus: cpus,
		type: type,
		release: release$1,
		networkInterfaces: networkInterfaces,
		getNetworkInterfaces: getNetworkInterfaces,
		arch: arch,
		platform: platform$1,
		tmpDir: tmpDir,
		tmpdir: tmpdir,
		EOL: EOL,
		'default': os
	});

	var hasFlag = (flag, argv) => {
		argv = argv || process.argv;
		const prefix = flag.startsWith('-') ? '' : (flag.length === 1 ? '-' : '--');
		const pos = argv.indexOf(prefix + flag);
		const terminatorPos = argv.indexOf('--');
		return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
	};

	var os$2 = getCjsExportFromNamespace(os$1);

	const env$1 = process.env;

	let forceColor;
	if (hasFlag('no-color') ||
		hasFlag('no-colors') ||
		hasFlag('color=false')) {
		forceColor = false;
	} else if (hasFlag('color') ||
		hasFlag('colors') ||
		hasFlag('color=true') ||
		hasFlag('color=always')) {
		forceColor = true;
	}
	if ('FORCE_COLOR' in env$1) {
		forceColor = env$1.FORCE_COLOR.length === 0 || parseInt(env$1.FORCE_COLOR, 10) !== 0;
	}

	function translateLevel(level) {
		if (level === 0) {
			return false;
		}

		return {
			level,
			hasBasic: true,
			has256: level >= 2,
			has16m: level >= 3
		};
	}

	function supportsColor(stream) {
		if (forceColor === false) {
			return 0;
		}

		if (hasFlag('color=16m') ||
			hasFlag('color=full') ||
			hasFlag('color=truecolor')) {
			return 3;
		}

		if (hasFlag('color=256')) {
			return 2;
		}

		if (stream && !stream.isTTY && forceColor !== true) {
			return 0;
		}

		const min = forceColor ? 1 : 0;

		if (process.platform === 'win32') {
			// Node.js 7.5.0 is the first version of Node.js to include a patch to
			// libuv that enables 256 color output on Windows. Anything earlier and it
			// won't work. However, here we target Node.js 8 at minimum as it is an LTS
			// release, and Node.js 7 is not. Windows 10 build 10586 is the first Windows
			// release that supports 256 colors. Windows 10 build 14931 is the first release
			// that supports 16m/TrueColor.
			const osRelease = os$2.release().split('.');
			if (
				Number(process.versions.node.split('.')[0]) >= 8 &&
				Number(osRelease[0]) >= 10 &&
				Number(osRelease[2]) >= 10586
			) {
				return Number(osRelease[2]) >= 14931 ? 3 : 2;
			}

			return 1;
		}

		if ('CI' in env$1) {
			if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(sign => sign in env$1) || env$1.CI_NAME === 'codeship') {
				return 1;
			}

			return min;
		}

		if ('TEAMCITY_VERSION' in env$1) {
			return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env$1.TEAMCITY_VERSION) ? 1 : 0;
		}

		if (env$1.COLORTERM === 'truecolor') {
			return 3;
		}

		if ('TERM_PROGRAM' in env$1) {
			const version = parseInt((env$1.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

			switch (env$1.TERM_PROGRAM) {
				case 'iTerm.app':
					return version >= 3 ? 3 : 2;
				case 'Apple_Terminal':
					return 2;
				// No default
			}
		}

		if (/-256(color)?$/i.test(env$1.TERM)) {
			return 2;
		}

		if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env$1.TERM)) {
			return 1;
		}

		if ('COLORTERM' in env$1) {
			return 1;
		}

		if (env$1.TERM === 'dumb') {
			return min;
		}

		return min;
	}

	function getSupportLevel(stream) {
		const level = supportsColor(stream);
		return translateLevel(level);
	}

	var supportsColor_1 = {
		supportsColor: getSupportLevel,
		stdout: getSupportLevel(process.stdout),
		stderr: getSupportLevel(process.stderr)
	};

	var tty$2 = getCjsExportFromNamespace(tty$1);

	var util$2 = getCjsExportFromNamespace(util$1);

	var node = createCommonjsModule(function (module, exports) {
	/**
	 * Module dependencies.
	 */




	/**
	 * This is the Node.js implementation of `debug()`.
	 */

	exports.init = init;
	exports.log = log;
	exports.formatArgs = formatArgs;
	exports.save = save;
	exports.load = load;
	exports.useColors = useColors;
	exports.destroy = util$2.deprecate(
		() => {},
		'Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.'
	);

	/**
	 * Colors.
	 */

	exports.colors = [6, 2, 3, 4, 5, 1];

	try {
		// Optional dependency (as in, doesn't need to be installed, NOT like optionalDependencies in package.json)
		// eslint-disable-next-line import/no-extraneous-dependencies
		const supportsColor = supportsColor_1;

		if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
			exports.colors = [
				20,
				21,
				26,
				27,
				32,
				33,
				38,
				39,
				40,
				41,
				42,
				43,
				44,
				45,
				56,
				57,
				62,
				63,
				68,
				69,
				74,
				75,
				76,
				77,
				78,
				79,
				80,
				81,
				92,
				93,
				98,
				99,
				112,
				113,
				128,
				129,
				134,
				135,
				148,
				149,
				160,
				161,
				162,
				163,
				164,
				165,
				166,
				167,
				168,
				169,
				170,
				171,
				172,
				173,
				178,
				179,
				184,
				185,
				196,
				197,
				198,
				199,
				200,
				201,
				202,
				203,
				204,
				205,
				206,
				207,
				208,
				209,
				214,
				215,
				220,
				221
			];
		}
	} catch (error) {
		// Swallow - we only care if `supports-color` is available; it doesn't have to be.
	}

	/**
	 * Build up the default `inspectOpts` object from the environment variables.
	 *
	 *   $ DEBUG_COLORS=no DEBUG_DEPTH=10 DEBUG_SHOW_HIDDEN=enabled node script.js
	 */

	exports.inspectOpts = Object.keys(process.env).filter(key => {
		return /^debug_/i.test(key);
	}).reduce((obj, key) => {
		// Camel-case
		const prop = key
			.substring(6)
			.toLowerCase()
			.replace(/_([a-z])/g, (_, k) => {
				return k.toUpperCase();
			});

		// Coerce string value into JS value
		let val = process.env[key];
		if (/^(yes|on|true|enabled)$/i.test(val)) {
			val = true;
		} else if (/^(no|off|false|disabled)$/i.test(val)) {
			val = false;
		} else if (val === 'null') {
			val = null;
		} else {
			val = Number(val);
		}

		obj[prop] = val;
		return obj;
	}, {});

	/**
	 * Is stdout a TTY? Colored output is enabled when `true`.
	 */

	function useColors() {
		return 'colors' in exports.inspectOpts ?
			Boolean(exports.inspectOpts.colors) :
			tty$2.isatty(process.stderr.fd);
	}

	/**
	 * Adds ANSI color escape codes if enabled.
	 *
	 * @api public
	 */

	function formatArgs(args) {
		const {namespace: name, useColors} = this;

		if (useColors) {
			const c = this.color;
			const colorCode = '\u001B[3' + (c < 8 ? c : '8;5;' + c);
			const prefix = `  ${colorCode};1m${name} \u001B[0m`;

			args[0] = prefix + args[0].split('\n').join('\n' + prefix);
			args.push(colorCode + 'm+' + module.exports.humanize(this.diff) + '\u001B[0m');
		} else {
			args[0] = getDate() + name + ' ' + args[0];
		}
	}

	function getDate() {
		if (exports.inspectOpts.hideDate) {
			return '';
		}
		return new Date().toISOString() + ' ';
	}

	/**
	 * Invokes `util.format()` with the specified arguments and writes to stderr.
	 */

	function log(...args) {
		return process.stderr.write(util$2.format(...args) + '\n');
	}

	/**
	 * Save `namespaces`.
	 *
	 * @param {String} namespaces
	 * @api private
	 */
	function save(namespaces) {
		if (namespaces) {
			process.env.DEBUG = namespaces;
		} else {
			// If you set a process.env field to null or undefined, it gets cast to the
			// string 'null' or 'undefined'. Just delete instead.
			delete process.env.DEBUG;
		}
	}

	/**
	 * Load `namespaces`.
	 *
	 * @return {String} returns the previously persisted debug modes
	 * @api private
	 */

	function load() {
		return process.env.DEBUG;
	}

	/**
	 * Init logic for `debug` instances.
	 *
	 * Create a new `inspectOpts` object in case `useColors` is set
	 * differently for a particular `debug` instance.
	 */

	function init(debug) {
		debug.inspectOpts = {};

		const keys = Object.keys(exports.inspectOpts);
		for (let i = 0; i < keys.length; i++) {
			debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
		}
	}

	module.exports = common(exports);

	const {formatters} = module.exports;

	/**
	 * Map %o to `util.inspect()`, all on a single line.
	 */

	formatters.o = function (v) {
		this.inspectOpts.colors = this.useColors;
		return util$2.inspect(v, this.inspectOpts)
			.split('\n')
			.map(str => str.trim())
			.join(' ');
	};

	/**
	 * Map %O to `util.inspect()`, allowing multiple lines if needed.
	 */

	formatters.O = function (v) {
		this.inspectOpts.colors = this.useColors;
		return util$2.inspect(v, this.inspectOpts);
	};
	});
	var node_1 = node.init;
	var node_2 = node.log;
	var node_3 = node.formatArgs;
	var node_4 = node.save;
	var node_5 = node.load;
	var node_6 = node.useColors;
	var node_7 = node.destroy;
	var node_8 = node.colors;
	var node_9 = node.inspectOpts;

	var src = createCommonjsModule(function (module) {
	/**
	 * Detect Electron renderer / nwjs process, which is node, but we should
	 * treat as a browser.
	 */

	if (typeof process === 'undefined' || process.type === 'renderer' || browser$1 === true || process.__nwjs) {
		module.exports = browser$2;
	} else {
		module.exports = node;
	}
	});

	var binding$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;

	class Binding {
	  constructor({
	    identifier,
	    scope,
	    path,
	    kind
	  }) {
	    this.constantViolations = [];
	    this.constant = true;
	    this.referencePaths = [];
	    this.referenced = false;
	    this.references = 0;
	    this.identifier = identifier;
	    this.scope = scope;
	    this.path = path;
	    this.kind = kind;
	    this.clearValue();
	  }

	  deoptValue() {
	    this.clearValue();
	    this.hasDeoptedValue = true;
	  }

	  setValue(value) {
	    if (this.hasDeoptedValue) return;
	    this.hasValue = true;
	    this.value = value;
	  }

	  clearValue() {
	    this.hasDeoptedValue = false;
	    this.hasValue = false;
	    this.value = null;
	  }

	  reassign(path) {
	    this.constant = false;

	    if (this.constantViolations.indexOf(path) !== -1) {
	      return;
	    }

	    this.constantViolations.push(path);
	  }

	  reference(path) {
	    if (this.referencePaths.indexOf(path) !== -1) {
	      return;
	    }

	    this.referenced = true;
	    this.references++;
	    this.referencePaths.push(path);
	  }

	  dereference() {
	    this.references--;
	    this.referenced = !!this.references;
	  }

	}

	exports.default = Binding;
	});

	unwrapExports(binding$1);

	var lib$2 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = splitExportDeclaration;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function splitExportDeclaration(exportDeclaration) {
	  if (!exportDeclaration.isExportDeclaration()) {
	    throw new Error("Only export declarations can be split.");
	  }

	  const isDefault = exportDeclaration.isExportDefaultDeclaration();
	  const declaration = exportDeclaration.get("declaration");
	  const isClassDeclaration = declaration.isClassDeclaration();

	  if (isDefault) {
	    const standaloneDeclaration = declaration.isFunctionDeclaration() || isClassDeclaration;
	    const scope = declaration.isScope() ? declaration.scope.parent : declaration.scope;
	    let id = declaration.node.id;
	    let needBindingRegistration = false;

	    if (!id) {
	      needBindingRegistration = true;
	      id = scope.generateUidIdentifier("default");

	      if (standaloneDeclaration || declaration.isFunctionExpression() || declaration.isClassExpression()) {
	        declaration.node.id = t.cloneNode(id);
	      }
	    }

	    const updatedDeclaration = standaloneDeclaration ? declaration : t.variableDeclaration("var", [t.variableDeclarator(t.cloneNode(id), declaration.node)]);
	    const updatedExportDeclaration = t.exportNamedDeclaration(null, [t.exportSpecifier(t.cloneNode(id), t.identifier("default"))]);
	    exportDeclaration.insertAfter(updatedExportDeclaration);
	    exportDeclaration.replaceWith(updatedDeclaration);

	    if (needBindingRegistration) {
	      scope.registerDeclaration(exportDeclaration);
	    }

	    return exportDeclaration;
	  }

	  if (exportDeclaration.get("specifiers").length > 0) {
	    throw new Error("It doesn't make sense to split exported specifiers.");
	  }

	  const bindingIdentifiers = declaration.getOuterBindingIdentifiers();
	  const specifiers = Object.keys(bindingIdentifiers).map(name => {
	    return t.exportSpecifier(t.identifier(name), t.identifier(name));
	  });
	  const aliasDeclar = t.exportNamedDeclaration(null, specifiers);
	  exportDeclaration.insertAfter(aliasDeclar);
	  exportDeclaration.replaceWith(declaration.node);
	  return exportDeclaration;
	}
	});

	unwrapExports(lib$2);

	var renamer = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;

	var _binding = _interopRequireDefault(binding$1);

	var _helperSplitExportDeclaration = _interopRequireDefault(lib$2);

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	const renameVisitor = {
	  ReferencedIdentifier({
	    node
	  }, state) {
	    if (node.name === state.oldName) {
	      node.name = state.newName;
	    }
	  },

	  Scope(path, state) {
	    if (!path.scope.bindingIdentifierEquals(state.oldName, state.binding.identifier)) {
	      path.skip();
	    }
	  },

	  "AssignmentExpression|Declaration|VariableDeclarator"(path, state) {
	    if (path.isVariableDeclaration()) return;
	    const ids = path.getOuterBindingIdentifiers();

	    for (const name in ids) {
	      if (name === state.oldName) ids[name].name = state.newName;
	    }
	  }

	};

	class Renamer {
	  constructor(binding, oldName, newName) {
	    this.newName = newName;
	    this.oldName = oldName;
	    this.binding = binding;
	  }

	  maybeConvertFromExportDeclaration(parentDeclar) {
	    const maybeExportDeclar = parentDeclar.parentPath;

	    if (!maybeExportDeclar.isExportDeclaration()) {
	      return;
	    }

	    if (maybeExportDeclar.isExportDefaultDeclaration() && !maybeExportDeclar.get("declaration").node.id) {
	      return;
	    }

	    (0, _helperSplitExportDeclaration.default)(maybeExportDeclar);
	  }

	  maybeConvertFromClassFunctionDeclaration(path) {
	    return;
	  }

	  maybeConvertFromClassFunctionExpression(path) {
	    return;
	  }

	  rename(block) {
	    const {
	      binding,
	      oldName,
	      newName
	    } = this;
	    const {
	      scope,
	      path
	    } = binding;
	    const parentDeclar = path.find(path => path.isDeclaration() || path.isFunctionExpression() || path.isClassExpression());

	    if (parentDeclar) {
	      const bindingIds = parentDeclar.getOuterBindingIdentifiers();

	      if (bindingIds[oldName] === binding.identifier) {
	        this.maybeConvertFromExportDeclaration(parentDeclar);
	      }
	    }

	    scope.traverse(block || scope.block, renameVisitor, this);

	    if (!block) {
	      scope.removeOwnBinding(oldName);
	      scope.bindings[newName] = binding;
	      this.binding.identifier.name = newName;
	    }

	    if (binding.type === "hoisted") ;

	    if (parentDeclar) {
	      this.maybeConvertFromClassFunctionDeclaration(parentDeclar);
	      this.maybeConvertFromClassFunctionExpression(parentDeclar);
	    }
	  }

	}

	exports.default = Renamer;
	});

	unwrapExports(renamer);

	var builtin = {
		"Array": false,
		"ArrayBuffer": false,
		Atomics: false,
		BigInt: false,
		BigInt64Array: false,
		BigUint64Array: false,
		"Boolean": false,
		constructor: false,
		"DataView": false,
		"Date": false,
		"decodeURI": false,
		"decodeURIComponent": false,
		"encodeURI": false,
		"encodeURIComponent": false,
		"Error": false,
		"escape": false,
		"eval": false,
		"EvalError": false,
		"Float32Array": false,
		"Float64Array": false,
		"Function": false,
		globalThis: false,
		hasOwnProperty: false,
		"Infinity": false,
		"Int16Array": false,
		"Int32Array": false,
		"Int8Array": false,
		"isFinite": false,
		"isNaN": false,
		isPrototypeOf: false,
		"JSON": false,
		"Map": false,
		"Math": false,
		"NaN": false,
		"Number": false,
		"Object": false,
		"parseFloat": false,
		"parseInt": false,
		"Promise": false,
		propertyIsEnumerable: false,
		"Proxy": false,
		"RangeError": false,
		"ReferenceError": false,
		"Reflect": false,
		"RegExp": false,
		"Set": false,
		SharedArrayBuffer: false,
		"String": false,
		"Symbol": false,
		"SyntaxError": false,
		toLocaleString: false,
		toString: false,
		"TypeError": false,
		"Uint16Array": false,
		"Uint32Array": false,
		"Uint8Array": false,
		"Uint8ClampedArray": false,
		"undefined": false,
		"unescape": false,
		"URIError": false,
		valueOf: false,
		"WeakMap": false,
		"WeakSet": false
	};
	var es5 = {
		"Array": false,
		"Boolean": false,
		constructor: false,
		"Date": false,
		"decodeURI": false,
		"decodeURIComponent": false,
		"encodeURI": false,
		"encodeURIComponent": false,
		"Error": false,
		"escape": false,
		"eval": false,
		"EvalError": false,
		"Function": false,
		hasOwnProperty: false,
		"Infinity": false,
		"isFinite": false,
		"isNaN": false,
		isPrototypeOf: false,
		"JSON": false,
		"Math": false,
		"NaN": false,
		"Number": false,
		"Object": false,
		"parseFloat": false,
		"parseInt": false,
		propertyIsEnumerable: false,
		"RangeError": false,
		"ReferenceError": false,
		"RegExp": false,
		"String": false,
		"SyntaxError": false,
		toLocaleString: false,
		toString: false,
		"TypeError": false,
		"undefined": false,
		"unescape": false,
		"URIError": false,
		valueOf: false
	};
	var es2015 = {
		"Array": false,
		"ArrayBuffer": false,
		"Boolean": false,
		constructor: false,
		"DataView": false,
		"Date": false,
		"decodeURI": false,
		"decodeURIComponent": false,
		"encodeURI": false,
		"encodeURIComponent": false,
		"Error": false,
		"escape": false,
		"eval": false,
		"EvalError": false,
		"Float32Array": false,
		"Float64Array": false,
		"Function": false,
		hasOwnProperty: false,
		"Infinity": false,
		"Int16Array": false,
		"Int32Array": false,
		"Int8Array": false,
		"isFinite": false,
		"isNaN": false,
		isPrototypeOf: false,
		"JSON": false,
		"Map": false,
		"Math": false,
		"NaN": false,
		"Number": false,
		"Object": false,
		"parseFloat": false,
		"parseInt": false,
		"Promise": false,
		propertyIsEnumerable: false,
		"Proxy": false,
		"RangeError": false,
		"ReferenceError": false,
		"Reflect": false,
		"RegExp": false,
		"Set": false,
		"String": false,
		"Symbol": false,
		"SyntaxError": false,
		toLocaleString: false,
		toString: false,
		"TypeError": false,
		"Uint16Array": false,
		"Uint32Array": false,
		"Uint8Array": false,
		"Uint8ClampedArray": false,
		"undefined": false,
		"unescape": false,
		"URIError": false,
		valueOf: false,
		"WeakMap": false,
		"WeakSet": false
	};
	var es2017 = {
		"Array": false,
		"ArrayBuffer": false,
		Atomics: false,
		"Boolean": false,
		constructor: false,
		"DataView": false,
		"Date": false,
		"decodeURI": false,
		"decodeURIComponent": false,
		"encodeURI": false,
		"encodeURIComponent": false,
		"Error": false,
		"escape": false,
		"eval": false,
		"EvalError": false,
		"Float32Array": false,
		"Float64Array": false,
		"Function": false,
		hasOwnProperty: false,
		"Infinity": false,
		"Int16Array": false,
		"Int32Array": false,
		"Int8Array": false,
		"isFinite": false,
		"isNaN": false,
		isPrototypeOf: false,
		"JSON": false,
		"Map": false,
		"Math": false,
		"NaN": false,
		"Number": false,
		"Object": false,
		"parseFloat": false,
		"parseInt": false,
		"Promise": false,
		propertyIsEnumerable: false,
		"Proxy": false,
		"RangeError": false,
		"ReferenceError": false,
		"Reflect": false,
		"RegExp": false,
		"Set": false,
		SharedArrayBuffer: false,
		"String": false,
		"Symbol": false,
		"SyntaxError": false,
		toLocaleString: false,
		toString: false,
		"TypeError": false,
		"Uint16Array": false,
		"Uint32Array": false,
		"Uint8Array": false,
		"Uint8ClampedArray": false,
		"undefined": false,
		"unescape": false,
		"URIError": false,
		valueOf: false,
		"WeakMap": false,
		"WeakSet": false
	};
	var browser$3 = {
		AbortController: false,
		AbortSignal: false,
		addEventListener: false,
		alert: false,
		AnalyserNode: false,
		Animation: false,
		AnimationEffectReadOnly: false,
		AnimationEffectTiming: false,
		AnimationEffectTimingReadOnly: false,
		AnimationEvent: false,
		AnimationPlaybackEvent: false,
		AnimationTimeline: false,
		applicationCache: false,
		ApplicationCache: false,
		ApplicationCacheErrorEvent: false,
		atob: false,
		Attr: false,
		Audio: false,
		AudioBuffer: false,
		AudioBufferSourceNode: false,
		AudioContext: false,
		AudioDestinationNode: false,
		AudioListener: false,
		AudioNode: false,
		AudioParam: false,
		AudioProcessingEvent: false,
		AudioScheduledSourceNode: false,
		"AudioWorkletGlobalScope ": false,
		AudioWorkletNode: false,
		AudioWorkletProcessor: false,
		BarProp: false,
		BaseAudioContext: false,
		BatteryManager: false,
		BeforeUnloadEvent: false,
		BiquadFilterNode: false,
		Blob: false,
		BlobEvent: false,
		blur: false,
		BroadcastChannel: false,
		btoa: false,
		BudgetService: false,
		ByteLengthQueuingStrategy: false,
		Cache: false,
		caches: false,
		CacheStorage: false,
		cancelAnimationFrame: false,
		cancelIdleCallback: false,
		CanvasCaptureMediaStreamTrack: false,
		CanvasGradient: false,
		CanvasPattern: false,
		CanvasRenderingContext2D: false,
		ChannelMergerNode: false,
		ChannelSplitterNode: false,
		CharacterData: false,
		clearInterval: false,
		clearTimeout: false,
		clientInformation: false,
		ClipboardEvent: false,
		close: false,
		closed: false,
		CloseEvent: false,
		Comment: false,
		CompositionEvent: false,
		confirm: false,
		console: false,
		ConstantSourceNode: false,
		ConvolverNode: false,
		CountQueuingStrategy: false,
		createImageBitmap: false,
		Credential: false,
		CredentialsContainer: false,
		crypto: false,
		Crypto: false,
		CryptoKey: false,
		CSS: false,
		CSSConditionRule: false,
		CSSFontFaceRule: false,
		CSSGroupingRule: false,
		CSSImportRule: false,
		CSSKeyframeRule: false,
		CSSKeyframesRule: false,
		CSSMediaRule: false,
		CSSNamespaceRule: false,
		CSSPageRule: false,
		CSSRule: false,
		CSSRuleList: false,
		CSSStyleDeclaration: false,
		CSSStyleRule: false,
		CSSStyleSheet: false,
		CSSSupportsRule: false,
		CustomElementRegistry: false,
		customElements: false,
		CustomEvent: false,
		DataTransfer: false,
		DataTransferItem: false,
		DataTransferItemList: false,
		defaultstatus: false,
		defaultStatus: false,
		DelayNode: false,
		DeviceMotionEvent: false,
		DeviceOrientationEvent: false,
		devicePixelRatio: false,
		dispatchEvent: false,
		document: false,
		Document: false,
		DocumentFragment: false,
		DocumentType: false,
		DOMError: false,
		DOMException: false,
		DOMImplementation: false,
		DOMMatrix: false,
		DOMMatrixReadOnly: false,
		DOMParser: false,
		DOMPoint: false,
		DOMPointReadOnly: false,
		DOMQuad: false,
		DOMRect: false,
		DOMRectReadOnly: false,
		DOMStringList: false,
		DOMStringMap: false,
		DOMTokenList: false,
		DragEvent: false,
		DynamicsCompressorNode: false,
		Element: false,
		ErrorEvent: false,
		event: false,
		Event: false,
		EventSource: false,
		EventTarget: false,
		external: false,
		fetch: false,
		File: false,
		FileList: false,
		FileReader: false,
		find: false,
		focus: false,
		FocusEvent: false,
		FontFace: false,
		FontFaceSetLoadEvent: false,
		FormData: false,
		frameElement: false,
		frames: false,
		GainNode: false,
		Gamepad: false,
		GamepadButton: false,
		GamepadEvent: false,
		getComputedStyle: false,
		getSelection: false,
		HashChangeEvent: false,
		Headers: false,
		history: false,
		History: false,
		HTMLAllCollection: false,
		HTMLAnchorElement: false,
		HTMLAreaElement: false,
		HTMLAudioElement: false,
		HTMLBaseElement: false,
		HTMLBodyElement: false,
		HTMLBRElement: false,
		HTMLButtonElement: false,
		HTMLCanvasElement: false,
		HTMLCollection: false,
		HTMLContentElement: false,
		HTMLDataElement: false,
		HTMLDataListElement: false,
		HTMLDetailsElement: false,
		HTMLDialogElement: false,
		HTMLDirectoryElement: false,
		HTMLDivElement: false,
		HTMLDListElement: false,
		HTMLDocument: false,
		HTMLElement: false,
		HTMLEmbedElement: false,
		HTMLFieldSetElement: false,
		HTMLFontElement: false,
		HTMLFormControlsCollection: false,
		HTMLFormElement: false,
		HTMLFrameElement: false,
		HTMLFrameSetElement: false,
		HTMLHeadElement: false,
		HTMLHeadingElement: false,
		HTMLHRElement: false,
		HTMLHtmlElement: false,
		HTMLIFrameElement: false,
		HTMLImageElement: false,
		HTMLInputElement: false,
		HTMLLabelElement: false,
		HTMLLegendElement: false,
		HTMLLIElement: false,
		HTMLLinkElement: false,
		HTMLMapElement: false,
		HTMLMarqueeElement: false,
		HTMLMediaElement: false,
		HTMLMenuElement: false,
		HTMLMetaElement: false,
		HTMLMeterElement: false,
		HTMLModElement: false,
		HTMLObjectElement: false,
		HTMLOListElement: false,
		HTMLOptGroupElement: false,
		HTMLOptionElement: false,
		HTMLOptionsCollection: false,
		HTMLOutputElement: false,
		HTMLParagraphElement: false,
		HTMLParamElement: false,
		HTMLPictureElement: false,
		HTMLPreElement: false,
		HTMLProgressElement: false,
		HTMLQuoteElement: false,
		HTMLScriptElement: false,
		HTMLSelectElement: false,
		HTMLShadowElement: false,
		HTMLSlotElement: false,
		HTMLSourceElement: false,
		HTMLSpanElement: false,
		HTMLStyleElement: false,
		HTMLTableCaptionElement: false,
		HTMLTableCellElement: false,
		HTMLTableColElement: false,
		HTMLTableElement: false,
		HTMLTableRowElement: false,
		HTMLTableSectionElement: false,
		HTMLTemplateElement: false,
		HTMLTextAreaElement: false,
		HTMLTimeElement: false,
		HTMLTitleElement: false,
		HTMLTrackElement: false,
		HTMLUListElement: false,
		HTMLUnknownElement: false,
		HTMLVideoElement: false,
		IDBCursor: false,
		IDBCursorWithValue: false,
		IDBDatabase: false,
		IDBFactory: false,
		IDBIndex: false,
		IDBKeyRange: false,
		IDBObjectStore: false,
		IDBOpenDBRequest: false,
		IDBRequest: false,
		IDBTransaction: false,
		IDBVersionChangeEvent: false,
		IdleDeadline: false,
		IIRFilterNode: false,
		Image: false,
		ImageBitmap: false,
		ImageBitmapRenderingContext: false,
		ImageCapture: false,
		ImageData: false,
		indexedDB: false,
		innerHeight: false,
		innerWidth: false,
		InputEvent: false,
		IntersectionObserver: false,
		IntersectionObserverEntry: false,
		"Intl": false,
		isSecureContext: false,
		KeyboardEvent: false,
		KeyframeEffect: false,
		KeyframeEffectReadOnly: false,
		length: false,
		localStorage: false,
		location: true,
		Location: false,
		locationbar: false,
		matchMedia: false,
		MediaDeviceInfo: false,
		MediaDevices: false,
		MediaElementAudioSourceNode: false,
		MediaEncryptedEvent: false,
		MediaError: false,
		MediaKeyMessageEvent: false,
		MediaKeySession: false,
		MediaKeyStatusMap: false,
		MediaKeySystemAccess: false,
		MediaList: false,
		MediaQueryList: false,
		MediaQueryListEvent: false,
		MediaRecorder: false,
		MediaSettingsRange: false,
		MediaSource: false,
		MediaStream: false,
		MediaStreamAudioDestinationNode: false,
		MediaStreamAudioSourceNode: false,
		MediaStreamEvent: false,
		MediaStreamTrack: false,
		MediaStreamTrackEvent: false,
		menubar: false,
		MessageChannel: false,
		MessageEvent: false,
		MessagePort: false,
		MIDIAccess: false,
		MIDIConnectionEvent: false,
		MIDIInput: false,
		MIDIInputMap: false,
		MIDIMessageEvent: false,
		MIDIOutput: false,
		MIDIOutputMap: false,
		MIDIPort: false,
		MimeType: false,
		MimeTypeArray: false,
		MouseEvent: false,
		moveBy: false,
		moveTo: false,
		MutationEvent: false,
		MutationObserver: false,
		MutationRecord: false,
		name: false,
		NamedNodeMap: false,
		NavigationPreloadManager: false,
		navigator: false,
		Navigator: false,
		NetworkInformation: false,
		Node: false,
		NodeFilter: false,
		NodeIterator: false,
		NodeList: false,
		Notification: false,
		OfflineAudioCompletionEvent: false,
		OfflineAudioContext: false,
		offscreenBuffering: false,
		OffscreenCanvas: true,
		onabort: true,
		onafterprint: true,
		onanimationend: true,
		onanimationiteration: true,
		onanimationstart: true,
		onappinstalled: true,
		onauxclick: true,
		onbeforeinstallprompt: true,
		onbeforeprint: true,
		onbeforeunload: true,
		onblur: true,
		oncancel: true,
		oncanplay: true,
		oncanplaythrough: true,
		onchange: true,
		onclick: true,
		onclose: true,
		oncontextmenu: true,
		oncuechange: true,
		ondblclick: true,
		ondevicemotion: true,
		ondeviceorientation: true,
		ondeviceorientationabsolute: true,
		ondrag: true,
		ondragend: true,
		ondragenter: true,
		ondragleave: true,
		ondragover: true,
		ondragstart: true,
		ondrop: true,
		ondurationchange: true,
		onemptied: true,
		onended: true,
		onerror: true,
		onfocus: true,
		ongotpointercapture: true,
		onhashchange: true,
		oninput: true,
		oninvalid: true,
		onkeydown: true,
		onkeypress: true,
		onkeyup: true,
		onlanguagechange: true,
		onload: true,
		onloadeddata: true,
		onloadedmetadata: true,
		onloadstart: true,
		onlostpointercapture: true,
		onmessage: true,
		onmessageerror: true,
		onmousedown: true,
		onmouseenter: true,
		onmouseleave: true,
		onmousemove: true,
		onmouseout: true,
		onmouseover: true,
		onmouseup: true,
		onmousewheel: true,
		onoffline: true,
		ononline: true,
		onpagehide: true,
		onpageshow: true,
		onpause: true,
		onplay: true,
		onplaying: true,
		onpointercancel: true,
		onpointerdown: true,
		onpointerenter: true,
		onpointerleave: true,
		onpointermove: true,
		onpointerout: true,
		onpointerover: true,
		onpointerup: true,
		onpopstate: true,
		onprogress: true,
		onratechange: true,
		onrejectionhandled: true,
		onreset: true,
		onresize: true,
		onscroll: true,
		onsearch: true,
		onseeked: true,
		onseeking: true,
		onselect: true,
		onstalled: true,
		onstorage: true,
		onsubmit: true,
		onsuspend: true,
		ontimeupdate: true,
		ontoggle: true,
		ontransitionend: true,
		onunhandledrejection: true,
		onunload: true,
		onvolumechange: true,
		onwaiting: true,
		onwheel: true,
		open: false,
		openDatabase: false,
		opener: false,
		Option: false,
		origin: false,
		OscillatorNode: false,
		outerHeight: false,
		outerWidth: false,
		PageTransitionEvent: false,
		pageXOffset: false,
		pageYOffset: false,
		PannerNode: false,
		parent: false,
		Path2D: false,
		PaymentAddress: false,
		PaymentRequest: false,
		PaymentRequestUpdateEvent: false,
		PaymentResponse: false,
		performance: false,
		Performance: false,
		PerformanceEntry: false,
		PerformanceLongTaskTiming: false,
		PerformanceMark: false,
		PerformanceMeasure: false,
		PerformanceNavigation: false,
		PerformanceNavigationTiming: false,
		PerformanceObserver: false,
		PerformanceObserverEntryList: false,
		PerformancePaintTiming: false,
		PerformanceResourceTiming: false,
		PerformanceTiming: false,
		PeriodicWave: false,
		Permissions: false,
		PermissionStatus: false,
		personalbar: false,
		PhotoCapabilities: false,
		Plugin: false,
		PluginArray: false,
		PointerEvent: false,
		PopStateEvent: false,
		postMessage: false,
		Presentation: false,
		PresentationAvailability: false,
		PresentationConnection: false,
		PresentationConnectionAvailableEvent: false,
		PresentationConnectionCloseEvent: false,
		PresentationConnectionList: false,
		PresentationReceiver: false,
		PresentationRequest: false,
		print: false,
		ProcessingInstruction: false,
		ProgressEvent: false,
		PromiseRejectionEvent: false,
		prompt: false,
		PushManager: false,
		PushSubscription: false,
		PushSubscriptionOptions: false,
		queueMicrotask: false,
		RadioNodeList: false,
		Range: false,
		ReadableStream: false,
		registerProcessor: false,
		RemotePlayback: false,
		removeEventListener: false,
		Request: false,
		requestAnimationFrame: false,
		requestIdleCallback: false,
		resizeBy: false,
		ResizeObserver: false,
		ResizeObserverEntry: false,
		resizeTo: false,
		Response: false,
		RTCCertificate: false,
		RTCDataChannel: false,
		RTCDataChannelEvent: false,
		RTCDtlsTransport: false,
		RTCIceCandidate: false,
		RTCIceGatherer: false,
		RTCIceTransport: false,
		RTCPeerConnection: false,
		RTCPeerConnectionIceEvent: false,
		RTCRtpContributingSource: false,
		RTCRtpReceiver: false,
		RTCRtpSender: false,
		RTCSctpTransport: false,
		RTCSessionDescription: false,
		RTCStatsReport: false,
		RTCTrackEvent: false,
		screen: false,
		Screen: false,
		screenLeft: false,
		ScreenOrientation: false,
		screenTop: false,
		screenX: false,
		screenY: false,
		ScriptProcessorNode: false,
		scroll: false,
		scrollbars: false,
		scrollBy: false,
		scrollTo: false,
		scrollX: false,
		scrollY: false,
		SecurityPolicyViolationEvent: false,
		Selection: false,
		self: false,
		ServiceWorker: false,
		ServiceWorkerContainer: false,
		ServiceWorkerRegistration: false,
		sessionStorage: false,
		setInterval: false,
		setTimeout: false,
		ShadowRoot: false,
		SharedWorker: false,
		SourceBuffer: false,
		SourceBufferList: false,
		speechSynthesis: false,
		SpeechSynthesisEvent: false,
		SpeechSynthesisUtterance: false,
		StaticRange: false,
		status: false,
		statusbar: false,
		StereoPannerNode: false,
		stop: false,
		Storage: false,
		StorageEvent: false,
		StorageManager: false,
		styleMedia: false,
		StyleSheet: false,
		StyleSheetList: false,
		SubtleCrypto: false,
		SVGAElement: false,
		SVGAngle: false,
		SVGAnimatedAngle: false,
		SVGAnimatedBoolean: false,
		SVGAnimatedEnumeration: false,
		SVGAnimatedInteger: false,
		SVGAnimatedLength: false,
		SVGAnimatedLengthList: false,
		SVGAnimatedNumber: false,
		SVGAnimatedNumberList: false,
		SVGAnimatedPreserveAspectRatio: false,
		SVGAnimatedRect: false,
		SVGAnimatedString: false,
		SVGAnimatedTransformList: false,
		SVGAnimateElement: false,
		SVGAnimateMotionElement: false,
		SVGAnimateTransformElement: false,
		SVGAnimationElement: false,
		SVGCircleElement: false,
		SVGClipPathElement: false,
		SVGComponentTransferFunctionElement: false,
		SVGDefsElement: false,
		SVGDescElement: false,
		SVGDiscardElement: false,
		SVGElement: false,
		SVGEllipseElement: false,
		SVGFEBlendElement: false,
		SVGFEColorMatrixElement: false,
		SVGFEComponentTransferElement: false,
		SVGFECompositeElement: false,
		SVGFEConvolveMatrixElement: false,
		SVGFEDiffuseLightingElement: false,
		SVGFEDisplacementMapElement: false,
		SVGFEDistantLightElement: false,
		SVGFEDropShadowElement: false,
		SVGFEFloodElement: false,
		SVGFEFuncAElement: false,
		SVGFEFuncBElement: false,
		SVGFEFuncGElement: false,
		SVGFEFuncRElement: false,
		SVGFEGaussianBlurElement: false,
		SVGFEImageElement: false,
		SVGFEMergeElement: false,
		SVGFEMergeNodeElement: false,
		SVGFEMorphologyElement: false,
		SVGFEOffsetElement: false,
		SVGFEPointLightElement: false,
		SVGFESpecularLightingElement: false,
		SVGFESpotLightElement: false,
		SVGFETileElement: false,
		SVGFETurbulenceElement: false,
		SVGFilterElement: false,
		SVGForeignObjectElement: false,
		SVGGElement: false,
		SVGGeometryElement: false,
		SVGGradientElement: false,
		SVGGraphicsElement: false,
		SVGImageElement: false,
		SVGLength: false,
		SVGLengthList: false,
		SVGLinearGradientElement: false,
		SVGLineElement: false,
		SVGMarkerElement: false,
		SVGMaskElement: false,
		SVGMatrix: false,
		SVGMetadataElement: false,
		SVGMPathElement: false,
		SVGNumber: false,
		SVGNumberList: false,
		SVGPathElement: false,
		SVGPatternElement: false,
		SVGPoint: false,
		SVGPointList: false,
		SVGPolygonElement: false,
		SVGPolylineElement: false,
		SVGPreserveAspectRatio: false,
		SVGRadialGradientElement: false,
		SVGRect: false,
		SVGRectElement: false,
		SVGScriptElement: false,
		SVGSetElement: false,
		SVGStopElement: false,
		SVGStringList: false,
		SVGStyleElement: false,
		SVGSVGElement: false,
		SVGSwitchElement: false,
		SVGSymbolElement: false,
		SVGTextContentElement: false,
		SVGTextElement: false,
		SVGTextPathElement: false,
		SVGTextPositioningElement: false,
		SVGTitleElement: false,
		SVGTransform: false,
		SVGTransformList: false,
		SVGTSpanElement: false,
		SVGUnitTypes: false,
		SVGUseElement: false,
		SVGViewElement: false,
		TaskAttributionTiming: false,
		Text: false,
		TextDecoder: false,
		TextEncoder: false,
		TextEvent: false,
		TextMetrics: false,
		TextTrack: false,
		TextTrackCue: false,
		TextTrackCueList: false,
		TextTrackList: false,
		TimeRanges: false,
		toolbar: false,
		top: false,
		Touch: false,
		TouchEvent: false,
		TouchList: false,
		TrackEvent: false,
		TransitionEvent: false,
		TreeWalker: false,
		UIEvent: false,
		URL: false,
		URLSearchParams: false,
		ValidityState: false,
		visualViewport: false,
		VisualViewport: false,
		VTTCue: false,
		WaveShaperNode: false,
		WebAssembly: false,
		WebGL2RenderingContext: false,
		WebGLActiveInfo: false,
		WebGLBuffer: false,
		WebGLContextEvent: false,
		WebGLFramebuffer: false,
		WebGLProgram: false,
		WebGLQuery: false,
		WebGLRenderbuffer: false,
		WebGLRenderingContext: false,
		WebGLSampler: false,
		WebGLShader: false,
		WebGLShaderPrecisionFormat: false,
		WebGLSync: false,
		WebGLTexture: false,
		WebGLTransformFeedback: false,
		WebGLUniformLocation: false,
		WebGLVertexArrayObject: false,
		WebSocket: false,
		WheelEvent: false,
		window: false,
		Window: false,
		Worker: false,
		WritableStream: false,
		XMLDocument: false,
		XMLHttpRequest: false,
		XMLHttpRequestEventTarget: false,
		XMLHttpRequestUpload: false,
		XMLSerializer: false,
		XPathEvaluator: false,
		XPathExpression: false,
		XPathResult: false,
		XSLTProcessor: false
	};
	var worker = {
		addEventListener: false,
		applicationCache: false,
		atob: false,
		Blob: false,
		BroadcastChannel: false,
		btoa: false,
		Cache: false,
		caches: false,
		clearInterval: false,
		clearTimeout: false,
		close: true,
		console: false,
		fetch: false,
		FileReaderSync: false,
		FormData: false,
		Headers: false,
		IDBCursor: false,
		IDBCursorWithValue: false,
		IDBDatabase: false,
		IDBFactory: false,
		IDBIndex: false,
		IDBKeyRange: false,
		IDBObjectStore: false,
		IDBOpenDBRequest: false,
		IDBRequest: false,
		IDBTransaction: false,
		IDBVersionChangeEvent: false,
		ImageData: false,
		importScripts: true,
		indexedDB: false,
		location: false,
		MessageChannel: false,
		MessagePort: false,
		name: false,
		navigator: false,
		Notification: false,
		onclose: true,
		onconnect: true,
		onerror: true,
		onlanguagechange: true,
		onmessage: true,
		onoffline: true,
		ononline: true,
		onrejectionhandled: true,
		onunhandledrejection: true,
		performance: false,
		Performance: false,
		PerformanceEntry: false,
		PerformanceMark: false,
		PerformanceMeasure: false,
		PerformanceNavigation: false,
		PerformanceResourceTiming: false,
		PerformanceTiming: false,
		postMessage: true,
		"Promise": false,
		queueMicrotask: false,
		removeEventListener: false,
		Request: false,
		Response: false,
		self: true,
		ServiceWorkerRegistration: false,
		setInterval: false,
		setTimeout: false,
		TextDecoder: false,
		TextEncoder: false,
		URL: false,
		URLSearchParams: false,
		WebSocket: false,
		Worker: false,
		WorkerGlobalScope: false,
		XMLHttpRequest: false
	};
	var node$1 = {
		__dirname: false,
		__filename: false,
		Buffer: false,
		clearImmediate: false,
		clearInterval: false,
		clearTimeout: false,
		console: false,
		exports: true,
		global: false,
		"Intl": false,
		module: false,
		process: false,
		queueMicrotask: false,
		require: false,
		setImmediate: false,
		setInterval: false,
		setTimeout: false,
		TextDecoder: false,
		TextEncoder: false,
		URL: false,
		URLSearchParams: false
	};
	var commonjs = {
		exports: true,
		global: false,
		module: false,
		require: false
	};
	var amd = {
		define: false,
		require: false
	};
	var mocha = {
		after: false,
		afterEach: false,
		before: false,
		beforeEach: false,
		context: false,
		describe: false,
		it: false,
		mocha: false,
		run: false,
		setup: false,
		specify: false,
		suite: false,
		suiteSetup: false,
		suiteTeardown: false,
		teardown: false,
		test: false,
		xcontext: false,
		xdescribe: false,
		xit: false,
		xspecify: false
	};
	var jasmine = {
		afterAll: false,
		afterEach: false,
		beforeAll: false,
		beforeEach: false,
		describe: false,
		expect: false,
		fail: false,
		fdescribe: false,
		fit: false,
		it: false,
		jasmine: false,
		pending: false,
		runs: false,
		spyOn: false,
		spyOnProperty: false,
		waits: false,
		waitsFor: false,
		xdescribe: false,
		xit: false
	};
	var jest = {
		afterAll: false,
		afterEach: false,
		beforeAll: false,
		beforeEach: false,
		describe: false,
		expect: false,
		fdescribe: false,
		fit: false,
		it: false,
		jest: false,
		pit: false,
		require: false,
		test: false,
		xdescribe: false,
		xit: false,
		xtest: false
	};
	var qunit = {
		asyncTest: false,
		deepEqual: false,
		equal: false,
		expect: false,
		module: false,
		notDeepEqual: false,
		notEqual: false,
		notOk: false,
		notPropEqual: false,
		notStrictEqual: false,
		ok: false,
		propEqual: false,
		QUnit: false,
		raises: false,
		start: false,
		stop: false,
		strictEqual: false,
		test: false,
		throws: false
	};
	var phantomjs = {
		console: true,
		exports: true,
		phantom: true,
		require: true,
		WebPage: true
	};
	var couch = {
		emit: false,
		exports: false,
		getRow: false,
		log: false,
		module: false,
		provides: false,
		require: false,
		respond: false,
		send: false,
		start: false,
		sum: false
	};
	var rhino = {
		defineClass: false,
		deserialize: false,
		gc: false,
		help: false,
		importClass: false,
		importPackage: false,
		java: false,
		load: false,
		loadClass: false,
		Packages: false,
		print: false,
		quit: false,
		readFile: false,
		readUrl: false,
		runCommand: false,
		seal: false,
		serialize: false,
		spawn: false,
		sync: false,
		toint32: false,
		version: false
	};
	var nashorn = {
		__DIR__: false,
		__FILE__: false,
		__LINE__: false,
		com: false,
		edu: false,
		exit: false,
		java: false,
		Java: false,
		javafx: false,
		JavaImporter: false,
		javax: false,
		JSAdapter: false,
		load: false,
		loadWithNewGlobal: false,
		org: false,
		Packages: false,
		print: false,
		quit: false
	};
	var wsh = {
		ActiveXObject: true,
		Enumerator: true,
		GetObject: true,
		ScriptEngine: true,
		ScriptEngineBuildVersion: true,
		ScriptEngineMajorVersion: true,
		ScriptEngineMinorVersion: true,
		VBArray: true,
		WScript: true,
		WSH: true,
		XDomainRequest: true
	};
	var jquery = {
		$: false,
		jQuery: false
	};
	var yui = {
		YAHOO: false,
		YAHOO_config: false,
		YUI: false,
		YUI_config: false
	};
	var shelljs = {
		cat: false,
		cd: false,
		chmod: false,
		config: false,
		cp: false,
		dirs: false,
		echo: false,
		env: false,
		error: false,
		exec: false,
		exit: false,
		find: false,
		grep: false,
		ln: false,
		ls: false,
		mkdir: false,
		mv: false,
		popd: false,
		pushd: false,
		pwd: false,
		rm: false,
		sed: false,
		set: false,
		target: false,
		tempdir: false,
		test: false,
		touch: false,
		which: false
	};
	var prototypejs = {
		$: false,
		$$: false,
		$A: false,
		$break: false,
		$continue: false,
		$F: false,
		$H: false,
		$R: false,
		$w: false,
		Abstract: false,
		Ajax: false,
		Autocompleter: false,
		Builder: false,
		Class: false,
		Control: false,
		Draggable: false,
		Draggables: false,
		Droppables: false,
		Effect: false,
		Element: false,
		Enumerable: false,
		Event: false,
		Field: false,
		Form: false,
		Hash: false,
		Insertion: false,
		ObjectRange: false,
		PeriodicalExecuter: false,
		Position: false,
		Prototype: false,
		Scriptaculous: false,
		Selector: false,
		Sortable: false,
		SortableObserver: false,
		Sound: false,
		Template: false,
		Toggle: false,
		Try: false
	};
	var meteor = {
		_: false,
		$: false,
		Accounts: false,
		AccountsClient: false,
		AccountsCommon: false,
		AccountsServer: false,
		App: false,
		Assets: false,
		Blaze: false,
		check: false,
		Cordova: false,
		DDP: false,
		DDPRateLimiter: false,
		DDPServer: false,
		Deps: false,
		EJSON: false,
		Email: false,
		HTTP: false,
		Log: false,
		Match: false,
		Meteor: false,
		Mongo: false,
		MongoInternals: false,
		Npm: false,
		Package: false,
		Plugin: false,
		process: false,
		Random: false,
		ReactiveDict: false,
		ReactiveVar: false,
		Router: false,
		ServiceConfiguration: false,
		Session: false,
		share: false,
		Spacebars: false,
		Template: false,
		Tinytest: false,
		Tracker: false,
		UI: false,
		Utils: false,
		WebApp: false,
		WebAppInternals: false
	};
	var mongo = {
		_isWindows: false,
		_rand: false,
		BulkWriteResult: false,
		cat: false,
		cd: false,
		connect: false,
		db: false,
		getHostName: false,
		getMemInfo: false,
		hostname: false,
		ISODate: false,
		listFiles: false,
		load: false,
		ls: false,
		md5sumFile: false,
		mkdir: false,
		Mongo: false,
		NumberInt: false,
		NumberLong: false,
		ObjectId: false,
		PlanCache: false,
		print: false,
		printjson: false,
		pwd: false,
		quit: false,
		removeFile: false,
		rs: false,
		sh: false,
		UUID: false,
		version: false,
		WriteResult: false
	};
	var applescript = {
		$: false,
		Application: false,
		Automation: false,
		console: false,
		delay: false,
		Library: false,
		ObjC: false,
		ObjectSpecifier: false,
		Path: false,
		Progress: false,
		Ref: false
	};
	var serviceworker = {
		addEventListener: false,
		applicationCache: false,
		atob: false,
		Blob: false,
		BroadcastChannel: false,
		btoa: false,
		Cache: false,
		caches: false,
		CacheStorage: false,
		clearInterval: false,
		clearTimeout: false,
		Client: false,
		clients: false,
		Clients: false,
		close: true,
		console: false,
		ExtendableEvent: false,
		ExtendableMessageEvent: false,
		fetch: false,
		FetchEvent: false,
		FileReaderSync: false,
		FormData: false,
		Headers: false,
		IDBCursor: false,
		IDBCursorWithValue: false,
		IDBDatabase: false,
		IDBFactory: false,
		IDBIndex: false,
		IDBKeyRange: false,
		IDBObjectStore: false,
		IDBOpenDBRequest: false,
		IDBRequest: false,
		IDBTransaction: false,
		IDBVersionChangeEvent: false,
		ImageData: false,
		importScripts: false,
		indexedDB: false,
		location: false,
		MessageChannel: false,
		MessagePort: false,
		name: false,
		navigator: false,
		Notification: false,
		onclose: true,
		onconnect: true,
		onerror: true,
		onfetch: true,
		oninstall: true,
		onlanguagechange: true,
		onmessage: true,
		onmessageerror: true,
		onnotificationclick: true,
		onnotificationclose: true,
		onoffline: true,
		ononline: true,
		onpush: true,
		onpushsubscriptionchange: true,
		onrejectionhandled: true,
		onsync: true,
		onunhandledrejection: true,
		performance: false,
		Performance: false,
		PerformanceEntry: false,
		PerformanceMark: false,
		PerformanceMeasure: false,
		PerformanceNavigation: false,
		PerformanceResourceTiming: false,
		PerformanceTiming: false,
		postMessage: true,
		"Promise": false,
		queueMicrotask: false,
		registration: false,
		removeEventListener: false,
		Request: false,
		Response: false,
		self: false,
		ServiceWorker: false,
		ServiceWorkerContainer: false,
		ServiceWorkerGlobalScope: false,
		ServiceWorkerMessageEvent: false,
		ServiceWorkerRegistration: false,
		setInterval: false,
		setTimeout: false,
		skipWaiting: false,
		TextDecoder: false,
		TextEncoder: false,
		URL: false,
		URLSearchParams: false,
		WebSocket: false,
		WindowClient: false,
		Worker: false,
		WorkerGlobalScope: false,
		XMLHttpRequest: false
	};
	var atomtest = {
		advanceClock: false,
		fakeClearInterval: false,
		fakeClearTimeout: false,
		fakeSetInterval: false,
		fakeSetTimeout: false,
		resetTimeouts: false,
		waitsForPromise: false
	};
	var embertest = {
		andThen: false,
		click: false,
		currentPath: false,
		currentRouteName: false,
		currentURL: false,
		fillIn: false,
		find: false,
		findAll: false,
		findWithAssert: false,
		keyEvent: false,
		pauseTest: false,
		resumeTest: false,
		triggerEvent: false,
		visit: false,
		wait: false
	};
	var protractor = {
		$: false,
		$$: false,
		browser: false,
		by: false,
		By: false,
		DartObject: false,
		element: false,
		protractor: false
	};
	var webextensions = {
		browser: false,
		chrome: false,
		opr: false
	};
	var greasemonkey = {
		cloneInto: false,
		createObjectIn: false,
		exportFunction: false,
		GM: false,
		GM_addStyle: false,
		GM_deleteValue: false,
		GM_getResourceText: false,
		GM_getResourceURL: false,
		GM_getValue: false,
		GM_info: false,
		GM_listValues: false,
		GM_log: false,
		GM_openInTab: false,
		GM_registerMenuCommand: false,
		GM_setClipboard: false,
		GM_setValue: false,
		GM_xmlhttpRequest: false,
		unsafeWindow: false
	};
	var devtools = {
		$: false,
		$_: false,
		$$: false,
		$0: false,
		$1: false,
		$2: false,
		$3: false,
		$4: false,
		$x: false,
		chrome: false,
		clear: false,
		copy: false,
		debug: false,
		dir: false,
		dirxml: false,
		getEventListeners: false,
		inspect: false,
		keys: false,
		monitor: false,
		monitorEvents: false,
		profile: false,
		profileEnd: false,
		queryObjects: false,
		table: false,
		undebug: false,
		unmonitor: false,
		unmonitorEvents: false,
		values: false
	};
	var globals = {
		builtin: builtin,
		es5: es5,
		es2015: es2015,
		es2017: es2017,
		browser: browser$3,
		worker: worker,
		node: node$1,
		commonjs: commonjs,
		amd: amd,
		mocha: mocha,
		jasmine: jasmine,
		jest: jest,
		qunit: qunit,
		phantomjs: phantomjs,
		couch: couch,
		rhino: rhino,
		nashorn: nashorn,
		wsh: wsh,
		jquery: jquery,
		yui: yui,
		shelljs: shelljs,
		prototypejs: prototypejs,
		meteor: meteor,
		mongo: mongo,
		applescript: applescript,
		serviceworker: serviceworker,
		atomtest: atomtest,
		embertest: embertest,
		protractor: protractor,
		"shared-node-browser": {
		clearInterval: false,
		clearTimeout: false,
		console: false,
		setInterval: false,
		setTimeout: false,
		URL: false,
		URLSearchParams: false
	},
		webextensions: webextensions,
		greasemonkey: greasemonkey,
		devtools: devtools
	};

	var globals$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		builtin: builtin,
		es5: es5,
		es2015: es2015,
		es2017: es2017,
		browser: browser$3,
		worker: worker,
		node: node$1,
		commonjs: commonjs,
		amd: amd,
		mocha: mocha,
		jasmine: jasmine,
		jest: jest,
		qunit: qunit,
		phantomjs: phantomjs,
		couch: couch,
		rhino: rhino,
		nashorn: nashorn,
		wsh: wsh,
		jquery: jquery,
		yui: yui,
		shelljs: shelljs,
		prototypejs: prototypejs,
		meteor: meteor,
		mongo: mongo,
		applescript: applescript,
		serviceworker: serviceworker,
		atomtest: atomtest,
		embertest: embertest,
		protractor: protractor,
		webextensions: webextensions,
		greasemonkey: greasemonkey,
		devtools: devtools,
		'default': globals
	});

	var require$$0 = getCjsExportFromNamespace(globals$1);

	var globals$2 = require$$0;

	var cache = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.clear = clear;
	exports.clearPath = clearPath;
	exports.clearScope = clearScope;
	exports.scope = exports.path = void 0;
	let path = new WeakMap();
	exports.path = path;
	let scope = new WeakMap();
	exports.scope = scope;

	function clear() {
	  clearPath();
	  clearScope();
	}

	function clearPath() {
	  exports.path = path = new WeakMap();
	}

	function clearScope() {
	  exports.scope = scope = new WeakMap();
	}
	});

	unwrapExports(cache);
	var cache_1 = cache.clear;
	var cache_2 = cache.clearPath;
	var cache_3 = cache.clearScope;
	var cache_4 = cache.scope;
	var cache_5 = cache.path;

	var scope = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;

	var _renamer = _interopRequireDefault(renamer);

	var _index = _interopRequireDefault(lib$a);

	var _binding = _interopRequireDefault(binding$1);

	var _globals = _interopRequireDefault(globals$2);

	var t = _interopRequireWildcard(lib$1);



	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function gatherNodeParts(node, parts) {
	  switch (node == null ? void 0 : node.type) {
	    default:
	      if (t.isModuleDeclaration(node)) {
	        if (node.source) {
	          gatherNodeParts(node.source, parts);
	        } else if (node.specifiers && node.specifiers.length) {
	          for (const e of node.specifiers) gatherNodeParts(e, parts);
	        } else if (node.declaration) {
	          gatherNodeParts(node.declaration, parts);
	        }
	      } else if (t.isModuleSpecifier(node)) {
	        gatherNodeParts(node.local, parts);
	      } else if (t.isLiteral(node)) {
	        parts.push(node.value);
	      }

	      break;

	    case "MemberExpression":
	    case "OptionalMemberExpression":
	    case "JSXMemberExpression":
	      gatherNodeParts(node.object, parts);
	      gatherNodeParts(node.property, parts);
	      break;

	    case "Identifier":
	    case "JSXIdentifier":
	      parts.push(node.name);
	      break;

	    case "CallExpression":
	    case "OptionalCallExpression":
	    case "NewExpression":
	      gatherNodeParts(node.callee, parts);
	      break;

	    case "ObjectExpression":
	    case "ObjectPattern":
	      for (const e of node.properties) {
	        gatherNodeParts(e, parts);
	      }

	      break;

	    case "SpreadElement":
	    case "RestElement":
	      gatherNodeParts(node.argument, parts);
	      break;

	    case "ObjectProperty":
	    case "ObjectMethod":
	    case "ClassProperty":
	    case "ClassMethod":
	    case "ClassPrivateProperty":
	    case "ClassPrivateMethod":
	      gatherNodeParts(node.key, parts);
	      break;

	    case "ThisExpression":
	      parts.push("this");
	      break;

	    case "Super":
	      parts.push("super");
	      break;

	    case "Import":
	      parts.push("import");
	      break;

	    case "DoExpression":
	      parts.push("do");
	      break;

	    case "YieldExpression":
	      parts.push("yield");
	      gatherNodeParts(node.argument, parts);
	      break;

	    case "AwaitExpression":
	      parts.push("await");
	      gatherNodeParts(node.argument, parts);
	      break;

	    case "AssignmentExpression":
	      gatherNodeParts(node.left, parts);
	      break;

	    case "VariableDeclarator":
	      gatherNodeParts(node.id, parts);
	      break;

	    case "FunctionExpression":
	    case "FunctionDeclaration":
	    case "ClassExpression":
	    case "ClassDeclaration":
	      gatherNodeParts(node.id, parts);
	      break;

	    case "PrivateName":
	      gatherNodeParts(node.id, parts);
	      break;

	    case "ParenthesizedExpression":
	      gatherNodeParts(node.expression, parts);
	      break;

	    case "UnaryExpression":
	    case "UpdateExpression":
	      gatherNodeParts(node.argument, parts);
	      break;

	    case "MetaProperty":
	      gatherNodeParts(node.meta, parts);
	      gatherNodeParts(node.property, parts);
	      break;

	    case "JSXElement":
	      gatherNodeParts(node.openingElement, parts);
	      break;

	    case "JSXOpeningElement":
	      parts.push(node.name);
	      break;

	    case "JSXFragment":
	      gatherNodeParts(node.openingFragment, parts);
	      break;

	    case "JSXOpeningFragment":
	      parts.push("Fragment");
	      break;

	    case "JSXNamespacedName":
	      gatherNodeParts(node.namespace, parts);
	      gatherNodeParts(node.name, parts);
	      break;
	  }
	}

	const collectorVisitor = {
	  For(path) {
	    for (const key of t.FOR_INIT_KEYS) {
	      const declar = path.get(key);

	      if (declar.isVar()) {
	        const parentScope = path.scope.getFunctionParent() || path.scope.getProgramParent();
	        parentScope.registerBinding("var", declar);
	      }
	    }
	  },

	  Declaration(path) {
	    if (path.isBlockScoped()) return;

	    if (path.isExportDeclaration() && path.get("declaration").isDeclaration()) {
	      return;
	    }

	    const parent = path.scope.getFunctionParent() || path.scope.getProgramParent();
	    parent.registerDeclaration(path);
	  },

	  ReferencedIdentifier(path, state) {
	    state.references.push(path);
	  },

	  ForXStatement(path, state) {
	    const left = path.get("left");

	    if (left.isPattern() || left.isIdentifier()) {
	      state.constantViolations.push(path);
	    }
	  },

	  ExportDeclaration: {
	    exit(path) {
	      const {
	        node,
	        scope
	      } = path;
	      const declar = node.declaration;

	      if (t.isClassDeclaration(declar) || t.isFunctionDeclaration(declar)) {
	        const id = declar.id;
	        if (!id) return;
	        const binding = scope.getBinding(id.name);
	        if (binding) binding.reference(path);
	      } else if (t.isVariableDeclaration(declar)) {
	        for (const decl of declar.declarations) {
	          for (const name of Object.keys(t.getBindingIdentifiers(decl))) {
	            const binding = scope.getBinding(name);
	            if (binding) binding.reference(path);
	          }
	        }
	      }
	    }

	  },

	  LabeledStatement(path) {
	    path.scope.getProgramParent().addGlobal(path.node);
	    path.scope.getBlockParent().registerDeclaration(path);
	  },

	  AssignmentExpression(path, state) {
	    state.assignments.push(path);
	  },

	  UpdateExpression(path, state) {
	    state.constantViolations.push(path);
	  },

	  UnaryExpression(path, state) {
	    if (path.node.operator === "delete") {
	      state.constantViolations.push(path);
	    }
	  },

	  BlockScoped(path) {
	    let scope = path.scope;
	    if (scope.path === path) scope = scope.parent;
	    const parent = scope.getBlockParent();
	    parent.registerDeclaration(path);

	    if (path.isClassDeclaration() && path.node.id) {
	      const id = path.node.id;
	      const name = id.name;
	      path.scope.bindings[name] = path.scope.parent.getBinding(name);
	    }
	  },

	  Block(path) {
	    const paths = path.get("body");

	    for (const bodyPath of paths) {
	      if (bodyPath.isFunctionDeclaration()) {
	        path.scope.getBlockParent().registerDeclaration(bodyPath);
	      }
	    }
	  },

	  CatchClause(path) {
	    path.scope.registerBinding("let", path);
	  },

	  Function(path) {
	    if (path.isFunctionExpression() && path.has("id") && !path.get("id").node[t.NOT_LOCAL_BINDING]) {
	      path.scope.registerBinding("local", path.get("id"), path);
	    }

	    const params = path.get("params");

	    for (const param of params) {
	      path.scope.registerBinding("param", param);
	    }
	  },

	  ClassExpression(path) {
	    if (path.has("id") && !path.get("id").node[t.NOT_LOCAL_BINDING]) {
	      path.scope.registerBinding("local", path);
	    }
	  }

	};
	let uid = 0;

	class Scope {
	  constructor(path) {
	    const {
	      node
	    } = path;

	    const cached = cache.scope.get(node);

	    if ((cached == null ? void 0 : cached.path) === path) {
	      return cached;
	    }

	    cache.scope.set(node, this);

	    this.uid = uid++;
	    this.block = node;
	    this.path = path;
	    this.labels = new Map();
	    this.inited = false;
	  }

	  get parent() {
	    const parent = this.path.findParent(p => p.isScope());
	    return parent == null ? void 0 : parent.scope;
	  }

	  get parentBlock() {
	    return this.path.parent;
	  }

	  get hub() {
	    return this.path.hub;
	  }

	  traverse(node, opts, state) {
	    (0, _index.default)(node, opts, this, state, this.path);
	  }

	  generateDeclaredUidIdentifier(name) {
	    const id = this.generateUidIdentifier(name);
	    this.push({
	      id
	    });
	    return t.cloneNode(id);
	  }

	  generateUidIdentifier(name) {
	    return t.identifier(this.generateUid(name));
	  }

	  generateUid(name = "temp") {
	    name = t.toIdentifier(name).replace(/^_+/, "").replace(/[0-9]+$/g, "");
	    let uid;
	    let i = 1;

	    do {
	      uid = this._generateUid(name, i);
	      i++;
	    } while (this.hasLabel(uid) || this.hasBinding(uid) || this.hasGlobal(uid) || this.hasReference(uid));

	    const program = this.getProgramParent();
	    program.references[uid] = true;
	    program.uids[uid] = true;
	    return uid;
	  }

	  _generateUid(name, i) {
	    let id = name;
	    if (i > 1) id += i;
	    return `_${id}`;
	  }

	  generateUidBasedOnNode(node, defaultName) {
	    const parts = [];
	    gatherNodeParts(node, parts);
	    let id = parts.join("$");
	    id = id.replace(/^_/, "") || defaultName || "ref";
	    return this.generateUid(id.slice(0, 20));
	  }

	  generateUidIdentifierBasedOnNode(node, defaultName) {
	    return t.identifier(this.generateUidBasedOnNode(node, defaultName));
	  }

	  isStatic(node) {
	    if (t.isThisExpression(node) || t.isSuper(node)) {
	      return true;
	    }

	    if (t.isIdentifier(node)) {
	      const binding = this.getBinding(node.name);

	      if (binding) {
	        return binding.constant;
	      } else {
	        return this.hasBinding(node.name);
	      }
	    }

	    return false;
	  }

	  maybeGenerateMemoised(node, dontPush) {
	    if (this.isStatic(node)) {
	      return null;
	    } else {
	      const id = this.generateUidIdentifierBasedOnNode(node);

	      if (!dontPush) {
	        this.push({
	          id
	        });
	        return t.cloneNode(id);
	      }

	      return id;
	    }
	  }

	  checkBlockScopedCollisions(local, kind, name, id) {
	    if (kind === "param") return;
	    if (local.kind === "local") return;
	    const duplicate = kind === "let" || local.kind === "let" || local.kind === "const" || local.kind === "module" || local.kind === "param" && (kind === "let" || kind === "const");

	    if (duplicate) {
	      throw this.hub.buildError(id, `Duplicate declaration "${name}"`, TypeError);
	    }
	  }

	  rename(oldName, newName, block) {
	    const binding = this.getBinding(oldName);

	    if (binding) {
	      newName = newName || this.generateUidIdentifier(oldName).name;
	      return new _renamer.default(binding, oldName, newName).rename(block);
	    }
	  }

	  _renameFromMap(map, oldName, newName, value) {
	    if (map[oldName]) {
	      map[newName] = value;
	      map[oldName] = null;
	    }
	  }

	  dump() {
	    const sep = "-".repeat(60);
	    console.log(sep);
	    let scope = this;

	    do {
	      console.log("#", scope.block.type);

	      for (const name of Object.keys(scope.bindings)) {
	        const binding = scope.bindings[name];
	        console.log(" -", name, {
	          constant: binding.constant,
	          references: binding.references,
	          violations: binding.constantViolations.length,
	          kind: binding.kind
	        });
	      }
	    } while (scope = scope.parent);

	    console.log(sep);
	  }

	  toArray(node, i, allowArrayLike) {
	    if (t.isIdentifier(node)) {
	      const binding = this.getBinding(node.name);

	      if ((binding == null ? void 0 : binding.constant) && binding.path.isGenericType("Array")) {
	        return node;
	      }
	    }

	    if (t.isArrayExpression(node)) {
	      return node;
	    }

	    if (t.isIdentifier(node, {
	      name: "arguments"
	    })) {
	      return t.callExpression(t.memberExpression(t.memberExpression(t.memberExpression(t.identifier("Array"), t.identifier("prototype")), t.identifier("slice")), t.identifier("call")), [node]);
	    }

	    let helperName;
	    const args = [node];

	    if (i === true) {
	      helperName = "toConsumableArray";
	    } else if (i) {
	      args.push(t.numericLiteral(i));
	      helperName = "slicedToArray";
	    } else {
	      helperName = "toArray";
	    }

	    if (allowArrayLike) {
	      args.unshift(this.hub.addHelper(helperName));
	      helperName = "maybeArrayLike";
	    }

	    return t.callExpression(this.hub.addHelper(helperName), args);
	  }

	  hasLabel(name) {
	    return !!this.getLabel(name);
	  }

	  getLabel(name) {
	    return this.labels.get(name);
	  }

	  registerLabel(path) {
	    this.labels.set(path.node.label.name, path);
	  }

	  registerDeclaration(path) {
	    if (path.isLabeledStatement()) {
	      this.registerLabel(path);
	    } else if (path.isFunctionDeclaration()) {
	      this.registerBinding("hoisted", path.get("id"), path);
	    } else if (path.isVariableDeclaration()) {
	      const declarations = path.get("declarations");

	      for (const declar of declarations) {
	        this.registerBinding(path.node.kind, declar);
	      }
	    } else if (path.isClassDeclaration()) {
	      this.registerBinding("let", path);
	    } else if (path.isImportDeclaration()) {
	      const specifiers = path.get("specifiers");

	      for (const specifier of specifiers) {
	        this.registerBinding("module", specifier);
	      }
	    } else if (path.isExportDeclaration()) {
	      const declar = path.get("declaration");

	      if (declar.isClassDeclaration() || declar.isFunctionDeclaration() || declar.isVariableDeclaration()) {
	        this.registerDeclaration(declar);
	      }
	    } else {
	      this.registerBinding("unknown", path);
	    }
	  }

	  buildUndefinedNode() {
	    return t.unaryExpression("void", t.numericLiteral(0), true);
	  }

	  registerConstantViolation(path) {
	    const ids = path.getBindingIdentifiers();

	    for (const name of Object.keys(ids)) {
	      const binding = this.getBinding(name);
	      if (binding) binding.reassign(path);
	    }
	  }

	  registerBinding(kind, path, bindingPath = path) {
	    if (!kind) throw new ReferenceError("no `kind`");

	    if (path.isVariableDeclaration()) {
	      const declarators = path.get("declarations");

	      for (const declar of declarators) {
	        this.registerBinding(kind, declar);
	      }

	      return;
	    }

	    const parent = this.getProgramParent();
	    const ids = path.getOuterBindingIdentifiers(true);

	    for (const name of Object.keys(ids)) {
	      parent.references[name] = true;

	      for (const id of ids[name]) {
	        const local = this.getOwnBinding(name);

	        if (local) {
	          if (local.identifier === id) continue;
	          this.checkBlockScopedCollisions(local, kind, name, id);
	        }

	        if (local) {
	          this.registerConstantViolation(bindingPath);
	        } else {
	          this.bindings[name] = new _binding.default({
	            identifier: id,
	            scope: this,
	            path: bindingPath,
	            kind: kind
	          });
	        }
	      }
	    }
	  }

	  addGlobal(node) {
	    this.globals[node.name] = node;
	  }

	  hasUid(name) {
	    let scope = this;

	    do {
	      if (scope.uids[name]) return true;
	    } while (scope = scope.parent);

	    return false;
	  }

	  hasGlobal(name) {
	    let scope = this;

	    do {
	      if (scope.globals[name]) return true;
	    } while (scope = scope.parent);

	    return false;
	  }

	  hasReference(name) {
	    return !!this.getProgramParent().references[name];
	  }

	  isPure(node, constantsOnly) {
	    if (t.isIdentifier(node)) {
	      const binding = this.getBinding(node.name);
	      if (!binding) return false;
	      if (constantsOnly) return binding.constant;
	      return true;
	    } else if (t.isClass(node)) {
	      if (node.superClass && !this.isPure(node.superClass, constantsOnly)) {
	        return false;
	      }

	      return this.isPure(node.body, constantsOnly);
	    } else if (t.isClassBody(node)) {
	      for (const method of node.body) {
	        if (!this.isPure(method, constantsOnly)) return false;
	      }

	      return true;
	    } else if (t.isBinary(node)) {
	      return this.isPure(node.left, constantsOnly) && this.isPure(node.right, constantsOnly);
	    } else if (t.isArrayExpression(node)) {
	      for (const elem of node.elements) {
	        if (!this.isPure(elem, constantsOnly)) return false;
	      }

	      return true;
	    } else if (t.isObjectExpression(node)) {
	      for (const prop of node.properties) {
	        if (!this.isPure(prop, constantsOnly)) return false;
	      }

	      return true;
	    } else if (t.isMethod(node)) {
	      if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
	      if (node.kind === "get" || node.kind === "set") return false;
	      return true;
	    } else if (t.isProperty(node)) {
	      if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
	      return this.isPure(node.value, constantsOnly);
	    } else if (t.isUnaryExpression(node)) {
	      return this.isPure(node.argument, constantsOnly);
	    } else if (t.isTaggedTemplateExpression(node)) {
	      return t.matchesPattern(node.tag, "String.raw") && !this.hasBinding("String", true) && this.isPure(node.quasi, constantsOnly);
	    } else if (t.isTemplateLiteral(node)) {
	      for (const expression of node.expressions) {
	        if (!this.isPure(expression, constantsOnly)) return false;
	      }

	      return true;
	    } else {
	      return t.isPureish(node);
	    }
	  }

	  setData(key, val) {
	    return this.data[key] = val;
	  }

	  getData(key) {
	    let scope = this;

	    do {
	      const data = scope.data[key];
	      if (data != null) return data;
	    } while (scope = scope.parent);
	  }

	  removeData(key) {
	    let scope = this;

	    do {
	      const data = scope.data[key];
	      if (data != null) scope.data[key] = null;
	    } while (scope = scope.parent);
	  }

	  init() {
	    if (!this.inited) {
	      this.inited = true;
	      this.crawl();
	    }
	  }

	  crawl() {
	    const path = this.path;
	    this.references = Object.create(null);
	    this.bindings = Object.create(null);
	    this.globals = Object.create(null);
	    this.uids = Object.create(null);
	    this.data = Object.create(null);

	    if (path.isFunction()) {
	      if (path.isFunctionExpression() && path.has("id") && !path.get("id").node[t.NOT_LOCAL_BINDING]) {
	        this.registerBinding("local", path.get("id"), path);
	      }

	      const params = path.get("params");

	      for (const param of params) {
	        this.registerBinding("param", param);
	      }
	    }

	    const programParent = this.getProgramParent();
	    if (programParent.crawling) return;
	    const state = {
	      references: [],
	      constantViolations: [],
	      assignments: []
	    };
	    this.crawling = true;
	    path.traverse(collectorVisitor, state);
	    this.crawling = false;

	    for (const path of state.assignments) {
	      const ids = path.getBindingIdentifiers();

	      for (const name of Object.keys(ids)) {
	        if (path.scope.getBinding(name)) continue;
	        programParent.addGlobal(ids[name]);
	      }

	      path.scope.registerConstantViolation(path);
	    }

	    for (const ref of state.references) {
	      const binding = ref.scope.getBinding(ref.node.name);

	      if (binding) {
	        binding.reference(ref);
	      } else {
	        programParent.addGlobal(ref.node);
	      }
	    }

	    for (const path of state.constantViolations) {
	      path.scope.registerConstantViolation(path);
	    }
	  }

	  push(opts) {
	    let path = this.path;

	    if (!path.isBlockStatement() && !path.isProgram()) {
	      path = this.getBlockParent().path;
	    }

	    if (path.isSwitchStatement()) {
	      path = (this.getFunctionParent() || this.getProgramParent()).path;
	    }

	    if (path.isLoop() || path.isCatchClause() || path.isFunction()) {
	      path.ensureBlock();
	      path = path.get("body");
	    }

	    const unique = opts.unique;
	    const kind = opts.kind || "var";
	    const blockHoist = opts._blockHoist == null ? 2 : opts._blockHoist;
	    const dataKey = `declaration:${kind}:${blockHoist}`;
	    let declarPath = !unique && path.getData(dataKey);

	    if (!declarPath) {
	      const declar = t.variableDeclaration(kind, []);
	      declar._blockHoist = blockHoist;
	      [declarPath] = path.unshiftContainer("body", [declar]);
	      if (!unique) path.setData(dataKey, declarPath);
	    }

	    const declarator = t.variableDeclarator(opts.id, opts.init);
	    declarPath.node.declarations.push(declarator);
	    this.registerBinding(kind, declarPath.get("declarations").pop());
	  }

	  getProgramParent() {
	    let scope = this;

	    do {
	      if (scope.path.isProgram()) {
	        return scope;
	      }
	    } while (scope = scope.parent);

	    throw new Error("Couldn't find a Program");
	  }

	  getFunctionParent() {
	    let scope = this;

	    do {
	      if (scope.path.isFunctionParent()) {
	        return scope;
	      }
	    } while (scope = scope.parent);

	    return null;
	  }

	  getBlockParent() {
	    let scope = this;

	    do {
	      if (scope.path.isBlockParent()) {
	        return scope;
	      }
	    } while (scope = scope.parent);

	    throw new Error("We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...");
	  }

	  getAllBindings() {
	    const ids = Object.create(null);
	    let scope = this;

	    do {
	      for (const key of Object.keys(scope.bindings)) {
	        if (key in ids === false) {
	          ids[key] = scope.bindings[key];
	        }
	      }

	      scope = scope.parent;
	    } while (scope);

	    return ids;
	  }

	  getAllBindingsOfKind() {
	    const ids = Object.create(null);

	    for (const kind of arguments) {
	      let scope = this;

	      do {
	        for (const name of Object.keys(scope.bindings)) {
	          const binding = scope.bindings[name];
	          if (binding.kind === kind) ids[name] = binding;
	        }

	        scope = scope.parent;
	      } while (scope);
	    }

	    return ids;
	  }

	  bindingIdentifierEquals(name, node) {
	    return this.getBindingIdentifier(name) === node;
	  }

	  getBinding(name) {
	    let scope = this;
	    let previousPath;

	    do {
	      const binding = scope.getOwnBinding(name);

	      if (binding) {
	        var _previousPath;

	        if (((_previousPath = previousPath) == null ? void 0 : _previousPath.isPattern()) && binding.kind !== "param") ; else {
	          return binding;
	        }
	      }

	      previousPath = scope.path;
	    } while (scope = scope.parent);
	  }

	  getOwnBinding(name) {
	    return this.bindings[name];
	  }

	  getBindingIdentifier(name) {
	    var _this$getBinding;

	    return (_this$getBinding = this.getBinding(name)) == null ? void 0 : _this$getBinding.identifier;
	  }

	  getOwnBindingIdentifier(name) {
	    const binding = this.bindings[name];
	    return binding == null ? void 0 : binding.identifier;
	  }

	  hasOwnBinding(name) {
	    return !!this.getOwnBinding(name);
	  }

	  hasBinding(name, noGlobals) {
	    if (!name) return false;
	    if (this.hasOwnBinding(name)) return true;
	    if (this.parentHasBinding(name, noGlobals)) return true;
	    if (this.hasUid(name)) return true;
	    if (!noGlobals && Scope.globals.includes(name)) return true;
	    if (!noGlobals && Scope.contextVariables.includes(name)) return true;
	    return false;
	  }

	  parentHasBinding(name, noGlobals) {
	    var _this$parent;

	    return (_this$parent = this.parent) == null ? void 0 : _this$parent.hasBinding(name, noGlobals);
	  }

	  moveBindingTo(name, scope) {
	    const info = this.getBinding(name);

	    if (info) {
	      info.scope.removeOwnBinding(name);
	      info.scope = scope;
	      scope.bindings[name] = info;
	    }
	  }

	  removeOwnBinding(name) {
	    delete this.bindings[name];
	  }

	  removeBinding(name) {
	    var _this$getBinding2;

	    (_this$getBinding2 = this.getBinding(name)) == null ? void 0 : _this$getBinding2.scope.removeOwnBinding(name);
	    let scope = this;

	    do {
	      if (scope.uids[name]) {
	        scope.uids[name] = false;
	      }
	    } while (scope = scope.parent);
	  }

	}

	exports.default = Scope;
	Scope.globals = Object.keys(_globals.default.builtin);
	Scope.contextVariables = ["arguments", "undefined", "Infinity", "NaN"];
	});

	unwrapExports(scope);

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

	/**
	 * Encode an integer in the range of 0 to 63 to a single base 64 digit.
	 */
	var encode = function (number) {
	  if (0 <= number && number < intToCharMap.length) {
	    return intToCharMap[number];
	  }
	  throw new TypeError("Must be between 0 and 63: " + number);
	};

	/**
	 * Decode a single base 64 character code digit to an integer. Returns -1 on
	 * failure.
	 */
	var decode = function (charCode) {
	  var bigA = 65;     // 'A'
	  var bigZ = 90;     // 'Z'

	  var littleA = 97;  // 'a'
	  var littleZ = 122; // 'z'

	  var zero = 48;     // '0'
	  var nine = 57;     // '9'

	  var plus = 43;     // '+'
	  var slash = 47;    // '/'

	  var littleOffset = 26;
	  var numberOffset = 52;

	  // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
	  if (bigA <= charCode && charCode <= bigZ) {
	    return (charCode - bigA);
	  }

	  // 26 - 51: abcdefghijklmnopqrstuvwxyz
	  if (littleA <= charCode && charCode <= littleZ) {
	    return (charCode - littleA + littleOffset);
	  }

	  // 52 - 61: 0123456789
	  if (zero <= charCode && charCode <= nine) {
	    return (charCode - zero + numberOffset);
	  }

	  // 62: +
	  if (charCode == plus) {
	    return 62;
	  }

	  // 63: /
	  if (charCode == slash) {
	    return 63;
	  }

	  // Invalid base64 digit.
	  return -1;
	};

	var base64 = {
		encode: encode,
		decode: decode
	};

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 *
	 * Based on the Base 64 VLQ implementation in Closure Compiler:
	 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
	 *
	 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions are
	 * met:
	 *
	 *  * Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 *  * Redistributions in binary form must reproduce the above
	 *    copyright notice, this list of conditions and the following
	 *    disclaimer in the documentation and/or other materials provided
	 *    with the distribution.
	 *  * Neither the name of Google Inc. nor the names of its
	 *    contributors may be used to endorse or promote products derived
	 *    from this software without specific prior written permission.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
	 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
	 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
	 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	 */



	// A single base 64 digit can contain 6 bits of data. For the base 64 variable
	// length quantities we use in the source map spec, the first bit is the sign,
	// the next four bits are the actual value, and the 6th bit is the
	// continuation bit. The continuation bit tells us whether there are more
	// digits in this value following this digit.
	//
	//   Continuation
	//   |    Sign
	//   |    |
	//   V    V
	//   101011

	var VLQ_BASE_SHIFT = 5;

	// binary: 100000
	var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

	// binary: 011111
	var VLQ_BASE_MASK = VLQ_BASE - 1;

	// binary: 100000
	var VLQ_CONTINUATION_BIT = VLQ_BASE;

	/**
	 * Converts from a two-complement value to a value where the sign bit is
	 * placed in the least significant bit.  For example, as decimals:
	 *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
	 *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
	 */
	function toVLQSigned(aValue) {
	  return aValue < 0
	    ? ((-aValue) << 1) + 1
	    : (aValue << 1) + 0;
	}

	/**
	 * Converts to a two-complement value from a value where the sign bit is
	 * placed in the least significant bit.  For example, as decimals:
	 *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
	 *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
	 */
	function fromVLQSigned(aValue) {
	  var isNegative = (aValue & 1) === 1;
	  var shifted = aValue >> 1;
	  return isNegative
	    ? -shifted
	    : shifted;
	}

	/**
	 * Returns the base 64 VLQ encoded value.
	 */
	var encode$1 = function base64VLQ_encode(aValue) {
	  var encoded = "";
	  var digit;

	  var vlq = toVLQSigned(aValue);

	  do {
	    digit = vlq & VLQ_BASE_MASK;
	    vlq >>>= VLQ_BASE_SHIFT;
	    if (vlq > 0) {
	      // There are still more digits in this value, so we must make sure the
	      // continuation bit is marked.
	      digit |= VLQ_CONTINUATION_BIT;
	    }
	    encoded += base64.encode(digit);
	  } while (vlq > 0);

	  return encoded;
	};

	/**
	 * Decodes the next base 64 VLQ value from the given string and returns the
	 * value and the rest of the string via the out parameter.
	 */
	var decode$1 = function base64VLQ_decode(aStr, aIndex, aOutParam) {
	  var strLen = aStr.length;
	  var result = 0;
	  var shift = 0;
	  var continuation, digit;

	  do {
	    if (aIndex >= strLen) {
	      throw new Error("Expected more digits in base 64 VLQ value.");
	    }

	    digit = base64.decode(aStr.charCodeAt(aIndex++));
	    if (digit === -1) {
	      throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
	    }

	    continuation = !!(digit & VLQ_CONTINUATION_BIT);
	    digit &= VLQ_BASE_MASK;
	    result = result + (digit << shift);
	    shift += VLQ_BASE_SHIFT;
	  } while (continuation);

	  aOutParam.value = fromVLQSigned(result);
	  aOutParam.rest = aIndex;
	};

	var base64Vlq = {
		encode: encode$1,
		decode: decode$1
	};

	var util$3 = createCommonjsModule(function (module, exports) {
	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	/**
	 * This is a helper function for getting values from parameter/options
	 * objects.
	 *
	 * @param args The object we are extracting values from
	 * @param name The name of the property we are getting.
	 * @param defaultValue An optional value to return if the property is missing
	 * from the object. If this is not specified and the property is missing, an
	 * error will be thrown.
	 */
	function getArg(aArgs, aName, aDefaultValue) {
	  if (aName in aArgs) {
	    return aArgs[aName];
	  } else if (arguments.length === 3) {
	    return aDefaultValue;
	  } else {
	    throw new Error('"' + aName + '" is a required argument.');
	  }
	}
	exports.getArg = getArg;

	var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
	var dataUrlRegexp = /^data:.+\,.+$/;

	function urlParse(aUrl) {
	  var match = aUrl.match(urlRegexp);
	  if (!match) {
	    return null;
	  }
	  return {
	    scheme: match[1],
	    auth: match[2],
	    host: match[3],
	    port: match[4],
	    path: match[5]
	  };
	}
	exports.urlParse = urlParse;

	function urlGenerate(aParsedUrl) {
	  var url = '';
	  if (aParsedUrl.scheme) {
	    url += aParsedUrl.scheme + ':';
	  }
	  url += '//';
	  if (aParsedUrl.auth) {
	    url += aParsedUrl.auth + '@';
	  }
	  if (aParsedUrl.host) {
	    url += aParsedUrl.host;
	  }
	  if (aParsedUrl.port) {
	    url += ":" + aParsedUrl.port;
	  }
	  if (aParsedUrl.path) {
	    url += aParsedUrl.path;
	  }
	  return url;
	}
	exports.urlGenerate = urlGenerate;

	/**
	 * Normalizes a path, or the path portion of a URL:
	 *
	 * - Replaces consecutive slashes with one slash.
	 * - Removes unnecessary '.' parts.
	 * - Removes unnecessary '<dir>/..' parts.
	 *
	 * Based on code in the Node.js 'path' core module.
	 *
	 * @param aPath The path or url to normalize.
	 */
	function normalize(aPath) {
	  var path = aPath;
	  var url = urlParse(aPath);
	  if (url) {
	    if (!url.path) {
	      return aPath;
	    }
	    path = url.path;
	  }
	  var isAbsolute = exports.isAbsolute(path);

	  var parts = path.split(/\/+/);
	  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
	    part = parts[i];
	    if (part === '.') {
	      parts.splice(i, 1);
	    } else if (part === '..') {
	      up++;
	    } else if (up > 0) {
	      if (part === '') {
	        // The first part is blank if the path is absolute. Trying to go
	        // above the root is a no-op. Therefore we can remove all '..' parts
	        // directly after the root.
	        parts.splice(i + 1, up);
	        up = 0;
	      } else {
	        parts.splice(i, 2);
	        up--;
	      }
	    }
	  }
	  path = parts.join('/');

	  if (path === '') {
	    path = isAbsolute ? '/' : '.';
	  }

	  if (url) {
	    url.path = path;
	    return urlGenerate(url);
	  }
	  return path;
	}
	exports.normalize = normalize;

	/**
	 * Joins two paths/URLs.
	 *
	 * @param aRoot The root path or URL.
	 * @param aPath The path or URL to be joined with the root.
	 *
	 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
	 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
	 *   first.
	 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
	 *   is updated with the result and aRoot is returned. Otherwise the result
	 *   is returned.
	 *   - If aPath is absolute, the result is aPath.
	 *   - Otherwise the two paths are joined with a slash.
	 * - Joining for example 'http://' and 'www.example.com' is also supported.
	 */
	function join(aRoot, aPath) {
	  if (aRoot === "") {
	    aRoot = ".";
	  }
	  if (aPath === "") {
	    aPath = ".";
	  }
	  var aPathUrl = urlParse(aPath);
	  var aRootUrl = urlParse(aRoot);
	  if (aRootUrl) {
	    aRoot = aRootUrl.path || '/';
	  }

	  // `join(foo, '//www.example.org')`
	  if (aPathUrl && !aPathUrl.scheme) {
	    if (aRootUrl) {
	      aPathUrl.scheme = aRootUrl.scheme;
	    }
	    return urlGenerate(aPathUrl);
	  }

	  if (aPathUrl || aPath.match(dataUrlRegexp)) {
	    return aPath;
	  }

	  // `join('http://', 'www.example.com')`
	  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
	    aRootUrl.host = aPath;
	    return urlGenerate(aRootUrl);
	  }

	  var joined = aPath.charAt(0) === '/'
	    ? aPath
	    : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

	  if (aRootUrl) {
	    aRootUrl.path = joined;
	    return urlGenerate(aRootUrl);
	  }
	  return joined;
	}
	exports.join = join;

	exports.isAbsolute = function (aPath) {
	  return aPath.charAt(0) === '/' || !!aPath.match(urlRegexp);
	};

	/**
	 * Make a path relative to a URL or another path.
	 *
	 * @param aRoot The root path or URL.
	 * @param aPath The path or URL to be made relative to aRoot.
	 */
	function relative(aRoot, aPath) {
	  if (aRoot === "") {
	    aRoot = ".";
	  }

	  aRoot = aRoot.replace(/\/$/, '');

	  // It is possible for the path to be above the root. In this case, simply
	  // checking whether the root is a prefix of the path won't work. Instead, we
	  // need to remove components from the root one by one, until either we find
	  // a prefix that fits, or we run out of components to remove.
	  var level = 0;
	  while (aPath.indexOf(aRoot + '/') !== 0) {
	    var index = aRoot.lastIndexOf("/");
	    if (index < 0) {
	      return aPath;
	    }

	    // If the only part of the root that is left is the scheme (i.e. http://,
	    // file:///, etc.), one or more slashes (/), or simply nothing at all, we
	    // have exhausted all components, so the path is not relative to the root.
	    aRoot = aRoot.slice(0, index);
	    if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
	      return aPath;
	    }

	    ++level;
	  }

	  // Make sure we add a "../" for each component we removed from the root.
	  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
	}
	exports.relative = relative;

	var supportsNullProto = (function () {
	  var obj = Object.create(null);
	  return !('__proto__' in obj);
	}());

	function identity (s) {
	  return s;
	}

	/**
	 * Because behavior goes wacky when you set `__proto__` on objects, we
	 * have to prefix all the strings in our set with an arbitrary character.
	 *
	 * See https://github.com/mozilla/source-map/pull/31 and
	 * https://github.com/mozilla/source-map/issues/30
	 *
	 * @param String aStr
	 */
	function toSetString(aStr) {
	  if (isProtoString(aStr)) {
	    return '$' + aStr;
	  }

	  return aStr;
	}
	exports.toSetString = supportsNullProto ? identity : toSetString;

	function fromSetString(aStr) {
	  if (isProtoString(aStr)) {
	    return aStr.slice(1);
	  }

	  return aStr;
	}
	exports.fromSetString = supportsNullProto ? identity : fromSetString;

	function isProtoString(s) {
	  if (!s) {
	    return false;
	  }

	  var length = s.length;

	  if (length < 9 /* "__proto__".length */) {
	    return false;
	  }

	  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
	      s.charCodeAt(length - 2) !== 95  /* '_' */ ||
	      s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
	      s.charCodeAt(length - 4) !== 116 /* 't' */ ||
	      s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
	      s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
	      s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
	      s.charCodeAt(length - 8) !== 95  /* '_' */ ||
	      s.charCodeAt(length - 9) !== 95  /* '_' */) {
	    return false;
	  }

	  for (var i = length - 10; i >= 0; i--) {
	    if (s.charCodeAt(i) !== 36 /* '$' */) {
	      return false;
	    }
	  }

	  return true;
	}

	/**
	 * Comparator between two mappings where the original positions are compared.
	 *
	 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
	 * mappings with the same original source/line/column, but different generated
	 * line and column the same. Useful when searching for a mapping with a
	 * stubbed out mapping.
	 */
	function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
	  var cmp = mappingA.source - mappingB.source;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.originalLine - mappingB.originalLine;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.originalColumn - mappingB.originalColumn;
	  if (cmp !== 0 || onlyCompareOriginal) {
	    return cmp;
	  }

	  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.generatedLine - mappingB.generatedLine;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  return mappingA.name - mappingB.name;
	}
	exports.compareByOriginalPositions = compareByOriginalPositions;

	/**
	 * Comparator between two mappings with deflated source and name indices where
	 * the generated positions are compared.
	 *
	 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
	 * mappings with the same generated line and column, but different
	 * source/name/original line and column the same. Useful when searching for a
	 * mapping with a stubbed out mapping.
	 */
	function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
	  var cmp = mappingA.generatedLine - mappingB.generatedLine;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
	  if (cmp !== 0 || onlyCompareGenerated) {
	    return cmp;
	  }

	  cmp = mappingA.source - mappingB.source;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.originalLine - mappingB.originalLine;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.originalColumn - mappingB.originalColumn;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  return mappingA.name - mappingB.name;
	}
	exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

	function strcmp(aStr1, aStr2) {
	  if (aStr1 === aStr2) {
	    return 0;
	  }

	  if (aStr1 > aStr2) {
	    return 1;
	  }

	  return -1;
	}

	/**
	 * Comparator between two mappings with inflated source and name strings where
	 * the generated positions are compared.
	 */
	function compareByGeneratedPositionsInflated(mappingA, mappingB) {
	  var cmp = mappingA.generatedLine - mappingB.generatedLine;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = strcmp(mappingA.source, mappingB.source);
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.originalLine - mappingB.originalLine;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  cmp = mappingA.originalColumn - mappingB.originalColumn;
	  if (cmp !== 0) {
	    return cmp;
	  }

	  return strcmp(mappingA.name, mappingB.name);
	}
	exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
	});
	var util_1 = util$3.getArg;
	var util_2 = util$3.urlParse;
	var util_3 = util$3.urlGenerate;
	var util_4 = util$3.normalize;
	var util_5 = util$3.join;
	var util_6 = util$3.isAbsolute;
	var util_7 = util$3.relative;
	var util_8 = util$3.toSetString;
	var util_9 = util$3.fromSetString;
	var util_10 = util$3.compareByOriginalPositions;
	var util_11 = util$3.compareByGeneratedPositionsDeflated;
	var util_12 = util$3.compareByGeneratedPositionsInflated;

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */


	var has = Object.prototype.hasOwnProperty;
	var hasNativeMap = typeof Map !== "undefined";

	/**
	 * A data structure which is a combination of an array and a set. Adding a new
	 * member is O(1), testing for membership is O(1), and finding the index of an
	 * element is O(1). Removing elements from the set is not supported. Only
	 * strings are supported for membership.
	 */
	function ArraySet() {
	  this._array = [];
	  this._set = hasNativeMap ? new Map() : Object.create(null);
	}

	/**
	 * Static method for creating ArraySet instances from an existing array.
	 */
	ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
	  var set = new ArraySet();
	  for (var i = 0, len = aArray.length; i < len; i++) {
	    set.add(aArray[i], aAllowDuplicates);
	  }
	  return set;
	};

	/**
	 * Return how many unique items are in this ArraySet. If duplicates have been
	 * added, than those do not count towards the size.
	 *
	 * @returns Number
	 */
	ArraySet.prototype.size = function ArraySet_size() {
	  return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
	};

	/**
	 * Add the given string to this set.
	 *
	 * @param String aStr
	 */
	ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
	  var sStr = hasNativeMap ? aStr : util$3.toSetString(aStr);
	  var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
	  var idx = this._array.length;
	  if (!isDuplicate || aAllowDuplicates) {
	    this._array.push(aStr);
	  }
	  if (!isDuplicate) {
	    if (hasNativeMap) {
	      this._set.set(aStr, idx);
	    } else {
	      this._set[sStr] = idx;
	    }
	  }
	};

	/**
	 * Is the given string a member of this set?
	 *
	 * @param String aStr
	 */
	ArraySet.prototype.has = function ArraySet_has(aStr) {
	  if (hasNativeMap) {
	    return this._set.has(aStr);
	  } else {
	    var sStr = util$3.toSetString(aStr);
	    return has.call(this._set, sStr);
	  }
	};

	/**
	 * What is the index of the given string in the array?
	 *
	 * @param String aStr
	 */
	ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
	  if (hasNativeMap) {
	    var idx = this._set.get(aStr);
	    if (idx >= 0) {
	        return idx;
	    }
	  } else {
	    var sStr = util$3.toSetString(aStr);
	    if (has.call(this._set, sStr)) {
	      return this._set[sStr];
	    }
	  }

	  throw new Error('"' + aStr + '" is not in the set.');
	};

	/**
	 * What is the element at the given index?
	 *
	 * @param Number aIdx
	 */
	ArraySet.prototype.at = function ArraySet_at(aIdx) {
	  if (aIdx >= 0 && aIdx < this._array.length) {
	    return this._array[aIdx];
	  }
	  throw new Error('No element indexed by ' + aIdx);
	};

	/**
	 * Returns the array representation of this set (which has the proper indices
	 * indicated by indexOf). Note that this is a copy of the internal array used
	 * for storing the members so that no one can mess with internal state.
	 */
	ArraySet.prototype.toArray = function ArraySet_toArray() {
	  return this._array.slice();
	};

	var ArraySet_1 = ArraySet;

	var arraySet = {
		ArraySet: ArraySet_1
	};

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2014 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */



	/**
	 * Determine whether mappingB is after mappingA with respect to generated
	 * position.
	 */
	function generatedPositionAfter(mappingA, mappingB) {
	  // Optimized for most common case
	  var lineA = mappingA.generatedLine;
	  var lineB = mappingB.generatedLine;
	  var columnA = mappingA.generatedColumn;
	  var columnB = mappingB.generatedColumn;
	  return lineB > lineA || lineB == lineA && columnB >= columnA ||
	         util$3.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
	}

	/**
	 * A data structure to provide a sorted view of accumulated mappings in a
	 * performance conscious manner. It trades a neglibable overhead in general
	 * case for a large speedup in case of mappings being added in order.
	 */
	function MappingList() {
	  this._array = [];
	  this._sorted = true;
	  // Serves as infimum
	  this._last = {generatedLine: -1, generatedColumn: 0};
	}

	/**
	 * Iterate through internal items. This method takes the same arguments that
	 * `Array.prototype.forEach` takes.
	 *
	 * NOTE: The order of the mappings is NOT guaranteed.
	 */
	MappingList.prototype.unsortedForEach =
	  function MappingList_forEach(aCallback, aThisArg) {
	    this._array.forEach(aCallback, aThisArg);
	  };

	/**
	 * Add the given source mapping.
	 *
	 * @param Object aMapping
	 */
	MappingList.prototype.add = function MappingList_add(aMapping) {
	  if (generatedPositionAfter(this._last, aMapping)) {
	    this._last = aMapping;
	    this._array.push(aMapping);
	  } else {
	    this._sorted = false;
	    this._array.push(aMapping);
	  }
	};

	/**
	 * Returns the flat, sorted array of mappings. The mappings are sorted by
	 * generated position.
	 *
	 * WARNING: This method returns internal data without copying, for
	 * performance. The return value must NOT be mutated, and should be treated as
	 * an immutable borrow. If you want to take ownership, you must make your own
	 * copy.
	 */
	MappingList.prototype.toArray = function MappingList_toArray() {
	  if (!this._sorted) {
	    this._array.sort(util$3.compareByGeneratedPositionsInflated);
	    this._sorted = true;
	  }
	  return this._array;
	};

	var MappingList_1 = MappingList;

	var mappingList = {
		MappingList: MappingList_1
	};

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */



	var ArraySet$1 = arraySet.ArraySet;
	var MappingList$1 = mappingList.MappingList;

	/**
	 * An instance of the SourceMapGenerator represents a source map which is
	 * being built incrementally. You may pass an object with the following
	 * properties:
	 *
	 *   - file: The filename of the generated source.
	 *   - sourceRoot: A root for all relative URLs in this source map.
	 */
	function SourceMapGenerator(aArgs) {
	  if (!aArgs) {
	    aArgs = {};
	  }
	  this._file = util$3.getArg(aArgs, 'file', null);
	  this._sourceRoot = util$3.getArg(aArgs, 'sourceRoot', null);
	  this._skipValidation = util$3.getArg(aArgs, 'skipValidation', false);
	  this._sources = new ArraySet$1();
	  this._names = new ArraySet$1();
	  this._mappings = new MappingList$1();
	  this._sourcesContents = null;
	}

	SourceMapGenerator.prototype._version = 3;

	/**
	 * Creates a new SourceMapGenerator based on a SourceMapConsumer
	 *
	 * @param aSourceMapConsumer The SourceMap.
	 */
	SourceMapGenerator.fromSourceMap =
	  function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
	    var sourceRoot = aSourceMapConsumer.sourceRoot;
	    var generator = new SourceMapGenerator({
	      file: aSourceMapConsumer.file,
	      sourceRoot: sourceRoot
	    });
	    aSourceMapConsumer.eachMapping(function (mapping) {
	      var newMapping = {
	        generated: {
	          line: mapping.generatedLine,
	          column: mapping.generatedColumn
	        }
	      };

	      if (mapping.source != null) {
	        newMapping.source = mapping.source;
	        if (sourceRoot != null) {
	          newMapping.source = util$3.relative(sourceRoot, newMapping.source);
	        }

	        newMapping.original = {
	          line: mapping.originalLine,
	          column: mapping.originalColumn
	        };

	        if (mapping.name != null) {
	          newMapping.name = mapping.name;
	        }
	      }

	      generator.addMapping(newMapping);
	    });
	    aSourceMapConsumer.sources.forEach(function (sourceFile) {
	      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	      if (content != null) {
	        generator.setSourceContent(sourceFile, content);
	      }
	    });
	    return generator;
	  };

	/**
	 * Add a single mapping from original source line and column to the generated
	 * source's line and column for this source map being created. The mapping
	 * object should have the following properties:
	 *
	 *   - generated: An object with the generated line and column positions.
	 *   - original: An object with the original line and column positions.
	 *   - source: The original source file (relative to the sourceRoot).
	 *   - name: An optional original token name for this mapping.
	 */
	SourceMapGenerator.prototype.addMapping =
	  function SourceMapGenerator_addMapping(aArgs) {
	    var generated = util$3.getArg(aArgs, 'generated');
	    var original = util$3.getArg(aArgs, 'original', null);
	    var source = util$3.getArg(aArgs, 'source', null);
	    var name = util$3.getArg(aArgs, 'name', null);

	    if (!this._skipValidation) {
	      this._validateMapping(generated, original, source, name);
	    }

	    if (source != null) {
	      source = String(source);
	      if (!this._sources.has(source)) {
	        this._sources.add(source);
	      }
	    }

	    if (name != null) {
	      name = String(name);
	      if (!this._names.has(name)) {
	        this._names.add(name);
	      }
	    }

	    this._mappings.add({
	      generatedLine: generated.line,
	      generatedColumn: generated.column,
	      originalLine: original != null && original.line,
	      originalColumn: original != null && original.column,
	      source: source,
	      name: name
	    });
	  };

	/**
	 * Set the source content for a source file.
	 */
	SourceMapGenerator.prototype.setSourceContent =
	  function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
	    var source = aSourceFile;
	    if (this._sourceRoot != null) {
	      source = util$3.relative(this._sourceRoot, source);
	    }

	    if (aSourceContent != null) {
	      // Add the source content to the _sourcesContents map.
	      // Create a new _sourcesContents map if the property is null.
	      if (!this._sourcesContents) {
	        this._sourcesContents = Object.create(null);
	      }
	      this._sourcesContents[util$3.toSetString(source)] = aSourceContent;
	    } else if (this._sourcesContents) {
	      // Remove the source file from the _sourcesContents map.
	      // If the _sourcesContents map is empty, set the property to null.
	      delete this._sourcesContents[util$3.toSetString(source)];
	      if (Object.keys(this._sourcesContents).length === 0) {
	        this._sourcesContents = null;
	      }
	    }
	  };

	/**
	 * Applies the mappings of a sub-source-map for a specific source file to the
	 * source map being generated. Each mapping to the supplied source file is
	 * rewritten using the supplied source map. Note: The resolution for the
	 * resulting mappings is the minimium of this map and the supplied map.
	 *
	 * @param aSourceMapConsumer The source map to be applied.
	 * @param aSourceFile Optional. The filename of the source file.
	 *        If omitted, SourceMapConsumer's file property will be used.
	 * @param aSourceMapPath Optional. The dirname of the path to the source map
	 *        to be applied. If relative, it is relative to the SourceMapConsumer.
	 *        This parameter is needed when the two source maps aren't in the same
	 *        directory, and the source map to be applied contains relative source
	 *        paths. If so, those relative source paths need to be rewritten
	 *        relative to the SourceMapGenerator.
	 */
	SourceMapGenerator.prototype.applySourceMap =
	  function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
	    var sourceFile = aSourceFile;
	    // If aSourceFile is omitted, we will use the file property of the SourceMap
	    if (aSourceFile == null) {
	      if (aSourceMapConsumer.file == null) {
	        throw new Error(
	          'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
	          'or the source map\'s "file" property. Both were omitted.'
	        );
	      }
	      sourceFile = aSourceMapConsumer.file;
	    }
	    var sourceRoot = this._sourceRoot;
	    // Make "sourceFile" relative if an absolute Url is passed.
	    if (sourceRoot != null) {
	      sourceFile = util$3.relative(sourceRoot, sourceFile);
	    }
	    // Applying the SourceMap can add and remove items from the sources and
	    // the names array.
	    var newSources = new ArraySet$1();
	    var newNames = new ArraySet$1();

	    // Find mappings for the "sourceFile"
	    this._mappings.unsortedForEach(function (mapping) {
	      if (mapping.source === sourceFile && mapping.originalLine != null) {
	        // Check if it can be mapped by the source map, then update the mapping.
	        var original = aSourceMapConsumer.originalPositionFor({
	          line: mapping.originalLine,
	          column: mapping.originalColumn
	        });
	        if (original.source != null) {
	          // Copy mapping
	          mapping.source = original.source;
	          if (aSourceMapPath != null) {
	            mapping.source = util$3.join(aSourceMapPath, mapping.source);
	          }
	          if (sourceRoot != null) {
	            mapping.source = util$3.relative(sourceRoot, mapping.source);
	          }
	          mapping.originalLine = original.line;
	          mapping.originalColumn = original.column;
	          if (original.name != null) {
	            mapping.name = original.name;
	          }
	        }
	      }

	      var source = mapping.source;
	      if (source != null && !newSources.has(source)) {
	        newSources.add(source);
	      }

	      var name = mapping.name;
	      if (name != null && !newNames.has(name)) {
	        newNames.add(name);
	      }

	    }, this);
	    this._sources = newSources;
	    this._names = newNames;

	    // Copy sourcesContents of applied map.
	    aSourceMapConsumer.sources.forEach(function (sourceFile) {
	      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	      if (content != null) {
	        if (aSourceMapPath != null) {
	          sourceFile = util$3.join(aSourceMapPath, sourceFile);
	        }
	        if (sourceRoot != null) {
	          sourceFile = util$3.relative(sourceRoot, sourceFile);
	        }
	        this.setSourceContent(sourceFile, content);
	      }
	    }, this);
	  };

	/**
	 * A mapping can have one of the three levels of data:
	 *
	 *   1. Just the generated position.
	 *   2. The Generated position, original position, and original source.
	 *   3. Generated and original position, original source, as well as a name
	 *      token.
	 *
	 * To maintain consistency, we validate that any new mapping being added falls
	 * in to one of these categories.
	 */
	SourceMapGenerator.prototype._validateMapping =
	  function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
	                                              aName) {
	    // When aOriginal is truthy but has empty values for .line and .column,
	    // it is most likely a programmer error. In this case we throw a very
	    // specific error message to try to guide them the right way.
	    // For example: https://github.com/Polymer/polymer-bundler/pull/519
	    if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
	        throw new Error(
	            'original.line and original.column are not numbers -- you probably meant to omit ' +
	            'the original mapping entirely and only map the generated position. If so, pass ' +
	            'null for the original mapping instead of an object with empty or null values.'
	        );
	    }

	    if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
	        && aGenerated.line > 0 && aGenerated.column >= 0
	        && !aOriginal && !aSource && !aName) {
	      // Case 1.
	      return;
	    }
	    else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
	             && aOriginal && 'line' in aOriginal && 'column' in aOriginal
	             && aGenerated.line > 0 && aGenerated.column >= 0
	             && aOriginal.line > 0 && aOriginal.column >= 0
	             && aSource) {
	      // Cases 2 and 3.
	      return;
	    }
	    else {
	      throw new Error('Invalid mapping: ' + JSON.stringify({
	        generated: aGenerated,
	        source: aSource,
	        original: aOriginal,
	        name: aName
	      }));
	    }
	  };

	/**
	 * Serialize the accumulated mappings in to the stream of base 64 VLQs
	 * specified by the source map format.
	 */
	SourceMapGenerator.prototype._serializeMappings =
	  function SourceMapGenerator_serializeMappings() {
	    var previousGeneratedColumn = 0;
	    var previousGeneratedLine = 1;
	    var previousOriginalColumn = 0;
	    var previousOriginalLine = 0;
	    var previousName = 0;
	    var previousSource = 0;
	    var result = '';
	    var next;
	    var mapping;
	    var nameIdx;
	    var sourceIdx;

	    var mappings = this._mappings.toArray();
	    for (var i = 0, len = mappings.length; i < len; i++) {
	      mapping = mappings[i];
	      next = '';

	      if (mapping.generatedLine !== previousGeneratedLine) {
	        previousGeneratedColumn = 0;
	        while (mapping.generatedLine !== previousGeneratedLine) {
	          next += ';';
	          previousGeneratedLine++;
	        }
	      }
	      else {
	        if (i > 0) {
	          if (!util$3.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
	            continue;
	          }
	          next += ',';
	        }
	      }

	      next += base64Vlq.encode(mapping.generatedColumn
	                                 - previousGeneratedColumn);
	      previousGeneratedColumn = mapping.generatedColumn;

	      if (mapping.source != null) {
	        sourceIdx = this._sources.indexOf(mapping.source);
	        next += base64Vlq.encode(sourceIdx - previousSource);
	        previousSource = sourceIdx;

	        // lines are stored 0-based in SourceMap spec version 3
	        next += base64Vlq.encode(mapping.originalLine - 1
	                                   - previousOriginalLine);
	        previousOriginalLine = mapping.originalLine - 1;

	        next += base64Vlq.encode(mapping.originalColumn
	                                   - previousOriginalColumn);
	        previousOriginalColumn = mapping.originalColumn;

	        if (mapping.name != null) {
	          nameIdx = this._names.indexOf(mapping.name);
	          next += base64Vlq.encode(nameIdx - previousName);
	          previousName = nameIdx;
	        }
	      }

	      result += next;
	    }

	    return result;
	  };

	SourceMapGenerator.prototype._generateSourcesContent =
	  function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
	    return aSources.map(function (source) {
	      if (!this._sourcesContents) {
	        return null;
	      }
	      if (aSourceRoot != null) {
	        source = util$3.relative(aSourceRoot, source);
	      }
	      var key = util$3.toSetString(source);
	      return Object.prototype.hasOwnProperty.call(this._sourcesContents, key)
	        ? this._sourcesContents[key]
	        : null;
	    }, this);
	  };

	/**
	 * Externalize the source map.
	 */
	SourceMapGenerator.prototype.toJSON =
	  function SourceMapGenerator_toJSON() {
	    var map = {
	      version: this._version,
	      sources: this._sources.toArray(),
	      names: this._names.toArray(),
	      mappings: this._serializeMappings()
	    };
	    if (this._file != null) {
	      map.file = this._file;
	    }
	    if (this._sourceRoot != null) {
	      map.sourceRoot = this._sourceRoot;
	    }
	    if (this._sourcesContents) {
	      map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
	    }

	    return map;
	  };

	/**
	 * Render the source map being generated to a string.
	 */
	SourceMapGenerator.prototype.toString =
	  function SourceMapGenerator_toString() {
	    return JSON.stringify(this.toJSON());
	  };

	var SourceMapGenerator_1 = SourceMapGenerator;

	var sourceMapGenerator = {
		SourceMapGenerator: SourceMapGenerator_1
	};

	var binarySearch = createCommonjsModule(function (module, exports) {
	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	exports.GREATEST_LOWER_BOUND = 1;
	exports.LEAST_UPPER_BOUND = 2;

	/**
	 * Recursive implementation of binary search.
	 *
	 * @param aLow Indices here and lower do not contain the needle.
	 * @param aHigh Indices here and higher do not contain the needle.
	 * @param aNeedle The element being searched for.
	 * @param aHaystack The non-empty array being searched.
	 * @param aCompare Function which takes two elements and returns -1, 0, or 1.
	 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
	 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
	 *     closest element that is smaller than or greater than the one we are
	 *     searching for, respectively, if the exact element cannot be found.
	 */
	function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
	  // This function terminates when one of the following is true:
	  //
	  //   1. We find the exact element we are looking for.
	  //
	  //   2. We did not find the exact element, but we can return the index of
	  //      the next-closest element.
	  //
	  //   3. We did not find the exact element, and there is no next-closest
	  //      element than the one we are searching for, so we return -1.
	  var mid = Math.floor((aHigh - aLow) / 2) + aLow;
	  var cmp = aCompare(aNeedle, aHaystack[mid], true);
	  if (cmp === 0) {
	    // Found the element we are looking for.
	    return mid;
	  }
	  else if (cmp > 0) {
	    // Our needle is greater than aHaystack[mid].
	    if (aHigh - mid > 1) {
	      // The element is in the upper half.
	      return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
	    }

	    // The exact needle element was not found in this haystack. Determine if
	    // we are in termination case (3) or (2) and return the appropriate thing.
	    if (aBias == exports.LEAST_UPPER_BOUND) {
	      return aHigh < aHaystack.length ? aHigh : -1;
	    } else {
	      return mid;
	    }
	  }
	  else {
	    // Our needle is less than aHaystack[mid].
	    if (mid - aLow > 1) {
	      // The element is in the lower half.
	      return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
	    }

	    // we are in termination case (3) or (2) and return the appropriate thing.
	    if (aBias == exports.LEAST_UPPER_BOUND) {
	      return mid;
	    } else {
	      return aLow < 0 ? -1 : aLow;
	    }
	  }
	}

	/**
	 * This is an implementation of binary search which will always try and return
	 * the index of the closest element if there is no exact hit. This is because
	 * mappings between original and generated line/col pairs are single points,
	 * and there is an implicit region between each of them, so a miss just means
	 * that you aren't on the very start of a region.
	 *
	 * @param aNeedle The element you are looking for.
	 * @param aHaystack The array that is being searched.
	 * @param aCompare A function which takes the needle and an element in the
	 *     array and returns -1, 0, or 1 depending on whether the needle is less
	 *     than, equal to, or greater than the element, respectively.
	 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
	 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
	 *     closest element that is smaller than or greater than the one we are
	 *     searching for, respectively, if the exact element cannot be found.
	 *     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
	 */
	exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
	  if (aHaystack.length === 0) {
	    return -1;
	  }

	  var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack,
	                              aCompare, aBias || exports.GREATEST_LOWER_BOUND);
	  if (index < 0) {
	    return -1;
	  }

	  // We have found either the exact element, or the next-closest element than
	  // the one we are searching for. However, there may be more than one such
	  // element. Make sure we always return the smallest of these.
	  while (index - 1 >= 0) {
	    if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
	      break;
	    }
	    --index;
	  }

	  return index;
	};
	});
	var binarySearch_1 = binarySearch.GREATEST_LOWER_BOUND;
	var binarySearch_2 = binarySearch.LEAST_UPPER_BOUND;
	var binarySearch_3 = binarySearch.search;

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	// It turns out that some (most?) JavaScript engines don't self-host
	// `Array.prototype.sort`. This makes sense because C++ will likely remain
	// faster than JS when doing raw CPU-intensive sorting. However, when using a
	// custom comparator function, calling back and forth between the VM's C++ and
	// JIT'd JS is rather slow *and* loses JIT type information, resulting in
	// worse generated code for the comparator function than would be optimal. In
	// fact, when sorting with a comparator, these costs outweigh the benefits of
	// sorting in C++. By using our own JS-implemented Quick Sort (below), we get
	// a ~3500ms mean speed-up in `bench/bench.html`.

	/**
	 * Swap the elements indexed by `x` and `y` in the array `ary`.
	 *
	 * @param {Array} ary
	 *        The array.
	 * @param {Number} x
	 *        The index of the first item.
	 * @param {Number} y
	 *        The index of the second item.
	 */
	function swap$1(ary, x, y) {
	  var temp = ary[x];
	  ary[x] = ary[y];
	  ary[y] = temp;
	}

	/**
	 * Returns a random integer within the range `low .. high` inclusive.
	 *
	 * @param {Number} low
	 *        The lower bound on the range.
	 * @param {Number} high
	 *        The upper bound on the range.
	 */
	function randomIntInRange(low, high) {
	  return Math.round(low + (Math.random() * (high - low)));
	}

	/**
	 * The Quick Sort algorithm.
	 *
	 * @param {Array} ary
	 *        An array to sort.
	 * @param {function} comparator
	 *        Function to use to compare two items.
	 * @param {Number} p
	 *        Start index of the array
	 * @param {Number} r
	 *        End index of the array
	 */
	function doQuickSort(ary, comparator, p, r) {
	  // If our lower bound is less than our upper bound, we (1) partition the
	  // array into two pieces and (2) recurse on each half. If it is not, this is
	  // the empty array and our base case.

	  if (p < r) {
	    // (1) Partitioning.
	    //
	    // The partitioning chooses a pivot between `p` and `r` and moves all
	    // elements that are less than or equal to the pivot to the before it, and
	    // all the elements that are greater than it after it. The effect is that
	    // once partition is done, the pivot is in the exact place it will be when
	    // the array is put in sorted order, and it will not need to be moved
	    // again. This runs in O(n) time.

	    // Always choose a random pivot so that an input array which is reverse
	    // sorted does not cause O(n^2) running time.
	    var pivotIndex = randomIntInRange(p, r);
	    var i = p - 1;

	    swap$1(ary, pivotIndex, r);
	    var pivot = ary[r];

	    // Immediately after `j` is incremented in this loop, the following hold
	    // true:
	    //
	    //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
	    //
	    //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
	    for (var j = p; j < r; j++) {
	      if (comparator(ary[j], pivot) <= 0) {
	        i += 1;
	        swap$1(ary, i, j);
	      }
	    }

	    swap$1(ary, i + 1, j);
	    var q = i + 1;

	    // (2) Recurse on each half.

	    doQuickSort(ary, comparator, p, q - 1);
	    doQuickSort(ary, comparator, q + 1, r);
	  }
	}

	/**
	 * Sort the given array in-place with the given comparator function.
	 *
	 * @param {Array} ary
	 *        An array to sort.
	 * @param {function} comparator
	 *        Function to use to compare two items.
	 */
	var quickSort_1 = function (ary, comparator) {
	  doQuickSort(ary, comparator, 0, ary.length - 1);
	};

	var quickSort = {
		quickSort: quickSort_1
	};

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */



	var ArraySet$2 = arraySet.ArraySet;

	var quickSort$1 = quickSort.quickSort;

	function SourceMapConsumer(aSourceMap) {
	  var sourceMap = aSourceMap;
	  if (typeof aSourceMap === 'string') {
	    sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
	  }

	  return sourceMap.sections != null
	    ? new IndexedSourceMapConsumer(sourceMap)
	    : new BasicSourceMapConsumer(sourceMap);
	}

	SourceMapConsumer.fromSourceMap = function(aSourceMap) {
	  return BasicSourceMapConsumer.fromSourceMap(aSourceMap);
	};

	/**
	 * The version of the source mapping spec that we are consuming.
	 */
	SourceMapConsumer.prototype._version = 3;

	// `__generatedMappings` and `__originalMappings` are arrays that hold the
	// parsed mapping coordinates from the source map's "mappings" attribute. They
	// are lazily instantiated, accessed via the `_generatedMappings` and
	// `_originalMappings` getters respectively, and we only parse the mappings
	// and create these arrays once queried for a source location. We jump through
	// these hoops because there can be many thousands of mappings, and parsing
	// them is expensive, so we only want to do it if we must.
	//
	// Each object in the arrays is of the form:
	//
	//     {
	//       generatedLine: The line number in the generated code,
	//       generatedColumn: The column number in the generated code,
	//       source: The path to the original source file that generated this
	//               chunk of code,
	//       originalLine: The line number in the original source that
	//                     corresponds to this chunk of generated code,
	//       originalColumn: The column number in the original source that
	//                       corresponds to this chunk of generated code,
	//       name: The name of the original symbol which generated this chunk of
	//             code.
	//     }
	//
	// All properties except for `generatedLine` and `generatedColumn` can be
	// `null`.
	//
	// `_generatedMappings` is ordered by the generated positions.
	//
	// `_originalMappings` is ordered by the original positions.

	SourceMapConsumer.prototype.__generatedMappings = null;
	Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
	  get: function () {
	    if (!this.__generatedMappings) {
	      this._parseMappings(this._mappings, this.sourceRoot);
	    }

	    return this.__generatedMappings;
	  }
	});

	SourceMapConsumer.prototype.__originalMappings = null;
	Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
	  get: function () {
	    if (!this.__originalMappings) {
	      this._parseMappings(this._mappings, this.sourceRoot);
	    }

	    return this.__originalMappings;
	  }
	});

	SourceMapConsumer.prototype._charIsMappingSeparator =
	  function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
	    var c = aStr.charAt(index);
	    return c === ";" || c === ",";
	  };

	/**
	 * Parse the mappings in a string in to a data structure which we can easily
	 * query (the ordered arrays in the `this.__generatedMappings` and
	 * `this.__originalMappings` properties).
	 */
	SourceMapConsumer.prototype._parseMappings =
	  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	    throw new Error("Subclasses must implement _parseMappings");
	  };

	SourceMapConsumer.GENERATED_ORDER = 1;
	SourceMapConsumer.ORIGINAL_ORDER = 2;

	SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
	SourceMapConsumer.LEAST_UPPER_BOUND = 2;

	/**
	 * Iterate over each mapping between an original source/line/column and a
	 * generated line/column in this source map.
	 *
	 * @param Function aCallback
	 *        The function that is called with each mapping.
	 * @param Object aContext
	 *        Optional. If specified, this object will be the value of `this` every
	 *        time that `aCallback` is called.
	 * @param aOrder
	 *        Either `SourceMapConsumer.GENERATED_ORDER` or
	 *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
	 *        iterate over the mappings sorted by the generated file's line/column
	 *        order or the original's source/line/column order, respectively. Defaults to
	 *        `SourceMapConsumer.GENERATED_ORDER`.
	 */
	SourceMapConsumer.prototype.eachMapping =
	  function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
	    var context = aContext || null;
	    var order = aOrder || SourceMapConsumer.GENERATED_ORDER;

	    var mappings;
	    switch (order) {
	    case SourceMapConsumer.GENERATED_ORDER:
	      mappings = this._generatedMappings;
	      break;
	    case SourceMapConsumer.ORIGINAL_ORDER:
	      mappings = this._originalMappings;
	      break;
	    default:
	      throw new Error("Unknown order of iteration.");
	    }

	    var sourceRoot = this.sourceRoot;
	    mappings.map(function (mapping) {
	      var source = mapping.source === null ? null : this._sources.at(mapping.source);
	      if (source != null && sourceRoot != null) {
	        source = util$3.join(sourceRoot, source);
	      }
	      return {
	        source: source,
	        generatedLine: mapping.generatedLine,
	        generatedColumn: mapping.generatedColumn,
	        originalLine: mapping.originalLine,
	        originalColumn: mapping.originalColumn,
	        name: mapping.name === null ? null : this._names.at(mapping.name)
	      };
	    }, this).forEach(aCallback, context);
	  };

	/**
	 * Returns all generated line and column information for the original source,
	 * line, and column provided. If no column is provided, returns all mappings
	 * corresponding to a either the line we are searching for or the next
	 * closest line that has any mappings. Otherwise, returns all mappings
	 * corresponding to the given line and either the column we are searching for
	 * or the next closest column that has any offsets.
	 *
	 * The only argument is an object with the following properties:
	 *
	 *   - source: The filename of the original source.
	 *   - line: The line number in the original source.
	 *   - column: Optional. the column number in the original source.
	 *
	 * and an array of objects is returned, each with the following properties:
	 *
	 *   - line: The line number in the generated source, or null.
	 *   - column: The column number in the generated source, or null.
	 */
	SourceMapConsumer.prototype.allGeneratedPositionsFor =
	  function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
	    var line = util$3.getArg(aArgs, 'line');

	    // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
	    // returns the index of the closest mapping less than the needle. By
	    // setting needle.originalColumn to 0, we thus find the last mapping for
	    // the given line, provided such a mapping exists.
	    var needle = {
	      source: util$3.getArg(aArgs, 'source'),
	      originalLine: line,
	      originalColumn: util$3.getArg(aArgs, 'column', 0)
	    };

	    if (this.sourceRoot != null) {
	      needle.source = util$3.relative(this.sourceRoot, needle.source);
	    }
	    if (!this._sources.has(needle.source)) {
	      return [];
	    }
	    needle.source = this._sources.indexOf(needle.source);

	    var mappings = [];

	    var index = this._findMapping(needle,
	                                  this._originalMappings,
	                                  "originalLine",
	                                  "originalColumn",
	                                  util$3.compareByOriginalPositions,
	                                  binarySearch.LEAST_UPPER_BOUND);
	    if (index >= 0) {
	      var mapping = this._originalMappings[index];

	      if (aArgs.column === undefined) {
	        var originalLine = mapping.originalLine;

	        // Iterate until either we run out of mappings, or we run into
	        // a mapping for a different line than the one we found. Since
	        // mappings are sorted, this is guaranteed to find all mappings for
	        // the line we found.
	        while (mapping && mapping.originalLine === originalLine) {
	          mappings.push({
	            line: util$3.getArg(mapping, 'generatedLine', null),
	            column: util$3.getArg(mapping, 'generatedColumn', null),
	            lastColumn: util$3.getArg(mapping, 'lastGeneratedColumn', null)
	          });

	          mapping = this._originalMappings[++index];
	        }
	      } else {
	        var originalColumn = mapping.originalColumn;

	        // Iterate until either we run out of mappings, or we run into
	        // a mapping for a different line than the one we were searching for.
	        // Since mappings are sorted, this is guaranteed to find all mappings for
	        // the line we are searching for.
	        while (mapping &&
	               mapping.originalLine === line &&
	               mapping.originalColumn == originalColumn) {
	          mappings.push({
	            line: util$3.getArg(mapping, 'generatedLine', null),
	            column: util$3.getArg(mapping, 'generatedColumn', null),
	            lastColumn: util$3.getArg(mapping, 'lastGeneratedColumn', null)
	          });

	          mapping = this._originalMappings[++index];
	        }
	      }
	    }

	    return mappings;
	  };

	var SourceMapConsumer_1 = SourceMapConsumer;

	/**
	 * A BasicSourceMapConsumer instance represents a parsed source map which we can
	 * query for information about the original file positions by giving it a file
	 * position in the generated source.
	 *
	 * The only parameter is the raw source map (either as a JSON string, or
	 * already parsed to an object). According to the spec, source maps have the
	 * following attributes:
	 *
	 *   - version: Which version of the source map spec this map is following.
	 *   - sources: An array of URLs to the original source files.
	 *   - names: An array of identifiers which can be referrenced by individual mappings.
	 *   - sourceRoot: Optional. The URL root from which all sources are relative.
	 *   - sourcesContent: Optional. An array of contents of the original source files.
	 *   - mappings: A string of base64 VLQs which contain the actual mappings.
	 *   - file: Optional. The generated file this source map is associated with.
	 *
	 * Here is an example source map, taken from the source map spec[0]:
	 *
	 *     {
	 *       version : 3,
	 *       file: "out.js",
	 *       sourceRoot : "",
	 *       sources: ["foo.js", "bar.js"],
	 *       names: ["src", "maps", "are", "fun"],
	 *       mappings: "AA,AB;;ABCDE;"
	 *     }
	 *
	 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
	 */
	function BasicSourceMapConsumer(aSourceMap) {
	  var sourceMap = aSourceMap;
	  if (typeof aSourceMap === 'string') {
	    sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
	  }

	  var version = util$3.getArg(sourceMap, 'version');
	  var sources = util$3.getArg(sourceMap, 'sources');
	  // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
	  // requires the array) to play nice here.
	  var names = util$3.getArg(sourceMap, 'names', []);
	  var sourceRoot = util$3.getArg(sourceMap, 'sourceRoot', null);
	  var sourcesContent = util$3.getArg(sourceMap, 'sourcesContent', null);
	  var mappings = util$3.getArg(sourceMap, 'mappings');
	  var file = util$3.getArg(sourceMap, 'file', null);

	  // Once again, Sass deviates from the spec and supplies the version as a
	  // string rather than a number, so we use loose equality checking here.
	  if (version != this._version) {
	    throw new Error('Unsupported version: ' + version);
	  }

	  sources = sources
	    .map(String)
	    // Some source maps produce relative source paths like "./foo.js" instead of
	    // "foo.js".  Normalize these first so that future comparisons will succeed.
	    // See bugzil.la/1090768.
	    .map(util$3.normalize)
	    // Always ensure that absolute sources are internally stored relative to
	    // the source root, if the source root is absolute. Not doing this would
	    // be particularly problematic when the source root is a prefix of the
	    // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
	    .map(function (source) {
	      return sourceRoot && util$3.isAbsolute(sourceRoot) && util$3.isAbsolute(source)
	        ? util$3.relative(sourceRoot, source)
	        : source;
	    });

	  // Pass `true` below to allow duplicate names and sources. While source maps
	  // are intended to be compressed and deduplicated, the TypeScript compiler
	  // sometimes generates source maps with duplicates in them. See Github issue
	  // #72 and bugzil.la/889492.
	  this._names = ArraySet$2.fromArray(names.map(String), true);
	  this._sources = ArraySet$2.fromArray(sources, true);

	  this.sourceRoot = sourceRoot;
	  this.sourcesContent = sourcesContent;
	  this._mappings = mappings;
	  this.file = file;
	}

	BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
	BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;

	/**
	 * Create a BasicSourceMapConsumer from a SourceMapGenerator.
	 *
	 * @param SourceMapGenerator aSourceMap
	 *        The source map that will be consumed.
	 * @returns BasicSourceMapConsumer
	 */
	BasicSourceMapConsumer.fromSourceMap =
	  function SourceMapConsumer_fromSourceMap(aSourceMap) {
	    var smc = Object.create(BasicSourceMapConsumer.prototype);

	    var names = smc._names = ArraySet$2.fromArray(aSourceMap._names.toArray(), true);
	    var sources = smc._sources = ArraySet$2.fromArray(aSourceMap._sources.toArray(), true);
	    smc.sourceRoot = aSourceMap._sourceRoot;
	    smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
	                                                            smc.sourceRoot);
	    smc.file = aSourceMap._file;

	    // Because we are modifying the entries (by converting string sources and
	    // names to indices into the sources and names ArraySets), we have to make
	    // a copy of the entry or else bad things happen. Shared mutable state
	    // strikes again! See github issue #191.

	    var generatedMappings = aSourceMap._mappings.toArray().slice();
	    var destGeneratedMappings = smc.__generatedMappings = [];
	    var destOriginalMappings = smc.__originalMappings = [];

	    for (var i = 0, length = generatedMappings.length; i < length; i++) {
	      var srcMapping = generatedMappings[i];
	      var destMapping = new Mapping;
	      destMapping.generatedLine = srcMapping.generatedLine;
	      destMapping.generatedColumn = srcMapping.generatedColumn;

	      if (srcMapping.source) {
	        destMapping.source = sources.indexOf(srcMapping.source);
	        destMapping.originalLine = srcMapping.originalLine;
	        destMapping.originalColumn = srcMapping.originalColumn;

	        if (srcMapping.name) {
	          destMapping.name = names.indexOf(srcMapping.name);
	        }

	        destOriginalMappings.push(destMapping);
	      }

	      destGeneratedMappings.push(destMapping);
	    }

	    quickSort$1(smc.__originalMappings, util$3.compareByOriginalPositions);

	    return smc;
	  };

	/**
	 * The version of the source mapping spec that we are consuming.
	 */
	BasicSourceMapConsumer.prototype._version = 3;

	/**
	 * The list of original sources.
	 */
	Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
	  get: function () {
	    return this._sources.toArray().map(function (s) {
	      return this.sourceRoot != null ? util$3.join(this.sourceRoot, s) : s;
	    }, this);
	  }
	});

	/**
	 * Provide the JIT with a nice shape / hidden class.
	 */
	function Mapping() {
	  this.generatedLine = 0;
	  this.generatedColumn = 0;
	  this.source = null;
	  this.originalLine = null;
	  this.originalColumn = null;
	  this.name = null;
	}

	/**
	 * Parse the mappings in a string in to a data structure which we can easily
	 * query (the ordered arrays in the `this.__generatedMappings` and
	 * `this.__originalMappings` properties).
	 */
	BasicSourceMapConsumer.prototype._parseMappings =
	  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	    var generatedLine = 1;
	    var previousGeneratedColumn = 0;
	    var previousOriginalLine = 0;
	    var previousOriginalColumn = 0;
	    var previousSource = 0;
	    var previousName = 0;
	    var length = aStr.length;
	    var index = 0;
	    var cachedSegments = {};
	    var temp = {};
	    var originalMappings = [];
	    var generatedMappings = [];
	    var mapping, str, segment, end, value;

	    while (index < length) {
	      if (aStr.charAt(index) === ';') {
	        generatedLine++;
	        index++;
	        previousGeneratedColumn = 0;
	      }
	      else if (aStr.charAt(index) === ',') {
	        index++;
	      }
	      else {
	        mapping = new Mapping();
	        mapping.generatedLine = generatedLine;

	        // Because each offset is encoded relative to the previous one,
	        // many segments often have the same encoding. We can exploit this
	        // fact by caching the parsed variable length fields of each segment,
	        // allowing us to avoid a second parse if we encounter the same
	        // segment again.
	        for (end = index; end < length; end++) {
	          if (this._charIsMappingSeparator(aStr, end)) {
	            break;
	          }
	        }
	        str = aStr.slice(index, end);

	        segment = cachedSegments[str];
	        if (segment) {
	          index += str.length;
	        } else {
	          segment = [];
	          while (index < end) {
	            base64Vlq.decode(aStr, index, temp);
	            value = temp.value;
	            index = temp.rest;
	            segment.push(value);
	          }

	          if (segment.length === 2) {
	            throw new Error('Found a source, but no line and column');
	          }

	          if (segment.length === 3) {
	            throw new Error('Found a source and line, but no column');
	          }

	          cachedSegments[str] = segment;
	        }

	        // Generated column.
	        mapping.generatedColumn = previousGeneratedColumn + segment[0];
	        previousGeneratedColumn = mapping.generatedColumn;

	        if (segment.length > 1) {
	          // Original source.
	          mapping.source = previousSource + segment[1];
	          previousSource += segment[1];

	          // Original line.
	          mapping.originalLine = previousOriginalLine + segment[2];
	          previousOriginalLine = mapping.originalLine;
	          // Lines are stored 0-based
	          mapping.originalLine += 1;

	          // Original column.
	          mapping.originalColumn = previousOriginalColumn + segment[3];
	          previousOriginalColumn = mapping.originalColumn;

	          if (segment.length > 4) {
	            // Original name.
	            mapping.name = previousName + segment[4];
	            previousName += segment[4];
	          }
	        }

	        generatedMappings.push(mapping);
	        if (typeof mapping.originalLine === 'number') {
	          originalMappings.push(mapping);
	        }
	      }
	    }

	    quickSort$1(generatedMappings, util$3.compareByGeneratedPositionsDeflated);
	    this.__generatedMappings = generatedMappings;

	    quickSort$1(originalMappings, util$3.compareByOriginalPositions);
	    this.__originalMappings = originalMappings;
	  };

	/**
	 * Find the mapping that best matches the hypothetical "needle" mapping that
	 * we are searching for in the given "haystack" of mappings.
	 */
	BasicSourceMapConsumer.prototype._findMapping =
	  function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
	                                         aColumnName, aComparator, aBias) {
	    // To return the position we are searching for, we must first find the
	    // mapping for the given position and then return the opposite position it
	    // points to. Because the mappings are sorted, we can use binary search to
	    // find the best mapping.

	    if (aNeedle[aLineName] <= 0) {
	      throw new TypeError('Line must be greater than or equal to 1, got '
	                          + aNeedle[aLineName]);
	    }
	    if (aNeedle[aColumnName] < 0) {
	      throw new TypeError('Column must be greater than or equal to 0, got '
	                          + aNeedle[aColumnName]);
	    }

	    return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
	  };

	/**
	 * Compute the last column for each generated mapping. The last column is
	 * inclusive.
	 */
	BasicSourceMapConsumer.prototype.computeColumnSpans =
	  function SourceMapConsumer_computeColumnSpans() {
	    for (var index = 0; index < this._generatedMappings.length; ++index) {
	      var mapping = this._generatedMappings[index];

	      // Mappings do not contain a field for the last generated columnt. We
	      // can come up with an optimistic estimate, however, by assuming that
	      // mappings are contiguous (i.e. given two consecutive mappings, the
	      // first mapping ends where the second one starts).
	      if (index + 1 < this._generatedMappings.length) {
	        var nextMapping = this._generatedMappings[index + 1];

	        if (mapping.generatedLine === nextMapping.generatedLine) {
	          mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
	          continue;
	        }
	      }

	      // The last mapping for each line spans the entire line.
	      mapping.lastGeneratedColumn = Infinity;
	    }
	  };

	/**
	 * Returns the original source, line, and column information for the generated
	 * source's line and column positions provided. The only argument is an object
	 * with the following properties:
	 *
	 *   - line: The line number in the generated source.
	 *   - column: The column number in the generated source.
	 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
	 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
	 *     closest element that is smaller than or greater than the one we are
	 *     searching for, respectively, if the exact element cannot be found.
	 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - source: The original source file, or null.
	 *   - line: The line number in the original source, or null.
	 *   - column: The column number in the original source, or null.
	 *   - name: The original identifier, or null.
	 */
	BasicSourceMapConsumer.prototype.originalPositionFor =
	  function SourceMapConsumer_originalPositionFor(aArgs) {
	    var needle = {
	      generatedLine: util$3.getArg(aArgs, 'line'),
	      generatedColumn: util$3.getArg(aArgs, 'column')
	    };

	    var index = this._findMapping(
	      needle,
	      this._generatedMappings,
	      "generatedLine",
	      "generatedColumn",
	      util$3.compareByGeneratedPositionsDeflated,
	      util$3.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
	    );

	    if (index >= 0) {
	      var mapping = this._generatedMappings[index];

	      if (mapping.generatedLine === needle.generatedLine) {
	        var source = util$3.getArg(mapping, 'source', null);
	        if (source !== null) {
	          source = this._sources.at(source);
	          if (this.sourceRoot != null) {
	            source = util$3.join(this.sourceRoot, source);
	          }
	        }
	        var name = util$3.getArg(mapping, 'name', null);
	        if (name !== null) {
	          name = this._names.at(name);
	        }
	        return {
	          source: source,
	          line: util$3.getArg(mapping, 'originalLine', null),
	          column: util$3.getArg(mapping, 'originalColumn', null),
	          name: name
	        };
	      }
	    }

	    return {
	      source: null,
	      line: null,
	      column: null,
	      name: null
	    };
	  };

	/**
	 * Return true if we have the source content for every source in the source
	 * map, false otherwise.
	 */
	BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
	  function BasicSourceMapConsumer_hasContentsOfAllSources() {
	    if (!this.sourcesContent) {
	      return false;
	    }
	    return this.sourcesContent.length >= this._sources.size() &&
	      !this.sourcesContent.some(function (sc) { return sc == null; });
	  };

	/**
	 * Returns the original source content. The only argument is the url of the
	 * original source file. Returns null if no original source content is
	 * available.
	 */
	BasicSourceMapConsumer.prototype.sourceContentFor =
	  function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
	    if (!this.sourcesContent) {
	      return null;
	    }

	    if (this.sourceRoot != null) {
	      aSource = util$3.relative(this.sourceRoot, aSource);
	    }

	    if (this._sources.has(aSource)) {
	      return this.sourcesContent[this._sources.indexOf(aSource)];
	    }

	    var url;
	    if (this.sourceRoot != null
	        && (url = util$3.urlParse(this.sourceRoot))) {
	      // XXX: file:// URIs and absolute paths lead to unexpected behavior for
	      // many users. We can help them out when they expect file:// URIs to
	      // behave like it would if they were running a local HTTP server. See
	      // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
	      var fileUriAbsPath = aSource.replace(/^file:\/\//, "");
	      if (url.scheme == "file"
	          && this._sources.has(fileUriAbsPath)) {
	        return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
	      }

	      if ((!url.path || url.path == "/")
	          && this._sources.has("/" + aSource)) {
	        return this.sourcesContent[this._sources.indexOf("/" + aSource)];
	      }
	    }

	    // This function is used recursively from
	    // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
	    // don't want to throw if we can't find the source - we just want to
	    // return null, so we provide a flag to exit gracefully.
	    if (nullOnMissing) {
	      return null;
	    }
	    else {
	      throw new Error('"' + aSource + '" is not in the SourceMap.');
	    }
	  };

	/**
	 * Returns the generated line and column information for the original source,
	 * line, and column positions provided. The only argument is an object with
	 * the following properties:
	 *
	 *   - source: The filename of the original source.
	 *   - line: The line number in the original source.
	 *   - column: The column number in the original source.
	 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
	 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
	 *     closest element that is smaller than or greater than the one we are
	 *     searching for, respectively, if the exact element cannot be found.
	 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - line: The line number in the generated source, or null.
	 *   - column: The column number in the generated source, or null.
	 */
	BasicSourceMapConsumer.prototype.generatedPositionFor =
	  function SourceMapConsumer_generatedPositionFor(aArgs) {
	    var source = util$3.getArg(aArgs, 'source');
	    if (this.sourceRoot != null) {
	      source = util$3.relative(this.sourceRoot, source);
	    }
	    if (!this._sources.has(source)) {
	      return {
	        line: null,
	        column: null,
	        lastColumn: null
	      };
	    }
	    source = this._sources.indexOf(source);

	    var needle = {
	      source: source,
	      originalLine: util$3.getArg(aArgs, 'line'),
	      originalColumn: util$3.getArg(aArgs, 'column')
	    };

	    var index = this._findMapping(
	      needle,
	      this._originalMappings,
	      "originalLine",
	      "originalColumn",
	      util$3.compareByOriginalPositions,
	      util$3.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
	    );

	    if (index >= 0) {
	      var mapping = this._originalMappings[index];

	      if (mapping.source === needle.source) {
	        return {
	          line: util$3.getArg(mapping, 'generatedLine', null),
	          column: util$3.getArg(mapping, 'generatedColumn', null),
	          lastColumn: util$3.getArg(mapping, 'lastGeneratedColumn', null)
	        };
	      }
	    }

	    return {
	      line: null,
	      column: null,
	      lastColumn: null
	    };
	  };

	var BasicSourceMapConsumer_1 = BasicSourceMapConsumer;

	/**
	 * An IndexedSourceMapConsumer instance represents a parsed source map which
	 * we can query for information. It differs from BasicSourceMapConsumer in
	 * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
	 * input.
	 *
	 * The only parameter is a raw source map (either as a JSON string, or already
	 * parsed to an object). According to the spec for indexed source maps, they
	 * have the following attributes:
	 *
	 *   - version: Which version of the source map spec this map is following.
	 *   - file: Optional. The generated file this source map is associated with.
	 *   - sections: A list of section definitions.
	 *
	 * Each value under the "sections" field has two fields:
	 *   - offset: The offset into the original specified at which this section
	 *       begins to apply, defined as an object with a "line" and "column"
	 *       field.
	 *   - map: A source map definition. This source map could also be indexed,
	 *       but doesn't have to be.
	 *
	 * Instead of the "map" field, it's also possible to have a "url" field
	 * specifying a URL to retrieve a source map from, but that's currently
	 * unsupported.
	 *
	 * Here's an example source map, taken from the source map spec[0], but
	 * modified to omit a section which uses the "url" field.
	 *
	 *  {
	 *    version : 3,
	 *    file: "app.js",
	 *    sections: [{
	 *      offset: {line:100, column:10},
	 *      map: {
	 *        version : 3,
	 *        file: "section.js",
	 *        sources: ["foo.js", "bar.js"],
	 *        names: ["src", "maps", "are", "fun"],
	 *        mappings: "AAAA,E;;ABCDE;"
	 *      }
	 *    }],
	 *  }
	 *
	 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
	 */
	function IndexedSourceMapConsumer(aSourceMap) {
	  var sourceMap = aSourceMap;
	  if (typeof aSourceMap === 'string') {
	    sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
	  }

	  var version = util$3.getArg(sourceMap, 'version');
	  var sections = util$3.getArg(sourceMap, 'sections');

	  if (version != this._version) {
	    throw new Error('Unsupported version: ' + version);
	  }

	  this._sources = new ArraySet$2();
	  this._names = new ArraySet$2();

	  var lastOffset = {
	    line: -1,
	    column: 0
	  };
	  this._sections = sections.map(function (s) {
	    if (s.url) {
	      // The url field will require support for asynchronicity.
	      // See https://github.com/mozilla/source-map/issues/16
	      throw new Error('Support for url field in sections not implemented.');
	    }
	    var offset = util$3.getArg(s, 'offset');
	    var offsetLine = util$3.getArg(offset, 'line');
	    var offsetColumn = util$3.getArg(offset, 'column');

	    if (offsetLine < lastOffset.line ||
	        (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
	      throw new Error('Section offsets must be ordered and non-overlapping.');
	    }
	    lastOffset = offset;

	    return {
	      generatedOffset: {
	        // The offset fields are 0-based, but we use 1-based indices when
	        // encoding/decoding from VLQ.
	        generatedLine: offsetLine + 1,
	        generatedColumn: offsetColumn + 1
	      },
	      consumer: new SourceMapConsumer(util$3.getArg(s, 'map'))
	    }
	  });
	}

	IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
	IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;

	/**
	 * The version of the source mapping spec that we are consuming.
	 */
	IndexedSourceMapConsumer.prototype._version = 3;

	/**
	 * The list of original sources.
	 */
	Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
	  get: function () {
	    var sources = [];
	    for (var i = 0; i < this._sections.length; i++) {
	      for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
	        sources.push(this._sections[i].consumer.sources[j]);
	      }
	    }
	    return sources;
	  }
	});

	/**
	 * Returns the original source, line, and column information for the generated
	 * source's line and column positions provided. The only argument is an object
	 * with the following properties:
	 *
	 *   - line: The line number in the generated source.
	 *   - column: The column number in the generated source.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - source: The original source file, or null.
	 *   - line: The line number in the original source, or null.
	 *   - column: The column number in the original source, or null.
	 *   - name: The original identifier, or null.
	 */
	IndexedSourceMapConsumer.prototype.originalPositionFor =
	  function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
	    var needle = {
	      generatedLine: util$3.getArg(aArgs, 'line'),
	      generatedColumn: util$3.getArg(aArgs, 'column')
	    };

	    // Find the section containing the generated position we're trying to map
	    // to an original position.
	    var sectionIndex = binarySearch.search(needle, this._sections,
	      function(needle, section) {
	        var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
	        if (cmp) {
	          return cmp;
	        }

	        return (needle.generatedColumn -
	                section.generatedOffset.generatedColumn);
	      });
	    var section = this._sections[sectionIndex];

	    if (!section) {
	      return {
	        source: null,
	        line: null,
	        column: null,
	        name: null
	      };
	    }

	    return section.consumer.originalPositionFor({
	      line: needle.generatedLine -
	        (section.generatedOffset.generatedLine - 1),
	      column: needle.generatedColumn -
	        (section.generatedOffset.generatedLine === needle.generatedLine
	         ? section.generatedOffset.generatedColumn - 1
	         : 0),
	      bias: aArgs.bias
	    });
	  };

	/**
	 * Return true if we have the source content for every source in the source
	 * map, false otherwise.
	 */
	IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
	  function IndexedSourceMapConsumer_hasContentsOfAllSources() {
	    return this._sections.every(function (s) {
	      return s.consumer.hasContentsOfAllSources();
	    });
	  };

	/**
	 * Returns the original source content. The only argument is the url of the
	 * original source file. Returns null if no original source content is
	 * available.
	 */
	IndexedSourceMapConsumer.prototype.sourceContentFor =
	  function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
	    for (var i = 0; i < this._sections.length; i++) {
	      var section = this._sections[i];

	      var content = section.consumer.sourceContentFor(aSource, true);
	      if (content) {
	        return content;
	      }
	    }
	    if (nullOnMissing) {
	      return null;
	    }
	    else {
	      throw new Error('"' + aSource + '" is not in the SourceMap.');
	    }
	  };

	/**
	 * Returns the generated line and column information for the original source,
	 * line, and column positions provided. The only argument is an object with
	 * the following properties:
	 *
	 *   - source: The filename of the original source.
	 *   - line: The line number in the original source.
	 *   - column: The column number in the original source.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - line: The line number in the generated source, or null.
	 *   - column: The column number in the generated source, or null.
	 */
	IndexedSourceMapConsumer.prototype.generatedPositionFor =
	  function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
	    for (var i = 0; i < this._sections.length; i++) {
	      var section = this._sections[i];

	      // Only consider this section if the requested source is in the list of
	      // sources of the consumer.
	      if (section.consumer.sources.indexOf(util$3.getArg(aArgs, 'source')) === -1) {
	        continue;
	      }
	      var generatedPosition = section.consumer.generatedPositionFor(aArgs);
	      if (generatedPosition) {
	        var ret = {
	          line: generatedPosition.line +
	            (section.generatedOffset.generatedLine - 1),
	          column: generatedPosition.column +
	            (section.generatedOffset.generatedLine === generatedPosition.line
	             ? section.generatedOffset.generatedColumn - 1
	             : 0)
	        };
	        return ret;
	      }
	    }

	    return {
	      line: null,
	      column: null
	    };
	  };

	/**
	 * Parse the mappings in a string in to a data structure which we can easily
	 * query (the ordered arrays in the `this.__generatedMappings` and
	 * `this.__originalMappings` properties).
	 */
	IndexedSourceMapConsumer.prototype._parseMappings =
	  function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	    this.__generatedMappings = [];
	    this.__originalMappings = [];
	    for (var i = 0; i < this._sections.length; i++) {
	      var section = this._sections[i];
	      var sectionMappings = section.consumer._generatedMappings;
	      for (var j = 0; j < sectionMappings.length; j++) {
	        var mapping = sectionMappings[j];

	        var source = section.consumer._sources.at(mapping.source);
	        if (section.consumer.sourceRoot !== null) {
	          source = util$3.join(section.consumer.sourceRoot, source);
	        }
	        this._sources.add(source);
	        source = this._sources.indexOf(source);

	        var name = section.consumer._names.at(mapping.name);
	        this._names.add(name);
	        name = this._names.indexOf(name);

	        // The mappings coming from the consumer for the section have
	        // generated positions relative to the start of the section, so we
	        // need to offset them to be relative to the start of the concatenated
	        // generated file.
	        var adjustedMapping = {
	          source: source,
	          generatedLine: mapping.generatedLine +
	            (section.generatedOffset.generatedLine - 1),
	          generatedColumn: mapping.generatedColumn +
	            (section.generatedOffset.generatedLine === mapping.generatedLine
	            ? section.generatedOffset.generatedColumn - 1
	            : 0),
	          originalLine: mapping.originalLine,
	          originalColumn: mapping.originalColumn,
	          name: name
	        };

	        this.__generatedMappings.push(adjustedMapping);
	        if (typeof adjustedMapping.originalLine === 'number') {
	          this.__originalMappings.push(adjustedMapping);
	        }
	      }
	    }

	    quickSort$1(this.__generatedMappings, util$3.compareByGeneratedPositionsDeflated);
	    quickSort$1(this.__originalMappings, util$3.compareByOriginalPositions);
	  };

	var IndexedSourceMapConsumer_1 = IndexedSourceMapConsumer;

	var sourceMapConsumer = {
		SourceMapConsumer: SourceMapConsumer_1,
		BasicSourceMapConsumer: BasicSourceMapConsumer_1,
		IndexedSourceMapConsumer: IndexedSourceMapConsumer_1
	};

	/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var SourceMapGenerator$1 = sourceMapGenerator.SourceMapGenerator;


	// Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
	// operating systems these days (capturing the result).
	var REGEX_NEWLINE = /(\r?\n)/;

	// Newline character code for charCodeAt() comparisons
	var NEWLINE_CODE = 10;

	// Private symbol for identifying `SourceNode`s when multiple versions of
	// the source-map library are loaded. This MUST NOT CHANGE across
	// versions!
	var isSourceNode = "$$$isSourceNode$$$";

	/**
	 * SourceNodes provide a way to abstract over interpolating/concatenating
	 * snippets of generated JavaScript source code while maintaining the line and
	 * column information associated with the original source code.
	 *
	 * @param aLine The original line number.
	 * @param aColumn The original column number.
	 * @param aSource The original source's filename.
	 * @param aChunks Optional. An array of strings which are snippets of
	 *        generated JS, or other SourceNodes.
	 * @param aName The original identifier.
	 */
	function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
	  this.children = [];
	  this.sourceContents = {};
	  this.line = aLine == null ? null : aLine;
	  this.column = aColumn == null ? null : aColumn;
	  this.source = aSource == null ? null : aSource;
	  this.name = aName == null ? null : aName;
	  this[isSourceNode] = true;
	  if (aChunks != null) this.add(aChunks);
	}

	/**
	 * Creates a SourceNode from generated code and a SourceMapConsumer.
	 *
	 * @param aGeneratedCode The generated code
	 * @param aSourceMapConsumer The SourceMap for the generated code
	 * @param aRelativePath Optional. The path that relative sources in the
	 *        SourceMapConsumer should be relative to.
	 */
	SourceNode.fromStringWithSourceMap =
	  function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
	    // The SourceNode we want to fill with the generated code
	    // and the SourceMap
	    var node = new SourceNode();

	    // All even indices of this array are one line of the generated code,
	    // while all odd indices are the newlines between two adjacent lines
	    // (since `REGEX_NEWLINE` captures its match).
	    // Processed fragments are accessed by calling `shiftNextLine`.
	    var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
	    var remainingLinesIndex = 0;
	    var shiftNextLine = function() {
	      var lineContents = getNextLine();
	      // The last line of a file might not have a newline.
	      var newLine = getNextLine() || "";
	      return lineContents + newLine;

	      function getNextLine() {
	        return remainingLinesIndex < remainingLines.length ?
	            remainingLines[remainingLinesIndex++] : undefined;
	      }
	    };

	    // We need to remember the position of "remainingLines"
	    var lastGeneratedLine = 1, lastGeneratedColumn = 0;

	    // The generate SourceNodes we need a code range.
	    // To extract it current and last mapping is used.
	    // Here we store the last mapping.
	    var lastMapping = null;

	    aSourceMapConsumer.eachMapping(function (mapping) {
	      if (lastMapping !== null) {
	        // We add the code from "lastMapping" to "mapping":
	        // First check if there is a new line in between.
	        if (lastGeneratedLine < mapping.generatedLine) {
	          // Associate first line with "lastMapping"
	          addMappingWithCode(lastMapping, shiftNextLine());
	          lastGeneratedLine++;
	          lastGeneratedColumn = 0;
	          // The remaining code is added without mapping
	        } else {
	          // There is no new line in between.
	          // Associate the code between "lastGeneratedColumn" and
	          // "mapping.generatedColumn" with "lastMapping"
	          var nextLine = remainingLines[remainingLinesIndex];
	          var code = nextLine.substr(0, mapping.generatedColumn -
	                                        lastGeneratedColumn);
	          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
	                                              lastGeneratedColumn);
	          lastGeneratedColumn = mapping.generatedColumn;
	          addMappingWithCode(lastMapping, code);
	          // No more remaining code, continue
	          lastMapping = mapping;
	          return;
	        }
	      }
	      // We add the generated code until the first mapping
	      // to the SourceNode without any mapping.
	      // Each line is added as separate string.
	      while (lastGeneratedLine < mapping.generatedLine) {
	        node.add(shiftNextLine());
	        lastGeneratedLine++;
	      }
	      if (lastGeneratedColumn < mapping.generatedColumn) {
	        var nextLine = remainingLines[remainingLinesIndex];
	        node.add(nextLine.substr(0, mapping.generatedColumn));
	        remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
	        lastGeneratedColumn = mapping.generatedColumn;
	      }
	      lastMapping = mapping;
	    }, this);
	    // We have processed all mappings.
	    if (remainingLinesIndex < remainingLines.length) {
	      if (lastMapping) {
	        // Associate the remaining code in the current line with "lastMapping"
	        addMappingWithCode(lastMapping, shiftNextLine());
	      }
	      // and add the remaining lines without any mapping
	      node.add(remainingLines.splice(remainingLinesIndex).join(""));
	    }

	    // Copy sourcesContent into SourceNode
	    aSourceMapConsumer.sources.forEach(function (sourceFile) {
	      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	      if (content != null) {
	        if (aRelativePath != null) {
	          sourceFile = util$3.join(aRelativePath, sourceFile);
	        }
	        node.setSourceContent(sourceFile, content);
	      }
	    });

	    return node;

	    function addMappingWithCode(mapping, code) {
	      if (mapping === null || mapping.source === undefined) {
	        node.add(code);
	      } else {
	        var source = aRelativePath
	          ? util$3.join(aRelativePath, mapping.source)
	          : mapping.source;
	        node.add(new SourceNode(mapping.originalLine,
	                                mapping.originalColumn,
	                                source,
	                                code,
	                                mapping.name));
	      }
	    }
	  };

	/**
	 * Add a chunk of generated JS to this source node.
	 *
	 * @param aChunk A string snippet of generated JS code, another instance of
	 *        SourceNode, or an array where each member is one of those things.
	 */
	SourceNode.prototype.add = function SourceNode_add(aChunk) {
	  if (Array.isArray(aChunk)) {
	    aChunk.forEach(function (chunk) {
	      this.add(chunk);
	    }, this);
	  }
	  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
	    if (aChunk) {
	      this.children.push(aChunk);
	    }
	  }
	  else {
	    throw new TypeError(
	      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
	    );
	  }
	  return this;
	};

	/**
	 * Add a chunk of generated JS to the beginning of this source node.
	 *
	 * @param aChunk A string snippet of generated JS code, another instance of
	 *        SourceNode, or an array where each member is one of those things.
	 */
	SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
	  if (Array.isArray(aChunk)) {
	    for (var i = aChunk.length-1; i >= 0; i--) {
	      this.prepend(aChunk[i]);
	    }
	  }
	  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
	    this.children.unshift(aChunk);
	  }
	  else {
	    throw new TypeError(
	      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
	    );
	  }
	  return this;
	};

	/**
	 * Walk over the tree of JS snippets in this node and its children. The
	 * walking function is called once for each snippet of JS and is passed that
	 * snippet and the its original associated source's line/column location.
	 *
	 * @param aFn The traversal function.
	 */
	SourceNode.prototype.walk = function SourceNode_walk(aFn) {
	  var chunk;
	  for (var i = 0, len = this.children.length; i < len; i++) {
	    chunk = this.children[i];
	    if (chunk[isSourceNode]) {
	      chunk.walk(aFn);
	    }
	    else {
	      if (chunk !== '') {
	        aFn(chunk, { source: this.source,
	                     line: this.line,
	                     column: this.column,
	                     name: this.name });
	      }
	    }
	  }
	};

	/**
	 * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
	 * each of `this.children`.
	 *
	 * @param aSep The separator.
	 */
	SourceNode.prototype.join = function SourceNode_join(aSep) {
	  var newChildren;
	  var i;
	  var len = this.children.length;
	  if (len > 0) {
	    newChildren = [];
	    for (i = 0; i < len-1; i++) {
	      newChildren.push(this.children[i]);
	      newChildren.push(aSep);
	    }
	    newChildren.push(this.children[i]);
	    this.children = newChildren;
	  }
	  return this;
	};

	/**
	 * Call String.prototype.replace on the very right-most source snippet. Useful
	 * for trimming whitespace from the end of a source node, etc.
	 *
	 * @param aPattern The pattern to replace.
	 * @param aReplacement The thing to replace the pattern with.
	 */
	SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
	  var lastChild = this.children[this.children.length - 1];
	  if (lastChild[isSourceNode]) {
	    lastChild.replaceRight(aPattern, aReplacement);
	  }
	  else if (typeof lastChild === 'string') {
	    this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
	  }
	  else {
	    this.children.push(''.replace(aPattern, aReplacement));
	  }
	  return this;
	};

	/**
	 * Set the source content for a source file. This will be added to the SourceMapGenerator
	 * in the sourcesContent field.
	 *
	 * @param aSourceFile The filename of the source file
	 * @param aSourceContent The content of the source file
	 */
	SourceNode.prototype.setSourceContent =
	  function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
	    this.sourceContents[util$3.toSetString(aSourceFile)] = aSourceContent;
	  };

	/**
	 * Walk over the tree of SourceNodes. The walking function is called for each
	 * source file content and is passed the filename and source content.
	 *
	 * @param aFn The traversal function.
	 */
	SourceNode.prototype.walkSourceContents =
	  function SourceNode_walkSourceContents(aFn) {
	    for (var i = 0, len = this.children.length; i < len; i++) {
	      if (this.children[i][isSourceNode]) {
	        this.children[i].walkSourceContents(aFn);
	      }
	    }

	    var sources = Object.keys(this.sourceContents);
	    for (var i = 0, len = sources.length; i < len; i++) {
	      aFn(util$3.fromSetString(sources[i]), this.sourceContents[sources[i]]);
	    }
	  };

	/**
	 * Return the string representation of this source node. Walks over the tree
	 * and concatenates all the various snippets together to one string.
	 */
	SourceNode.prototype.toString = function SourceNode_toString() {
	  var str = "";
	  this.walk(function (chunk) {
	    str += chunk;
	  });
	  return str;
	};

	/**
	 * Returns the string representation of this source node along with a source
	 * map.
	 */
	SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
	  var generated = {
	    code: "",
	    line: 1,
	    column: 0
	  };
	  var map = new SourceMapGenerator$1(aArgs);
	  var sourceMappingActive = false;
	  var lastOriginalSource = null;
	  var lastOriginalLine = null;
	  var lastOriginalColumn = null;
	  var lastOriginalName = null;
	  this.walk(function (chunk, original) {
	    generated.code += chunk;
	    if (original.source !== null
	        && original.line !== null
	        && original.column !== null) {
	      if(lastOriginalSource !== original.source
	         || lastOriginalLine !== original.line
	         || lastOriginalColumn !== original.column
	         || lastOriginalName !== original.name) {
	        map.addMapping({
	          source: original.source,
	          original: {
	            line: original.line,
	            column: original.column
	          },
	          generated: {
	            line: generated.line,
	            column: generated.column
	          },
	          name: original.name
	        });
	      }
	      lastOriginalSource = original.source;
	      lastOriginalLine = original.line;
	      lastOriginalColumn = original.column;
	      lastOriginalName = original.name;
	      sourceMappingActive = true;
	    } else if (sourceMappingActive) {
	      map.addMapping({
	        generated: {
	          line: generated.line,
	          column: generated.column
	        }
	      });
	      lastOriginalSource = null;
	      sourceMappingActive = false;
	    }
	    for (var idx = 0, length = chunk.length; idx < length; idx++) {
	      if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
	        generated.line++;
	        generated.column = 0;
	        // Mappings end at eol
	        if (idx + 1 === length) {
	          lastOriginalSource = null;
	          sourceMappingActive = false;
	        } else if (sourceMappingActive) {
	          map.addMapping({
	            source: original.source,
	            original: {
	              line: original.line,
	              column: original.column
	            },
	            generated: {
	              line: generated.line,
	              column: generated.column
	            },
	            name: original.name
	          });
	        }
	      } else {
	        generated.column++;
	      }
	    }
	  });
	  this.walkSourceContents(function (sourceFile, sourceContent) {
	    map.setSourceContent(sourceFile, sourceContent);
	  });

	  return { code: generated.code, map: map };
	};

	var SourceNode_1 = SourceNode;

	var sourceNode = {
		SourceNode: SourceNode_1
	};

	/*
	 * Copyright 2009-2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE.txt or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	var SourceMapGenerator$2 = sourceMapGenerator.SourceMapGenerator;
	var SourceMapConsumer$1 = sourceMapConsumer.SourceMapConsumer;
	var SourceNode$1 = sourceNode.SourceNode;

	var sourceMap = {
		SourceMapGenerator: SourceMapGenerator$2,
		SourceMapConsumer: SourceMapConsumer$1,
		SourceNode: SourceNode$1
	};

	var sourceMap$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;

	var _sourceMap = _interopRequireDefault(sourceMap);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	class SourceMap {
	  constructor(opts, code) {
	    this._cachedMap = null;
	    this._code = code;
	    this._opts = opts;
	    this._rawMappings = [];
	  }

	  get() {
	    if (!this._cachedMap) {
	      const map = this._cachedMap = new _sourceMap.default.SourceMapGenerator({
	        sourceRoot: this._opts.sourceRoot
	      });
	      const code = this._code;

	      if (typeof code === "string") {
	        map.setSourceContent(this._opts.sourceFileName.replace(/\\/g, "/"), code);
	      } else if (typeof code === "object") {
	        Object.keys(code).forEach(sourceFileName => {
	          map.setSourceContent(sourceFileName.replace(/\\/g, "/"), code[sourceFileName]);
	        });
	      }

	      this._rawMappings.forEach(mapping => map.addMapping(mapping), map);
	    }

	    return this._cachedMap.toJSON();
	  }

	  getRawMappings() {
	    return this._rawMappings.slice();
	  }

	  mark(generatedLine, generatedColumn, line, column, identifierName, filename, force) {
	    if (this._lastGenLine !== generatedLine && line === null) return;

	    if (!force && this._lastGenLine === generatedLine && this._lastSourceLine === line && this._lastSourceColumn === column) {
	      return;
	    }

	    this._cachedMap = null;
	    this._lastGenLine = generatedLine;
	    this._lastSourceLine = line;
	    this._lastSourceColumn = column;

	    this._rawMappings.push({
	      name: identifierName || undefined,
	      generated: {
	        line: generatedLine,
	        column: generatedColumn
	      },
	      source: line == null ? undefined : (filename || this._opts.sourceFileName).replace(/\\/g, "/"),
	      original: line == null ? undefined : {
	        line: line,
	        column: column
	      }
	    });
	  }

	}

	exports.default = SourceMap;
	});

	unwrapExports(sourceMap$1);

	var buffer = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;
	const SPACES_RE = /^[ \t]+$/;

	class Buffer {
	  constructor(map) {
	    this._map = null;
	    this._buf = [];
	    this._last = "";
	    this._queue = [];
	    this._position = {
	      line: 1,
	      column: 0
	    };
	    this._sourcePosition = {
	      identifierName: null,
	      line: null,
	      column: null,
	      filename: null
	    };
	    this._disallowedPop = null;
	    this._map = map;
	  }

	  get() {
	    this._flush();

	    const map = this._map;
	    const result = {
	      code: this._buf.join("").trimRight(),
	      map: null,
	      rawMappings: map == null ? void 0 : map.getRawMappings()
	    };

	    if (map) {
	      Object.defineProperty(result, "map", {
	        configurable: true,
	        enumerable: true,

	        get() {
	          return this.map = map.get();
	        },

	        set(value) {
	          Object.defineProperty(this, "map", {
	            value,
	            writable: true
	          });
	        }

	      });
	    }

	    return result;
	  }

	  append(str) {
	    this._flush();

	    const {
	      line,
	      column,
	      filename,
	      identifierName,
	      force
	    } = this._sourcePosition;

	    this._append(str, line, column, identifierName, filename, force);
	  }

	  queue(str) {
	    if (str === "\n") {
	      while (this._queue.length > 0 && SPACES_RE.test(this._queue[0][0])) {
	        this._queue.shift();
	      }
	    }

	    const {
	      line,
	      column,
	      filename,
	      identifierName,
	      force
	    } = this._sourcePosition;

	    this._queue.unshift([str, line, column, identifierName, filename, force]);
	  }

	  _flush() {
	    let item;

	    while (item = this._queue.pop()) this._append(...item);
	  }

	  _append(str, line, column, identifierName, filename, force) {
	    this._buf.push(str);

	    this._last = str[str.length - 1];
	    let i = str.indexOf("\n");
	    let last = 0;

	    if (i !== 0) {
	      this._mark(line, column, identifierName, filename, force);
	    }

	    while (i !== -1) {
	      this._position.line++;
	      this._position.column = 0;
	      last = i + 1;

	      if (last < str.length) {
	        this._mark(++line, 0, identifierName, filename, force);
	      }

	      i = str.indexOf("\n", last);
	    }

	    this._position.column += str.length - last;
	  }

	  _mark(line, column, identifierName, filename, force) {
	    var _this$_map;

	    (_this$_map = this._map) == null ? void 0 : _this$_map.mark(this._position.line, this._position.column, line, column, identifierName, filename, force);
	  }

	  removeTrailingNewline() {
	    if (this._queue.length > 0 && this._queue[0][0] === "\n") {
	      this._queue.shift();
	    }
	  }

	  removeLastSemicolon() {
	    if (this._queue.length > 0 && this._queue[0][0] === ";") {
	      this._queue.shift();
	    }
	  }

	  endsWith(suffix) {
	    if (suffix.length === 1) {
	      let last;

	      if (this._queue.length > 0) {
	        const str = this._queue[0][0];
	        last = str[str.length - 1];
	      } else {
	        last = this._last;
	      }

	      return last === suffix;
	    }

	    const end = this._last + this._queue.reduce((acc, item) => item[0] + acc, "");

	    if (suffix.length <= end.length) {
	      return end.slice(-suffix.length) === suffix;
	    }

	    return false;
	  }

	  hasContent() {
	    return this._queue.length > 0 || !!this._last;
	  }

	  exactSource(loc, cb) {
	    this.source("start", loc, true);
	    cb();
	    this.source("end", loc);

	    this._disallowPop("start", loc);
	  }

	  source(prop, loc, force) {
	    if (prop && !loc) return;

	    this._normalizePosition(prop, loc, this._sourcePosition, force);
	  }

	  withSource(prop, loc, cb) {
	    if (!this._map) return cb();
	    const originalLine = this._sourcePosition.line;
	    const originalColumn = this._sourcePosition.column;
	    const originalFilename = this._sourcePosition.filename;
	    const originalIdentifierName = this._sourcePosition.identifierName;
	    this.source(prop, loc);
	    cb();

	    if ((!this._sourcePosition.force || this._sourcePosition.line !== originalLine || this._sourcePosition.column !== originalColumn || this._sourcePosition.filename !== originalFilename) && (!this._disallowedPop || this._disallowedPop.line !== originalLine || this._disallowedPop.column !== originalColumn || this._disallowedPop.filename !== originalFilename)) {
	      this._sourcePosition.line = originalLine;
	      this._sourcePosition.column = originalColumn;
	      this._sourcePosition.filename = originalFilename;
	      this._sourcePosition.identifierName = originalIdentifierName;
	      this._sourcePosition.force = false;
	      this._disallowedPop = null;
	    }
	  }

	  _disallowPop(prop, loc) {
	    if (prop && !loc) return;
	    this._disallowedPop = this._normalizePosition(prop, loc);
	  }

	  _normalizePosition(prop, loc, targetObj, force) {
	    const pos = loc ? loc[prop] : null;

	    if (targetObj === undefined) {
	      targetObj = {
	        identifierName: null,
	        line: null,
	        column: null,
	        filename: null,
	        force: false
	      };
	    }

	    const origLine = targetObj.line;
	    const origColumn = targetObj.column;
	    const origFilename = targetObj.filename;
	    targetObj.identifierName = prop === "start" && (loc == null ? void 0 : loc.identifierName) || null;
	    targetObj.line = pos == null ? void 0 : pos.line;
	    targetObj.column = pos == null ? void 0 : pos.column;
	    targetObj.filename = loc == null ? void 0 : loc.filename;

	    if (force || targetObj.line !== origLine || targetObj.column !== origColumn || targetObj.filename !== origFilename) {
	      targetObj.force = force;
	    }

	    return targetObj;
	  }

	  getCurrentColumn() {
	    const extra = this._queue.reduce((acc, item) => item[0] + acc, "");

	    const lastIndex = extra.lastIndexOf("\n");
	    return lastIndex === -1 ? this._position.column + extra.length : extra.length - 1 - lastIndex;
	  }

	  getCurrentLine() {
	    const extra = this._queue.reduce((acc, item) => item[0] + acc, "");

	    let count = 0;

	    for (let i = 0; i < extra.length; i++) {
	      if (extra[i] === "\n") count++;
	    }

	    return this._position.line + count;
	  }

	}

	exports.default = Buffer;
	});

	unwrapExports(buffer);

	var whitespace = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.list = exports.nodes = void 0;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function crawl(node, state = {}) {
	  if (t.isMemberExpression(node) || t.isOptionalMemberExpression(node)) {
	    crawl(node.object, state);
	    if (node.computed) crawl(node.property, state);
	  } else if (t.isBinary(node) || t.isAssignmentExpression(node)) {
	    crawl(node.left, state);
	    crawl(node.right, state);
	  } else if (t.isCallExpression(node) || t.isOptionalCallExpression(node)) {
	    state.hasCall = true;
	    crawl(node.callee, state);
	  } else if (t.isFunction(node)) {
	    state.hasFunction = true;
	  } else if (t.isIdentifier(node)) {
	    state.hasHelper = state.hasHelper || isHelper(node.callee);
	  }

	  return state;
	}

	function isHelper(node) {
	  if (t.isMemberExpression(node)) {
	    return isHelper(node.object) || isHelper(node.property);
	  } else if (t.isIdentifier(node)) {
	    return node.name === "require" || node.name[0] === "_";
	  } else if (t.isCallExpression(node)) {
	    return isHelper(node.callee);
	  } else if (t.isBinary(node) || t.isAssignmentExpression(node)) {
	    return t.isIdentifier(node.left) && isHelper(node.left) || isHelper(node.right);
	  } else {
	    return false;
	  }
	}

	function isType(node) {
	  return t.isLiteral(node) || t.isObjectExpression(node) || t.isArrayExpression(node) || t.isIdentifier(node) || t.isMemberExpression(node);
	}

	const nodes = {
	  AssignmentExpression(node) {
	    const state = crawl(node.right);

	    if (state.hasCall && state.hasHelper || state.hasFunction) {
	      return {
	        before: state.hasFunction,
	        after: true
	      };
	    }
	  },

	  SwitchCase(node, parent) {
	    return {
	      before: node.consequent.length || parent.cases[0] === node,
	      after: !node.consequent.length && parent.cases[parent.cases.length - 1] === node
	    };
	  },

	  LogicalExpression(node) {
	    if (t.isFunction(node.left) || t.isFunction(node.right)) {
	      return {
	        after: true
	      };
	    }
	  },

	  Literal(node) {
	    if (node.value === "use strict") {
	      return {
	        after: true
	      };
	    }
	  },

	  CallExpression(node) {
	    if (t.isFunction(node.callee) || isHelper(node)) {
	      return {
	        before: true,
	        after: true
	      };
	    }
	  },

	  OptionalCallExpression(node) {
	    if (t.isFunction(node.callee)) {
	      return {
	        before: true,
	        after: true
	      };
	    }
	  },

	  VariableDeclaration(node) {
	    for (let i = 0; i < node.declarations.length; i++) {
	      const declar = node.declarations[i];
	      let enabled = isHelper(declar.id) && !isType(declar.init);

	      if (!enabled) {
	        const state = crawl(declar.init);
	        enabled = isHelper(declar.init) && state.hasCall || state.hasFunction;
	      }

	      if (enabled) {
	        return {
	          before: true,
	          after: true
	        };
	      }
	    }
	  },

	  IfStatement(node) {
	    if (t.isBlockStatement(node.consequent)) {
	      return {
	        before: true,
	        after: true
	      };
	    }
	  }

	};
	exports.nodes = nodes;

	nodes.ObjectProperty = nodes.ObjectTypeProperty = nodes.ObjectMethod = function (node, parent) {
	  if (parent.properties[0] === node) {
	    return {
	      before: true
	    };
	  }
	};

	nodes.ObjectTypeCallProperty = function (node, parent) {
	  var _parent$properties;

	  if (parent.callProperties[0] === node && !((_parent$properties = parent.properties) == null ? void 0 : _parent$properties.length)) {
	    return {
	      before: true
	    };
	  }
	};

	nodes.ObjectTypeIndexer = function (node, parent) {
	  var _parent$properties2, _parent$callPropertie;

	  if (parent.indexers[0] === node && !((_parent$properties2 = parent.properties) == null ? void 0 : _parent$properties2.length) && !((_parent$callPropertie = parent.callProperties) == null ? void 0 : _parent$callPropertie.length)) {
	    return {
	      before: true
	    };
	  }
	};

	nodes.ObjectTypeInternalSlot = function (node, parent) {
	  var _parent$properties3, _parent$callPropertie2, _parent$indexers;

	  if (parent.internalSlots[0] === node && !((_parent$properties3 = parent.properties) == null ? void 0 : _parent$properties3.length) && !((_parent$callPropertie2 = parent.callProperties) == null ? void 0 : _parent$callPropertie2.length) && !((_parent$indexers = parent.indexers) == null ? void 0 : _parent$indexers.length)) {
	    return {
	      before: true
	    };
	  }
	};

	const list = {
	  VariableDeclaration(node) {
	    return node.declarations.map(decl => decl.init);
	  },

	  ArrayExpression(node) {
	    return node.elements;
	  },

	  ObjectExpression(node) {
	    return node.properties;
	  }

	};
	exports.list = list;
	[["Function", true], ["Class", true], ["Loop", true], ["LabeledStatement", true], ["SwitchStatement", true], ["TryStatement", true]].forEach(function ([type, amounts]) {
	  if (typeof amounts === "boolean") {
	    amounts = {
	      after: amounts,
	      before: amounts
	    };
	  }

	  [type].concat(t.FLIPPED_ALIAS_KEYS[type] || []).forEach(function (type) {
	    nodes[type] = function () {
	      return amounts;
	    };
	  });
	});
	});

	unwrapExports(whitespace);
	var whitespace_1 = whitespace.list;
	var whitespace_2 = whitespace.nodes;

	var parentheses = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.NullableTypeAnnotation = NullableTypeAnnotation;
	exports.FunctionTypeAnnotation = FunctionTypeAnnotation;
	exports.UpdateExpression = UpdateExpression;
	exports.ObjectExpression = ObjectExpression;
	exports.DoExpression = DoExpression;
	exports.Binary = Binary;
	exports.IntersectionTypeAnnotation = exports.UnionTypeAnnotation = UnionTypeAnnotation;
	exports.TSAsExpression = TSAsExpression;
	exports.TSTypeAssertion = TSTypeAssertion;
	exports.TSIntersectionType = exports.TSUnionType = TSUnionType;
	exports.TSInferType = TSInferType;
	exports.BinaryExpression = BinaryExpression;
	exports.SequenceExpression = SequenceExpression;
	exports.AwaitExpression = exports.YieldExpression = YieldExpression;
	exports.ClassExpression = ClassExpression;
	exports.UnaryLike = UnaryLike;
	exports.FunctionExpression = FunctionExpression;
	exports.ArrowFunctionExpression = ArrowFunctionExpression;
	exports.ConditionalExpression = ConditionalExpression;
	exports.OptionalCallExpression = exports.OptionalMemberExpression = OptionalMemberExpression;
	exports.AssignmentExpression = AssignmentExpression;
	exports.LogicalExpression = LogicalExpression;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	const PRECEDENCE = {
	  "||": 0,
	  "??": 0,
	  "&&": 1,
	  "|": 2,
	  "^": 3,
	  "&": 4,
	  "==": 5,
	  "===": 5,
	  "!=": 5,
	  "!==": 5,
	  "<": 6,
	  ">": 6,
	  "<=": 6,
	  ">=": 6,
	  in: 6,
	  instanceof: 6,
	  ">>": 7,
	  "<<": 7,
	  ">>>": 7,
	  "+": 8,
	  "-": 8,
	  "*": 9,
	  "/": 9,
	  "%": 9,
	  "**": 10
	};

	const isClassExtendsClause = (node, parent) => (t.isClassDeclaration(parent) || t.isClassExpression(parent)) && parent.superClass === node;

	const hasPostfixPart = (node, parent) => (t.isMemberExpression(parent) || t.isOptionalMemberExpression(parent)) && parent.object === node || (t.isCallExpression(parent) || t.isOptionalCallExpression(parent) || t.isNewExpression(parent)) && parent.callee === node || t.isTaggedTemplateExpression(parent) && parent.tag === node || t.isTSNonNullExpression(parent);

	function NullableTypeAnnotation(node, parent) {
	  return t.isArrayTypeAnnotation(parent);
	}

	function FunctionTypeAnnotation(node, parent, printStack) {
	  return t.isUnionTypeAnnotation(parent) || t.isIntersectionTypeAnnotation(parent) || t.isArrayTypeAnnotation(parent) || t.isTypeAnnotation(parent) && t.isArrowFunctionExpression(printStack[printStack.length - 3]);
	}

	function UpdateExpression(node, parent) {
	  return hasPostfixPart(node, parent) || isClassExtendsClause(node, parent);
	}

	function ObjectExpression(node, parent, printStack) {
	  return isFirstInStatement(printStack, {
	    considerArrow: true
	  });
	}

	function DoExpression(node, parent, printStack) {
	  return isFirstInStatement(printStack);
	}

	function Binary(node, parent) {
	  if (node.operator === "**" && t.isBinaryExpression(parent, {
	    operator: "**"
	  })) {
	    return parent.left === node;
	  }

	  if (isClassExtendsClause(node, parent)) {
	    return true;
	  }

	  if (hasPostfixPart(node, parent) || t.isUnaryLike(parent) || t.isAwaitExpression(parent)) {
	    return true;
	  }

	  if (t.isBinary(parent)) {
	    const parentOp = parent.operator;
	    const parentPos = PRECEDENCE[parentOp];
	    const nodeOp = node.operator;
	    const nodePos = PRECEDENCE[nodeOp];

	    if (parentPos === nodePos && parent.right === node && !t.isLogicalExpression(parent) || parentPos > nodePos) {
	      return true;
	    }
	  }
	}

	function UnionTypeAnnotation(node, parent) {
	  return t.isArrayTypeAnnotation(parent) || t.isNullableTypeAnnotation(parent) || t.isIntersectionTypeAnnotation(parent) || t.isUnionTypeAnnotation(parent);
	}

	function TSAsExpression() {
	  return true;
	}

	function TSTypeAssertion() {
	  return true;
	}

	function TSUnionType(node, parent) {
	  return t.isTSArrayType(parent) || t.isTSOptionalType(parent) || t.isTSIntersectionType(parent) || t.isTSUnionType(parent) || t.isTSRestType(parent);
	}

	function TSInferType(node, parent) {
	  return t.isTSArrayType(parent) || t.isTSOptionalType(parent);
	}

	function BinaryExpression(node, parent) {
	  return node.operator === "in" && (t.isVariableDeclarator(parent) || t.isFor(parent));
	}

	function SequenceExpression(node, parent) {
	  if (t.isForStatement(parent) || t.isThrowStatement(parent) || t.isReturnStatement(parent) || t.isIfStatement(parent) && parent.test === node || t.isWhileStatement(parent) && parent.test === node || t.isForInStatement(parent) && parent.right === node || t.isSwitchStatement(parent) && parent.discriminant === node || t.isExpressionStatement(parent) && parent.expression === node) {
	    return false;
	  }

	  return true;
	}

	function YieldExpression(node, parent) {
	  return t.isBinary(parent) || t.isUnaryLike(parent) || hasPostfixPart(node, parent) || t.isAwaitExpression(parent) && t.isYieldExpression(node) || t.isConditionalExpression(parent) && node === parent.test || isClassExtendsClause(node, parent);
	}

	function ClassExpression(node, parent, printStack) {
	  return isFirstInStatement(printStack, {
	    considerDefaultExports: true
	  });
	}

	function UnaryLike(node, parent) {
	  return hasPostfixPart(node, parent) || t.isBinaryExpression(parent, {
	    operator: "**",
	    left: node
	  }) || isClassExtendsClause(node, parent);
	}

	function FunctionExpression(node, parent, printStack) {
	  return isFirstInStatement(printStack, {
	    considerDefaultExports: true
	  });
	}

	function ArrowFunctionExpression(node, parent) {
	  return t.isExportDeclaration(parent) || ConditionalExpression(node, parent);
	}

	function ConditionalExpression(node, parent) {
	  if (t.isUnaryLike(parent) || t.isBinary(parent) || t.isConditionalExpression(parent, {
	    test: node
	  }) || t.isAwaitExpression(parent) || t.isTSTypeAssertion(parent) || t.isTSAsExpression(parent)) {
	    return true;
	  }

	  return UnaryLike(node, parent);
	}

	function OptionalMemberExpression(node, parent) {
	  return t.isCallExpression(parent, {
	    callee: node
	  }) || t.isMemberExpression(parent, {
	    object: node
	  });
	}

	function AssignmentExpression(node, parent, printStack) {
	  if (t.isObjectPattern(node.left)) {
	    return true;
	  } else {
	    return ConditionalExpression(node, parent);
	  }
	}

	function LogicalExpression(node, parent) {
	  switch (node.operator) {
	    case "||":
	      if (!t.isLogicalExpression(parent)) return false;
	      return parent.operator === "??" || parent.operator === "&&";

	    case "&&":
	      return t.isLogicalExpression(parent, {
	        operator: "??"
	      });

	    case "??":
	      return t.isLogicalExpression(parent) && parent.operator !== "??";
	  }
	}

	function isFirstInStatement(printStack, {
	  considerArrow = false,
	  considerDefaultExports = false
	} = {}) {
	  let i = printStack.length - 1;
	  let node = printStack[i];
	  i--;
	  let parent = printStack[i];

	  while (i >= 0) {
	    if (t.isExpressionStatement(parent, {
	      expression: node
	    }) || considerDefaultExports && t.isExportDefaultDeclaration(parent, {
	      declaration: node
	    }) || considerArrow && t.isArrowFunctionExpression(parent, {
	      body: node
	    })) {
	      return true;
	    }

	    if (hasPostfixPart(node, parent) && !t.isNewExpression(parent) || t.isSequenceExpression(parent) && parent.expressions[0] === node || t.isConditional(parent, {
	      test: node
	    }) || t.isBinary(parent, {
	      left: node
	    }) || t.isAssignmentExpression(parent, {
	      left: node
	    })) {
	      node = parent;
	      i--;
	      parent = printStack[i];
	    } else {
	      return false;
	    }
	  }

	  return false;
	}
	});

	unwrapExports(parentheses);
	var parentheses_1 = parentheses.NullableTypeAnnotation;
	var parentheses_2 = parentheses.FunctionTypeAnnotation;
	var parentheses_3 = parentheses.UpdateExpression;
	var parentheses_4 = parentheses.ObjectExpression;
	var parentheses_5 = parentheses.DoExpression;
	var parentheses_6 = parentheses.Binary;
	var parentheses_7 = parentheses.IntersectionTypeAnnotation;
	var parentheses_8 = parentheses.UnionTypeAnnotation;
	var parentheses_9 = parentheses.TSAsExpression;
	var parentheses_10 = parentheses.TSTypeAssertion;
	var parentheses_11 = parentheses.TSIntersectionType;
	var parentheses_12 = parentheses.TSUnionType;
	var parentheses_13 = parentheses.TSInferType;
	var parentheses_14 = parentheses.BinaryExpression;
	var parentheses_15 = parentheses.SequenceExpression;
	var parentheses_16 = parentheses.AwaitExpression;
	var parentheses_17 = parentheses.YieldExpression;
	var parentheses_18 = parentheses.ClassExpression;
	var parentheses_19 = parentheses.UnaryLike;
	var parentheses_20 = parentheses.FunctionExpression;
	var parentheses_21 = parentheses.ArrowFunctionExpression;
	var parentheses_22 = parentheses.ConditionalExpression;
	var parentheses_23 = parentheses.OptionalCallExpression;
	var parentheses_24 = parentheses.OptionalMemberExpression;
	var parentheses_25 = parentheses.AssignmentExpression;
	var parentheses_26 = parentheses.LogicalExpression;

	var node$2 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.needsWhitespace = needsWhitespace;
	exports.needsWhitespaceBefore = needsWhitespaceBefore;
	exports.needsWhitespaceAfter = needsWhitespaceAfter;
	exports.needsParens = needsParens;

	var whitespace$1 = _interopRequireWildcard(whitespace);

	var parens = _interopRequireWildcard(parentheses);

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function expandAliases(obj) {
	  const newObj = {};

	  function add(type, func) {
	    const fn = newObj[type];
	    newObj[type] = fn ? function (node, parent, stack) {
	      const result = fn(node, parent, stack);
	      return result == null ? func(node, parent, stack) : result;
	    } : func;
	  }

	  for (const type of Object.keys(obj)) {
	    const aliases = t.FLIPPED_ALIAS_KEYS[type];

	    if (aliases) {
	      for (const alias of aliases) {
	        add(alias, obj[type]);
	      }
	    } else {
	      add(type, obj[type]);
	    }
	  }

	  return newObj;
	}

	const expandedParens = expandAliases(parens);
	const expandedWhitespaceNodes = expandAliases(whitespace$1.nodes);
	const expandedWhitespaceList = expandAliases(whitespace$1.list);

	function find(obj, node, parent, printStack) {
	  const fn = obj[node.type];
	  return fn ? fn(node, parent, printStack) : null;
	}

	function isOrHasCallExpression(node) {
	  if (t.isCallExpression(node)) {
	    return true;
	  }

	  return t.isMemberExpression(node) && isOrHasCallExpression(node.object);
	}

	function needsWhitespace(node, parent, type) {
	  if (!node) return 0;

	  if (t.isExpressionStatement(node)) {
	    node = node.expression;
	  }

	  let linesInfo = find(expandedWhitespaceNodes, node, parent);

	  if (!linesInfo) {
	    const items = find(expandedWhitespaceList, node, parent);

	    if (items) {
	      for (let i = 0; i < items.length; i++) {
	        linesInfo = needsWhitespace(items[i], node, type);
	        if (linesInfo) break;
	      }
	    }
	  }

	  if (typeof linesInfo === "object" && linesInfo !== null) {
	    return linesInfo[type] || 0;
	  }

	  return 0;
	}

	function needsWhitespaceBefore(node, parent) {
	  return needsWhitespace(node, parent, "before");
	}

	function needsWhitespaceAfter(node, parent) {
	  return needsWhitespace(node, parent, "after");
	}

	function needsParens(node, parent, printStack) {
	  if (!parent) return false;

	  if (t.isNewExpression(parent) && parent.callee === node) {
	    if (isOrHasCallExpression(node)) return true;
	  }

	  return find(expandedParens, node, parent, printStack);
	}
	});

	unwrapExports(node$2);
	var node_1$1 = node$2.needsWhitespace;
	var node_2$1 = node$2.needsWhitespaceBefore;
	var node_3$1 = node$2.needsWhitespaceAfter;
	var node_4$1 = node$2.needsParens;

	var templateLiterals = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.TaggedTemplateExpression = TaggedTemplateExpression;
	exports.TemplateElement = TemplateElement;
	exports.TemplateLiteral = TemplateLiteral;

	function TaggedTemplateExpression(node) {
	  this.print(node.tag, node);
	  this.print(node.typeParameters, node);
	  this.print(node.quasi, node);
	}

	function TemplateElement(node, parent) {
	  const isFirst = parent.quasis[0] === node;
	  const isLast = parent.quasis[parent.quasis.length - 1] === node;
	  const value = (isFirst ? "`" : "}") + node.value.raw + (isLast ? "`" : "${");
	  this.token(value);
	}

	function TemplateLiteral(node) {
	  const quasis = node.quasis;

	  for (let i = 0; i < quasis.length; i++) {
	    this.print(quasis[i], node);

	    if (i + 1 < quasis.length) {
	      this.print(node.expressions[i], node);
	    }
	  }
	}
	});

	unwrapExports(templateLiterals);
	var templateLiterals_1 = templateLiterals.TaggedTemplateExpression;
	var templateLiterals_2 = templateLiterals.TemplateElement;
	var templateLiterals_3 = templateLiterals.TemplateLiteral;

	var expressions = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.UnaryExpression = UnaryExpression;
	exports.DoExpression = DoExpression;
	exports.ParenthesizedExpression = ParenthesizedExpression;
	exports.UpdateExpression = UpdateExpression;
	exports.ConditionalExpression = ConditionalExpression;
	exports.NewExpression = NewExpression;
	exports.SequenceExpression = SequenceExpression;
	exports.ThisExpression = ThisExpression;
	exports.Super = Super;
	exports.Decorator = Decorator;
	exports.OptionalMemberExpression = OptionalMemberExpression;
	exports.OptionalCallExpression = OptionalCallExpression;
	exports.CallExpression = CallExpression;
	exports.Import = Import;
	exports.EmptyStatement = EmptyStatement;
	exports.ExpressionStatement = ExpressionStatement;
	exports.AssignmentPattern = AssignmentPattern;
	exports.LogicalExpression = exports.BinaryExpression = exports.AssignmentExpression = AssignmentExpression;
	exports.BindExpression = BindExpression;
	exports.MemberExpression = MemberExpression;
	exports.MetaProperty = MetaProperty;
	exports.PrivateName = PrivateName;
	exports.V8IntrinsicIdentifier = V8IntrinsicIdentifier;
	exports.AwaitExpression = exports.YieldExpression = void 0;

	var t = _interopRequireWildcard(lib$1);

	var n = _interopRequireWildcard(node$2);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function UnaryExpression(node) {
	  if (node.operator === "void" || node.operator === "delete" || node.operator === "typeof" || node.operator === "throw") {
	    this.word(node.operator);
	    this.space();
	  } else {
	    this.token(node.operator);
	  }

	  this.print(node.argument, node);
	}

	function DoExpression(node) {
	  this.word("do");
	  this.space();
	  this.print(node.body, node);
	}

	function ParenthesizedExpression(node) {
	  this.token("(");
	  this.print(node.expression, node);
	  this.token(")");
	}

	function UpdateExpression(node) {
	  if (node.prefix) {
	    this.token(node.operator);
	    this.print(node.argument, node);
	  } else {
	    this.startTerminatorless(true);
	    this.print(node.argument, node);
	    this.endTerminatorless();
	    this.token(node.operator);
	  }
	}

	function ConditionalExpression(node) {
	  this.print(node.test, node);
	  this.space();
	  this.token("?");
	  this.space();
	  this.print(node.consequent, node);
	  this.space();
	  this.token(":");
	  this.space();
	  this.print(node.alternate, node);
	}

	function NewExpression(node, parent) {
	  this.word("new");
	  this.space();
	  this.print(node.callee, node);

	  if (this.format.minified && node.arguments.length === 0 && !node.optional && !t.isCallExpression(parent, {
	    callee: node
	  }) && !t.isMemberExpression(parent) && !t.isNewExpression(parent)) {
	    return;
	  }

	  this.print(node.typeArguments, node);
	  this.print(node.typeParameters, node);

	  if (node.optional) {
	    this.token("?.");
	  }

	  this.token("(");
	  this.printList(node.arguments, node);
	  this.token(")");
	}

	function SequenceExpression(node) {
	  this.printList(node.expressions, node);
	}

	function ThisExpression() {
	  this.word("this");
	}

	function Super() {
	  this.word("super");
	}

	function Decorator(node) {
	  this.token("@");
	  this.print(node.expression, node);
	  this.newline();
	}

	function OptionalMemberExpression(node) {
	  this.print(node.object, node);

	  if (!node.computed && t.isMemberExpression(node.property)) {
	    throw new TypeError("Got a MemberExpression for MemberExpression property");
	  }

	  let computed = node.computed;

	  if (t.isLiteral(node.property) && typeof node.property.value === "number") {
	    computed = true;
	  }

	  if (node.optional) {
	    this.token("?.");
	  }

	  if (computed) {
	    this.token("[");
	    this.print(node.property, node);
	    this.token("]");
	  } else {
	    if (!node.optional) {
	      this.token(".");
	    }

	    this.print(node.property, node);
	  }
	}

	function OptionalCallExpression(node) {
	  this.print(node.callee, node);
	  this.print(node.typeArguments, node);
	  this.print(node.typeParameters, node);

	  if (node.optional) {
	    this.token("?.");
	  }

	  this.token("(");
	  this.printList(node.arguments, node);
	  this.token(")");
	}

	function CallExpression(node) {
	  this.print(node.callee, node);
	  this.print(node.typeArguments, node);
	  this.print(node.typeParameters, node);
	  this.token("(");
	  this.printList(node.arguments, node);
	  this.token(")");
	}

	function Import() {
	  this.word("import");
	}

	function buildYieldAwait(keyword) {
	  return function (node) {
	    this.word(keyword);

	    if (node.delegate) {
	      this.token("*");
	    }

	    if (node.argument) {
	      this.space();
	      const terminatorState = this.startTerminatorless();
	      this.print(node.argument, node);
	      this.endTerminatorless(terminatorState);
	    }
	  };
	}

	const YieldExpression = buildYieldAwait("yield");
	exports.YieldExpression = YieldExpression;
	const AwaitExpression = buildYieldAwait("await");
	exports.AwaitExpression = AwaitExpression;

	function EmptyStatement() {
	  this.semicolon(true);
	}

	function ExpressionStatement(node) {
	  this.print(node.expression, node);
	  this.semicolon();
	}

	function AssignmentPattern(node) {
	  this.print(node.left, node);
	  if (node.left.optional) this.token("?");
	  this.print(node.left.typeAnnotation, node);
	  this.space();
	  this.token("=");
	  this.space();
	  this.print(node.right, node);
	}

	function AssignmentExpression(node, parent) {
	  const parens = this.inForStatementInitCounter && node.operator === "in" && !n.needsParens(node, parent);

	  if (parens) {
	    this.token("(");
	  }

	  this.print(node.left, node);
	  this.space();

	  if (node.operator === "in" || node.operator === "instanceof") {
	    this.word(node.operator);
	  } else {
	    this.token(node.operator);
	  }

	  this.space();
	  this.print(node.right, node);

	  if (parens) {
	    this.token(")");
	  }
	}

	function BindExpression(node) {
	  this.print(node.object, node);
	  this.token("::");
	  this.print(node.callee, node);
	}

	function MemberExpression(node) {
	  this.print(node.object, node);

	  if (!node.computed && t.isMemberExpression(node.property)) {
	    throw new TypeError("Got a MemberExpression for MemberExpression property");
	  }

	  let computed = node.computed;

	  if (t.isLiteral(node.property) && typeof node.property.value === "number") {
	    computed = true;
	  }

	  if (computed) {
	    this.token("[");
	    this.print(node.property, node);
	    this.token("]");
	  } else {
	    this.token(".");
	    this.print(node.property, node);
	  }
	}

	function MetaProperty(node) {
	  this.print(node.meta, node);
	  this.token(".");
	  this.print(node.property, node);
	}

	function PrivateName(node) {
	  this.token("#");
	  this.print(node.id, node);
	}

	function V8IntrinsicIdentifier(node) {
	  this.token("%");
	  this.word(node.name);
	}
	});

	unwrapExports(expressions);
	var expressions_1 = expressions.UnaryExpression;
	var expressions_2 = expressions.DoExpression;
	var expressions_3 = expressions.ParenthesizedExpression;
	var expressions_4 = expressions.UpdateExpression;
	var expressions_5 = expressions.ConditionalExpression;
	var expressions_6 = expressions.NewExpression;
	var expressions_7 = expressions.SequenceExpression;
	var expressions_8 = expressions.ThisExpression;
	var expressions_9 = expressions.Super;
	var expressions_10 = expressions.Decorator;
	var expressions_11 = expressions.OptionalMemberExpression;
	var expressions_12 = expressions.OptionalCallExpression;
	var expressions_13 = expressions.CallExpression;
	var expressions_14 = expressions.Import;
	var expressions_15 = expressions.EmptyStatement;
	var expressions_16 = expressions.ExpressionStatement;
	var expressions_17 = expressions.AssignmentPattern;
	var expressions_18 = expressions.LogicalExpression;
	var expressions_19 = expressions.BinaryExpression;
	var expressions_20 = expressions.AssignmentExpression;
	var expressions_21 = expressions.BindExpression;
	var expressions_22 = expressions.MemberExpression;
	var expressions_23 = expressions.MetaProperty;
	var expressions_24 = expressions.PrivateName;
	var expressions_25 = expressions.V8IntrinsicIdentifier;
	var expressions_26 = expressions.AwaitExpression;
	var expressions_27 = expressions.YieldExpression;

	var statements = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.WithStatement = WithStatement;
	exports.IfStatement = IfStatement;
	exports.ForStatement = ForStatement;
	exports.WhileStatement = WhileStatement;
	exports.DoWhileStatement = DoWhileStatement;
	exports.LabeledStatement = LabeledStatement;
	exports.TryStatement = TryStatement;
	exports.CatchClause = CatchClause;
	exports.SwitchStatement = SwitchStatement;
	exports.SwitchCase = SwitchCase;
	exports.DebuggerStatement = DebuggerStatement;
	exports.VariableDeclaration = VariableDeclaration;
	exports.VariableDeclarator = VariableDeclarator;
	exports.ThrowStatement = exports.BreakStatement = exports.ReturnStatement = exports.ContinueStatement = exports.ForOfStatement = exports.ForInStatement = void 0;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function WithStatement(node) {
	  this.word("with");
	  this.space();
	  this.token("(");
	  this.print(node.object, node);
	  this.token(")");
	  this.printBlock(node);
	}

	function IfStatement(node) {
	  this.word("if");
	  this.space();
	  this.token("(");
	  this.print(node.test, node);
	  this.token(")");
	  this.space();
	  const needsBlock = node.alternate && t.isIfStatement(getLastStatement(node.consequent));

	  if (needsBlock) {
	    this.token("{");
	    this.newline();
	    this.indent();
	  }

	  this.printAndIndentOnComments(node.consequent, node);

	  if (needsBlock) {
	    this.dedent();
	    this.newline();
	    this.token("}");
	  }

	  if (node.alternate) {
	    if (this.endsWith("}")) this.space();
	    this.word("else");
	    this.space();
	    this.printAndIndentOnComments(node.alternate, node);
	  }
	}

	function getLastStatement(statement) {
	  if (!t.isStatement(statement.body)) return statement;
	  return getLastStatement(statement.body);
	}

	function ForStatement(node) {
	  this.word("for");
	  this.space();
	  this.token("(");
	  this.inForStatementInitCounter++;
	  this.print(node.init, node);
	  this.inForStatementInitCounter--;
	  this.token(";");

	  if (node.test) {
	    this.space();
	    this.print(node.test, node);
	  }

	  this.token(";");

	  if (node.update) {
	    this.space();
	    this.print(node.update, node);
	  }

	  this.token(")");
	  this.printBlock(node);
	}

	function WhileStatement(node) {
	  this.word("while");
	  this.space();
	  this.token("(");
	  this.print(node.test, node);
	  this.token(")");
	  this.printBlock(node);
	}

	const buildForXStatement = function (op) {
	  return function (node) {
	    this.word("for");
	    this.space();

	    if (op === "of" && node.await) {
	      this.word("await");
	      this.space();
	    }

	    this.token("(");
	    this.print(node.left, node);
	    this.space();
	    this.word(op);
	    this.space();
	    this.print(node.right, node);
	    this.token(")");
	    this.printBlock(node);
	  };
	};

	const ForInStatement = buildForXStatement("in");
	exports.ForInStatement = ForInStatement;
	const ForOfStatement = buildForXStatement("of");
	exports.ForOfStatement = ForOfStatement;

	function DoWhileStatement(node) {
	  this.word("do");
	  this.space();
	  this.print(node.body, node);
	  this.space();
	  this.word("while");
	  this.space();
	  this.token("(");
	  this.print(node.test, node);
	  this.token(")");
	  this.semicolon();
	}

	function buildLabelStatement(prefix, key = "label") {
	  return function (node) {
	    this.word(prefix);
	    const label = node[key];

	    if (label) {
	      this.space();
	      const isLabel = key == "label";
	      const terminatorState = this.startTerminatorless(isLabel);
	      this.print(label, node);
	      this.endTerminatorless(terminatorState);
	    }

	    this.semicolon();
	  };
	}

	const ContinueStatement = buildLabelStatement("continue");
	exports.ContinueStatement = ContinueStatement;
	const ReturnStatement = buildLabelStatement("return", "argument");
	exports.ReturnStatement = ReturnStatement;
	const BreakStatement = buildLabelStatement("break");
	exports.BreakStatement = BreakStatement;
	const ThrowStatement = buildLabelStatement("throw", "argument");
	exports.ThrowStatement = ThrowStatement;

	function LabeledStatement(node) {
	  this.print(node.label, node);
	  this.token(":");
	  this.space();
	  this.print(node.body, node);
	}

	function TryStatement(node) {
	  this.word("try");
	  this.space();
	  this.print(node.block, node);
	  this.space();

	  if (node.handlers) {
	    this.print(node.handlers[0], node);
	  } else {
	    this.print(node.handler, node);
	  }

	  if (node.finalizer) {
	    this.space();
	    this.word("finally");
	    this.space();
	    this.print(node.finalizer, node);
	  }
	}

	function CatchClause(node) {
	  this.word("catch");
	  this.space();

	  if (node.param) {
	    this.token("(");
	    this.print(node.param, node);
	    this.print(node.param.typeAnnotation, node);
	    this.token(")");
	    this.space();
	  }

	  this.print(node.body, node);
	}

	function SwitchStatement(node) {
	  this.word("switch");
	  this.space();
	  this.token("(");
	  this.print(node.discriminant, node);
	  this.token(")");
	  this.space();
	  this.token("{");
	  this.printSequence(node.cases, node, {
	    indent: true,

	    addNewlines(leading, cas) {
	      if (!leading && node.cases[node.cases.length - 1] === cas) return -1;
	    }

	  });
	  this.token("}");
	}

	function SwitchCase(node) {
	  if (node.test) {
	    this.word("case");
	    this.space();
	    this.print(node.test, node);
	    this.token(":");
	  } else {
	    this.word("default");
	    this.token(":");
	  }

	  if (node.consequent.length) {
	    this.newline();
	    this.printSequence(node.consequent, node, {
	      indent: true
	    });
	  }
	}

	function DebuggerStatement() {
	  this.word("debugger");
	  this.semicolon();
	}

	function variableDeclarationIndent() {
	  this.token(",");
	  this.newline();
	  if (this.endsWith("\n")) for (let i = 0; i < 4; i++) this.space(true);
	}

	function constDeclarationIndent() {
	  this.token(",");
	  this.newline();
	  if (this.endsWith("\n")) for (let i = 0; i < 6; i++) this.space(true);
	}

	function VariableDeclaration(node, parent) {
	  if (node.declare) {
	    this.word("declare");
	    this.space();
	  }

	  this.word(node.kind);
	  this.space();
	  let hasInits = false;

	  if (!t.isFor(parent)) {
	    for (const declar of node.declarations) {
	      if (declar.init) {
	        hasInits = true;
	      }
	    }
	  }

	  let separator;

	  if (hasInits) {
	    separator = node.kind === "const" ? constDeclarationIndent : variableDeclarationIndent;
	  }

	  this.printList(node.declarations, node, {
	    separator
	  });

	  if (t.isFor(parent)) {
	    if (parent.left === node || parent.init === node) return;
	  }

	  this.semicolon();
	}

	function VariableDeclarator(node) {
	  this.print(node.id, node);
	  if (node.definite) this.token("!");
	  this.print(node.id.typeAnnotation, node);

	  if (node.init) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(node.init, node);
	  }
	}
	});

	unwrapExports(statements);
	var statements_1 = statements.WithStatement;
	var statements_2 = statements.IfStatement;
	var statements_3 = statements.ForStatement;
	var statements_4 = statements.WhileStatement;
	var statements_5 = statements.DoWhileStatement;
	var statements_6 = statements.LabeledStatement;
	var statements_7 = statements.TryStatement;
	var statements_8 = statements.CatchClause;
	var statements_9 = statements.SwitchStatement;
	var statements_10 = statements.SwitchCase;
	var statements_11 = statements.DebuggerStatement;
	var statements_12 = statements.VariableDeclaration;
	var statements_13 = statements.VariableDeclarator;
	var statements_14 = statements.ThrowStatement;
	var statements_15 = statements.BreakStatement;
	var statements_16 = statements.ReturnStatement;
	var statements_17 = statements.ContinueStatement;
	var statements_18 = statements.ForOfStatement;
	var statements_19 = statements.ForInStatement;

	var classes = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.ClassExpression = exports.ClassDeclaration = ClassDeclaration;
	exports.ClassBody = ClassBody;
	exports.ClassProperty = ClassProperty;
	exports.ClassPrivateProperty = ClassPrivateProperty;
	exports.ClassMethod = ClassMethod;
	exports.ClassPrivateMethod = ClassPrivateMethod;
	exports._classMethodHead = _classMethodHead;
	exports.StaticBlock = StaticBlock;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function ClassDeclaration(node, parent) {
	  if (!this.format.decoratorsBeforeExport || !t.isExportDefaultDeclaration(parent) && !t.isExportNamedDeclaration(parent)) {
	    this.printJoin(node.decorators, node);
	  }

	  if (node.declare) {
	    this.word("declare");
	    this.space();
	  }

	  if (node.abstract) {
	    this.word("abstract");
	    this.space();
	  }

	  this.word("class");

	  if (node.id) {
	    this.space();
	    this.print(node.id, node);
	  }

	  this.print(node.typeParameters, node);

	  if (node.superClass) {
	    this.space();
	    this.word("extends");
	    this.space();
	    this.print(node.superClass, node);
	    this.print(node.superTypeParameters, node);
	  }

	  if (node.implements) {
	    this.space();
	    this.word("implements");
	    this.space();
	    this.printList(node.implements, node);
	  }

	  this.space();
	  this.print(node.body, node);
	}

	function ClassBody(node) {
	  this.token("{");
	  this.printInnerComments(node);

	  if (node.body.length === 0) {
	    this.token("}");
	  } else {
	    this.newline();
	    this.indent();
	    this.printSequence(node.body, node);
	    this.dedent();
	    if (!this.endsWith("\n")) this.newline();
	    this.rightBrace();
	  }
	}

	function ClassProperty(node) {
	  this.printJoin(node.decorators, node);
	  this.tsPrintClassMemberModifiers(node, true);

	  if (node.computed) {
	    this.token("[");
	    this.print(node.key, node);
	    this.token("]");
	  } else {
	    this._variance(node);

	    this.print(node.key, node);
	  }

	  if (node.optional) {
	    this.token("?");
	  }

	  if (node.definite) {
	    this.token("!");
	  }

	  this.print(node.typeAnnotation, node);

	  if (node.value) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(node.value, node);
	  }

	  this.semicolon();
	}

	function ClassPrivateProperty(node) {
	  this.printJoin(node.decorators, node);

	  if (node.static) {
	    this.word("static");
	    this.space();
	  }

	  this.print(node.key, node);
	  this.print(node.typeAnnotation, node);

	  if (node.value) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(node.value, node);
	  }

	  this.semicolon();
	}

	function ClassMethod(node) {
	  this._classMethodHead(node);

	  this.space();
	  this.print(node.body, node);
	}

	function ClassPrivateMethod(node) {
	  this._classMethodHead(node);

	  this.space();
	  this.print(node.body, node);
	}

	function _classMethodHead(node) {
	  this.printJoin(node.decorators, node);
	  this.tsPrintClassMemberModifiers(node, false);

	  this._methodHead(node);
	}

	function StaticBlock(node) {
	  this.word("static");
	  this.space();
	  this.token("{");

	  if (node.body.length === 0) {
	    this.token("}");
	  } else {
	    this.newline();
	    this.printSequence(node.body, node, {
	      indent: true
	    });
	    this.rightBrace();
	  }
	}
	});

	unwrapExports(classes);
	var classes_1 = classes.ClassExpression;
	var classes_2 = classes.ClassDeclaration;
	var classes_3 = classes.ClassBody;
	var classes_4 = classes.ClassProperty;
	var classes_5 = classes.ClassPrivateProperty;
	var classes_6 = classes.ClassMethod;
	var classes_7 = classes.ClassPrivateMethod;
	var classes_8 = classes._classMethodHead;
	var classes_9 = classes.StaticBlock;

	var methods = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports._params = _params;
	exports._parameters = _parameters;
	exports._param = _param;
	exports._methodHead = _methodHead;
	exports._predicate = _predicate;
	exports._functionHead = _functionHead;
	exports.FunctionDeclaration = exports.FunctionExpression = FunctionExpression;
	exports.ArrowFunctionExpression = ArrowFunctionExpression;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _params(node) {
	  this.print(node.typeParameters, node);
	  this.token("(");

	  this._parameters(node.params, node);

	  this.token(")");
	  this.print(node.returnType, node);
	}

	function _parameters(parameters, parent) {
	  for (let i = 0; i < parameters.length; i++) {
	    this._param(parameters[i], parent);

	    if (i < parameters.length - 1) {
	      this.token(",");
	      this.space();
	    }
	  }
	}

	function _param(parameter, parent) {
	  this.printJoin(parameter.decorators, parameter);
	  this.print(parameter, parent);
	  if (parameter.optional) this.token("?");
	  this.print(parameter.typeAnnotation, parameter);
	}

	function _methodHead(node) {
	  const kind = node.kind;
	  const key = node.key;

	  if (kind === "get" || kind === "set") {
	    this.word(kind);
	    this.space();
	  }

	  if (node.async) {
	    this._catchUp("start", key.loc);

	    this.word("async");
	    this.space();
	  }

	  if (kind === "method" || kind === "init") {
	    if (node.generator) {
	      this.token("*");
	    }
	  }

	  if (node.computed) {
	    this.token("[");
	    this.print(key, node);
	    this.token("]");
	  } else {
	    this.print(key, node);
	  }

	  if (node.optional) {
	    this.token("?");
	  }

	  this._params(node);
	}

	function _predicate(node) {
	  if (node.predicate) {
	    if (!node.returnType) {
	      this.token(":");
	    }

	    this.space();
	    this.print(node.predicate, node);
	  }
	}

	function _functionHead(node) {
	  if (node.async) {
	    this.word("async");
	    this.space();
	  }

	  this.word("function");
	  if (node.generator) this.token("*");
	  this.space();

	  if (node.id) {
	    this.print(node.id, node);
	  }

	  this._params(node);

	  this._predicate(node);
	}

	function FunctionExpression(node) {
	  this._functionHead(node);

	  this.space();
	  this.print(node.body, node);
	}

	function ArrowFunctionExpression(node) {
	  if (node.async) {
	    this.word("async");
	    this.space();
	  }

	  const firstParam = node.params[0];

	  if (node.params.length === 1 && t.isIdentifier(firstParam) && !hasTypes(node, firstParam)) {
	    if ((this.format.retainLines || node.async) && node.loc && node.body.loc && node.loc.start.line < node.body.loc.start.line) {
	      this.token("(");

	      if (firstParam.loc && firstParam.loc.start.line > node.loc.start.line) {
	        this.indent();
	        this.print(firstParam, node);
	        this.dedent();

	        this._catchUp("start", node.body.loc);
	      } else {
	        this.print(firstParam, node);
	      }

	      this.token(")");
	    } else {
	      this.print(firstParam, node);
	    }
	  } else {
	    this._params(node);
	  }

	  this._predicate(node);

	  this.space();
	  this.token("=>");
	  this.space();
	  this.print(node.body, node);
	}

	function hasTypes(node, param) {
	  return node.typeParameters || node.returnType || param.typeAnnotation || param.optional || param.trailingComments;
	}
	});

	unwrapExports(methods);
	var methods_1 = methods._params;
	var methods_2 = methods._parameters;
	var methods_3 = methods._param;
	var methods_4 = methods._methodHead;
	var methods_5 = methods._predicate;
	var methods_6 = methods._functionHead;
	var methods_7 = methods.FunctionDeclaration;
	var methods_8 = methods.FunctionExpression;
	var methods_9 = methods.ArrowFunctionExpression;

	var modules = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.ImportSpecifier = ImportSpecifier;
	exports.ImportDefaultSpecifier = ImportDefaultSpecifier;
	exports.ExportDefaultSpecifier = ExportDefaultSpecifier;
	exports.ExportSpecifier = ExportSpecifier;
	exports.ExportNamespaceSpecifier = ExportNamespaceSpecifier;
	exports.ExportAllDeclaration = ExportAllDeclaration;
	exports.ExportNamedDeclaration = ExportNamedDeclaration;
	exports.ExportDefaultDeclaration = ExportDefaultDeclaration;
	exports.ImportDeclaration = ImportDeclaration;
	exports.ImportAttribute = ImportAttribute;
	exports.ImportNamespaceSpecifier = ImportNamespaceSpecifier;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function ImportSpecifier(node) {
	  if (node.importKind === "type" || node.importKind === "typeof") {
	    this.word(node.importKind);
	    this.space();
	  }

	  this.print(node.imported, node);

	  if (node.local && node.local.name !== node.imported.name) {
	    this.space();
	    this.word("as");
	    this.space();
	    this.print(node.local, node);
	  }
	}

	function ImportDefaultSpecifier(node) {
	  this.print(node.local, node);
	}

	function ExportDefaultSpecifier(node) {
	  this.print(node.exported, node);
	}

	function ExportSpecifier(node) {
	  this.print(node.local, node);

	  if (node.exported && node.local.name !== node.exported.name) {
	    this.space();
	    this.word("as");
	    this.space();
	    this.print(node.exported, node);
	  }
	}

	function ExportNamespaceSpecifier(node) {
	  this.token("*");
	  this.space();
	  this.word("as");
	  this.space();
	  this.print(node.exported, node);
	}

	function ExportAllDeclaration(node) {
	  this.word("export");
	  this.space();

	  if (node.exportKind === "type") {
	    this.word("type");
	    this.space();
	  }

	  this.token("*");
	  this.space();
	  this.word("from");
	  this.space();
	  this.print(node.source, node);
	  this.printAssertions(node);
	  this.semicolon();
	}

	function ExportNamedDeclaration(node) {
	  if (this.format.decoratorsBeforeExport && t.isClassDeclaration(node.declaration)) {
	    this.printJoin(node.declaration.decorators, node);
	  }

	  this.word("export");
	  this.space();
	  ExportDeclaration.apply(this, arguments);
	}

	function ExportDefaultDeclaration(node) {
	  if (this.format.decoratorsBeforeExport && t.isClassDeclaration(node.declaration)) {
	    this.printJoin(node.declaration.decorators, node);
	  }

	  this.word("export");
	  this.space();
	  this.word("default");
	  this.space();
	  ExportDeclaration.apply(this, arguments);
	}

	function ExportDeclaration(node) {
	  if (node.declaration) {
	    const declar = node.declaration;
	    this.print(declar, node);
	    if (!t.isStatement(declar)) this.semicolon();
	  } else {
	    if (node.exportKind === "type") {
	      this.word("type");
	      this.space();
	    }

	    const specifiers = node.specifiers.slice(0);
	    let hasSpecial = false;

	    for (;;) {
	      const first = specifiers[0];

	      if (t.isExportDefaultSpecifier(first) || t.isExportNamespaceSpecifier(first)) {
	        hasSpecial = true;
	        this.print(specifiers.shift(), node);

	        if (specifiers.length) {
	          this.token(",");
	          this.space();
	        }
	      } else {
	        break;
	      }
	    }

	    if (specifiers.length || !specifiers.length && !hasSpecial) {
	      this.token("{");

	      if (specifiers.length) {
	        this.space();
	        this.printList(specifiers, node);
	        this.space();
	      }

	      this.token("}");
	    }

	    if (node.source) {
	      this.space();
	      this.word("from");
	      this.space();
	      this.print(node.source, node);
	      this.printAssertions(node);
	    }

	    this.semicolon();
	  }
	}

	function ImportDeclaration(node) {
	  var _node$attributes;

	  this.word("import");
	  this.space();

	  if (node.importKind === "type" || node.importKind === "typeof") {
	    this.word(node.importKind);
	    this.space();
	  }

	  const specifiers = node.specifiers.slice(0);

	  if (specifiers == null ? void 0 : specifiers.length) {
	    for (;;) {
	      const first = specifiers[0];

	      if (t.isImportDefaultSpecifier(first) || t.isImportNamespaceSpecifier(first)) {
	        this.print(specifiers.shift(), node);

	        if (specifiers.length) {
	          this.token(",");
	          this.space();
	        }
	      } else {
	        break;
	      }
	    }

	    if (specifiers.length) {
	      this.token("{");
	      this.space();
	      this.printList(specifiers, node);
	      this.space();
	      this.token("}");
	    }

	    this.space();
	    this.word("from");
	    this.space();
	  }

	  this.print(node.source, node);
	  this.printAssertions(node);

	  if ((_node$attributes = node.attributes) == null ? void 0 : _node$attributes.length) {
	    this.space();
	    this.word("with");
	    this.space();
	    this.printList(node.attributes, node);
	  }

	  this.semicolon();
	}

	function ImportAttribute(node) {
	  this.print(node.key);
	  this.token(":");
	  this.space();
	  this.print(node.value);
	}

	function ImportNamespaceSpecifier(node) {
	  this.token("*");
	  this.space();
	  this.word("as");
	  this.space();
	  this.print(node.local, node);
	}
	});

	unwrapExports(modules);
	var modules_1 = modules.ImportSpecifier;
	var modules_2 = modules.ImportDefaultSpecifier;
	var modules_3 = modules.ExportDefaultSpecifier;
	var modules_4 = modules.ExportSpecifier;
	var modules_5 = modules.ExportNamespaceSpecifier;
	var modules_6 = modules.ExportAllDeclaration;
	var modules_7 = modules.ExportNamedDeclaration;
	var modules_8 = modules.ExportDefaultDeclaration;
	var modules_9 = modules.ImportDeclaration;
	var modules_10 = modules.ImportAttribute;
	var modules_11 = modules.ImportNamespaceSpecifier;

	const object = {};
	const hasOwnProperty$c = object.hasOwnProperty;
	const forOwn = (object, callback) => {
		for (const key in object) {
			if (hasOwnProperty$c.call(object, key)) {
				callback(key, object[key]);
			}
		}
	};

	const extend = (destination, source) => {
		if (!source) {
			return destination;
		}
		forOwn(source, (key, value) => {
			destination[key] = value;
		});
		return destination;
	};

	const forEach = (array, callback) => {
		const length = array.length;
		let index = -1;
		while (++index < length) {
			callback(array[index]);
		}
	};

	const toString$1 = object.toString;
	const isArray$3 = Array.isArray;
	const isBuffer$2 = isBuffer;
	const isObject$2 = (value) => {
		// This is a very simple check, but it’s good enough for what we need.
		return toString$1.call(value) == '[object Object]';
	};
	const isString$1 = (value) => {
		return typeof value == 'string' ||
			toString$1.call(value) == '[object String]';
	};
	const isNumber$1 = (value) => {
		return typeof value == 'number' ||
			toString$1.call(value) == '[object Number]';
	};
	const isFunction$2 = (value) => {
		return typeof value == 'function';
	};
	const isMap$1 = (value) => {
		return toString$1.call(value) == '[object Map]';
	};
	const isSet$1 = (value) => {
		return toString$1.call(value) == '[object Set]';
	};

	/*--------------------------------------------------------------------------*/

	// https://mathiasbynens.be/notes/javascript-escapes#single
	const singleEscapes = {
		'"': '\\"',
		'\'': '\\\'',
		'\\': '\\\\',
		'\b': '\\b',
		'\f': '\\f',
		'\n': '\\n',
		'\r': '\\r',
		'\t': '\\t'
		// `\v` is omitted intentionally, because in IE < 9, '\v' == 'v'.
		// '\v': '\\x0B'
	};
	const regexSingleEscape = /["'\\\b\f\n\r\t]/;

	const regexDigit = /[0-9]/;
	const regexWhitelist = /[ !#-&\(-\[\]-_a-~]/;

	const jsesc = (argument, options) => {
		const increaseIndentation = () => {
			oldIndent = indent;
			++options.indentLevel;
			indent = options.indent.repeat(options.indentLevel);
		};
		// Handle options
		const defaults = {
			'escapeEverything': false,
			'minimal': false,
			'isScriptContext': false,
			'quotes': 'single',
			'wrap': false,
			'es6': false,
			'json': false,
			'compact': true,
			'lowercaseHex': false,
			'numbers': 'decimal',
			'indent': '\t',
			'indentLevel': 0,
			'__inline1__': false,
			'__inline2__': false
		};
		const json = options && options.json;
		if (json) {
			defaults.quotes = 'double';
			defaults.wrap = true;
		}
		options = extend(defaults, options);
		if (
			options.quotes != 'single' &&
			options.quotes != 'double' &&
			options.quotes != 'backtick'
		) {
			options.quotes = 'single';
		}
		const quote = options.quotes == 'double' ?
			'"' :
			(options.quotes == 'backtick' ?
				'`' :
				'\''
			);
		const compact = options.compact;
		const lowercaseHex = options.lowercaseHex;
		let indent = options.indent.repeat(options.indentLevel);
		let oldIndent = '';
		const inline1 = options.__inline1__;
		const inline2 = options.__inline2__;
		const newLine = compact ? '' : '\n';
		let result;
		let isEmpty = true;
		const useBinNumbers = options.numbers == 'binary';
		const useOctNumbers = options.numbers == 'octal';
		const useDecNumbers = options.numbers == 'decimal';
		const useHexNumbers = options.numbers == 'hexadecimal';

		if (json && argument && isFunction$2(argument.toJSON)) {
			argument = argument.toJSON();
		}

		if (!isString$1(argument)) {
			if (isMap$1(argument)) {
				if (argument.size == 0) {
					return 'new Map()';
				}
				if (!compact) {
					options.__inline1__ = true;
					options.__inline2__ = false;
				}
				return 'new Map(' + jsesc(Array.from(argument), options) + ')';
			}
			if (isSet$1(argument)) {
				if (argument.size == 0) {
					return 'new Set()';
				}
				return 'new Set(' + jsesc(Array.from(argument), options) + ')';
			}
			if (isBuffer$2(argument)) {
				if (argument.length == 0) {
					return 'Buffer.from([])';
				}
				return 'Buffer.from(' + jsesc(Array.from(argument), options) + ')';
			}
			if (isArray$3(argument)) {
				result = [];
				options.wrap = true;
				if (inline1) {
					options.__inline1__ = false;
					options.__inline2__ = true;
				}
				if (!inline2) {
					increaseIndentation();
				}
				forEach(argument, (value) => {
					isEmpty = false;
					if (inline2) {
						options.__inline2__ = false;
					}
					result.push(
						(compact || inline2 ? '' : indent) +
						jsesc(value, options)
					);
				});
				if (isEmpty) {
					return '[]';
				}
				if (inline2) {
					return '[' + result.join(', ') + ']';
				}
				return '[' + newLine + result.join(',' + newLine) + newLine +
					(compact ? '' : oldIndent) + ']';
			} else if (isNumber$1(argument)) {
				if (json) {
					// Some number values (e.g. `Infinity`) cannot be represented in JSON.
					return JSON.stringify(argument);
				}
				if (useDecNumbers) {
					return String(argument);
				}
				if (useHexNumbers) {
					let hexadecimal = argument.toString(16);
					if (!lowercaseHex) {
						hexadecimal = hexadecimal.toUpperCase();
					}
					return '0x' + hexadecimal;
				}
				if (useBinNumbers) {
					return '0b' + argument.toString(2);
				}
				if (useOctNumbers) {
					return '0o' + argument.toString(8);
				}
			} else if (!isObject$2(argument)) {
				if (json) {
					// For some values (e.g. `undefined`, `function` objects),
					// `JSON.stringify(value)` returns `undefined` (which isn’t valid
					// JSON) instead of `'null'`.
					return JSON.stringify(argument) || 'null';
				}
				return String(argument);
			} else { // it’s an object
				result = [];
				options.wrap = true;
				increaseIndentation();
				forOwn(argument, (key, value) => {
					isEmpty = false;
					result.push(
						(compact ? '' : indent) +
						jsesc(key, options) + ':' +
						(compact ? '' : ' ') +
						jsesc(value, options)
					);
				});
				if (isEmpty) {
					return '{}';
				}
				return '{' + newLine + result.join(',' + newLine) + newLine +
					(compact ? '' : oldIndent) + '}';
			}
		}

		const string = argument;
		// Loop over each code unit in the string and escape it
		let index = -1;
		const length = string.length;
		result = '';
		while (++index < length) {
			const character = string.charAt(index);
			if (options.es6) {
				const first = string.charCodeAt(index);
				if ( // check if it’s the start of a surrogate pair
					first >= 0xD800 && first <= 0xDBFF && // high surrogate
					length > index + 1 // there is a next code unit
				) {
					const second = string.charCodeAt(index + 1);
					if (second >= 0xDC00 && second <= 0xDFFF) { // low surrogate
						// https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
						const codePoint = (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
						let hexadecimal = codePoint.toString(16);
						if (!lowercaseHex) {
							hexadecimal = hexadecimal.toUpperCase();
						}
						result += '\\u{' + hexadecimal + '}';
						++index;
						continue;
					}
				}
			}
			if (!options.escapeEverything) {
				if (regexWhitelist.test(character)) {
					// It’s a printable ASCII character that is not `"`, `'` or `\`,
					// so don’t escape it.
					result += character;
					continue;
				}
				if (character == '"') {
					result += quote == character ? '\\"' : character;
					continue;
				}
				if (character == '`') {
					result += quote == character ? '\\`' : character;
					continue;
				}
				if (character == '\'') {
					result += quote == character ? '\\\'' : character;
					continue;
				}
			}
			if (
				character == '\0' &&
				!json &&
				!regexDigit.test(string.charAt(index + 1))
			) {
				result += '\\0';
				continue;
			}
			if (regexSingleEscape.test(character)) {
				// no need for a `hasOwnProperty` check here
				result += singleEscapes[character];
				continue;
			}
			const charCode = character.charCodeAt(0);
			if (options.minimal && charCode != 0x2028 && charCode != 0x2029) {
				result += character;
				continue;
			}
			let hexadecimal = charCode.toString(16);
			if (!lowercaseHex) {
				hexadecimal = hexadecimal.toUpperCase();
			}
			const longhand = hexadecimal.length > 2 || json;
			const escaped = '\\' + (longhand ? 'u' : 'x') +
				('0000' + hexadecimal).slice(longhand ? -4 : -2);
			result += escaped;
			continue;
		}
		if (options.wrap) {
			result = quote + result + quote;
		}
		if (quote == '`') {
			result = result.replace(/\$\{/g, '\\\$\{');
		}
		if (options.isScriptContext) {
			// https://mathiasbynens.be/notes/etago
			return result
				.replace(/<\/(script|style)/gi, '<\\/$1')
				.replace(/<!--/g, json ? '\\u003C!--' : '\\x3C!--');
		}
		return result;
	};

	jsesc.version = '2.5.2';

	var jsesc_1 = jsesc;

	var types = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.Identifier = Identifier;
	exports.ArgumentPlaceholder = ArgumentPlaceholder;
	exports.SpreadElement = exports.RestElement = RestElement;
	exports.ObjectPattern = exports.ObjectExpression = ObjectExpression;
	exports.ObjectMethod = ObjectMethod;
	exports.ObjectProperty = ObjectProperty;
	exports.ArrayPattern = exports.ArrayExpression = ArrayExpression;
	exports.RecordExpression = RecordExpression;
	exports.TupleExpression = TupleExpression;
	exports.RegExpLiteral = RegExpLiteral;
	exports.BooleanLiteral = BooleanLiteral;
	exports.NullLiteral = NullLiteral;
	exports.NumericLiteral = NumericLiteral;
	exports.StringLiteral = StringLiteral;
	exports.BigIntLiteral = BigIntLiteral;
	exports.DecimalLiteral = DecimalLiteral;
	exports.PipelineTopicExpression = PipelineTopicExpression;
	exports.PipelineBareFunction = PipelineBareFunction;
	exports.PipelinePrimaryTopicReference = PipelinePrimaryTopicReference;

	var t = _interopRequireWildcard(lib$1);

	var _jsesc = _interopRequireDefault(jsesc_1);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function Identifier(node) {
	  this.exactSource(node.loc, () => {
	    this.word(node.name);
	  });
	}

	function ArgumentPlaceholder() {
	  this.token("?");
	}

	function RestElement(node) {
	  this.token("...");
	  this.print(node.argument, node);
	}

	function ObjectExpression(node) {
	  const props = node.properties;
	  this.token("{");
	  this.printInnerComments(node);

	  if (props.length) {
	    this.space();
	    this.printList(props, node, {
	      indent: true,
	      statement: true
	    });
	    this.space();
	  }

	  this.token("}");
	}

	function ObjectMethod(node) {
	  this.printJoin(node.decorators, node);

	  this._methodHead(node);

	  this.space();
	  this.print(node.body, node);
	}

	function ObjectProperty(node) {
	  this.printJoin(node.decorators, node);

	  if (node.computed) {
	    this.token("[");
	    this.print(node.key, node);
	    this.token("]");
	  } else {
	    if (t.isAssignmentPattern(node.value) && t.isIdentifier(node.key) && node.key.name === node.value.left.name) {
	      this.print(node.value, node);
	      return;
	    }

	    this.print(node.key, node);

	    if (node.shorthand && t.isIdentifier(node.key) && t.isIdentifier(node.value) && node.key.name === node.value.name) {
	      return;
	    }
	  }

	  this.token(":");
	  this.space();
	  this.print(node.value, node);
	}

	function ArrayExpression(node) {
	  const elems = node.elements;
	  const len = elems.length;
	  this.token("[");
	  this.printInnerComments(node);

	  for (let i = 0; i < elems.length; i++) {
	    const elem = elems[i];

	    if (elem) {
	      if (i > 0) this.space();
	      this.print(elem, node);
	      if (i < len - 1) this.token(",");
	    } else {
	      this.token(",");
	    }
	  }

	  this.token("]");
	}

	function RecordExpression(node) {
	  const props = node.properties;
	  let startToken;
	  let endToken;

	  if (this.format.recordAndTupleSyntaxType === "bar") {
	    startToken = "{|";
	    endToken = "|}";
	  } else if (this.format.recordAndTupleSyntaxType === "hash") {
	    startToken = "#{";
	    endToken = "}";
	  } else {
	    throw new Error(`The "recordAndTupleSyntaxType" generator option must be "bar" or "hash" (${JSON.stringify(this.format.recordAndTupleSyntaxType)} received).`);
	  }

	  this.token(startToken);
	  this.printInnerComments(node);

	  if (props.length) {
	    this.space();
	    this.printList(props, node, {
	      indent: true,
	      statement: true
	    });
	    this.space();
	  }

	  this.token(endToken);
	}

	function TupleExpression(node) {
	  const elems = node.elements;
	  const len = elems.length;
	  let startToken;
	  let endToken;

	  if (this.format.recordAndTupleSyntaxType === "bar") {
	    startToken = "[|";
	    endToken = "|]";
	  } else if (this.format.recordAndTupleSyntaxType === "hash") {
	    startToken = "#[";
	    endToken = "]";
	  } else {
	    throw new Error(`${this.format.recordAndTupleSyntaxType} is not a valid recordAndTuple syntax type`);
	  }

	  this.token(startToken);
	  this.printInnerComments(node);

	  for (let i = 0; i < elems.length; i++) {
	    const elem = elems[i];

	    if (elem) {
	      if (i > 0) this.space();
	      this.print(elem, node);
	      if (i < len - 1) this.token(",");
	    }
	  }

	  this.token(endToken);
	}

	function RegExpLiteral(node) {
	  this.word(`/${node.pattern}/${node.flags}`);
	}

	function BooleanLiteral(node) {
	  this.word(node.value ? "true" : "false");
	}

	function NullLiteral() {
	  this.word("null");
	}

	function NumericLiteral(node) {
	  const raw = this.getPossibleRaw(node);
	  const opts = this.format.jsescOption;
	  const value = node.value + "";

	  if (opts.numbers) {
	    this.number((0, _jsesc.default)(node.value, opts));
	  } else if (raw == null) {
	    this.number(value);
	  } else if (this.format.minified) {
	    this.number(raw.length < value.length ? raw : value);
	  } else {
	    this.number(raw);
	  }
	}

	function StringLiteral(node) {
	  const raw = this.getPossibleRaw(node);

	  if (!this.format.minified && raw != null) {
	    this.token(raw);
	    return;
	  }

	  const opts = this.format.jsescOption;

	  if (this.format.jsonCompatibleStrings) {
	    opts.json = true;
	  }

	  const val = (0, _jsesc.default)(node.value, opts);
	  return this.token(val);
	}

	function BigIntLiteral(node) {
	  const raw = this.getPossibleRaw(node);

	  if (!this.format.minified && raw != null) {
	    this.token(raw);
	    return;
	  }

	  this.token(node.value + "n");
	}

	function DecimalLiteral(node) {
	  const raw = this.getPossibleRaw(node);

	  if (!this.format.minified && raw != null) {
	    this.token(raw);
	    return;
	  }

	  this.token(node.value + "m");
	}

	function PipelineTopicExpression(node) {
	  this.print(node.expression, node);
	}

	function PipelineBareFunction(node) {
	  this.print(node.callee, node);
	}

	function PipelinePrimaryTopicReference() {
	  this.token("#");
	}
	});

	unwrapExports(types);
	var types_1 = types.Identifier;
	var types_2 = types.ArgumentPlaceholder;
	var types_3 = types.SpreadElement;
	var types_4 = types.RestElement;
	var types_5 = types.ObjectPattern;
	var types_6 = types.ObjectExpression;
	var types_7 = types.ObjectMethod;
	var types_8 = types.ObjectProperty;
	var types_9 = types.ArrayPattern;
	var types_10 = types.ArrayExpression;
	var types_11 = types.RecordExpression;
	var types_12 = types.TupleExpression;
	var types_13 = types.RegExpLiteral;
	var types_14 = types.BooleanLiteral;
	var types_15 = types.NullLiteral;
	var types_16 = types.NumericLiteral;
	var types_17 = types.StringLiteral;
	var types_18 = types.BigIntLiteral;
	var types_19 = types.DecimalLiteral;
	var types_20 = types.PipelineTopicExpression;
	var types_21 = types.PipelineBareFunction;
	var types_22 = types.PipelinePrimaryTopicReference;

	var flow$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.AnyTypeAnnotation = AnyTypeAnnotation;
	exports.ArrayTypeAnnotation = ArrayTypeAnnotation;
	exports.BooleanTypeAnnotation = BooleanTypeAnnotation;
	exports.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
	exports.NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
	exports.DeclareClass = DeclareClass;
	exports.DeclareFunction = DeclareFunction;
	exports.InferredPredicate = InferredPredicate;
	exports.DeclaredPredicate = DeclaredPredicate;
	exports.DeclareInterface = DeclareInterface;
	exports.DeclareModule = DeclareModule;
	exports.DeclareModuleExports = DeclareModuleExports;
	exports.DeclareTypeAlias = DeclareTypeAlias;
	exports.DeclareOpaqueType = DeclareOpaqueType;
	exports.DeclareVariable = DeclareVariable;
	exports.DeclareExportDeclaration = DeclareExportDeclaration;
	exports.DeclareExportAllDeclaration = DeclareExportAllDeclaration;
	exports.EnumDeclaration = EnumDeclaration;
	exports.EnumBooleanBody = EnumBooleanBody;
	exports.EnumNumberBody = EnumNumberBody;
	exports.EnumStringBody = EnumStringBody;
	exports.EnumSymbolBody = EnumSymbolBody;
	exports.EnumDefaultedMember = EnumDefaultedMember;
	exports.EnumBooleanMember = EnumBooleanMember;
	exports.EnumNumberMember = EnumNumberMember;
	exports.EnumStringMember = EnumStringMember;
	exports.ExistsTypeAnnotation = ExistsTypeAnnotation;
	exports.FunctionTypeAnnotation = FunctionTypeAnnotation;
	exports.FunctionTypeParam = FunctionTypeParam;
	exports.GenericTypeAnnotation = exports.ClassImplements = exports.InterfaceExtends = InterfaceExtends;
	exports._interfaceish = _interfaceish;
	exports._variance = _variance;
	exports.InterfaceDeclaration = InterfaceDeclaration;
	exports.InterfaceTypeAnnotation = InterfaceTypeAnnotation;
	exports.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
	exports.MixedTypeAnnotation = MixedTypeAnnotation;
	exports.EmptyTypeAnnotation = EmptyTypeAnnotation;
	exports.NullableTypeAnnotation = NullableTypeAnnotation;
	exports.NumberTypeAnnotation = NumberTypeAnnotation;
	exports.StringTypeAnnotation = StringTypeAnnotation;
	exports.ThisTypeAnnotation = ThisTypeAnnotation;
	exports.TupleTypeAnnotation = TupleTypeAnnotation;
	exports.TypeofTypeAnnotation = TypeofTypeAnnotation;
	exports.TypeAlias = TypeAlias;
	exports.TypeAnnotation = TypeAnnotation;
	exports.TypeParameterDeclaration = exports.TypeParameterInstantiation = TypeParameterInstantiation;
	exports.TypeParameter = TypeParameter;
	exports.OpaqueType = OpaqueType;
	exports.ObjectTypeAnnotation = ObjectTypeAnnotation;
	exports.ObjectTypeInternalSlot = ObjectTypeInternalSlot;
	exports.ObjectTypeCallProperty = ObjectTypeCallProperty;
	exports.ObjectTypeIndexer = ObjectTypeIndexer;
	exports.ObjectTypeProperty = ObjectTypeProperty;
	exports.ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
	exports.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
	exports.SymbolTypeAnnotation = SymbolTypeAnnotation;
	exports.UnionTypeAnnotation = UnionTypeAnnotation;
	exports.TypeCastExpression = TypeCastExpression;
	exports.Variance = Variance;
	exports.VoidTypeAnnotation = VoidTypeAnnotation;
	Object.defineProperty(exports, "NumberLiteralTypeAnnotation", {
	  enumerable: true,
	  get: function () {
	    return types.NumericLiteral;
	  }
	});
	Object.defineProperty(exports, "StringLiteralTypeAnnotation", {
	  enumerable: true,
	  get: function () {
	    return types.StringLiteral;
	  }
	});

	var t = _interopRequireWildcard(lib$1);





	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function AnyTypeAnnotation() {
	  this.word("any");
	}

	function ArrayTypeAnnotation(node) {
	  this.print(node.elementType, node);
	  this.token("[");
	  this.token("]");
	}

	function BooleanTypeAnnotation() {
	  this.word("boolean");
	}

	function BooleanLiteralTypeAnnotation(node) {
	  this.word(node.value ? "true" : "false");
	}

	function NullLiteralTypeAnnotation() {
	  this.word("null");
	}

	function DeclareClass(node, parent) {
	  if (!t.isDeclareExportDeclaration(parent)) {
	    this.word("declare");
	    this.space();
	  }

	  this.word("class");
	  this.space();

	  this._interfaceish(node);
	}

	function DeclareFunction(node, parent) {
	  if (!t.isDeclareExportDeclaration(parent)) {
	    this.word("declare");
	    this.space();
	  }

	  this.word("function");
	  this.space();
	  this.print(node.id, node);
	  this.print(node.id.typeAnnotation.typeAnnotation, node);

	  if (node.predicate) {
	    this.space();
	    this.print(node.predicate, node);
	  }

	  this.semicolon();
	}

	function InferredPredicate() {
	  this.token("%");
	  this.word("checks");
	}

	function DeclaredPredicate(node) {
	  this.token("%");
	  this.word("checks");
	  this.token("(");
	  this.print(node.value, node);
	  this.token(")");
	}

	function DeclareInterface(node) {
	  this.word("declare");
	  this.space();
	  this.InterfaceDeclaration(node);
	}

	function DeclareModule(node) {
	  this.word("declare");
	  this.space();
	  this.word("module");
	  this.space();
	  this.print(node.id, node);
	  this.space();
	  this.print(node.body, node);
	}

	function DeclareModuleExports(node) {
	  this.word("declare");
	  this.space();
	  this.word("module");
	  this.token(".");
	  this.word("exports");
	  this.print(node.typeAnnotation, node);
	}

	function DeclareTypeAlias(node) {
	  this.word("declare");
	  this.space();
	  this.TypeAlias(node);
	}

	function DeclareOpaqueType(node, parent) {
	  if (!t.isDeclareExportDeclaration(parent)) {
	    this.word("declare");
	    this.space();
	  }

	  this.OpaqueType(node);
	}

	function DeclareVariable(node, parent) {
	  if (!t.isDeclareExportDeclaration(parent)) {
	    this.word("declare");
	    this.space();
	  }

	  this.word("var");
	  this.space();
	  this.print(node.id, node);
	  this.print(node.id.typeAnnotation, node);
	  this.semicolon();
	}

	function DeclareExportDeclaration(node) {
	  this.word("declare");
	  this.space();
	  this.word("export");
	  this.space();

	  if (node.default) {
	    this.word("default");
	    this.space();
	  }

	  FlowExportDeclaration.apply(this, arguments);
	}

	function DeclareExportAllDeclaration() {
	  this.word("declare");
	  this.space();

	  modules.ExportAllDeclaration.apply(this, arguments);
	}

	function EnumDeclaration(node) {
	  const {
	    id,
	    body
	  } = node;
	  this.word("enum");
	  this.space();
	  this.print(id, node);
	  this.print(body, node);
	}

	function enumExplicitType(context, name, hasExplicitType) {
	  if (hasExplicitType) {
	    context.space();
	    context.word("of");
	    context.space();
	    context.word(name);
	  }

	  context.space();
	}

	function enumBody(context, node) {
	  const {
	    members
	  } = node;
	  context.token("{");
	  context.indent();
	  context.newline();

	  for (const member of members) {
	    context.print(member, node);
	    context.newline();
	  }

	  context.dedent();
	  context.token("}");
	}

	function EnumBooleanBody(node) {
	  const {
	    explicitType
	  } = node;
	  enumExplicitType(this, "boolean", explicitType);
	  enumBody(this, node);
	}

	function EnumNumberBody(node) {
	  const {
	    explicitType
	  } = node;
	  enumExplicitType(this, "number", explicitType);
	  enumBody(this, node);
	}

	function EnumStringBody(node) {
	  const {
	    explicitType
	  } = node;
	  enumExplicitType(this, "string", explicitType);
	  enumBody(this, node);
	}

	function EnumSymbolBody(node) {
	  enumExplicitType(this, "symbol", true);
	  enumBody(this, node);
	}

	function EnumDefaultedMember(node) {
	  const {
	    id
	  } = node;
	  this.print(id, node);
	  this.token(",");
	}

	function enumInitializedMember(context, node) {
	  const {
	    id,
	    init
	  } = node;
	  context.print(id, node);
	  context.space();
	  context.token("=");
	  context.space();
	  context.print(init, node);
	  context.token(",");
	}

	function EnumBooleanMember(node) {
	  enumInitializedMember(this, node);
	}

	function EnumNumberMember(node) {
	  enumInitializedMember(this, node);
	}

	function EnumStringMember(node) {
	  enumInitializedMember(this, node);
	}

	function FlowExportDeclaration(node) {
	  if (node.declaration) {
	    const declar = node.declaration;
	    this.print(declar, node);
	    if (!t.isStatement(declar)) this.semicolon();
	  } else {
	    this.token("{");

	    if (node.specifiers.length) {
	      this.space();
	      this.printList(node.specifiers, node);
	      this.space();
	    }

	    this.token("}");

	    if (node.source) {
	      this.space();
	      this.word("from");
	      this.space();
	      this.print(node.source, node);
	    }

	    this.semicolon();
	  }
	}

	function ExistsTypeAnnotation() {
	  this.token("*");
	}

	function FunctionTypeAnnotation(node, parent) {
	  this.print(node.typeParameters, node);
	  this.token("(");
	  this.printList(node.params, node);

	  if (node.rest) {
	    if (node.params.length) {
	      this.token(",");
	      this.space();
	    }

	    this.token("...");
	    this.print(node.rest, node);
	  }

	  this.token(")");

	  if (parent.type === "ObjectTypeCallProperty" || parent.type === "DeclareFunction" || parent.type === "ObjectTypeProperty" && parent.method) {
	    this.token(":");
	  } else {
	    this.space();
	    this.token("=>");
	  }

	  this.space();
	  this.print(node.returnType, node);
	}

	function FunctionTypeParam(node) {
	  this.print(node.name, node);
	  if (node.optional) this.token("?");

	  if (node.name) {
	    this.token(":");
	    this.space();
	  }

	  this.print(node.typeAnnotation, node);
	}

	function InterfaceExtends(node) {
	  this.print(node.id, node);
	  this.print(node.typeParameters, node);
	}

	function _interfaceish(node) {
	  this.print(node.id, node);
	  this.print(node.typeParameters, node);

	  if (node.extends.length) {
	    this.space();
	    this.word("extends");
	    this.space();
	    this.printList(node.extends, node);
	  }

	  if (node.mixins && node.mixins.length) {
	    this.space();
	    this.word("mixins");
	    this.space();
	    this.printList(node.mixins, node);
	  }

	  if (node.implements && node.implements.length) {
	    this.space();
	    this.word("implements");
	    this.space();
	    this.printList(node.implements, node);
	  }

	  this.space();
	  this.print(node.body, node);
	}

	function _variance(node) {
	  if (node.variance) {
	    if (node.variance.kind === "plus") {
	      this.token("+");
	    } else if (node.variance.kind === "minus") {
	      this.token("-");
	    }
	  }
	}

	function InterfaceDeclaration(node) {
	  this.word("interface");
	  this.space();

	  this._interfaceish(node);
	}

	function andSeparator() {
	  this.space();
	  this.token("&");
	  this.space();
	}

	function InterfaceTypeAnnotation(node) {
	  this.word("interface");

	  if (node.extends && node.extends.length) {
	    this.space();
	    this.word("extends");
	    this.space();
	    this.printList(node.extends, node);
	  }

	  this.space();
	  this.print(node.body, node);
	}

	function IntersectionTypeAnnotation(node) {
	  this.printJoin(node.types, node, {
	    separator: andSeparator
	  });
	}

	function MixedTypeAnnotation() {
	  this.word("mixed");
	}

	function EmptyTypeAnnotation() {
	  this.word("empty");
	}

	function NullableTypeAnnotation(node) {
	  this.token("?");
	  this.print(node.typeAnnotation, node);
	}

	function NumberTypeAnnotation() {
	  this.word("number");
	}

	function StringTypeAnnotation() {
	  this.word("string");
	}

	function ThisTypeAnnotation() {
	  this.word("this");
	}

	function TupleTypeAnnotation(node) {
	  this.token("[");
	  this.printList(node.types, node);
	  this.token("]");
	}

	function TypeofTypeAnnotation(node) {
	  this.word("typeof");
	  this.space();
	  this.print(node.argument, node);
	}

	function TypeAlias(node) {
	  this.word("type");
	  this.space();
	  this.print(node.id, node);
	  this.print(node.typeParameters, node);
	  this.space();
	  this.token("=");
	  this.space();
	  this.print(node.right, node);
	  this.semicolon();
	}

	function TypeAnnotation(node) {
	  this.token(":");
	  this.space();
	  if (node.optional) this.token("?");
	  this.print(node.typeAnnotation, node);
	}

	function TypeParameterInstantiation(node) {
	  this.token("<");
	  this.printList(node.params, node, {});
	  this.token(">");
	}

	function TypeParameter(node) {
	  this._variance(node);

	  this.word(node.name);

	  if (node.bound) {
	    this.print(node.bound, node);
	  }

	  if (node.default) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(node.default, node);
	  }
	}

	function OpaqueType(node) {
	  this.word("opaque");
	  this.space();
	  this.word("type");
	  this.space();
	  this.print(node.id, node);
	  this.print(node.typeParameters, node);

	  if (node.supertype) {
	    this.token(":");
	    this.space();
	    this.print(node.supertype, node);
	  }

	  if (node.impltype) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(node.impltype, node);
	  }

	  this.semicolon();
	}

	function ObjectTypeAnnotation(node) {
	  if (node.exact) {
	    this.token("{|");
	  } else {
	    this.token("{");
	  }

	  const props = node.properties.concat(node.callProperties || [], node.indexers || [], node.internalSlots || []);

	  if (props.length) {
	    this.space();
	    this.printJoin(props, node, {
	      addNewlines(leading) {
	        if (leading && !props[0]) return 1;
	      },

	      indent: true,
	      statement: true,
	      iterator: () => {
	        if (props.length !== 1 || node.inexact) {
	          this.token(",");
	          this.space();
	        }
	      }
	    });
	    this.space();
	  }

	  if (node.inexact) {
	    this.indent();
	    this.token("...");

	    if (props.length) {
	      this.newline();
	    }

	    this.dedent();
	  }

	  if (node.exact) {
	    this.token("|}");
	  } else {
	    this.token("}");
	  }
	}

	function ObjectTypeInternalSlot(node) {
	  if (node.static) {
	    this.word("static");
	    this.space();
	  }

	  this.token("[");
	  this.token("[");
	  this.print(node.id, node);
	  this.token("]");
	  this.token("]");
	  if (node.optional) this.token("?");

	  if (!node.method) {
	    this.token(":");
	    this.space();
	  }

	  this.print(node.value, node);
	}

	function ObjectTypeCallProperty(node) {
	  if (node.static) {
	    this.word("static");
	    this.space();
	  }

	  this.print(node.value, node);
	}

	function ObjectTypeIndexer(node) {
	  if (node.static) {
	    this.word("static");
	    this.space();
	  }

	  this._variance(node);

	  this.token("[");

	  if (node.id) {
	    this.print(node.id, node);
	    this.token(":");
	    this.space();
	  }

	  this.print(node.key, node);
	  this.token("]");
	  this.token(":");
	  this.space();
	  this.print(node.value, node);
	}

	function ObjectTypeProperty(node) {
	  if (node.proto) {
	    this.word("proto");
	    this.space();
	  }

	  if (node.static) {
	    this.word("static");
	    this.space();
	  }

	  if (node.kind === "get" || node.kind === "set") {
	    this.word(node.kind);
	    this.space();
	  }

	  this._variance(node);

	  this.print(node.key, node);
	  if (node.optional) this.token("?");

	  if (!node.method) {
	    this.token(":");
	    this.space();
	  }

	  this.print(node.value, node);
	}

	function ObjectTypeSpreadProperty(node) {
	  this.token("...");
	  this.print(node.argument, node);
	}

	function QualifiedTypeIdentifier(node) {
	  this.print(node.qualification, node);
	  this.token(".");
	  this.print(node.id, node);
	}

	function SymbolTypeAnnotation() {
	  this.word("symbol");
	}

	function orSeparator() {
	  this.space();
	  this.token("|");
	  this.space();
	}

	function UnionTypeAnnotation(node) {
	  this.printJoin(node.types, node, {
	    separator: orSeparator
	  });
	}

	function TypeCastExpression(node) {
	  this.token("(");
	  this.print(node.expression, node);
	  this.print(node.typeAnnotation, node);
	  this.token(")");
	}

	function Variance(node) {
	  if (node.kind === "plus") {
	    this.token("+");
	  } else {
	    this.token("-");
	  }
	}

	function VoidTypeAnnotation() {
	  this.word("void");
	}
	});

	unwrapExports(flow$1);
	var flow_1 = flow$1.AnyTypeAnnotation;
	var flow_2 = flow$1.ArrayTypeAnnotation;
	var flow_3 = flow$1.BooleanTypeAnnotation;
	var flow_4 = flow$1.BooleanLiteralTypeAnnotation;
	var flow_5 = flow$1.NullLiteralTypeAnnotation;
	var flow_6 = flow$1.DeclareClass;
	var flow_7 = flow$1.DeclareFunction;
	var flow_8 = flow$1.InferredPredicate;
	var flow_9 = flow$1.DeclaredPredicate;
	var flow_10 = flow$1.DeclareInterface;
	var flow_11 = flow$1.DeclareModule;
	var flow_12 = flow$1.DeclareModuleExports;
	var flow_13 = flow$1.DeclareTypeAlias;
	var flow_14 = flow$1.DeclareOpaqueType;
	var flow_15 = flow$1.DeclareVariable;
	var flow_16 = flow$1.DeclareExportDeclaration;
	var flow_17 = flow$1.DeclareExportAllDeclaration;
	var flow_18 = flow$1.EnumDeclaration;
	var flow_19 = flow$1.EnumBooleanBody;
	var flow_20 = flow$1.EnumNumberBody;
	var flow_21 = flow$1.EnumStringBody;
	var flow_22 = flow$1.EnumSymbolBody;
	var flow_23 = flow$1.EnumDefaultedMember;
	var flow_24 = flow$1.EnumBooleanMember;
	var flow_25 = flow$1.EnumNumberMember;
	var flow_26 = flow$1.EnumStringMember;
	var flow_27 = flow$1.ExistsTypeAnnotation;
	var flow_28 = flow$1.FunctionTypeAnnotation;
	var flow_29 = flow$1.FunctionTypeParam;
	var flow_30 = flow$1.GenericTypeAnnotation;
	var flow_31 = flow$1.ClassImplements;
	var flow_32 = flow$1.InterfaceExtends;
	var flow_33 = flow$1._interfaceish;
	var flow_34 = flow$1._variance;
	var flow_35 = flow$1.InterfaceDeclaration;
	var flow_36 = flow$1.InterfaceTypeAnnotation;
	var flow_37 = flow$1.IntersectionTypeAnnotation;
	var flow_38 = flow$1.MixedTypeAnnotation;
	var flow_39 = flow$1.EmptyTypeAnnotation;
	var flow_40 = flow$1.NullableTypeAnnotation;
	var flow_41 = flow$1.NumberTypeAnnotation;
	var flow_42 = flow$1.StringTypeAnnotation;
	var flow_43 = flow$1.ThisTypeAnnotation;
	var flow_44 = flow$1.TupleTypeAnnotation;
	var flow_45 = flow$1.TypeofTypeAnnotation;
	var flow_46 = flow$1.TypeAlias;
	var flow_47 = flow$1.TypeAnnotation;
	var flow_48 = flow$1.TypeParameterDeclaration;
	var flow_49 = flow$1.TypeParameterInstantiation;
	var flow_50 = flow$1.TypeParameter;
	var flow_51 = flow$1.OpaqueType;
	var flow_52 = flow$1.ObjectTypeAnnotation;
	var flow_53 = flow$1.ObjectTypeInternalSlot;
	var flow_54 = flow$1.ObjectTypeCallProperty;
	var flow_55 = flow$1.ObjectTypeIndexer;
	var flow_56 = flow$1.ObjectTypeProperty;
	var flow_57 = flow$1.ObjectTypeSpreadProperty;
	var flow_58 = flow$1.QualifiedTypeIdentifier;
	var flow_59 = flow$1.SymbolTypeAnnotation;
	var flow_60 = flow$1.UnionTypeAnnotation;
	var flow_61 = flow$1.TypeCastExpression;
	var flow_62 = flow$1.Variance;
	var flow_63 = flow$1.VoidTypeAnnotation;

	var base = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.File = File;
	exports.Program = Program;
	exports.BlockStatement = BlockStatement;
	exports.Noop = Noop;
	exports.Directive = Directive;
	exports.DirectiveLiteral = DirectiveLiteral;
	exports.InterpreterDirective = InterpreterDirective;
	exports.Placeholder = Placeholder;

	function File(node) {
	  if (node.program) {
	    this.print(node.program.interpreter, node);
	  }

	  this.print(node.program, node);
	}

	function Program(node) {
	  this.printInnerComments(node, false);
	  this.printSequence(node.directives, node);
	  if (node.directives && node.directives.length) this.newline();
	  this.printSequence(node.body, node);
	}

	function BlockStatement(node) {
	  var _node$directives;

	  this.token("{");
	  this.printInnerComments(node);
	  const hasDirectives = (_node$directives = node.directives) == null ? void 0 : _node$directives.length;

	  if (node.body.length || hasDirectives) {
	    this.newline();
	    this.printSequence(node.directives, node, {
	      indent: true
	    });
	    if (hasDirectives) this.newline();
	    this.printSequence(node.body, node, {
	      indent: true
	    });
	    this.removeTrailingNewline();
	    this.source("end", node.loc);
	    if (!this.endsWith("\n")) this.newline();
	    this.rightBrace();
	  } else {
	    this.source("end", node.loc);
	    this.token("}");
	  }
	}

	function Noop() {}

	function Directive(node) {
	  this.print(node.value, node);
	  this.semicolon();
	}

	const unescapedSingleQuoteRE = /(?:^|[^\\])(?:\\\\)*'/;
	const unescapedDoubleQuoteRE = /(?:^|[^\\])(?:\\\\)*"/;

	function DirectiveLiteral(node) {
	  const raw = this.getPossibleRaw(node);

	  if (raw != null) {
	    this.token(raw);
	    return;
	  }

	  const {
	    value
	  } = node;

	  if (!unescapedDoubleQuoteRE.test(value)) {
	    this.token(`"${value}"`);
	  } else if (!unescapedSingleQuoteRE.test(value)) {
	    this.token(`'${value}'`);
	  } else {
	    throw new Error("Malformed AST: it is not possible to print a directive containing" + " both unescaped single and double quotes.");
	  }
	}

	function InterpreterDirective(node) {
	  this.token(`#!${node.value}\n`);
	}

	function Placeholder(node) {
	  this.token("%%");
	  this.print(node.name);
	  this.token("%%");

	  if (node.expectedNode === "Statement") {
	    this.semicolon();
	  }
	}
	});

	unwrapExports(base);
	var base_1 = base.File;
	var base_2 = base.Program;
	var base_3 = base.BlockStatement;
	var base_4 = base.Noop;
	var base_5 = base.Directive;
	var base_6 = base.DirectiveLiteral;
	var base_7 = base.InterpreterDirective;
	var base_8 = base.Placeholder;

	var jsx$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.JSXAttribute = JSXAttribute;
	exports.JSXIdentifier = JSXIdentifier;
	exports.JSXNamespacedName = JSXNamespacedName;
	exports.JSXMemberExpression = JSXMemberExpression;
	exports.JSXSpreadAttribute = JSXSpreadAttribute;
	exports.JSXExpressionContainer = JSXExpressionContainer;
	exports.JSXSpreadChild = JSXSpreadChild;
	exports.JSXText = JSXText;
	exports.JSXElement = JSXElement;
	exports.JSXOpeningElement = JSXOpeningElement;
	exports.JSXClosingElement = JSXClosingElement;
	exports.JSXEmptyExpression = JSXEmptyExpression;
	exports.JSXFragment = JSXFragment;
	exports.JSXOpeningFragment = JSXOpeningFragment;
	exports.JSXClosingFragment = JSXClosingFragment;

	function JSXAttribute(node) {
	  this.print(node.name, node);

	  if (node.value) {
	    this.token("=");
	    this.print(node.value, node);
	  }
	}

	function JSXIdentifier(node) {
	  this.word(node.name);
	}

	function JSXNamespacedName(node) {
	  this.print(node.namespace, node);
	  this.token(":");
	  this.print(node.name, node);
	}

	function JSXMemberExpression(node) {
	  this.print(node.object, node);
	  this.token(".");
	  this.print(node.property, node);
	}

	function JSXSpreadAttribute(node) {
	  this.token("{");
	  this.token("...");
	  this.print(node.argument, node);
	  this.token("}");
	}

	function JSXExpressionContainer(node) {
	  this.token("{");
	  this.print(node.expression, node);
	  this.token("}");
	}

	function JSXSpreadChild(node) {
	  this.token("{");
	  this.token("...");
	  this.print(node.expression, node);
	  this.token("}");
	}

	function JSXText(node) {
	  const raw = this.getPossibleRaw(node);

	  if (raw != null) {
	    this.token(raw);
	  } else {
	    this.token(node.value);
	  }
	}

	function JSXElement(node) {
	  const open = node.openingElement;
	  this.print(open, node);
	  if (open.selfClosing) return;
	  this.indent();

	  for (const child of node.children) {
	    this.print(child, node);
	  }

	  this.dedent();
	  this.print(node.closingElement, node);
	}

	function spaceSeparator() {
	  this.space();
	}

	function JSXOpeningElement(node) {
	  this.token("<");
	  this.print(node.name, node);
	  this.print(node.typeParameters, node);

	  if (node.attributes.length > 0) {
	    this.space();
	    this.printJoin(node.attributes, node, {
	      separator: spaceSeparator
	    });
	  }

	  if (node.selfClosing) {
	    this.space();
	    this.token("/>");
	  } else {
	    this.token(">");
	  }
	}

	function JSXClosingElement(node) {
	  this.token("</");
	  this.print(node.name, node);
	  this.token(">");
	}

	function JSXEmptyExpression(node) {
	  this.printInnerComments(node);
	}

	function JSXFragment(node) {
	  this.print(node.openingFragment, node);
	  this.indent();

	  for (const child of node.children) {
	    this.print(child, node);
	  }

	  this.dedent();
	  this.print(node.closingFragment, node);
	}

	function JSXOpeningFragment() {
	  this.token("<");
	  this.token(">");
	}

	function JSXClosingFragment() {
	  this.token("</");
	  this.token(">");
	}
	});

	unwrapExports(jsx$1);
	var jsx_1 = jsx$1.JSXAttribute;
	var jsx_2 = jsx$1.JSXIdentifier;
	var jsx_3 = jsx$1.JSXNamespacedName;
	var jsx_4 = jsx$1.JSXMemberExpression;
	var jsx_5 = jsx$1.JSXSpreadAttribute;
	var jsx_6 = jsx$1.JSXExpressionContainer;
	var jsx_7 = jsx$1.JSXSpreadChild;
	var jsx_8 = jsx$1.JSXText;
	var jsx_9 = jsx$1.JSXElement;
	var jsx_10 = jsx$1.JSXOpeningElement;
	var jsx_11 = jsx$1.JSXClosingElement;
	var jsx_12 = jsx$1.JSXEmptyExpression;
	var jsx_13 = jsx$1.JSXFragment;
	var jsx_14 = jsx$1.JSXOpeningFragment;
	var jsx_15 = jsx$1.JSXClosingFragment;

	var typescript$1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.TSTypeAnnotation = TSTypeAnnotation;
	exports.TSTypeParameterDeclaration = exports.TSTypeParameterInstantiation = TSTypeParameterInstantiation;
	exports.TSTypeParameter = TSTypeParameter;
	exports.TSParameterProperty = TSParameterProperty;
	exports.TSDeclareFunction = TSDeclareFunction;
	exports.TSDeclareMethod = TSDeclareMethod;
	exports.TSQualifiedName = TSQualifiedName;
	exports.TSCallSignatureDeclaration = TSCallSignatureDeclaration;
	exports.TSConstructSignatureDeclaration = TSConstructSignatureDeclaration;
	exports.TSPropertySignature = TSPropertySignature;
	exports.tsPrintPropertyOrMethodName = tsPrintPropertyOrMethodName;
	exports.TSMethodSignature = TSMethodSignature;
	exports.TSIndexSignature = TSIndexSignature;
	exports.TSAnyKeyword = TSAnyKeyword;
	exports.TSBigIntKeyword = TSBigIntKeyword;
	exports.TSUnknownKeyword = TSUnknownKeyword;
	exports.TSNumberKeyword = TSNumberKeyword;
	exports.TSObjectKeyword = TSObjectKeyword;
	exports.TSBooleanKeyword = TSBooleanKeyword;
	exports.TSStringKeyword = TSStringKeyword;
	exports.TSSymbolKeyword = TSSymbolKeyword;
	exports.TSVoidKeyword = TSVoidKeyword;
	exports.TSUndefinedKeyword = TSUndefinedKeyword;
	exports.TSNullKeyword = TSNullKeyword;
	exports.TSNeverKeyword = TSNeverKeyword;
	exports.TSIntrinsicKeyword = TSIntrinsicKeyword;
	exports.TSThisType = TSThisType;
	exports.TSFunctionType = TSFunctionType;
	exports.TSConstructorType = TSConstructorType;
	exports.tsPrintFunctionOrConstructorType = tsPrintFunctionOrConstructorType;
	exports.TSTypeReference = TSTypeReference;
	exports.TSTypePredicate = TSTypePredicate;
	exports.TSTypeQuery = TSTypeQuery;
	exports.TSTypeLiteral = TSTypeLiteral;
	exports.tsPrintTypeLiteralOrInterfaceBody = tsPrintTypeLiteralOrInterfaceBody;
	exports.tsPrintBraced = tsPrintBraced;
	exports.TSArrayType = TSArrayType;
	exports.TSTupleType = TSTupleType;
	exports.TSOptionalType = TSOptionalType;
	exports.TSRestType = TSRestType;
	exports.TSNamedTupleMember = TSNamedTupleMember;
	exports.TSUnionType = TSUnionType;
	exports.TSIntersectionType = TSIntersectionType;
	exports.tsPrintUnionOrIntersectionType = tsPrintUnionOrIntersectionType;
	exports.TSConditionalType = TSConditionalType;
	exports.TSInferType = TSInferType;
	exports.TSParenthesizedType = TSParenthesizedType;
	exports.TSTypeOperator = TSTypeOperator;
	exports.TSIndexedAccessType = TSIndexedAccessType;
	exports.TSMappedType = TSMappedType;
	exports.TSLiteralType = TSLiteralType;
	exports.TSExpressionWithTypeArguments = TSExpressionWithTypeArguments;
	exports.TSInterfaceDeclaration = TSInterfaceDeclaration;
	exports.TSInterfaceBody = TSInterfaceBody;
	exports.TSTypeAliasDeclaration = TSTypeAliasDeclaration;
	exports.TSAsExpression = TSAsExpression;
	exports.TSTypeAssertion = TSTypeAssertion;
	exports.TSEnumDeclaration = TSEnumDeclaration;
	exports.TSEnumMember = TSEnumMember;
	exports.TSModuleDeclaration = TSModuleDeclaration;
	exports.TSModuleBlock = TSModuleBlock;
	exports.TSImportType = TSImportType;
	exports.TSImportEqualsDeclaration = TSImportEqualsDeclaration;
	exports.TSExternalModuleReference = TSExternalModuleReference;
	exports.TSNonNullExpression = TSNonNullExpression;
	exports.TSExportAssignment = TSExportAssignment;
	exports.TSNamespaceExportDeclaration = TSNamespaceExportDeclaration;
	exports.tsPrintSignatureDeclarationBase = tsPrintSignatureDeclarationBase;
	exports.tsPrintClassMemberModifiers = tsPrintClassMemberModifiers;

	function TSTypeAnnotation(node) {
	  this.token(":");
	  this.space();
	  if (node.optional) this.token("?");
	  this.print(node.typeAnnotation, node);
	}

	function TSTypeParameterInstantiation(node) {
	  this.token("<");
	  this.printList(node.params, node, {});
	  this.token(">");
	}

	function TSTypeParameter(node) {
	  this.word(node.name);

	  if (node.constraint) {
	    this.space();
	    this.word("extends");
	    this.space();
	    this.print(node.constraint, node);
	  }

	  if (node.default) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(node.default, node);
	  }
	}

	function TSParameterProperty(node) {
	  if (node.accessibility) {
	    this.word(node.accessibility);
	    this.space();
	  }

	  if (node.readonly) {
	    this.word("readonly");
	    this.space();
	  }

	  this._param(node.parameter);
	}

	function TSDeclareFunction(node) {
	  if (node.declare) {
	    this.word("declare");
	    this.space();
	  }

	  this._functionHead(node);

	  this.token(";");
	}

	function TSDeclareMethod(node) {
	  this._classMethodHead(node);

	  this.token(";");
	}

	function TSQualifiedName(node) {
	  this.print(node.left, node);
	  this.token(".");
	  this.print(node.right, node);
	}

	function TSCallSignatureDeclaration(node) {
	  this.tsPrintSignatureDeclarationBase(node);
	  this.token(";");
	}

	function TSConstructSignatureDeclaration(node) {
	  this.word("new");
	  this.space();
	  this.tsPrintSignatureDeclarationBase(node);
	  this.token(";");
	}

	function TSPropertySignature(node) {
	  const {
	    readonly,
	    initializer
	  } = node;

	  if (readonly) {
	    this.word("readonly");
	    this.space();
	  }

	  this.tsPrintPropertyOrMethodName(node);
	  this.print(node.typeAnnotation, node);

	  if (initializer) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(initializer, node);
	  }

	  this.token(";");
	}

	function tsPrintPropertyOrMethodName(node) {
	  if (node.computed) {
	    this.token("[");
	  }

	  this.print(node.key, node);

	  if (node.computed) {
	    this.token("]");
	  }

	  if (node.optional) {
	    this.token("?");
	  }
	}

	function TSMethodSignature(node) {
	  this.tsPrintPropertyOrMethodName(node);
	  this.tsPrintSignatureDeclarationBase(node);
	  this.token(";");
	}

	function TSIndexSignature(node) {
	  const {
	    readonly
	  } = node;

	  if (readonly) {
	    this.word("readonly");
	    this.space();
	  }

	  this.token("[");

	  this._parameters(node.parameters, node);

	  this.token("]");
	  this.print(node.typeAnnotation, node);
	  this.token(";");
	}

	function TSAnyKeyword() {
	  this.word("any");
	}

	function TSBigIntKeyword() {
	  this.word("bigint");
	}

	function TSUnknownKeyword() {
	  this.word("unknown");
	}

	function TSNumberKeyword() {
	  this.word("number");
	}

	function TSObjectKeyword() {
	  this.word("object");
	}

	function TSBooleanKeyword() {
	  this.word("boolean");
	}

	function TSStringKeyword() {
	  this.word("string");
	}

	function TSSymbolKeyword() {
	  this.word("symbol");
	}

	function TSVoidKeyword() {
	  this.word("void");
	}

	function TSUndefinedKeyword() {
	  this.word("undefined");
	}

	function TSNullKeyword() {
	  this.word("null");
	}

	function TSNeverKeyword() {
	  this.word("never");
	}

	function TSIntrinsicKeyword() {
	  this.word("intrinsic");
	}

	function TSThisType() {
	  this.word("this");
	}

	function TSFunctionType(node) {
	  this.tsPrintFunctionOrConstructorType(node);
	}

	function TSConstructorType(node) {
	  this.word("new");
	  this.space();
	  this.tsPrintFunctionOrConstructorType(node);
	}

	function tsPrintFunctionOrConstructorType(node) {
	  const {
	    typeParameters,
	    parameters
	  } = node;
	  this.print(typeParameters, node);
	  this.token("(");

	  this._parameters(parameters, node);

	  this.token(")");
	  this.space();
	  this.token("=>");
	  this.space();
	  this.print(node.typeAnnotation.typeAnnotation, node);
	}

	function TSTypeReference(node) {
	  this.print(node.typeName, node);
	  this.print(node.typeParameters, node);
	}

	function TSTypePredicate(node) {
	  if (node.asserts) {
	    this.word("asserts");
	    this.space();
	  }

	  this.print(node.parameterName);

	  if (node.typeAnnotation) {
	    this.space();
	    this.word("is");
	    this.space();
	    this.print(node.typeAnnotation.typeAnnotation);
	  }
	}

	function TSTypeQuery(node) {
	  this.word("typeof");
	  this.space();
	  this.print(node.exprName);
	}

	function TSTypeLiteral(node) {
	  this.tsPrintTypeLiteralOrInterfaceBody(node.members, node);
	}

	function tsPrintTypeLiteralOrInterfaceBody(members, node) {
	  this.tsPrintBraced(members, node);
	}

	function tsPrintBraced(members, node) {
	  this.token("{");

	  if (members.length) {
	    this.indent();
	    this.newline();

	    for (const member of members) {
	      this.print(member, node);
	      this.newline();
	    }

	    this.dedent();
	    this.rightBrace();
	  } else {
	    this.token("}");
	  }
	}

	function TSArrayType(node) {
	  this.print(node.elementType, node);
	  this.token("[]");
	}

	function TSTupleType(node) {
	  this.token("[");
	  this.printList(node.elementTypes, node);
	  this.token("]");
	}

	function TSOptionalType(node) {
	  this.print(node.typeAnnotation, node);
	  this.token("?");
	}

	function TSRestType(node) {
	  this.token("...");
	  this.print(node.typeAnnotation, node);
	}

	function TSNamedTupleMember(node) {
	  this.print(node.label, node);
	  if (node.optional) this.token("?");
	  this.token(":");
	  this.space();
	  this.print(node.elementType, node);
	}

	function TSUnionType(node) {
	  this.tsPrintUnionOrIntersectionType(node, "|");
	}

	function TSIntersectionType(node) {
	  this.tsPrintUnionOrIntersectionType(node, "&");
	}

	function tsPrintUnionOrIntersectionType(node, sep) {
	  this.printJoin(node.types, node, {
	    separator() {
	      this.space();
	      this.token(sep);
	      this.space();
	    }

	  });
	}

	function TSConditionalType(node) {
	  this.print(node.checkType);
	  this.space();
	  this.word("extends");
	  this.space();
	  this.print(node.extendsType);
	  this.space();
	  this.token("?");
	  this.space();
	  this.print(node.trueType);
	  this.space();
	  this.token(":");
	  this.space();
	  this.print(node.falseType);
	}

	function TSInferType(node) {
	  this.token("infer");
	  this.space();
	  this.print(node.typeParameter);
	}

	function TSParenthesizedType(node) {
	  this.token("(");
	  this.print(node.typeAnnotation, node);
	  this.token(")");
	}

	function TSTypeOperator(node) {
	  this.word(node.operator);
	  this.space();
	  this.print(node.typeAnnotation, node);
	}

	function TSIndexedAccessType(node) {
	  this.print(node.objectType, node);
	  this.token("[");
	  this.print(node.indexType, node);
	  this.token("]");
	}

	function TSMappedType(node) {
	  const {
	    nameType,
	    optional,
	    readonly,
	    typeParameter
	  } = node;
	  this.token("{");
	  this.space();

	  if (readonly) {
	    tokenIfPlusMinus(this, readonly);
	    this.word("readonly");
	    this.space();
	  }

	  this.token("[");
	  this.word(typeParameter.name);
	  this.space();
	  this.word("in");
	  this.space();
	  this.print(typeParameter.constraint, typeParameter);

	  if (nameType) {
	    this.space();
	    this.word("as");
	    this.space();
	    this.print(nameType, node);
	  }

	  this.token("]");

	  if (optional) {
	    tokenIfPlusMinus(this, optional);
	    this.token("?");
	  }

	  this.token(":");
	  this.space();
	  this.print(node.typeAnnotation, node);
	  this.space();
	  this.token("}");
	}

	function tokenIfPlusMinus(self, tok) {
	  if (tok !== true) {
	    self.token(tok);
	  }
	}

	function TSLiteralType(node) {
	  this.print(node.literal, node);
	}

	function TSExpressionWithTypeArguments(node) {
	  this.print(node.expression, node);
	  this.print(node.typeParameters, node);
	}

	function TSInterfaceDeclaration(node) {
	  const {
	    declare,
	    id,
	    typeParameters,
	    extends: extendz,
	    body
	  } = node;

	  if (declare) {
	    this.word("declare");
	    this.space();
	  }

	  this.word("interface");
	  this.space();
	  this.print(id, node);
	  this.print(typeParameters, node);

	  if (extendz) {
	    this.space();
	    this.word("extends");
	    this.space();
	    this.printList(extendz, node);
	  }

	  this.space();
	  this.print(body, node);
	}

	function TSInterfaceBody(node) {
	  this.tsPrintTypeLiteralOrInterfaceBody(node.body, node);
	}

	function TSTypeAliasDeclaration(node) {
	  const {
	    declare,
	    id,
	    typeParameters,
	    typeAnnotation
	  } = node;

	  if (declare) {
	    this.word("declare");
	    this.space();
	  }

	  this.word("type");
	  this.space();
	  this.print(id, node);
	  this.print(typeParameters, node);
	  this.space();
	  this.token("=");
	  this.space();
	  this.print(typeAnnotation, node);
	  this.token(";");
	}

	function TSAsExpression(node) {
	  const {
	    expression,
	    typeAnnotation
	  } = node;
	  this.print(expression, node);
	  this.space();
	  this.word("as");
	  this.space();
	  this.print(typeAnnotation, node);
	}

	function TSTypeAssertion(node) {
	  const {
	    typeAnnotation,
	    expression
	  } = node;
	  this.token("<");
	  this.print(typeAnnotation, node);
	  this.token(">");
	  this.space();
	  this.print(expression, node);
	}

	function TSEnumDeclaration(node) {
	  const {
	    declare,
	    const: isConst,
	    id,
	    members
	  } = node;

	  if (declare) {
	    this.word("declare");
	    this.space();
	  }

	  if (isConst) {
	    this.word("const");
	    this.space();
	  }

	  this.word("enum");
	  this.space();
	  this.print(id, node);
	  this.space();
	  this.tsPrintBraced(members, node);
	}

	function TSEnumMember(node) {
	  const {
	    id,
	    initializer
	  } = node;
	  this.print(id, node);

	  if (initializer) {
	    this.space();
	    this.token("=");
	    this.space();
	    this.print(initializer, node);
	  }

	  this.token(",");
	}

	function TSModuleDeclaration(node) {
	  const {
	    declare,
	    id
	  } = node;

	  if (declare) {
	    this.word("declare");
	    this.space();
	  }

	  if (!node.global) {
	    this.word(id.type === "Identifier" ? "namespace" : "module");
	    this.space();
	  }

	  this.print(id, node);

	  if (!node.body) {
	    this.token(";");
	    return;
	  }

	  let body = node.body;

	  while (body.type === "TSModuleDeclaration") {
	    this.token(".");
	    this.print(body.id, body);
	    body = body.body;
	  }

	  this.space();
	  this.print(body, node);
	}

	function TSModuleBlock(node) {
	  this.tsPrintBraced(node.body, node);
	}

	function TSImportType(node) {
	  const {
	    argument,
	    qualifier,
	    typeParameters
	  } = node;
	  this.word("import");
	  this.token("(");
	  this.print(argument, node);
	  this.token(")");

	  if (qualifier) {
	    this.token(".");
	    this.print(qualifier, node);
	  }

	  if (typeParameters) {
	    this.print(typeParameters, node);
	  }
	}

	function TSImportEqualsDeclaration(node) {
	  const {
	    isExport,
	    id,
	    moduleReference
	  } = node;

	  if (isExport) {
	    this.word("export");
	    this.space();
	  }

	  this.word("import");
	  this.space();
	  this.print(id, node);
	  this.space();
	  this.token("=");
	  this.space();
	  this.print(moduleReference, node);
	  this.token(";");
	}

	function TSExternalModuleReference(node) {
	  this.token("require(");
	  this.print(node.expression, node);
	  this.token(")");
	}

	function TSNonNullExpression(node) {
	  this.print(node.expression, node);
	  this.token("!");
	}

	function TSExportAssignment(node) {
	  this.word("export");
	  this.space();
	  this.token("=");
	  this.space();
	  this.print(node.expression, node);
	  this.token(";");
	}

	function TSNamespaceExportDeclaration(node) {
	  this.word("export");
	  this.space();
	  this.word("as");
	  this.space();
	  this.word("namespace");
	  this.space();
	  this.print(node.id, node);
	}

	function tsPrintSignatureDeclarationBase(node) {
	  const {
	    typeParameters,
	    parameters
	  } = node;
	  this.print(typeParameters, node);
	  this.token("(");

	  this._parameters(parameters, node);

	  this.token(")");
	  this.print(node.typeAnnotation, node);
	}

	function tsPrintClassMemberModifiers(node, isField) {
	  if (isField && node.declare) {
	    this.word("declare");
	    this.space();
	  }

	  if (node.accessibility) {
	    this.word(node.accessibility);
	    this.space();
	  }

	  if (node.static) {
	    this.word("static");
	    this.space();
	  }

	  if (node.abstract) {
	    this.word("abstract");
	    this.space();
	  }

	  if (isField && node.readonly) {
	    this.word("readonly");
	    this.space();
	  }
	}
	});

	unwrapExports(typescript$1);
	var typescript_1 = typescript$1.TSTypeAnnotation;
	var typescript_2 = typescript$1.TSTypeParameterDeclaration;
	var typescript_3 = typescript$1.TSTypeParameterInstantiation;
	var typescript_4 = typescript$1.TSTypeParameter;
	var typescript_5 = typescript$1.TSParameterProperty;
	var typescript_6 = typescript$1.TSDeclareFunction;
	var typescript_7 = typescript$1.TSDeclareMethod;
	var typescript_8 = typescript$1.TSQualifiedName;
	var typescript_9 = typescript$1.TSCallSignatureDeclaration;
	var typescript_10 = typescript$1.TSConstructSignatureDeclaration;
	var typescript_11 = typescript$1.TSPropertySignature;
	var typescript_12 = typescript$1.tsPrintPropertyOrMethodName;
	var typescript_13 = typescript$1.TSMethodSignature;
	var typescript_14 = typescript$1.TSIndexSignature;
	var typescript_15 = typescript$1.TSAnyKeyword;
	var typescript_16 = typescript$1.TSBigIntKeyword;
	var typescript_17 = typescript$1.TSUnknownKeyword;
	var typescript_18 = typescript$1.TSNumberKeyword;
	var typescript_19 = typescript$1.TSObjectKeyword;
	var typescript_20 = typescript$1.TSBooleanKeyword;
	var typescript_21 = typescript$1.TSStringKeyword;
	var typescript_22 = typescript$1.TSSymbolKeyword;
	var typescript_23 = typescript$1.TSVoidKeyword;
	var typescript_24 = typescript$1.TSUndefinedKeyword;
	var typescript_25 = typescript$1.TSNullKeyword;
	var typescript_26 = typescript$1.TSNeverKeyword;
	var typescript_27 = typescript$1.TSIntrinsicKeyword;
	var typescript_28 = typescript$1.TSThisType;
	var typescript_29 = typescript$1.TSFunctionType;
	var typescript_30 = typescript$1.TSConstructorType;
	var typescript_31 = typescript$1.tsPrintFunctionOrConstructorType;
	var typescript_32 = typescript$1.TSTypeReference;
	var typescript_33 = typescript$1.TSTypePredicate;
	var typescript_34 = typescript$1.TSTypeQuery;
	var typescript_35 = typescript$1.TSTypeLiteral;
	var typescript_36 = typescript$1.tsPrintTypeLiteralOrInterfaceBody;
	var typescript_37 = typescript$1.tsPrintBraced;
	var typescript_38 = typescript$1.TSArrayType;
	var typescript_39 = typescript$1.TSTupleType;
	var typescript_40 = typescript$1.TSOptionalType;
	var typescript_41 = typescript$1.TSRestType;
	var typescript_42 = typescript$1.TSNamedTupleMember;
	var typescript_43 = typescript$1.TSUnionType;
	var typescript_44 = typescript$1.TSIntersectionType;
	var typescript_45 = typescript$1.tsPrintUnionOrIntersectionType;
	var typescript_46 = typescript$1.TSConditionalType;
	var typescript_47 = typescript$1.TSInferType;
	var typescript_48 = typescript$1.TSParenthesizedType;
	var typescript_49 = typescript$1.TSTypeOperator;
	var typescript_50 = typescript$1.TSIndexedAccessType;
	var typescript_51 = typescript$1.TSMappedType;
	var typescript_52 = typescript$1.TSLiteralType;
	var typescript_53 = typescript$1.TSExpressionWithTypeArguments;
	var typescript_54 = typescript$1.TSInterfaceDeclaration;
	var typescript_55 = typescript$1.TSInterfaceBody;
	var typescript_56 = typescript$1.TSTypeAliasDeclaration;
	var typescript_57 = typescript$1.TSAsExpression;
	var typescript_58 = typescript$1.TSTypeAssertion;
	var typescript_59 = typescript$1.TSEnumDeclaration;
	var typescript_60 = typescript$1.TSEnumMember;
	var typescript_61 = typescript$1.TSModuleDeclaration;
	var typescript_62 = typescript$1.TSModuleBlock;
	var typescript_63 = typescript$1.TSImportType;
	var typescript_64 = typescript$1.TSImportEqualsDeclaration;
	var typescript_65 = typescript$1.TSExternalModuleReference;
	var typescript_66 = typescript$1.TSNonNullExpression;
	var typescript_67 = typescript$1.TSExportAssignment;
	var typescript_68 = typescript$1.TSNamespaceExportDeclaration;
	var typescript_69 = typescript$1.tsPrintSignatureDeclarationBase;
	var typescript_70 = typescript$1.tsPrintClassMemberModifiers;

	var generators = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});



	Object.keys(templateLiterals).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === templateLiterals[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return templateLiterals[key];
	    }
	  });
	});



	Object.keys(expressions).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === expressions[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return expressions[key];
	    }
	  });
	});



	Object.keys(statements).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === statements[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return statements[key];
	    }
	  });
	});



	Object.keys(classes).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === classes[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return classes[key];
	    }
	  });
	});



	Object.keys(methods).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === methods[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return methods[key];
	    }
	  });
	});



	Object.keys(modules).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === modules[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return modules[key];
	    }
	  });
	});



	Object.keys(types).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === types[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return types[key];
	    }
	  });
	});



	Object.keys(flow$1).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === flow$1[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return flow$1[key];
	    }
	  });
	});



	Object.keys(base).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === base[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return base[key];
	    }
	  });
	});



	Object.keys(jsx$1).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === jsx$1[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return jsx$1[key];
	    }
	  });
	});



	Object.keys(typescript$1).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === typescript$1[key]) return;
	  Object.defineProperty(exports, key, {
	    enumerable: true,
	    get: function () {
	      return typescript$1[key];
	    }
	  });
	});
	});

	unwrapExports(generators);

	var printer = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = void 0;

	var _buffer = _interopRequireDefault(buffer);

	var n = _interopRequireWildcard(node$2);

	var t = _interopRequireWildcard(lib$1);

	var generatorFunctions = _interopRequireWildcard(generators);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	const SCIENTIFIC_NOTATION = /e/i;
	const ZERO_DECIMAL_INTEGER = /\.0+$/;
	const NON_DECIMAL_LITERAL = /^0[box]/;
	const PURE_ANNOTATION_RE = /^\s*[@#]__PURE__\s*$/;

	class Printer {
	  constructor(format, map) {
	    this.inForStatementInitCounter = 0;
	    this._printStack = [];
	    this._indent = 0;
	    this._insideAux = false;
	    this._printedCommentStarts = {};
	    this._parenPushNewlineState = null;
	    this._noLineTerminator = false;
	    this._printAuxAfterOnNextUserNode = false;
	    this._printedComments = new WeakSet();
	    this._endsWithInteger = false;
	    this._endsWithWord = false;
	    this.format = format || {};
	    this._buf = new _buffer.default(map);
	  }

	  generate(ast) {
	    this.print(ast);

	    this._maybeAddAuxComment();

	    return this._buf.get();
	  }

	  indent() {
	    if (this.format.compact || this.format.concise) return;
	    this._indent++;
	  }

	  dedent() {
	    if (this.format.compact || this.format.concise) return;
	    this._indent--;
	  }

	  semicolon(force = false) {
	    this._maybeAddAuxComment();

	    this._append(";", !force);
	  }

	  rightBrace() {
	    if (this.format.minified) {
	      this._buf.removeLastSemicolon();
	    }

	    this.token("}");
	  }

	  space(force = false) {
	    if (this.format.compact) return;

	    if (this._buf.hasContent() && !this.endsWith(" ") && !this.endsWith("\n") || force) {
	      this._space();
	    }
	  }

	  word(str) {
	    if (this._endsWithWord || this.endsWith("/") && str.indexOf("/") === 0) {
	      this._space();
	    }

	    this._maybeAddAuxComment();

	    this._append(str);

	    this._endsWithWord = true;
	  }

	  number(str) {
	    this.word(str);
	    this._endsWithInteger = Number.isInteger(+str) && !NON_DECIMAL_LITERAL.test(str) && !SCIENTIFIC_NOTATION.test(str) && !ZERO_DECIMAL_INTEGER.test(str) && str[str.length - 1] !== ".";
	  }

	  token(str) {
	    if (str === "--" && this.endsWith("!") || str[0] === "+" && this.endsWith("+") || str[0] === "-" && this.endsWith("-") || str[0] === "." && this._endsWithInteger) {
	      this._space();
	    }

	    this._maybeAddAuxComment();

	    this._append(str);
	  }

	  newline(i) {
	    if (this.format.retainLines || this.format.compact) return;

	    if (this.format.concise) {
	      this.space();
	      return;
	    }

	    if (this.endsWith("\n\n")) return;
	    if (typeof i !== "number") i = 1;
	    i = Math.min(2, i);
	    if (this.endsWith("{\n") || this.endsWith(":\n")) i--;
	    if (i <= 0) return;

	    for (let j = 0; j < i; j++) {
	      this._newline();
	    }
	  }

	  endsWith(str) {
	    return this._buf.endsWith(str);
	  }

	  removeTrailingNewline() {
	    this._buf.removeTrailingNewline();
	  }

	  exactSource(loc, cb) {
	    this._catchUp("start", loc);

	    this._buf.exactSource(loc, cb);
	  }

	  source(prop, loc) {
	    this._catchUp(prop, loc);

	    this._buf.source(prop, loc);
	  }

	  withSource(prop, loc, cb) {
	    this._catchUp(prop, loc);

	    this._buf.withSource(prop, loc, cb);
	  }

	  _space() {
	    this._append(" ", true);
	  }

	  _newline() {
	    this._append("\n", true);
	  }

	  _append(str, queue = false) {
	    this._maybeAddParen(str);

	    this._maybeIndent(str);

	    if (queue) this._buf.queue(str);else this._buf.append(str);
	    this._endsWithWord = false;
	    this._endsWithInteger = false;
	  }

	  _maybeIndent(str) {
	    if (this._indent && this.endsWith("\n") && str[0] !== "\n") {
	      this._buf.queue(this._getIndent());
	    }
	  }

	  _maybeAddParen(str) {
	    const parenPushNewlineState = this._parenPushNewlineState;
	    if (!parenPushNewlineState) return;
	    let i;

	    for (i = 0; i < str.length && str[i] === " "; i++) continue;

	    if (i === str.length) {
	      return;
	    }

	    const cha = str[i];

	    if (cha !== "\n") {
	      if (cha !== "/" || i + 1 === str.length) {
	        this._parenPushNewlineState = null;
	        return;
	      }

	      const chaPost = str[i + 1];

	      if (chaPost === "*") {
	        if (PURE_ANNOTATION_RE.test(str.slice(i + 2, str.length - 2))) {
	          return;
	        }
	      } else if (chaPost !== "/") {
	        this._parenPushNewlineState = null;
	        return;
	      }
	    }

	    this.token("(");
	    this.indent();
	    parenPushNewlineState.printed = true;
	  }

	  _catchUp(prop, loc) {
	    if (!this.format.retainLines) return;
	    const pos = loc ? loc[prop] : null;

	    if ((pos == null ? void 0 : pos.line) != null) {
	      const count = pos.line - this._buf.getCurrentLine();

	      for (let i = 0; i < count; i++) {
	        this._newline();
	      }
	    }
	  }

	  _getIndent() {
	    return this.format.indent.style.repeat(this._indent);
	  }

	  startTerminatorless(isLabel = false) {
	    if (isLabel) {
	      this._noLineTerminator = true;
	      return null;
	    } else {
	      return this._parenPushNewlineState = {
	        printed: false
	      };
	    }
	  }

	  endTerminatorless(state) {
	    this._noLineTerminator = false;

	    if (state == null ? void 0 : state.printed) {
	      this.dedent();
	      this.newline();
	      this.token(")");
	    }
	  }

	  print(node, parent) {
	    if (!node) return;
	    const oldConcise = this.format.concise;

	    if (node._compact) {
	      this.format.concise = true;
	    }

	    const printMethod = this[node.type];

	    if (!printMethod) {
	      throw new ReferenceError(`unknown node of type ${JSON.stringify(node.type)} with constructor ${JSON.stringify(node == null ? void 0 : node.constructor.name)}`);
	    }

	    this._printStack.push(node);

	    const oldInAux = this._insideAux;
	    this._insideAux = !node.loc;

	    this._maybeAddAuxComment(this._insideAux && !oldInAux);

	    let needsParens = n.needsParens(node, parent, this._printStack);

	    if (this.format.retainFunctionParens && node.type === "FunctionExpression" && node.extra && node.extra.parenthesized) {
	      needsParens = true;
	    }

	    if (needsParens) this.token("(");

	    this._printLeadingComments(node);

	    const loc = t.isProgram(node) || t.isFile(node) ? null : node.loc;
	    this.withSource("start", loc, () => {
	      printMethod.call(this, node, parent);
	    });

	    this._printTrailingComments(node);

	    if (needsParens) this.token(")");

	    this._printStack.pop();

	    this.format.concise = oldConcise;
	    this._insideAux = oldInAux;
	  }

	  _maybeAddAuxComment(enteredPositionlessNode) {
	    if (enteredPositionlessNode) this._printAuxBeforeComment();
	    if (!this._insideAux) this._printAuxAfterComment();
	  }

	  _printAuxBeforeComment() {
	    if (this._printAuxAfterOnNextUserNode) return;
	    this._printAuxAfterOnNextUserNode = true;
	    const comment = this.format.auxiliaryCommentBefore;

	    if (comment) {
	      this._printComment({
	        type: "CommentBlock",
	        value: comment
	      });
	    }
	  }

	  _printAuxAfterComment() {
	    if (!this._printAuxAfterOnNextUserNode) return;
	    this._printAuxAfterOnNextUserNode = false;
	    const comment = this.format.auxiliaryCommentAfter;

	    if (comment) {
	      this._printComment({
	        type: "CommentBlock",
	        value: comment
	      });
	    }
	  }

	  getPossibleRaw(node) {
	    const extra = node.extra;

	    if (extra && extra.raw != null && extra.rawValue != null && node.value === extra.rawValue) {
	      return extra.raw;
	    }
	  }

	  printJoin(nodes, parent, opts = {}) {
	    if (!(nodes == null ? void 0 : nodes.length)) return;
	    if (opts.indent) this.indent();
	    const newlineOpts = {
	      addNewlines: opts.addNewlines
	    };

	    for (let i = 0; i < nodes.length; i++) {
	      const node = nodes[i];
	      if (!node) continue;
	      if (opts.statement) this._printNewline(true, node, parent, newlineOpts);
	      this.print(node, parent);

	      if (opts.iterator) {
	        opts.iterator(node, i);
	      }

	      if (opts.separator && i < nodes.length - 1) {
	        opts.separator.call(this);
	      }

	      if (opts.statement) this._printNewline(false, node, parent, newlineOpts);
	    }

	    if (opts.indent) this.dedent();
	  }

	  printAndIndentOnComments(node, parent) {
	    const indent = node.leadingComments && node.leadingComments.length > 0;
	    if (indent) this.indent();
	    this.print(node, parent);
	    if (indent) this.dedent();
	  }

	  printBlock(parent) {
	    const node = parent.body;

	    if (!t.isEmptyStatement(node)) {
	      this.space();
	    }

	    this.print(node, parent);
	  }

	  _printTrailingComments(node) {
	    this._printComments(this._getComments(false, node));
	  }

	  _printLeadingComments(node) {
	    this._printComments(this._getComments(true, node), true);
	  }

	  printInnerComments(node, indent = true) {
	    var _node$innerComments;

	    if (!((_node$innerComments = node.innerComments) == null ? void 0 : _node$innerComments.length)) return;
	    if (indent) this.indent();

	    this._printComments(node.innerComments);

	    if (indent) this.dedent();
	  }

	  printSequence(nodes, parent, opts = {}) {
	    opts.statement = true;
	    return this.printJoin(nodes, parent, opts);
	  }

	  printList(items, parent, opts = {}) {
	    if (opts.separator == null) {
	      opts.separator = commaSeparator;
	    }

	    return this.printJoin(items, parent, opts);
	  }

	  _printNewline(leading, node, parent, opts) {
	    if (this.format.retainLines || this.format.compact) return;

	    if (this.format.concise) {
	      this.space();
	      return;
	    }

	    let lines = 0;

	    if (this._buf.hasContent()) {
	      if (!leading) lines++;
	      if (opts.addNewlines) lines += opts.addNewlines(leading, node) || 0;
	      const needs = leading ? n.needsWhitespaceBefore : n.needsWhitespaceAfter;
	      if (needs(node, parent)) lines++;
	    }

	    this.newline(lines);
	  }

	  _getComments(leading, node) {
	    return node && (leading ? node.leadingComments : node.trailingComments) || [];
	  }

	  _printComment(comment, skipNewLines) {
	    if (!this.format.shouldPrintComment(comment.value)) return;
	    if (comment.ignore) return;
	    if (this._printedComments.has(comment)) return;

	    this._printedComments.add(comment);

	    if (comment.start != null) {
	      if (this._printedCommentStarts[comment.start]) return;
	      this._printedCommentStarts[comment.start] = true;
	    }

	    const isBlockComment = comment.type === "CommentBlock";
	    const printNewLines = isBlockComment && !skipNewLines && !this._noLineTerminator;
	    if (printNewLines && this._buf.hasContent()) this.newline(1);
	    if (!this.endsWith("[") && !this.endsWith("{")) this.space();
	    let val = !isBlockComment && !this._noLineTerminator ? `//${comment.value}\n` : `/*${comment.value}*/`;

	    if (isBlockComment && this.format.indent.adjustMultilineComment) {
	      var _comment$loc;

	      const offset = (_comment$loc = comment.loc) == null ? void 0 : _comment$loc.start.column;

	      if (offset) {
	        const newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
	        val = val.replace(newlineRegex, "\n");
	      }

	      const indentSize = Math.max(this._getIndent().length, this.format.retainLines ? 0 : this._buf.getCurrentColumn());
	      val = val.replace(/\n(?!$)/g, `\n${" ".repeat(indentSize)}`);
	    }

	    if (this.endsWith("/")) this._space();
	    this.withSource("start", comment.loc, () => {
	      this._append(val);
	    });
	    if (printNewLines) this.newline(1);
	  }

	  _printComments(comments, inlinePureAnnotation) {
	    if (!(comments == null ? void 0 : comments.length)) return;

	    if (inlinePureAnnotation && comments.length === 1 && PURE_ANNOTATION_RE.test(comments[0].value)) {
	      this._printComment(comments[0], this._buf.hasContent() && !this.endsWith("\n"));
	    } else {
	      for (const comment of comments) {
	        this._printComment(comment);
	      }
	    }
	  }

	  printAssertions(node) {
	    var _node$assertions;

	    if ((_node$assertions = node.assertions) == null ? void 0 : _node$assertions.length) {
	      this.space();
	      this.word("assert");
	      this.space();
	      this.token("{");
	      this.space();
	      this.printList(node.assertions, node);
	      this.space();
	      this.token("}");
	    }
	  }

	}

	exports.default = Printer;
	Object.assign(Printer.prototype, generatorFunctions);

	function commaSeparator() {
	  this.token(",");
	  this.space();
	}
	});

	unwrapExports(printer);

	var lib$3 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = _default;
	exports.CodeGenerator = void 0;

	var _sourceMap = _interopRequireDefault(sourceMap$1);

	var _printer = _interopRequireDefault(printer);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	class Generator extends _printer.default {
	  constructor(ast, opts = {}, code) {
	    const format = normalizeOptions(code, opts);
	    const map = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
	    super(format, map);
	    this.ast = void 0;
	    this.ast = ast;
	  }

	  generate() {
	    return super.generate(this.ast);
	  }

	}

	function normalizeOptions(code, opts) {
	  const format = {
	    auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
	    auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
	    shouldPrintComment: opts.shouldPrintComment,
	    retainLines: opts.retainLines,
	    retainFunctionParens: opts.retainFunctionParens,
	    comments: opts.comments == null || opts.comments,
	    compact: opts.compact,
	    minified: opts.minified,
	    concise: opts.concise,
	    jsonCompatibleStrings: opts.jsonCompatibleStrings,
	    indent: {
	      adjustMultilineComment: true,
	      style: "  ",
	      base: 0
	    },
	    decoratorsBeforeExport: !!opts.decoratorsBeforeExport,
	    jsescOption: Object.assign({
	      quotes: "double",
	      wrap: true
	    }, opts.jsescOption),
	    recordAndTupleSyntaxType: opts.recordAndTupleSyntaxType
	  };

	  if (format.minified) {
	    format.compact = true;

	    format.shouldPrintComment = format.shouldPrintComment || (() => format.comments);
	  } else {
	    format.shouldPrintComment = format.shouldPrintComment || (value => format.comments || value.indexOf("@license") >= 0 || value.indexOf("@preserve") >= 0);
	  }

	  if (format.compact === "auto") {
	    format.compact = code.length > 500000;

	    if (format.compact) {
	      console.error("[BABEL] Note: The code generator has deoptimised the styling of " + `${opts.filename} as it exceeds the max of ${"500KB"}.`);
	    }
	  }

	  if (format.compact) {
	    format.indent.adjustMultilineComment = false;
	  }

	  return format;
	}

	class CodeGenerator {
	  constructor(ast, opts, code) {
	    this._generator = new Generator(ast, opts, code);
	  }

	  generate() {
	    return this._generator.generate();
	  }

	}

	exports.CodeGenerator = CodeGenerator;

	function _default(ast, opts, code) {
	  const gen = new Generator(ast, opts, code);
	  return gen.generate();
	}
	});

	unwrapExports(lib$3);
	var lib_1$1 = lib$3.CodeGenerator;

	var ancestry = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.findParent = findParent;
	exports.find = find;
	exports.getFunctionParent = getFunctionParent;
	exports.getStatementParent = getStatementParent;
	exports.getEarliestCommonAncestorFrom = getEarliestCommonAncestorFrom;
	exports.getDeepestCommonAncestorFrom = getDeepestCommonAncestorFrom;
	exports.getAncestry = getAncestry;
	exports.isAncestor = isAncestor;
	exports.isDescendant = isDescendant;
	exports.inType = inType;

	var t = _interopRequireWildcard(lib$1);

	var _index = _interopRequireDefault(path);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function findParent(callback) {
	  let path = this;

	  while (path = path.parentPath) {
	    if (callback(path)) return path;
	  }

	  return null;
	}

	function find(callback) {
	  let path = this;

	  do {
	    if (callback(path)) return path;
	  } while (path = path.parentPath);

	  return null;
	}

	function getFunctionParent() {
	  return this.findParent(p => p.isFunction());
	}

	function getStatementParent() {
	  let path = this;

	  do {
	    if (!path.parentPath || Array.isArray(path.container) && path.isStatement()) {
	      break;
	    } else {
	      path = path.parentPath;
	    }
	  } while (path);

	  if (path && (path.isProgram() || path.isFile())) {
	    throw new Error("File/Program node, we can't possibly find a statement parent to this");
	  }

	  return path;
	}

	function getEarliestCommonAncestorFrom(paths) {
	  return this.getDeepestCommonAncestorFrom(paths, function (deepest, i, ancestries) {
	    let earliest;
	    const keys = t.VISITOR_KEYS[deepest.type];

	    for (const ancestry of ancestries) {
	      const path = ancestry[i + 1];

	      if (!earliest) {
	        earliest = path;
	        continue;
	      }

	      if (path.listKey && earliest.listKey === path.listKey) {
	        if (path.key < earliest.key) {
	          earliest = path;
	          continue;
	        }
	      }

	      const earliestKeyIndex = keys.indexOf(earliest.parentKey);
	      const currentKeyIndex = keys.indexOf(path.parentKey);

	      if (earliestKeyIndex > currentKeyIndex) {
	        earliest = path;
	      }
	    }

	    return earliest;
	  });
	}

	function getDeepestCommonAncestorFrom(paths, filter) {
	  if (!paths.length) {
	    return this;
	  }

	  if (paths.length === 1) {
	    return paths[0];
	  }

	  let minDepth = Infinity;
	  let lastCommonIndex, lastCommon;
	  const ancestries = paths.map(path => {
	    const ancestry = [];

	    do {
	      ancestry.unshift(path);
	    } while ((path = path.parentPath) && path !== this);

	    if (ancestry.length < minDepth) {
	      minDepth = ancestry.length;
	    }

	    return ancestry;
	  });
	  const first = ancestries[0];

	  depthLoop: for (let i = 0; i < minDepth; i++) {
	    const shouldMatch = first[i];

	    for (const ancestry of ancestries) {
	      if (ancestry[i] !== shouldMatch) {
	        break depthLoop;
	      }
	    }

	    lastCommonIndex = i;
	    lastCommon = shouldMatch;
	  }

	  if (lastCommon) {
	    if (filter) {
	      return filter(lastCommon, lastCommonIndex, ancestries);
	    } else {
	      return lastCommon;
	    }
	  } else {
	    throw new Error("Couldn't find intersection");
	  }
	}

	function getAncestry() {
	  let path = this;
	  const paths = [];

	  do {
	    paths.push(path);
	  } while (path = path.parentPath);

	  return paths;
	}

	function isAncestor(maybeDescendant) {
	  return maybeDescendant.isDescendant(this);
	}

	function isDescendant(maybeAncestor) {
	  return !!this.findParent(parent => parent === maybeAncestor);
	}

	function inType() {
	  let path = this;

	  while (path) {
	    for (const type of arguments) {
	      if (path.node.type === type) return true;
	    }

	    path = path.parentPath;
	  }

	  return false;
	}
	});

	unwrapExports(ancestry);
	var ancestry_1 = ancestry.findParent;
	var ancestry_2 = ancestry.find;
	var ancestry_3 = ancestry.getFunctionParent;
	var ancestry_4 = ancestry.getStatementParent;
	var ancestry_5 = ancestry.getEarliestCommonAncestorFrom;
	var ancestry_6 = ancestry.getDeepestCommonAncestorFrom;
	var ancestry_7 = ancestry.getAncestry;
	var ancestry_8 = ancestry.isAncestor;
	var ancestry_9 = ancestry.isDescendant;
	var ancestry_10 = ancestry.inType;

	var infererReference = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = _default;

	var t = _interopRequireWildcard(lib$1);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _default(node) {
	  if (!this.isReferenced()) return;
	  const binding = this.scope.getBinding(node.name);

	  if (binding) {
	    if (binding.identifier.typeAnnotation) {
	      return binding.identifier.typeAnnotation;
	    } else {
	      return getTypeAnnotationBindingConstantViolations(binding, this, node.name);
	    }
	  }

	  if (node.name === "undefined") {
	    return t.voidTypeAnnotation();
	  } else if (node.name === "NaN" || node.name === "Infinity") {
	    return t.numberTypeAnnotation();
	  } else if (node.name === "arguments") ;
	}

	function getTypeAnnotationBindingConstantViolations(binding, path, name) {
	  const types = [];
	  const functionConstantViolations = [];
	  let constantViolations = getConstantViolationsBefore(binding, path, functionConstantViolations);
	  const testType = getConditionalAnnotation(binding, path, name);

	  if (testType) {
	    const testConstantViolations = getConstantViolationsBefore(binding, testType.ifStatement);
	    constantViolations = constantViolations.filter(path => testConstantViolations.indexOf(path) < 0);
	    types.push(testType.typeAnnotation);
	  }

	  if (constantViolations.length) {
	    constantViolations = constantViolations.concat(functionConstantViolations);

	    for (const violation of constantViolations) {
	      types.push(violation.getTypeAnnotation());
	    }
	  }

	  if (!types.length) {
	    return;
	  }

	  if (t.isTSTypeAnnotation(types[0]) && t.createTSUnionType) {
	    return t.createTSUnionType(types);
	  }

	  if (t.createFlowUnionType) {
	    return t.createFlowUnionType(types);
	  }

	  return t.createUnionTypeAnnotation(types);
	}

	function getConstantViolationsBefore(binding, path, functions) {
	  const violations = binding.constantViolations.slice();
	  violations.unshift(binding.path);
	  return violations.filter(violation => {
	    violation = violation.resolve();

	    const status = violation._guessExecutionStatusRelativeTo(path);

	    if (functions && status === "unknown") functions.push(violation);
	    return status === "before";
	  });
	}

	function inferAnnotationFromBinaryExpression(name, path) {
	  const operator = path.node.operator;
	  const right = path.get("right").resolve();
	  const left = path.get("left").resolve();
	  let target;

	  if (left.isIdentifier({
	    name
	  })) {
	    target = right;
	  } else if (right.isIdentifier({
	    name
	  })) {
	    target = left;
	  }

	  if (target) {
	    if (operator === "===") {
	      return target.getTypeAnnotation();
	    }

	    if (t.BOOLEAN_NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
	      return t.numberTypeAnnotation();
	    }

	    return;
	  }

	  if (operator !== "===" && operator !== "==") return;
	  let typeofPath;
	  let typePath;

	  if (left.isUnaryExpression({
	    operator: "typeof"
	  })) {
	    typeofPath = left;
	    typePath = right;
	  } else if (right.isUnaryExpression({
	    operator: "typeof"
	  })) {
	    typeofPath = right;
	    typePath = left;
	  }

	  if (!typeofPath) return;
	  if (!typeofPath.get("argument").isIdentifier({
	    name
	  })) return;
	  typePath = typePath.resolve();
	  if (!typePath.isLiteral()) return;
	  const typeValue = typePath.node.value;
	  if (typeof typeValue !== "string") return;
	  return t.createTypeAnnotationBasedOnTypeof(typeValue);
	}

	function getParentConditionalPath(binding, path, name) {
	  let parentPath;

	  while (parentPath = path.parentPath) {
	    if (parentPath.isIfStatement() || parentPath.isConditionalExpression()) {
	      if (path.key === "test") {
	        return;
	      }

	      return parentPath;
	    }

	    if (parentPath.isFunction()) {
	      if (parentPath.parentPath.scope.getBinding(name) !== binding) return;
	    }

	    path = parentPath;
	  }
	}

	function getConditionalAnnotation(binding, path, name) {
	  const ifStatement = getParentConditionalPath(binding, path, name);
	  if (!ifStatement) return;
	  const test = ifStatement.get("test");
	  const paths = [test];
	  const types = [];

	  for (let i = 0; i < paths.length; i++) {
	    const path = paths[i];

	    if (path.isLogicalExpression()) {
	      if (path.node.operator === "&&") {
	        paths.push(path.get("left"));
	        paths.push(path.get("right"));
	      }
	    } else if (path.isBinaryExpression()) {
	      const type = inferAnnotationFromBinaryExpression(name, path);
	      if (type) types.push(type);
	    }
	  }

	  if (types.length) {
	    if (t.isTSTypeAnnotation(types[0]) && t.createTSUnionType) {
	      return {
	        typeAnnotation: t.createTSUnionType(types),
	        ifStatement
	      };
	    }

	    if (t.createFlowUnionType) {
	      return {
	        typeAnnotation: t.createFlowUnionType(types),
	        ifStatement
	      };
	    }

	    return {
	      typeAnnotation: t.createUnionTypeAnnotation(types),
	      ifStatement
	    };
	  }

	  return getConditionalAnnotation(ifStatement, name);
	}
	});

	unwrapExports(infererReference);

	var inferers = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.VariableDeclarator = VariableDeclarator;
	exports.TypeCastExpression = TypeCastExpression;
	exports.NewExpression = NewExpression;
	exports.TemplateLiteral = TemplateLiteral;
	exports.UnaryExpression = UnaryExpression;
	exports.BinaryExpression = BinaryExpression;
	exports.LogicalExpression = LogicalExpression;
	exports.ConditionalExpression = ConditionalExpression;
	exports.SequenceExpression = SequenceExpression;
	exports.ParenthesizedExpression = ParenthesizedExpression;
	exports.AssignmentExpression = AssignmentExpression;
	exports.UpdateExpression = UpdateExpression;
	exports.StringLiteral = StringLiteral;
	exports.NumericLiteral = NumericLiteral;
	exports.BooleanLiteral = BooleanLiteral;
	exports.NullLiteral = NullLiteral;
	exports.RegExpLiteral = RegExpLiteral;
	exports.ObjectExpression = ObjectExpression;
	exports.ArrayExpression = ArrayExpression;
	exports.RestElement = RestElement;
	exports.ClassDeclaration = exports.ClassExpression = exports.FunctionDeclaration = exports.ArrowFunctionExpression = exports.FunctionExpression = Func;
	exports.CallExpression = CallExpression;
	exports.TaggedTemplateExpression = TaggedTemplateExpression;
	Object.defineProperty(exports, "Identifier", {
	  enumerable: true,
	  get: function () {
	    return _infererReference.default;
	  }
	});

	var t = _interopRequireWildcard(lib$1);

	var _infererReference = _interopRequireDefault(infererReference);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function VariableDeclarator() {
	  var _type;

	  const id = this.get("id");
	  if (!id.isIdentifier()) return;
	  const init = this.get("init");
	  let type = init.getTypeAnnotation();

	  if (((_type = type) == null ? void 0 : _type.type) === "AnyTypeAnnotation") {
	    if (init.isCallExpression() && init.get("callee").isIdentifier({
	      name: "Array"
	    }) && !init.scope.hasBinding("Array", true)) {
	      type = ArrayExpression();
	    }
	  }

	  return type;
	}

	function TypeCastExpression(node) {
	  return node.typeAnnotation;
	}

	TypeCastExpression.validParent = true;

	function NewExpression(node) {
	  if (this.get("callee").isIdentifier()) {
	    return t.genericTypeAnnotation(node.callee);
	  }
	}

	function TemplateLiteral() {
	  return t.stringTypeAnnotation();
	}

	function UnaryExpression(node) {
	  const operator = node.operator;

	  if (operator === "void") {
	    return t.voidTypeAnnotation();
	  } else if (t.NUMBER_UNARY_OPERATORS.indexOf(operator) >= 0) {
	    return t.numberTypeAnnotation();
	  } else if (t.STRING_UNARY_OPERATORS.indexOf(operator) >= 0) {
	    return t.stringTypeAnnotation();
	  } else if (t.BOOLEAN_UNARY_OPERATORS.indexOf(operator) >= 0) {
	    return t.booleanTypeAnnotation();
	  }
	}

	function BinaryExpression(node) {
	  const operator = node.operator;

	  if (t.NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
	    return t.numberT