'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ImportChecker = function () {
    function ImportChecker(option) {
        _classCallCheck(this, ImportChecker);

        if (typeof option === 'string') {
            this.name = option;
            this.use = null;
            this.nameRegExp = null;
            this.module = null;
        } else {
            this.name = option.name || null;
            this.nameRegExp = option.nameRegExp || null;
            this.use = option.use || null;
            this.module = option.module || null;
        }

        this.regExp = this.nameRegExp ? new RegExp(this.nameRegExp) : null;

        if (this.name && this.nameRegExp) {
            throw new Error('You should provide one of "name" or "nameRegExp" in option');
        }
    }

    _createClass(ImportChecker, [{
        key: 'check',
        value: function check(importPath, importModules) {
            if (this.module && importModules && importModules.size) {
                return importPath === this.module && importModules.has(this.name);
            }
            if (this.name) {
                return importPath === this.name;
            }
            if (this.regExp) {
                if (typeof importPath !== 'string') {
                    return false;
                }
                return Boolean(importPath.match(this.regExp));
            }
            throw new Error('You should provide "name" or "nameRegExp" as an option to plugin');
        }
    }, {
        key: 'getErrMessage',
        value: function getErrMessage() {
            if (this.module && this.use && this.name) {
                var _errorMsg = this.name + ' from ' + this.module + ' is deprecated. Use ' + this.use + ' instead.';
                return _errorMsg;
            }
            if (this.name) {
                var _errorMsg2 = 'Module ' + this.name + ' is deprecated.';
                if (this.use) {
                    _errorMsg2 += ' Use ' + this.use + ' instead.';
                }
                return _errorMsg2;
            }
            var errorMsg = 'Import pattern \'' + this.nameRegExp + '\' is deprecated.';
            if (this.use) {
                errorMsg += ' Use ' + this.use + ' instead.';
            }
            return errorMsg;
        }
    }]);

    return ImportChecker;
}();

module.exports = ImportChecker;