import ts from 'typescript';
import { IMPORT_STAR } from '../../../constants.js';
import { isDefaultImport } from '../../ast-helpers.js';
import { importVisitor as visit } from '../index.js';
export default visit(() => true, node => {
    if (ts.isImportDeclaration(node) && ts.isStringLiteralLike(node.moduleSpecifier)) {
        const specifier = node.moduleSpecifier.text;
        if (!node.importClause) {
            return { specifier, identifier: undefined, pos: node.pos };
        }
        const imports = [];
        if (isDefaultImport(node)) {
            imports.push({
                identifier: 'default',
                alias: String(node.importClause.name?.escapedText),
                specifier,
                symbol: node.importClause.symbol,
                pos: node.moduleSpecifier.pos,
            });
        }
        if (node.importClause?.namedBindings) {
            if (ts.isNamespaceImport(node.importClause.namedBindings)) {
                const symbol = node.importClause.namedBindings.symbol;
                imports.push({
                    symbol,
                    specifier,
                    identifier: IMPORT_STAR,
                    isTypeOnly: node.importClause?.isTypeOnly,
                    pos: symbol?.declarations[0]?.pos ?? node.pos,
                });
            }
            if (ts.isNamedImports(node.importClause.namedBindings)) {
                for (const element of node.importClause.namedBindings.elements) {
                    const identifier = (element.propertyName ?? element.name).getText();
                    imports.push({
                        identifier,
                        specifier,
                        symbol: element.symbol,
                        isTypeOnly: node.importClause?.isTypeOnly,
                        pos: element.pos,
                    });
                }
            }
            if (imports.length === 0) {
                imports.push({
                    specifier,
                    identifier: undefined,
                    isTypeOnly: node.importClause?.isTypeOnly,
                    pos: node.importClause.namedBindings.pos,
                });
            }
        }
        return imports;
    }
});
