import { compact } from '../../util/array.js';
import { toConfig, toDeferResolve, toProductionDependency } from '../../util/input.js';
import { join } from '../../util/path.js';
import { hasDependency } from '../../util/plugin.js';
const title = 'TypeScript';
const enablers = ['typescript'];
const isEnabled = ({ dependencies }) => hasDependency(dependencies, enablers);
const config = ['tsconfig.json'];
const resolveConfig = async (localConfig, options) => {
    const { compilerOptions } = localConfig;
    const extend = localConfig.extends
        ? [localConfig.extends]
            .flat()
            .map(specifier => toConfig('typescript', specifier, { containingFilePath: options.configFilePath }))
        : [];
    const references = localConfig.references
        ?.filter(reference => reference.path.endsWith('.json'))
        .map(reference => toConfig('typescript', reference.path, { containingFilePath: options.configFilePath })) ?? [];
    if (!(compilerOptions && localConfig))
        return compact([...extend, ...references]);
    const jsx = (compilerOptions?.jsxImportSource ? [compilerOptions.jsxImportSource] : []).map(toProductionDependency);
    const types = compilerOptions.types ?? [];
    const plugins = Array.isArray(compilerOptions?.plugins)
        ? compilerOptions.plugins.map(plugin => (typeof plugin === 'object' && 'name' in plugin ? plugin.name : ''))
        : [];
    const importHelpers = compilerOptions?.importHelpers ? ['tslib'] : [];
    return compact([
        ...extend,
        ...references,
        ...[...types, ...plugins, ...importHelpers].map(id => toDeferResolve(id)),
        ...jsx,
    ]);
};
const args = {
    binaries: ['tsc'],
    string: ['project'],
    alias: { project: ['p'] },
    config: [['project', (p) => (p.endsWith('.json') ? p : join(p, 'tsconfig.json'))]],
};
const note = '[What’s up with that configurable tsconfig.json location?](/reference/faq#whats-up-with-that-configurable-tsconfigjson-location)';
export const docs = { note };
export default {
    title,
    enablers,
    isEnabled,
    config,
    resolveConfig,
    args,
};
