import { toDeferResolve, toDependency } from '../../util/input.js';
import { hasDependency } from '../../util/plugin.js';
const title = 'Gatsby';
const enablers = ['gatsby', 'gatsby-cli'];
const isEnabled = ({ dependencies }) => hasDependency(dependencies, enablers);
const config = ['gatsby-{config,node}.{js,jsx,ts,tsx}', 'plugins/**/gatsby-node.{js,jsx,ts,tsx}'];
const production = [
    'gatsby-{browser,ssr}.{js,jsx,ts,tsx}',
    'src/api/**/*.{js,ts}',
    'src/pages/**/*.{js,jsx,ts,tsx}',
    'src/templates/**/*.{js,jsx,ts,tsx}',
    'src/html.{js,jsx,ts,tsx}',
    'plugins/**/gatsby-{browser,ssr}.{js,jsx,ts,tsx}',
];
const resolveConfig = async (localConfig, options) => {
    const { configFileName } = options;
    if (/gatsby-config/.test(configFileName)) {
        return localConfig.plugins
            .map(plugin => (typeof plugin === 'string' ? plugin : plugin.resolve))
            .map(id => toDeferResolve(id));
    }
    if (/gatsby-node/.test(configFileName)) {
        const plugins = new Set();
        const actions = { setBabelPlugin: plugin => plugins.add(plugin.name) };
        const _config = localConfig;
        if (typeof _config.onCreateBabelConfig === 'function') {
            _config.onCreateBabelConfig({ actions });
        }
        return Array.from(plugins).map(id => toDependency(id));
    }
    return [];
};
export default {
    title,
    enablers,
    isEnabled,
    config,
    production,
    resolveConfig,
};
