import type { Configuration, IgnorePatterns, RawConfiguration, WorkspaceConfiguration } from './types/config.js';
import type { ConfigurationHints } from './types/issues.js';
import type { WorkspacePackage } from './types/package-json.js';
import type { MainOptions } from './util/create-options.js';
import { type WorkspaceGraph } from './util/create-workspace-graph.js';
export declare const isDefaultPattern: (type: "entry" | "project", id: string) => boolean;
export type Workspace = {
    name: string;
    pkgName: string;
    dir: string;
    ancestors: string[];
    config: WorkspaceConfiguration;
    manifestPath: string;
    manifestStr: string;
    ignoreMembers: IgnorePatterns;
    srcDir?: string;
    outDir?: string;
};
export declare class ConfigurationChief {
    cwd: string;
    rawConfig?: RawConfiguration;
    isProduction: boolean;
    isStrict: boolean;
    isIncludeEntryExports: boolean;
    config: Configuration;
    workspace: string | undefined;
    workspaces: string[];
    ignoredWorkspacePatterns: string[];
    workspacePackages: Map<string, WorkspacePackage>;
    workspacesByPkgName: Map<string, Workspace>;
    workspacesByName: Map<string, Workspace>;
    additionalWorkspaceNames: Set<string>;
    availableWorkspaceNames: string[];
    availableWorkspacePkgNames: Set<string>;
    availableWorkspaceDirs: string[];
    workspaceGraph: WorkspaceGraph;
    includedWorkspaces: Workspace[];
    constructor(options: MainOptions);
    getConfigurationHints(): ConfigurationHints;
    private normalize;
    getWorkspaces(): Promise<Workspace[]>;
    private getListedWorkspaces;
    private getIgnoredWorkspaces;
    private getIgnoredWorkspacePatterns;
    private getConfiguredWorkspaceKeys;
    private getAdditionalWorkspaceNames;
    private getAvailableWorkspaceNames;
    private getIncludedWorkspaces;
    getManifestForWorkspace(name: string): import("./types/package-json.js").PackageJson | undefined;
    private getDescendentWorkspaces;
    getIgnoredWorkspacesFor(name: string): string[];
    getNegatedWorkspacePatterns(name: string): string[];
    private getConfigKeyForWorkspace;
    getWorkspaceConfig(workspaceName: string): {
        angular?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        astro?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        ava?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        babel?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        biome?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        bumpp?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        bun?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        c8?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        capacitor?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        changelogen?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        changelogithub?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        changesets?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        commitizen?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        commitlint?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        convex?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'create-typescript-app'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        cspell?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        cucumber?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        cypress?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'dependency-cruiser'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        docusaurus?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        dotenv?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        drizzle?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        eleventy?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        eslint?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        expo?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        gatsby?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'github-action'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'github-actions'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        glob?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'graphql-codegen'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        hardhat?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        husky?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'i18next-parser'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        jest?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        karma?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        ladle?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        lefthook?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'lint-staged'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        linthtml?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'lockfile-lint'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'lost-pixel'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        markdownlint?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        metro?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        mocha?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        moonrepo?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        msw?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'nano-staged'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        nest?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        netlify?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        next?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        node?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'node-modules-inspector'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        nodemon?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'npm-package-json-lint'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        nuxt?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        nx?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        nyc?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        oclif?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        oxlint?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        playwright?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'playwright-ct'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'playwright-test'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        plop?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        pnpm?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        postcss?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        preconstruct?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        prettier?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        prisma?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'react-cosmos'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'react-router'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        relay?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'release-it'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        remark?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        remix?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        rollup?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        rsbuild?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        rslib?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        rspack?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        rstest?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'semantic-release'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        sentry?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'simple-git-hooks'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'size-limit'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        sst?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        starlight?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        storybook?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        stryker?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        stylelint?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        svelte?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        svgo?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        syncpack?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        tailwind?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        travis?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'ts-node'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        tsdown?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        tsup?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        tsx?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        typedoc?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        typescript?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        unbuild?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        unocss?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'vercel-og'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        vike?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        vite?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        vitest?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        vue?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        'webdriver-io'?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        webpack?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        wireit?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        wrangler?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        xo?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        yarn?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        yorkie?: string | boolean | string[] | {
            config?: string | string[] | undefined;
            entry?: string | string[] | undefined;
            project?: string | string[] | undefined;
        } | undefined;
        entry?: string | string[] | undefined;
        project?: string | string[] | undefined;
        paths?: Record<string, string[]> | undefined;
        ignore?: string | string[] | undefined;
        ignoreBinaries?: (string | RegExp)[] | undefined;
        ignoreDependencies?: (string | RegExp)[] | undefined;
        ignoreMembers?: (string | RegExp)[] | undefined;
        ignoreUnresolved?: (string | RegExp)[] | undefined;
        includeEntryExports?: boolean | undefined;
    };
    getIgnores(workspaceName: string): {
        ignoreBinaries: (string | RegExp)[];
        ignoreDependencies: (string | RegExp)[];
        ignoreUnresolved: (string | RegExp)[];
    };
    getConfigForWorkspace(workspaceName: string, extensions?: string[]): {
        angular?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        astro?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        ava?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        babel?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        biome?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        bumpp?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        bun?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        c8?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        capacitor?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        changelogen?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        changelogithub?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        changesets?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        commitizen?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        commitlint?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        convex?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "create-typescript-app"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        cspell?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        cucumber?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        cypress?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "dependency-cruiser"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        docusaurus?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        dotenv?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        drizzle?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        eleventy?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        eslint?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        expo?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        gatsby?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "github-action"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "github-actions"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        glob?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "graphql-codegen"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        hardhat?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        husky?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "i18next-parser"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        jest?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        karma?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        ladle?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        lefthook?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "lint-staged"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        linthtml?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "lockfile-lint"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "lost-pixel"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        markdownlint?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        metro?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        mocha?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        moonrepo?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        msw?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "nano-staged"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        nest?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        netlify?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        next?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        node?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "node-modules-inspector"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        nodemon?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "npm-package-json-lint"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        nuxt?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        nx?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        nyc?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        oclif?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        oxlint?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        playwright?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "playwright-ct"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "playwright-test"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        plop?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        pnpm?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        postcss?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        preconstruct?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        prettier?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        prisma?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "react-cosmos"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "react-router"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        relay?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "release-it"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        remark?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        remix?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        rollup?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        rsbuild?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        rslib?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        rspack?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        rstest?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "semantic-release"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        sentry?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "simple-git-hooks"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "size-limit"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        sst?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        starlight?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        storybook?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        stryker?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        stylelint?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        svelte?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        svgo?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        syncpack?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        tailwind?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        travis?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "ts-node"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        tsdown?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        tsup?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        tsx?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        typedoc?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        typescript?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        unbuild?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        unocss?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "vercel-og"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        vike?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        vite?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        vitest?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        vue?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        "webdriver-io"?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        webpack?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        wireit?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        wrangler?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        xo?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        yarn?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        yorkie?: (boolean | import("./types/config.js").EnsuredPluginConfiguration) | undefined;
        entry: string[];
        project: string[];
        paths: Record<string, string[]>;
        ignore: string[];
        isIncludeEntryExports: boolean;
    };
    findWorkspaceByFilePath(filePath: string): Workspace | undefined;
    getUnusedIgnoredWorkspaces(): string[];
}
