const MX_USERNAME_PREFIX = "@";
const MX_ROOM_PREFIX = "#";
const MX_ALIAS_PREFIX = "+";
const graphemeSegmenter = new Intl.Segmenter();
function getInitialLetter(name) {
  if (name.length < 1) {
    return "";
  }
  const initial = name[0];
  if ([MX_USERNAME_PREFIX, MX_ROOM_PREFIX, MX_ALIAS_PREFIX].includes(initial)) {
    name = name.substring(1);
  }
  const result = graphemeSegmenter.segment(name)[Symbol.iterator]().next();
  return result.done ? "" : result.value.segment;
}
export {
  MX_ALIAS_PREFIX,
  MX_ROOM_PREFIX,
  MX_USERNAME_PREFIX,
  getInitialLetter
};
//# sourceMappingURL=string.js.map
