"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
function getPlatform() {
  const userAgent = globalThis.navigator?.userAgent;
  if (/android/i.test(userAgent)) {
    return "android";
  } else if (/iPad|iPhone|iPod|Mac/.test(userAgent) && "ontouchend" in document) {
    return "ios";
  } else {
    return "other";
  }
}
exports.getPlatform = getPlatform;
//# sourceMappingURL=platform.cjs.map
