import { jsxs, jsx } from "react/jsx-runtime";
import styles from "./VisualListItem.module.css.js";
import classNames from "classnames";
function VisualListItem({
  className,
  children,
  Icon,
  success = false,
  destructive = false,
  ...props
}) {
  return /* @__PURE__ */ jsxs(
    "li",
    {
      className: classNames(styles["visual-list-item"], className),
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          Icon,
          {
            className: classNames(styles["visual-list-item-icon"], {
              [styles["visual-list-item-icon-success"]]: success,
              [styles["visual-list-item-icon-destructive"]]: destructive
            }),
            width: "24px",
            height: "24px",
            "aria-hidden": true
          }
        ),
        children
      ]
    }
  );
}
export {
  VisualListItem
};
//# sourceMappingURL=VisualListItem.js.map
