"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const VisualListItem_module = require("./VisualListItem.module.css.cjs");
const classNames = require("classnames");
function VisualListItem({
  className,
  children,
  Icon,
  success = false,
  destructive = false,
  ...props
}) {
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "li",
    {
      className: classNames(VisualListItem_module.default["visual-list-item"], className),
      ...props,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          Icon,
          {
            className: classNames(VisualListItem_module.default["visual-list-item-icon"], {
              [VisualListItem_module.default["visual-list-item-icon-success"]]: success,
              [VisualListItem_module.default["visual-list-item-icon-destructive"]]: destructive
            }),
            width: "24px",
            height: "24px",
            "aria-hidden": true
          }
        ),
        children
      ]
    }
  );
}
exports.VisualListItem = VisualListItem;
//# sourceMappingURL=VisualListItem.cjs.map
