import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import styles from "./Typography.module.css.js";
const Typography = ({
  as,
  children,
  type = "body",
  weight = "regular",
  size = "md",
  className,
  ...restProps
}) => {
  const Component = as || "p";
  return /* @__PURE__ */ jsx(
    Component,
    {
      ...restProps,
      className: classNames(
        styles.typography,
        styles[`font-${type}-${size}-${weight}`],
        className
      ),
      children
    }
  );
};
export {
  Typography
};
//# sourceMappingURL=Typography.js.map
