"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const Typography_module = require("./Typography.module.css.cjs");
const Typography = ({
  as,
  children,
  type = "body",
  weight = "regular",
  size = "md",
  className,
  ...restProps
}) => {
  const Component = as || "p";
  return /* @__PURE__ */ jsxRuntime.jsx(
    Component,
    {
      ...restProps,
      className: classNames(
        Typography_module.default.typography,
        Typography_module.default[`font-${type}-${size}-${weight}`],
        className
      ),
      children
    }
  );
};
exports.Typography = Typography;
//# sourceMappingURL=Typography.cjs.map
