import { jsx } from "react/jsx-runtime";
import { Typography } from "./Typography.js";
import { Text } from "./Text.js";
const Heading = ({ as = "h1", children, ...props }) => {
  return /* @__PURE__ */ jsx(Typography, { as, type: "heading", ...props, children });
};
const H1 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsx(Heading, { as: "h1", weight: "semibold", size: "xl", ...props, children });
};
const H2 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsx(Heading, { as: "h2", weight: "semibold", size: "lg", ...props, children });
};
const H3 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsx(Heading, { as: "h3", weight: "semibold", size: "md", ...props, children });
};
const H4 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsx(Heading, { as: "h4", weight: "semibold", size: "sm", ...props, children });
};
const H5 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsx(Text, { as: "h5", weight: "semibold", size: "lg", ...props, children });
};
const H6 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsx(Text, { as: "h6", weight: "semibold", size: "md", ...props, children });
};
export {
  H1,
  H2,
  H3,
  H4,
  H5,
  H6,
  Heading
};
//# sourceMappingURL=Heading.js.map
