"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const Typography = require("./Typography.cjs");
const Text = require("./Text.cjs");
const Heading = ({ as = "h1", children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Typography.Typography, { as, type: "heading", ...props, children });
};
const H1 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Heading, { as: "h1", weight: "semibold", size: "xl", ...props, children });
};
const H2 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Heading, { as: "h2", weight: "semibold", size: "lg", ...props, children });
};
const H3 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Heading, { as: "h3", weight: "semibold", size: "md", ...props, children });
};
const H4 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Heading, { as: "h4", weight: "semibold", size: "sm", ...props, children });
};
const H5 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Text.Text, { as: "h5", weight: "semibold", size: "lg", ...props, children });
};
const H6 = ({ children, ...props }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Text.Text, { as: "h6", weight: "semibold", size: "md", ...props, children });
};
exports.H1 = H1;
exports.H2 = H2;
exports.H3 = H3;
exports.H4 = H4;
exports.H5 = H5;
exports.H6 = H6;
exports.Heading = Heading;
//# sourceMappingURL=Heading.cjs.map
