import { createContext, useContext } from "react";
const TooltipContext = createContext(null);
function useTooltipContext() {
  const context = useContext(TooltipContext);
  if (context == null) {
    throw new Error("Tooltip components must be wrapped in <Tooltip />");
  }
  return context;
}
export {
  TooltipContext,
  useTooltipContext
};
//# sourceMappingURL=TooltipContext.js.map
