"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const React = require("react");
const TooltipContext = React.createContext(null);
function useTooltipContext() {
  const context = React.useContext(TooltipContext);
  if (context == null) {
    throw new Error("Tooltip components must be wrapped in <Tooltip />");
  }
  return context;
}
exports.TooltipContext = TooltipContext;
exports.useTooltipContext = useTooltipContext;
//# sourceMappingURL=TooltipContext.cjs.map
