"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const TooltipContext = require("./TooltipContext.cjs");
const react = require("@floating-ui/react");
const React = require("react");
const classNames = require("classnames");
const Tooltip_module = require("./Tooltip.module.css.cjs");
const useTooltip = require("./useTooltip.cjs");
const hasLabel = (props) => "label" in props && !!props.label;
function Tooltip({
  children,
  isTriggerInteractive = true,
  nonInteractiveTriggerTabIndex = 0,
  ...props
}) {
  const context = useTooltip.useTooltip({ isTriggerInteractive, ...props });
  return /* @__PURE__ */ jsxRuntime.jsxs(TooltipContext.TooltipContext.Provider, { value: context, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      TooltipAnchor,
      {
        isTriggerInteractive,
        nonInteractiveTriggerTabIndex,
        children
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs(TooltipContent, { children: [
      /* @__PURE__ */ jsxRuntime.jsx("span", { id: context.labelId, children: hasLabel(props) ? props.label : props.description }),
      /* @__PURE__ */ jsxRuntime.jsx(Caption, {})
    ] })
  ] });
}
function Caption() {
  const { caption, captionId } = TooltipContext.useTooltipContext();
  if (!caption) return null;
  const isCaptionString = typeof caption === "string";
  const Container = isCaptionString ? "span" : "div";
  return /* @__PURE__ */ jsxRuntime.jsx(
    Container,
    {
      id: captionId,
      className: classNames(Tooltip_module.default.caption, "cpd-theme-dark"),
      children: caption
    }
  );
}
function TooltipContent({
  children
}) {
  const {
    context: floatingContext,
    open,
    arrowRef,
    purpose,
    ...rest
  } = TooltipContext.useTooltipContext();
  if (!open && purpose !== "label") return null;
  return /* @__PURE__ */ jsxRuntime.jsx(react.FloatingPortal, { children: /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      ref: rest.refs.setFloating,
      style: rest.floatingStyles,
      ...rest.tooltipProps,
      ...rest.getFloatingProps(),
      className: classNames(Tooltip_module.default.tooltip, {
        [Tooltip_module.default.invisible]: purpose === "label" && !open
      }),
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          react.FloatingArrow,
          {
            ref: arrowRef,
            context: floatingContext,
            width: 10,
            height: 6,
            className: Tooltip_module.default.arrow
          }
        ),
        children
      ]
    }
  ) });
}
const TooltipAnchor = ({
  children,
  isTriggerInteractive,
  nonInteractiveTriggerTabIndex
}) => {
  const context = TooltipContext.useTooltipContext();
  const childrenRef = children?.ref;
  const ref = react.useMergeRefs([context.refs.setReference, childrenRef]);
  const element = React.useMemo(() => {
    if (!React.isValidElement(children)) return;
    if (isTriggerInteractive) {
      const props = context.getReferenceProps({
        // To support React 18, we need to explicitly pass the children's props. See  https://github.com/element-hq/compound/issues/333
        // In React 19, this is not necessary. `getReferenceProps` is able to get the props directly from the ref.
        ...typeof children.props === "object" ? children.props : {},
        ref
      });
      return React.cloneElement(children, props);
    } else {
      const props = context.getReferenceProps({
        ref,
        tabIndex: nonInteractiveTriggerTabIndex
      });
      const {
        "aria-labelledby": labelId,
        "aria-describedby": descriptionId,
        ...spanProps
      } = props;
      return /* @__PURE__ */ jsxRuntime.jsx("span", { tabIndex: nonInteractiveTriggerTabIndex, ...spanProps, children: React.cloneElement(children, {
        "aria-labelledby": labelId,
        "aria-describedby": descriptionId
      }) });
    }
  }, [context, ref, children]);
  if (!element) {
    throw new Error("Tooltip anchor must be a single valid React element");
  }
  return element;
};
exports.Tooltip = Tooltip;
//# sourceMappingURL=Tooltip.cjs.map
