import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import * as RadixSeparator from "@radix-ui/react-separator";
import { forwardRef, useRef, useEffect } from "react";
import styles from "./Separator.module.css.js";
import { useMergeRefs } from "@floating-ui/react";
const SPACING_CUSTOM_PROP = "--cpd-separator-spacing";
const Separator = forwardRef(
  ({
    className,
    spacing,
    // Default provided via global.css
    kind = "primary",
    ...props
  }, theirRef) => {
    const classes = classNames(styles.separator, className);
    const ourRef = useRef(null);
    const ref = useMergeRefs([ourRef, theirRef]);
    useEffect(() => {
      const style = ourRef.current?.style;
      if (spacing) {
        style?.setProperty(SPACING_CUSTOM_PROP, spacing);
      } else {
        style?.removeProperty(SPACING_CUSTOM_PROP);
      }
    }, [spacing]);
    return /* @__PURE__ */ jsx(
      RadixSeparator.Root,
      {
        ...props,
        className: classes,
        ref,
        "data-kind": kind
      }
    );
  }
);
Separator.displayName = "Separator";
export {
  Separator
};
//# sourceMappingURL=Separator.js.map
