"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const RadixSeparator = require("@radix-ui/react-separator");
const React = require("react");
const Separator_module = require("./Separator.module.css.cjs");
const react = require("@floating-ui/react");
function _interopNamespaceDefault(e) {
  const n = Object.create(null, { [Symbol.toStringTag]: { value: "Module" } });
  if (e) {
    for (const k in e) {
      if (k !== "default") {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}
const RadixSeparator__namespace = /* @__PURE__ */ _interopNamespaceDefault(RadixSeparator);
const SPACING_CUSTOM_PROP = "--cpd-separator-spacing";
const Separator = React.forwardRef(
  ({
    className,
    spacing,
    // Default provided via global.css
    kind = "primary",
    ...props
  }, theirRef) => {
    const classes = classNames(Separator_module.default.separator, className);
    const ourRef = React.useRef(null);
    const ref = react.useMergeRefs([ourRef, theirRef]);
    React.useEffect(() => {
      const style = ourRef.current?.style;
      if (spacing) {
        style?.setProperty(SPACING_CUSTOM_PROP, spacing);
      } else {
        style?.removeProperty(SPACING_CUSTOM_PROP);
      }
    }, [spacing]);
    return /* @__PURE__ */ jsxRuntime.jsx(
      RadixSeparator__namespace.Root,
      {
        ...props,
        className: classes,
        ref,
        "data-kind": kind
      }
    );
  }
);
Separator.displayName = "Separator";
exports.Separator = Separator;
//# sourceMappingURL=Separator.cjs.map
