import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { forwardRef, useId } from "react";
import styles from "./Search.module.css.js";
import SearchIcon from "@vector-im/compound-design-tokens/assets/web/icons/search";
import { Field } from "../Form/Field.js";
import { Label } from "../Form/Label.js";
const Search = forwardRef(function Search2({
  className,
  onChange,
  // TODO: i18n needs to be setup
  placeholder = "Search…",
  name,
  ...props
}, ref) {
  const classes = classNames(styles.search, className);
  const id = useId();
  return /* @__PURE__ */ jsx(Field, { name, asChild: true, children: /* @__PURE__ */ jsxs(Label, { className: classes, htmlFor: id, children: [
    /* @__PURE__ */ jsx(SearchIcon, { className: styles.icon, width: 20, height: 20 }),
    /* @__PURE__ */ jsx(
      "input",
      {
        ref,
        ...props,
        id,
        name,
        type: "search",
        placeholder,
        onChange,
        className: styles.input
      }
    )
  ] }) });
});
export {
  Search
};
//# sourceMappingURL=Search.js.map
