"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const Search_module = require("./Search.module.css.cjs");
const SearchIcon = require("@vector-im/compound-design-tokens/assets/web/icons/search");
const Field = require("../Form/Field.cjs");
const Label = require("../Form/Label.cjs");
const Search = React.forwardRef(function Search2({
  className,
  onChange,
  // TODO: i18n needs to be setup
  placeholder = "Search…",
  name,
  ...props
}, ref) {
  const classes = classNames(Search_module.default.search, className);
  const id = React.useId();
  return /* @__PURE__ */ jsxRuntime.jsx(Field.Field, { name, asChild: true, children: /* @__PURE__ */ jsxRuntime.jsxs(Label.Label, { className: classes, htmlFor: id, children: [
    /* @__PURE__ */ jsxRuntime.jsx(SearchIcon, { className: Search_module.default.icon, width: 20, height: 20 }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        ref,
        ...props,
        id,
        name,
        type: "search",
        placeholder,
        onChange,
        className: Search_module.default.input
      }
    )
  ] }) });
});
exports.Search = Search;
//# sourceMappingURL=Search.cjs.map
