import { useId, useFloating, offset, shift, arrow, autoUpdate, limitShift, useRole, useInteractions } from "@floating-ui/react";
import { useRef, useMemo } from "react";
function useReleaseAnnouncement({
  open,
  header,
  description,
  closeLabel,
  placement,
  onClick,
  displayArrow
}) {
  const labelId = useId();
  const descriptionId = useId();
  const arrowRef = useRef(null);
  const data = useFloating({
    placement,
    open,
    whileElementsMounted: autoUpdate,
    middleware: [
      // arrow height 12px + 4px padding
      offset(16),
      shift({ limiter: limitShift({ offset: 50 }) }),
      // add the little arrow along with the floating content
      displayArrow && arrow({
        element: arrowRef
      })
    ]
  });
  const role = useRole(data.context);
  const interactions = useInteractions([role]);
  return useMemo(
    () => ({
      open,
      ...data,
      ...interactions,
      labelId,
      descriptionId,
      header,
      description,
      closeLabel,
      onClick,
      displayArrow,
      arrowRef
    }),
    [
      open,
      role,
      interactions,
      data,
      labelId,
      descriptionId,
      header,
      description,
      closeLabel,
      onClick,
      displayArrow,
      arrowRef
    ]
  );
}
export {
  useReleaseAnnouncement
};
//# sourceMappingURL=useReleaseAnnouncement.js.map
