"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const react = require("@floating-ui/react");
const React = require("react");
function useReleaseAnnouncement({
  open,
  header,
  description,
  closeLabel,
  placement,
  onClick,
  displayArrow
}) {
  const labelId = react.useId();
  const descriptionId = react.useId();
  const arrowRef = React.useRef(null);
  const data = react.useFloating({
    placement,
    open,
    whileElementsMounted: react.autoUpdate,
    middleware: [
      // arrow height 12px + 4px padding
      react.offset(16),
      react.shift({ limiter: react.limitShift({ offset: 50 }) }),
      // add the little arrow along with the floating content
      displayArrow && react.arrow({
        element: arrowRef
      })
    ]
  });
  const role = react.useRole(data.context);
  const interactions = react.useInteractions([role]);
  return React.useMemo(
    () => ({
      open,
      ...data,
      ...interactions,
      labelId,
      descriptionId,
      header,
      description,
      closeLabel,
      onClick,
      displayArrow,
      arrowRef
    }),
    [
      open,
      role,
      interactions,
      data,
      labelId,
      descriptionId,
      header,
      description,
      closeLabel,
      onClick,
      displayArrow,
      arrowRef
    ]
  );
}
exports.useReleaseAnnouncement = useReleaseAnnouncement;
//# sourceMappingURL=useReleaseAnnouncement.cjs.map
