"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const React = require("react");
const ReleaseAnnouncementContext = React.createContext(null);
function useReleaseAnnouncementContext() {
  const context = React.useContext(ReleaseAnnouncementContext);
  if (context == null) {
    throw new Error(
      "ReleaseAnnouncement components must be wrapped in <ReleaseAnnouncement />"
    );
  }
  return context;
}
exports.ReleaseAnnouncementContext = ReleaseAnnouncementContext;
exports.useReleaseAnnouncementContext = useReleaseAnnouncementContext;
//# sourceMappingURL=ReleaseAnnouncementContext.cjs.map
