import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { isValidElement, cloneElement } from "react";
import { useMergeRefs, FloatingPortal, FloatingFocusManager, FloatingArrow } from "@floating-ui/react";
import { Text } from "../Typography/Text.js";
import styles from "./ReleaseAnnouncement.module.css.js";
import { ReleaseAnnouncementContext, useReleaseAnnouncementContext } from "./ReleaseAnnouncementContext.js";
import { useReleaseAnnouncement } from "./useReleaseAnnouncement.js";
import { Button } from "../Button/Button.js";
function ReleaseAnnouncement({
  /**
   * The children anchor should be a single valid React element.
   */
  children,
  placement = "right",
  displayArrow = true,
  ...props
}) {
  const context = useReleaseAnnouncement({ placement, displayArrow, ...props });
  return /* @__PURE__ */ jsxs(ReleaseAnnouncementContext.Provider, { value: context, children: [
    /* @__PURE__ */ jsx(ReleaseAnnouncementAnchor, { children }),
    /* @__PURE__ */ jsx(ReleaseAnnouncementContainer, { children: /* @__PURE__ */ jsx(ReleaseAnnouncementContent, {}) })
  ] });
}
function ReleaseAnnouncementAnchor({
  children
}) {
  const context = useReleaseAnnouncementContext();
  const childrenRef = children?.ref;
  const ref = useMergeRefs([context.refs.setReference, childrenRef]);
  if (!isValidElement(children)) {
    throw new Error(
      "ReleaseAnnouncement anchor must be a single valid React element"
    );
  }
  const referenceProps = context.getReferenceProps({
    ref,
    // If the ReleaseAnnouncement is open, we need manually aria-describedby.
    // The RA has the dialog role and it's not adding automatically the aria-describedby.
    ...context.open && {
      "aria-describedby": context.getFloatingProps().id
    }
  });
  delete referenceProps["aria-expanded"];
  return cloneElement(children, referenceProps);
}
function ReleaseAnnouncementContainer({
  children
}) {
  const {
    context: floatingContext,
    arrowRef,
    displayArrow,
    ...rest
  } = useReleaseAnnouncementContext();
  if (!floatingContext.open) return null;
  return /* @__PURE__ */ jsx(FloatingPortal, { children: /* @__PURE__ */ jsx(FloatingFocusManager, { context: floatingContext, modal: false, children: /* @__PURE__ */ jsxs(
    "div",
    {
      ref: rest.refs.setFloating,
      style: rest.floatingStyles,
      "aria-labelledby": rest.labelId,
      "aria-describedby": rest.descriptionId,
      ...rest.getFloatingProps(),
      className: styles.content,
      children: [
        displayArrow && /* @__PURE__ */ jsx(
          FloatingArrow,
          {
            ref: arrowRef,
            context: floatingContext,
            width: 20,
            height: 12,
            className: styles.arrow
          }
        ),
        children
      ]
    }
  ) }) });
}
function ReleaseAnnouncementContent() {
  const { labelId, descriptionId, header, description, closeLabel, onClick } = useReleaseAnnouncementContext();
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Text,
      {
        as: "h3",
        id: labelId,
        className: styles.header,
        size: "lg",
        weight: "semibold",
        children: header
      }
    ),
    /* @__PURE__ */ jsx(
      Text,
      {
        as: "span",
        id: descriptionId,
        className: styles.description,
        size: "sm",
        weight: "regular",
        children: description
      }
    ),
    /* @__PURE__ */ jsx(
      Button,
      {
        size: "sm",
        kind: "secondary",
        className: styles.button,
        onClick,
        children: closeLabel
      }
    )
  ] });
}
export {
  ReleaseAnnouncement
};
//# sourceMappingURL=ReleaseAnnouncement.js.map
