"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const react = require("@floating-ui/react");
const Text = require("../Typography/Text.cjs");
const ReleaseAnnouncement_module = require("./ReleaseAnnouncement.module.css.cjs");
const ReleaseAnnouncementContext = require("./ReleaseAnnouncementContext.cjs");
const useReleaseAnnouncement = require("./useReleaseAnnouncement.cjs");
const Button = require("../Button/Button.cjs");
function ReleaseAnnouncement({
  /**
   * The children anchor should be a single valid React element.
   */
  children,
  placement = "right",
  displayArrow = true,
  ...props
}) {
  const context = useReleaseAnnouncement.useReleaseAnnouncement({ placement, displayArrow, ...props });
  return /* @__PURE__ */ jsxRuntime.jsxs(ReleaseAnnouncementContext.ReleaseAnnouncementContext.Provider, { value: context, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ReleaseAnnouncementAnchor, { children }),
    /* @__PURE__ */ jsxRuntime.jsx(ReleaseAnnouncementContainer, { children: /* @__PURE__ */ jsxRuntime.jsx(ReleaseAnnouncementContent, {}) })
  ] });
}
function ReleaseAnnouncementAnchor({
  children
}) {
  const context = ReleaseAnnouncementContext.useReleaseAnnouncementContext();
  const childrenRef = children?.ref;
  const ref = react.useMergeRefs([context.refs.setReference, childrenRef]);
  if (!React.isValidElement(children)) {
    throw new Error(
      "ReleaseAnnouncement anchor must be a single valid React element"
    );
  }
  const referenceProps = context.getReferenceProps({
    ref,
    // If the ReleaseAnnouncement is open, we need manually aria-describedby.
    // The RA has the dialog role and it's not adding automatically the aria-describedby.
    ...context.open && {
      "aria-describedby": context.getFloatingProps().id
    }
  });
  delete referenceProps["aria-expanded"];
  return React.cloneElement(children, referenceProps);
}
function ReleaseAnnouncementContainer({
  children
}) {
  const {
    context: floatingContext,
    arrowRef,
    displayArrow,
    ...rest
  } = ReleaseAnnouncementContext.useReleaseAnnouncementContext();
  if (!floatingContext.open) return null;
  return /* @__PURE__ */ jsxRuntime.jsx(react.FloatingPortal, { children: /* @__PURE__ */ jsxRuntime.jsx(react.FloatingFocusManager, { context: floatingContext, modal: false, children: /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      ref: rest.refs.setFloating,
      style: rest.floatingStyles,
      "aria-labelledby": rest.labelId,
      "aria-describedby": rest.descriptionId,
      ...rest.getFloatingProps(),
      className: ReleaseAnnouncement_module.default.content,
      children: [
        displayArrow && /* @__PURE__ */ jsxRuntime.jsx(
          react.FloatingArrow,
          {
            ref: arrowRef,
            context: floatingContext,
            width: 20,
            height: 12,
            className: ReleaseAnnouncement_module.default.arrow
          }
        ),
        children
      ]
    }
  ) }) });
}
function ReleaseAnnouncementContent() {
  const { labelId, descriptionId, header, description, closeLabel, onClick } = ReleaseAnnouncementContext.useReleaseAnnouncementContext();
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Text.Text,
      {
        as: "h3",
        id: labelId,
        className: ReleaseAnnouncement_module.default.header,
        size: "lg",
        weight: "semibold",
        children: header
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      Text.Text,
      {
        as: "span",
        id: descriptionId,
        className: ReleaseAnnouncement_module.default.description,
        size: "sm",
        weight: "regular",
        children: description
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(
      Button.Button,
      {
        size: "sm",
        kind: "secondary",
        className: ReleaseAnnouncement_module.default.button,
        onClick,
        children: closeLabel
      }
    )
  ] });
}
exports.ReleaseAnnouncement = ReleaseAnnouncement;
//# sourceMappingURL=ReleaseAnnouncement.cjs.map
