import { jsxs, jsx } from "react/jsx-runtime";
import { forwardRef, useId } from "react";
import classNames from "classnames";
import styles from "./Progress.module.css.js";
import { Root, Indicator } from "@radix-ui/react-progress";
const Progress = forwardRef(
  function Progress2({
    size,
    tint,
    className,
    value: valueProp,
    max: maxProp,
    getValueLabel,
    ...props
  }, ref) {
    const max = maxProp ?? 1;
    const value = valueProp ?? max;
    const labelId = useId();
    const label = getValueLabel ? getValueLabel(value, max) : null;
    return /* @__PURE__ */ jsxs(
      "div",
      {
        className: classNames(styles["progress-bar-container"], className),
        "data-tint": tint,
        ...props,
        children: [
          label && /* @__PURE__ */ jsx("div", { id: labelId, className: styles["progress-bar-label"], children: label }),
          /* @__PURE__ */ jsx(
            Root,
            {
              className: styles["progress-bar"],
              "data-size": size,
              max,
              value,
              ref,
              "aria-labelledby": label ? labelId : void 0,
              getValueLabel,
              children: /* @__PURE__ */ jsx(
                Indicator,
                {
                  className: styles["progress-bar-indicator"],
                  style: {
                    transform: `translateX(-${100 - value / max * 100}%)`
                  }
                }
              )
            }
          )
        ]
      }
    );
  }
);
export {
  Progress
};
//# sourceMappingURL=Progress.js.map
