"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const classNames = require("classnames");
const Progress_module = require("./Progress.module.css.cjs");
const reactProgress = require("@radix-ui/react-progress");
const Progress = React.forwardRef(
  function Progress2({
    size,
    tint,
    className,
    value: valueProp,
    max: maxProp,
    getValueLabel,
    ...props
  }, ref) {
    const max = maxProp ?? 1;
    const value = valueProp ?? max;
    const labelId = React.useId();
    const label = getValueLabel ? getValueLabel(value, max) : null;
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        className: classNames(Progress_module.default["progress-bar-container"], className),
        "data-tint": tint,
        ...props,
        children: [
          label && /* @__PURE__ */ jsxRuntime.jsx("div", { id: labelId, className: Progress_module.default["progress-bar-label"], children: label }),
          /* @__PURE__ */ jsxRuntime.jsx(
            reactProgress.Root,
            {
              className: Progress_module.default["progress-bar"],
              "data-size": size,
              max,
              value,
              ref,
              "aria-labelledby": label ? labelId : void 0,
              getValueLabel,
              children: /* @__PURE__ */ jsxRuntime.jsx(
                reactProgress.Indicator,
                {
                  className: Progress_module.default["progress-bar-indicator"],
                  style: {
                    transform: `translateX(-${100 - value / max * 100}%)`
                  }
                }
              )
            }
          )
        ]
      }
    );
  }
);
exports.Progress = Progress;
//# sourceMappingURL=Progress.cjs.map
