import { jsx } from "react/jsx-runtime";
import { forwardRef } from "react";
import styles from "./Nav.module.css.js";
const NavItemLink = forwardRef(function NavItemLink2({
  children,
  href,
  onClick,
  ...rest
}, ref) {
  return /* @__PURE__ */ jsx(
    "a",
    {
      href,
      onClick,
      className: styles["nav-item"],
      ...rest,
      ref,
      children
    }
  );
});
const NavItemButton = forwardRef(function NavItemButton2({
  children,
  disabled,
  onClick,
  ...rest
}, ref) {
  return /* @__PURE__ */ jsx(
    "button",
    {
      onClick,
      className: styles["nav-item"],
      disabled,
      ref,
      ...rest,
      children
    }
  );
});
const renderAsLink = (props) => "href" in props && !!props.href;
const NavItem = forwardRef(function NavItem2(props, ref) {
  const ariaControls = props["aria-controls"];
  const isUsedAsTabs = !!ariaControls;
  const a11yAttributes = isUsedAsTabs ? {
    // when used as tabs
    "aria-controls": ariaControls,
    role: "tab",
    "aria-selected": props.active
  } : {
    // when used as navigation elements
    "aria-current": props.active ? true : void 0
  };
  const propsForChild = { ...props };
  delete propsForChild["active"];
  let navItem;
  if (renderAsLink(propsForChild)) {
    const buttonRef = ref;
    navItem = /* @__PURE__ */ jsx(NavItemLink, { ...propsForChild, ...a11yAttributes, ref: buttonRef });
  } else {
    const buttonRef = ref;
    navItem = /* @__PURE__ */ jsx(NavItemButton, { ...propsForChild, ...a11yAttributes, ref: buttonRef });
  }
  return /* @__PURE__ */ jsx(
    "li",
    {
      className: styles["nav-tab"],
      "data-current": props.active ? true : void 0,
      role: "presentation",
      children: navItem
    }
  );
});
export {
  NavItem
};
//# sourceMappingURL=NavItem.js.map
