"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const React = require("react");
const Nav_module = require("./Nav.module.css.cjs");
const NavItemLink = React.forwardRef(function NavItemLink2({
  children,
  href,
  onClick,
  ...rest
}, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(
    "a",
    {
      href,
      onClick,
      className: Nav_module.default["nav-item"],
      ...rest,
      ref,
      children
    }
  );
});
const NavItemButton = React.forwardRef(function NavItemButton2({
  children,
  disabled,
  onClick,
  ...rest
}, ref) {
  return /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      onClick,
      className: Nav_module.default["nav-item"],
      disabled,
      ref,
      ...rest,
      children
    }
  );
});
const renderAsLink = (props) => "href" in props && !!props.href;
const NavItem = React.forwardRef(function NavItem2(props, ref) {
  const ariaControls = props["aria-controls"];
  const isUsedAsTabs = !!ariaControls;
  const a11yAttributes = isUsedAsTabs ? {
    // when used as tabs
    "aria-controls": ariaControls,
    role: "tab",
    "aria-selected": props.active
  } : {
    // when used as navigation elements
    "aria-current": props.active ? true : void 0
  };
  const propsForChild = { ...props };
  delete propsForChild["active"];
  let navItem;
  if (renderAsLink(propsForChild)) {
    const buttonRef = ref;
    navItem = /* @__PURE__ */ jsxRuntime.jsx(NavItemLink, { ...propsForChild, ...a11yAttributes, ref: buttonRef });
  } else {
    const buttonRef = ref;
    navItem = /* @__PURE__ */ jsxRuntime.jsx(NavItemButton, { ...propsForChild, ...a11yAttributes, ref: buttonRef });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    "li",
    {
      className: Nav_module.default["nav-tab"],
      "data-current": props.active ? true : void 0,
      role: "presentation",
      children: navItem
    }
  );
});
exports.NavItem = NavItem;
//# sourceMappingURL=NavItem.cjs.map
