import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import styles from "./Nav.module.css.js";
const NavBar = ({
  children,
  className,
  role,
  "aria-label": ariaLabel,
  ...rest
}) => {
  const classes = classNames(className, styles["nav-bar"]);
  const a11yAttributesForNav = role !== "tablist" ? (
    /**
     * If role isn't tablist, default to navigation.
     */
    { role: "navigation", "aria-label": ariaLabel }
  ) : (
    /**
     * If role is tablist, give nav presentation role to remove
     * any semantic meaning.
     */
    { role: "presentation" }
  );
  const a11yAttributesForUl = role === "tablist" ? { role: "tablist", "aria-label": ariaLabel } : {};
  return /* @__PURE__ */ jsx("nav", { ...a11yAttributesForNav, ...rest, className: classes, children: /* @__PURE__ */ jsx("ul", { ...a11yAttributesForUl, className: styles["nav-bar-items"], children }) });
};
export {
  NavBar
};
//# sourceMappingURL=NavBar.js.map
